/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorEquivalenceForOverrides;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.OverridingUtil;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorEquivalenceForOverrides {
    public static final DescriptorEquivalenceForOverrides INSTANCE;

    public final boolean areEquivalent(@Nullable DeclarationDescriptor a2, @Nullable DeclarationDescriptor b2) {
        return a2 instanceof ClassDescriptor && b2 instanceof ClassDescriptor ? this.areClassesEquivalent((ClassDescriptor)a2, (ClassDescriptor)b2) : (a2 instanceof TypeParameterDescriptor && b2 instanceof TypeParameterDescriptor ? DescriptorEquivalenceForOverrides.areTypeParametersEquivalent$default(this, (TypeParameterDescriptor)a2, (TypeParameterDescriptor)b2, null, 4, null) : (a2 instanceof CallableDescriptor && b2 instanceof CallableDescriptor ? DescriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent$default(this, (CallableDescriptor)a2, (CallableDescriptor)b2, false, 4, null) : (a2 instanceof PackageFragmentDescriptor && b2 instanceof PackageFragmentDescriptor ? Intrinsics.areEqual(((PackageFragmentDescriptor)a2).getFqName(), ((PackageFragmentDescriptor)b2).getFqName()) : Intrinsics.areEqual(a2, b2))));
    }

    private final boolean areClassesEquivalent(ClassDescriptor a2, ClassDescriptor b2) {
        return Intrinsics.areEqual(a2.getTypeConstructor(), b2.getTypeConstructor());
    }

    private final boolean areTypeParametersEquivalent(TypeParameterDescriptor a2, TypeParameterDescriptor b2, Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean> equivalentCallables) {
        if (Intrinsics.areEqual(a2, b2)) {
            return true;
        }
        if (Intrinsics.areEqual(a2.getContainingDeclaration(), b2.getContainingDeclaration())) {
            return false;
        }
        if (!this.ownersEquivalent(a2, b2, equivalentCallables)) {
            return false;
        }
        return a2.getIndex() == b2.getIndex();
    }

    static /* bridge */ /* synthetic */ boolean areTypeParametersEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, TypeParameterDescriptor typeParameterDescriptor, TypeParameterDescriptor typeParameterDescriptor2, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            function2 = areTypeParametersEquivalent.1.INSTANCE;
        }
        return descriptorEquivalenceForOverrides.areTypeParametersEquivalent(typeParameterDescriptor, typeParameterDescriptor2, function2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean areCallableDescriptorsEquivalent(@NotNull CallableDescriptor a2, @NotNull CallableDescriptor b2, boolean ignoreReturnType) {
        Intrinsics.checkParameterIsNotNull(a2, "a");
        Intrinsics.checkParameterIsNotNull(b2, "b");
        if (Intrinsics.areEqual(a2, b2)) {
            return true;
        }
        if (Intrinsics.areEqual(a2.getName(), b2.getName()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual(a2.getContainingDeclaration(), b2.getContainingDeclaration())) {
            return false;
        }
        if (DescriptorUtils.isLocal(a2)) return false;
        if (DescriptorUtils.isLocal(b2)) {
            return false;
        }
        if (!this.ownersEquivalent(a2, b2, areCallableDescriptorsEquivalent.1.INSTANCE)) {
            return false;
        }
        OverridingUtil overridingUtil2 = OverridingUtil.createWithEqualityAxioms(new KotlinTypeChecker.TypeConstructorEquality(a2, b2){
            final /* synthetic */ CallableDescriptor $a;
            final /* synthetic */ CallableDescriptor $b;

            public final boolean invoke(@NotNull TypeConstructor c1, @NotNull TypeConstructor c2) {
                Intrinsics.checkParameterIsNotNull(c1, "c1");
                Intrinsics.checkParameterIsNotNull(c2, "c2");
                if (Intrinsics.areEqual(c1, c2)) {
                    return true;
                }
                ClassifierDescriptor d1 = c1.getDeclarationDescriptor();
                ClassifierDescriptor d2 = c2.getDeclarationDescriptor();
                if (!(d1 instanceof TypeParameterDescriptor) || !(d2 instanceof TypeParameterDescriptor)) {
                    return false;
                }
                return DescriptorEquivalenceForOverrides.access$areTypeParametersEquivalent(DescriptorEquivalenceForOverrides.INSTANCE, (TypeParameterDescriptor)d1, (TypeParameterDescriptor)d2, new Function2<DeclarationDescriptor, DeclarationDescriptor, Boolean>(this){
                    final /* synthetic */ areCallableDescriptorsEquivalent.overridingUtil.1 this$0;

                    public final boolean invoke(@Nullable DeclarationDescriptor x, @Nullable DeclarationDescriptor y) {
                        return Intrinsics.areEqual(x, this.this$0.$a) && Intrinsics.areEqual(y, this.this$0.$b);
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                });
            }
            {
                this.$a = callableDescriptor;
                this.$b = callableDescriptor2;
            }
        });
        OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = overridingUtil2.isOverridableBy(a2, b2, null, !ignoreReturnType);
        Intrinsics.checkExpressionValueIsNotNull(overrideCompatibilityInfo, "overridingUtil.isOverrid\u2026 null, !ignoreReturnType)");
        if (overrideCompatibilityInfo.getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) return false;
        OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo2 = overridingUtil2.isOverridableBy(b2, a2, null, !ignoreReturnType);
        Intrinsics.checkExpressionValueIsNotNull(overrideCompatibilityInfo2, "overridingUtil.isOverrid\u2026 null, !ignoreReturnType)");
        if (overrideCompatibilityInfo2.getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) return false;
        return true;
    }

    public static /* bridge */ /* synthetic */ boolean areCallableDescriptorsEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return descriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent(callableDescriptor, callableDescriptor2, bl);
    }

    private final boolean ownersEquivalent(DeclarationDescriptor a2, DeclarationDescriptor b2, Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean> equivalentCallables) {
        DeclarationDescriptor aOwner = a2.getContainingDeclaration();
        DeclarationDescriptor bOwner = b2.getContainingDeclaration();
        return aOwner instanceof CallableMemberDescriptor || bOwner instanceof CallableMemberDescriptor ? equivalentCallables.invoke(aOwner, bOwner).booleanValue() : this.areEquivalent(aOwner, bOwner);
    }

    private DescriptorEquivalenceForOverrides() {
    }

    static {
        DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides;
        INSTANCE = descriptorEquivalenceForOverrides = new DescriptorEquivalenceForOverrides();
    }

    public static final /* synthetic */ boolean access$areTypeParametersEquivalent(DescriptorEquivalenceForOverrides $this, @NotNull TypeParameterDescriptor a2, @NotNull TypeParameterDescriptor b2, @NotNull Function2 equivalentCallables) {
        return $this.areTypeParametersEquivalent(a2, b2, equivalentCallables);
    }
}

