/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.Collection;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import org.jetbrains.annotations.NotNull;

public final class StrictEqualityTypeChecker {
    public static final StrictEqualityTypeChecker INSTANCE;

    public final boolean strictEqualTypes(@NotNull UnwrappedType a2, @NotNull UnwrappedType b2) {
        Intrinsics.checkParameterIsNotNull(a2, "a");
        Intrinsics.checkParameterIsNotNull(b2, "b");
        if (a2 == b2) {
            return true;
        }
        if (a2 instanceof SimpleType && b2 instanceof SimpleType) {
            return this.strictEqualTypes((SimpleType)a2, (SimpleType)b2);
        }
        if (a2 instanceof FlexibleType && b2 instanceof FlexibleType) {
            return this.strictEqualTypes(((FlexibleType)a2).getLowerBound(), ((FlexibleType)b2).getLowerBound()) && this.strictEqualTypes(((FlexibleType)a2).getUpperBound(), ((FlexibleType)b2).getUpperBound());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean strictEqualTypes(@NotNull SimpleType a2, @NotNull SimpleType b2) {
        Intrinsics.checkParameterIsNotNull(a2, "a");
        Intrinsics.checkParameterIsNotNull(b2, "b");
        if (a2.isMarkedNullable() != b2.isMarkedNullable() || SpecialTypesKt.isDefinitelyNotNullType(a2) != SpecialTypesKt.isDefinitelyNotNullType(b2) || Intrinsics.areEqual(a2.getConstructor(), b2.getConstructor()) ^ true || a2.getArguments().size() != b2.getArguments().size()) {
            return false;
        }
        if (a2.getArguments() == b2.getArguments()) {
            return true;
        }
        int n = 0;
        int n2 = ((Collection)a2.getArguments()).size();
        while (n < n2) {
            void i2;
            TypeProjection aArg = a2.getArguments().get((int)i2);
            TypeProjection bArg = b2.getArguments().get((int)i2);
            if (aArg.isStarProjection() != bArg.isStarProjection()) {
                return false;
            }
            if (!aArg.isStarProjection()) {
                if (aArg.getProjectionKind() != bArg.getProjectionKind()) {
                    return false;
                }
                if (!this.strictEqualTypes(aArg.getType().unwrap(), bArg.getType().unwrap())) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    private StrictEqualityTypeChecker() {
    }

    static {
        StrictEqualityTypeChecker strictEqualityTypeChecker;
        INSTANCE = strictEqualityTypeChecker = new StrictEqualityTypeChecker();
    }
}

