/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.experimental;

import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.experimental.Continuation;
import kotlin.coroutines.experimental.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.experimental.CancellableContinuation;
import kotlinx.coroutines.experimental.CoroutineDispatcher;
import kotlinx.coroutines.experimental.DefaultExecutor;
import kotlinx.coroutines.experimental.Delay;
import kotlinx.coroutines.experimental.DisposableFutureHandle;
import kotlinx.coroutines.experimental.DisposableHandle;
import kotlinx.coroutines.experimental.JobKt;
import kotlinx.coroutines.experimental.ResumeUndispatchedRunnable;
import kotlinx.coroutines.experimental.TimeSourceKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0016J&\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lkotlinx/coroutines/experimental/ExecutorCoroutineDispatcherBase;", "Lkotlinx/coroutines/experimental/CoroutineDispatcher;", "Lkotlinx/coroutines/experimental/Delay;", "()V", "executor", "Ljava/util/concurrent/Executor;", "getExecutor$kotlinx_coroutines_core", "()Ljava/util/concurrent/Executor;", "dispatch", "", "context", "Lkotlin/coroutines/experimental/CoroutineContext;", "block", "Ljava/lang/Runnable;", "equals", "", "other", "", "hashCode", "", "invokeOnTimeout", "Lkotlinx/coroutines/experimental/DisposableHandle;", "time", "", "unit", "Ljava/util/concurrent/TimeUnit;", "scheduleResumeAfterDelay", "continuation", "Lkotlinx/coroutines/experimental/CancellableContinuation;", "toString", "", "kotlinx-coroutines-core"})
public abstract class ExecutorCoroutineDispatcherBase
extends CoroutineDispatcher
implements Delay {
    @NotNull
    public abstract Executor getExecutor$kotlinx_coroutines_core();

    @Override
    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(block, "block");
        try {
            this.getExecutor$kotlinx_coroutines_core().execute(TimeSourceKt.getTimeSource().trackTask(block));
        }
        catch (RejectedExecutionException e) {
            TimeSourceKt.getTimeSource().unTrackTask();
            DefaultExecutor.INSTANCE.execute(block);
        }
    }

    @Override
    public void scheduleResumeAfterDelay(long time2, @NotNull TimeUnit unit, @NotNull CancellableContinuation<? super Unit> continuation2) {
        ScheduledFuture<?> scheduledFuture;
        Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
        Intrinsics.checkParameterIsNotNull(continuation2, "continuation");
        try {
            Executor executor2 = this.getExecutor$kotlinx_coroutines_core();
            if (!(executor2 instanceof ScheduledExecutorService)) {
                executor2 = null;
            }
            ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)executor2;
            scheduledFuture = scheduledExecutorService != null ? scheduledExecutorService.schedule(new ResumeUndispatchedRunnable(this, continuation2), time2, unit) : null;
        }
        catch (RejectedExecutionException e) {
            scheduledFuture = null;
        }
        ScheduledFuture<?> timeout = scheduledFuture;
        if (timeout != null) {
            JobKt.cancelFutureOnCompletion(continuation2, (Future)timeout);
        } else {
            DefaultExecutor.INSTANCE.scheduleResumeAfterDelay(time2, unit, continuation2);
        }
    }

    @Override
    @NotNull
    public DisposableHandle invokeOnTimeout(long time2, @NotNull TimeUnit unit, @NotNull Runnable block) {
        ScheduledFuture<?> scheduledFuture;
        Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
        Intrinsics.checkParameterIsNotNull(block, "block");
        try {
            Executor executor2 = this.getExecutor$kotlinx_coroutines_core();
            if (!(executor2 instanceof ScheduledExecutorService)) {
                executor2 = null;
            }
            ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)executor2;
            scheduledFuture = scheduledExecutorService != null ? scheduledExecutorService.schedule(block, time2, unit) : null;
        }
        catch (RejectedExecutionException e) {
            scheduledFuture = null;
        }
        ScheduledFuture<?> timeout = scheduledFuture;
        if (timeout != null) {
            return new DisposableFutureHandle((Future)timeout);
        }
        return DefaultExecutor.INSTANCE.invokeOnTimeout(time2, unit, block);
    }

    @Override
    @NotNull
    public String toString() {
        return this.getExecutor$kotlinx_coroutines_core().toString();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ExecutorCoroutineDispatcherBase && ((ExecutorCoroutineDispatcherBase)other).getExecutor$kotlinx_coroutines_core() == this.getExecutor$kotlinx_coroutines_core();
    }

    public int hashCode() {
        return System.identityHashCode(this.getExecutor$kotlinx_coroutines_core());
    }

    @Override
    @Nullable
    public Object delay(long time2, @NotNull TimeUnit unit, @NotNull Continuation<? super Unit> continuation2) {
        return Delay.DefaultImpls.delay(this, time2, unit, continuation2);
    }
}

