/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.html.dom;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlinx.html.Entities;
import kotlinx.html.Tag;
import kotlinx.html.TagConsumer;
import kotlinx.html.Unsafe;
import kotlinx.html.dom.HTMLDOMBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.xml.sax.InputSource;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0017\u001a\u00020\u0002H\u0016J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0016J!\u0010%\u001a\u00020\u00192\u0017\u0010&\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00190'\u00a2\u0006\u0002\b(H\u0016J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J,\u0010*\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u00190'H\u0016J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\f\u0010.\u001a\u00020\u0019*\u00020\u0002H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR#\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0015j\b\u0012\u0004\u0012\u00020\u0002`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lkotlinx/html/dom/HTMLDOMBuilder;", "Lkotlinx/html/TagConsumer;", "Lorg/w3c/dom/Element;", "document", "Lorg/w3c/dom/Document;", "(Lorg/w3c/dom/Document;)V", "UnsafeImpl", "Lkotlinx/html/Unsafe;", "getUnsafeImpl", "()Lkotlinx/html/Unsafe;", "getDocument", "()Lorg/w3c/dom/Document;", "documentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "kotlin.jvm.PlatformType", "getDocumentBuilder", "()Ljavax/xml/parsers/DocumentBuilder;", "documentBuilder$delegate", "Lkotlin/Lazy;", "lastLeaved", "path", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "finalize", "onTagAttributeChange", "", "tag", "Lkotlinx/html/Tag;", "attribute", "", "value", "onTagContent", "content", "", "onTagContentEntity", "entity", "Lkotlinx/html/Entities;", "onTagContentUnsafe", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "onTagEnd", "onTagEvent", "event", "Lorg/w3c/dom/events/Event;", "onTagStart", "setIdAttributeName", "kotlinx-html-jvm"})
public final class HTMLDOMBuilder
implements TagConsumer<Element> {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final ArrayList<Element> path;
    private Element lastLeaved;
    private final Lazy documentBuilder$delegate;
    @NotNull
    private final Unsafe UnsafeImpl;
    @NotNull
    private final Document document;

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(HTMLDOMBuilder.class), "documentBuilder", "getDocumentBuilder()Ljavax/xml/parsers/DocumentBuilder;"))};
    }

    private final DocumentBuilder getDocumentBuilder() {
        Lazy lazy = this.documentBuilder$delegate;
        HTMLDOMBuilder hTMLDOMBuilder = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (DocumentBuilder)lazy.getValue();
    }

    @Override
    public void onTagStart(@NotNull Tag tag) {
        Element element;
        Intrinsics.checkParameterIsNotNull(tag, "tag");
        if (tag.getNamespace() != null) {
            String string = tag.getNamespace();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            element = this.document.createElementNS(string, tag.getTagName());
        } else {
            element = this.document.createElement(tag.getTagName());
        }
        Element element2 = element;
        Iterable $receiver$iv = tag.getAttributesEntries();
        for (Object element$iv : $receiver$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            element2.setAttribute((String)it.getKey(), (String)it.getValue());
        }
        Collection collection = this.path;
        if (!collection.isEmpty()) {
            ((Element)CollectionsKt.last((List)this.path)).appendChild(element2);
        }
        this.path.add(element2);
    }

    @Override
    public void onTagAttributeChange(@NotNull Tag tag, @NotNull String attribute, @Nullable String value) {
        Intrinsics.checkParameterIsNotNull(tag, "tag");
        Intrinsics.checkParameterIsNotNull(attribute, "attribute");
        if (this.path.isEmpty()) {
            throw (Throwable)new IllegalStateException("No current tag");
        }
        Object t = CollectionsKt.last((List)this.path);
        Element node = (Element)t;
        if (value == null) {
            node.removeAttribute(attribute);
        } else {
            node.setAttribute(attribute, value);
        }
    }

    @Override
    public void onTagEvent(@NotNull Tag tag, @NotNull String event, @NotNull Function1<? super Event, Unit> value) {
        Intrinsics.checkParameterIsNotNull(tag, "tag");
        Intrinsics.checkParameterIsNotNull(event, "event");
        Intrinsics.checkParameterIsNotNull(value, "value");
        throw (Throwable)new UnsupportedOperationException("You can't assign lambda event handler on JVM");
    }

    @Override
    public void onTagEnd(@NotNull Tag tag) {
        block6: {
            block5: {
                String string;
                Intrinsics.checkParameterIsNotNull(tag, "tag");
                if (this.path.isEmpty()) break block5;
                String string2 = string = ((Element)CollectionsKt.last((List)this.path)).getTagName();
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).toLowerCase()");
                string = tag.getTagName();
                String string4 = string3;
                String string5 = string;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull(string6, "(this as java.lang.String).toLowerCase()");
                String string7 = string6;
                if (!(Intrinsics.areEqual(string4, string7) ^ true)) break block6;
            }
            throw (Throwable)new IllegalStateException("We haven't entered tag " + tag.getTagName() + " but trying to leave");
        }
        Element element = this.path.remove(CollectionsKt.getLastIndex((List)this.path));
        this.setIdAttributeName(element);
        this.lastLeaved = element;
    }

    @Override
    public void onTagContent(@NotNull CharSequence content2) {
        Intrinsics.checkParameterIsNotNull(content2, "content");
        if (this.path.isEmpty()) {
            throw (Throwable)new IllegalStateException("No current DOM node");
        }
        ((Element)CollectionsKt.last((List)this.path)).appendChild(this.document.createTextNode(((Object)content2).toString()));
    }

    @Override
    public void onTagContentEntity(@NotNull Entities entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, "entity");
        if (this.path.isEmpty()) {
            throw (Throwable)new IllegalStateException("No current DOM node");
        }
        ((Element)CollectionsKt.last((List)this.path)).appendChild(this.document.createEntityReference(entity.name()));
    }

    @Override
    @NotNull
    public Element finalize() {
        Element element = this.lastLeaved;
        if (element == null) {
            throw (Throwable)new IllegalStateException("No tags were emitted");
        }
        return element;
    }

    @Override
    public void onTagContentUnsafe(@NotNull Function1<? super Unsafe, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, "block");
        block.invoke(this.UnsafeImpl);
    }

    @NotNull
    public final Unsafe getUnsafeImpl() {
        return this.UnsafeImpl;
    }

    private final void setIdAttributeName(@NotNull Element $receiver) {
        if ($receiver.hasAttribute("id")) {
            $receiver.setIdAttribute("id", true);
        }
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    public HTMLDOMBuilder(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull(document, "document");
        this.document = document;
        HTMLDOMBuilder hTMLDOMBuilder = this;
        ArrayList arrayList = new ArrayList();
        hTMLDOMBuilder.path = arrayList;
        this.documentBuilder$delegate = LazyKt.lazy(documentBuilder.2.INSTANCE);
        this.UnsafeImpl = new Unsafe(this){
            final /* synthetic */ HTMLDOMBuilder this$0;

            public void unaryPlus(@NotNull String $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                Element element = HTMLDOMBuilder.access$getDocumentBuilder$p(this.this$0).parse(new InputSource(new StringReader($receiver))).getDocumentElement();
                Node importNode = this.this$0.getDocument().importNode(element, true);
                ((Element)CollectionsKt.last(HTMLDOMBuilder.access$getPath$p(this.this$0))).appendChild(importNode);
            }
            {
                this.this$0 = $outer;
            }

            public void unaryPlus(@NotNull Entities $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), "$receiver");
                Unsafe.DefaultImpls.unaryPlus(this, $receiver);
            }

            public void raw(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull(s, "s");
                Unsafe.DefaultImpls.raw((Unsafe)this, s);
            }

            public void raw(@NotNull Entities entity) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)entity), "entity");
                Unsafe.DefaultImpls.raw((Unsafe)this, entity);
            }

            public void raw(@NotNull Number n) {
                Intrinsics.checkParameterIsNotNull(n, "n");
                Unsafe.DefaultImpls.raw((Unsafe)this, n);
            }
        };
    }

    @Override
    public void onTagError(@NotNull Tag tag, @NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull(tag, "tag");
        Intrinsics.checkParameterIsNotNull(exception, "exception");
        TagConsumer.DefaultImpls.onTagError(this, tag, exception);
    }

    public static final /* synthetic */ DocumentBuilder access$getDocumentBuilder$p(HTMLDOMBuilder $this) {
        return $this.getDocumentBuilder();
    }

    @NotNull
    public static final /* synthetic */ ArrayList access$getPath$p(HTMLDOMBuilder $this) {
        return $this.path;
    }
}

