/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.transform.impl;

import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.ObjectSwitchCallback;
import net.sf.cglib.core.ProcessSwitchCallback;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.transform.ClassEmitterTransformer;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class FieldProviderTransformer
extends ClassEmitterTransformer {
    private static final String FIELD_NAMES = "CGLIB$FIELD_NAMES";
    private static final String FIELD_TYPES = "CGLIB$FIELD_TYPES";
    private static final Type FIELD_PROVIDER = TypeUtils.parseType("net.sf.cglib.transform.impl.FieldProvider");
    private static final Type ILLEGAL_ARGUMENT_EXCEPTION = TypeUtils.parseType("IllegalArgumentException");
    private static final Signature PROVIDER_GET = TypeUtils.parseSignature("Object getField(String)");
    private static final Signature PROVIDER_SET = TypeUtils.parseSignature("void setField(String, Object)");
    private static final Signature PROVIDER_SET_BY_INDEX = TypeUtils.parseSignature("void setField(int, Object)");
    private static final Signature PROVIDER_GET_BY_INDEX = TypeUtils.parseSignature("Object getField(int)");
    private static final Signature PROVIDER_GET_TYPES = TypeUtils.parseSignature("Class[] getFieldTypes()");
    private static final Signature PROVIDER_GET_NAMES = TypeUtils.parseSignature("String[] getFieldNames()");
    private int access;
    private Map fields;

    public void begin_class(int version, int access, String className2, Type superType, Type[] interfaces, String sourceFile) {
        if (!TypeUtils.isAbstract(access)) {
            interfaces = TypeUtils.add(interfaces, FIELD_PROVIDER);
        }
        this.access = access;
        this.fields = new HashMap();
        super.begin_class(version, access, className2, superType, interfaces, sourceFile);
    }

    public void declare_field(int access, String name, Type type2, Object value) {
        super.declare_field(access, name, type2, value);
        if (!TypeUtils.isStatic(access)) {
            this.fields.put(name, type2);
        }
    }

    public void end_class() {
        if (!TypeUtils.isInterface(this.access)) {
            try {
                this.generate();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CodeGenerationException(e);
            }
        }
        super.end_class();
    }

    private void generate() throws Exception {
        String[] names2 = this.fields.keySet().toArray(new String[this.fields.size()]);
        int[] indexes = new int[names2.length];
        for (int i2 = 0; i2 < indexes.length; ++i2) {
            indexes[i2] = i2;
        }
        super.declare_field(26, FIELD_NAMES, Constants.TYPE_STRING_ARRAY, null);
        super.declare_field(26, FIELD_TYPES, Constants.TYPE_CLASS_ARRAY, null);
        this.initFieldProvider(names2);
        this.getNames();
        this.getTypes();
        this.getField(names2);
        this.setField(names2);
        this.setByIndex(names2, indexes);
        this.getByIndex(names2, indexes);
    }

    private void initFieldProvider(String[] names2) {
        CodeEmitter e = this.getStaticHook();
        EmitUtils.push_object(e, names2);
        e.putstatic(this.getClassType(), FIELD_NAMES, Constants.TYPE_STRING_ARRAY);
        e.push(names2.length);
        e.newarray(Constants.TYPE_CLASS);
        e.dup();
        for (int i2 = 0; i2 < names2.length; ++i2) {
            e.dup();
            e.push(i2);
            Type type2 = (Type)this.fields.get(names2[i2]);
            EmitUtils.load_class(e, type2);
            e.aastore();
        }
        e.putstatic(this.getClassType(), FIELD_TYPES, Constants.TYPE_CLASS_ARRAY);
    }

    private void getNames() {
        CodeEmitter e = super.begin_method(1, PROVIDER_GET_NAMES, null);
        e.getstatic(this.getClassType(), FIELD_NAMES, Constants.TYPE_STRING_ARRAY);
        e.return_value();
        e.end_method();
    }

    private void getTypes() {
        CodeEmitter e = super.begin_method(1, PROVIDER_GET_TYPES, null);
        e.getstatic(this.getClassType(), FIELD_TYPES, Constants.TYPE_CLASS_ARRAY);
        e.return_value();
        e.end_method();
    }

    private void setByIndex(final String[] names2, int[] indexes) throws Exception {
        final CodeEmitter e = super.begin_method(1, PROVIDER_SET_BY_INDEX, null);
        e.load_this();
        e.load_arg(1);
        e.load_arg(0);
        e.process_switch(indexes, new ProcessSwitchCallback(){

            public void processCase(int key, Label end) throws Exception {
                Type type2 = (Type)FieldProviderTransformer.this.fields.get(names2[key]);
                e.unbox(type2);
                e.putfield(names2[key]);
                e.return_value();
            }

            public void processDefault() throws Exception {
                e.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Unknown field index");
            }
        });
        e.end_method();
    }

    private void getByIndex(final String[] names2, int[] indexes) throws Exception {
        final CodeEmitter e = super.begin_method(1, PROVIDER_GET_BY_INDEX, null);
        e.load_this();
        e.load_arg(0);
        e.process_switch(indexes, new ProcessSwitchCallback(){

            public void processCase(int key, Label end) throws Exception {
                Type type2 = (Type)FieldProviderTransformer.this.fields.get(names2[key]);
                e.getfield(names2[key]);
                e.box(type2);
                e.return_value();
            }

            public void processDefault() throws Exception {
                e.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Unknown field index");
            }
        });
        e.end_method();
    }

    private void getField(String[] names2) throws Exception {
        final CodeEmitter e = this.begin_method(1, PROVIDER_GET, null);
        e.load_this();
        e.load_arg(0);
        EmitUtils.string_switch(e, names2, 1, new ObjectSwitchCallback(){

            public void processCase(Object key, Label end) {
                Type type2 = (Type)FieldProviderTransformer.this.fields.get(key);
                e.getfield((String)key);
                e.box(type2);
                e.return_value();
            }

            public void processDefault() {
                e.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Unknown field name");
            }
        });
        e.end_method();
    }

    private void setField(String[] names2) throws Exception {
        final CodeEmitter e = this.begin_method(1, PROVIDER_SET, null);
        e.load_this();
        e.load_arg(1);
        e.load_arg(0);
        EmitUtils.string_switch(e, names2, 1, new ObjectSwitchCallback(){

            public void processCase(Object key, Label end) {
                Type type2 = (Type)FieldProviderTransformer.this.fields.get(key);
                e.unbox(type2);
                e.putfield((String)key);
                e.return_value();
            }

            public void processDefault() {
                e.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Unknown field name");
            }
        });
        e.end_method();
    }
}

