/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.Spliterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import one.util.streamex.StreamExInternals;

class UnorderedCancellableSpliterator<T, A>
extends StreamExInternals.CloneableSpliterator<A, UnorderedCancellableSpliterator<T, A>> {
    private volatile Spliterator<T> source;
    private final BiConsumer<A, ? super T> accumulator;
    private final Predicate<A> cancelPredicate;
    private final Supplier<A> supplier;
    private final ConcurrentLinkedQueue<A> partialResults = new ConcurrentLinkedQueue();
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final AtomicInteger nPeers = new AtomicInteger(1);
    private final BinaryOperator<A> combiner;
    private boolean flag;

    UnorderedCancellableSpliterator(Spliterator<T> source2, Supplier<A> supplier, BiConsumer<A, ? super T> accumulator, BinaryOperator<A> combiner, Predicate<A> cancelPredicate) {
        this.source = source2;
        this.supplier = supplier;
        this.accumulator = accumulator;
        this.combiner = combiner;
        this.cancelPredicate = cancelPredicate;
    }

    private boolean checkCancel(A acc) {
        if (this.cancelPredicate.test(acc) && this.cancelled.compareAndSet(false, true)) {
            this.flag = true;
            return true;
        }
        if (this.cancelled.get()) {
            this.flag = false;
            return true;
        }
        return false;
    }

    private boolean handleCancel(Consumer<? super A> action2, A acc) {
        this.source = null;
        if (this.flag) {
            action2.accept(acc);
            return true;
        }
        return false;
    }

    @Override
    public boolean tryAdvance(Consumer<? super A> action2) {
        A acc2;
        Spliterator<Object> source2 = this.source;
        if (source2 == null || this.cancelled.get()) {
            this.source = null;
            return false;
        }
        A acc = this.supplier.get();
        if (this.checkCancel(acc)) {
            return this.handleCancel(action2, acc);
        }
        try {
            source2.forEachRemaining((? super T t) -> {
                this.accumulator.accept(acc, t);
                if (this.checkCancel(acc)) {
                    throw new StreamExInternals.CancelException();
                }
            });
        }
        catch (StreamExInternals.CancelException ex) {
            return this.handleCancel(action2, acc);
        }
        Object result2 = acc;
        while ((acc2 = this.partialResults.poll()) != null) {
            if (!this.checkCancel(result2 = this.combiner.apply(result2, acc2))) continue;
            return this.handleCancel(action2, result2);
        }
        this.partialResults.offer(result2);
        this.source = null;
        if (this.nPeers.decrementAndGet() == 0) {
            result2 = this.partialResults.poll();
            while ((acc2 = this.partialResults.poll()) != null && !this.cancelPredicate.test(result2 = this.combiner.apply(result2, acc2))) {
            }
            this.source = null;
            action2.accept(result2);
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(Consumer<? super A> action2) {
        this.tryAdvance(action2);
    }

    @Override
    public Spliterator<A> trySplit() {
        if (this.source == null || this.cancelled.get()) {
            this.source = null;
            return null;
        }
        Spliterator<T> prefix = this.source.trySplit();
        if (prefix == null) {
            return null;
        }
        UnorderedCancellableSpliterator result2 = (UnorderedCancellableSpliterator)this.doClone();
        result2.source = prefix;
        this.nPeers.incrementAndGet();
        return result2;
    }

    @Override
    public long estimateSize() {
        return this.source == null ? 0L : this.source.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.source == null ? 64 : 0;
    }
}

