/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.impl.ListCompositeNode;
import org.intellij.markdown.ast.impl.ListItemCompositeNode;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.InlineHolderGeneratingProvider;
import org.intellij.markdown.html.SimpleTagProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/intellij/markdown/html/ListItemGeneratingProvider;", "Lorg/intellij/markdown/html/SimpleTagProvider;", "()V", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "SilentParagraphGeneratingProvider", "intellij-markdown"})
public final class ListItemGeneratingProvider
extends SimpleTagProvider {
    @Override
    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text2, @NotNull ASTNode node) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        Intrinsics.checkParameterIsNotNull(text2, "text");
        Intrinsics.checkParameterIsNotNull(node, "node");
        boolean bl = node instanceof ListItemCompositeNode;
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        this.openTag(visitor2, text2, node);
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.intellij.markdown.ast.impl.ListItemCompositeNode");
        }
        ListCompositeNode listCompositeNode = ((ListItemCompositeNode)aSTNode).getParent();
        if (listCompositeNode == null) {
            Intrinsics.throwNpe();
        }
        boolean isLoose = listCompositeNode.getLoose();
        for (ASTNode child : node.getChildren()) {
            if (Intrinsics.areEqual(child.getType(), MarkdownElementTypes.PARAGRAPH) && !isLoose) {
                SilentParagraphGeneratingProvider.INSTANCE.processNode(visitor2, text2, child);
                continue;
            }
            ASTNodeKt.accept(child, visitor2);
        }
        this.closeTag(visitor2, text2, node);
    }

    public ListItemGeneratingProvider() {
        super("li");
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/intellij/markdown/html/ListItemGeneratingProvider$SilentParagraphGeneratingProvider;", "Lorg/intellij/markdown/html/InlineHolderGeneratingProvider;", "()V", "closeTag", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "openTag", "intellij-markdown"})
    public static final class SilentParagraphGeneratingProvider
    extends InlineHolderGeneratingProvider {
        public static final SilentParagraphGeneratingProvider INSTANCE;

        @Override
        public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text2, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
            Intrinsics.checkParameterIsNotNull(text2, "text");
            Intrinsics.checkParameterIsNotNull(node, "node");
        }

        @Override
        public void closeTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text2, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
            Intrinsics.checkParameterIsNotNull(text2, "text");
            Intrinsics.checkParameterIsNotNull(node, "node");
        }

        private SilentParagraphGeneratingProvider() {
            INSTANCE = this;
        }

        static {
            new SilentParagraphGeneratingProvider();
        }
    }
}

