/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CharIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.ast.visitors.RecursiveVisitor;
import org.intellij.markdown.html.entities.EntityConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\b\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c2\u0003J\u001f\u0010\b\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u0004R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/intellij/markdown/parser/LinkMap;", "", "map", "", "", "Lorg/intellij/markdown/parser/LinkMap$LinkInfo;", "(Ljava/util/Map;)V", "component1", "copy", "getLinkInfo", "label", "Builder", "LinkInfo", "intellij-markdown"})
public final class LinkMap {
    private final Map<CharSequence, LinkInfo> map;
    @NotNull
    private static final Regex SPACES_REGEX;
    public static final Builder Builder;

    @Nullable
    public final LinkInfo getLinkInfo(@NotNull CharSequence label2) {
        Intrinsics.checkParameterIsNotNull(label2, "label");
        return this.map.get(LinkMap.Builder.normalizeLabel(label2));
    }

    private LinkMap(Map<CharSequence, LinkInfo> map2) {
        this.map = map2;
    }

    static {
        Builder = new Builder(null);
        SPACES_REGEX = new Regex("\\s+");
    }

    public /* synthetic */ LinkMap(@NotNull Map map2, DefaultConstructorMarker $constructor_marker) {
        this(map2);
    }

    private final Map<CharSequence, LinkInfo> component1() {
        return this.map;
    }

    @NotNull
    public final LinkMap copy(@NotNull Map<CharSequence, LinkInfo> map2) {
        Intrinsics.checkParameterIsNotNull(map2, "map");
        return new LinkMap(map2);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ LinkMap copy$default(LinkMap linkMap, Map map2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
        }
        if ((n & 1) != 0) {
            map2 = linkMap.map;
        }
        return linkMap.copy(map2);
    }

    public String toString() {
        return "LinkMap(map=" + this.map + ")";
    }

    public int hashCode() {
        Map<CharSequence, LinkInfo> map2 = this.map;
        return map2 != null ? ((Object)map2).hashCode() : 0;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LinkMap)) break block3;
                LinkMap linkMap = (LinkMap)object;
                if (!Intrinsics.areEqual(this.map, linkMap.map)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\r\b\u0086\b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/intellij/markdown/parser/LinkMap$LinkInfo;", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "destination", "", "title", "(Lorg/intellij/markdown/ast/ASTNode;Ljava/lang/CharSequence;Ljava/lang/CharSequence;)V", "getDestination", "()Ljava/lang/CharSequence;", "getNode", "()Lorg/intellij/markdown/ast/ASTNode;", "getTitle", "component1", "component2", "component3", "copy", "Companion", "intellij-markdown"})
    public static final class LinkInfo {
        @NotNull
        private final ASTNode node;
        @NotNull
        private final CharSequence destination;
        @Nullable
        private final CharSequence title;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final ASTNode getNode() {
            return this.node;
        }

        @NotNull
        public final CharSequence getDestination() {
            return this.destination;
        }

        @Nullable
        public final CharSequence getTitle() {
            return this.title;
        }

        private LinkInfo(ASTNode node, CharSequence destination, CharSequence title2) {
            this.node = node;
            this.destination = destination;
            this.title = title2;
        }

        public /* synthetic */ LinkInfo(@NotNull ASTNode node, @NotNull CharSequence destination, @Nullable CharSequence title2, DefaultConstructorMarker $constructor_marker) {
            this(node, destination, title2);
        }

        @NotNull
        public final ASTNode component1() {
            return this.node;
        }

        @NotNull
        public final CharSequence component2() {
            return this.destination;
        }

        @Nullable
        public final CharSequence component3() {
            return this.title;
        }

        @NotNull
        public final LinkInfo copy(@NotNull ASTNode node, @NotNull CharSequence destination, @Nullable CharSequence title2) {
            Intrinsics.checkParameterIsNotNull(node, "node");
            Intrinsics.checkParameterIsNotNull(destination, "destination");
            return new LinkInfo(node, destination, title2);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ LinkInfo copy$default(LinkInfo linkInfo, ASTNode aSTNode, CharSequence charSequence, CharSequence charSequence2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                aSTNode = linkInfo.node;
            }
            if ((n & 2) != 0) {
                charSequence = linkInfo.destination;
            }
            if ((n & 4) != 0) {
                charSequence2 = linkInfo.title;
            }
            return linkInfo.copy(aSTNode, charSequence, charSequence2);
        }

        public String toString() {
            return "LinkInfo(node=" + this.node + ", destination=" + this.destination + ", title=" + this.title + ")";
        }

        public int hashCode() {
            ASTNode aSTNode = this.node;
            CharSequence charSequence = this.destination;
            CharSequence charSequence2 = this.title;
            return ((aSTNode != null ? aSTNode.hashCode() : 0) * 31 + (charSequence != null ? charSequence.hashCode() : 0)) * 31 + (charSequence2 != null ? charSequence2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LinkInfo)) break block3;
                    LinkInfo linkInfo = (LinkInfo)object;
                    if (!Intrinsics.areEqual(this.node, linkInfo.node) || !Intrinsics.areEqual(this.destination, linkInfo.destination) || !Intrinsics.areEqual(this.title, linkInfo.title)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/intellij/markdown/parser/LinkMap$LinkInfo$Companion;", "", "()V", "create", "Lorg/intellij/markdown/parser/LinkMap$LinkInfo;", "node", "Lorg/intellij/markdown/ast/ASTNode;", "fileText", "", "create$intellij_markdown", "intellij-markdown"})
        public static final class Companion {
            /*
             * WARNING - void declaration
             */
            @NotNull
            public final LinkInfo create$intellij_markdown(@NotNull ASTNode node, @NotNull CharSequence fileText) {
                CharSequence charSequence;
                Object object;
                Object v0;
                Object object2;
                CharSequence destination;
                block5: {
                    void $receiver$iv;
                    Object element$iv2;
                    Builder builder;
                    block4: {
                        void $receiver$iv2;
                        Intrinsics.checkParameterIsNotNull(node, "node");
                        Intrinsics.checkParameterIsNotNull(fileText, "fileText");
                        Iterable iterable = node.getChildren();
                        builder = Builder;
                        for (Object element$iv2 : $receiver$iv2) {
                            ASTNode it = (ASTNode)element$iv2;
                            if (!Intrinsics.areEqual(it.getType(), MarkdownElementTypes.LINK_DESTINATION)) continue;
                            break block4;
                        }
                        throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    Object t = element$iv2;
                    destination = builder.normalizeDestination(ASTUtilKt.getTextInNode((ASTNode)t, fileText));
                    object2 = node.getChildren();
                    for (Object element$iv3 : $receiver$iv) {
                        ASTNode it = (ASTNode)element$iv3;
                        if (!Intrinsics.areEqual(it.getType(), MarkdownElementTypes.LINK_TITLE)) continue;
                        v0 = element$iv3;
                        break block5;
                    }
                    v0 = null;
                }
                if ((object = (ASTNode)v0) != null && (object = ASTUtilKt.getTextInNode((ASTNode)object, fileText)) != null) {
                    object2 = object;
                    CharSequence it = (CharSequence)object2;
                    charSequence = Builder.normalizeTitle(it);
                } else {
                    charSequence = null;
                }
                CharSequence title2 = charSequence;
                return new LinkInfo(node, destination, title2, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ)\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/intellij/markdown/parser/LinkMap$Builder;", "", "()V", "SPACES_REGEX", "Lkotlin/text/Regex;", "getSPACES_REGEX", "()Lkotlin/text/Regex;", "buildLinkMap", "Lorg/intellij/markdown/parser/LinkMap;", "root", "Lorg/intellij/markdown/ast/ASTNode;", "text", "", "clearBounding", "s", "boundQuotes", "", "", "(Ljava/lang/CharSequence;[Ljava/lang/String;)Ljava/lang/CharSequence;", "normalizeDestination", "normalizeLabel", "label", "normalizeTitle", "intellij-markdown"})
    public static final class Builder {
        @NotNull
        public final LinkMap buildLinkMap(@NotNull ASTNode root2, @NotNull CharSequence text2) {
            Intrinsics.checkParameterIsNotNull(root2, "root");
            Intrinsics.checkParameterIsNotNull(text2, "text");
            HashMap map2 = new HashMap();
            ASTNodeKt.accept(root2, new RecursiveVisitor(text2, map2){
                final /* synthetic */ CharSequence $text;
                final /* synthetic */ HashMap $map;

                /*
                 * WARNING - void declaration
                 */
                public void visitNode(@NotNull ASTNode node) {
                    Intrinsics.checkParameterIsNotNull(node, "node");
                    if (Intrinsics.areEqual(node.getType(), MarkdownElementTypes.LINK_DEFINITION)) {
                        T element$iv2;
                        Builder builder;
                        block4: {
                            void $receiver$iv;
                            Iterable iterable = node.getChildren();
                            builder = LinkMap.Builder;
                            for (T element$iv2 : $receiver$iv) {
                                ASTNode it = (ASTNode)element$iv2;
                                if (!Intrinsics.areEqual(it.getType(), MarkdownElementTypes.LINK_LABEL)) continue;
                                break block4;
                            }
                            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                        }
                        T t = element$iv2;
                        CharSequence linkLabel = org.intellij.markdown.parser.LinkMap$Builder.access$normalizeLabel(builder, ASTUtilKt.getTextInNode((ASTNode)t, this.$text));
                        if (!this.$map.containsKey(linkLabel)) {
                            this.$map.put(linkLabel, LinkInfo.Companion.create$intellij_markdown(node, this.$text));
                        }
                    } else {
                        super.visitNode(node);
                    }
                }
                {
                    this.$text = $captured_local_variable$0;
                    this.$map = $captured_local_variable$1;
                }
            });
            return new LinkMap(map2, null);
        }

        private final CharSequence normalizeLabel(CharSequence label2) {
            String string = this.getSPACES_REGEX().replace(label2, " ");
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull(locale, "Locale.US");
            Locale locale2 = locale;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase(locale2);
            Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).toLowerCase(locale)");
            return string3;
        }

        @NotNull
        public final CharSequence normalizeDestination(@NotNull CharSequence s) {
            Intrinsics.checkParameterIsNotNull(s, "s");
            String dest = EntityConverter.INSTANCE.replaceEntities(this.clearBounding(s, "<>"), true, true);
            StringBuilder sb = new StringBuilder();
            CharIterator charIterator = StringsKt.iterator(dest);
            while (charIterator.hasNext()) {
                char c = charIterator.nextChar();
                char code2 = c;
                if (code2 == ' ') {
                    sb.append("%20");
                    continue;
                }
                if (code2 < ' ' || code2 >= '\u0080' || StringsKt.contains$default((CharSequence)"\".<>\\^_`{|}~", c, false, 2, null)) {
                    sb.append(URLEncoder.encode(String.valueOf(c), "UTF-8"));
                    continue;
                }
                sb.append(c);
            }
            CharSequence charSequence = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull(charSequence, "sb.toString()");
            return charSequence;
        }

        @NotNull
        public final CharSequence normalizeTitle(@NotNull CharSequence s) {
            Intrinsics.checkParameterIsNotNull(s, "s");
            return EntityConverter.INSTANCE.replaceEntities(this.clearBounding(s, "\"\"", "''", "()"), true, true);
        }

        private final CharSequence clearBounding(CharSequence s, String ... boundQuotes) {
            if (s.length() == 0) {
                return s;
            }
            for (int j = 0; j < boundQuotes.length; ++j) {
                String quotePair = boundQuotes[j];
                if (s.charAt(0) != quotePair.charAt(0) || s.charAt(s.length() - 1) != quotePair.charAt(1)) continue;
                return s.subSequence(1, s.length() - 1);
            }
            return s;
        }

        @NotNull
        public final Regex getSPACES_REGEX() {
            return SPACES_REGEX;
        }

        private Builder() {
        }

        public /* synthetic */ Builder(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

