/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.snappy;

import java.io.IOException;
import java.io.OutputStream;
import org.iq80.snappy.BufferRecycler;
import org.iq80.snappy.Crc32C;
import org.iq80.snappy.Snappy;
import org.iq80.snappy.SnappyInternalUtils;

abstract class AbstractSnappyOutputStream
extends OutputStream {
    private final BufferRecycler recycler;
    private final int blockSize;
    private final byte[] buffer;
    private final byte[] outputBuffer;
    private final double minCompressionRatio;
    private final OutputStream out;
    private int position;
    private boolean closed;

    @Override
    public void write(int b2) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.position >= this.blockSize) {
            this.flushBuffer();
        }
        this.buffer[this.position++] = (byte)b2;
    }

    @Override
    public void write(byte[] input2, int offset2, int length) throws IOException {
        SnappyInternalUtils.checkNotNull(input2, "input is null", new Object[0]);
        SnappyInternalUtils.checkPositionIndexes(offset2, offset2 + length, input2.length);
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        int free = this.blockSize - this.position;
        if (free >= length) {
            this.copyToBuffer(input2, offset2, length);
            return;
        }
        if (this.position > 0) {
            this.copyToBuffer(input2, offset2, free);
            this.flushBuffer();
            offset2 += free;
            length -= free;
        }
        while (length >= this.blockSize) {
            this.writeCompressed(input2, offset2, this.blockSize);
            offset2 += this.blockSize;
            length -= this.blockSize;
        }
        this.copyToBuffer(input2, offset2, length);
    }

    @Override
    public final void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        this.flushBuffer();
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.flush();
            this.out.close();
        }
        finally {
            this.closed = true;
            this.recycler.releaseOutputBuffer(this.outputBuffer);
            this.recycler.releaseEncodeBuffer(this.buffer);
        }
    }

    private void copyToBuffer(byte[] input2, int offset2, int length) {
        System.arraycopy(input2, offset2, this.buffer, this.position, length);
        this.position += length;
    }

    private void flushBuffer() throws IOException {
        if (this.position > 0) {
            this.writeCompressed(this.buffer, 0, this.position);
            this.position = 0;
        }
    }

    private void writeCompressed(byte[] input2, int offset2, int length) throws IOException {
        int crc32c = this.calculateCRC32C(input2, offset2, length);
        int compressed = Snappy.compress(input2, offset2, length, this.outputBuffer, 0);
        if ((double)compressed / (double)length <= this.minCompressionRatio) {
            this.writeBlock(this.out, this.outputBuffer, 0, compressed, true, crc32c);
        } else {
            this.writeBlock(this.out, input2, offset2, length, false, crc32c);
        }
    }

    protected int calculateCRC32C(byte[] data2, int offset2, int length) {
        return Crc32C.maskedCrc32c(data2, offset2, length);
    }

    protected abstract void writeBlock(OutputStream var1, byte[] var2, int var3, int var4, boolean var5, int var6) throws IOException;
}

