/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.IllegalAddException;
import org.jdom.Namespace;
import org.jdom.Verifier;

class AttributeList
extends AbstractList<Attribute>
implements Serializable {
    private Attribute[] elementData;
    private int size;
    private Element parent;

    private AttributeList() {
    }

    AttributeList(Element parent2) {
        this.parent = parent2;
    }

    @Override
    public boolean add(Attribute obj) {
        if (obj != null) {
            Attribute attribute = obj;
            int duplicate = this.indexOfDuplicate(attribute);
            if (duplicate < 0) {
                this.addImpl(this.size(), attribute);
            } else {
                this.setImpl(duplicate, attribute);
            }
        } else {
            throw new IllegalAddException("Cannot add null attribute");
        }
        return true;
    }

    @Override
    public void add(int index2, Attribute obj) {
        Attribute attribute;
        if (obj != null) {
            attribute = obj;
            int duplicate = this.indexOfDuplicate(attribute);
            if (duplicate >= 0) {
                throw new IllegalAddException("Cannot add duplicate attribute");
            }
        } else {
            throw new IllegalAddException("Cannot add null attribute");
        }
        this.addImpl(index2, attribute);
        ++this.modCount;
    }

    void addImpl(int index2, Attribute attribute) {
        if (attribute.getParent() != null) {
            throw new IllegalAddException("The attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"");
        }
        String reason = Verifier.checkNamespaceCollision(attribute, this.parent);
        if (reason != null) {
            throw new IllegalAddException(this.parent, attribute, reason);
        }
        if (index2 < 0 || index2 > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index2 + " Size: " + this.size());
        }
        attribute.setParent(this.parent);
        this.ensureCapacity(this.size + 1);
        if (index2 == this.size) {
            this.elementData[this.size++] = attribute;
        } else {
            System.arraycopy(this.elementData, index2, this.elementData, index2 + 1, this.size - index2);
            this.elementData[index2] = attribute;
            ++this.size;
        }
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Attribute> collection) {
        return this.addAll(this.size(), collection);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(int index2, Collection<? extends Attribute> collection) {
        if (index2 < 0 || index2 > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index2 + " Size: " + this.size());
        }
        if (collection == null || collection.size() == 0) {
            return false;
        }
        this.ensureCapacity(this.size() + collection.size());
        int count2 = 0;
        try {
            for (Attribute attribute : collection) {
                this.add(index2 + count2, attribute);
                ++count2;
            }
        }
        catch (RuntimeException exception) {
            void var5_8;
            boolean bl = false;
            while (var5_8 < count2) {
                this.remove(index2);
                ++var5_8;
            }
            throw exception;
        }
        return true;
    }

    @Override
    public void clear() {
        if (this.elementData != null) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                Attribute attribute = this.elementData[i2];
                attribute.setParent(null);
            }
            this.elementData = null;
            this.size = 0;
        }
        ++this.modCount;
    }

    private void ensureCapacity(int minCapacity) {
        if (this.elementData == null) {
            this.elementData = new Attribute[Math.max(minCapacity, 5)];
        } else {
            int oldCapacity = this.elementData.length;
            if (minCapacity > oldCapacity) {
                Attribute[] oldData = this.elementData;
                int newCapacity = oldCapacity * 3 / 2 + 1;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this.elementData = new Attribute[newCapacity];
                System.arraycopy(oldData, 0, this.elementData, 0, this.size);
            }
        }
    }

    @Override
    public Attribute get(int index2) {
        if (index2 < 0 || index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index2 + " Size: " + this.size());
        }
        return this.elementData[index2];
    }

    Object get(String name, Namespace namespace) {
        int index2 = this.indexOf(name, namespace);
        if (index2 < 0) {
            return null;
        }
        return this.elementData[index2];
    }

    int indexOf(String name, Namespace namespace) {
        String uri = namespace.getURI();
        if (this.elementData != null) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                Attribute old = this.elementData[i2];
                String oldURI = old.getNamespaceURI();
                String oldName = old.getName();
                if (!oldURI.equals(uri) || !oldName.equals(name)) continue;
                return i2;
            }
        }
        return -1;
    }

    @Override
    public Attribute remove(int index2) {
        if (index2 < 0 || index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index2 + " Size: " + this.size());
        }
        Attribute old = this.elementData[index2];
        old.setParent(null);
        int numMoved = this.size - index2 - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index2 + 1, this.elementData, index2, numMoved);
        }
        this.elementData[--this.size] = null;
        ++this.modCount;
        return old;
    }

    @Override
    public Attribute set(int index2, Attribute obj) {
        if (obj != null) {
            Attribute attribute = obj;
            int duplicate = this.indexOfDuplicate(attribute);
            if (duplicate >= 0 && duplicate != index2) {
                throw new IllegalAddException("Cannot set duplicate attribute");
            }
            return this.setImpl(index2, attribute);
        }
        throw new IllegalAddException("Cannot add null attribute");
    }

    Attribute setImpl(int index2, Attribute attribute) {
        if (index2 < 0 || index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index2 + " Size: " + this.size());
        }
        if (attribute.getParent() != null) {
            throw new IllegalAddException("The attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"");
        }
        String reason = Verifier.checkNamespaceCollision(attribute, this.parent);
        if (reason != null) {
            throw new IllegalAddException(this.parent, attribute, reason);
        }
        Attribute old = this.elementData[index2];
        old.setParent(null);
        this.elementData[index2] = attribute;
        attribute.setParent(this.parent);
        return old;
    }

    private int indexOfDuplicate(Attribute attribute) {
        int duplicate = -1;
        String name = attribute.getName();
        Namespace namespace = attribute.getNamespace();
        duplicate = this.indexOf(name, namespace);
        return duplicate;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

