/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.intellij.util.io.PathKt;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dokka.DocumentationBuilderKt;
import org.jetbrains.dokka.DocumentationOptions;
import org.jetbrains.dokka.DokkaConfiguration;
import org.jetbrains.dokka.DokkaLogger;
import org.jetbrains.dokka.ExternalDocumentationLinkResolver;
import org.jetbrains.dokka.ExternalDocumentationLinkResolverKt;
import org.jetbrains.dokka.InboundExternalLinkResolutionService;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Singleton
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 *2\u00020\u0001:\u0002*+B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u001e\u0010$\u001a\u00020%*\u00020&2\b\b\u0002\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020(R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0014\u00a8\u0006,"}, d2={"Lorg/jetbrains/dokka/ExternalDocumentationLinkResolver;", "", "options", "Lorg/jetbrains/dokka/DocumentationOptions;", "logger", "Lorg/jetbrains/dokka/DokkaLogger;", "(Lorg/jetbrains/dokka/DocumentationOptions;Lorg/jetbrains/dokka/DokkaLogger;)V", "cacheDir", "Ljava/nio/file/Path;", "getCacheDir", "()Ljava/nio/file/Path;", "cachedProtocols", "", "", "getCachedProtocols", "()Ljava/util/Set;", "formats", "", "Lorg/jetbrains/dokka/InboundExternalLinkResolutionService;", "getFormats", "()Ljava/util/Map;", "getLogger", "()Lorg/jetbrains/dokka/DokkaLogger;", "getOptions", "()Lorg/jetbrains/dokka/DocumentationOptions;", "packageFqNameToLocation", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/dokka/ExternalDocumentationLinkResolver$ExternalDocumentationRoot;", "getPackageFqNameToLocation", "buildExternalDocumentationLink", "symbol", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "loadPackageList", "", "link", "Lorg/jetbrains/dokka/DokkaConfiguration$ExternalDocumentationLink;", "doOpenConnectionToReadContent", "Ljava/net/URLConnection;", "Ljava/net/URL;", "timeout", "", "redirectsAllowed", "Companion", "ExternalDocumentationRoot", "core"})
public final class ExternalDocumentationLinkResolver {
    @NotNull
    private final Map<FqName, ExternalDocumentationRoot> packageFqNameToLocation;
    @NotNull
    private final Map<String, InboundExternalLinkResolutionService> formats;
    @Nullable
    private final Path cacheDir;
    @NotNull
    private final Set<String> cachedProtocols;
    @NotNull
    private final DocumentationOptions options;
    @NotNull
    private final DokkaLogger logger;
    @NotNull
    public static final String DOKKA_PARAM_PREFIX = "$dokka.";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Map<FqName, ExternalDocumentationRoot> getPackageFqNameToLocation() {
        return this.packageFqNameToLocation;
    }

    @NotNull
    public final Map<String, InboundExternalLinkResolutionService> getFormats() {
        return this.formats;
    }

    @Nullable
    public final Path getCacheDir() {
        return this.cacheDir;
    }

    @NotNull
    public final Set<String> getCachedProtocols() {
        return this.cachedProtocols;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final URLConnection doOpenConnectionToReadContent(@NotNull URL $receiver, int timeout, int redirectsAllowed) {
        URLConnection uRLConnection;
        URLConnection connection;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        URLConnection uRLConnection2 = connection = $receiver.openConnection();
        Intrinsics.checkExpressionValueIsNotNull(uRLConnection2, "connection");
        uRLConnection2.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        URLConnection uRLConnection3 = connection;
        if (!(uRLConnection3 instanceof HttpURLConnection)) return connection;
        int n = ((HttpURLConnection)connection).getResponseCode();
        int n2 = n;
        if (200 <= n2 && 299 >= n2) {
            uRLConnection = connection;
            return uRLConnection;
        } else {
            if (n != 301 && n != 302 && n != 303) throw (Throwable)new RuntimeException("Unhandled http code: " + ((HttpURLConnection)connection).getResponseCode());
            if (redirectsAllowed <= 0) throw (Throwable)new RuntimeException("Too many redirects");
            String newUrl = connection.getHeaderField("Location");
            uRLConnection = this.doOpenConnectionToReadContent(new URL(newUrl), timeout, redirectsAllowed - 1);
        }
        return uRLConnection;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ URLConnection doOpenConnectionToReadContent$default(ExternalDocumentationLinkResolver externalDocumentationLinkResolver, URL uRL, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 10000;
        }
        if ((n3 & 2) != 0) {
            n2 = 16;
        }
        return externalDocumentationLinkResolver.doOpenConnectionToReadContent(uRL, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void loadPackageList(@NotNull DokkaConfiguration.ExternalDocumentationLink link2) {
        void $receiver$iv$iv;
        InboundExternalLinkResolutionService inboundExternalLinkResolutionService;
        Object it;
        String[] $i$a$3$groupBy;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv;
        List list2;
        Object format;
        String value;
        Iterable $$_$_value;
        void $receiver$iv$iv3;
        void params2;
        Object object;
        List first$iv;
        Iterator it$iv2;
        Sequence $receiver$iv2;
        InputStream packageListStream;
        InputStream inputStream;
        Closeable closeable;
        Object cacheEntry;
        Object hash;
        Object object2;
        Object object3;
        Object packageListLink;
        Intrinsics.checkParameterIsNotNull(link2, "link");
        URL packageListUrl = link2.getPackageListUrl();
        boolean needsCache = this.cachedProtocols.contains(packageListUrl.getProtocol());
        if (this.cacheDir != null && needsCache) {
            packageListLink = packageListUrl.toExternalForm();
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            String string = packageListLink;
            Intrinsics.checkExpressionValueIsNotNull(string, "packageListLink");
            String string2 = string;
            Charset charset = Charsets.UTF_8;
            object3 = digest;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull(byArray, "(this as java.lang.String).getBytes(charset)");
            object2 = byArray;
            byte[] byArray2 = ((MessageDigest)object3).digest((byte[])object2);
            Intrinsics.checkExpressionValueIsNotNull(byArray2, "digest.digest(packageLis\u2026yteArray(Charsets.UTF_8))");
            hash = ExternalDocumentationLinkResolverKt.toHexString(byArray2);
            Object object4 = cacheEntry = this.cacheDir.resolve((String)hash);
            Intrinsics.checkExpressionValueIsNotNull(object4, "cacheEntry");
            if (PathKt.exists((Path)object4)) {
                try {
                    URLConnection connection = ExternalDocumentationLinkResolver.doOpenConnectionToReadContent$default(this, packageListUrl, 0, 0, 3, null);
                    long originModifiedDate = connection.getDate();
                    long cacheDate = PathKt.lastModified((Path)cacheEntry).toMillis();
                    if (originModifiedDate > cacheDate || originModifiedDate == 0L) {
                        if (originModifiedDate == 0L) {
                            this.logger.warn("No date header for " + packageListUrl + ", downloading anyway");
                        } else {
                            this.logger.info("Renewing package-list from " + packageListUrl);
                        }
                        InputStream inputStream2 = connection.getInputStream();
                        Intrinsics.checkExpressionValueIsNotNull(inputStream2, "connection.getInputStream()");
                        ByteStreamsKt.copyTo$default(inputStream2, PathKt.outputStream((Path)cacheEntry), 0, 2, null);
                    }
                }
                catch (Exception e) {
                    this.logger.error("Failed to update package-list cache for " + link2);
                    ByteArrayOutputStream baos22 = new ByteArrayOutputStream();
                    closeable = new PrintWriter(baos22);
                    Throwable cacheDate = null;
                    try {
                        Object it2 = (PrintWriter)closeable;
                        e.printStackTrace((PrintWriter)it2);
                        it2 = Unit.INSTANCE;
                    }
                    catch (Throwable it2) {
                        cacheDate = it2;
                        throw it2;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, cacheDate);
                    }
                    baos22.flush();
                    String string4 = baos22.toString();
                    Intrinsics.checkExpressionValueIsNotNull(string4, "baos.toString()");
                    this.logger.error(string4);
                }
            } else {
                this.logger.info("Downloading package-list from " + packageListUrl);
                InputStream inputStream3 = packageListUrl.openStream();
                Intrinsics.checkExpressionValueIsNotNull(inputStream3, "packageListUrl.openStream()");
                ByteStreamsKt.copyTo$default(inputStream3, PathKt.outputStream((Path)cacheEntry), 0, 2, null);
            }
            inputStream = PathKt.inputStream((Path)cacheEntry);
        } else {
            inputStream = ExternalDocumentationLinkResolver.doOpenConnectionToReadContent$default(this, packageListUrl, 0, 0, 3, null).getInputStream();
        }
        InputStream inputStream4 = packageListStream = inputStream;
        Intrinsics.checkExpressionValueIsNotNull(inputStream4, "packageListStream");
        cacheEntry = inputStream4;
        Sequence e = Charsets.UTF_8;
        closeable = cacheEntry;
        closeable = new InputStreamReader((InputStream)closeable, (Charset)((Object)e));
        int cacheDate = 8192;
        cacheEntry = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, cacheDate);
        e = $receiver$iv2;
        int baos22 = 8192;
        e = e instanceof BufferedReader ? (BufferedReader)((Object)e) : new BufferedReader((Reader)((Object)e), baos22);
        Throwable baos22 = null;
        try {
            Sequence<String> lines;
            it$iv2 = (BufferedReader)((Object)e);
            Sequence<String> $receiver$iv3 = lines = TextStreamsKt.lineSequence((BufferedReader)((Object)it$iv2));
            first$iv = new ArrayList<String>();
            ArrayList<String> second$iv = new ArrayList<String>();
            object = $receiver$iv3.iterator();
            while (object.hasNext()) {
                String element$iv = object.next();
                String it3 = element$iv;
                if (StringsKt.startsWith$default(it3, DOKKA_PARAM_PREFIX, false, 2, null)) {
                    ((ArrayList)first$iv).add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            it$iv2 = new Pair(first$iv, second$iv);
        }
        catch (Throwable it$iv2) {
            baos22 = it$iv2;
            throw it$iv2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)((Object)e), baos22);
        }
        hash = it$iv2;
        packageListLink = (List)((Pair)hash).component1();
        List packages2 = (List)((Pair)hash).component2();
        $receiver$iv2 = SequencesKt.map(CollectionsKt.asSequence((Iterable)params2), loadPackageList.paramsMap.1.INSTANCE);
        e = $receiver$iv2;
        Iterable<Object> destination$iv$iv = new LinkedHashMap();
        it$iv2 = $receiver$iv$iv3.iterator();
        while (it$iv2.hasNext()) {
            Object object5;
            List $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = it$iv2.next();
            List $key_$_$ = (List)element$iv$iv;
            first$iv = $key_$_$;
            String key = (String)first$iv.get(0);
            String key$iv$iv = key;
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object5 = answer$iv$iv$iv;
            } else {
                object5 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object5;
            $key_$_$ = (List)element$iv$iv;
            object3 = list$iv$iv;
            first$iv = $$_$_value;
            value = (String)first$iv.get(1);
            object2 = value;
            object3.add(object2);
        }
        List paramsMap2 = destination$iv$iv;
        Object object6 = (List)paramsMap2.get("format");
        if (object6 == null || (object6 = (String)CollectionsKt.singleOrNull(object6)) == null) {
            object6 = format = "javadoc";
        }
        if ((list2 = (destination$iv$iv = (List)paramsMap2.get("location"))) == null) {
            list2 = CollectionsKt.emptyList();
        }
        destination$iv$iv = list2;
        it$iv2 = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            value = (String)item$iv$iv;
            object3 = destination$iv$iv2;
            $i$a$3$groupBy = new String[]{"\u001f"};
            boolean key$iv$iv = false;
            int $receiver$iv$iv$iv = 2;
            object2 = StringsKt.split$default((CharSequence)it, $i$a$3$groupBy, key$iv$iv, $receiver$iv$iv$iv, 2, null);
            object3.add(object2);
        }
        $receiver$iv = (List)destination$iv$iv2;
        $receiver$iv$iv2 = $receiver$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            Iterator $key_value;
            it = (List)item$iv$iv;
            object3 = destination$iv$iv2;
            $i$a$3$groupBy = $key_value;
            String key = (String)$i$a$3$groupBy.get(0);
            $i$a$3$groupBy = $key_value;
            String value2 = (String)$i$a$3$groupBy.get(1);
            object2 = TuplesKt.to(key, value2);
            object3.add(object2);
        }
        Map<String, String> locations = MapsKt.toMap((List)destination$iv$iv2);
        if (Intrinsics.areEqual(format, "javadoc")) {
            inboundExternalLinkResolutionService = new InboundExternalLinkResolutionService.Javadoc();
        } else {
            Object object7 = (List)paramsMap2.get("linkExtension");
            if (object7 == null || (object7 = (String)CollectionsKt.singleOrNull(object7)) == null) {
                throw (Throwable)new RuntimeException("Failed to parse package list from " + packageListUrl);
            }
            Object linkExtension = object7;
            inboundExternalLinkResolutionService = new InboundExternalLinkResolutionService.Dokka((String)linkExtension);
        }
        InboundExternalLinkResolutionService resolver2 = inboundExternalLinkResolutionService;
        ExternalDocumentationRoot rootInfo = new ExternalDocumentationRoot(link2.getUrl(), resolver2, locations);
        Iterable $receiver$iv4 = packages2;
        $$_$_value = $receiver$iv4;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv4, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it4;
            String key = (String)item$iv$iv;
            object3 = destination$iv$iv3;
            object2 = new FqName((String)it4);
            object3.add(object2);
        }
        $receiver$iv4 = (List)destination$iv$iv3;
        for (Object element$iv : $receiver$iv4) {
            it = (FqName)element$iv;
            object = this.packageFqNameToLocation;
            ExternalDocumentationRoot externalDocumentationRoot = rootInfo;
            object.put(it, externalDocumentationRoot);
        }
    }

    @Nullable
    public final String buildExternalDocumentationLink(@NotNull DeclarationDescriptor symbol2) {
        Object object;
        Intrinsics.checkParameterIsNotNull(symbol2, "symbol");
        DeclarationDescriptor declarationDescriptor = symbol2;
        if (declarationDescriptor instanceof DeclarationDescriptorNonRoot) {
            DeclarationDescriptor declarationDescriptor2;
            block9: {
                Sequence<DeclarationDescriptor> $receiver$iv = DescriptorUtilsKt.getParents(symbol2);
                Iterator<DeclarationDescriptor> iterator2 = $receiver$iv.iterator();
                while (iterator2.hasNext()) {
                    DeclarationDescriptor element$iv = iterator2.next();
                    DeclarationDescriptor it = element$iv;
                    if (!(it instanceof PackageFragmentDescriptor)) continue;
                    declarationDescriptor2 = element$iv;
                    break block9;
                }
                declarationDescriptor2 = null;
            }
            if ((object = (DeclarationDescriptor)declarationDescriptor2) == null || (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) == null) {
                return null;
            }
        } else if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            object = ((PackageFragmentDescriptor)symbol2).getFqName();
        } else {
            return null;
        }
        FqName packageFqName = object;
        ExternalDocumentationRoot externalDocumentationRoot = this.packageFqNameToLocation.get(packageFqName);
        if (externalDocumentationRoot == null) {
            return null;
        }
        ExternalDocumentationRoot externalLocation = externalDocumentationRoot;
        String string = externalLocation.getLocations().get(DocumentationBuilderKt.signature(symbol2));
        if (string == null) {
            string = externalLocation.getResolver().getPath(symbol2);
        }
        if (string == null) {
            return null;
        }
        String path2 = string;
        return new URL(externalLocation.getRootUrl(), path2).toExternalForm();
    }

    @NotNull
    public final DocumentationOptions getOptions() {
        return this.options;
    }

    @NotNull
    public final DokkaLogger getLogger() {
        return this.logger;
    }

    @Inject
    public ExternalDocumentationLinkResolver(@NotNull DocumentationOptions options, @NotNull DokkaLogger logger) {
        Object object;
        Intrinsics.checkParameterIsNotNull(options, "options");
        Intrinsics.checkParameterIsNotNull(logger, "logger");
        this.options = options;
        this.logger = logger;
        ExternalDocumentationLinkResolver externalDocumentationLinkResolver = this;
        Object object2 = new LinkedHashMap();
        externalDocumentationLinkResolver.packageFqNameToLocation = object2;
        externalDocumentationLinkResolver = this;
        object2 = new LinkedHashMap();
        externalDocumentationLinkResolver.formats = object2;
        ExternalDocumentationLinkResolver externalDocumentationLinkResolver2 = this;
        Path path2 = this.options.getCacheRoot();
        if (path2 != null && (path2 = path2.resolve("packageListCache")) != null) {
            Path path3 = path2;
            externalDocumentationLinkResolver = externalDocumentationLinkResolver2;
            Path $receiver = path3;
            PathKt.createDirectories($receiver);
            object2 = path3;
            externalDocumentationLinkResolver2 = externalDocumentationLinkResolver;
            object = object2;
        } else {
            object = null;
        }
        externalDocumentationLinkResolver2.cacheDir = object;
        this.cachedProtocols = SetsKt.setOf(new String[]{"http", "https", "ftp"});
        Iterable $receiver$iv = this.options.getExternalDocumentationLinks();
        for (Object element$iv : $receiver$iv) {
            DokkaConfiguration.ExternalDocumentationLink it = (DokkaConfiguration.ExternalDocumentationLink)element$iv;
            try {
                this.loadPackageList(it);
            }
            catch (Exception e) {
                throw (Throwable)new RuntimeException("Exception while loading package-list from " + it, e);
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\bH\u0016R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/dokka/ExternalDocumentationLinkResolver$ExternalDocumentationRoot;", "", "rootUrl", "Ljava/net/URL;", "resolver", "Lorg/jetbrains/dokka/InboundExternalLinkResolutionService;", "locations", "", "", "(Ljava/net/URL;Lorg/jetbrains/dokka/InboundExternalLinkResolutionService;Ljava/util/Map;)V", "getLocations", "()Ljava/util/Map;", "getResolver", "()Lorg/jetbrains/dokka/InboundExternalLinkResolutionService;", "getRootUrl", "()Ljava/net/URL;", "toString", "core"})
    public static final class ExternalDocumentationRoot {
        @NotNull
        private final URL rootUrl;
        @NotNull
        private final InboundExternalLinkResolutionService resolver;
        @NotNull
        private final Map<String, String> locations;

        @NotNull
        public String toString() {
            String string = this.rootUrl.toString();
            Intrinsics.checkExpressionValueIsNotNull(string, "rootUrl.toString()");
            return string;
        }

        @NotNull
        public final URL getRootUrl() {
            return this.rootUrl;
        }

        @NotNull
        public final InboundExternalLinkResolutionService getResolver() {
            return this.resolver;
        }

        @NotNull
        public final Map<String, String> getLocations() {
            return this.locations;
        }

        public ExternalDocumentationRoot(@NotNull URL rootUrl, @NotNull InboundExternalLinkResolutionService resolver2, @NotNull Map<String, String> locations) {
            Intrinsics.checkParameterIsNotNull(rootUrl, "rootUrl");
            Intrinsics.checkParameterIsNotNull(resolver2, "resolver");
            Intrinsics.checkParameterIsNotNull(locations, "locations");
            this.rootUrl = rootUrl;
            this.resolver = resolver2;
            this.locations = locations;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/dokka/ExternalDocumentationLinkResolver$Companion;", "", "()V", "DOKKA_PARAM_PREFIX", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

