/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dokka.ContentNode;
import org.jetbrains.dokka.ContentText;
import org.jetbrains.dokka.DocumentationNode;
import org.jetbrains.dokka.DocumentationNodeKt;
import org.jetbrains.dokka.JavaLanguageService$WhenMappings;
import org.jetbrains.dokka.LanguageService;
import org.jetbrains.dokka.NodeKind;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aH\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/dokka/JavaLanguageService;", "Lorg/jetbrains/dokka/LanguageService;", "()V", "getArrayDimension", "", "node", "Lorg/jetbrains/dokka/DocumentationNode;", "getArrayElementType", "render", "Lorg/jetbrains/dokka/ContentNode;", "renderMode", "Lorg/jetbrains/dokka/LanguageService$RenderMode;", "renderClass", "", "renderFunction", "renderModifier", "renderModifiersForNode", "renderName", "renderPackage", "renderParameter", "renderProperty", "renderType", "renderTypeParameter", "renderTypeParametersForNode", "summarizeSignatures", "nodes", "", "core"})
public final class JavaLanguageService
implements LanguageService {
    @Override
    @NotNull
    public ContentNode render(@NotNull DocumentationNode node, @NotNull LanguageService.RenderMode renderMode) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull((Object)renderMode, "renderMode");
        NodeKind nodeKind = node.getKind();
        return new ContentText(Intrinsics.areEqual((Object)nodeKind, (Object)NodeKind.Package) ? this.renderPackage(node) : (NodeKind.Companion.getClassLike().contains((Object)nodeKind) ? this.renderClass(node) : (Intrinsics.areEqual((Object)nodeKind, (Object)NodeKind.TypeParameter) ? this.renderTypeParameter(node) : (Intrinsics.areEqual((Object)nodeKind, (Object)NodeKind.Type) || Intrinsics.areEqual((Object)nodeKind, (Object)NodeKind.UpperBound) ? this.renderType(node) : (Intrinsics.areEqual((Object)nodeKind, (Object)NodeKind.Constructor) || Intrinsics.areEqual((Object)nodeKind, (Object)NodeKind.Function) ? this.renderFunction(node) : (Intrinsics.areEqual((Object)nodeKind, (Object)NodeKind.Property) ? this.renderProperty(node) : "" + (Object)((Object)node.getKind()) + ": " + node.getName()))))));
    }

    @Override
    @NotNull
    public String renderName(@NotNull DocumentationNode node) {
        String string;
        Intrinsics.checkParameterIsNotNull(node, "node");
        switch (JavaLanguageService$WhenMappings.$EnumSwitchMapping$0[node.getKind().ordinal()]) {
            case 1: {
                DocumentationNode documentationNode = node.getOwner();
                if (documentationNode == null) {
                    Intrinsics.throwNpe();
                }
                string = documentationNode.getName();
                break;
            }
            default: {
                string = node.getName();
            }
        }
        return string;
    }

    @Override
    @Nullable
    public ContentNode summarizeSignatures(@NotNull List<? extends DocumentationNode> nodes) {
        Intrinsics.checkParameterIsNotNull(nodes, "nodes");
        return null;
    }

    private final String renderPackage(DocumentationNode node) {
        return "package " + node.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String renderModifier(DocumentationNode node) {
        String string = node.getName();
        switch (string.hashCode()) {
            case 570410685: {
                if (!string.equals("internal")) break;
                return "";
            }
            case 3417674: {
                if (!string.equals("open")) break;
                return "";
            }
        }
        String string2 = node.getName();
        return string2;
    }

    @Nullable
    public final DocumentationNode getArrayElementType(@NotNull DocumentationNode node) {
        DocumentationNode documentationNode;
        Intrinsics.checkParameterIsNotNull(node, "node");
        switch (DocumentationNodeKt.qualifiedName(node)) {
            case "kotlin.Array": {
                documentationNode = CollectionsKt.singleOrNull(node.details(NodeKind.Type));
                if (documentationNode != null) {
                    DocumentationNode documentationNode2 = documentationNode;
                    DocumentationNode et = documentationNode2;
                    DocumentationNode documentationNode3 = this.getArrayElementType(et);
                    if (documentationNode3 == null) {
                        documentationNode3 = documentationNode = et;
                    }
                    if (documentationNode3 != null) break;
                }
                documentationNode = new DocumentationNode("Object", node.getContent(), NodeKind.ExternalClass);
                break;
            }
            case "kotlin.IntArray": 
            case "kotlin.CharArray": 
            case "kotlin.BooleanArray": 
            case "kotlin.LongArray": 
            case "kotlin.ShortArray": 
            case "kotlin.DoubleArray": 
            case "kotlin.ByteArray": 
            case "kotlin.FloatArray": {
                DocumentationNode documentationNode4;
                String string = StringsKt.removeSuffix(node.getName(), (CharSequence)"Array");
                DocumentationNode documentationNode5 = documentationNode4;
                DocumentationNode documentationNode6 = documentationNode4;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).toLowerCase()");
                String string4 = string3;
                documentationNode = documentationNode6;
                documentationNode5(string4, node.getContent(), NodeKind.Type);
                break;
            }
            default: {
                documentationNode = null;
            }
        }
        return documentationNode;
    }

    public final int getArrayDimension(@NotNull DocumentationNode node) {
        int n;
        Intrinsics.checkParameterIsNotNull(node, "node");
        switch (DocumentationNodeKt.qualifiedName(node)) {
            case "kotlin.Array": {
                int n2;
                int n3 = 1;
                DocumentationNode documentationNode = CollectionsKt.singleOrNull(node.details(NodeKind.Type));
                if (documentationNode != null) {
                    DocumentationNode documentationNode2 = documentationNode;
                    int n4 = n3;
                    DocumentationNode it = documentationNode2;
                    int n5 = this.getArrayDimension(it);
                    n3 = n4;
                    n2 = n5;
                } else {
                    n2 = 0;
                }
                n = n3 + n2;
                break;
            }
            case "kotlin.IntArray": 
            case "kotlin.CharArray": 
            case "kotlin.BooleanArray": 
            case "kotlin.LongArray": 
            case "kotlin.ShortArray": 
            case "kotlin.DoubleArray": 
            case "kotlin.ByteArray": 
            case "kotlin.FloatArray": {
                n = 1;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @NotNull
    public final String renderType(@NotNull DocumentationNode node) {
        String string;
        Intrinsics.checkParameterIsNotNull(node, "node");
        switch (node.getName()) {
            case "Unit": {
                string = "void";
                break;
            }
            case "Int": {
                string = "int";
                break;
            }
            case "Long": {
                string = "long";
                break;
            }
            case "Double": {
                string = "double";
                break;
            }
            case "Float": {
                string = "float";
                break;
            }
            case "Char": {
                string = "char";
                break;
            }
            case "Boolean": {
                string = "bool";
                break;
            }
            default: {
                string = node.getName();
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String renderTypeParameter(DocumentationNode node) {
        String string;
        List<DocumentationNode> constraints = node.details(NodeKind.UpperBound);
        if (CollectionsKt.none((Iterable)constraints)) {
            string = node.getName();
        } else {
            Collection<String> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = constraints;
            StringBuilder stringBuilder = new StringBuilder().append(node.getName()).append(" extends ");
            void var4_5 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                DocumentationNode documentationNode = (DocumentationNode)item$iv$iv;
                collection = destination$iv$iv;
                String string2 = this.renderType(node);
                collection.add(string2);
            }
            collection = (List)destination$iv$iv;
            string = stringBuilder.append(CollectionsKt.joinToString$default(collection, null, null, null, 0, null, null, 63, null)).toString();
        }
        return string;
    }

    private final String renderParameter(DocumentationNode node) {
        return "" + this.renderType(node.detail(NodeKind.Type)) + ' ' + node.getName();
    }

    /*
     * WARNING - void declaration
     */
    private final String renderTypeParametersForNode(DocumentationNode node) {
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        List<DocumentationNode> typeParameters2 = node.details(NodeKind.TypeParameter);
        if (CollectionsKt.any((Iterable)typeParameters2)) {
            Collection<String> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            $receiver.append("<");
            Iterable iterable = typeParameters2;
            StringBuilder stringBuilder2 = $receiver;
            void var7_7 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                DocumentationNode documentationNode = (DocumentationNode)item$iv$iv;
                collection = destination$iv$iv;
                String string = this.renderTypeParameter((DocumentationNode)it);
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            stringBuilder2.append(CollectionsKt.joinToString$default(collection, null, null, null, 0, null, null, 63, null));
            $receiver.append("> ");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply {\n\u2026   }\n        }.toString()");
        return string;
    }

    private final String renderModifiersForNode(DocumentationNode node) {
        String it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)node.details(NodeKind.Modifier);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            DocumentationNode documentationNode = (DocumentationNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = this.renderModifier((DocumentationNode)((Object)it));
            collection.add(string);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (String)element$iv$iv;
            if (!(Intrinsics.areEqual(it, "") ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modifiers2 = (List)destination$iv$iv;
        if (CollectionsKt.none(modifiers2)) {
            return "";
        }
        return CollectionsKt.joinToString$default(modifiers2, " ", null, " ", 0, null, null, 58, null);
    }

    private final String renderClass(DocumentationNode node) {
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        switch (JavaLanguageService$WhenMappings.$EnumSwitchMapping$1[node.getKind().ordinal()]) {
            case 1: {
                $receiver.append("class ");
                break;
            }
            case 2: {
                $receiver.append("interface ");
                break;
            }
            case 3: {
                $receiver.append("enum ");
                break;
            }
            case 4: {
                $receiver.append("enum value ");
                break;
            }
            case 5: {
                $receiver.append("class ");
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Node " + node + " is not a class-like object");
            }
        }
        $receiver.append(node.getName());
        $receiver.append(this.renderTypeParametersForNode(node));
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply {\n\u2026de))\n        }.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String renderFunction(DocumentationNode node) {
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        switch (JavaLanguageService$WhenMappings.$EnumSwitchMapping$2[node.getKind().ordinal()]) {
            case 1: {
                DocumentationNode documentationNode = node.getOwner();
                $receiver.append(documentationNode != null ? documentationNode.getName() : null);
                break;
            }
            case 2: {
                $receiver.append(this.renderTypeParametersForNode(node));
                $receiver.append(this.renderType(node.detail(NodeKind.Type)));
                $receiver.append(" ");
                $receiver.append(node.getName());
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Node " + node + " is not a function-like object");
            }
        }
        DocumentationNode receiver = CollectionsKt.singleOrNull(node.details(NodeKind.Receiver));
        $receiver.append("(");
        if (receiver != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf(receiver), (Iterable)node.details(NodeKind.Parameter));
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                DocumentationNode documentationNode = (DocumentationNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string = this.renderParameter((DocumentationNode)it);
                collection.add(string);
            }
            CollectionsKt.joinTo$default((List)destination$iv$iv, $receiver, null, null, null, 0, null, null, 126, null);
        } else {
            Iterable $receiver$iv;
            Iterable $receiver$iv$iv = $receiver$iv = (Iterable)node.details(NodeKind.Parameter);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                DocumentationNode it = (DocumentationNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string = this.renderParameter(it);
                collection.add(string);
            }
            CollectionsKt.joinTo$default((List)destination$iv$iv, $receiver, null, null, null, 0, null, null, 126, null);
        }
        $receiver.append(")");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply {\n\u2026\")\")\n        }.toString()");
        return string;
    }

    private final String renderProperty(DocumentationNode node) {
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        switch (JavaLanguageService$WhenMappings.$EnumSwitchMapping$3[node.getKind().ordinal()]) {
            case 1: {
                $receiver.append("val ");
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Node " + node + " is not a property");
            }
        }
        $receiver.append(this.renderTypeParametersForNode(node));
        DocumentationNode receiver = CollectionsKt.singleOrNull(node.details(NodeKind.Receiver));
        if (receiver != null) {
            $receiver.append(this.renderType(receiver.detail(NodeKind.Type)));
            $receiver.append(".");
        }
        $receiver.append(node.getName());
        $receiver.append(": ");
        $receiver.append(this.renderType(node.detail(NodeKind.Type)));
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply {\n\u2026e)))\n        }.toString()");
        return string;
    }
}

