/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka;

import com.google.inject.Inject;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dokka.DocumentationNode;
import org.jetbrains.dokka.LanguageService;
import org.jetbrains.dokka.Location;
import org.jetbrains.dokka.NodeLocationAwareGenerator;
import org.jetbrains.dokka.OutlineFormatService;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0016J\"\u0010\u001a\u001a\u00020\u00122\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/dokka/YamlOutlineService;", "Lorg/jetbrains/dokka/OutlineFormatService;", "generator", "Lorg/jetbrains/dokka/NodeLocationAwareGenerator;", "languageService", "Lorg/jetbrains/dokka/LanguageService;", "(Lorg/jetbrains/dokka/NodeLocationAwareGenerator;Lorg/jetbrains/dokka/LanguageService;)V", "getGenerator", "()Lorg/jetbrains/dokka/NodeLocationAwareGenerator;", "getLanguageService", "()Lorg/jetbrains/dokka/LanguageService;", "outlineLevel", "", "getOutlineLevel", "()I", "setOutlineLevel", "(I)V", "appendOutlineHeader", "", "location", "Lorg/jetbrains/dokka/Location;", "node", "Lorg/jetbrains/dokka/DocumentationNode;", "to", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "appendOutlineLevel", "body", "Lkotlin/Function0;", "getOutlineFileName", "Ljava/io/File;", "core"})
public final class YamlOutlineService
implements OutlineFormatService {
    private int outlineLevel;
    @NotNull
    private final NodeLocationAwareGenerator generator;
    @NotNull
    private final LanguageService languageService;

    @Override
    @NotNull
    public File getOutlineFileName(@NotNull Location location2) {
        Intrinsics.checkParameterIsNotNull(location2, "location");
        return new File("" + location2.getPath() + ".yml");
    }

    public final int getOutlineLevel() {
        return this.outlineLevel;
    }

    public final void setOutlineLevel(int n) {
        this.outlineLevel = n;
    }

    @Override
    public void appendOutlineHeader(@NotNull Location location2, @NotNull DocumentationNode node, @NotNull StringBuilder to) {
        Intrinsics.checkParameterIsNotNull(location2, "location");
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(to, "to");
        String indent = StringsKt.repeat("    ", this.outlineLevel);
        StringBuilder stringBuilder = to;
        String string = "" + indent + "- title: " + this.languageService.renderName(node);
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkExpressionValueIsNotNull(stringBuilder2, "append(value)");
        StringsKt.appendln(stringBuilder2);
        stringBuilder = to;
        string = "" + indent + "  url: " + this.generator.location(node).getPath();
        StringBuilder stringBuilder3 = stringBuilder.append(string);
        Intrinsics.checkExpressionValueIsNotNull(stringBuilder3, "append(value)");
        StringsKt.appendln(stringBuilder3);
    }

    @Override
    public void appendOutlineLevel(@NotNull StringBuilder to, @NotNull Function0<Unit> body2) {
        Intrinsics.checkParameterIsNotNull(to, "to");
        Intrinsics.checkParameterIsNotNull(body2, "body");
        String indent = StringsKt.repeat("    ", this.outlineLevel);
        StringBuilder stringBuilder = to;
        String string = "" + indent + "  content:";
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkExpressionValueIsNotNull(stringBuilder2, "append(value)");
        StringsKt.appendln(stringBuilder2);
        int n = this.outlineLevel;
        this.outlineLevel = n + 1;
        body2.invoke();
        n = this.outlineLevel;
        this.outlineLevel = n + -1;
    }

    @NotNull
    public final NodeLocationAwareGenerator getGenerator() {
        return this.generator;
    }

    @NotNull
    public final LanguageService getLanguageService() {
        return this.languageService;
    }

    @Inject
    public YamlOutlineService(@NotNull NodeLocationAwareGenerator generator, @NotNull LanguageService languageService) {
        Intrinsics.checkParameterIsNotNull(generator, "generator");
        Intrinsics.checkParameterIsNotNull(languageService, "languageService");
        this.generator = generator;
        this.languageService = languageService;
    }

    @Override
    public void appendOutline(@NotNull Location location2, @NotNull StringBuilder to, @NotNull Iterable<? extends DocumentationNode> nodes) {
        Intrinsics.checkParameterIsNotNull(location2, "location");
        Intrinsics.checkParameterIsNotNull(to, "to");
        Intrinsics.checkParameterIsNotNull(nodes, "nodes");
        OutlineFormatService.DefaultImpls.appendOutline(this, location2, to, nodes);
    }

    @Override
    @NotNull
    public String formatOutline(@NotNull Location location2, @NotNull Iterable<? extends DocumentationNode> nodes) {
        Intrinsics.checkParameterIsNotNull(location2, "location");
        Intrinsics.checkParameterIsNotNull(nodes, "nodes");
        return OutlineFormatService.DefaultImpls.formatOutline(this, location2, nodes);
    }
}

