/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpsMavenRepositoryLibraryDescriptor {
    private final String myMavenId;
    private final String myGroupId;
    private final String myArtifactId;
    private final String myVersion;
    private final boolean myIncludeTransitiveDependencies;

    public JpsMavenRepositoryLibraryDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        if (groupId == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(0);
        }
        if (artifactId == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(1);
        }
        if (version == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(2);
        }
        this(groupId, artifactId, version, true);
    }

    public JpsMavenRepositoryLibraryDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, boolean includeTransitiveDependencies) {
        if (groupId == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(3);
        }
        if (artifactId == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(4);
        }
        if (version == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(5);
        }
        this.myGroupId = groupId;
        this.myArtifactId = artifactId;
        this.myVersion = version;
        this.myIncludeTransitiveDependencies = includeTransitiveDependencies;
        this.myMavenId = groupId + ":" + artifactId + ":" + version;
    }

    public JpsMavenRepositoryLibraryDescriptor(@Nullable String mavenId) {
        this(mavenId, true);
    }

    public JpsMavenRepositoryLibraryDescriptor(@Nullable String mavenId, boolean includeTransitiveDependencies) {
        this.myMavenId = mavenId;
        this.myIncludeTransitiveDependencies = includeTransitiveDependencies;
        if (mavenId == null) {
            this.myVersion = null;
            this.myArtifactId = null;
            this.myGroupId = null;
        } else {
            String[] parts = mavenId.split(":");
            this.myGroupId = parts.length > 0 ? parts[0] : null;
            this.myArtifactId = parts.length > 1 ? parts[1] : null;
            this.myVersion = parts.length > 2 ? parts[2] : null;
        }
    }

    public String getMavenId() {
        return this.myMavenId;
    }

    public String getGroupId() {
        return this.myGroupId;
    }

    public String getArtifactId() {
        return this.myArtifactId;
    }

    public boolean isIncludeTransitiveDependencies() {
        return this.myIncludeTransitiveDependencies;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JpsMavenRepositoryLibraryDescriptor that = (JpsMavenRepositoryLibraryDescriptor)o;
        return Objects.equals(this.myMavenId, that.myMavenId) && this.myIncludeTransitiveDependencies == that.myIncludeTransitiveDependencies;
    }

    public int hashCode() {
        return Objects.hashCode(this.myMavenId) * 31 + (this.myIncludeTransitiveDependencies ? 1 : 0);
    }

    public String toString() {
        return this.myMavenId != null ? this.myMavenId : "null";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "groupId";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "artifactId";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "version";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

