/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.util.JDOMUtil;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDomSerializationUtil {
    @NonNls
    public static final String COMPONENT_ELEMENT = "component";
    @NonNls
    protected static final String OPTION_ELEMENT = "option";
    @NonNls
    protected static final String NAME_ATTRIBUTE = "name";
    @NonNls
    protected static final String VALUE_ATTRIBUTE = "value";

    @Nullable
    public static Element findComponent(@Nullable Element root2, @NonNls String componentName) {
        for (Element element : JDOMUtil.getChildren(root2, COMPONENT_ELEMENT)) {
            if (!componentName.equals(element.getAttributeValue(NAME_ATTRIBUTE))) continue;
            return element;
        }
        return null;
    }

    public static Element createComponentElement(String componentName) {
        Element element = new Element(COMPONENT_ELEMENT);
        element.setAttribute(NAME_ATTRIBUTE, componentName);
        return element;
    }

    @NotNull
    public static Element findOrCreateComponentElement(@NotNull Element root2, @NotNull String componentName) {
        Element component;
        if (root2 == null) {
            JDomSerializationUtil.$$$reportNull$$$0(0);
        }
        if (componentName == null) {
            JDomSerializationUtil.$$$reportNull$$$0(1);
        }
        if ((component = JDomSerializationUtil.findComponent(root2, componentName)) == null) {
            component = JDomSerializationUtil.createComponentElement(componentName);
            JDomSerializationUtil.addComponent(root2, component);
        }
        Element element = component;
        if (element == null) {
            JDomSerializationUtil.$$$reportNull$$$0(2);
        }
        return element;
    }

    public static void addComponent(Element root2, Element component) {
        String componentName = component.getAttributeValue(NAME_ATTRIBUTE);
        Element old = JDomSerializationUtil.findComponent(root2, componentName);
        if (old != null) {
            root2.removeContent(old);
        }
        for (int i2 = 0; i2 < root2.getContent().size(); ++i2) {
            String name;
            Element element;
            Content o = root2.getContent().get(i2);
            if (!(o instanceof Element) || !(element = (Element)o).getName().equals(COMPONENT_ELEMENT) || componentName.compareTo(name = element.getAttributeValue(NAME_ATTRIBUTE)) >= 0) continue;
            root2.addContent(i2, component);
            return;
        }
        root2.addContent(component);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/JDomSerializationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/JDomSerializationUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateComponentElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateComponentElement";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

