/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.jarRepository;

import com.intellij.util.SmartList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoriesConfiguration;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoryDescription;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoryService;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;

public class JpsRemoteRepositoriesConfigurationSerializer
extends JpsProjectExtensionSerializer {
    private static final String ELEMENT_TAG = "remote-repository";
    private static final String OPTION_TAG = "option";
    private static final String ID_PROPERTY = "id";
    private static final String NAME_PROPERTY = "name";
    private static final String URL_PROPERTY = "url";

    public JpsRemoteRepositoriesConfigurationSerializer() {
        super("jarRepositories.xml", "RemoteRepositoriesConfiguration");
    }

    @Override
    public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
        if (project == null) {
            JpsRemoteRepositoriesConfigurationSerializer.$$$reportNull$$$0(0);
        }
        if (componentTag == null) {
            JpsRemoteRepositoriesConfigurationSerializer.$$$reportNull$$$0(1);
        }
        SmartList<JpsRemoteRepositoryDescription> result2 = new SmartList<JpsRemoteRepositoryDescription>();
        List<Element> children2 = componentTag.getChildren(ELEMENT_TAG);
        for (Element repoElement : children2) {
            String id = null;
            String name = null;
            String url = null;
            for (Element element : repoElement.getChildren(OPTION_TAG)) {
                String option2 = element.getAttributeValue(NAME_PROPERTY);
                String optionValue = element.getAttributeValue("value");
                if (ID_PROPERTY.equals(option2)) {
                    id = optionValue;
                    continue;
                }
                if (NAME_PROPERTY.equals(option2)) {
                    name = optionValue == null ? "" : optionValue;
                    continue;
                }
                if (!URL_PROPERTY.equals(option2)) continue;
                url = optionValue;
            }
            if (id == null || url == null) continue;
            result2.add(new JpsRemoteRepositoryDescription(id, name, url));
        }
        JpsRemoteRepositoriesConfiguration config = JpsRemoteRepositoryService.getInstance().getOrCreateRemoteRepositoriesConfiguration(project);
        if (!result2.isEmpty()) {
            config.setRepositories(result2);
        }
    }

    @Override
    public void saveExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
        if (project == null) {
            JpsRemoteRepositoriesConfigurationSerializer.$$$reportNull$$$0(2);
        }
        if (componentTag == null) {
            JpsRemoteRepositoriesConfigurationSerializer.$$$reportNull$$$0(3);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentTag";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/model/serialization/jarRepository/JpsRemoteRepositoriesConfigurationSerializer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadExtension";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "saveExtension";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

