/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import java.io.EOFException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.PackagePartProvider;
import org.jetbrains.kotlin.load.kotlin.ModuleMapping;
import org.jetbrains.kotlin.load.kotlin.PackageParts;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.CompilerDeserializationConfiguration;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f2\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u0013\u001a\u00020\u0012H\u0003R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider;", "Lorg/jetbrains/kotlin/descriptors/PackagePartProvider;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lcom/intellij/psi/search/GlobalSearchScope;)V", "deserializationConfiguration", "Lorg/jetbrains/kotlin/resolve/CompilerDeserializationConfiguration;", "loadedModules", "", "Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider$ModuleMappingInfo;", "addRoots", "", "roots", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "findMetadataPackageParts", "", "packageFqName", "findPackageParts", "getAnnotationsOnBinaryModule", "Lorg/jetbrains/kotlin/name/ClassId;", "moduleName", "getPackageParts", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/load/kotlin/PackageParts;", "ModuleMappingInfo", "cli"})
public final class JvmPackagePartProvider
implements PackagePartProvider {
    private final CompilerDeserializationConfiguration deserializationConfiguration;
    private final List<ModuleMappingInfo> loadedModules;
    private final GlobalSearchScope scope;

    @Override
    @NotNull
    public List<String> findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        Map<VirtualFile, PackageParts> rootToPackageParts = this.getPackageParts(packageFqName);
        if (rootToPackageParts.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        LinkedHashSet visitedMultifileFacades = new LinkedHashSet();
        Map<VirtualFile, PackageParts> map2 = rootToPackageParts;
        Iterator<Map.Entry<VirtualFile, PackageParts>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Iterable $receiver$iv;
            Map.Entry<VirtualFile, PackageParts> entry;
            Map.Entry<VirtualFile, PackageParts> entry2 = entry = iterator2.next();
            PackageParts packageParts = entry2.getValue();
            for (String name : packageParts.getParts()) {
                String facadeName = packageParts.getMultifileFacadeName(name);
                if (facadeName != null && visitedMultifileFacades.contains(facadeName)) continue;
                result2.add(name);
            }
            Iterable $receiver$iv$iv = $receiver$iv = (Iterable)packageParts.getParts();
            for (Object element$iv$iv : $receiver$iv$iv) {
                String string;
                Object element$iv = element$iv$iv;
                String p1 = (String)element$iv;
                if (packageParts.getMultifileFacadeName(p1) == null) continue;
                String it$iv = string;
                ((Collection)visitedMultifileFacades).add(it$iv);
            }
        }
        return CollectionsKt.toList((Iterable)result2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> findMetadataPackageParts(@NotNull String packageFqName) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        Iterable iterable = $receiver$iv = (Iterable)this.getPackageParts(packageFqName).values();
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object receiver = element$iv$iv = iterator2.next();
            Iterable list$iv$iv = ((PackageParts)receiver).getMetadataParts();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return CollectionsKt.distinct((List)destination$iv$iv);
    }

    private final synchronized Map<VirtualFile, PackageParts> getPackageParts(String packageFqName) {
        Map result2 = new LinkedHashMap();
        for (ModuleMappingInfo moduleMappingInfo : this.loadedModules) {
            PackageParts newParts;
            VirtualFile root2 = moduleMappingInfo.component1();
            ModuleMapping mapping2 = moduleMappingInfo.component2();
            if (mapping2.findPackageParts(packageFqName) == null) {
                continue;
            }
            if ((PackageParts)result2.get(root2) != null) {
                PackageParts packageParts;
                PackageParts parts = packageParts;
                parts.plusAssign(newParts);
                continue;
            }
            result2.put(root2, newParts);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ClassId> getAnnotationsOnBinaryModule(@NotNull String moduleName) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
        Iterable iterable = $receiver$iv = (Iterable)this.loadedModules;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            List<ClassId> list2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            ModuleMappingInfo $$_$_mapping_name = (ModuleMappingInfo)element$iv$iv;
            ModuleMapping mapping2 = $$_$_mapping_name.component2();
            String name = $$_$_mapping_name.component3();
            List<ClassId> list3 = Intrinsics.areEqual(name, moduleName) ? mapping2.getModuleData().getAnnotations() : null;
            if (list3 == null) continue;
            List<ClassId> it$iv$iv = list2 = list3;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.flatten((List)destination$iv$iv);
    }

    public final void addRoots(@NotNull List<JavaRoot> roots2) {
        Intrinsics.checkParameterIsNotNull(roots2, "roots");
        for (JavaRoot javaRoot : roots2) {
            VirtualFile metaInf;
            VirtualFile root2 = javaRoot.component1();
            JavaRoot.RootType type2 = javaRoot.component2();
            if (type2 != JavaRoot.RootType.BINARY || !this.scope.contains(root2)) continue;
            if (root2.findChild("META-INF") == null) {
                continue;
            }
            VirtualFile virtualFile2 = metaInf;
            Intrinsics.checkExpressionValueIsNotNull(virtualFile2, "metaInf");
            VirtualFile[] virtualFileArray = virtualFile2.getChildren();
            int n = virtualFileArray.length;
            for (int j = 0; j < n; ++j) {
                ModuleMapping moduleMapping;
                VirtualFile moduleFile;
                VirtualFile virtualFile3 = moduleFile = virtualFileArray[j];
                Intrinsics.checkExpressionValueIsNotNull(virtualFile3, "moduleFile");
                String string = virtualFile3.getName();
                Intrinsics.checkExpressionValueIsNotNull(string, "moduleFile.name");
                if (!StringsKt.endsWith$default(string, ModuleMapping.MAPPING_FILE_EXT, false, 2, null)) continue;
                try {
                    byte[] byArray = moduleFile.contentsToByteArray();
                    String string2 = moduleFile.toString();
                    Intrinsics.checkExpressionValueIsNotNull(string2, "moduleFile.toString()");
                    moduleMapping = ModuleMapping.Companion.create(byArray, string2, this.deserializationConfiguration);
                }
                catch (EOFException e) {
                    throw (Throwable)new RuntimeException("Error on reading package parts from " + moduleFile + " in " + root2, e);
                }
                ModuleMapping mapping2 = moduleMapping;
                String string3 = moduleFile.getNameWithoutExtension();
                Intrinsics.checkExpressionValueIsNotNull(string3, "moduleFile.nameWithoutExtension");
                this.loadedModules.add(new ModuleMappingInfo(root2, mapping2, string3));
            }
        }
    }

    public JvmPackagePartProvider(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        this.scope = scope;
        this.deserializationConfiguration = new CompilerDeserializationConfiguration(languageVersionSettings);
        this.loadedModules = new SmartList();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider$ModuleMappingInfo;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "mapping", "Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping;", "name", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping;Ljava/lang/String;)V", "getMapping", "()Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping;", "getName", "()Ljava/lang/String;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "cli"})
    private static final class ModuleMappingInfo {
        @NotNull
        private final VirtualFile root;
        @NotNull
        private final ModuleMapping mapping;
        @NotNull
        private final String name;

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @NotNull
        public final ModuleMapping getMapping() {
            return this.mapping;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public ModuleMappingInfo(@NotNull VirtualFile root2, @NotNull ModuleMapping mapping2, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull(root2, "root");
            Intrinsics.checkParameterIsNotNull(mapping2, "mapping");
            Intrinsics.checkParameterIsNotNull(name, "name");
            this.root = root2;
            this.mapping = mapping2;
            this.name = name;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.root;
        }

        @NotNull
        public final ModuleMapping component2() {
            return this.mapping;
        }

        @NotNull
        public final String component3() {
            return this.name;
        }

        @NotNull
        public final ModuleMappingInfo copy(@NotNull VirtualFile root2, @NotNull ModuleMapping mapping2, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull(root2, "root");
            Intrinsics.checkParameterIsNotNull(mapping2, "mapping");
            Intrinsics.checkParameterIsNotNull(name, "name");
            return new ModuleMappingInfo(root2, mapping2, name);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ModuleMappingInfo copy$default(ModuleMappingInfo moduleMappingInfo, VirtualFile virtualFile2, ModuleMapping moduleMapping, String string, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile2 = moduleMappingInfo.root;
            }
            if ((n & 2) != 0) {
                moduleMapping = moduleMappingInfo.mapping;
            }
            if ((n & 4) != 0) {
                string = moduleMappingInfo.name;
            }
            return moduleMappingInfo.copy(virtualFile2, moduleMapping, string);
        }

        public String toString() {
            return "ModuleMappingInfo(root=" + this.root + ", mapping=" + this.mapping + ", name=" + this.name + ")";
        }

        public int hashCode() {
            VirtualFile virtualFile2 = this.root;
            ModuleMapping moduleMapping = this.mapping;
            String string = this.name;
            return ((virtualFile2 != null ? virtualFile2.hashCode() : 0) * 31 + (moduleMapping != null ? moduleMapping.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ModuleMappingInfo)) break block3;
                    ModuleMappingInfo moduleMappingInfo = (ModuleMappingInfo)object;
                    if (!Intrinsics.areEqual(this.root, moduleMappingInfo.root) || !Intrinsics.areEqual(this.mapping, moduleMappingInfo.mapping) || !Intrinsics.areEqual(this.name, moduleMappingInfo.name)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

