/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.storage.ProtoMapValue;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ProtoMapValueExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "Lorg/jetbrains/kotlin/incremental/storage/ProtoMapValue;", "()V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "value", "kotlin-build-common"})
public final class ProtoMapValueExternalizer
implements DataExternalizer<ProtoMapValue> {
    public static final ProtoMapValueExternalizer INSTANCE;

    @Override
    public void save(@NotNull DataOutput output2, @NotNull ProtoMapValue value) {
        Intrinsics.checkParameterIsNotNull(output2, "output");
        Intrinsics.checkParameterIsNotNull(value, "value");
        output2.writeBoolean(value.isPackageFacade());
        output2.writeInt(value.getBytes().length);
        output2.write(value.getBytes());
        output2.writeInt(((Object[])value.getStrings()).length);
        for (String string : value.getStrings()) {
            output2.writeUTF(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ProtoMapValue read(@NotNull DataInput input2) {
        Intrinsics.checkParameterIsNotNull(input2, "input");
        boolean isPackageFacade = input2.readBoolean();
        int bytesLength = input2.readInt();
        byte[] bytes = new byte[bytesLength];
        input2.readFully(bytes, 0, bytesLength);
        int stringsLength = input2.readInt();
        String[] result$iv = new String[stringsLength];
        int n = 0;
        int n2 = result$iv.length;
        while (n < n2) {
            String string;
            void i$iv;
            void var10_9 = i$iv;
            void var14_11 = i$iv++;
            String[] stringArray = result$iv;
            Intrinsics.checkExpressionValueIsNotNull(input2.readUTF(), "input.readUTF()");
            stringArray[var14_11] = string;
        }
        String[] strings = result$iv;
        return new ProtoMapValue(isPackageFacade, bytes, strings);
    }

    private ProtoMapValueExternalizer() {
    }

    static {
        ProtoMapValueExternalizer protoMapValueExternalizer;
        INSTANCE = protoMapValueExternalizer = new ProtoMapValueExternalizer();
    }
}

