/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenCondition;

public class KtWhenConditionInRange
extends KtWhenCondition {
    public KtWhenConditionInRange(@NotNull ASTNode node) {
        super(node);
    }

    public boolean isNegated() {
        return this.getNode().findChildByType(KtTokens.NOT_IN) != null;
    }

    @IfNotParsed
    @Nullable
    public KtExpression getRangeExpression() {
        for (ASTNode node = this.getOperationReference().getNode().getTreeNext(); node != null; node = node.getTreeNext()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof KtExpression)) continue;
            return (KtExpression)psi;
        }
        return null;
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        return visitor2.visitWhenConditionInRange(this, data2);
    }

    @NotNull
    public KtOperationReferenceExpression getOperationReference() {
        return (KtOperationReferenceExpression)this.findChildByType(KtNodeTypes.OPERATION_REFERENCE);
    }
}

