/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.ControlFlowInformationProvider;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.checkers.PlatformDiagnosticSuppressor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

public class ControlFlowAnalyzer {
    private final BindingTrace trace;
    private final KotlinBuiltIns builtIns;
    private final LanguageVersionSettings languageVersionSettings;
    private final PlatformDiagnosticSuppressor diagnosticSuppressor;

    public ControlFlowAnalyzer(@NotNull BindingTrace trace2, @NotNull KotlinBuiltIns builtIns, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull PlatformDiagnosticSuppressor diagnosticSuppressor) {
        this.trace = trace2;
        this.builtIns = builtIns;
        this.languageVersionSettings = languageVersionSettings;
        this.diagnosticSuppressor = diagnosticSuppressor;
    }

    public void process(@NotNull BodiesResolveContext c) {
        for (KtFile ktFile : c.getFiles()) {
            this.checkDeclarationContainer(c, ktFile);
        }
        for (KtClassOrObject ktClassOrObject : c.getDeclaredClasses().keySet()) {
            this.checkDeclarationContainer(c, ktClassOrObject);
        }
        for (KtScript ktScript : c.getScripts().keySet()) {
            this.checkDeclarationContainer(c, ktScript);
        }
        for (KtSecondaryConstructor ktSecondaryConstructor : c.getSecondaryConstructors().keySet()) {
            this.checkSecondaryConstructor(ktSecondaryConstructor);
        }
        for (Map.Entry entry : c.getFunctions().entrySet()) {
            KtNamedFunction function2 = (KtNamedFunction)entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)entry.getValue();
            KotlinType expectedReturnType = !function2.hasBlockBody() && !function2.hasDeclaredReturnType() ? TypeUtils.NO_EXPECTED_TYPE : functionDescriptor.getReturnType();
            this.checkFunction(c, function2, expectedReturnType);
        }
        for (Map.Entry entry : c.getProperties().entrySet()) {
            KtProperty property = (KtProperty)entry.getKey();
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getValue();
            this.checkProperty(c, property, propertyDescriptor);
        }
    }

    private void checkSecondaryConstructor(@NotNull KtSecondaryConstructor constructor) {
        ControlFlowInformationProvider controlFlowInformationProvider = new ControlFlowInformationProvider(constructor, this.trace, this.languageVersionSettings, this.diagnosticSuppressor);
        controlFlowInformationProvider.checkDeclaration();
        controlFlowInformationProvider.checkFunction(this.builtIns.getUnitType());
    }

    private void checkDeclarationContainer(@NotNull BodiesResolveContext c, KtDeclarationContainer declarationContainer) {
        ControlFlowInformationProvider controlFlowInformationProvider = new ControlFlowInformationProvider((KtElement)((Object)declarationContainer), this.trace, this.languageVersionSettings, this.diagnosticSuppressor);
        if (c.getTopDownAnalysisMode().isLocalDeclarations()) {
            controlFlowInformationProvider.checkForLocalClassOrObjectMode();
            return;
        }
        controlFlowInformationProvider.checkDeclaration();
    }

    private void checkProperty(@NotNull BodiesResolveContext c, KtProperty property, PropertyDescriptor propertyDescriptor) {
        for (KtPropertyAccessor accessor : property.getAccessors()) {
            PropertyAccessorDescriptor accessorDescriptor;
            PropertyAccessorDescriptor propertyAccessorDescriptor = accessorDescriptor = accessor.isGetter() ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
            assert (accessorDescriptor != null) : "no property accessor descriptor " + accessor.getText();
            KotlinType returnType = accessorDescriptor.getReturnType();
            this.checkFunction(c, accessor, returnType);
        }
    }

    private void checkFunction(@NotNull BodiesResolveContext c, @NotNull KtDeclarationWithBody function2, @Nullable KotlinType expectedReturnType) {
        ControlFlowInformationProvider controlFlowInformationProvider = new ControlFlowInformationProvider(function2, this.trace, this.languageVersionSettings, this.diagnosticSuppressor);
        if (c.getTopDownAnalysisMode().isLocalDeclarations()) {
            controlFlowInformationProvider.checkForLocalClassOrObjectMode();
            return;
        }
        controlFlowInformationProvider.checkDeclaration();
        controlFlowInformationProvider.checkFunction(expectedReturnType);
    }
}

