/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SupertypeLoopChecker;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationSplitter;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.CompositeAnnotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationReturnTypeSanitizer;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.TypeAliasExpansionReportStrategy;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.VariableAsPropertyInfo;
import org.jetbrains.kotlin.resolve.VariableTypeAndInitializerResolver;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.extensions.SyntheticResolveExtension;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyTypeAliasDescriptor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.ScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.TypeApproximator;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.WrappedTypeFactory;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.DestructuringDeclarationResolver;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitor;
import org.jetbrains.kotlin.types.expressions.PreliminaryDeclarationVisitor;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class DescriptorResolver {
    private final TypeResolver typeResolver;
    private final AnnotationResolver annotationResolver;
    private final StorageManager storageManager;
    private final KotlinBuiltIns builtIns;
    private final SupertypeLoopChecker supertypeLoopsResolver;
    private final VariableTypeAndInitializerResolver variableTypeAndInitializerResolver;
    private final ExpressionTypingServices expressionTypingServices;
    private final OverloadChecker overloadChecker;
    private final LanguageVersionSettings languageVersionSettings;
    private final FunctionsTypingVisitor functionsTypingVisitor;
    private final DestructuringDeclarationResolver destructuringDeclarationResolver;
    private final ModifiersChecker modifiersChecker;
    private final WrappedTypeFactory wrappedTypeFactory;
    private final SyntheticResolveExtension syntheticResolveExtension;
    private final TypeApproximator typeApproximator;
    private final DeclarationReturnTypeSanitizer declarationReturnTypeSanitizer;
    private final DataFlowValueFactory dataFlowValueFactory;

    public DescriptorResolver(@NotNull AnnotationResolver annotationResolver, @NotNull KotlinBuiltIns builtIns, @NotNull StorageManager storageManager, @NotNull TypeResolver typeResolver, @NotNull SupertypeLoopChecker supertypeLoopsResolver, @NotNull VariableTypeAndInitializerResolver variableTypeAndInitializerResolver, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull OverloadChecker overloadChecker, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull FunctionsTypingVisitor functionsTypingVisitor, @NotNull DestructuringDeclarationResolver destructuringDeclarationResolver, @NotNull ModifiersChecker modifiersChecker, @NotNull WrappedTypeFactory wrappedTypeFactory, @NotNull Project project, @NotNull TypeApproximator approximator, @NotNull DeclarationReturnTypeSanitizer declarationReturnTypeSanitizer, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        this.annotationResolver = annotationResolver;
        this.builtIns = builtIns;
        this.storageManager = storageManager;
        this.typeResolver = typeResolver;
        this.supertypeLoopsResolver = supertypeLoopsResolver;
        this.variableTypeAndInitializerResolver = variableTypeAndInitializerResolver;
        this.expressionTypingServices = expressionTypingServices;
        this.overloadChecker = overloadChecker;
        this.languageVersionSettings = languageVersionSettings;
        this.functionsTypingVisitor = functionsTypingVisitor;
        this.destructuringDeclarationResolver = destructuringDeclarationResolver;
        this.modifiersChecker = modifiersChecker;
        this.wrappedTypeFactory = wrappedTypeFactory;
        this.syntheticResolveExtension = SyntheticResolveExtension.Companion.getInstance(project);
        this.typeApproximator = approximator;
        this.declarationReturnTypeSanitizer = declarationReturnTypeSanitizer;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }

    public List<KotlinType> resolveSupertypes(@NotNull LexicalScope scope, @NotNull ClassDescriptor classDescriptor, @Nullable KtPureClassOrObject correspondingClassOrObject, BindingTrace trace2) {
        ArrayList<KotlinType> supertypes2 = Lists.newArrayList();
        List<KtSuperTypeListEntry> delegationSpecifiers = correspondingClassOrObject == null ? Collections.emptyList() : correspondingClassOrObject.getSuperTypeListEntries();
        Collection<KotlinType> declaredSupertypes = DescriptorResolver.resolveSuperTypeListEntries(scope, delegationSpecifiers, this.typeResolver, trace2, false);
        for (KotlinType declaredSupertype : declaredSupertypes) {
            DescriptorResolver.addValidSupertype(supertypes2, declaredSupertype);
        }
        if (classDescriptor.getKind() == ClassKind.ENUM_CLASS && !DescriptorResolver.containsClass(supertypes2)) {
            supertypes2.add(0, this.builtIns.getEnumType(classDescriptor.getDefaultType()));
        }
        this.syntheticResolveExtension.addSyntheticSupertypes(classDescriptor, supertypes2);
        if (supertypes2.isEmpty()) {
            DescriptorResolver.addValidSupertype(supertypes2, this.getDefaultSupertype(classDescriptor));
        }
        return supertypes2;
    }

    private static void addValidSupertype(List<KotlinType> supertypes2, KotlinType declaredSupertype) {
        if (!KotlinTypeKt.isError(declaredSupertype)) {
            supertypes2.add(declaredSupertype);
        }
    }

    private static boolean containsClass(Collection<KotlinType> result2) {
        for (KotlinType type2 : result2) {
            ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
            if (!(descriptor2 instanceof ClassDescriptor) || ((ClassDescriptor)descriptor2).getKind() == ClassKind.INTERFACE) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private KotlinType getDefaultSupertype(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor.getKind() == ClassKind.ENUM_ENTRY) {
            return ((ClassDescriptor)classDescriptor.getContainingDeclaration()).getDefaultType();
        }
        if (classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS) {
            return this.builtIns.getAnnotationType();
        }
        return this.builtIns.getAnyType();
    }

    private static Collection<KotlinType> resolveSuperTypeListEntries(LexicalScope extensibleScope, List<KtSuperTypeListEntry> delegationSpecifiers, @NotNull TypeResolver resolver2, BindingTrace trace2, boolean checkBounds) {
        if (delegationSpecifiers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<KotlinType> result2 = Lists.newArrayList();
        for (KtSuperTypeListEntry delegationSpecifier : delegationSpecifiers) {
            KtTypeReference typeReference = delegationSpecifier.getTypeReference();
            if (typeReference != null) {
                KotlinType supertype = resolver2.resolveType(extensibleScope, typeReference, trace2, checkBounds);
                if (DynamicTypesKt.isDynamic(supertype)) {
                    trace2.report(Errors.DYNAMIC_SUPERTYPE.on(typeReference));
                    continue;
                }
                result2.add(supertype);
                KtTypeElement bareSuperType = DescriptorResolver.checkNullableSupertypeAndStripQuestionMarks(trace2, typeReference.getTypeElement());
                DescriptorResolver.checkProjectionsInImmediateArguments(trace2, bareSuperType, supertype);
                continue;
            }
            result2.add(ErrorUtils.createErrorType("No type reference"));
        }
        return result2;
    }

    @Nullable
    private static KtTypeElement checkNullableSupertypeAndStripQuestionMarks(@NotNull BindingTrace trace2, @Nullable KtTypeElement typeElement) {
        while (typeElement instanceof KtNullableType) {
            KtNullableType nullableType = (KtNullableType)typeElement;
            if ((typeElement = nullableType.getInnerType()) instanceof KtNullableType || typeElement == null) continue;
            trace2.report(Errors.NULLABLE_SUPERTYPE.on(nullableType));
        }
        return typeElement;
    }

    private static void checkProjectionsInImmediateArguments(@NotNull BindingTrace trace2, @Nullable KtTypeElement typeElement, @NotNull KotlinType type2) {
        if (typeElement == null) {
            return;
        }
        boolean hasProjectionsInWrittenArguments = false;
        if (typeElement instanceof KtUserType) {
            KtUserType userType = (KtUserType)typeElement;
            List<KtTypeProjection> typeArguments2 = userType.getTypeArguments();
            for (KtTypeProjection typeArgument : typeArguments2) {
                if (typeArgument.getProjectionKind() == KtProjectionKind.NONE) continue;
                trace2.report(Errors.PROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE.on(typeArgument));
                hasProjectionsInWrittenArguments = true;
            }
        }
        if (!KotlinTypeKt.isError(type2) && SpecialTypesKt.getAbbreviatedType(type2) != null && !hasProjectionsInWrittenArguments && TypeUtilsKt.isInterface(type2) && TypeUtilsKt.containsTypeProjectionsInTopLevelArguments(type2)) {
            trace2.report(Errors.EXPANDED_TYPE_CANNOT_BE_INHERITED.on(typeElement, type2));
        }
    }

    public static Visibility getDefaultVisibility(KtModifierListOwner modifierListOwner, DeclarationDescriptor containingDescriptor) {
        KtModifierList modifierList;
        Visibility defaultVisibility = containingDescriptor instanceof ClassDescriptor ? ((modifierList = modifierListOwner.getModifierList()) != null && modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD) ? Visibilities.INHERITED : Visibilities.DEFAULT_VISIBILITY) : (containingDescriptor instanceof FunctionDescriptor || containingDescriptor instanceof PropertyDescriptor ? Visibilities.LOCAL : Visibilities.DEFAULT_VISIBILITY);
        return defaultVisibility;
    }

    public static Modality getDefaultModality(DeclarationDescriptor containingDescriptor, Visibility visibility, boolean isBodyPresent) {
        Modality defaultModality;
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean isTrait = ((ClassDescriptor)containingDescriptor).getKind() == ClassKind.INTERFACE;
            boolean isDefinitelyAbstract = isTrait && !isBodyPresent;
            Modality basicModality = isTrait && !Visibilities.isPrivate(visibility) ? Modality.OPEN : Modality.FINAL;
            defaultModality = isDefinitelyAbstract ? Modality.ABSTRACT : basicModality;
        } else {
            defaultModality = Modality.FINAL;
        }
        return defaultModality;
    }

    @NotNull
    public ValueParameterDescriptorImpl resolveValueParameterDescriptor(@NotNull LexicalScope scope, @NotNull FunctionDescriptor owner, @NotNull KtParameter valueParameter, int index2, @NotNull KotlinType type2, @NotNull BindingTrace trace2) {
        Function0<List> destructuringVariables;
        KtDestructuringDeclaration destructuringDeclaration;
        KotlinType varargElementType = null;
        KotlinType variableType = type2;
        if (valueParameter.hasModifier(KtTokens.VARARG_KEYWORD)) {
            varargElementType = type2;
            variableType = this.getVarargParameterType(type2);
        }
        KtModifierList modifierList = valueParameter.getModifierList();
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scope, valueParameter.getModifierList(), trace2);
        Annotations valueParameterAnnotations = Annotations.Companion.getEMPTY();
        if (modifierList != null) {
            if (valueParameter.hasValOrVar()) {
                AnnotationSplitter annotationSplitter = AnnotationSplitter.create(this.storageManager, allAnnotations, SetsKt.setOf(AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER));
                valueParameterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER);
            } else {
                valueParameterAnnotations = allAnnotations;
            }
        }
        if ((destructuringDeclaration = valueParameter.getDestructuringDeclaration()) != null) {
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.DestructuringLambdaParameters)) {
                trace2.report(Errors.UNSUPPORTED_FEATURE.on(valueParameter, TuplesKt.to(LanguageFeature.DestructuringLambdaParameters, this.languageVersionSettings)));
            }
            destructuringVariables = () -> {
                assert (owner.getDispatchReceiverParameter() == null) : "Destructuring declarations are only be parsed for lambdas, and they must not have a dispatch receiver";
                LexicalScope scopeForDestructuring = ScopeUtilsKt.createScopeForDestructuring(scope, owner.getExtensionReceiverParameter());
                List<VariableDescriptor> result2 = this.destructuringDeclarationResolver.resolveLocalVariablesFromDestructuringDeclaration(scope, destructuringDeclaration, new TransientReceiver(type2), null, ExpressionTypingContext.newContext(trace2, scopeForDestructuring, DataFlowInfoFactory.EMPTY, TypeUtils.NO_EXPECTED_TYPE, this.languageVersionSettings, this.dataFlowValueFactory));
                this.modifiersChecker.withTrace(trace2).checkModifiersForDestructuringDeclaration(destructuringDeclaration);
                return result2;
            };
        } else {
            destructuringVariables = null;
        }
        Name parameterName = destructuringDeclaration == null ? (!valueParameter.hasValOrVar() && UnderscoreUtilKt.isSingleUnderscore(valueParameter) ? Name.special("<anonymous parameter " + index2 + ">") : KtPsiUtil.safeName(valueParameter.getName())) : Name.special("<name for destructuring parameter " + index2 + ">");
        ValueParameterDescriptorImpl valueParameterDescriptor = ValueParameterDescriptorImpl.createWithDestructuringDeclarations(owner, null, index2, valueParameterAnnotations, parameterName, variableType, valueParameter.hasDefaultValue(), valueParameter.hasModifier(KtTokens.CROSSINLINE_KEYWORD), valueParameter.hasModifier(KtTokens.NOINLINE_KEYWORD), varargElementType, KotlinSourceElementKt.toSourceElement(valueParameter), destructuringVariables);
        trace2.record(BindingContext.VALUE_PARAMETER, valueParameter, valueParameterDescriptor);
        return valueParameterDescriptor;
    }

    @NotNull
    private KotlinType getVarargParameterType(@NotNull KotlinType elementType) {
        SimpleType primitiveArrayType = this.builtIns.getPrimitiveArrayKotlinTypeByPrimitiveKotlinType(elementType);
        if (primitiveArrayType != null) {
            return primitiveArrayType;
        }
        return this.builtIns.getArrayType(Variance.OUT_VARIANCE, elementType);
    }

    public List<TypeParameterDescriptorImpl> resolveTypeParametersForDescriptor(DeclarationDescriptor containingDescriptor, LexicalWritableScope extensibleScope, LexicalScope scopeForAnnotationsResolve, List<KtTypeParameter> typeParameters2, BindingTrace trace2) {
        List<TypeParameterDescriptorImpl> descriptors = this.resolveTypeParametersForDescriptor(containingDescriptor, scopeForAnnotationsResolve, typeParameters2, trace2);
        for (TypeParameterDescriptorImpl descriptor2 : descriptors) {
            extensibleScope.addClassifierDescriptor(descriptor2);
        }
        return descriptors;
    }

    private List<TypeParameterDescriptorImpl> resolveTypeParametersForDescriptor(DeclarationDescriptor containingDescriptor, LexicalScope scopeForAnnotationsResolve, List<KtTypeParameter> typeParameters2, BindingTrace trace2) {
        assert (containingDescriptor instanceof FunctionDescriptor || containingDescriptor instanceof PropertyDescriptor || containingDescriptor instanceof TypeAliasDescriptor) : "This method should be called for functions, properties, or type aliases, got " + containingDescriptor;
        ArrayList<TypeParameterDescriptorImpl> result2 = new ArrayList<TypeParameterDescriptorImpl>();
        int typeParametersSize = typeParameters2.size();
        for (int i2 = 0; i2 < typeParametersSize; ++i2) {
            KtTypeParameter typeParameter = typeParameters2.get(i2);
            result2.add(this.resolveTypeParameterForDescriptor(containingDescriptor, scopeForAnnotationsResolve, typeParameter, i2, trace2));
        }
        return result2;
    }

    private TypeParameterDescriptorImpl resolveTypeParameterForDescriptor(DeclarationDescriptor containingDescriptor, LexicalScope scopeForAnnotationsResolve, KtTypeParameter typeParameter, int index2, BindingTrace trace2) {
        if (typeParameter.getVariance() != Variance.INVARIANT) {
            trace2.report(Errors.VARIANCE_ON_TYPE_PARAMETER_NOT_ALLOWED.on(typeParameter));
        }
        Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithArguments(scopeForAnnotationsResolve, typeParameter.getModifierList(), trace2);
        TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(containingDescriptor, annotations2, typeParameter.hasModifier(KtTokens.REIFIED_KEYWORD), typeParameter.getVariance(), KtPsiUtil.safeName(typeParameter.getName()), index2, KotlinSourceElementKt.toSourceElement(typeParameter), type2 -> {
            if (!(containingDescriptor instanceof TypeAliasDescriptor)) {
                trace2.report(Errors.CYCLIC_GENERIC_UPPER_BOUND.on(typeParameter));
            }
            return null;
        }, this.supertypeLoopsResolver);
        trace2.record(BindingContext.TYPE_PARAMETER, typeParameter, typeParameterDescriptor);
        return typeParameterDescriptor;
    }

    @NotNull
    public static ClassConstructorDescriptorImpl createAndRecordPrimaryConstructorForObject(@Nullable KtPureClassOrObject object, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace2) {
        ClassConstructorDescriptorImpl constructorDescriptor = DescriptorFactory.createPrimaryConstructorForObject(classDescriptor, KotlinSourceElementKt.toSourceElement(object));
        if (object instanceof PsiElement) {
            KtPrimaryConstructor primaryConstructor2 = object.getPrimaryConstructor();
            trace2.record(BindingContext.CONSTRUCTOR, primaryConstructor2 != null ? primaryConstructor2 : (PsiElement)((Object)object), constructorDescriptor);
        }
        return constructorDescriptor;
    }

    public void resolveGenericBounds(@NotNull KtTypeParameterListOwner declaration, @NotNull DeclarationDescriptor descriptor2, LexicalScope scope, List<TypeParameterDescriptorImpl> parameters2, BindingTrace trace2) {
        ArrayList<UpperBoundCheckRequest> upperBoundCheckRequests = Lists.newArrayList();
        List<KtTypeParameter> typeParameters2 = declaration.getTypeParameters();
        HashMap<Name, TypeParameterDescriptorImpl> parameterByName = Maps.newHashMap();
        for (int i2 = 0; i2 < typeParameters2.size(); ++i2) {
            KtTypeParameter ktTypeParameter = typeParameters2.get(i2);
            TypeParameterDescriptorImpl typeParameterDescriptor = parameters2.get(i2);
            parameterByName.put(typeParameterDescriptor.getName(), typeParameterDescriptor);
            KtTypeReference extendsBound = ktTypeParameter.getExtendsBound();
            if (extendsBound == null) continue;
            KotlinType type2 = this.typeResolver.resolveType(scope, extendsBound, trace2, false);
            typeParameterDescriptor.addUpperBound(type2);
            upperBoundCheckRequests.add(new UpperBoundCheckRequest(ktTypeParameter.getNameAsName(), extendsBound, type2));
        }
        for (KtTypeConstraint constraint : declaration.getTypeConstraints()) {
            KtSimpleNameExpression subjectTypeParameterName = constraint.getSubjectTypeParameterName();
            if (subjectTypeParameterName == null) continue;
            Name referencedName = subjectTypeParameterName.getReferencedNameAsName();
            TypeParameterDescriptorImpl typeParameterDescriptor = (TypeParameterDescriptorImpl)parameterByName.get(referencedName);
            KtTypeReference boundTypeReference = constraint.getBoundTypeReference();
            KotlinType bound = null;
            if (boundTypeReference != null) {
                bound = this.typeResolver.resolveType(scope, boundTypeReference, trace2, false);
                upperBoundCheckRequests.add(new UpperBoundCheckRequest(referencedName, boundTypeReference, bound));
            }
            if (typeParameterDescriptor == null) continue;
            trace2.record(BindingContext.REFERENCE_TARGET, subjectTypeParameterName, typeParameterDescriptor);
            if (bound == null) continue;
            typeParameterDescriptor.addUpperBound(bound);
        }
        for (TypeParameterDescriptorImpl parameter : parameters2) {
            parameter.addDefaultUpperBound();
            parameter.setInitialized();
        }
        for (TypeParameterDescriptorImpl parameter : parameters2) {
            DescriptorResolver.checkConflictingUpperBounds(trace2, parameter, typeParameters2.get(parameter.getIndex()));
        }
        if (!(declaration instanceof KtClass)) {
            DescriptorResolver.checkUpperBoundTypes(trace2, upperBoundCheckRequests);
            this.checkNamesInConstraints(declaration, descriptor2, scope, trace2);
        }
    }

    public static void checkUpperBoundTypes(@NotNull BindingTrace trace2, @NotNull List<UpperBoundCheckRequest> requests) {
        if (requests.isEmpty()) {
            return;
        }
        HashSet<Name> classBoundEncountered = new HashSet<Name>();
        HashSet<Pair<Name, TypeConstructor>> allBounds = new HashSet<Pair<Name, TypeConstructor>>();
        for (UpperBoundCheckRequest request : requests) {
            Name typeParameterName = request.typeParameterName;
            KotlinType upperBound = request.upperBoundType;
            KtTypeReference upperBoundElement = request.upperBound;
            if (!KotlinTypeKt.isError(upperBound)) {
                if (!allBounds.add(new Pair<Name, TypeConstructor>(typeParameterName, upperBound.getConstructor()))) {
                    trace2.report(Errors.REPEATED_BOUND.on(upperBoundElement));
                } else {
                    ClassKind kind;
                    ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(upperBound);
                    if (!(classDescriptor == null || (kind = classDescriptor.getKind()) != ClassKind.CLASS && kind != ClassKind.ENUM_CLASS && kind != ClassKind.OBJECT || classBoundEncountered.add(typeParameterName))) {
                        trace2.report(Errors.ONLY_ONE_CLASS_BOUND_ALLOWED.on(upperBoundElement));
                    }
                }
            }
            DescriptorResolver.checkUpperBoundType(upperBoundElement, upperBound, trace2);
        }
    }

    public static void checkConflictingUpperBounds(@NotNull BindingTrace trace2, @NotNull TypeParameterDescriptor parameter, @NotNull KtTypeParameter typeParameter) {
        if (KotlinBuiltIns.isNothing(TypeIntersector.getUpperBoundsAsType(parameter))) {
            trace2.report(Errors.CONFLICTING_UPPER_BOUNDS.on(typeParameter, parameter));
        }
    }

    public void checkNamesInConstraints(@NotNull KtTypeParameterListOwner declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull LexicalScope scope, @NotNull BindingTrace trace2) {
        for (KtTypeConstraint constraint : declaration.getTypeConstraints()) {
            KtTypeReference boundTypeReference;
            Name name;
            ClassifierDescriptor classifier2;
            KtSimpleNameExpression nameExpression = constraint.getSubjectTypeParameterName();
            if (nameExpression == null || (classifier2 = ScopeUtilsKt.findClassifier(scope, name = nameExpression.getReferencedNameAsName(), NoLookupLocation.FOR_NON_TRACKED_SCOPE)) instanceof TypeParameterDescriptor && classifier2.getContainingDeclaration() == descriptor2) continue;
            if (classifier2 != null) {
                trace2.report(Errors.NAME_IN_CONSTRAINT_IS_NOT_A_TYPE_PARAMETER.on(nameExpression, constraint, declaration));
                trace2.record(BindingContext.REFERENCE_TARGET, nameExpression, classifier2);
            } else {
                trace2.report(Errors.UNRESOLVED_REFERENCE.on(nameExpression, nameExpression));
            }
            if ((boundTypeReference = constraint.getBoundTypeReference()) == null) continue;
            this.typeResolver.resolveType(scope, boundTypeReference, trace2, true);
        }
    }

    public static void checkUpperBoundType(KtTypeReference upperBound, @NotNull KotlinType upperBoundType, BindingTrace trace2) {
        if (!TypeUtils.canHaveSubtypes(KotlinTypeChecker.DEFAULT, upperBoundType)) {
            trace2.report(Errors.FINAL_UPPER_BOUND.on(upperBound, upperBoundType));
        }
        if (DynamicTypesKt.isDynamic(upperBoundType)) {
            trace2.report(Errors.DYNAMIC_UPPER_BOUND.on(upperBound));
        }
        if (FunctionTypesKt.isExtensionFunctionType(upperBoundType)) {
            trace2.report(Errors.UPPER_BOUND_IS_EXTENSION_FUNCTION_TYPE.on(upperBound));
        }
    }

    @NotNull
    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull LexicalScope scope, @NotNull KtParameter parameter, BindingTrace trace2) {
        KotlinType type2 = this.resolveParameterType(scope, parameter, trace2);
        return this.resolveLocalVariableDescriptor(parameter, type2, trace2, scope);
    }

    private KotlinType resolveParameterType(LexicalScope scope, KtParameter parameter, BindingTrace trace2) {
        KtTypeReference typeReference = parameter.getTypeReference();
        KotlinType type2 = typeReference != null ? this.typeResolver.resolveType(scope, typeReference, trace2, true) : ErrorUtils.createErrorType("Annotation is absent");
        if (parameter.hasModifier(KtTokens.VARARG_KEYWORD)) {
            return this.getVarargParameterType(type2);
        }
        return type2;
    }

    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull KtParameter parameter, @NotNull KotlinType type2, BindingTrace trace2, @NotNull LexicalScope scope) {
        UnwrappedType approximatedType = this.typeApproximator.approximateDeclarationType(type2, true, this.languageVersionSettings);
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(scope.getOwnerDescriptor(), this.annotationResolver.resolveAnnotationsWithArguments(scope, parameter.getModifierList(), trace2), KtPsiUtil.safeName(parameter.getName()), approximatedType, KotlinSourceElementKt.toSourceElement(parameter));
        trace2.record(BindingContext.VALUE_PARAMETER, parameter, variableDescriptor);
        ForceResolveUtil.forceResolveAllContents(type2.getAnnotations());
        return variableDescriptor;
    }

    @NotNull
    public TypeAliasDescriptor resolveTypeAliasDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull LexicalScope scope, @NotNull KtTypeAlias typeAlias, @NotNull BindingTrace trace2) {
        List<TypeParameterDescriptorImpl> typeParameterDescriptors;
        LexicalScope scopeWithTypeParameters;
        if (!(containingDeclaration instanceof PackageFragmentDescriptor) && !(containingDeclaration instanceof ScriptDescriptor)) {
            trace2.report(Errors.TOPLEVEL_TYPEALIASES_ONLY.on(typeAlias));
        }
        KtModifierList modifierList = typeAlias.getModifierList();
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(typeAlias, DescriptorResolver.getDefaultVisibility(typeAlias, containingDeclaration));
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithArguments(scope, modifierList, trace2);
        Name name = KtPsiUtil.safeName(typeAlias.getName());
        SourceElement sourceElement = KotlinSourceElementKt.toSourceElement(typeAlias);
        LazyTypeAliasDescriptor typeAliasDescriptor = LazyTypeAliasDescriptor.create(this.storageManager, trace2, containingDeclaration, allAnnotations, name, sourceElement, visibility);
        List<KtTypeParameter> typeParameters2 = typeAlias.getTypeParameters();
        if (typeParameters2.isEmpty()) {
            scopeWithTypeParameters = scope;
            typeParameterDescriptors = Collections.emptyList();
        } else {
            LexicalWritableScope writableScope = new LexicalWritableScope(scope, containingDeclaration, false, new TraceBasedLocalRedeclarationChecker(trace2, this.overloadChecker), LexicalScopeKind.TYPE_ALIAS_HEADER);
            typeParameterDescriptors = this.resolveTypeParametersForDescriptor(typeAliasDescriptor, writableScope, scope, typeParameters2, trace2);
            writableScope.freeze();
            DescriptorResolver.checkNoGenericBoundsOnTypeAliasParameters(typeAlias, trace2);
            this.resolveGenericBounds(typeAlias, typeAliasDescriptor, writableScope, typeParameterDescriptors, trace2);
            scopeWithTypeParameters = writableScope;
        }
        KtTypeReference typeReference = typeAlias.getTypeReference();
        if (typeReference == null) {
            typeAliasDescriptor.initialize(typeParameterDescriptors, ErrorUtils.createErrorType(name.asString()), ErrorUtils.createErrorType(name.asString()));
        } else if (!this.languageVersionSettings.supportsFeature(LanguageFeature.TypeAliases)) {
            this.typeResolver.resolveAbbreviatedType(scopeWithTypeParameters, typeReference, trace2);
            PsiElement typeAliasKeyword = typeAlias.getTypeAliasKeyword();
            trace2.report(Errors.UNSUPPORTED_FEATURE.on(typeAliasKeyword != null ? typeAliasKeyword : typeAlias, TuplesKt.to(LanguageFeature.TypeAliases, this.languageVersionSettings)));
            typeAliasDescriptor.initialize(typeParameterDescriptors, ErrorUtils.createErrorType(name.asString()), ErrorUtils.createErrorType(name.asString()));
        } else {
            typeAliasDescriptor.initialize(typeParameterDescriptors, this.storageManager.createRecursionTolerantLazyValue(() -> this.typeResolver.resolveAbbreviatedType(scopeWithTypeParameters, typeReference, trace2), ErrorUtils.createErrorType("Recursive type alias expansion for " + typeAliasDescriptor.getName().asString())), this.storageManager.createRecursionTolerantLazyValue(() -> this.typeResolver.resolveExpandedTypeForTypeAlias(typeAliasDescriptor), ErrorUtils.createErrorType("Recursive type alias expansion for " + typeAliasDescriptor.getName().asString())));
        }
        trace2.record(BindingContext.TYPE_ALIAS, typeAlias, typeAliasDescriptor);
        return typeAliasDescriptor;
    }

    private static void checkNoGenericBoundsOnTypeAliasParameters(@NotNull KtTypeAlias typeAlias, @NotNull BindingTrace trace2) {
        for (KtTypeParameter typeParameter : typeAlias.getTypeParameters()) {
            KtTypeReference bound = typeParameter.getExtendsBound();
            if (bound == null) continue;
            trace2.report(Errors.BOUND_ON_TYPE_ALIAS_PARAMETER_NOT_ALLOWED.on(bound));
        }
    }

    @NotNull
    public PropertyDescriptor resolveDestructuringDeclarationEntryAsProperty(@NotNull DeclarationDescriptor containingDeclaration, @NotNull LexicalScope scopeForDeclarationResolution, @NotNull LexicalScope scopeForInitializerResolution2, @NotNull KtDestructuringDeclarationEntry entry, @NotNull BindingTrace trace2, @NotNull DataFlowInfo dataFlowInfo) {
        KtDestructuringDeclaration destructuringDeclaration = (KtDestructuringDeclaration)entry.getParent();
        KtExpression initializer2 = destructuringDeclaration.getInitializer();
        ExpressionTypingContext context = ExpressionTypingContext.newContext(trace2, scopeForDeclarationResolution, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, this.languageVersionSettings, this.dataFlowValueFactory);
        ExpressionReceiver receiver = this.createReceiverForDestructuringDeclaration(destructuringDeclaration, context);
        int componentIndex = destructuringDeclaration.getEntries().indexOf(entry);
        KotlinType componentType = this.destructuringDeclarationResolver.resolveInitializer(entry, receiver, initializer2, context, componentIndex);
        return this.resolveAsPropertyDescriptor(containingDeclaration, scopeForDeclarationResolution, scopeForInitializerResolution2, entry, trace2, dataFlowInfo, VariableAsPropertyInfo.Companion.createFromDestructuringDeclarationEntry(componentType));
    }

    private ExpressionReceiver createReceiverForDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration, @NotNull ExpressionTypingContext context) {
        KtExpression initializer2 = destructuringDeclaration.getInitializer();
        if (initializer2 == null) {
            return null;
        }
        KotlinType initializerType = this.expressionTypingServices.getTypeInfo(initializer2, context).getType();
        if (initializerType == null) {
            return null;
        }
        return ExpressionReceiver.Companion.create(initializer2, initializerType, context.trace.getBindingContext());
    }

    @NotNull
    public PropertyDescriptor resolvePropertyDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull LexicalScope scopeForDeclarationResolution, @NotNull LexicalScope scopeForInitializerResolution2, @NotNull KtProperty property, @NotNull BindingTrace trace2, @NotNull DataFlowInfo dataFlowInfo) {
        return this.resolveAsPropertyDescriptor(containingDeclaration, scopeForDeclarationResolution, scopeForInitializerResolution2, property, trace2, dataFlowInfo, VariableAsPropertyInfo.Companion.createFromProperty(property));
    }

    @NotNull
    private PropertyDescriptor resolveAsPropertyDescriptor(@NotNull DeclarationDescriptor container2, @NotNull LexicalScope scopeForDeclarationResolution, @NotNull LexicalScope scopeForInitializerResolution2, @NotNull KtVariableDeclaration variableDeclaration, @NotNull BindingTrace trace2, @NotNull DataFlowInfo dataFlowInfo, @NotNull VariableAsPropertyInfo propertyInfo) {
        KotlinType type2;
        List<Object> typeParameterDescriptors;
        LexicalScope scopeForInitializerResolutionWithTypeParameters;
        LexicalScope scopeForDeclarationResolutionWithTypeParameters;
        KtModifierList modifierList = variableDeclaration.getModifierList();
        boolean isVar = variableDeclaration.isVar();
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(variableDeclaration, DescriptorResolver.getDefaultVisibility(variableDeclaration, container2));
        Modality modality = container2 instanceof ClassDescriptor ? ModifiersChecker.resolveMemberModalityFromModifiers(variableDeclaration, DescriptorResolver.getDefaultModality(container2, visibility, propertyInfo.getHasBody()), trace2.getBindingContext(), container2) : Modality.FINAL;
        AnnotationSplitter.PropertyWrapper wrapper = new AnnotationSplitter.PropertyWrapper(variableDeclaration);
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scopeForDeclarationResolution, modifierList, trace2);
        AnnotationSplitter annotationSplitter = new AnnotationSplitter(this.storageManager, allAnnotations, () -> AnnotationSplitter.getTargetSet(false, trace2.getBindingContext(), wrapper));
        CompositeAnnotations propertyAnnotations = new CompositeAnnotations(CollectionsKt.listOf(new Annotations[]{annotationSplitter.getAnnotationsForTargets(AnnotationUseSiteTarget.PROPERTY, AnnotationUseSiteTarget.FIELD, AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD), annotationSplitter.getOtherAnnotations()}));
        PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(container2, propertyAnnotations, modality, visibility, isVar, KtPsiUtil.safeName(variableDeclaration.getName()), CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(variableDeclaration), modifierList != null && modifierList.hasModifier(KtTokens.LATEINIT_KEYWORD), modifierList != null && modifierList.hasModifier(KtTokens.CONST_KEYWORD), modifierList != null && PsiUtilsKt.hasExpectModifier(modifierList) && container2 instanceof PackageFragmentDescriptor || container2 instanceof ClassDescriptor && ((ClassDescriptor)container2).isExpect(), modifierList != null && PsiUtilsKt.hasActualModifier(modifierList), modifierList != null && modifierList.hasModifier(KtTokens.EXTERNAL_KEYWORD), propertyInfo.getHasDelegate());
        wrapper.setDescriptor(propertyDescriptor);
        KotlinType receiverType = null;
        List<KtTypeParameter> typeParameters2 = variableDeclaration.getTypeParameters();
        if (typeParameters2.isEmpty()) {
            scopeForDeclarationResolutionWithTypeParameters = scopeForDeclarationResolution;
            scopeForInitializerResolutionWithTypeParameters = scopeForInitializerResolution2;
            typeParameterDescriptors = Collections.emptyList();
        } else {
            LexicalWritableScope writableScopeForDeclarationResolution = new LexicalWritableScope(scopeForDeclarationResolution, container2, false, new TraceBasedLocalRedeclarationChecker(trace2, this.overloadChecker), LexicalScopeKind.PROPERTY_HEADER);
            LexicalWritableScope writableScopeForInitializerResolution = new LexicalWritableScope(scopeForInitializerResolution2, container2, false, LocalRedeclarationChecker.DO_NOTHING.INSTANCE, LexicalScopeKind.PROPERTY_HEADER);
            typeParameterDescriptors = this.resolveTypeParametersForDescriptor(propertyDescriptor, scopeForDeclarationResolution, typeParameters2, trace2);
            for (TypeParameterDescriptor typeParameterDescriptor : typeParameterDescriptors) {
                writableScopeForDeclarationResolution.addClassifierDescriptor(typeParameterDescriptor);
                writableScopeForInitializerResolution.addClassifierDescriptor(typeParameterDescriptor);
            }
            writableScopeForDeclarationResolution.freeze();
            writableScopeForInitializerResolution.freeze();
            this.resolveGenericBounds(variableDeclaration, propertyDescriptor, writableScopeForDeclarationResolution, typeParameterDescriptors, trace2);
            scopeForDeclarationResolutionWithTypeParameters = writableScopeForDeclarationResolution;
            scopeForInitializerResolutionWithTypeParameters = writableScopeForInitializerResolution;
        }
        KtTypeReference receiverTypeRef = variableDeclaration.getReceiverTypeReference();
        if (receiverTypeRef != null) {
            receiverType = this.typeResolver.resolveType(scopeForDeclarationResolutionWithTypeParameters, receiverTypeRef, trace2, true);
        }
        ReceiverParameterDescriptor receiverDescriptor = DescriptorFactory.createExtensionReceiverParameterForCallable(propertyDescriptor, receiverType);
        LexicalScope scopeForInitializer = ScopeUtils.makeScopeForPropertyInitializer(scopeForInitializerResolutionWithTypeParameters, propertyDescriptor);
        KotlinType propertyType = propertyInfo.getVariableType();
        KotlinType typeIfKnown = propertyType != null ? propertyType : this.variableTypeAndInitializerResolver.resolveTypeNullable(propertyDescriptor, scopeForInitializer, variableDeclaration, dataFlowInfo, trace2, false);
        PropertyGetterDescriptorImpl propertyGetterDescriptorImpl = this.resolvePropertyGetterDescriptor(scopeForDeclarationResolutionWithTypeParameters, variableDeclaration, propertyDescriptor, annotationSplitter, trace2, typeIfKnown, propertyInfo.getPropertyGetter(), propertyInfo.getHasDelegate());
        KotlinType kotlinType = type2 = typeIfKnown != null ? typeIfKnown : propertyGetterDescriptorImpl.getReturnType();
        assert (type2 != null) : "At least getter type must be initialized via resolvePropertyGetterDescriptor";
        this.variableTypeAndInitializerResolver.setConstantForVariableIfNeeded(propertyDescriptor, scopeForInitializer, variableDeclaration, dataFlowInfo, type2, trace2);
        propertyDescriptor.setType(type2, typeParameterDescriptors, DescriptorUtils.getDispatchReceiverParameterIfNeeded(container2), receiverDescriptor);
        PropertySetterDescriptor setter2 = this.resolvePropertySetterDescriptor(scopeForDeclarationResolutionWithTypeParameters, variableDeclaration, propertyDescriptor, annotationSplitter, trace2, propertyInfo.getPropertySetter(), propertyInfo.getHasDelegate());
        propertyDescriptor.initialize(propertyGetterDescriptorImpl, setter2);
        trace2.record(BindingContext.VARIABLE, variableDeclaration, propertyDescriptor);
        return propertyDescriptor;
    }

    @NotNull
    static KotlinType transformAnonymousTypeIfNeeded(@NotNull DeclarationDescriptorWithVisibility descriptor2, @NotNull KtDeclaration declaration, @NotNull KotlinType type2, @NotNull BindingTrace trace2) {
        ClassifierDescriptor classifier2 = type2.getConstructor().getDeclarationDescriptor();
        if (classifier2 == null || !DescriptorUtils.isAnonymousObject(classifier2) || DescriptorUtils.isLocal(descriptor2)) {
            return type2;
        }
        if (!Visibilities.isPrivate(descriptor2.getVisibility())) {
            if (type2.getConstructor().getSupertypes().size() == 1) {
                return type2.getConstructor().getSupertypes().iterator().next();
            }
            trace2.report(Errors.AMBIGUOUS_ANONYMOUS_TYPE_INFERRED.on(declaration, type2.getConstructor().getSupertypes()));
        }
        return type2;
    }

    @Nullable
    private PropertySetterDescriptor resolvePropertySetterDescriptor(@NotNull LexicalScope scopeWithTypeParameters, @NotNull KtVariableDeclaration property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull AnnotationSplitter annotationSplitter, @NotNull BindingTrace trace2, @Nullable KtPropertyAccessor setter2, boolean hasDelegate) {
        PropertySetterDescriptorImpl setterDescriptor = null;
        if (setter2 != null) {
            KotlinType returnType;
            CompositeAnnotations annotations2 = new CompositeAnnotations(CollectionsKt.listOf(new Annotations[]{annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_SETTER), this.annotationResolver.resolveAnnotationsWithoutArguments(scopeWithTypeParameters, setter2.getModifierList(), trace2)}));
            KtParameter parameter = setter2.getParameter();
            setterDescriptor = new PropertySetterDescriptorImpl(propertyDescriptor, annotations2, ModifiersChecker.resolveMemberModalityFromModifiers(setter2, propertyDescriptor.getModality(), trace2.getBindingContext(), propertyDescriptor.getContainingDeclaration()), ModifiersChecker.resolveVisibilityFromModifiers(setter2, propertyDescriptor.getVisibility()), false, setter2.hasModifier(KtTokens.EXTERNAL_KEYWORD), property.hasModifier(KtTokens.INLINE_KEYWORD) || setter2.hasModifier(KtTokens.INLINE_KEYWORD), CallableMemberDescriptor.Kind.DECLARATION, null, KotlinSourceElementKt.toSourceElement(setter2));
            KtTypeReference returnTypeReference = setter2.getReturnTypeReference();
            if (returnTypeReference != null && !KotlinBuiltIns.isUnit(returnType = this.typeResolver.resolveType(scopeWithTypeParameters, returnTypeReference, trace2, true))) {
                trace2.report(Errors.WRONG_SETTER_RETURN_TYPE.on(returnTypeReference));
            }
            if (parameter != null) {
                KotlinType type2;
                KtTypeReference typeReference;
                if (parameter.hasDefaultValue()) {
                    trace2.report(Errors.SETTER_PARAMETER_WITH_DEFAULT_VALUE.on(parameter.getDefaultValue()));
                }
                if ((typeReference = parameter.getTypeReference()) == null) {
                    type2 = propertyDescriptor.getType();
                } else {
                    KotlinType inType;
                    type2 = this.typeResolver.resolveType(scopeWithTypeParameters, typeReference, trace2, true);
                    if (!TypeUtils.equalTypes(type2, inType = propertyDescriptor.getType())) {
                        trace2.report(Errors.WRONG_SETTER_PARAMETER_TYPE.on(typeReference, inType, type2));
                    }
                }
                ValueParameterDescriptorImpl valueParameterDescriptor = this.resolveValueParameterDescriptor(scopeWithTypeParameters, setterDescriptor, parameter, 0, type2, trace2);
                setterDescriptor.initialize(valueParameterDescriptor);
            } else {
                setterDescriptor.initializeDefault();
            }
            trace2.record(BindingContext.PROPERTY_ACCESSOR, setter2, setterDescriptor);
        } else if (property.isVar()) {
            Annotations setterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_SETTER);
            setterDescriptor = DescriptorFactory.createSetter(propertyDescriptor, setterAnnotations, !hasDelegate, false, property.hasModifier(KtTokens.INLINE_KEYWORD), propertyDescriptor.getSource());
        }
        if (!property.isVar() && setter2 != null) {
            trace2.report(Errors.VAL_WITH_SETTER.on(setter2));
        }
        return setterDescriptor;
    }

    @NotNull
    private PropertyGetterDescriptorImpl resolvePropertyGetterDescriptor(@NotNull LexicalScope scopeForDeclarationResolution, @NotNull KtVariableDeclaration property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull AnnotationSplitter annotationSplitter, @NotNull BindingTrace trace2, @Nullable KotlinType propertyTypeIfKnown, @Nullable KtPropertyAccessor getter2, boolean hasDelegate) {
        KotlinType getterType;
        PropertyGetterDescriptorImpl getterDescriptor;
        if (getter2 != null) {
            CompositeAnnotations getterAnnotations = new CompositeAnnotations(CollectionsKt.listOf(new Annotations[]{annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_GETTER), this.annotationResolver.resolveAnnotationsWithoutArguments(scopeForDeclarationResolution, getter2.getModifierList(), trace2)}));
            getterDescriptor = new PropertyGetterDescriptorImpl(propertyDescriptor, getterAnnotations, ModifiersChecker.resolveMemberModalityFromModifiers(getter2, propertyDescriptor.getModality(), trace2.getBindingContext(), propertyDescriptor.getContainingDeclaration()), ModifiersChecker.resolveVisibilityFromModifiers(getter2, propertyDescriptor.getVisibility()), false, getter2.hasModifier(KtTokens.EXTERNAL_KEYWORD), property.hasModifier(KtTokens.INLINE_KEYWORD) || getter2.hasModifier(KtTokens.INLINE_KEYWORD), CallableMemberDescriptor.Kind.DECLARATION, null, KotlinSourceElementKt.toSourceElement(getter2));
            getterType = this.determineGetterReturnType(scopeForDeclarationResolution, trace2, getterDescriptor, getter2, propertyTypeIfKnown);
            trace2.record(BindingContext.PROPERTY_ACCESSOR, getter2, getterDescriptor);
        } else {
            Annotations getterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_GETTER);
            getterDescriptor = DescriptorFactory.createGetter(propertyDescriptor, getterAnnotations, !hasDelegate, false, property.hasModifier(KtTokens.INLINE_KEYWORD));
            getterType = propertyTypeIfKnown;
        }
        getterDescriptor.initialize(getterType != null ? getterType : VariableTypeAndInitializerResolver.STUB_FOR_PROPERTY_WITHOUT_TYPE);
        return getterDescriptor;
    }

    @Nullable
    private KotlinType determineGetterReturnType(@NotNull LexicalScope scope, @NotNull BindingTrace trace2, @NotNull PropertyGetterDescriptor getterDescriptor, @NotNull KtPropertyAccessor getter2, @Nullable KotlinType propertyTypeIfKnown) {
        KtTypeReference returnTypeReference = getter2.getReturnTypeReference();
        if (returnTypeReference != null) {
            KotlinType explicitReturnType = this.typeResolver.resolveType(scope, returnTypeReference, trace2, true);
            if (propertyTypeIfKnown != null && !TypeUtils.equalTypes(explicitReturnType, propertyTypeIfKnown)) {
                trace2.report(Errors.WRONG_GETTER_RETURN_TYPE.on(returnTypeReference, propertyTypeIfKnown, explicitReturnType));
            }
            return explicitReturnType;
        }
        KtProperty property = getter2.getProperty();
        if (!property.hasDelegateExpressionOrInitializer() && property.getTypeReference() == null && getter2.hasBody() && !getter2.hasBlockBody()) {
            return this.inferReturnTypeFromExpressionBody(trace2, scope, DataFlowInfoFactory.EMPTY, getter2, getterDescriptor);
        }
        return propertyTypeIfKnown;
    }

    @NotNull
    KotlinType inferReturnTypeFromExpressionBody(@NotNull BindingTrace trace2, @NotNull LexicalScope scope, @NotNull DataFlowInfo dataFlowInfo, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor) {
        return this.wrappedTypeFactory.createRecursionIntolerantDeferredType(trace2, () -> {
            PreliminaryDeclarationVisitor.Companion.createForDeclaration(function2, trace2, this.languageVersionSettings);
            KotlinType type2 = this.expressionTypingServices.getBodyExpressionType(trace2, scope, dataFlowInfo, function2, functionDescriptor);
            KotlinType publicType = DescriptorResolver.transformAnonymousTypeIfNeeded(functionDescriptor, function2, type2, trace2);
            UnwrappedType approximatedType = this.typeApproximator.approximateDeclarationType(publicType, false, this.languageVersionSettings);
            UnwrappedType sanitizedType = this.declarationReturnTypeSanitizer.sanitizeReturnType(approximatedType, this.wrappedTypeFactory, trace2, this.languageVersionSettings);
            this.functionsTypingVisitor.checkTypesForReturnStatements(function2, trace2, sanitizedType);
            return sanitizedType;
        });
    }

    @NotNull
    public PropertyDescriptor resolvePrimaryConstructorParameterToAProperty(@NotNull ClassDescriptor classDescriptor, @NotNull ValueParameterDescriptor valueParameter, @NotNull LexicalScope scope, @NotNull KtParameter parameter, BindingTrace trace2) {
        KotlinType type2 = this.resolveParameterType(scope, parameter, trace2);
        Name name = parameter.getNameAsSafeName();
        boolean isMutable = parameter.isMutable();
        KtModifierList modifierList = parameter.getModifierList();
        if (modifierList != null && modifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            trace2.report(Errors.ABSTRACT_PROPERTY_IN_PRIMARY_CONSTRUCTOR_PARAMETERS.on(parameter));
        }
        AnnotationSplitter.PropertyWrapper propertyWrapper = new AnnotationSplitter.PropertyWrapper(parameter);
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scope, parameter.getModifierList(), trace2);
        AnnotationSplitter annotationSplitter = new AnnotationSplitter(this.storageManager, allAnnotations, () -> AnnotationSplitter.getTargetSet(true, trace2.getBindingContext(), propertyWrapper));
        CompositeAnnotations propertyAnnotations = new CompositeAnnotations(annotationSplitter.getAnnotationsForTargets(AnnotationUseSiteTarget.PROPERTY, AnnotationUseSiteTarget.FIELD), annotationSplitter.getOtherAnnotations());
        PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(classDescriptor, propertyAnnotations, ModifiersChecker.resolveMemberModalityFromModifiers(parameter, Modality.FINAL, trace2.getBindingContext(), classDescriptor), ModifiersChecker.resolveVisibilityFromModifiers(parameter, DescriptorResolver.getDefaultVisibility(parameter, classDescriptor)), isMutable, name, CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(parameter), false, false, classDescriptor.isExpect(), modifierList != null && PsiUtilsKt.hasActualModifier(modifierList), false, false);
        propertyWrapper.setDescriptor(propertyDescriptor);
        propertyDescriptor.setType(type2, Collections.emptyList(), DescriptorUtils.getDispatchReceiverParameterIfNeeded(classDescriptor), (ReceiverParameterDescriptor)null);
        Annotations setterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_SETTER);
        CompositeAnnotations getterAnnotations = new CompositeAnnotations(CollectionsKt.listOf(annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_GETTER)));
        PropertyGetterDescriptorImpl getter2 = DescriptorFactory.createDefaultGetter(propertyDescriptor, getterAnnotations);
        PropertySetterDescriptorImpl setter2 = propertyDescriptor.isVar() ? DescriptorFactory.createDefaultSetter(propertyDescriptor, setterAnnotations) : null;
        propertyDescriptor.initialize(getter2, setter2);
        getter2.initialize(propertyDescriptor.getType());
        trace2.record(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter, propertyDescriptor);
        trace2.record(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameter, propertyDescriptor);
        return propertyDescriptor;
    }

    public static void checkBounds(@NotNull KtTypeReference typeReference, @NotNull KotlinType type2, @NotNull BindingTrace trace2) {
        if (KotlinTypeKt.isError(type2)) {
            return;
        }
        KtTypeElement typeElement = typeReference.getTypeElement();
        if (typeElement == null) {
            return;
        }
        List<TypeParameterDescriptor> parameters2 = type2.getConstructor().getParameters();
        List<TypeProjection> arguments2 = type2.getArguments();
        assert (parameters2.size() == arguments2.size());
        List<KtTypeReference> ktTypeArguments = typeElement.getTypeArgumentsAsTypes();
        if (FlexibleTypesKt.isFlexible(type2) && !DynamicTypesKt.isDynamic(type2)) {
            assert (ktTypeArguments.size() == 2) : "Flexible type cannot be denoted in Kotlin otherwise than as ft<T1, T2>, but was: " + PsiUtilsKt.getElementTextWithContext(typeReference);
            FlexibleType flexibleType = FlexibleTypesKt.asFlexibleType(type2);
            DescriptorResolver.checkBounds(ktTypeArguments.get(0), flexibleType.getLowerBound(), trace2);
            DescriptorResolver.checkBounds(ktTypeArguments.get(1), flexibleType.getUpperBound(), trace2);
            return;
        }
        if (ktTypeArguments.size() != arguments2.size()) {
            return;
        }
        TypeSubstitutor substitutor2 = TypeSubstitutor.create(type2);
        for (int i2 = 0; i2 < ktTypeArguments.size(); ++i2) {
            KtTypeReference ktTypeArgument = ktTypeArguments.get(i2);
            if (ktTypeArgument == null) continue;
            KotlinType typeArgument = arguments2.get(i2).getType();
            DescriptorResolver.checkBounds(ktTypeArgument, typeArgument, trace2);
            TypeParameterDescriptor typeParameterDescriptor = parameters2.get(i2);
            DescriptorResolver.checkBounds(ktTypeArgument, typeArgument, typeParameterDescriptor, substitutor2, trace2);
        }
    }

    public static void checkBounds(@NotNull KtTypeReference jetTypeArgument, @NotNull KotlinType typeArgument, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor2, @NotNull BindingTrace trace2) {
        for (KotlinType bound : typeParameterDescriptor.getUpperBounds()) {
            KotlinType substitutedBound = substitutor2.safeSubstitute(bound, Variance.INVARIANT);
            if (KotlinTypeChecker.DEFAULT.isSubtypeOf(typeArgument, substitutedBound)) continue;
            trace2.report(Errors.UPPER_BOUND_VIOLATED.on(jetTypeArgument, substitutedBound, typeArgument));
        }
    }

    public static void checkBoundsInTypeAlias(@NotNull TypeAliasExpansionReportStrategy reportStrategy, @NotNull KotlinType unsubstitutedArgument, @NotNull KotlinType typeArgument, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor2) {
        for (KotlinType bound : typeParameterDescriptor.getUpperBounds()) {
            KotlinType substitutedBound = substitutor2.safeSubstitute(bound, Variance.INVARIANT);
            if (KotlinTypeChecker.DEFAULT.isSubtypeOf(typeArgument, substitutedBound)) continue;
            reportStrategy.boundsViolationInSubstitution(substitutedBound, unsubstitutedArgument, typeArgument, typeParameterDescriptor);
        }
    }

    public static boolean checkHasOuterClassInstance(@NotNull LexicalScope scope, @NotNull BindingTrace trace2, @NotNull PsiElement reportErrorsOn, @NotNull ClassDescriptor target) {
        ClassDescriptor classDescriptor = DescriptorResolver.getContainingClass(scope);
        if (!DescriptorResolver.isInsideOuterClassOrItsSubclass(classDescriptor, target)) {
            return true;
        }
        while (classDescriptor != null) {
            if (DescriptorUtils.isSubclass(classDescriptor, target)) {
                return true;
            }
            if (DescriptorUtils.isStaticNestedClass(classDescriptor)) {
                trace2.report(Errors.INACCESSIBLE_OUTER_CLASS_EXPRESSION.on(reportErrorsOn, classDescriptor));
                return false;
            }
            classDescriptor = DescriptorUtils.getParentOfType(classDescriptor, ClassDescriptor.class, true);
        }
        return true;
    }

    private static boolean isInsideOuterClassOrItsSubclass(@Nullable DeclarationDescriptor nested, @NotNull ClassDescriptor outer) {
        if (nested == null) {
            return false;
        }
        if (nested instanceof ClassDescriptor && DescriptorUtils.isSubclass((ClassDescriptor)nested, outer)) {
            return true;
        }
        return DescriptorResolver.isInsideOuterClassOrItsSubclass(nested.getContainingDeclaration(), outer);
    }

    @Nullable
    public static ClassDescriptor getContainingClass(@NotNull LexicalScope scope) {
        return DescriptorUtils.getParentOfType(scope.getOwnerDescriptor(), ClassDescriptor.class, false);
    }

    public static void registerFileInPackage(@NotNull BindingTrace trace2, @NotNull KtFile file2) {
        FqName fqName2 = file2.getPackageFqName();
        Collection<KtFile> files2 = trace2.get(BindingContext.PACKAGE_TO_FILES, fqName2);
        if (files2 == null) {
            files2 = Sets.newIdentityHashSet();
        }
        files2.add(file2);
        trace2.record(BindingContext.PACKAGE_TO_FILES, fqName2, files2);
    }

    static final class UpperBoundCheckRequest {
        public final Name typeParameterName;
        public final KtTypeReference upperBound;
        public final KotlinType upperBoundType;

        UpperBoundCheckRequest(Name typeParameterName, KtTypeReference upperBound, KotlinType upperBoundType) {
            this.typeParameterName = typeParameterName;
            this.upperBound = upperBound;
            this.upperBoundType = upperBoundType;
        }
    }
}

