/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.CollectionLiteralKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.IntersectionTypeKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u001c\u0010\u0012\u001a\u00020\b*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0002\u001a\u001c\u0010\u0017\u001a\u00020\u0001*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\f\u0010\u0018\u001a\u00020\u0001*\u00020\u0011H\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u001a\u0010\f\u001a\u0004\u0018\u00010\b*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0019"}, d2={"isActualParameterWithExpectedDefault", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;)Z", "isVararg", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;)Z", "stableType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;", "getStableType", "(Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;)Lorg/jetbrains/kotlin/types/UnwrappedType;", "unstableType", "getUnstableType", "unexpectedArgument", "", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "getExpectedType", "parameter", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "hasDefaultValue", "isArrayAssignedAsNamedArgumentInAnnotation", "isArrayOrArrayLiteral", "resolution"})
public final class ArgumentsUtilsKt {
    @NotNull
    public static final Void unexpectedArgument(@NotNull KotlinCallArgument argument) {
        Intrinsics.checkParameterIsNotNull(argument, "argument");
        String string = "Unexpected argument type: " + argument + ", " + argument.getClass().getCanonicalName() + '.';
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Nullable
    public static final UnwrappedType getUnstableType(@NotNull ReceiverValueWithSmartCastInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver.isStable() || $receiver.getPossibleTypes().isEmpty()) {
            return null;
        }
        return IntersectionTypeKt.intersectWrappedTypes((Collection<? extends KotlinType>)SetsKt.plus($receiver.getPossibleTypes(), $receiver.getReceiverValue().getType()));
    }

    @NotNull
    public static final UnwrappedType getStableType(@NotNull ReceiverValueWithSmartCastInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (!$receiver.isStable() || $receiver.getPossibleTypes().isEmpty()) {
            return $receiver.getReceiverValue().getType().unwrap();
        }
        return IntersectionTypeKt.intersectWrappedTypes((Collection<? extends KotlinType>)SetsKt.plus($receiver.getPossibleTypes(), $receiver.getReceiverValue().getType()));
    }

    @NotNull
    public static final UnwrappedType getExpectedType(@NotNull KotlinCallArgument $receiver, @NotNull ParameterDescriptor parameter, @NotNull LanguageVersionSettings languageVersionSettings) {
        Annotated annotated;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(parameter, "parameter");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        if ($receiver.isSpread() || ArgumentsUtilsKt.isArrayAssignedAsNamedArgumentInAnnotation($receiver, parameter, languageVersionSettings)) {
            annotated = parameter.getType().unwrap();
        } else {
            ParameterDescriptor $receiver$iv = parameter;
            ParameterDescriptor parameterDescriptor = $receiver$iv;
            if (!(parameterDescriptor instanceof ValueParameterDescriptor)) {
                parameterDescriptor = null;
            }
            if ((annotated = (ValueParameterDescriptor)parameterDescriptor) == null || (annotated = annotated.getVarargElementType()) == null || (annotated = ((KotlinType)annotated).unwrap()) == null) {
                annotated = parameter.getType().unwrap();
            }
        }
        return annotated;
    }

    public static final boolean isVararg(@NotNull ValueParameterDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getVarargElementType() != null;
    }

    public static final boolean isVararg(@NotNull ParameterDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ParameterDescriptor $receiver$iv = $receiver;
        ParameterDescriptor parameterDescriptor = $receiver$iv;
        if (!(parameterDescriptor instanceof ValueParameterDescriptor)) {
            parameterDescriptor = null;
        }
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)parameterDescriptor;
        return valueParameterDescriptor != null ? ArgumentsUtilsKt.isVararg(valueParameterDescriptor) : false;
    }

    public static final boolean hasDefaultValue(@NotNull ValueParameterDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Boolean bl = DFS.ifAny((Collection)CollectionsKt.listOf($receiver), hasDefaultValue.1.INSTANCE, hasDefaultValue.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(bl, "DFS.ifAny(\n        listO\u2026thExpectedDefault }\n    )");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isActualParameterWithExpectedDefault(@NotNull ValueParameterDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        CallableDescriptor function2 = $receiver.getContainingDeclaration();
        if (!(function2 instanceof FunctionDescriptor)) return false;
        if (!((FunctionDescriptor)function2).isActual()) return false;
        ExpectedActualResolver expectedActualResolver = ExpectedActualResolver.INSTANCE;
        ExpectedActualResolver $receiver2 = expectedActualResolver;
        MemberDescriptor expected = CollectionsKt.firstOrNull($receiver2.findCompatibleExpectedForActual((MemberDescriptor)((Object)function2), DescriptorUtilsKt.getModule(function2)));
        if (!(expected instanceof FunctionDescriptor)) return false;
        ValueParameterDescriptor valueParameterDescriptor = ((FunctionDescriptor)expected).getValueParameters().get($receiver.getIndex());
        Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "expected.valueParameters[index]");
        if (!ArgumentsUtilsKt.hasDefaultValue(valueParameterDescriptor)) return false;
        return true;
    }

    private static final boolean isArrayAssignedAsNamedArgumentInAnnotation(@NotNull KotlinCallArgument $receiver, ParameterDescriptor parameter, LanguageVersionSettings languageVersionSettings) {
        if (!languageVersionSettings.supportsFeature(LanguageFeature.AssigningArraysToVarargsInNamedFormInAnnotations)) {
            return false;
        }
        if ($receiver.getArgumentName() == null || !ArgumentsUtilsKt.isVararg(parameter)) {
            return false;
        }
        return DescriptorUtilsKt.isParameterOfAnnotation(parameter) && ArgumentsUtilsKt.isArrayOrArrayLiteral($receiver);
    }

    private static final boolean isArrayOrArrayLiteral(@NotNull KotlinCallArgument $receiver) {
        if ($receiver instanceof CollectionLiteralKotlinCallArgument) {
            return true;
        }
        if (!($receiver instanceof SimpleKotlinCallArgument)) {
            return false;
        }
        KotlinType type2 = ((SimpleKotlinCallArgument)$receiver).getReceiver().getReceiverValue().getType();
        return KotlinBuiltIns.isArrayOrPrimitiveArray(type2);
    }
}

