/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.results;

import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public final class ResolutionStatus
extends Enum<ResolutionStatus> {
    public static final /* enum */ ResolutionStatus UNKNOWN_STATUS = new ResolutionStatus();
    public static final /* enum */ ResolutionStatus UNSAFE_CALL_ERROR = new ResolutionStatus();
    public static final /* enum */ ResolutionStatus WRONG_NUMBER_OF_TYPE_ARGUMENTS_ERROR = new ResolutionStatus();
    public static final /* enum */ ResolutionStatus UNSTABLE_SMARTCAST_FOR_RECEIVER_ERROR = new ResolutionStatus();
    public static final /* enum */ ResolutionStatus INVISIBLE_MEMBER_ERROR = new ResolutionStatus();
    public static final /* enum */ ResolutionStatus NULLABLE_ARGUMENT_TYPE_MISMATCH = new ResolutionStatus();
    public static final /* enum */ ResolutionStatus OTHER_ERROR = new ResolutionStatus();
    public static final /* enum */ ResolutionStatus ARGUMENTS_MAPPING_ERROR = new ResolutionStatus();
    public static final /* enum */ ResolutionStatus RECEIVER_TYPE_ERROR = new ResolutionStatus();
    public static final /* enum */ ResolutionStatus RECEIVER_PRESENCE_ERROR = new ResolutionStatus();
    public static final /* enum */ ResolutionStatus INCOMPLETE_TYPE_INFERENCE = new ResolutionStatus();
    public static final /* enum */ ResolutionStatus SUCCESS = new ResolutionStatus(true);
    public static final EnumSet<ResolutionStatus>[] SEVERITY_LEVELS;
    private final boolean success;
    private int severityIndex = -1;
    private static final /* synthetic */ ResolutionStatus[] $VALUES;

    public static ResolutionStatus[] values() {
        return (ResolutionStatus[])$VALUES.clone();
    }

    public static ResolutionStatus valueOf(String name) {
        return Enum.valueOf(ResolutionStatus.class, name);
    }

    private ResolutionStatus(boolean success) {
        this.success = success;
    }

    private ResolutionStatus() {
        this(false);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean possibleTransformToSuccess() {
        return this == UNKNOWN_STATUS || this == INCOMPLETE_TYPE_INFERENCE || this == SUCCESS;
    }

    @NotNull
    public ResolutionStatus combine(ResolutionStatus other) {
        if (this == UNKNOWN_STATUS) {
            return other;
        }
        if (SUCCESS.among(this, other)) {
            return SUCCESS.chooseDifferent(this, other);
        }
        if (INCOMPLETE_TYPE_INFERENCE.among(this, other)) {
            return INCOMPLETE_TYPE_INFERENCE.chooseDifferent(this, other);
        }
        if (this.getSeverityIndex() < other.getSeverityIndex()) {
            return other;
        }
        return this;
    }

    private boolean among(ResolutionStatus first2, ResolutionStatus second) {
        return this == first2 || this == second;
    }

    private ResolutionStatus chooseDifferent(ResolutionStatus first2, ResolutionStatus second) {
        assert (this.among(first2, second));
        return this == first2 ? second : first2;
    }

    private int getSeverityIndex() {
        if (this.severityIndex == -1) {
            for (int i2 = 0; i2 < SEVERITY_LEVELS.length; ++i2) {
                if (!SEVERITY_LEVELS[i2].contains((Object)this)) continue;
                this.severityIndex = i2;
                break;
            }
        }
        assert (this.severityIndex >= 0);
        return this.severityIndex;
    }

    static {
        $VALUES = new ResolutionStatus[]{UNKNOWN_STATUS, UNSAFE_CALL_ERROR, WRONG_NUMBER_OF_TYPE_ARGUMENTS_ERROR, UNSTABLE_SMARTCAST_FOR_RECEIVER_ERROR, INVISIBLE_MEMBER_ERROR, NULLABLE_ARGUMENT_TYPE_MISMATCH, OTHER_ERROR, ARGUMENTS_MAPPING_ERROR, RECEIVER_TYPE_ERROR, RECEIVER_PRESENCE_ERROR, INCOMPLETE_TYPE_INFERENCE, SUCCESS};
        SEVERITY_LEVELS = new EnumSet[]{EnumSet.of(UNSAFE_CALL_ERROR), EnumSet.of(WRONG_NUMBER_OF_TYPE_ARGUMENTS_ERROR), EnumSet.of(UNSTABLE_SMARTCAST_FOR_RECEIVER_ERROR), EnumSet.of(INVISIBLE_MEMBER_ERROR), EnumSet.of(NULLABLE_ARGUMENT_TYPE_MISMATCH), EnumSet.of(OTHER_ERROR), EnumSet.of(ARGUMENTS_MAPPING_ERROR), EnumSet.of(RECEIVER_TYPE_ERROR), EnumSet.of(RECEIVER_PRESENCE_ERROR)};
    }
}

