/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/InlineClassDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isParameterAcceptableForInlineClass", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "frontend"})
public final class InlineClassDeclarationChecker
implements DeclarationChecker {
    public static final InlineClassDeclarationChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineClasses)) {
            return;
        }
        if (!(declaration instanceof KtClass)) {
            return;
        }
        if (!(descriptor2 instanceof ClassDescriptor) || !((ClassDescriptor)descriptor2).isInline()) {
            return;
        }
        if (((ClassDescriptor)descriptor2).getKind() != ClassKind.CLASS) {
            return;
        }
        BindingTrace trace2 = context.getTrace();
        if (!DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            trace2.report(Errors.INLINE_CLASS_NOT_TOP_LEVEL.on((KtClass)declaration));
            return;
        }
        PsiElement modalityModifier = KtPsiUtilKt.modalityModifier(declaration);
        if (modalityModifier != null && ((ClassDescriptor)descriptor2).getModality() != Modality.FINAL) {
            trace2.report(Errors.INLINE_CLASS_NOT_FINAL.on(modalityModifier));
            return;
        }
        KtPrimaryConstructor primaryConstructor2 = ((KtClass)declaration).getPrimaryConstructor();
        if (primaryConstructor2 == null) {
            trace2.report(Errors.ABSENCE_OF_PRIMARY_CONSTRUCTOR_FOR_INLINE_CLASS.on((KtClass)declaration));
            return;
        }
        List<KtParameter> list2 = primaryConstructor2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "primaryConstructor.valueParameters");
        KtParameter baseParameter = CollectionsKt.singleOrNull(list2);
        if (baseParameter == null) {
            KtElementImplStub ktElementImplStub;
            KtParameterList ktParameterList = primaryConstructor2.getValueParameterList();
            KtElementImplStub it = ktElementImplStub = ktParameterList != null ? (KtElementImplStub)ktParameterList : (KtElementImplStub)((Object)declaration);
            trace2.report(Errors.INLINE_CLASS_CONSTRUCTOR_WRONG_PARAMETERS_SIZE.on((KtElement)((PsiElement)it)));
            return;
        }
        if (!this.isParameterAcceptableForInlineClass(baseParameter)) {
            trace2.report(Errors.INLINE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER.on((KtParameter)((PsiElement)baseParameter)));
            return;
        }
    }

    private final boolean isParameterAcceptableForInlineClass(KtParameter parameter) {
        UserDataHolder userDataHolder = KtPsiUtilKt.modalityModifier(parameter);
        boolean isOpen = Intrinsics.areEqual(userDataHolder != null && (userDataHolder = userDataHolder.getNode()) != null ? userDataHolder.getElementType() : null, KtTokens.OPEN_KEYWORD);
        return parameter.hasValOrVar() && !parameter.isMutable() && !parameter.isVarArg() && !parameter.hasDefaultValue() && !isOpen;
    }

    private InlineClassDeclarationChecker() {
    }

    static {
        InlineClassDeclarationChecker inlineClassDeclarationChecker;
        INSTANCE = inlineClassDeclarationChecker = new InlineClassDeclarationChecker();
    }
}

