/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorVisitor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 72\u00020\u0001:\u00017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u000b\u001a\u00020\f2\u001a\u0010\r\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0011J$\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001b2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0011J$\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J.\u0010!\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010#\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000e2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%H\u0002J.\u0010&\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020 H\u0002J&\u0010+\u001a\u00020)2\u0014\u0010,\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001b0\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0002J1\u0010-\u001a\u0012\u0012\u0004\u0012\u00020/\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0.2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b0J*\u00101\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u000f2\u0006\u00102\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u00103\u001a\u00020\f2\u0006\u00104\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u00105\u001a\u0002062\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "getLanguageVersionSettings$frontend", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getModule$frontend", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "checkArgumentsAreCompileTimeConstants", "", "argumentsWithComponentType", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/types/KotlinType;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkCompileTimeConstant", "argumentExpression", "expectedType", "evaluateExpression", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "expression", "evaluateToConstantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "getAnnotationArgumentValue", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "getArgumentExpressionsForArrayCall", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getArgumentExpressionsForArrayLikeCall", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "getArgumentExpressionsForCollectionLiteralCall", "Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;", "hasSpread", "", "argument", "isArrayPassedInNamedForm", "constants", "resolveAnnotationArguments", "", "Lorg/jetbrains/kotlin/name/Name;", "resolveAnnotationArguments$frontend", "resolveAnnotationValueArguments", "resolvedValueArgument", "updateNumberType", "numberType", "statementFilter", "Lorg/jetbrains/kotlin/resolve/StatementFilter;", "Companion", "frontend"})
public final class ConstantExpressionEvaluator {
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    public static final Companion Companion = new Companion(null);

    public final void updateNumberType(@NotNull KotlinType numberType, @Nullable KtExpression expression2, @NotNull StatementFilter statementFilter, @NotNull BindingTrace trace2) {
        Intrinsics.checkParameterIsNotNull(numberType, "numberType");
        Intrinsics.checkParameterIsNotNull(statementFilter, "statementFilter");
        Intrinsics.checkParameterIsNotNull(trace2, "trace");
        if (expression2 == null) {
            return;
        }
        BindingContextUtils.updateRecordedType(numberType, expression2, trace2, false);
        if (!(expression2 instanceof KtConstantExpression)) {
            KtExpression deparenthesized = KtPsiUtil.getLastElementDeparenthesized(expression2, statementFilter);
            if (deparenthesized != expression2) {
                this.updateNumberType(numberType, deparenthesized, statementFilter, trace2);
            }
            return;
        }
        this.evaluateExpression(expression2, trace2, numberType);
    }

    @NotNull
    public final Map<Name, ConstantValue<?>> resolveAnnotationArguments$frontend(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BindingTrace trace2) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(trace2, "trace");
        HashMap arguments2 = new HashMap();
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = resolvedCall2.getValueArguments().entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry2 = entry = iterator2.next();
            ValueParameterDescriptor parameterDescriptor = entry2.getKey();
            entry2 = entry;
            ResolvedValueArgument resolvedArgument = entry2.getValue();
            ValueParameterDescriptor valueParameterDescriptor = parameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "parameterDescriptor");
            ResolvedValueArgument resolvedValueArgument = resolvedArgument;
            Intrinsics.checkExpressionValueIsNotNull(resolvedValueArgument, "resolvedArgument");
            ConstantValue<?> value = this.getAnnotationArgumentValue(trace2, valueParameterDescriptor, resolvedValueArgument);
            if (value == null) continue;
            arguments2.put(parameterDescriptor.getName(), value);
        }
        return arguments2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ConstantValue<?> getAnnotationArgumentValue(@NotNull BindingTrace trace2, @NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ResolvedValueArgument resolvedArgument) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        KotlinType constantType;
        Intrinsics.checkParameterIsNotNull(trace2, "trace");
        Intrinsics.checkParameterIsNotNull(parameterDescriptor, "parameterDescriptor");
        Intrinsics.checkParameterIsNotNull(resolvedArgument, "resolvedArgument");
        KotlinType varargElementType = parameterDescriptor.getVarargElementType();
        boolean argumentsAsVararg = varargElementType != null && !this.hasSpread(resolvedArgument);
        KotlinType kotlinType = constantType = argumentsAsVararg ? varargElementType : parameterDescriptor.getType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        List<CompileTimeConstant<?>> compileTimeConstants = this.resolveAnnotationValueArguments(resolvedArgument, kotlinType, trace2);
        Iterable iterable = $receiver$iv = (Iterable)compileTimeConstants;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            CompileTimeConstant compileTimeConstant = (CompileTimeConstant)item$iv$iv;
            Collection collection = destination$iv$iv;
            ConstantValue constantValue = it.toConstantValue(constantType);
            collection.add(constantValue);
        }
        List constants = (List)destination$iv$iv;
        if (argumentsAsVararg) {
            if (this.isArrayPassedInNamedForm(constants, resolvedArgument)) {
                return (ConstantValue)CollectionsKt.single(constants);
            }
            if (parameterDescriptor.declaresDefaultValue() && compileTimeConstants.isEmpty()) {
                return null;
            }
            KotlinType kotlinType2 = parameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "parameterDescriptor.type");
            return ConstantValueFactory.INSTANCE.createArrayValue(constants, kotlinType2);
        }
        return (ConstantValue)CollectionsKt.lastOrNull(constants);
    }

    private final boolean isArrayPassedInNamedForm(List<? extends ConstantValue<? extends Object>> constants, ResolvedValueArgument resolvedArgument) {
        ConstantValue<? extends Object> constantValue = CollectionsKt.singleOrNull(constants);
        if (constantValue == null) {
            return false;
        }
        ConstantValue<? extends Object> constant = constantValue;
        List<ValueArgument> list2 = resolvedArgument.getArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, "resolvedArgument.arguments");
        ValueArgument valueArgument = CollectionsKt.singleOrNull(list2);
        if (valueArgument == null) {
            return false;
        }
        ValueArgument argument = valueArgument;
        return constant instanceof ArrayValue && argument.isNamed();
    }

    private final void checkCompileTimeConstant(KtExpression argumentExpression, KotlinType expectedType2, BindingTrace trace2) {
        Pair<List<KtExpression>, KotlinType> it;
        Pair<List<KtExpression>, KotlinType> pair;
        KotlinType expressionType = trace2.getType(argumentExpression);
        if (expressionType == null || !KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, expectedType2)) {
            return;
        }
        if (argumentExpression instanceof KtCallExpression) {
            Pair<List<KtExpression>, KotlinType> pair2 = this.getArgumentExpressionsForArrayCall((KtCallExpression)argumentExpression, trace2);
            if (pair2 != null) {
                it = pair = pair2;
                this.checkArgumentsAreCompileTimeConstants(it, trace2);
            }
        }
        if (argumentExpression instanceof KtCollectionLiteralExpression) {
            Pair<List<KtExpression>, KotlinType> pair3 = this.getArgumentExpressionsForCollectionLiteralCall((KtCollectionLiteralExpression)argumentExpression, trace2);
            if (pair3 != null) {
                it = pair = pair3;
                this.checkArgumentsAreCompileTimeConstants(it, trace2);
            }
        }
        BindingContext bindingContext = trace2.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        CompileTimeConstant<?> constant = Companion.getConstant(argumentExpression, bindingContext);
        if (constant != null && constant.getCanBeUsedInAnnotations()) {
            DoubleColonLHS doubleColonLhs;
            KtExpression lhsExpression;
            if (constant.getUsesNonConstValAsConstant()) {
                trace2.report(Errors.NON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION.on((KtExpression)((PsiElement)argumentExpression)));
            }
            if (argumentExpression instanceof KtClassLiteralExpression && (lhsExpression = ((KtClassLiteralExpression)argumentExpression).getReceiverExpression()) != null && (doubleColonLhs = (DoubleColonLHS)trace2.getBindingContext().get(BindingContext.DOUBLE_COLON_LHS, lhsExpression)) instanceof DoubleColonLHS.Expression && !((DoubleColonLHS.Expression)doubleColonLhs).isObjectQualifier()) {
                trace2.report(Errors.ANNOTATION_PARAMETER_MUST_BE_KCLASS_LITERAL.on((KtExpression)((PsiElement)argumentExpression)));
            }
            return;
        }
        ClassifierDescriptor descriptor2 = expressionType.getConstructor().getDeclarationDescriptor();
        if (descriptor2 != null && DescriptorUtils.isEnumClass(descriptor2)) {
            trace2.report(Errors.ANNOTATION_PARAMETER_MUST_BE_ENUM_CONST.on((KtExpression)((PsiElement)argumentExpression)));
        } else if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2)) {
            trace2.report(Errors.ANNOTATION_PARAMETER_MUST_BE_KCLASS_LITERAL.on((KtExpression)((PsiElement)argumentExpression)));
        } else {
            trace2.report(Errors.ANNOTATION_PARAMETER_MUST_BE_CONST.on((KtExpression)((PsiElement)argumentExpression)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkArgumentsAreCompileTimeConstants(Pair<? extends List<? extends KtExpression>, ? extends KotlinType> argumentsWithComponentType, BindingTrace trace2) {
        void arguments2;
        Pair<? extends List<? extends KtExpression>, ? extends KotlinType> pair = argumentsWithComponentType;
        List<? extends KtExpression> list2 = pair.component1();
        KotlinType componentType = pair.component2();
        for (KtExpression expression2 : arguments2) {
            KotlinType kotlinType = componentType;
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            this.checkCompileTimeConstant(expression2, kotlinType, trace2);
        }
    }

    private final Pair<List<KtExpression>, KotlinType> getArgumentExpressionsForArrayCall(KtCallExpression expression2, BindingTrace trace2) {
        KtElement ktElement = expression2;
        BindingContext bindingContext = trace2.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        return this.getArgumentExpressionsForArrayLikeCall(resolvedCall3);
    }

    private final Pair<List<KtExpression>, KotlinType> getArgumentExpressionsForCollectionLiteralCall(KtCollectionLiteralExpression expression2, BindingTrace trace2) {
        ResolvedCall resolvedCall2;
        ResolvedCall resolvedCall3 = (ResolvedCall)trace2.get(BindingContext.COLLECTION_LITERAL_CALL, expression2);
        if (resolvedCall3 == null) {
            return null;
        }
        ResolvedCall resolvedCall4 = resolvedCall2 = resolvedCall3;
        Intrinsics.checkExpressionValueIsNotNull(resolvedCall4, "resolvedCall");
        return this.getArgumentExpressionsForArrayLikeCall(resolvedCall4);
    }

    private final Pair<List<KtExpression>, KotlinType> getArgumentExpressionsForArrayLikeCall(ResolvedCall<?> resolvedCall2) {
        if (!CompileTimeConstantUtils.isArrayFunctionCall(resolvedCall2)) {
            return null;
        }
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, "resolvedCall.resultingDescriptor");
        KotlinType kotlinType = obj.getReturnType();
        if (kotlinType == null) {
            return null;
        }
        KotlinType returnType = kotlinType;
        KotlinType componentType = this.module.getBuiltIns().getArrayElementType(returnType);
        ArrayList<KtExpression> result2 = new ArrayList<KtExpression>();
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = resolvedCall2.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(map2, "resolvedCall.valueArguments");
        Map<ValueParameterDescriptor, ResolvedValueArgument> map3 = map2;
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            ResolvedValueArgument resolvedValueArgument;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry2 = entry = iterator2.next();
            ResolvedValueArgument resolvedValueArgument2 = resolvedValueArgument = entry2.getValue();
            Intrinsics.checkExpressionValueIsNotNull(resolvedValueArgument2, "resolvedValueArgument");
            for (ValueArgument valueArgument : resolvedValueArgument2.getArguments()) {
                KtExpression valueArgumentExpression = valueArgument.getArgumentExpression();
                if (valueArgumentExpression == null) continue;
                result2.add(valueArgumentExpression);
            }
        }
        KotlinType kotlinType2 = componentType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "componentType");
        return new Pair<List<KtExpression>, KotlinType>(result2, kotlinType2);
    }

    private final boolean hasSpread(ResolvedValueArgument argument) {
        List<ValueArgument> arguments2 = argument.getArguments();
        return arguments2.size() == 1 && arguments2.get(0).getSpreadElement() != null;
    }

    private final List<CompileTimeConstant<?>> resolveAnnotationValueArguments(ResolvedValueArgument resolvedValueArgument, KotlinType expectedType2, BindingTrace trace2) {
        ArrayList constants = new ArrayList();
        for (ValueArgument argument : resolvedValueArgument.getArguments()) {
            KtExpression argumentExpression;
            if (argument.getArgumentExpression() == null) {
                continue;
            }
            CompileTimeConstant<?> constant = this.evaluateExpression(argumentExpression, trace2, expectedType2);
            if (constant instanceof IntegerValueTypeConstant) {
                KotlinType defaultType2 = ((IntegerValueTypeConstant)constant).getType(expectedType2);
                this.updateNumberType(defaultType2, argumentExpression, StatementFilter.NONE, trace2);
            }
            if (constant != null) {
                constants.add(constant);
            }
            this.checkCompileTimeConstant(argumentExpression, expectedType2, trace2);
        }
        return constants;
    }

    @Nullable
    public final CompileTimeConstant<?> evaluateExpression(@NotNull KtExpression expression2, @NotNull BindingTrace trace2, @Nullable KotlinType expectedType2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(trace2, "trace");
        ConstantExpressionEvaluatorVisitor visitor2 = new ConstantExpressionEvaluatorVisitor(this, trace2);
        CompileTimeConstant<?> compileTimeConstant = visitor2.evaluate(expression2, expectedType2);
        if (compileTimeConstant == null) {
            return null;
        }
        CompileTimeConstant<?> constant = compileTimeConstant;
        return !constant.isError() ? constant : null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ CompileTimeConstant evaluateExpression$default(ConstantExpressionEvaluator constantExpressionEvaluator, KtExpression ktExpression, BindingTrace bindingTrace, KotlinType kotlinType, int n, Object object) {
        if ((n & 4) != 0) {
            kotlinType = TypeUtils.NO_EXPECTED_TYPE;
        }
        return constantExpressionEvaluator.evaluateExpression(ktExpression, bindingTrace, kotlinType);
    }

    @Nullable
    public final ConstantValue<?> evaluateToConstantValue(@NotNull KtExpression expression2, @NotNull BindingTrace trace2, @NotNull KotlinType expectedType2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(trace2, "trace");
        Intrinsics.checkParameterIsNotNull(expectedType2, "expectedType");
        CompileTimeConstant<?> compileTimeConstant = this.evaluateExpression(expression2, trace2, expectedType2);
        return compileTimeConstant != null ? compileTimeConstant.toConstantValue(expectedType2) : null;
    }

    @NotNull
    public final ModuleDescriptor getModule$frontend() {
        return this.module;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings$frontend() {
        return this.languageVersionSettings;
    }

    public ConstantExpressionEvaluator(@NotNull ModuleDescriptor module2, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull(module2, "module");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        this.module = module2;
        this.languageVersionSettings = languageVersionSettings;
    }

    @JvmStatic
    @Nullable
    public static final CompileTimeConstant<?> getConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext) {
        return Companion.getConstant(expression2, bindingContext);
    }

    @JvmStatic
    @Nullable
    public static final CompileTimeConstant<?> getPossiblyErrorConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext) {
        return Companion.getPossiblyErrorConstant(expression2, bindingContext);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001e\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator$Companion;", "", "()V", "getConstant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getPossiblyErrorConstant", "frontend"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final CompileTimeConstant<?> getConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
            CompileTimeConstant<?> compileTimeConstant = this.getPossiblyErrorConstant(expression2, bindingContext);
            if (compileTimeConstant == null) {
                return null;
            }
            CompileTimeConstant<?> constant = compileTimeConstant;
            return !constant.isError() ? constant : null;
        }

        @JvmStatic
        @Nullable
        public final CompileTimeConstant<?> getPossiblyErrorConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
            return (CompileTimeConstant)bindingContext.get(BindingContext.COMPILE_TIME_VALUE, expression2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

