/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.NotFoundClasses;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.AnnotationDeserializer$WhenMappings;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J>\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0014\u0010!\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u001f\u001a\u00020 H\u0002J\"\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/AnnotationDeserializer;", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "notFoundClasses", "Lorg/jetbrains/kotlin/descriptors/NotFoundClasses;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/descriptors/NotFoundClasses;)V", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "deserializeAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "proto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Annotation;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "resolveArgument", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Annotation$Argument;", "parameterByName", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "resolveArrayElementType", "Lorg/jetbrains/kotlin/types/SimpleType;", "value", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Annotation$Argument$Value;", "resolveClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "resolveClassLiteralValue", "resolveValue", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "deserialization"})
public final class AnnotationDeserializer {
    private final ModuleDescriptor module;
    private final NotFoundClasses notFoundClasses;

    private final KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnnotationDescriptor deserializeAnnotation(@NotNull ProtoBuf.Annotation proto, @NotNull NameResolver nameResolver) {
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        ClassId classId = nameResolver.getClassId(proto.getId());
        Intrinsics.checkExpressionValueIsNotNull(classId, "nameResolver.getClassId(proto.id)");
        ClassDescriptor annotationClass = this.resolveClass(classId);
        Map<Name, ConstantValue<Object>> arguments2 = MapsKt.emptyMap();
        if (proto.getArgumentCount() != 0 && !ErrorUtils.isError(annotationClass) && DescriptorUtils.isAnnotationClass(annotationClass)) {
            Collection<ClassConstructorDescriptor> collection = annotationClass.getConstructors();
            Intrinsics.checkExpressionValueIsNotNull(collection, "annotationClass.constructors");
            ClassConstructorDescriptor constructor = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (constructor != null) {
                void $receiver$iv$iv;
                void $receiver$iv$iv2;
                List<ValueParameterDescriptor> list2 = constructor.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, "constructor.valueParameters");
                Iterable $receiver$iv = list2;
                int capacity$iv22 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
                Iterable iterable = $receiver$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
                for (Object element$iv$iv : $receiver$iv$iv2) {
                    void it;
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)element$iv$iv;
                    Map map2 = destination$iv$iv;
                    void v3 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v3, "it");
                    Name name = v3.getName();
                    map2.put(name, element$iv$iv);
                }
                Map parameterByName = destination$iv$iv;
                List<ProtoBuf.Annotation.Argument> list3 = proto.getArgumentList();
                Intrinsics.checkExpressionValueIsNotNull(list3, "proto.argumentList");
                Iterable capacity$iv22 = $receiver$iv = (Iterable)list3;
                Collection destination$iv$iv2 = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                Iterator iterator2 = $receiver$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Pair<Name, ConstantValue<?>> pair;
                    ProtoBuf.Annotation.Argument it;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    ProtoBuf.Annotation.Argument argument = it = (ProtoBuf.Annotation.Argument)element$iv$iv;
                    Intrinsics.checkExpressionValueIsNotNull(argument, "it");
                    if (this.resolveArgument(argument, parameterByName, nameResolver) == null) continue;
                    Pair<Name, ConstantValue<?>> it$iv$iv = pair;
                    destination$iv$iv2.add(it$iv$iv);
                }
                arguments2 = MapsKt.toMap((List)destination$iv$iv2);
            }
        }
        return new AnnotationDescriptorImpl(annotationClass.getDefaultType(), arguments2, SourceElement.NO_SOURCE);
    }

    private final Pair<Name, ConstantValue<?>> resolveArgument(ProtoBuf.Annotation.Argument proto, Map<Name, ? extends ValueParameterDescriptor> parameterByName, NameResolver nameResolver) {
        ValueParameterDescriptor valueParameterDescriptor = parameterByName.get(nameResolver.getName(proto.getNameId()));
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor parameter = valueParameterDescriptor;
        Name name = nameResolver.getName(proto.getNameId());
        KotlinType kotlinType = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "parameter.type");
        ProtoBuf.Annotation.Argument.Value value = proto.getValue();
        Intrinsics.checkExpressionValueIsNotNull(value, "proto.value");
        return new Pair(name, this.resolveValue(kotlinType, value, nameResolver));
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final ConstantValue<?> resolveValue(@NotNull KotlinType expectedType, @NotNull ProtoBuf.Annotation.Argument.Value value, @NotNull NameResolver nameResolver) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        v0 = value.getType();
        if (v0 == null) ** GOTO lbl-1000
        switch (AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
            case 1: {
                v1 = new ByteValue((byte)value.getIntValue());
                break;
            }
            case 2: {
                v1 = new CharValue((char)value.getIntValue());
                break;
            }
            case 3: {
                v1 = new ShortValue((short)value.getIntValue());
                break;
            }
            case 4: {
                v1 = new IntValue((int)value.getIntValue());
                break;
            }
            case 5: {
                v1 = new LongValue(value.getIntValue());
                break;
            }
            case 6: {
                v1 = new FloatValue(value.getFloatValue());
                break;
            }
            case 7: {
                v1 = new DoubleValue(value.getDoubleValue());
                break;
            }
            case 8: {
                v1 = new BooleanValue(value.getIntValue() != 0L);
                break;
            }
            case 9: {
                v2 = nameResolver.getString(value.getStringValue());
                Intrinsics.checkExpressionValueIsNotNull(v2, "nameResolver.getString(value.stringValue)");
                v1 = new StringValue(v2);
                break;
            }
            case 10: {
                v3 = nameResolver.getClassId(value.getClassId());
                Intrinsics.checkExpressionValueIsNotNull(v3, "nameResolver.getClassId(value.classId)");
                v1 = this.resolveClassLiteralValue(v3);
                break;
            }
            case 11: {
                v4 = nameResolver.getClassId(value.getClassId());
                Intrinsics.checkExpressionValueIsNotNull(v4, "nameResolver.getClassId(value.classId)");
                v5 = nameResolver.getName(value.getEnumValueId());
                Intrinsics.checkExpressionValueIsNotNull(v5, "nameResolver.getName(value.enumValueId)");
                v1 = new EnumValue(v4, v5);
                break;
            }
            case 12: {
                v6 = value.getAnnotation();
                Intrinsics.checkExpressionValueIsNotNull(v6, "value.annotation");
                v1 = new AnnotationValue(this.deserializeAnnotation(v6, nameResolver));
                break;
            }
            case 13: {
                expectedIsArray = KotlinBuiltIns.isArray(expectedType) != false || KotlinBuiltIns.isPrimitiveArray(expectedType) != false;
                v7 = arrayElements = value.getArrayElementList();
                Intrinsics.checkExpressionValueIsNotNull(v7, "arrayElements");
                var8_7 = v7;
                if (var8_7.isEmpty() == false) {
                    v8 = CollectionsKt.first(arrayElements);
                    Intrinsics.checkExpressionValueIsNotNull(v8, "arrayElements.first()");
                    actualElementType = this.resolveArrayElementType(v8, nameResolver);
                    v9 = this.getBuiltIns().getPrimitiveArrayKotlinTypeByPrimitiveKotlinType(actualElementType);
                    if (v9 != null) {
                        v10 = v9;
                    } else {
                        v11 = this.getBuiltIns().getArrayType(Variance.INVARIANT, actualElementType);
                        Intrinsics.checkExpressionValueIsNotNull(v11, "builtIns.getArrayType(Va\u2026RIANT, actualElementType)");
                        v10 = v11;
                    }
                } else if (expectedIsArray) {
                    v10 = expectedType;
                } else {
                    v12 = this.getBuiltIns().getArrayType(Variance.INVARIANT, this.getBuiltIns().getAnyType());
                    Intrinsics.checkExpressionValueIsNotNull(v12, "builtIns.getArrayType(Va\u2026ARIANT, builtIns.anyType)");
                    v10 = v12;
                }
                actualArrayType = v10;
                expectedElementType = this.getBuiltIns().getArrayElementType(expectedIsArray != false ? expectedType : actualArrayType);
                var9_9 = arrayElements;
                var18_10 = ConstantValueFactory.INSTANCE;
                var10_11 = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    var14_15 = (ProtoBuf.Annotation.Argument.Value)item$iv$iv;
                    var19_16 = destination$iv$iv;
                    v13 = expectedElementType;
                    Intrinsics.checkExpressionValueIsNotNull(v13, "expectedElementType");
                    v14 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v14, "it");
                    var20_17 = this.resolveValue(v13, (ProtoBuf.Annotation.Argument.Value)v14, nameResolver);
                    var19_16.add(var20_17);
                }
                var19_16 = (List)destination$iv$iv;
                v1 = var18_10.createArrayValue((List<? extends ConstantValue<?>>)var19_16, actualArrayType);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                var5_5 = "Unsupported annotation argument type: " + value.getType() + " (expected " + expectedType + ')';
                throw (Throwable)new IllegalStateException(var5_5.toString());
            }
        }
        result = v1;
        return TypeUtilsKt.isSubtypeOf(result.getType(this.module), expectedType) != false ? result : (ConstantValue)ErrorValue.Companion.create("Unexpected argument value");
    }

    private final ConstantValue<?> resolveClassLiteralValue(ClassId classId) {
        SimpleType simpleType2 = this.resolveClass(classId).getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "resolveClass(classId).defaultType");
        KotlinType starProjectedType = TypeUtilsKt.replaceArgumentsWithStarProjections(simpleType2);
        ClassId classId2 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.kClass.toSafe());
        Intrinsics.checkExpressionValueIsNotNull(classId2, "ClassId.topLevel(KotlinB\u2026FQ_NAMES.kClass.toSafe())");
        ClassDescriptor kClass2 = this.resolveClass(classId2);
        SimpleType type2 = KotlinTypeFactory.simpleNotNullType(Annotations.Companion.getEMPTY(), kClass2, CollectionsKt.listOf(new TypeProjectionImpl(starProjectedType)));
        return new KClassValue(type2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final SimpleType resolveArrayElementType(ProtoBuf.Annotation.Argument.Value value, NameResolver nameResolver) {
        KotlinBuiltIns kotlinBuiltIns;
        KotlinBuiltIns $receiver = kotlinBuiltIns = this.getBuiltIns();
        ProtoBuf.Annotation.Argument.Value.Type type2 = value.getType();
        if (type2 != null) {
            switch (AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$1[type2.ordinal()]) {
                case 1: {
                    SimpleType simpleType2 = $receiver.getByteType();
                    SimpleType simpleType3 = simpleType2;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType2, "byteType");
                    return simpleType3;
                }
                case 2: {
                    SimpleType simpleType4 = $receiver.getCharType();
                    SimpleType simpleType3 = simpleType4;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType4, "charType");
                    return simpleType3;
                }
                case 3: {
                    SimpleType simpleType5 = $receiver.getShortType();
                    SimpleType simpleType3 = simpleType5;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType5, "shortType");
                    return simpleType3;
                }
                case 4: {
                    SimpleType simpleType6 = $receiver.getIntType();
                    SimpleType simpleType3 = simpleType6;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType6, "intType");
                    return simpleType3;
                }
                case 5: {
                    SimpleType simpleType7 = $receiver.getLongType();
                    SimpleType simpleType3 = simpleType7;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType7, "longType");
                    return simpleType3;
                }
                case 6: {
                    SimpleType simpleType8 = $receiver.getFloatType();
                    SimpleType simpleType3 = simpleType8;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType8, "floatType");
                    return simpleType3;
                }
                case 7: {
                    SimpleType simpleType9 = $receiver.getDoubleType();
                    SimpleType simpleType3 = simpleType9;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType9, "doubleType");
                    return simpleType3;
                }
                case 8: {
                    SimpleType simpleType10 = $receiver.getBooleanType();
                    SimpleType simpleType3 = simpleType10;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType10, "booleanType");
                    return simpleType3;
                }
                case 9: {
                    SimpleType simpleType11 = $receiver.getStringType();
                    SimpleType simpleType3 = simpleType11;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType11, "stringType");
                    return simpleType3;
                }
                case 10: {
                    String string = "Arrays of class literals are not supported yet";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                case 11: {
                    ClassId classId = nameResolver.getClassId(value.getClassId());
                    Intrinsics.checkExpressionValueIsNotNull(classId, "nameResolver.getClassId(value.classId)");
                    SimpleType simpleType12 = this.resolveClass(classId).getDefaultType();
                    SimpleType simpleType3 = simpleType12;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType12, "resolveClass(nameResolve\u2026lue.classId)).defaultType");
                    return simpleType3;
                }
                case 12: {
                    ProtoBuf.Annotation annotation2 = value.getAnnotation();
                    Intrinsics.checkExpressionValueIsNotNull(annotation2, "value.annotation");
                    ClassId classId = nameResolver.getClassId(annotation2.getId());
                    Intrinsics.checkExpressionValueIsNotNull(classId, "nameResolver.getClassId(value.annotation.id)");
                    SimpleType simpleType13 = this.resolveClass(classId).getDefaultType();
                    SimpleType simpleType3 = simpleType13;
                    Intrinsics.checkExpressionValueIsNotNull(simpleType13, "resolveClass(nameResolve\u2026notation.id)).defaultType");
                    return simpleType3;
                }
                case 13: {
                    String string = "Array of arrays is impossible";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
        }
        String string = "Unknown type: " + value.getType();
        throw (Throwable)new IllegalStateException(string.toString());
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(this.module, classId, this.notFoundClasses);
    }

    public AnnotationDeserializer(@NotNull ModuleDescriptor module2, @NotNull NotFoundClasses notFoundClasses) {
        Intrinsics.checkParameterIsNotNull(module2, "module");
        Intrinsics.checkParameterIsNotNull(notFoundClasses, "notFoundClasses");
        this.module = module2;
        this.notFoundClasses = notFoundClasses;
    }
}

