/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/types/checker/StrictEqualityTypeChecker;", "", "()V", "strictEqualTypes", "", "a", "Lorg/jetbrains/kotlin/types/SimpleType;", "b", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "descriptors"})
public final class StrictEqualityTypeChecker {
    public static final StrictEqualityTypeChecker INSTANCE;

    public final boolean strictEqualTypes(@NotNull UnwrappedType a2, @NotNull UnwrappedType b2) {
        Intrinsics.checkParameterIsNotNull(a2, "a");
        Intrinsics.checkParameterIsNotNull(b2, "b");
        if (a2 == b2) {
            return true;
        }
        if (a2 instanceof SimpleType && b2 instanceof SimpleType) {
            return this.strictEqualTypes((SimpleType)a2, (SimpleType)b2);
        }
        if (a2 instanceof FlexibleType && b2 instanceof FlexibleType) {
            return this.strictEqualTypes(((FlexibleType)a2).getLowerBound(), ((FlexibleType)b2).getLowerBound()) && this.strictEqualTypes(((FlexibleType)a2).getUpperBound(), ((FlexibleType)b2).getUpperBound());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean strictEqualTypes(@NotNull SimpleType a2, @NotNull SimpleType b2) {
        Intrinsics.checkParameterIsNotNull(a2, "a");
        Intrinsics.checkParameterIsNotNull(b2, "b");
        if (a2.isMarkedNullable() != b2.isMarkedNullable() || SpecialTypesKt.isDefinitelyNotNullType(a2) != SpecialTypesKt.isDefinitelyNotNullType(b2) || Intrinsics.areEqual(a2.getConstructor(), b2.getConstructor()) ^ true || a2.getArguments().size() != b2.getArguments().size()) {
            return false;
        }
        if (a2.getArguments() == b2.getArguments()) {
            return true;
        }
        int n = 0;
        int n2 = ((Collection)a2.getArguments()).size();
        while (n < n2) {
            void i2;
            TypeProjection aArg = a2.getArguments().get((int)i2);
            TypeProjection bArg = b2.getArguments().get((int)i2);
            if (aArg.isStarProjection() != bArg.isStarProjection()) {
                return false;
            }
            if (!aArg.isStarProjection()) {
                if (aArg.getProjectionKind() != bArg.getProjectionKind()) {
                    return false;
                }
                if (!this.strictEqualTypes(aArg.getType().unwrap(), bArg.getType().unwrap())) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    private StrictEqualityTypeChecker() {
    }

    static {
        StrictEqualityTypeChecker strictEqualityTypeChecker;
        INSTANCE = strictEqualityTypeChecker = new StrictEqualityTypeChecker();
    }
}

