/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitor;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.LambdaWithSuspendModifierCallChecker;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.tower.KotlinResolutionCallbacksImpl;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.LabelResolver;
import org.jetbrains.kotlin.types.expressions.PreliminaryLoopVisitor;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

public class ControlStructureTypingVisitor
extends ExpressionTypingVisitor {
    protected ControlStructureTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        super(facade);
    }

    @NotNull
    private DataFlowInfo checkCondition(@Nullable KtExpression condition, @NotNull ExpressionTypingContext context) {
        if (condition != null) {
            ExpressionTypingContext conditionContext = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(this.components.builtIns.getBooleanType())).replaceContextDependency(ContextDependency.INDEPENDENT);
            KotlinTypeInfo typeInfo = this.facade.getTypeInfo(condition, conditionContext);
            return this.components.dataFlowAnalyzer.checkType(typeInfo, condition, (ResolutionContext)conditionContext).getDataFlowInfo();
        }
        return context.dataFlowInfo;
    }

    @Override
    public KotlinTypeInfo visitIfExpression(@NotNull KtIfExpression expression2, ExpressionTypingContext context) {
        return this.visitIfExpression(expression2, context, false);
    }

    public KotlinTypeInfo visitIfExpression(KtIfExpression ifExpression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        this.components.dataFlowAnalyzer.recordExpectedType(contextWithExpectedType.trace, ifExpression, contextWithExpectedType.expectedType);
        ExpressionTypingContext context = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KtExpression condition = ifExpression.getCondition();
        DataFlowInfo conditionDataFlowInfo = this.checkCondition(condition, context);
        boolean loopBreakContinuePossibleInCondition = condition != null && this.containsJumpOutOfLoop(condition, context);
        KtExpression elseBranch = ifExpression.getElse();
        KtExpression thenBranch = ifExpression.getThen();
        LexicalWritableScope thenScope = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.THEN, this.components.overloadChecker);
        LexicalWritableScope elseScope = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.ELSE, this.components.overloadChecker);
        DataFlowInfo thenInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition, true, context).and(conditionDataFlowInfo);
        DataFlowInfo elseInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition, false, context).and(conditionDataFlowInfo);
        if (elseBranch == null) {
            if (thenBranch != null) {
                KotlinTypeInfo result2 = this.getTypeInfoWhenOnlyOneBranchIsPresent(thenBranch, thenScope, thenInfo, elseInfo, contextWithExpectedType, ifExpression);
                return result2.getJumpOutPossible() ? result2.replaceJumpOutPossible(true).replaceJumpFlowInfo(conditionDataFlowInfo) : result2;
            }
            return TypeInfoFactoryKt.createTypeInfo((KotlinType)this.components.builtIns.getUnitType(), thenInfo.or(elseInfo));
        }
        if (thenBranch == null) {
            return this.getTypeInfoWhenOnlyOneBranchIsPresent(elseBranch, elseScope, elseInfo, thenInfo, contextWithExpectedType, ifExpression);
        }
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory(ifExpression, false);
        KtBlockExpression thenBlock = psiFactory.wrapInABlockWrapper(thenBranch);
        KtBlockExpression elseBlock = psiFactory.wrapInABlockWrapper(elseBranch);
        Call callForIf = ControlStructureTypingUtils.createCallForSpecialConstruction(ifExpression, ifExpression, Lists.newArrayList(thenBlock, elseBlock));
        MutableDataFlowInfoForArguments dataFlowInfoForArguments = ControlStructureTypingUtils.createDataFlowInfoForArgumentsForIfCall(callForIf, conditionDataFlowInfo, thenInfo, elseInfo);
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(callForIf, ControlStructureTypingUtils.ResolveConstruct.IF, Lists.newArrayList("thenBranch", "elseBranch"), Lists.newArrayList(false, false), contextWithExpectedType, dataFlowInfoForArguments);
        return this.processBranches(ifExpression, contextWithExpectedType, context, conditionDataFlowInfo, loopBreakContinuePossibleInCondition, elseBranch, thenBranch, resolvedCall2);
    }

    @NotNull
    private KotlinTypeInfo processBranches(KtIfExpression ifExpression, ExpressionTypingContext contextWithExpectedType, ExpressionTypingContext context, DataFlowInfo conditionDataFlowInfo, boolean loopBreakContinuePossibleInCondition, KtExpression elseBranch, KtExpression thenBranch, ResolvedCall<FunctionDescriptor> resolvedCall2) {
        DataFlowInfo resultDataFlowInfo;
        BindingContext bindingContext = context.trace.getBindingContext();
        KotlinTypeInfo thenTypeInfo = BindingContextUtils.getRecordedTypeInfo(thenBranch, bindingContext);
        KotlinTypeInfo elseTypeInfo = BindingContextUtils.getRecordedTypeInfo(elseBranch, bindingContext);
        boolean isThenPostponed = ArgumentTypeResolver.isFunctionLiteralOrCallableReference(thenBranch, context);
        boolean isElsePostponed = ArgumentTypeResolver.isFunctionLiteralOrCallableReference(thenBranch, context);
        assert (thenTypeInfo != null || elseTypeInfo != null || isThenPostponed || isElsePostponed) : "Both branches of if expression were not processed: " + ifExpression.getText();
        if (thenTypeInfo == null && elseTypeInfo == null) {
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        KotlinType resultType = resolvedCall2.getResultingDescriptor().getReturnType();
        boolean loopBreakContinuePossible = loopBreakContinuePossibleInCondition;
        if (elseTypeInfo == null) {
            loopBreakContinuePossible |= thenTypeInfo.getJumpOutPossible();
            resultDataFlowInfo = thenTypeInfo.getDataFlowInfo();
        } else if (thenTypeInfo == null) {
            loopBreakContinuePossible |= elseTypeInfo.getJumpOutPossible();
            resultDataFlowInfo = elseTypeInfo.getDataFlowInfo();
        } else {
            boolean jumpInElse;
            KotlinType thenType = thenTypeInfo.getType();
            KotlinType elseType = elseTypeInfo.getType();
            DataFlowInfo thenDataFlowInfo = thenTypeInfo.getDataFlowInfo();
            DataFlowInfo elseDataFlowInfo = elseTypeInfo.getDataFlowInfo();
            if (resultType != null && thenType != null && elseType != null) {
                DataFlowValue resultValue = this.components.dataFlowValueFactory.createDataFlowValue(ifExpression, resultType, context);
                DataFlowValue thenValue = this.components.dataFlowValueFactory.createDataFlowValue(thenBranch, thenType, context);
                thenDataFlowInfo = thenDataFlowInfo.assign(resultValue, thenValue, this.components.languageVersionSettings);
                DataFlowValue elseValue = this.components.dataFlowValueFactory.createDataFlowValue(elseBranch, elseType, context);
                elseDataFlowInfo = elseDataFlowInfo.assign(resultValue, elseValue, this.components.languageVersionSettings);
            }
            loopBreakContinuePossible |= thenTypeInfo.getJumpOutPossible() || elseTypeInfo.getJumpOutPossible();
            boolean jumpInThen = thenType != null && KotlinBuiltIns.isNothing(thenType);
            boolean bl = jumpInElse = elseType != null && KotlinBuiltIns.isNothing(elseType);
            resultDataFlowInfo = thenType == null && elseType == null ? thenDataFlowInfo.or(elseDataFlowInfo) : (thenType == null || jumpInThen && !jumpInElse ? elseDataFlowInfo : (elseType == null || jumpInElse && !jumpInThen ? thenDataFlowInfo : thenDataFlowInfo.or(elseDataFlowInfo)));
            if (thenType == null && jumpInElse || elseType == null && jumpInThen) {
                return TypeInfoFactoryKt.noTypeInfo(resultDataFlowInfo);
            }
        }
        return TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkType(resultType, (KtExpression)ifExpression, (ResolutionContext)contextWithExpectedType), resultDataFlowInfo, loopBreakContinuePossible, loopBreakContinuePossibleInCondition ? context.dataFlowInfo : conditionDataFlowInfo);
    }

    @NotNull
    private KotlinTypeInfo getTypeInfoWhenOnlyOneBranchIsPresent(@NotNull KtExpression presentBranch, @NotNull LexicalWritableScope presentScope, @NotNull DataFlowInfo presentInfo, @NotNull DataFlowInfo otherInfo, @NotNull ExpressionTypingContext context, @NotNull KtIfExpression ifExpression) {
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceDataFlowInfo(presentInfo)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KotlinTypeInfo typeInfo = this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(presentScope, Collections.singletonList(presentBranch), CoercionStrategy.NO_COERCION, newContext);
        KotlinType type2 = typeInfo.getType();
        DataFlowInfo dataFlowInfo = type2 != null && KotlinBuiltIns.isNothing(type2) ? otherInfo : typeInfo.getDataFlowInfo().or(otherInfo);
        return this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(this.components.builtIns.getUnitType()), (KtExpression)ifExpression, (ResolutionContext)context).replaceDataFlowInfo(dataFlowInfo);
    }

    @Override
    public KotlinTypeInfo visitWhileExpression(@NotNull KtWhileExpression expression2, ExpressionTypingContext context) {
        return this.visitWhileExpression(expression2, context, false);
    }

    public KotlinTypeInfo visitWhileExpression(KtWhileExpression expression2, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        KotlinTypeInfo bodyTypeInfo;
        if (!isStatement) {
            return this.components.dataFlowAnalyzer.illegalStatementType(expression2, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        PreliminaryLoopVisitor loopVisitor = PreliminaryLoopVisitor.visitLoop(expression2);
        context = (ExpressionTypingContext)context.replaceDataFlowInfo(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(context.dataFlowInfo, this.components.languageVersionSettings));
        KtExpression condition = expression2.getCondition();
        DataFlowInfo dataFlowInfo = this.checkCondition(condition, context);
        KtExpression body2 = expression2.getBody();
        DataFlowInfo conditionInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition, true, context).and(dataFlowInfo);
        if (body2 != null) {
            LexicalWritableScope scopeToExtend = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.WHILE_BODY, this.components.overloadChecker);
            bodyTypeInfo = this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(scopeToExtend, Collections.singletonList(body2), CoercionStrategy.NO_COERCION, (ExpressionTypingContext)context.replaceDataFlowInfo(conditionInfo));
        } else {
            bodyTypeInfo = TypeInfoFactoryKt.noTypeInfo(conditionInfo);
        }
        if (!this.containsJumpOutOfLoop(expression2, context)) {
            dataFlowInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition, false, context).and(dataFlowInfo);
        }
        if (body2 != null && KtPsiUtil.isTrueConstant(condition)) {
            dataFlowInfo = dataFlowInfo.and(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(bodyTypeInfo.getJumpFlowInfo(), this.components.languageVersionSettings));
        }
        return this.components.dataFlowAnalyzer.checkType(bodyTypeInfo.replaceType(this.components.builtIns.getUnitType()), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType).replaceDataFlowInfo(dataFlowInfo);
    }

    private boolean containsJumpOutOfLoop(final @NotNull KtExpression expression2, final ExpressionTypingContext context) {
        final boolean[] result2 = new boolean[]{false};
        expression2.accept(new KtTreeVisitor<List<KtLoopExpression>>(){

            @Override
            public Void visitBreakExpression(@NotNull KtBreakExpression breakExpression, List<KtLoopExpression> outerLoops) {
                PsiElement element;
                KtSimpleNameExpression targetLabel = breakExpression.getTargetLabel();
                PsiElement psiElement = element = targetLabel != null ? context.trace.get(BindingContext.LABEL_TARGET, targetLabel) : null;
                if (outerLoops.isEmpty() || element == expression2 || targetLabel == null && outerLoops.get(outerLoops.size() - 1) == expression2) {
                    result2[0] = true;
                }
                return null;
            }

            @Override
            public Void visitContinueExpression(@NotNull KtContinueExpression expression22, List<KtLoopExpression> outerLoops) {
                PsiElement element;
                KtSimpleNameExpression targetLabel = expression22.getTargetLabel();
                if (targetLabel != null && (element = context.trace.get(BindingContext.LABEL_TARGET, targetLabel)) instanceof KtLoopExpression && !outerLoops.contains(element)) {
                    result2[0] = true;
                }
                return null;
            }

            @Override
            public Void visitLoopExpression(@NotNull KtLoopExpression loopExpression, List<KtLoopExpression> outerLoops) {
                ArrayList<KtLoopExpression> newOuterLoops = Lists.newArrayList(outerLoops);
                newOuterLoops.add(loopExpression);
                return (Void)super.visitLoopExpression(loopExpression, newOuterLoops);
            }
        }, expression2 instanceof KtLoopExpression ? Lists.newArrayList((KtLoopExpression)expression2) : Lists.newArrayList());
        return result2[0];
    }

    @Override
    public KotlinTypeInfo visitDoWhileExpression(@NotNull KtDoWhileExpression expression2, ExpressionTypingContext context) {
        return this.visitDoWhileExpression(expression2, context, false);
    }

    public KotlinTypeInfo visitDoWhileExpression(KtDoWhileExpression expression2, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        KotlinTypeInfo bodyTypeInfo;
        if (!isStatement) {
            return this.components.dataFlowAnalyzer.illegalStatementType(expression2, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KtExpression body2 = expression2.getBody();
        LexicalScope conditionScope = context.scope;
        PreliminaryLoopVisitor loopVisitor = PreliminaryLoopVisitor.visitLoop(expression2);
        context = (ExpressionTypingContext)context.replaceDataFlowInfo(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(context.dataFlowInfo, this.components.languageVersionSettings));
        if (body2 instanceof KtLambdaExpression) {
            bodyTypeInfo = this.facade.getTypeInfo(body2, context);
        } else if (body2 != null) {
            LexicalWritableScope writableScope = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.DO_WHILE_BODY, this.components.overloadChecker);
            conditionScope = writableScope;
            List<KtExpression> block = body2 instanceof KtBlockExpression ? ((KtBlockExpression)body2).getStatements() : Collections.singletonList(body2);
            bodyTypeInfo = this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(writableScope, block, CoercionStrategy.NO_COERCION, context);
        } else {
            bodyTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        }
        KtExpression condition = expression2.getCondition();
        DataFlowInfo conditionDataFlowInfo = this.checkCondition(condition, (ExpressionTypingContext)context.replaceScope(conditionScope));
        DataFlowInfo dataFlowInfo = !this.containsJumpOutOfLoop(expression2, context) ? this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition, false, context).and(conditionDataFlowInfo) : context.dataFlowInfo;
        if (body2 != null) {
            dataFlowInfo = dataFlowInfo.and(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(bodyTypeInfo.getJumpFlowInfo(), this.components.languageVersionSettings));
        }
        return this.components.dataFlowAnalyzer.checkType(bodyTypeInfo.replaceType(this.components.builtIns.getUnitType()), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType).replaceDataFlowInfo(dataFlowInfo);
    }

    @Override
    public KotlinTypeInfo visitForExpression(@NotNull KtForExpression expression2, ExpressionTypingContext context) {
        return this.visitForExpression(expression2, context, false);
    }

    public KotlinTypeInfo visitForExpression(KtForExpression expression2, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        KtExpression body2;
        KotlinTypeInfo loopRangeInfo;
        if (!isStatement) {
            return this.components.dataFlowAnalyzer.illegalStatementType(expression2, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        PreliminaryLoopVisitor loopVisitor = PreliminaryLoopVisitor.visitLoop(expression2);
        context = (ExpressionTypingContext)context.replaceDataFlowInfo(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(context.dataFlowInfo, this.components.languageVersionSettings));
        KtExpression loopRange = expression2.getLoopRange();
        KotlinType expectedParameterType = null;
        if (loopRange != null) {
            ExpressionReceiver loopRangeReceiver = ExpressionTypingUtils.getExpressionReceiver(this.facade, loopRange, context);
            loopRangeInfo = this.facade.getTypeInfo(loopRange, context);
            if (loopRangeReceiver != null) {
                expectedParameterType = this.components.forLoopConventionsChecker.checkIterableConvention(loopRangeReceiver, context);
            }
        } else {
            loopRangeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        }
        LexicalWritableScope loopScope = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.FOR, this.components.overloadChecker);
        KtParameter loopParameter = expression2.getLoopParameter();
        if (loopParameter != null) {
            VariableDescriptor variableDescriptor = this.createLoopParameterDescriptor(loopParameter, expectedParameterType, context);
            ModifiersChecker.ModifiersCheckingProcedure modifiersCheckingProcedure = this.components.modifiersChecker.withTrace(context.trace);
            modifiersCheckingProcedure.checkModifiersForLocalDeclaration(loopParameter, variableDescriptor);
            this.components.identifierChecker.checkDeclaration(loopParameter, context.trace);
            loopScope.addVariableDescriptor(variableDescriptor);
            KtDestructuringDeclaration multiParameter = loopParameter.getDestructuringDeclaration();
            if (multiParameter != null) {
                KotlinType elementType = expectedParameterType == null ? ErrorUtils.createErrorType("Loop range has no type") : expectedParameterType;
                TransientReceiver iteratorNextAsReceiver = new TransientReceiver(elementType);
                this.components.annotationResolver.resolveAnnotationsWithArguments((LexicalScope)loopScope, loopParameter.getModifierList(), context.trace);
                this.components.destructuringDeclarationResolver.defineLocalVariablesFromDestructuringDeclaration(loopScope, multiParameter, iteratorNextAsReceiver, loopRange, context);
                modifiersCheckingProcedure.checkModifiersForDestructuringDeclaration(multiParameter);
                this.components.identifierChecker.checkDeclaration(multiParameter, context.trace);
            }
        }
        KotlinTypeInfo bodyTypeInfo = (body2 = expression2.getBody()) != null ? this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(loopScope, Collections.singletonList(body2), CoercionStrategy.NO_COERCION, (ExpressionTypingContext)context.replaceDataFlowInfo(loopRangeInfo.getDataFlowInfo())) : loopRangeInfo;
        return this.components.dataFlowAnalyzer.checkType(bodyTypeInfo.replaceType(this.components.builtIns.getUnitType()), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType).replaceDataFlowInfo(loopRangeInfo.getDataFlowInfo());
    }

    private VariableDescriptor createLoopParameterDescriptor(KtParameter loopParameter, KotlinType expectedParameterType, ExpressionTypingContext context) {
        VariableDescriptor variableDescriptor;
        this.components.modifiersChecker.withTrace(context.trace).checkParameterHasNoValOrVar(loopParameter, Errors.VAL_OR_VAR_ON_LOOP_PARAMETER);
        KtTypeReference typeReference = loopParameter.getTypeReference();
        if (typeReference != null) {
            variableDescriptor = this.components.descriptorResolver.resolveLocalVariableDescriptor(context.scope, loopParameter, context.trace);
            KotlinType actualParameterType = variableDescriptor.getType();
            if (expectedParameterType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(expectedParameterType, actualParameterType)) {
                context.trace.report(Errors.TYPE_MISMATCH_IN_FOR_LOOP.on(typeReference, expectedParameterType, actualParameterType));
            }
        } else {
            if (expectedParameterType == null) {
                expectedParameterType = ErrorUtils.createErrorType("Error");
            }
            variableDescriptor = this.components.descriptorResolver.resolveLocalVariableDescriptor(loopParameter, expectedParameterType, context.trace, context.scope);
        }
        ExpressionTypingUtils.checkVariableShadowing(context.scope, context.trace, variableDescriptor);
        return variableDescriptor;
    }

    @Override
    public KotlinTypeInfo visitTryExpression(@NotNull KtTryExpression expression2, ExpressionTypingContext typingContext) {
        ExpressionTypingContext context = (ExpressionTypingContext)typingContext.replaceContextDependency(ContextDependency.INDEPENDENT);
        KtBlockExpression tryBlock = expression2.getTryBlock();
        List<KtCatchClause> catchClauses = expression2.getCatchClauses();
        KtFinallySection finallyBlock = expression2.getFinallyBlock();
        ArrayList<KotlinType> types = new ArrayList<KotlinType>();
        boolean nothingInAllCatchBranches = true;
        for (KtCatchClause catchClause : catchClauses) {
            KtParameter catchParameter = catchClause.getCatchParameter();
            KtExpression catchBody = catchClause.getCatchBody();
            boolean nothingInCatchBranch = false;
            if (catchParameter != null) {
                this.checkCatchParameterDeclaration(catchParameter, context);
                VariableDescriptor variableDescriptor = this.components.descriptorResolver.resolveLocalVariableDescriptor(context.scope, catchParameter, context.trace);
                KotlinType catchParameterType = variableDescriptor.getType();
                ControlStructureTypingVisitor.checkCatchParameterType(catchParameter, catchParameterType, context);
                SimpleType throwableType = this.components.builtIns.getThrowable().getDefaultType();
                this.components.dataFlowAnalyzer.checkType(catchParameterType, (KtExpression)catchParameter, (ResolutionContext)context.replaceExpectedType(throwableType));
                if (catchBody != null) {
                    LexicalWritableScope catchScope = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.CATCH, this.components.overloadChecker);
                    catchScope.addVariableDescriptor(variableDescriptor);
                    KotlinType type2 = this.facade.getTypeInfo(catchBody, (ExpressionTypingContext)context.replaceScope(catchScope)).getType();
                    if (type2 != null) {
                        types.add(type2);
                        if (KotlinBuiltIns.isNothing(type2)) {
                            nothingInCatchBranch = true;
                        }
                    }
                }
            }
            if (nothingInCatchBranch) continue;
            nothingInAllCatchBranches = false;
        }
        KotlinTypeInfo tryResult = this.facade.getTypeInfo(tryBlock, context);
        ExpressionTypingContext tryOutputContext = (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        if (!nothingInAllCatchBranches && this.facade.getComponents().languageVersionSettings.supportsFeature(LanguageFeature.SoundSmartCastsAfterTry)) {
            PreliminaryLoopVisitor tryVisitor = PreliminaryLoopVisitor.visitTryBlock(expression2);
            tryOutputContext = (ExpressionTypingContext)tryOutputContext.replaceDataFlowInfo(tryVisitor.clearDataFlowInfoForAssignedLocalVariables(tryOutputContext.dataFlowInfo, this.components.languageVersionSettings));
        }
        KotlinTypeInfo result2 = TypeInfoFactoryKt.noTypeInfo(tryOutputContext);
        if (finallyBlock != null) {
            result2 = this.facade.getTypeInfo(finallyBlock.getFinalExpression(), tryOutputContext);
        } else if (nothingInAllCatchBranches) {
            result2 = tryResult;
        }
        KotlinType type3 = tryResult.getType();
        if (type3 != null) {
            types.add(type3);
        }
        if (types.isEmpty()) {
            return result2.clearType();
        }
        return result2.replaceType(CommonSupertypes.commonSupertype(types));
    }

    private static void checkCatchParameterType(KtParameter catchParameter, KotlinType catchParameterType, ExpressionTypingContext context) {
        TypeParameterDescriptor typeParameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(catchParameterType);
        if (typeParameterDescriptor != null) {
            if (typeParameterDescriptor.isReified()) {
                context.trace.report(Errors.REIFIED_TYPE_IN_CATCH_CLAUSE.on(catchParameter));
            } else {
                context.trace.report(Errors.TYPE_PARAMETER_IN_CATCH_CLAUSE.on(catchParameter));
            }
        }
    }

    private void checkCatchParameterDeclaration(KtParameter catchParameter, ExpressionTypingContext context) {
        this.components.identifierChecker.checkDeclaration(catchParameter, context.trace);
        ModifiersChecker.ModifiersCheckingProcedure modifiersChecking = this.components.modifiersChecker.withTrace(context.trace);
        modifiersChecking.checkParameterHasNoValOrVar(catchParameter, Errors.VAL_OR_VAR_ON_CATCH_PARAMETER);
        ModifierCheckerCore.INSTANCE.check(catchParameter, context.trace, null, this.components.languageVersionSettings);
        if (catchParameter.hasDefaultValue()) {
            context.trace.report(Errors.CATCH_PARAMETER_WITH_DEFAULT_VALUE.on(catchParameter));
        }
    }

    @Override
    public KotlinTypeInfo visitThrowExpression(@NotNull KtThrowExpression expression2, ExpressionTypingContext context) {
        KtExpression thrownExpression = expression2.getThrownExpression();
        if (thrownExpression != null) {
            SimpleType throwableType = this.components.builtIns.getThrowable().getDefaultType();
            this.facade.getTypeInfo(thrownExpression, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(throwableType)).replaceContextDependency(ContextDependency.INDEPENDENT));
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(this.components.builtIns.getNothingType(), context, expression2);
    }

    @Override
    public KotlinTypeInfo visitReturnExpression(@NotNull KtReturnExpression expression2, ExpressionTypingContext context) {
        SimpleFunctionDescriptor functionDescriptor;
        KtElement labelTargetElement = LabelResolver.INSTANCE.resolveControlLabel(expression2, context);
        KtExpression returnedExpression = expression2.getReturnedExpression();
        KotlinResolutionCallbacksImpl.LambdaInfo newInferenceLambdaInfo = null;
        KotlinType expectedType2 = TypeUtils.NO_EXPECTED_TYPE;
        SimpleType resultType = this.components.builtIns.getNothingType();
        KtDeclaration parentDeclaration = (KtDeclaration)context.getContextParentOfType(expression2, KtDeclaration.class);
        if (parentDeclaration instanceof KtParameter) {
            context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression2));
        }
        if (expression2.getTargetLabel() == null) {
            while (parentDeclaration instanceof KtDestructuringDeclaration) {
                parentDeclaration = (KtDeclaration)context.getContextParentOfType(parentDeclaration, KtDeclaration.class);
            }
            DeclarationDescriptor declarationDescriptor = context.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, parentDeclaration);
            com.intellij.openapi.util.Pair<FunctionDescriptor, PsiElement> containingFunInfo = BindingContextUtils.getContainingFunctionSkipFunctionLiterals(declarationDescriptor, false);
            FunctionDescriptor containingFunctionDescriptor = containingFunInfo.getFirst();
            if (containingFunctionDescriptor != null) {
                if (!InlineUtil.checkNonLocalReturnUsage(containingFunctionDescriptor, expression2, context) || ControlStructureTypingVisitor.isClassInitializer(containingFunInfo)) {
                    context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression2));
                    resultType = ErrorUtils.createErrorType("Return not allowed");
                }
                expectedType2 = ControlStructureTypingVisitor.getFunctionExpectedReturnType(containingFunctionDescriptor, (KtElement)containingFunInfo.getSecond(), context);
                newInferenceLambdaInfo = ControlStructureTypingVisitor.getNewInferenceLambdaInfo(context, (KtElement)containingFunInfo.getSecond());
            } else {
                context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression2));
                resultType = ErrorUtils.createErrorType("Return not allowed");
            }
        } else if (labelTargetElement != null && (functionDescriptor = context.trace.get(BindingContext.FUNCTION, labelTargetElement)) != null) {
            KtExpression callExpression;
            ResolvedCall<? extends CallableDescriptor> resolvedCall2;
            expectedType2 = ControlStructureTypingVisitor.getFunctionExpectedReturnType(functionDescriptor, labelTargetElement, context);
            newInferenceLambdaInfo = ControlStructureTypingVisitor.getNewInferenceLambdaInfo(context, labelTargetElement);
            if (!InlineUtil.checkNonLocalReturnUsage(functionDescriptor, expression2, context)) {
                context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression2));
                resultType = ErrorUtils.createErrorType("Return not allowed");
            } else if (labelTargetElement instanceof KtFunctionLiteral && Objects.equals(expression2.getLabelName(), "suspend") && (resolvedCall2 = CallUtilKt.getResolvedCall(callExpression = KtPsiUtil.getParentCallIfPresent((KtFunction)labelTargetElement), context.trace.getBindingContext())) != null && !KtPsiUtil.isLabeledFunctionLiteral((KtFunctionLiteral)labelTargetElement) && Objects.equals(DescriptorUtilsKt.fqNameOrNull(resolvedCall2.getResultingDescriptor()), LambdaWithSuspendModifierCallChecker.KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME)) {
                context.trace.report(Errors.RETURN_FOR_BUILT_IN_SUSPEND.on(expression2));
            }
        }
        if (returnedExpression != null) {
            if (newInferenceLambdaInfo != null) {
                KotlinTypeInfo result2 = this.facade.getTypeInfo(returnedExpression, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(newInferenceLambdaInfo.getExpectedType())).replaceContextDependency(newInferenceLambdaInfo.getContextDependency()));
                newInferenceLambdaInfo.getReturnStatements().add(new Pair<KtReturnExpression, KotlinTypeInfo>(expression2, result2));
            } else {
                this.facade.getTypeInfo(returnedExpression, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(expectedType2)).replaceContextDependency(ContextDependency.INDEPENDENT));
            }
        } else {
            if (!(TypeUtils.noExpectedType(expectedType2) || KotlinBuiltIns.isUnit(expectedType2) || TypeUtils.isDontCarePlaceholder(expectedType2))) {
                context.trace.report(Errors.RETURN_TYPE_MISMATCH.on(expression2, expectedType2));
            }
            if (newInferenceLambdaInfo != null) {
                newInferenceLambdaInfo.getReturnStatements().add(new Pair<KtReturnExpression, Object>(expression2, null));
            }
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(resultType, context, expression2);
    }

    private static boolean isClassInitializer(@NotNull com.intellij.openapi.util.Pair<FunctionDescriptor, PsiElement> containingFunInfo) {
        return containingFunInfo.getFirst() instanceof ConstructorDescriptor && !(containingFunInfo.getSecond() instanceof KtSecondaryConstructor);
    }

    @Override
    public KotlinTypeInfo visitBreakExpression(@NotNull KtBreakExpression expression2, ExpressionTypingContext context) {
        LabelResolver.INSTANCE.resolveControlLabel(expression2, context);
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(this.components.builtIns.getNothingType(), context, expression2).replaceJumpOutPossible(true);
    }

    @Override
    public KotlinTypeInfo visitContinueExpression(@NotNull KtContinueExpression expression2, ExpressionTypingContext context) {
        LabelResolver.INSTANCE.resolveControlLabel(expression2, context);
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(this.components.builtIns.getNothingType(), context, expression2).replaceJumpOutPossible(true);
    }

    @Nullable
    private static KotlinResolutionCallbacksImpl.LambdaInfo getNewInferenceLambdaInfo(@NotNull ExpressionTypingContext context, @NotNull KtElement function2) {
        if (function2 instanceof KtFunction) {
            return context.trace.get(BindingContext.NEW_INFERENCE_LAMBDA_INFO, (KtFunction)function2);
        }
        return null;
    }

    @NotNull
    private static KotlinType getFunctionExpectedReturnType(@NotNull FunctionDescriptor descriptor2, @NotNull KtElement function2, @NotNull ExpressionTypingContext context) {
        KotlinType expectedType2;
        if (function2 instanceof KtSecondaryConstructor) {
            expectedType2 = DescriptorUtilsKt.getBuiltIns(descriptor2).getUnitType();
        } else if (function2 instanceof KtFunction) {
            KtFunction ktFunction = (KtFunction)function2;
            expectedType2 = context.trace.get(BindingContext.EXPECTED_RETURN_TYPE, ktFunction);
            if (expectedType2 == null && (ktFunction.getTypeReference() != null || ktFunction.hasBlockBody())) {
                expectedType2 = descriptor2.getReturnType();
            }
        } else {
            expectedType2 = descriptor2.getReturnType();
        }
        return expectedType2 != null ? expectedType2 : TypeUtils.NO_EXPECTED_TYPE;
    }
}

