/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm;

import org.jetbrains.org.objectweb.asm.ByteVector;
import org.jetbrains.org.objectweb.asm.Edge;
import org.jetbrains.org.objectweb.asm.Frame;
import org.jetbrains.org.objectweb.asm.MethodWriter;

public class Label {
    public Object info;
    int status;
    int line;
    int position;
    private int referenceCount;
    private int[] srcAndRefPositions;
    int inputStackTop;
    int outputStackMax;
    Frame frame;
    Label successor;
    Edge successors;
    Label next;

    void put(MethodWriter owner, ByteVector out, int source2, boolean wideOffset) {
        if ((this.status & 2) == 0) {
            if (wideOffset) {
                this.addReference(-1 - source2, out.length);
                out.putInt(-1);
            } else {
                this.addReference(source2, out.length);
                out.putShort(-1);
            }
        } else if (wideOffset) {
            out.putInt(this.position - source2);
        } else {
            out.putShort(this.position - source2);
        }
    }

    private void addReference(int sourcePosition, int referencePosition) {
        if (this.srcAndRefPositions == null) {
            this.srcAndRefPositions = new int[6];
        }
        if (this.referenceCount >= this.srcAndRefPositions.length) {
            int[] a2 = new int[this.srcAndRefPositions.length + 6];
            System.arraycopy(this.srcAndRefPositions, 0, a2, 0, this.srcAndRefPositions.length);
            this.srcAndRefPositions = a2;
        }
        this.srcAndRefPositions[this.referenceCount++] = sourcePosition;
        this.srcAndRefPositions[this.referenceCount++] = referencePosition;
    }

    boolean resolve(MethodWriter owner, int position, byte[] data2) {
        boolean needUpdate = false;
        this.status |= 2;
        this.position = position;
        int i2 = 0;
        while (i2 < this.referenceCount) {
            int offset2;
            int source2 = this.srcAndRefPositions[i2++];
            int reference = this.srcAndRefPositions[i2++];
            if (source2 >= 0) {
                offset2 = position - source2;
                if (offset2 < Short.MIN_VALUE || offset2 > Short.MAX_VALUE) {
                    int opcode = data2[reference - 1] & 0xFF;
                    data2[reference - 1] = opcode <= 168 ? (byte)(opcode + 49) : (byte)(opcode + 20);
                    needUpdate = true;
                }
                data2[reference++] = (byte)(offset2 >>> 8);
                data2[reference] = (byte)offset2;
                continue;
            }
            offset2 = position + source2 + 1;
            data2[reference++] = (byte)(offset2 >>> 24);
            data2[reference++] = (byte)(offset2 >>> 16);
            data2[reference++] = (byte)(offset2 >>> 8);
            data2[reference] = (byte)offset2;
        }
        return needUpdate;
    }

    Label getFirst() {
        return this.frame == null ? this : this.frame.owner;
    }

    boolean inSubroutine(long id) {
        if ((this.status & 0x400) != 0) {
            return (this.srcAndRefPositions[(int)(id >>> 32)] & (int)id) != 0;
        }
        return false;
    }

    boolean inSameSubroutine(Label block) {
        if ((this.status & 0x400) == 0 || (block.status & 0x400) == 0) {
            return false;
        }
        for (int i2 = 0; i2 < this.srcAndRefPositions.length; ++i2) {
            if ((this.srcAndRefPositions[i2] & block.srcAndRefPositions[i2]) == 0) continue;
            return true;
        }
        return false;
    }

    void addToSubroutine(long id, int nbSubroutines) {
        if ((this.status & 0x400) == 0) {
            this.status |= 0x400;
            this.srcAndRefPositions = new int[nbSubroutines / 32 + 1];
        }
        int n = (int)(id >>> 32);
        this.srcAndRefPositions[n] = this.srcAndRefPositions[n] | (int)id;
    }

    void visitSubroutine(Label JSR, long id, int nbSubroutines) {
        Label stack = this;
        while (stack != null) {
            Edge e;
            Label l = stack;
            stack = l.next;
            l.next = null;
            if (JSR != null) {
                if ((l.status & 0x800) != 0) continue;
                l.status |= 0x800;
                if ((l.status & 0x100) != 0 && !l.inSameSubroutine(JSR)) {
                    e = new Edge();
                    e.info = l.inputStackTop;
                    e.successor = JSR.successors.successor;
                    e.next = l.successors;
                    l.successors = e;
                }
            } else {
                if (l.inSubroutine(id)) continue;
                l.addToSubroutine(id, nbSubroutines);
            }
            e = l.successors;
            while (e != null) {
                if (((l.status & 0x80) == 0 || e != l.successors.next) && e.successor.next == null) {
                    e.successor.next = stack;
                    stack = e.successor;
                }
                e = e.next;
            }
        }
    }

    public String toString() {
        return "L" + System.identityHashCode(this);
    }
}

