/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.examples;

import java.io.IOException;
import org.jsoup.Jsoup;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public class HtmlToPlainText {
    private static final String userAgent = "Mozilla/5.0 (jsoup)";
    private static final int timeout = 5000;

    public static void main(String ... args) throws IOException {
        Validate.isTrue(args.length == 1 || args.length == 2, "usage: java -cp jsoup.jar org.jsoup.examples.HtmlToPlainText url [selector]");
        String url = args[0];
        String selector = args.length == 2 ? args[1] : null;
        Document doc = Jsoup.connect(url).userAgent(userAgent).timeout(5000).get();
        HtmlToPlainText formatter = new HtmlToPlainText();
        if (selector != null) {
            Elements elements = doc.select(selector);
            for (Element element : elements) {
                String plainText = formatter.getPlainText(element);
                System.out.println(plainText);
            }
        } else {
            String plainText = formatter.getPlainText(doc);
            System.out.println(plainText);
        }
    }

    public String getPlainText(Element element) {
        FormattingVisitor formatter = new FormattingVisitor();
        NodeTraversor traversor = new NodeTraversor(formatter);
        traversor.traverse(element);
        return formatter.toString();
    }

    private class FormattingVisitor
    implements NodeVisitor {
        private static final int maxWidth = 80;
        private int width = 0;
        private StringBuilder accum = new StringBuilder();

        private FormattingVisitor() {
        }

        public void head(Node node, int depth) {
            String name = node.nodeName();
            if (node instanceof TextNode) {
                this.append(((TextNode)node).text());
            } else if (name.equals("li")) {
                this.append("\n * ");
            } else if (name.equals("dt")) {
                this.append("  ");
            } else if (StringUtil.in(name, "p", "h1", "h2", "h3", "h4", "h5", "tr")) {
                this.append("\n");
            }
        }

        public void tail(Node node, int depth) {
            String name = node.nodeName();
            if (StringUtil.in(name, "br", "dd", "dt", "p", "h1", "h2", "h3", "h4", "h5")) {
                this.append("\n");
            } else if (name.equals("a")) {
                this.append(String.format(" <%s>", node.absUrl("href")));
            }
        }

        private void append(String text2) {
            if (text2.startsWith("\n")) {
                this.width = 0;
            }
            if (text2.equals(" ") && (this.accum.length() == 0 || StringUtil.in(this.accum.substring(this.accum.length() - 1), " ", "\n"))) {
                return;
            }
            if (text2.length() + this.width > 80) {
                String[] words = text2.split("\\s+");
                for (int i2 = 0; i2 < words.length; ++i2) {
                    boolean last2;
                    String word = words[i2];
                    boolean bl = last2 = i2 == words.length - 1;
                    if (!last2) {
                        word = word + " ";
                    }
                    if (word.length() + this.width > 80) {
                        this.accum.append("\n").append(word);
                        this.width = word.length();
                        continue;
                    }
                    this.accum.append(word);
                    this.width += word.length();
                }
            } else {
                this.accum.append(text2);
                this.width += text2.length();
            }
        }

        public String toString() {
            return this.accum.toString();
        }
    }
}

