/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;

public final class DataUtil {
    private static final Pattern charsetPattern = Pattern.compile("(?i)\\bcharset=\\s*(?:\"|')?([^\\s,;\"']*)");
    static final String defaultCharset = "UTF-8";
    private static final int bufferSize = 131072;
    private static final int UNICODE_BOM = 65279;
    private static final char[] mimeBoundaryChars = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    static final int boundaryLength = 32;

    private DataUtil() {
    }

    public static Document load(File in, String charsetName, String baseUri) throws IOException {
        ByteBuffer byteData = DataUtil.readFileToByteBuffer(in);
        return DataUtil.parseByteData(byteData, charsetName, baseUri, Parser.htmlParser());
    }

    public static Document load(InputStream in, String charsetName, String baseUri) throws IOException {
        ByteBuffer byteData = DataUtil.readToByteBuffer(in);
        return DataUtil.parseByteData(byteData, charsetName, baseUri, Parser.htmlParser());
    }

    public static Document load(InputStream in, String charsetName, String baseUri, Parser parser) throws IOException {
        ByteBuffer byteData = DataUtil.readToByteBuffer(in);
        return DataUtil.parseByteData(byteData, charsetName, baseUri, parser);
    }

    static void crossStreams(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[131072];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
    }

    static Document parseByteData(ByteBuffer byteData, String charsetName, String baseUri, Parser parser) {
        String docData;
        Document doc = null;
        if (charsetName == null) {
            docData = Charset.forName(defaultCharset).decode(byteData).toString();
            doc = parser.parseInput(docData, baseUri);
            Element meta2 = doc.select("meta[http-equiv=content-type], meta[charset]").first();
            if (meta2 != null) {
                String foundCharset = null;
                if (meta2.hasAttr("http-equiv")) {
                    foundCharset = DataUtil.getCharsetFromContentType(meta2.attr("content"));
                }
                if (foundCharset == null && meta2.hasAttr("charset")) {
                    try {
                        if (Charset.isSupported(meta2.attr("charset"))) {
                            foundCharset = meta2.attr("charset");
                        }
                    }
                    catch (IllegalCharsetNameException e) {
                        foundCharset = null;
                    }
                }
                if (foundCharset != null && foundCharset.length() != 0 && !foundCharset.equals(defaultCharset)) {
                    charsetName = foundCharset = foundCharset.trim().replaceAll("[\"']", "");
                    byteData.rewind();
                    docData = Charset.forName(foundCharset).decode(byteData).toString();
                    doc = null;
                }
            }
        } else {
            Validate.notEmpty(charsetName, "Must set charset arg to character set of file to parse. Set to null to attempt to detect from HTML");
            docData = Charset.forName(charsetName).decode(byteData).toString();
        }
        if (docData.length() > 0 && docData.charAt(0) == '\ufeff') {
            byteData.rewind();
            docData = Charset.forName(defaultCharset).decode(byteData).toString();
            docData = docData.substring(1);
            charsetName = defaultCharset;
            doc = null;
        }
        if (doc == null) {
            doc = parser.parseInput(docData, baseUri);
            doc.outputSettings().charset(charsetName);
        }
        return doc;
    }

    static ByteBuffer readToByteBuffer(InputStream inStream, int maxSize) throws IOException {
        int read2;
        Validate.isTrue(maxSize >= 0, "maxSize must be 0 (unlimited) or larger");
        boolean capped = maxSize > 0;
        byte[] buffer = new byte[131072];
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(131072);
        int remaining = maxSize;
        while ((read2 = inStream.read(buffer)) != -1) {
            if (capped) {
                if (read2 > remaining) {
                    outStream.write(buffer, 0, remaining);
                    break;
                }
                remaining -= read2;
            }
            outStream.write(buffer, 0, read2);
        }
        return ByteBuffer.wrap(outStream.toByteArray());
    }

    static ByteBuffer readToByteBuffer(InputStream inStream) throws IOException {
        return DataUtil.readToByteBuffer(inStream, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ByteBuffer readFileToByteBuffer(File file2) throws IOException {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file2, "r");
            byte[] bytes = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(bytes);
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            return byteBuffer;
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    static ByteBuffer emptyByteBuffer() {
        return ByteBuffer.allocate(0);
    }

    static String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m = charsetPattern.matcher(contentType);
        if (m.find()) {
            String charset = m.group(1).trim();
            if ((charset = charset.replace("charset=", "")).length() == 0) {
                return null;
            }
            try {
                if (Charset.isSupported(charset)) {
                    return charset;
                }
                if (Charset.isSupported(charset = charset.toUpperCase(Locale.ENGLISH))) {
                    return charset;
                }
            }
            catch (IllegalCharsetNameException e) {
                return null;
            }
        }
        return null;
    }

    static String mimeBoundary() {
        StringBuilder mime = new StringBuilder(32);
        Random rand = new Random();
        for (int i2 = 0; i2 < 32; ++i2) {
            mime.append(mimeBoundaryChars[rand.nextInt(mimeBoundaryChars.length)]);
        }
        return mime.toString();
    }
}

