/*
 * Decompiled with CFR 0.152.
 */
package ru.yole.jkid.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty1;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.yole.jkid.DeserializeInterface;
import ru.yole.jkid.JsonName;
import ru.yole.jkid.ValueSerializer;
import ru.yole.jkid.ValueSerializersKt;
import ru.yole.jkid.deserialization.JKidException;
import ru.yole.jkid.serialization.SerializerKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\t\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0012\u001a\u00020\u00132\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J!\u0010\u0015\u001a\u00028\u00002\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002J\u001e\u0010\u001b\u001a\u00020\u00132\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0017H\u0002J\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0007J\u0018\u0010\u001e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\f2\u0006\u0010\u001d\u001a\u00020\u0007J\u001a\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\n\u001a2\u0012\u0004\u0012\u00020\u0007\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\f0\u000bj\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u000bj\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0010\u001a2\u0012\u0004\u0012\u00020\u000f\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\u00110\u000bj\u0018\u0012\u0004\u0012\u00020\u000f\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\u0011`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lru/yole/jkid/deserialization/ClassInfo;", "T", "", "cls", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "className", "", "constructor", "Lkotlin/reflect/KFunction;", "jsonNameToDeserializeClassMap", "Ljava/util/HashMap;", "Ljava/lang/Class;", "Lkotlin/collections/HashMap;", "jsonNameToParamMap", "Lkotlin/reflect/KParameter;", "paramToSerializerMap", "Lru/yole/jkid/ValueSerializer;", "cacheDataForParameter", "", "param", "createInstance", "arguments", "", "(Ljava/util/Map;)Ljava/lang/Object;", "deserializeConstructorArgument", "value", "ensureAllParametersPresent", "getConstructorParameter", "propertyName", "getDeserializeClass", "validateArgumentType", "build"})
public final class ClassInfo<T> {
    private final String className;
    private final KFunction<T> constructor;
    private final HashMap<String, KParameter> jsonNameToParamMap;
    private final HashMap<KParameter, ValueSerializer<? extends Object>> paramToSerializerMap;
    private final HashMap<String, Class<? extends Object>> jsonNameToDeserializeClassMap;

    /*
     * WARNING - void declaration
     */
    private final void cacheDataForParameter(KClass<?> cls, KParameter param2) {
        void $receiver$iv$iv$iv;
        void $receiver$iv$iv$iv2;
        Object $receiver$iv$iv;
        Object v1;
        Object object2;
        String paramName;
        block8: {
            Iterable iterable;
            String string = param2.getName();
            if (string == null) {
                throw (Throwable)new JKidException("Class " + this.className + " has constructor parameter without name");
            }
            paramName = string;
            Iterable iterable2 = iterable = (Iterable)KClasses.getDeclaredMemberProperties(cls);
            for (Object object2 : iterable2) {
                KProperty1 it = (KProperty1)object2;
                if (!Intrinsics.areEqual(it.getName(), paramName)) continue;
                v1 = object2;
                break block8;
            }
            v1 = null;
        }
        KProperty1 kProperty1 = v1;
        if (kProperty1 == null) {
            return;
        }
        KProperty1 property = kProperty1;
        Object $receiver$iv = property;
        object2 = $receiver$iv$iv = (Iterable)$receiver$iv.getAnnotations();
        Iterable destination$iv$iv$iv = new ArrayList();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv2) {
            if (!(element$iv$iv$iv instanceof JsonName)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        Object object3 = (JsonName)CollectionsKt.firstOrNull((List)destination$iv$iv$iv);
        if (object3 == null || (object3 = object3.name()) == null) {
            object3 = paramName;
        }
        Object name = object3;
        $receiver$iv = this.jsonNameToParamMap;
        $receiver$iv$iv = param2;
        $receiver$iv.put(name, $receiver$iv$iv);
        Object $receiver$iv2 = property;
        Iterable $receiver$iv$iv2 = $receiver$iv2.getAnnotations();
        destination$iv$iv$iv = $receiver$iv$iv2;
        Collection destination$iv$iv$iv2 = new ArrayList();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof DeserializeInterface)) continue;
            destination$iv$iv$iv2.add(element$iv$iv$iv);
        }
        DeserializeInterface deserializeInterface = (DeserializeInterface)CollectionsKt.firstOrNull((List)destination$iv$iv$iv2);
        Class<? extends Object> deserializeClass = deserializeInterface != null ? deserializeInterface.targetClass() : null;
        $receiver$iv2 = this.jsonNameToDeserializeClassMap;
        object2 = deserializeClass;
        $receiver$iv2.put(name, object2);
        ValueSerializer<Object> valueSerializer = SerializerKt.getSerializer(property);
        if (valueSerializer == null) {
            valueSerializer = ValueSerializersKt.serializerForType(ReflectJvmMapping.getJavaType(param2.getType()));
        }
        if (valueSerializer == null) {
            return;
        }
        ValueSerializer<Object> valueSerializer2 = valueSerializer;
        object2 = this.paramToSerializerMap;
        ValueSerializer<Object> valueSerializer3 = valueSerializer2;
        object2.put((KParameter)param2, valueSerializer3);
    }

    @NotNull
    public final KParameter getConstructorParameter(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        KParameter kParameter = this.jsonNameToParamMap.get(propertyName);
        if (kParameter == null) {
            throw (Throwable)new JKidException("Constructor parameter " + propertyName + " is not found for class " + this.className);
        }
        return kParameter;
    }

    @Nullable
    public final Class<? extends Object> getDeserializeClass(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        return this.jsonNameToDeserializeClassMap.get(propertyName);
    }

    @Nullable
    public final Object deserializeConstructorArgument(@NotNull KParameter param2, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull(param2, "param");
        ValueSerializer<? extends Object> serializer2 = this.paramToSerializerMap.get(param2);
        if (serializer2 != null) {
            return serializer2.fromJsonValue(value);
        }
        this.validateArgumentType(param2, value);
        return value;
    }

    private final void validateArgumentType(KParameter param2, Object value) {
        if (value == null && !param2.getType().isMarkedNullable()) {
            throw (Throwable)new JKidException("Received null value for non-null parameter " + param2.getName());
        }
        if (value != null && Intrinsics.areEqual(value.getClass(), ReflectJvmMapping.getJavaType(param2.getType())) ^ true) {
            throw (Throwable)new JKidException("Type mismatch for parameter " + param2.getName() + ": " + "expected " + ReflectJvmMapping.getJavaType(param2.getType()) + ", found " + value.getClass());
        }
    }

    @NotNull
    public final T createInstance(@NotNull Map<KParameter, ? extends Object> arguments2) {
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        this.ensureAllParametersPresent(arguments2);
        return (T)this.constructor.callBy(arguments2);
    }

    private final void ensureAllParametersPresent(Map<KParameter, ? extends Object> arguments2) {
        for (KParameter param2 : this.constructor.getParameters()) {
            if (arguments2.get(param2) != null || param2.isOptional() || param2.getType().isMarkedNullable()) continue;
            throw (Throwable)new JKidException("Missing value for parameter " + param2.getName());
        }
    }

    public ClassInfo(@NotNull KClass<T> cls) {
        Intrinsics.checkParameterIsNotNull(cls, "cls");
        this.className = cls.getQualifiedName();
        KFunction<T> kFunction = KClasses.getPrimaryConstructor(cls);
        if (kFunction == null) {
            throw (Throwable)new JKidException("Class " + cls.getQualifiedName() + " doesn't have a primary constructor");
        }
        this.constructor = kFunction;
        this.jsonNameToParamMap = new HashMap();
        this.paramToSerializerMap = new HashMap();
        this.jsonNameToDeserializeClassMap = new HashMap();
        Iterable $receiver$iv = this.constructor.getParameters();
        for (Object element$iv : $receiver$iv) {
            KParameter it = (KParameter)element$iv;
            this.cacheDataForParameter(cls, it);
        }
    }
}

