/*
 * Decompiled with CFR 0.152.
 */
package ru.yole.jkid.deserialization;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.yole.jkid.deserialization.CharReader;
import ru.yole.jkid.deserialization.Lexer;
import ru.yole.jkid.deserialization.MalformedJSONException;
import ru.yole.jkid.deserialization.Token;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\b\u0010\u0010\u001a\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0007\u001a6\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\n0\bj\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\n`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lru/yole/jkid/deserialization/Lexer;", "", "reader", "Ljava/io/Reader;", "(Ljava/io/Reader;)V", "charReader", "Lru/yole/jkid/deserialization/CharReader;", "tokenMap", "Ljava/util/HashMap;", "", "Lkotlin/Function1;", "Lru/yole/jkid/deserialization/Token;", "Lkotlin/collections/HashMap;", "nextToken", "readNumberToken", "firstChar", "readStringToken", "Companion", "build"})
public final class Lexer {
    private final CharReader charReader;
    private final HashMap<Character, Function1<Character, Token>> tokenMap;
    private static final Set<Character> valueEndChars;
    public static final Companion Companion;

    @Nullable
    public final Token nextToken() {
        Character c;
        while ((c = this.charReader.readNext()) != null && CharsKt.isWhitespace(c.charValue())) {
        }
        if (c == null) {
            return null;
        }
        Function1<Character, Token> function1 = this.tokenMap.get(c);
        if (function1 == null || (function1 = function1.invoke(c)) == null) {
            throw (Throwable)new MalformedJSONException("Unexpected token " + c);
        }
        return function1;
    }

    private final Token readStringToken() {
        StringBuilder result2 = new StringBuilder();
        while (true) {
            Character c = this.charReader.readNext();
            if (c == null) {
                throw (Throwable)new MalformedJSONException("Unterminated string");
            }
            char c2 = c.charValue();
            if (c2 == '\"') break;
            if (c2 == '\\') {
                Character c3 = this.charReader.readNext();
                if (c3 == null) {
                    throw (Throwable)new MalformedJSONException("Unterminated escape sequence");
                }
                char escaped = c3.charValue();
                switch (escaped) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        result2.append(escaped);
                        break;
                    }
                    case 'b': {
                        result2.append('\b');
                        break;
                    }
                    case 'f': {
                        result2.append('\f');
                        break;
                    }
                    case 'n': {
                        result2.append('\n');
                        break;
                    }
                    case 'r': {
                        result2.append('\r');
                        break;
                    }
                    case 't': {
                        result2.append('\t');
                        break;
                    }
                    case 'u': {
                        String hexChars = this.charReader.readNextChars(4);
                        result2.append((char)Integer.parseInt(hexChars, 16));
                        break;
                    }
                    default: {
                        throw (Throwable)new MalformedJSONException("Unsupported escape sequence \\" + escaped);
                    }
                }
                continue;
            }
            result2.append(c2);
        }
        String string = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "result.toString()");
        return new Token.StringValue(string);
    }

    private final Token readNumberToken(char firstChar) {
        Token token;
        String value;
        Character c;
        StringBuilder buffer = new StringBuilder(String.valueOf(firstChar));
        while ((c = this.charReader.peekNext()) != null && !Lexer.Companion.getValueEndChars().contains(c)) {
            Character c2 = this.charReader.readNext();
            if (c2 == null) {
                Intrinsics.throwNpe();
            }
            buffer.append(c2.charValue());
        }
        String string = value = buffer.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "value");
        if (StringsKt.contains$default((CharSequence)string, ".", false, 2, null)) {
            String string2 = value;
            token = new Token.DoubleValue(Double.parseDouble(string2));
        } else {
            String string3 = value;
            token = new Token.LongValue(Long.parseLong(string3));
        }
        return token;
    }

    /*
     * WARNING - void declaration
     */
    public Lexer(@NotNull Reader reader) {
        HashMap hashMap;
        Intrinsics.checkParameterIsNotNull(reader, "reader");
        this.charReader = new CharReader(reader);
        HashMap hashMap2 = hashMap = MapsKt.hashMapOf(TuplesKt.to(Character.valueOf(','), tokenMap.1.INSTANCE), TuplesKt.to(Character.valueOf('{'), tokenMap.2.INSTANCE), TuplesKt.to(Character.valueOf('}'), tokenMap.3.INSTANCE), TuplesKt.to(Character.valueOf('['), tokenMap.4.INSTANCE), TuplesKt.to(Character.valueOf(']'), tokenMap.5.INSTANCE), TuplesKt.to(Character.valueOf(':'), tokenMap.6.INSTANCE), TuplesKt.to(Character.valueOf('t'), new Function1<Character, Token.BoolValue>(this){
            final /* synthetic */ Lexer this$0;

            @NotNull
            public final Token.BoolValue invoke(char c) {
                Lexer.access$getCharReader$p(this.this$0).expectText("rue", ru.yole.jkid.deserialization.Lexer$Companion.access$getValueEndChars$p(Lexer.Companion));
                return Token.Companion.getTRUE();
            }
            {
                this.this$0 = lexer;
                super(1);
            }
        }), TuplesKt.to(Character.valueOf('f'), new Function1<Character, Token.BoolValue>(this){
            final /* synthetic */ Lexer this$0;

            @NotNull
            public final Token.BoolValue invoke(char c) {
                Lexer.access$getCharReader$p(this.this$0).expectText("alse", ru.yole.jkid.deserialization.Lexer$Companion.access$getValueEndChars$p(Lexer.Companion));
                return Token.Companion.getFALSE();
            }
            {
                this.this$0 = lexer;
                super(1);
            }
        }), TuplesKt.to(Character.valueOf('n'), new Function1<Character, Token.NullValue>(this){
            final /* synthetic */ Lexer this$0;

            @NotNull
            public final Token.NullValue invoke(char c) {
                Lexer.access$getCharReader$p(this.this$0).expectText("ull", ru.yole.jkid.deserialization.Lexer$Companion.access$getValueEndChars$p(Lexer.Companion));
                return Token.NullValue.INSTANCE;
            }
            {
                this.this$0 = lexer;
                super(1);
            }
        }), TuplesKt.to(Character.valueOf('\"'), new Function1<Character, Token>(this){
            final /* synthetic */ Lexer this$0;

            @NotNull
            public final Token invoke(char c) {
                return Lexer.access$readStringToken(this.this$0);
            }
            {
                this.this$0 = lexer;
                super(1);
            }
        }), TuplesKt.to(Character.valueOf('-'), new Function1<Character, Token>(this){
            final /* synthetic */ Lexer this$0;

            @NotNull
            public final Token invoke(char c) {
                return Lexer.access$readNumberToken(this.this$0, c);
            }
            {
                this.this$0 = lexer;
                super(1);
            }
        }));
        Lexer lexer = this;
        int n = 48;
        int n2 = 57;
        while (true) {
            char i2;
            void $receiver;
            Map map2 = (Map)$receiver;
            Character c = Character.valueOf(i2);
            Function1<Character, Token> function1 = new Function1<Character, Token>(this){
                final /* synthetic */ Lexer this$0;
                {
                    this.this$0 = lexer;
                    super(1);
                }

                @NotNull
                public final Token invoke(char c) {
                    return Lexer.access$readNumberToken(this.this$0, c);
                }
            };
            map2.put(c, function1);
            if (i2 == n2) break;
            i2 = (char)(i2 + true);
        }
        Unit unit = Unit.INSTANCE;
        lexer.tokenMap = hashMap;
    }

    static {
        Companion = new Companion(null);
        valueEndChars = SetsKt.setOf(new Character[]{Character.valueOf(','), Character.valueOf('}'), Character.valueOf(']'), Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\r'), Character.valueOf('\n')});
    }

    @NotNull
    public static final /* synthetic */ CharReader access$getCharReader$p(Lexer $this) {
        return $this.charReader;
    }

    @NotNull
    public static final /* synthetic */ Token access$readStringToken(Lexer $this) {
        return $this.readStringToken();
    }

    @NotNull
    public static final /* synthetic */ Token access$readNumberToken(Lexer $this, char firstChar) {
        return $this.readNumberToken(firstChar);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/yole/jkid/deserialization/Lexer$Companion;", "", "()V", "valueEndChars", "", "", "getValueEndChars", "()Ljava/util/Set;", "build"})
    public static final class Companion {
        private final Set<Character> getValueEndChars() {
            return valueEndChars;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

