/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1alpha1 "github.com/rook/rook/pkg/apis/edgefs.rook.io/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeISCSIs implements ISCSIInterface
type FakeISCSIs struct {
	Fake *FakeEdgefsV1alpha1
	ns   string
}

var iscsisResource = schema.GroupVersionResource{Group: "edgefs.rook.io", Version: "v1alpha1", Resource: "iscsis"}

var iscsisKind = schema.GroupVersionKind{Group: "edgefs.rook.io", Version: "v1alpha1", Kind: "ISCSI"}

// Get takes name of the iSCSI, and returns the corresponding iSCSI object, and an error if there is any.
func (c *FakeISCSIs) Get(name string, options v1.GetOptions) (result *v1alpha1.ISCSI, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(iscsisResource, c.ns, name), &v1alpha1.ISCSI{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ISCSI), err
}

// List takes label and field selectors, and returns the list of ISCSIs that match those selectors.
func (c *FakeISCSIs) List(opts v1.ListOptions) (result *v1alpha1.ISCSIList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(iscsisResource, iscsisKind, c.ns, opts), &v1alpha1.ISCSIList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.ISCSIList{ListMeta: obj.(*v1alpha1.ISCSIList).ListMeta}
	for _, item := range obj.(*v1alpha1.ISCSIList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested iSCSIs.
func (c *FakeISCSIs) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(iscsisResource, c.ns, opts))

}

// Create takes the representation of a iSCSI and creates it.  Returns the server's representation of the iSCSI, and an error, if there is any.
func (c *FakeISCSIs) Create(iSCSI *v1alpha1.ISCSI) (result *v1alpha1.ISCSI, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(iscsisResource, c.ns, iSCSI), &v1alpha1.ISCSI{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ISCSI), err
}

// Update takes the representation of a iSCSI and updates it. Returns the server's representation of the iSCSI, and an error, if there is any.
func (c *FakeISCSIs) Update(iSCSI *v1alpha1.ISCSI) (result *v1alpha1.ISCSI, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(iscsisResource, c.ns, iSCSI), &v1alpha1.ISCSI{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ISCSI), err
}

// Delete takes name of the iSCSI and deletes it. Returns an error if one occurs.
func (c *FakeISCSIs) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(iscsisResource, c.ns, name), &v1alpha1.ISCSI{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeISCSIs) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(iscsisResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.ISCSIList{})
	return err
}

// Patch applies the patch and returns the patched iSCSI.
func (c *FakeISCSIs) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.ISCSI, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(iscsisResource, c.ns, name, data, subresources...), &v1alpha1.ISCSI{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ISCSI), err
}
