//Code is generated by ucloud code generator, don't modify it by hand, it will cause undefined behaviors.
//go:generate ucloud-gen-go-api UNet DescribeFirewall

package unet

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// DescribeFirewallRequest is request schema for DescribeFirewall action
type DescribeFirewallRequest struct {
	request.CommonBase

	// [公共参数] 地域
	// Region *string `required:"true"`

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写
	// ProjectId *string `required:"false"`

	// 防火墙ID，默认为返回所有防火墙
	FWId *string `required:"false"`

	// 绑定防火墙组的资源类型，默认为全部资源类型。枚举值为："unatgw"，NAT网关； "uhost"，云主机； "upm"，物理云主机； "hadoophost"，hadoop节点； "fortresshost"，堡垒机； "udhost"，私有专区主机；"udockhost"，容器；"dbaudit"，数据库审计.
	ResourceType *string `required:"false"`

	// 绑定防火墙组的资源ID
	ResourceId *string `required:"false"`

	// 返回数据长度，默认为20，最大10000000
	Limit *int `required:"false"`

	// 列表起始位置偏移量，默认为0
	Offset *int `required:"false"`
}

// DescribeFirewallResponse is response schema for DescribeFirewall action
type DescribeFirewallResponse struct {
	response.CommonBase

	// 获取的防火墙组详细信息 参见 FirewallDataSet
	DataSet []FirewallDataSet

	// 数量
	TotalCount int
}

// NewDescribeFirewallRequest will create request of DescribeFirewall action.
func (c *UNetClient) NewDescribeFirewallRequest() *DescribeFirewallRequest {
	req := &DescribeFirewallRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

// DescribeFirewall - 获取防火墙组信息
func (c *UNetClient) DescribeFirewall(req *DescribeFirewallRequest) (*DescribeFirewallResponse, error) {
	var err error
	var res DescribeFirewallResponse

	err = c.Client.InvokeAction("DescribeFirewall", req, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
