// Code is generated by ucloud-model, DO NOT EDIT IT.

package vpc

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// DescribeWhiteListResourceRequest is request schema for DescribeWhiteListResource action
type DescribeWhiteListResourceRequest struct {
	request.CommonBase

	// [公共参数] 项目id
	// ProjectId *string `required:"true"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// NAT网关的Id
	NATGWIds []string `required:"true"`
}

// DescribeWhiteListResourceResponse is response schema for DescribeWhiteListResource action
type DescribeWhiteListResourceResponse struct {
	response.CommonBase

	// 白名单资源的详细信息，详见DescribeResourceWhiteListDataSet
	DataSet []NatGWWhitelistDataSet

	// 上述DataSet总数量
	TotalCount int
}

// NewDescribeWhiteListResourceRequest will create request of DescribeWhiteListResource action.
func (c *VPCClient) NewDescribeWhiteListResourceRequest() *DescribeWhiteListResourceRequest {
	req := &DescribeWhiteListResourceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

// DescribeWhiteListResource - 展示NAT网关白名单资源列表
func (c *VPCClient) DescribeWhiteListResource(req *DescribeWhiteListResourceRequest) (*DescribeWhiteListResourceResponse, error) {
	var err error
	var res DescribeWhiteListResourceResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeWhiteListResource", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
