using System.Collections.Generic;
using System.Data;
using System.Data.SqlTypes;
using System.Globalization;
using System.Linq;
using System.Net;
using System.Numerics;
using System.Text;

namespace System.Runtime.Serialization.Formatters.Tests
{
    public partial class BinaryFormatterTests
    {
        /// <summary>
        /// First: Object
        /// Second: String Array with Base64 Object Hashes serialized in 1. netcoreapp and 2. netfx
        /// If a new hash needs to be generated delete the string element in the array and you will get 
        /// the new one in the exception message when running the ValidateTfmHashes test.
        /// </summary>
        public static IEnumerable<object[]> SerializableObjects()
        {
            // Primitive types
            yield return new object[] { byte.MinValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAAtTeXN0ZW0uQnl0ZQEAAAAHbV92YWx1ZQACAAs=", "AAEAAAD/////AQAAAAAAAAAEAQAAAAtTeXN0ZW0uQnl0ZQEAAAAHbV92YWx1ZQACAAs=" } };
            yield return new object[] { byte.MaxValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAAtTeXN0ZW0uQnl0ZQEAAAAHbV92YWx1ZQAC/ws=", "AAEAAAD/////AQAAAAAAAAAEAQAAAAtTeXN0ZW0uQnl0ZQEAAAAHbV92YWx1ZQAC/ws=" } };
            yield return new object[] { sbyte.MinValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAAxTeXN0ZW0uU0J5dGUBAAAAB21fdmFsdWUACoAL", "AAEAAAD/////AQAAAAAAAAAEAQAAAAxTeXN0ZW0uU0J5dGUBAAAAB21fdmFsdWUACoAL" } };
            yield return new object[] { sbyte.MaxValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAAxTeXN0ZW0uU0J5dGUBAAAAB21fdmFsdWUACn8L", "AAEAAAD/////AQAAAAAAAAAEAQAAAAxTeXN0ZW0uU0J5dGUBAAAAB21fdmFsdWUACn8L" } };
            yield return new object[] { short.MinValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAAxTeXN0ZW0uSW50MTYBAAAAB21fdmFsdWUABwCACw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAAxTeXN0ZW0uSW50MTYBAAAAB21fdmFsdWUABwCACw==" } };
            yield return new object[] { short.MaxValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAAxTeXN0ZW0uSW50MTYBAAAAB21fdmFsdWUAB/9/Cw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAAxTeXN0ZW0uSW50MTYBAAAAB21fdmFsdWUAB/9/Cw==" } };
            yield return new object[] { ushort.MinValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uVUludDE2AQAAAAdtX3ZhbHVlAA4AAAs=", "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uVUludDE2AQAAAAdtX3ZhbHVlAA4AAAs=" } };
            yield return new object[] { ushort.MaxValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uVUludDE2AQAAAAdtX3ZhbHVlAA7//ws=", "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uVUludDE2AQAAAAdtX3ZhbHVlAA7//ws=" } };
            yield return new object[] { int.MinValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAAxTeXN0ZW0uSW50MzIBAAAAB21fdmFsdWUACAAAAIAL", "AAEAAAD/////AQAAAAAAAAAEAQAAAAxTeXN0ZW0uSW50MzIBAAAAB21fdmFsdWUACAAAAIAL" } };
            yield return new object[] { int.MaxValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAAxTeXN0ZW0uSW50MzIBAAAAB21fdmFsdWUACP///38L", "AAEAAAD/////AQAAAAAAAAAEAQAAAAxTeXN0ZW0uSW50MzIBAAAAB21fdmFsdWUACP///38L" } };
            yield return new object[] { uint.MinValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uVUludDMyAQAAAAdtX3ZhbHVlAA8AAAAACw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uVUludDMyAQAAAAdtX3ZhbHVlAA8AAAAACw==" } };
            yield return new object[] { uint.MaxValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uVUludDMyAQAAAAdtX3ZhbHVlAA//////Cw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uVUludDMyAQAAAAdtX3ZhbHVlAA//////Cw==" } };
            yield return new object[] { long.MinValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAAxTeXN0ZW0uSW50NjQBAAAAB21fdmFsdWUACQAAAAAAAACACw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAAxTeXN0ZW0uSW50NjQBAAAAB21fdmFsdWUACQAAAAAAAACACw==" } };
            yield return new object[] { long.MaxValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAAxTeXN0ZW0uSW50NjQBAAAAB21fdmFsdWUACf////////9/Cw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAAxTeXN0ZW0uSW50NjQBAAAAB21fdmFsdWUACf////////9/Cw==" } };
            yield return new object[] { ulong.MinValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uVUludDY0AQAAAAdtX3ZhbHVlABAAAAAAAAAAAAs=", "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uVUludDY0AQAAAAdtX3ZhbHVlABAAAAAAAAAAAAs=" } };
            yield return new object[] { ulong.MaxValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uVUludDY0AQAAAAdtX3ZhbHVlABD//////////ws=", "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uVUludDY0AQAAAAdtX3ZhbHVlABD//////////ws=" } };
            yield return new object[] { char.MinValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAAtTeXN0ZW0uQ2hhcgEAAAAHbV92YWx1ZQADAAs=", "AAEAAAD/////AQAAAAAAAAAEAQAAAAtTeXN0ZW0uQ2hhcgEAAAAHbV92YWx1ZQADAAs=" } };
            yield return new object[] { char.MaxValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAAtTeXN0ZW0uQ2hhcgEAAAAHbV92YWx1ZQAD77+/Cw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAAtTeXN0ZW0uQ2hhcgEAAAAHbV92YWx1ZQAD77+/Cw==" } };
            yield return new object[] { float.MinValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uU2luZ2xlAQAAAAdtX3ZhbHVlAAv//3//Cw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uU2luZ2xlAQAAAAdtX3ZhbHVlAAv//3//Cw==" } };
            yield return new object[] { float.MaxValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uU2luZ2xlAQAAAAdtX3ZhbHVlAAv//39/Cw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uU2luZ2xlAQAAAAdtX3ZhbHVlAAv//39/Cw==" } };
            yield return new object[] { double.MinValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uRG91YmxlAQAAAAdtX3ZhbHVlAAb////////v/ws=", "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uRG91YmxlAQAAAAdtX3ZhbHVlAAb////////v/ws=" } };
            yield return new object[] { double.MaxValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uRG91YmxlAQAAAAdtX3ZhbHVlAAb////////vfws=", "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uRG91YmxlAQAAAAdtX3ZhbHVlAAb////////vfws=" } };
            yield return new object[] { decimal.MinValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAA5TeXN0ZW0uRGVjaW1hbAQAAAAFZmxhZ3MCaGkCbG8DbWlkAAAAAAgICAgAAACA////////////////Cw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAA5TeXN0ZW0uRGVjaW1hbAQAAAAFZmxhZ3MCaGkCbG8DbWlkAAAAAAgICAgAAACA////////////////Cw==" } };
            yield return new object[] { decimal.MaxValue, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAA5TeXN0ZW0uRGVjaW1hbAQAAAAFZmxhZ3MCaGkCbG8DbWlkAAAAAAgICAgAAAAA////////////////Cw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAA5TeXN0ZW0uRGVjaW1hbAQAAAAFZmxhZ3MCaGkCbG8DbWlkAAAAAAgICAgAAAAA////////////////Cw==" } };
            yield return new object[] { decimal.MinusOne, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAA5TeXN0ZW0uRGVjaW1hbAQAAAAFZmxhZ3MCaGkCbG8DbWlkAAAAAAgICAgAAACAAAAAAAEAAAAAAAAACw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAA5TeXN0ZW0uRGVjaW1hbAQAAAAFZmxhZ3MCaGkCbG8DbWlkAAAAAAgICAgAAACAAAAAAAEAAAAAAAAACw==" } };
            yield return new object[] { true, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAA5TeXN0ZW0uQm9vbGVhbgEAAAAHbV92YWx1ZQABAQs=", "AAEAAAD/////AQAAAAAAAAAEAQAAAA5TeXN0ZW0uQm9vbGVhbgEAAAAHbV92YWx1ZQABAQs=" } };
            yield return new object[] { false, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAA5TeXN0ZW0uQm9vbGVhbgEAAAAHbV92YWx1ZQABAAs=", "AAEAAAD/////AQAAAAAAAAAEAQAAAA5TeXN0ZW0uQm9vbGVhbgEAAAAHbV92YWx1ZQABAAs=" } };
            yield return new object[] { "", new string[] { "AAEAAAD/////AQAAAAAAAAAGAQAAAAAL", "AAEAAAD/////AQAAAAAAAAAGAQAAAAAL" } };
            yield return new object[] { "c", new string[] { "AAEAAAD/////AQAAAAAAAAAGAQAAAAFjCw==", "AAEAAAD/////AQAAAAAAAAAGAQAAAAFjCw==" } };
            yield return new object[] { "\u4F60\u597D", new string[] { "AAEAAAD/////AQAAAAAAAAAGAQAAAAbkvaDlpb0L", "AAEAAAD/////AQAAAAAAAAAGAQAAAAbkvaDlpb0L" } };
            yield return new object[] { "some\0data\0with\0null\0chars", new string[] { "AAEAAAD/////AQAAAAAAAAAGAQAAABlzb21lAGRhdGEAd2l0aABudWxsAGNoYXJzCw==", "AAEAAAD/////AQAAAAAAAAAGAQAAABlzb21lAGRhdGEAd2l0aABudWxsAGNoYXJzCw==" } };
            yield return new object[] { "<>&\"\'", new string[] { "AAEAAAD/////AQAAAAAAAAAGAQAAAAU8PiYiJws=", "AAEAAAD/////AQAAAAAAAAAGAQAAAAU8PiYiJws=" } };
            yield return new object[] { " < ", new string[] { "AAEAAAD/////AQAAAAAAAAAGAQAAAAMgPCAL", "AAEAAAD/////AQAAAAAAAAAGAQAAAAMgPCAL" } };
            yield return new object[] { "minchar" + char.MinValue + "minchar", new string[] { "AAEAAAD/////AQAAAAAAAAAGAQAAAA9taW5jaGFyAG1pbmNoYXIL", "AAEAAAD/////AQAAAAAAAAAGAQAAAA9taW5jaGFyAG1pbmNoYXIL" } };

            // Enum values
            yield return new object[] { DayOfWeek.Monday, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAABBTeXN0ZW0uRGF5T2ZXZWVrAQAAAAd2YWx1ZV9fAAgBAAAACw==", "AAEAAAD/////AQAAAAAAAAAEAQAAABBTeXN0ZW0uRGF5T2ZXZWVrAQAAAAd2YWx1ZV9fAAgBAAAACw==" } };
            yield return new object[] { DateTimeKind.Local, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAABNTeXN0ZW0uRGF0ZVRpbWVLaW5kAQAAAAd2YWx1ZV9fAAgCAAAACw==", "AAEAAAD/////AQAAAAAAAAAEAQAAABNTeXN0ZW0uRGF0ZVRpbWVLaW5kAQAAAAd2YWx1ZV9fAAgCAAAACw==" } };

            // Nullables
            yield return new object[] { (int?)1, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAAxTeXN0ZW0uSW50MzIBAAAAB21fdmFsdWUACAEAAAAL", "AAEAAAD/////AQAAAAAAAAAEAQAAAAxTeXN0ZW0uSW50MzIBAAAAB21fdmFsdWUACAEAAAAL" } };
            yield return new object[] { (StructWithIntField?)new StructWithIntField() { X = 42 }, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABAU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdFdpdGhJbnRGaWVsZAEAAAABWAAIAgAAACoAAAAL", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABAU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdFdpdGhJbnRGaWVsZAEAAAABWAAIAgAAACoAAAAL" } };

            // Nullable equality comparer roundtrips as opposed to other equality comparers which serialize to ObjectEqualityComparer
            yield return new object[] { EqualityComparer<int>.Default, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAJ8BU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuR2VuZXJpY0VxdWFsaXR5Q29tcGFyZXJgMVtbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dAAAAAAs=", "AAEAAAD/////AQAAAAAAAAAEAQAAAJEBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuR2VuZXJpY0VxdWFsaXR5Q29tcGFyZXJgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQAAAAAL" } };
            yield return new object[] { EqualityComparer<long>.Default, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAJ8BU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuR2VuZXJpY0VxdWFsaXR5Q29tcGFyZXJgMVtbU3lzdGVtLkludDY0LCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dAAAAAAs=", "AAEAAAD/////AQAAAAAAAAAEAQAAAJEBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuR2VuZXJpY0VxdWFsaXR5Q29tcGFyZXJgMVtbU3lzdGVtLkludDY0LCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQAAAAAL" } };
            yield return new object[] { EqualityComparer<string>.Default, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAKABU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuR2VuZXJpY0VxdWFsaXR5Q29tcGFyZXJgMVtbU3lzdGVtLlN0cmluZywgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQAAAAAL", "AAEAAAD/////AQAAAAAAAAAEAQAAAJIBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuR2VuZXJpY0VxdWFsaXR5Q29tcGFyZXJgMVtbU3lzdGVtLlN0cmluZywgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0AAAAACw==" } };
            yield return new object[] { EqualityComparer<object>.Default, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAJ8BU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuT2JqZWN0RXF1YWxpdHlDb21wYXJlcmAxW1tTeXN0ZW0uT2JqZWN0LCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dAAAAAAs=", "AAEAAAD/////AQAAAAAAAAAEAQAAAJEBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuT2JqZWN0RXF1YWxpdHlDb21wYXJlcmAxW1tTeXN0ZW0uT2JqZWN0LCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQAAAAAL" } };
            yield return new object[] { EqualityComparer<int?>.Default, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAKABU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuTnVsbGFibGVFcXVhbGl0eUNvbXBhcmVyYDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQAAAAAL", "AAEAAAD/////AQAAAAAAAAAEAQAAAJIBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuTnVsbGFibGVFcXVhbGl0eUNvbXBhcmVyYDFbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0AAAAACw==" } };
            yield return new object[] { EqualityComparer<double?>.Default, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAKEBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuTnVsbGFibGVFcXVhbGl0eUNvbXBhcmVyYDFbW1N5c3RlbS5Eb3VibGUsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0AAAAACw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAJMBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuTnVsbGFibGVFcXVhbGl0eUNvbXBhcmVyYDFbW1N5c3RlbS5Eb3VibGUsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dAAAAAAs=" } };

            // Equality comparers which can roundtrip
            yield return new object[] { EqualityComparer<byte>.Default, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAC9TeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5CeXRlRXF1YWxpdHlDb21wYXJlcgAAAAAL", "AAEAAAD/////AQAAAAAAAAAEAQAAAC9TeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5CeXRlRXF1YWxpdHlDb21wYXJlcgAAAAAL" } };
            yield return new object[] { EqualityComparer<Int32Enum>.Default, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAN4BU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuRW51bUVxdWFsaXR5Q29tcGFyZXJgMVtbU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLkludDMyRW51bSwgU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYl1dAAAAAAs=", "AAEAAAD/////AQAAAAAAAAAEAQAAAN4BU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuRW51bUVxdWFsaXR5Q29tcGFyZXJgMVtbU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLkludDMyRW51bSwgU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYl1dAAAAAAs=" } };

            // Other core serializable types
            yield return new object[] { IntPtr.Zero, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uSW50UHRyAQAAAAV2YWx1ZQAJAAAAAAAAAAAL", "AAEAAAD/////AQAAAAAAAAAEAQAAAA1TeXN0ZW0uSW50UHRyAQAAAAV2YWx1ZQAJAAAAAAAAAAAL" } };
            yield return new object[] { UIntPtr.Zero, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAA5TeXN0ZW0uVUludFB0cgEAAAAFdmFsdWUAEAAAAAAAAAAACw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAA5TeXN0ZW0uVUludFB0cgEAAAAFdmFsdWUAEAAAAAAAAAAACw==" } };
            yield return new object[] { new DateTime(1990, 11, 23), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAA9TeXN0ZW0uRGF0ZVRpbWUCAAAABXRpY2tzCV9kYXRlRGF0YQAACRAAwPc9bey2CADA9z1t7LYICw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAA9TeXN0ZW0uRGF0ZVRpbWUCAAAABXRpY2tzCGRhdGVEYXRhAAAJEADA9z1t7LYIAMD3PW3stggL" } };
            yield return new object[] { new DateTimeOffset(1990, 11, 23, 03, 30, 00, 00, TimeSpan.FromMinutes(30)), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAABVTeXN0ZW0uRGF0ZVRpbWVPZmZzZXQCAAAACERhdGVUaW1lDU9mZnNldE1pbnV0ZXMAAA0HAPhEY4bstggeAAs=", "AAEAAAD/////AQAAAAAAAAAEAQAAABVTeXN0ZW0uRGF0ZVRpbWVPZmZzZXQCAAAACERhdGVUaW1lDU9mZnNldE1pbnV0ZXMAAA0HAPhEY4bstggeAAs=" } };
            yield return new object[] { TimeZoneInfo.Utc, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAABNTeXN0ZW0uVGltZVpvbmVJbmZvBwAAAAJJZAtEaXNwbGF5TmFtZQxTdGFuZGFyZE5hbWUMRGF5bGlnaHROYW1lDUJhc2VVdGNPZmZzZXQPQWRqdXN0bWVudFJ1bGVzGlN1cHBvcnRzRGF5bGlnaHRTYXZpbmdUaW1lAQEBAQACAAwBBgIAAAADVVRDCQIAAAAJAgAAAAkCAAAAAAAAAAAAAAAKAAs=", "AAEAAAD/////AQAAAAAAAAAMAgAAAE5TeXN0ZW0uQ29yZSwgVmVyc2lvbj0zLjUuMC4wLCBDdWx0dXJlPU5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODkFAQAAABNTeXN0ZW0uVGltZVpvbmVJbmZvBwAAAAJJZAtEaXNwbGF5TmFtZQxTdGFuZGFyZE5hbWUMRGF5bGlnaHROYW1lDUJhc2VVdGNPZmZzZXQPQWRqdXN0bWVudFJ1bGVzGlN1cHBvcnRzRGF5bGlnaHRTYXZpbmdUaW1lAQEBAQACAAwBAgAAAAYDAAAAA1VUQwkDAAAACQMAAAAJAwAAAAAAAAAAAAAACgAL" } };
            yield return new object[] { TimeZoneInfo.TransitionTime.CreateFixedDateRule(new DateTime(1, 1, 1, 2, 0, 0), 3, 15), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAACJTeXN0ZW0uVGltZVpvbmVJbmZvK1RyYW5zaXRpb25UaW1lBgAAAAlUaW1lT2ZEYXkFTW9udGgEV2VlawNEYXkJRGF5T2ZXZWVrD0lzRml4ZWREYXRlUnVsZQAAAAADAA0CAgIQU3lzdGVtLkRheU9mV2VlawEA0IjDEAAAAAMBDwT+////EFN5c3RlbS5EYXlPZldlZWsBAAAAB3ZhbHVlX18ACAAAAAABCw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAE5TeXN0ZW0uQ29yZSwgVmVyc2lvbj0zLjUuMC4wLCBDdWx0dXJlPU5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODkFAQAAACJTeXN0ZW0uVGltZVpvbmVJbmZvK1RyYW5zaXRpb25UaW1lBgAAAAlUaW1lT2ZEYXkFTW9udGgEV2VlawNEYXkJRGF5T2ZXZWVrD0lzRml4ZWREYXRlUnVsZQAAAAADAA0CAgIQU3lzdGVtLkRheU9mV2VlawECAAAAANCIwxAAAAADAQ8E/f///xBTeXN0ZW0uRGF5T2ZXZWVrAQAAAAd2YWx1ZV9fAAgAAAAAAQs=" } };
            yield return new object[] { TimeZoneInfo.AdjustmentRule.CreateAdjustmentRule(new DateTime(1900, 1, 1),
                new DateTime(1955, 12, 31),
                TimeSpan.FromHours(2),
                TimeZoneInfo.TransitionTime.CreateFixedDateRule(new DateTime(1, 1, 1, 2, 0, 0), 2, 3),
                TimeZoneInfo.TransitionTime.CreateFixedDateRule(new DateTime(1, 1, 1, 2, 0, 0), 3, 4)), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAACJTeXN0ZW0uVGltZVpvbmVJbmZvK0FkanVzdG1lbnRSdWxlBwAAAAlEYXRlU3RhcnQHRGF0ZUVuZA1EYXlsaWdodERlbHRhF0RheWxpZ2h0VHJhbnNpdGlvblN0YXJ0FURheWxpZ2h0VHJhbnNpdGlvbkVuZBJCYXNlVXRjT2Zmc2V0RGVsdGEVTm9EYXlsaWdodFRyYW5zaXRpb25zAAAAAwMAAA0NDCJTeXN0ZW0uVGltZVpvbmVJbmZvK1RyYW5zaXRpb25UaW1lIlN5c3RlbS5UaW1lWm9uZUluZm8rVHJhbnNpdGlvblRpbWUMAQBAVyBTBVEIAEDGiJPMjwgA0IjDEAAAAAT+////IlN5c3RlbS5UaW1lWm9uZUluZm8rVHJhbnNpdGlvblRpbWUGAAAACVRpbWVPZkRheQVNb250aARXZWVrA0RheQlEYXlPZldlZWsPSXNGaXhlZERhdGVSdWxlAAAAAAMADQICAhBTeXN0ZW0uRGF5T2ZXZWVrAQDQiMMQAAAAAgEDBP3///8QU3lzdGVtLkRheU9mV2VlawEAAAAHdmFsdWVfXwAIAAAAAAEB/P////7///8A0IjDEAAAAAMBBAH7/////f///wAAAAABAAAAAAAAAAAACw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAE5TeXN0ZW0uQ29yZSwgVmVyc2lvbj0zLjUuMC4wLCBDdWx0dXJlPU5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODkFAQAAACJTeXN0ZW0uVGltZVpvbmVJbmZvK0FkanVzdG1lbnRSdWxlBgAAAAlEYXRlU3RhcnQHRGF0ZUVuZA1EYXlsaWdodERlbHRhF0RheWxpZ2h0VHJhbnNpdGlvblN0YXJ0FURheWxpZ2h0VHJhbnNpdGlvbkVuZBJCYXNlVXRjT2Zmc2V0RGVsdGEAAAAEBAANDQwiU3lzdGVtLlRpbWVab25lSW5mbytUcmFuc2l0aW9uVGltZQIAAAAiU3lzdGVtLlRpbWVab25lSW5mbytUcmFuc2l0aW9uVGltZQIAAAAMAgAAAABAVyBTBVEIAEDGiJPMjwgA0IjDEAAAAAX9////IlN5c3RlbS5UaW1lWm9uZUluZm8rVHJhbnNpdGlvblRpbWUGAAAACVRpbWVPZkRheQVNb250aARXZWVrA0RheQlEYXlPZldlZWsPSXNGaXhlZERhdGVSdWxlAAAAAAMADQICAhBTeXN0ZW0uRGF5T2ZXZWVrAQIAAAAA0IjDEAAAAAIBAwT8////EFN5c3RlbS5EYXlPZldlZWsBAAAAB3ZhbHVlX18ACAAAAAABAfv////9////ANCIwxAAAAADAQQB+v////z///8AAAAAAQAAAAAAAAAACw==" } };
            yield return new object[] { TimeSpan.FromDays(7), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAA9TeXN0ZW0uVGltZVNwYW4BAAAABl90aWNrcwAJAEDkKIAFAAAL", "AAEAAAD/////AQAAAAAAAAAEAQAAAA9TeXN0ZW0uVGltZVNwYW4BAAAABl90aWNrcwAJAEDkKIAFAAAL" } };
            yield return new object[] { new Version(1, 2, 3, 4), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAA5TeXN0ZW0uVmVyc2lvbgQAAAAGX01ham9yBl9NaW5vcgZfQnVpbGQJX1JldmlzaW9uAAAAAAgICAgBAAAAAgAAAAMAAAAEAAAACw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAA5TeXN0ZW0uVmVyc2lvbgQAAAAGX01ham9yBl9NaW5vcgZfQnVpbGQJX1JldmlzaW9uAAAAAAgICAgBAAAAAgAAAAMAAAAEAAAACw==" } };
            yield return new object[] { new Guid("0CACAA4D-C6BD-420A-B660-2F557337CA89"), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAAtTeXN0ZW0uR3VpZAsAAAACX2ECX2ICX2MCX2QCX2UCX2YCX2cCX2gCX2kCX2oCX2sAAAAAAAAAAAAAAAgHBwICAgICAgICTaqsDL3GCkK2YC9VczfKiQs=", "AAEAAAD/////AQAAAAAAAAAEAQAAAAtTeXN0ZW0uR3VpZAsAAAACX2ECX2ICX2MCX2QCX2UCX2YCX2cCX2gCX2kCX2oCX2sAAAAAAAAAAAAAAAgHBwICAgICAgICTaqsDL3GCkK2YC9VczfKiQs=" } };
            yield return new object[] { new List<int>(), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAIwBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuTGlzdGAxW1tTeXN0ZW0uSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0DAAAABl9pdGVtcwVfc2l6ZQhfdmVyc2lvbgcAAAgICAkCAAAAAAAAAAAAAAAPAgAAAAAAAAAICw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAH5TeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5MaXN0YDFbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0DAAAABl9pdGVtcwVfc2l6ZQhfdmVyc2lvbgcAAAgICAkCAAAAAAAAAAAAAAAPAgAAAAAAAAAICw==" } };
            yield return new object[] { new List<int>() { 1, 2, 3, 4, 5 }, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAIwBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuTGlzdGAxW1tTeXN0ZW0uSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0DAAAABl9pdGVtcwVfc2l6ZQhfdmVyc2lvbgcAAAgICAkCAAAABQAAAAUAAAAPAgAAAAgAAAAIAQAAAAIAAAADAAAABAAAAAUAAAAAAAAAAAAAAAAAAAAL", "AAEAAAD/////AQAAAAAAAAAEAQAAAH5TeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5MaXN0YDFbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0DAAAABl9pdGVtcwVfc2l6ZQhfdmVyc2lvbgcAAAgICAkCAAAABQAAAAUAAAAPAgAAAAgAAAAIAQAAAAIAAAADAAAABAAAAAUAAAAAAAAAAAAAAAAAAAAL" } };
            var dictionary = new Dictionary<int, string>() { { 1, "test" }, { 2, "another test" } };
            yield return new object[] { dictionary, new string[] { "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", "AAEAAAD/////AQAAAAAAAAAEAQAAAOEBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuRGljdGlvbmFyeWAyW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV0sW1N5c3RlbS5TdHJpbmcsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dBAAAAAdWZXJzaW9uCENvbXBhcmVyCEhhc2hTaXplDUtleVZhbHVlUGFpcnMAAwADCJEBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuR2VuZXJpY0VxdWFsaXR5Q29tcGFyZXJgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQjlAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLktleVZhbHVlUGFpcmAyW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV0sW1N5c3RlbS5TdHJpbmcsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dW10CAAAACQIAAAADAAAACQMAAAAEAgAAAJEBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuR2VuZXJpY0VxdWFsaXR5Q29tcGFyZXJgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQAAAAAHAwAAAAABAAAAAgAAAAPjAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLktleVZhbHVlUGFpcmAyW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV0sW1N5c3RlbS5TdHJpbmcsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dBPz////jAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLktleVZhbHVlUGFpcmAyW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV0sW1N5c3RlbS5TdHJpbmcsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dAgAAAANrZXkFdmFsdWUAAQgBAAAABgUAAAAEdGVzdAH6/////P///wIAAAAGBwAAAAxhbm90aGVyIHRlc3QL" } };
            var pointDictionary = new Dictionary<int, Point>()
            {
                { 1, new Point(1, 1) },
                { 2, new Point(2, 2) }
            };
            yield return new object[] { Tuple.Create(1), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAHlTeXN0ZW0uVHVwbGVgMVtbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dAQAAAAdtX0l0ZW0xAAgBAAAACw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAGtTeXN0ZW0uVHVwbGVgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQEAAAAHbV9JdGVtMQAIAQAAAAs=" } };
            yield return new object[] { Tuple.Create(1, "2"), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAOQBU3lzdGVtLlR1cGxlYDJbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdLFtTeXN0ZW0uU3RyaW5nLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dAgAAAAdtX0l0ZW0xB21fSXRlbTIAAQgBAAAABgIAAAABMgs=", "AAEAAAD/////AQAAAAAAAAAEAQAAAMgBU3lzdGVtLlR1cGxlYDJbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XSxbU3lzdGVtLlN0cmluZywgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0CAAAAB21fSXRlbTEHbV9JdGVtMgABCAEAAAAGAgAAAAEyCw==" } };
            yield return new object[] { Tuple.Create(1, "2", 3u), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAM8CU3lzdGVtLlR1cGxlYDNbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdLFtTeXN0ZW0uU3RyaW5nLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV0sW1N5c3RlbS5VSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0DAAAAB21fSXRlbTEHbV9JdGVtMgdtX0l0ZW0zAAEACA8BAAAABgIAAAABMgMAAAAL", "AAEAAAD/////AQAAAAAAAAAEAQAAAKUCU3lzdGVtLlR1cGxlYDNbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XSxbU3lzdGVtLlN0cmluZywgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XSxbU3lzdGVtLlVJbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0DAAAAB21fSXRlbTEHbV9JdGVtMgdtX0l0ZW0zAAEACA8BAAAABgIAAAABMgMAAAAL" } };
            yield return new object[] { Tuple.Create(1, "2", 3u, 4L), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAALkDU3lzdGVtLlR1cGxlYDRbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdLFtTeXN0ZW0uU3RyaW5nLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV0sW1N5c3RlbS5VSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXSxbU3lzdGVtLkludDY0LCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dBAAAAAdtX0l0ZW0xB21fSXRlbTIHbV9JdGVtMwdtX0l0ZW00AAEAAAgPCQEAAAAGAgAAAAEyAwAAAAQAAAAAAAAACw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAIEDU3lzdGVtLlR1cGxlYDRbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XSxbU3lzdGVtLlN0cmluZywgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XSxbU3lzdGVtLlVJbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XSxbU3lzdGVtLkludDY0LCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQQAAAAHbV9JdGVtMQdtX0l0ZW0yB21fSXRlbTMHbV9JdGVtNAABAAAIDwkBAAAABgIAAAABMgMAAAAEAAAAAAAAAAs=" } };
            yield return new object[] { Tuple.Create(1, "2", 3u, 4L, 5.6), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAKQEU3lzdGVtLlR1cGxlYDVbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdLFtTeXN0ZW0uU3RyaW5nLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV0sW1N5c3RlbS5VSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXSxbU3lzdGVtLkludDY0LCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV0sW1N5c3RlbS5Eb3VibGUsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0FAAAAB21fSXRlbTEHbV9JdGVtMgdtX0l0ZW0zB21fSXRlbTQHbV9JdGVtNQABAAAACA8JBgEAAAAGAgAAAAEyAwAAAAQAAAAAAAAAZmZmZmZmFkAL", "AAEAAAD/////AQAAAAAAAAAEAQAAAN4DU3lzdGVtLlR1cGxlYDVbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XSxbU3lzdGVtLlN0cmluZywgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XSxbU3lzdGVtLlVJbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XSxbU3lzdGVtLkludDY0LCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldLFtTeXN0ZW0uRG91YmxlLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQUAAAAHbV9JdGVtMQdtX0l0ZW0yB21fSXRlbTMHbV9JdGVtNAdtX0l0ZW01AAEAAAAIDwkGAQAAAAYCAAAAATIDAAAABAAAAAAAAABmZmZmZmYWQAs=" } };
            yield return new object[] { Tuple.Create(1, "2", 3u, 4L, 5.6, 7.8f), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAI8FU3lzdGVtLlR1cGxlYDZbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdLFtTeXN0ZW0uU3RyaW5nLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV0sW1N5c3RlbS5VSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXSxbU3lzdGVtLkludDY0LCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV0sW1N5c3RlbS5Eb3VibGUsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXSxbU3lzdGVtLlNpbmdsZSwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQYAAAAHbV9JdGVtMQdtX0l0ZW0yB21fSXRlbTMHbV9JdGVtNAdtX0l0ZW01B21fSXRlbTYAAQAAAAAIDwkGCwEAAAAGAgAAAAEyAwAAAAQAAAAAAAAAZmZmZmZmFkCamflACw==", "AAEAAAD/////AQAAAAAAAAAEAQAAALsEU3lzdGVtLlR1cGxlYDZbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XSxbU3lzdGVtLlN0cmluZywgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XSxbU3lzdGVtLlVJbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XSxbU3lzdGVtLkludDY0LCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldLFtTeXN0ZW0uRG91YmxlLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldLFtTeXN0ZW0uU2luZ2xlLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQYAAAAHbV9JdGVtMQdtX0l0ZW0yB21fSXRlbTMHbV9JdGVtNAdtX0l0ZW01B21fSXRlbTYAAQAAAAAIDwkGCwEAAAAGAgAAAAEyAwAAAAQAAAAAAAAAZmZmZmZmFkCamflACw==" } };
            yield return new object[] { Tuple.Create(1, "2", 3u, 4L, 5.6, 7.8f, 9m), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAPsFU3lzdGVtLlR1cGxlYDdbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdLFtTeXN0ZW0uU3RyaW5nLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV0sW1N5c3RlbS5VSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXSxbU3lzdGVtLkludDY0LCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV0sW1N5c3RlbS5Eb3VibGUsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXSxbU3lzdGVtLlNpbmdsZSwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdLFtTeXN0ZW0uRGVjaW1hbCwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQcAAAAHbV9JdGVtMQdtX0l0ZW0yB21fSXRlbTMHbV9JdGVtNAdtX0l0ZW01B21fSXRlbTYHbV9JdGVtNwABAAAAAAAIDwkGCwUBAAAABgIAAAABMgMAAAAEAAAAAAAAAGZmZmZmZhZAmpn5QAE5Cw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAJkFU3lzdGVtLlR1cGxlYDdbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XSxbU3lzdGVtLlN0cmluZywgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XSxbU3lzdGVtLlVJbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XSxbU3lzdGVtLkludDY0LCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldLFtTeXN0ZW0uRG91YmxlLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldLFtTeXN0ZW0uU2luZ2xlLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldLFtTeXN0ZW0uRGVjaW1hbCwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0HAAAAB21fSXRlbTEHbV9JdGVtMgdtX0l0ZW0zB21fSXRlbTQHbV9JdGVtNQdtX0l0ZW02B21fSXRlbTcAAQAAAAAACA8JBgsFAQAAAAYCAAAAATIDAAAABAAAAAAAAABmZmZmZmYWQJqZ+UABOQs=" } };
            yield return new object[] { Tuple.Create(1, "2", 3u, 4L, 5.6, 7.8f, 9m, Tuple.Create(10)), new string[] { "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", "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" } };
            yield return new object[] { new KeyValuePair<int, byte>(42, 84), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAP0BU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuS2V5VmFsdWVQYWlyYDJbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdLFtTeXN0ZW0uQnl0ZSwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQIAAAADa2V5BXZhbHVlAAAIAioAAABUCw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAOEBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuS2V5VmFsdWVQYWlyYDJbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XSxbU3lzdGVtLkJ5dGUsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dAgAAAANrZXkFdmFsdWUAAAgCKgAAAFQL" } };
            var dotnetUri = new Uri("https://dot.net");
            yield return new object[] { dotnetUri, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uUHJpdmF0ZS5VcmksIFZlcnNpb249NC4wLjUuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAAKU3lzdGVtLlVyaQEAAAALQWJzb2x1dGVVcmkBAgAAAAYDAAAAEGh0dHBzOi8vZG90Lm5ldC8L", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAAAKU3lzdGVtLlVyaQEAAAALQWJzb2x1dGVVcmkBAgAAAAYDAAAAEGh0dHBzOi8vZG90Lm5ldC8L" } };
            yield return new object[] { new Uri(dotnetUri, "articles/info.html"), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uUHJpdmF0ZS5VcmksIFZlcnNpb249NC4wLjUuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAAKU3lzdGVtLlVyaQEAAAALQWJzb2x1dGVVcmkBAgAAAAYDAAAAImh0dHBzOi8vZG90Lm5ldC9hcnRpY2xlcy9pbmZvLmh0bWwL", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAAAKU3lzdGVtLlVyaQEAAAALQWJzb2x1dGVVcmkBAgAAAAYDAAAAImh0dHBzOi8vZG90Lm5ldC9hcnRpY2xlcy9pbmZvLmh0bWwL" } };
            yield return new object[] { new WeakReference(dotnetUri, false), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uUHJpdmF0ZS5VcmksIFZlcnNpb249NC4wLjUuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBAEAAAAUU3lzdGVtLldlYWtSZWZlcmVuY2UCAAAADVRyYWNrZWRPYmplY3QRVHJhY2tSZXN1cnJlY3Rpb24EAApTeXN0ZW0uVXJpAgAAAAEJAwAAAAAFAwAAAApTeXN0ZW0uVXJpAQAAAAtBYnNvbHV0ZVVyaQECAAAABgQAAAAQaHR0cHM6Ly9kb3QubmV0Lws=", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BAEAAAAUU3lzdGVtLldlYWtSZWZlcmVuY2UCAAAADVRyYWNrZWRPYmplY3QRVHJhY2tSZXN1cnJlY3Rpb24EAApTeXN0ZW0uVXJpAgAAAAEJAwAAAAAFAwAAAApTeXN0ZW0uVXJpAQAAAAtBYnNvbHV0ZVVyaQECAAAABgQAAAAQaHR0cHM6Ly9kb3QubmV0Lws=" } };
            var trackingPoint = new Point(2, 3);
            yield return new object[] { new WeakReference<Point>(trackingPoint, false), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBAEAAAC/AVN5c3RlbS5XZWFrUmVmZXJlbmNlYDFbW1N5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5Qb2ludCwgU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYl1dAgAAAA1UcmFja2VkT2JqZWN0EVRyYWNrUmVzdXJyZWN0aW9uBAAzU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50AgAAAAEJAwAAAAAFAwAAADNTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnQCAAAAAVgBWQAACAgCAAAAAgAAAAMAAAAL", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBAEAAAC/AVN5c3RlbS5XZWFrUmVmZXJlbmNlYDFbW1N5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5Qb2ludCwgU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYl1dAgAAAA1UcmFja2VkT2JqZWN0EVRyYWNrUmVzdXJyZWN0aW9uBAAzU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50AgAAAAEJAwAAAAAFAwAAADNTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnQCAAAAAVgBWQAACAgCAAAAAgAAAAMAAAAL" } };
            yield return new object[] { new StringBuilder(), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAABlTeXN0ZW0uVGV4dC5TdHJpbmdCdWlsZGVyBAAAAA1tX01heENhcGFjaXR5CENhcGFjaXR5DW1fU3RyaW5nVmFsdWUPbV9jdXJyZW50VGhyZWFkAAABAAgICP///38QAAAABgIAAAAAAAAAAAs=", "AAEAAAD/////AQAAAAAAAAAEAQAAABlTeXN0ZW0uVGV4dC5TdHJpbmdCdWlsZGVyBAAAAA1tX01heENhcGFjaXR5CENhcGFjaXR5DW1fU3RyaW5nVmFsdWUPbV9jdXJyZW50VGhyZWFkAAABAAgICP///38QAAAABgIAAAAAAAAAAAs=" } };
            yield return new object[] { new StringBuilder("starting", 0, 5, 10), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAABlTeXN0ZW0uVGV4dC5TdHJpbmdCdWlsZGVyBAAAAA1tX01heENhcGFjaXR5CENhcGFjaXR5DW1fU3RyaW5nVmFsdWUPbV9jdXJyZW50VGhyZWFkAAABAAgICP///38KAAAABgIAAAAFc3RhcnQAAAAACw==", "AAEAAAD/////AQAAAAAAAAAEAQAAABlTeXN0ZW0uVGV4dC5TdHJpbmdCdWlsZGVyBAAAAA1tX01heENhcGFjaXR5CENhcGFjaXR5DW1fU3RyaW5nVmFsdWUPbV9jdXJyZW50VGhyZWFkAAABAAgICP///38KAAAABgIAAAAFc3RhcnQAAAAACw==" } };
            var cookie = new Cookie("host", "edge", "auth", "dot.net");
            yield return new object[] { cookie, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFhTeXN0ZW0uTmV0LlByaW1pdGl2ZXMsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhDAMAAABVU3lzdGVtLlByaXZhdGUuVXJpLCBWZXJzaW9uPTQuMC41LjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49YjAzZjVmN2YxMWQ1MGEzYQUBAAAAEVN5c3RlbS5OZXQuQ29va2llFQAAAAltX2NvbW1lbnQMbV9jb21tZW50VXJpD21fY29va2llVmFyaWFudAltX2Rpc2NhcmQIbV9kb21haW4QbV9kb21haW5JbXBsaWNpdAltX2V4cGlyZXMGbV9uYW1lBm1fcGF0aA5tX3BhdGhJbXBsaWNpdAZtX3BvcnQObV9wb3J0SW1wbGljaXQKbV9wb3J0TGlzdAhtX3NlY3VyZQptX2h0dHBPbmx5C21fdGltZVN0YW1wB21fdmFsdWUJbV92ZXJzaW9uC21fZG9tYWluS2V5D0lzUXVvdGVkVmVyc2lvbg5Jc1F1b3RlZERvbWFpbgEEBAABAAABAQABAAcAAAABAAEAAApTeXN0ZW0uVXJpAwAAABhTeXN0ZW0uTmV0LkNvb2tpZVZhcmlhbnQCAAAAAQENAQEIAQENCAEBAgAAAAYEAAAAAAoF+////xhTeXN0ZW0uTmV0LkNvb2tpZVZhcmlhbnQBAAAAB3ZhbHVlX18ACAIAAAABAAAAAAYGAAAAB2RvdC5uZXQAAAAAAAAAAAAGBwAAAARob3N0BggAAAAEYXV0aAAJBAAAAAEKAABfHM/eP6jUCAYKAAAABGVkZ2UAAAAACQQAAAAAAAs=", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAAARU3lzdGVtLk5ldC5Db29raWUVAAAACW1fY29tbWVudAxtX2NvbW1lbnRVcmkPbV9jb29raWVWYXJpYW50CW1fZGlzY2FyZAhtX2RvbWFpbhFtX2RvbWFpbl9pbXBsaWNpdAltX2V4cGlyZXMGbV9uYW1lBm1fcGF0aA9tX3BhdGhfaW1wbGljaXQGbV9wb3J0D21fcG9ydF9pbXBsaWNpdAttX3BvcnRfbGlzdAhtX3NlY3VyZQptX2h0dHBPbmx5C21fdGltZVN0YW1wB21fdmFsdWUJbV92ZXJzaW9uC21fZG9tYWluS2V5D0lzUXVvdGVkVmVyc2lvbg5Jc1F1b3RlZERvbWFpbgEEBAABAAABAQABAAcAAAABAAEAAApTeXN0ZW0uVXJpAgAAABhTeXN0ZW0uTmV0LkNvb2tpZVZhcmlhbnQCAAAAAQENAQEIAQENCAEBAgAAAAYDAAAAAAoF/P///xhTeXN0ZW0uTmV0LkNvb2tpZVZhcmlhbnQBAAAAB3ZhbHVlX18ACAIAAAABAAAAAAYFAAAAB2RvdC5uZXQAAAAAAAAAAAAGBgAAAARob3N0BgcAAAAEYXV0aAAJAwAAAAEKAAAsrl5tgKfUiAYJAAAABGVkZ2UAAAAACQMAAAAAAAs=" } };
            var cookieCollection = new CookieCollection();
            cookieCollection.Add(cookie);
            yield return new object[] { cookieCollection, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFhTeXN0ZW0uTmV0LlByaW1pdGl2ZXMsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAAbU3lzdGVtLk5ldC5Db29raWVDb2xsZWN0aW9uAwAAAAZtX2xpc3QLbV90aW1lU3RhbXAUbV9oYXNfb3RoZXJfdmVyc2lvbnMDAACQAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLkxpc3RgMVtbU3lzdGVtLk5ldC5Db29raWUsIFN5c3RlbS5OZXQuUHJpbWl0aXZlcywgVmVyc2lvbj00LjEuMS4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2FdXQ0BAgAAAAkDAAAAAAAAAAAAAAAABAMAAACQAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLkxpc3RgMVtbU3lzdGVtLk5ldC5Db29raWUsIFN5c3RlbS5OZXQuUHJpbWl0aXZlcywgVmVyc2lvbj00LjEuMS4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2FdXQMAAAAGX2l0ZW1zBV9zaXplCF92ZXJzaW9uBAAAE1N5c3RlbS5OZXQuQ29va2llW10CAAAACAgJBAAAAAEAAAABAAAABwQAAAAAAQAAAAQAAAAEEVN5c3RlbS5OZXQuQ29va2llAgAAAAkFAAAADQMMBgAAAFVTeXN0ZW0uUHJpdmF0ZS5VcmksIFZlcnNpb249NC4wLjUuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQUAAAARU3lzdGVtLk5ldC5Db29raWUVAAAACW1fY29tbWVudAxtX2NvbW1lbnRVcmkPbV9jb29raWVWYXJpYW50CW1fZGlzY2FyZAhtX2RvbWFpbhBtX2RvbWFpbkltcGxpY2l0CW1fZXhwaXJlcwZtX25hbWUGbV9wYXRoDm1fcGF0aEltcGxpY2l0Bm1fcG9ydA5tX3BvcnRJbXBsaWNpdAptX3BvcnRMaXN0CG1fc2VjdXJlCm1faHR0cE9ubHkLbV90aW1lU3RhbXAHbV92YWx1ZQltX3ZlcnNpb24LbV9kb21haW5LZXkPSXNRdW90ZWRWZXJzaW9uDklzUXVvdGVkRG9tYWluAQQEAAEAAAEBAAEABwAAAAEAAQAAClN5c3RlbS5VcmkGAAAAGFN5c3RlbS5OZXQuQ29va2llVmFyaWFudAIAAAABAQ0BAQgBAQ0IAQECAAAABgcAAAAACgX4////GFN5c3RlbS5OZXQuQ29va2llVmFyaWFudAEAAAAHdmFsdWVfXwAIAgAAAAEAAAAABgkAAAAHZG90Lm5ldAAAAAAAAAAAAAYKAAAABGhvc3QGCwAAAARhdXRoAAkHAAAAAQoAAF8cz94/qNQIBg0AAAAEZWRnZQAAAAAJBwAAAAAACw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAAAbU3lzdGVtLk5ldC5Db29raWVDb2xsZWN0aW9uBQAAAAltX3ZlcnNpb24GbV9saXN0C21fVGltZVN0YW1wFG1faGFzX290aGVyX3ZlcnNpb25zDG1fSXNSZWFkT25seQADAAAACBxTeXN0ZW0uQ29sbGVjdGlvbnMuQXJyYXlMaXN0DQEBAgAAAAEAAAAJAwAAAAAAAAAAAAAAAAEEAwAAABxTeXN0ZW0uQ29sbGVjdGlvbnMuQXJyYXlMaXN0AwAAAAZfaXRlbXMFX3NpemUIX3ZlcnNpb24FAAAICAkEAAAAAQAAAAEAAAAQBAAAAAQAAAAJBQAAAA0DBQUAAAARU3lzdGVtLk5ldC5Db29raWUVAAAACW1fY29tbWVudAxtX2NvbW1lbnRVcmkPbV9jb29raWVWYXJpYW50CW1fZGlzY2FyZAhtX2RvbWFpbhFtX2RvbWFpbl9pbXBsaWNpdAltX2V4cGlyZXMGbV9uYW1lBm1fcGF0aA9tX3BhdGhfaW1wbGljaXQGbV9wb3J0D21fcG9ydF9pbXBsaWNpdAttX3BvcnRfbGlzdAhtX3NlY3VyZQptX2h0dHBPbmx5C21fdGltZVN0YW1wB21fdmFsdWUJbV92ZXJzaW9uC21fZG9tYWluS2V5D0lzUXVvdGVkVmVyc2lvbg5Jc1F1b3RlZERvbWFpbgEEBAABAAABAQABAAcAAAABAAEAAApTeXN0ZW0uVXJpAgAAABhTeXN0ZW0uTmV0LkNvb2tpZVZhcmlhbnQCAAAAAQENAQEIAQENCAEBAgAAAAYGAAAAAAoF+f///xhTeXN0ZW0uTmV0LkNvb2tpZVZhcmlhbnQBAAAAB3ZhbHVlX18ACAIAAAABAAAAAAYIAAAAB2RvdC5uZXQAAAAAAAAAAAAGCQAAAARob3N0BgoAAAAEYXV0aAAJBgAAAAEKAAAsrl5tgKfUiAYMAAAABGVkZ2UAAAAACQYAAAAAAAs=" } };
            var cookieContainer = new CookieContainer(10, 5, 1024);
            cookieCollection.Add(cookie);
            yield return new object[] { cookieContainer, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFhTeXN0ZW0uTmV0LlByaW1pdGl2ZXMsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAAaU3lzdGVtLk5ldC5Db29raWVDb250YWluZXIGAAAADW1fZG9tYWluVGFibGUPbV9tYXhDb29raWVTaXplDG1fbWF4Q29va2llcxVtX21heENvb2tpZXNQZXJEb21haW4HbV9jb3VudA5tX2ZxZG5NeURvbWFpbgMAAAAAAYMCU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuRGljdGlvbmFyeWAyW1tTeXN0ZW0uU3RyaW5nLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV0sW1N5c3RlbS5OZXQuUGF0aExpc3QsIFN5c3RlbS5OZXQuUHJpbWl0aXZlcywgVmVyc2lvbj00LjEuMS4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2FdXQgICAgCAAAACQMAAAAABAAACgAAAAUAAAAAAAAABgQAAAAbLnJlZG1vbmQuY29ycC5taWNyb3NvZnQuY29tBAMAAACDAlN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLkRpY3Rpb25hcnlgMltbU3lzdGVtLlN0cmluZywgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdLFtTeXN0ZW0uTmV0LlBhdGhMaXN0LCBTeXN0ZW0uTmV0LlByaW1pdGl2ZXMsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhXV0DAAAAB1ZlcnNpb24IQ29tcGFyZXIISGFzaFNpemUAAwAIPlN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLk5vblJhbmRvbWl6ZWRTdHJpbmdFcXVhbGl0eUNvbXBhcmVyCAAAAAAJBQAAAAAAAAAEBQAAAD5TeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5Ob25SYW5kb21pemVkU3RyaW5nRXF1YWxpdHlDb21wYXJlcgAAAAAL", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAAAaU3lzdGVtLk5ldC5Db29raWVDb250YWluZXIGAAAADW1fZG9tYWluVGFibGUPbV9tYXhDb29raWVTaXplDG1fbWF4Q29va2llcxVtX21heENvb2tpZXNQZXJEb21haW4HbV9jb3VudA5tX2ZxZG5NeURvbWFpbgMAAAAAARxTeXN0ZW0uQ29sbGVjdGlvbnMuSGFzaHRhYmxlCAgICAIAAAAJAwAAAAAEAAAKAAAABQAAAAAAAAAGBAAAABsucmVkbW9uZC5jb3JwLm1pY3Jvc29mdC5jb20EAwAAABxTeXN0ZW0uQ29sbGVjdGlvbnMuSGFzaHRhYmxlBwAAAApMb2FkRmFjdG9yB1ZlcnNpb24IQ29tcGFyZXIQSGFzaENvZGVQcm92aWRlcghIYXNoU2l6ZQRLZXlzBlZhbHVlcwAAAwMABQULCBxTeXN0ZW0uQ29sbGVjdGlvbnMuSUNvbXBhcmVyJFN5c3RlbS5Db2xsZWN0aW9ucy5JSGFzaENvZGVQcm92aWRlcgjsUTg/AAAAAAoKAwAAAAkFAAAACQYAAAAQBQAAAAAAAAAQBgAAAAAAAAAL" } };
            yield return new object[] { new DataSet("Dataset") { Locale = CultureInfo.InvariantCulture }, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uRGF0YS5Db21tb24sIFZlcnNpb249NC4yLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAATU3lzdGVtLkRhdGEuRGF0YVNldAMAAAAXRGF0YVNldC5SZW1vdGluZ1ZlcnNpb24JWG1sU2NoZW1hC1htbERpZmZHcmFtAwEBDlN5c3RlbS5WZXJzaW9uAgAAAAkDAAAABgQAAAD3Ajw/eG1sIHZlcnNpb249IjEuMCIgZW5jb2Rpbmc9InV0Zi0xNiI/Pg0KPHhzOnNjaGVtYSBpZD0iRGF0YXNldCIgeG1sbnM9IiIgeG1sbnM6eHM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDEvWE1MU2NoZW1hIiB4bWxuczptc2RhdGE9InVybjpzY2hlbWFzLW1pY3Jvc29mdC1jb206eG1sLW1zZGF0YSI+DQogIDx4czplbGVtZW50IG5hbWU9IkRhdGFzZXQiIG1zZGF0YTpJc0RhdGFTZXQ9InRydWUiIG1zZGF0YTpMb2NhbGU9IiI+DQogICAgPHhzOmNvbXBsZXhUeXBlPg0KICAgICAgPHhzOmNob2ljZSBtaW5PY2N1cnM9IjAiIG1heE9jY3Vycz0idW5ib3VuZGVkIiAvPg0KICAgIDwveHM6Y29tcGxleFR5cGU+DQogIDwveHM6ZWxlbWVudD4NCjwveHM6c2NoZW1hPgYFAAAAgAE8ZGlmZmdyOmRpZmZncmFtIHhtbG5zOm1zZGF0YT0idXJuOnNjaGVtYXMtbWljcm9zb2Z0LWNvbTp4bWwtbXNkYXRhIiB4bWxuczpkaWZmZ3I9InVybjpzY2hlbWFzLW1pY3Jvc29mdC1jb206eG1sLWRpZmZncmFtLXYxIiAvPgQDAAAADlN5c3RlbS5WZXJzaW9uBAAAAAZfTWFqb3IGX01pbm9yBl9CdWlsZAlfUmV2aXNpb24AAAAACAgICAIAAAAAAAAA//////////8L", "AAEAAAD/////AQAAAAAAAAAMAgAAAE5TeXN0ZW0uRGF0YSwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODkFAQAAABNTeXN0ZW0uRGF0YS5EYXRhU2V0AwAAABdEYXRhU2V0LlJlbW90aW5nVmVyc2lvbglYbWxTY2hlbWELWG1sRGlmZkdyYW0DAQEOU3lzdGVtLlZlcnNpb24CAAAACQMAAAAGBAAAAIUDPD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTE2Ij8+DQo8eHM6c2NoZW1hIGlkPSJEYXRhc2V0IiB4bWxucz0iIiB4bWxuczp4cz0iaHR0cDovL3d3dy53My5vcmcvMjAwMS9YTUxTY2hlbWEiIHhtbG5zOm1zZGF0YT0idXJuOnNjaGVtYXMtbWljcm9zb2Z0LWNvbTp4bWwtbXNkYXRhIj4NCiAgPHhzOmVsZW1lbnQgbmFtZT0iRGF0YXNldCIgbXNkYXRhOklzRGF0YVNldD0idHJ1ZSIgbXNkYXRhOlVzZUN1cnJlbnRMb2NhbGU9InRydWUiPg0KICAgIDx4czpjb21wbGV4VHlwZT4NCiAgICAgIDx4czpjaG9pY2UgbWluT2NjdXJzPSIwIiBtYXhPY2N1cnM9InVuYm91bmRlZCIgLz4NCiAgICA8L3hzOmNvbXBsZXhUeXBlPg0KICA8L3hzOmVsZW1lbnQ+DQo8L3hzOnNjaGVtYT4GBQAAAIABPGRpZmZncjpkaWZmZ3JhbSB4bWxuczptc2RhdGE9InVybjpzY2hlbWFzLW1pY3Jvc29mdC1jb206eG1sLW1zZGF0YSIgeG1sbnM6ZGlmZmdyPSJ1cm46c2NoZW1hcy1taWNyb3NvZnQtY29tOnhtbC1kaWZmZ3JhbS12MSIgLz4EAwAAAA5TeXN0ZW0uVmVyc2lvbgQAAAAGX01ham9yBl9NaW5vcgZfQnVpbGQJX1JldmlzaW9uAAAAAAgICAgCAAAAAAAAAP//////////Cw==" } };
            yield return new object[] { new DataTable("Datatable", "corens") { Locale = CultureInfo.InvariantCulture }, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uRGF0YS5Db21tb24sIFZlcnNpb249NC4yLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAAVU3lzdGVtLkRhdGEuRGF0YVRhYmxlAwAAABlEYXRhVGFibGUuUmVtb3RpbmdWZXJzaW9uCVhtbFNjaGVtYQtYbWxEaWZmR3JhbQMBAQ5TeXN0ZW0uVmVyc2lvbgIAAAAJAwAAAAYEAAAA/wQ8P3htbCB2ZXJzaW9uPSIxLjAiIGVuY29kaW5nPSJ1dGYtMTYiPz4NCjx4czpzY2hlbWEgdGFyZ2V0TmFtZXNwYWNlPSJjb3JlbnMiIHhtbG5zOm1zdG5zPSJjb3JlbnMiIHhtbG5zPSJjb3JlbnMiIHhtbG5zOnhzPSJodHRwOi8vd3d3LnczLm9yZy8yMDAxL1hNTFNjaGVtYSIgeG1sbnM6bXNkYXRhPSJ1cm46c2NoZW1hcy1taWNyb3NvZnQtY29tOnhtbC1tc2RhdGEiIGF0dHJpYnV0ZUZvcm1EZWZhdWx0PSJxdWFsaWZpZWQiIGVsZW1lbnRGb3JtRGVmYXVsdD0icXVhbGlmaWVkIj4NCiAgPHhzOmVsZW1lbnQgbmFtZT0iRGF0YXRhYmxlIiBtc2RhdGE6TG9jYWxlPSIiPg0KICAgIDx4czpjb21wbGV4VHlwZT4NCiAgICA8L3hzOmNvbXBsZXhUeXBlPg0KICA8L3hzOmVsZW1lbnQ+DQogIDx4czplbGVtZW50IG5hbWU9InRtcERhdGFTZXQiIG1zZGF0YTpJc0RhdGFTZXQ9InRydWUiIG1zZGF0YTpNYWluRGF0YVRhYmxlPSJjb3JlbnNfeDAwM0FfRGF0YXRhYmxlIiBtc2RhdGE6TG9jYWxlPSIiPg0KICAgIDx4czpjb21wbGV4VHlwZT4NCiAgICAgIDx4czpjaG9pY2UgbWluT2NjdXJzPSIwIiBtYXhPY2N1cnM9InVuYm91bmRlZCIgLz4NCiAgICA8L3hzOmNvbXBsZXhUeXBlPg0KICA8L3hzOmVsZW1lbnQ+DQo8L3hzOnNjaGVtYT4GBQAAAIABPGRpZmZncjpkaWZmZ3JhbSB4bWxuczptc2RhdGE9InVybjpzY2hlbWFzLW1pY3Jvc29mdC1jb206eG1sLW1zZGF0YSIgeG1sbnM6ZGlmZmdyPSJ1cm46c2NoZW1hcy1taWNyb3NvZnQtY29tOnhtbC1kaWZmZ3JhbS12MSIgLz4EAwAAAA5TeXN0ZW0uVmVyc2lvbgQAAAAGX01ham9yBl9NaW5vcgZfQnVpbGQJX1JldmlzaW9uAAAAAAgICAgCAAAAAAAAAP//////////Cw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAE5TeXN0ZW0uRGF0YSwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODkFAQAAABVTeXN0ZW0uRGF0YS5EYXRhVGFibGUDAAAAGURhdGFUYWJsZS5SZW1vdGluZ1ZlcnNpb24JWG1sU2NoZW1hC1htbERpZmZHcmFtAwEBDlN5c3RlbS5WZXJzaW9uAgAAAAkDAAAABgQAAAD8BDw/eG1sIHZlcnNpb249IjEuMCIgZW5jb2Rpbmc9InV0Zi0xNiI/Pg0KPHhzOnNjaGVtYSB0YXJnZXROYW1lc3BhY2U9ImNvcmVucyIgeG1sbnM6bXN0bnM9ImNvcmVucyIgeG1sbnM9ImNvcmVucyIgeG1sbnM6eHM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDEvWE1MU2NoZW1hIiB4bWxuczptc2RhdGE9InVybjpzY2hlbWFzLW1pY3Jvc29mdC1jb206eG1sLW1zZGF0YSIgYXR0cmlidXRlRm9ybURlZmF1bHQ9InF1YWxpZmllZCIgZWxlbWVudEZvcm1EZWZhdWx0PSJxdWFsaWZpZWQiPg0KICA8eHM6ZWxlbWVudCBuYW1lPSJEYXRhdGFibGUiPg0KICAgIDx4czpjb21wbGV4VHlwZT4NCiAgICA8L3hzOmNvbXBsZXhUeXBlPg0KICA8L3hzOmVsZW1lbnQ+DQogIDx4czplbGVtZW50IG5hbWU9InRtcERhdGFTZXQiIG1zZGF0YTpJc0RhdGFTZXQ9InRydWUiIG1zZGF0YTpNYWluRGF0YVRhYmxlPSJjb3JlbnNfeDAwM0FfRGF0YXRhYmxlIiBtc2RhdGE6VXNlQ3VycmVudExvY2FsZT0idHJ1ZSI+DQogICAgPHhzOmNvbXBsZXhUeXBlPg0KICAgICAgPHhzOmNob2ljZSBtaW5PY2N1cnM9IjAiIG1heE9jY3Vycz0idW5ib3VuZGVkIiAvPg0KICAgIDwveHM6Y29tcGxleFR5cGU+DQogIDwveHM6ZWxlbWVudD4NCjwveHM6c2NoZW1hPgYFAAAAgAE8ZGlmZmdyOmRpZmZncmFtIHhtbG5zOm1zZGF0YT0idXJuOnNjaGVtYXMtbWljcm9zb2Z0LWNvbTp4bWwtbXNkYXRhIiB4bWxuczpkaWZmZ3I9InVybjpzY2hlbWFzLW1pY3Jvc29mdC1jb206eG1sLWRpZmZncmFtLXYxIiAvPgQDAAAADlN5c3RlbS5WZXJzaW9uBAAAAAZfTWFqb3IGX01pbm9yBl9CdWlsZAlfUmV2aXNpb24AAAAACAgICAIAAAAAAAAA//////////8L" } };
            var propertyCollection = new PropertyCollection
            {
                { "p1", "v1" },
                { "px", "vx" }
            };
            yield return new object[] { propertyCollection, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uRGF0YS5Db21tb24sIFZlcnNpb249NC4yLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhDAMAAABcU3lzdGVtLlJ1bnRpbWUuRXh0ZW5zaW9ucywgVmVyc2lvbj00LjIuMS4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2EFAQAAAB5TeXN0ZW0uRGF0YS5Qcm9wZXJ0eUNvbGxlY3Rpb24HAAAACkxvYWRGYWN0b3IHVmVyc2lvbghDb21wYXJlchBIYXNoQ29kZVByb3ZpZGVyCEhhc2hTaXplBEtleXMGVmFsdWVzAAADBAAFBQsIHFN5c3RlbS5Db2xsZWN0aW9ucy5JQ29tcGFyZXIkU3lzdGVtLkNvbGxlY3Rpb25zLklIYXNoQ29kZVByb3ZpZGVyAwAAAAgCAAAA7FE4PwIAAAAKCgMAAAAJBAAAAAkFAAAAEAQAAAACAAAABgYAAAACcHgGBwAAAAJwMRAFAAAAAgAAAAYIAAAAAnZ4BgkAAAACdjEL", "AAEAAAD/////AQAAAAAAAAAMAgAAAE5TeXN0ZW0uRGF0YSwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODkFAQAAAB5TeXN0ZW0uRGF0YS5Qcm9wZXJ0eUNvbGxlY3Rpb24HAAAACkxvYWRGYWN0b3IHVmVyc2lvbghDb21wYXJlchBIYXNoQ29kZVByb3ZpZGVyCEhhc2hTaXplBEtleXMGVmFsdWVzAAADAwAFBQsIHFN5c3RlbS5Db2xsZWN0aW9ucy5JQ29tcGFyZXIkU3lzdGVtLkNvbGxlY3Rpb25zLklIYXNoQ29kZVByb3ZpZGVyCAIAAADsUTg/AgAAAAoKAwAAAAkDAAAACQQAAAAQAwAAAAIAAAAGBQAAAAJweAYGAAAAAnAxEAQAAAACAAAABgcAAAACdngGCAAAAAJ2MQs=" } };
            yield return new object[] { new SqlBoolean(true), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uRGF0YS5Db21tb24sIFZlcnNpb249NC4yLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAAfU3lzdGVtLkRhdGEuU3FsVHlwZXMuU3FsQm9vbGVhbgEAAAAHbV92YWx1ZQACAgAAAAIL", "AAEAAAD/////AQAAAAAAAAAMAgAAAE5TeXN0ZW0uRGF0YSwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODkFAQAAAB9TeXN0ZW0uRGF0YS5TcWxUeXBlcy5TcWxCb29sZWFuAQAAAAdtX3ZhbHVlAAICAAAAAgs=" } };
            yield return new object[] { new SqlByte(255), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uRGF0YS5Db21tb24sIFZlcnNpb249NC4yLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAAcU3lzdGVtLkRhdGEuU3FsVHlwZXMuU3FsQnl0ZQIAAAAKbV9mTm90TnVsbAdtX3ZhbHVlAAABAgIAAAAB/ws=", "AAEAAAD/////AQAAAAAAAAAMAgAAAE5TeXN0ZW0uRGF0YSwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODkFAQAAABxTeXN0ZW0uRGF0YS5TcWxUeXBlcy5TcWxCeXRlAgAAAAptX2ZOb3ROdWxsB21fdmFsdWUAAAECAgAAAAH/Cw==" } };
            yield return new object[] { new SqlDateTime(new DateTime(1990, 11, 23, 03, 30, 00, 00, DateTimeKind.Utc)), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uRGF0YS5Db21tb24sIFZlcnNpb249NC4yLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAAgU3lzdGVtLkRhdGEuU3FsVHlwZXMuU3FsRGF0ZVRpbWUDAAAACm1fZk5vdE51bGwFbV9kYXkGbV90aW1lAAAAAQgIAgAAAAGugQAAoK05AAs=", "AAEAAAD/////AQAAAAAAAAAMAgAAAE5TeXN0ZW0uRGF0YSwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODkFAQAAACBTeXN0ZW0uRGF0YS5TcWxUeXBlcy5TcWxEYXRlVGltZQMAAAAKbV9mTm90TnVsbAVtX2RheQZtX3RpbWUAAAABCAgCAAAAAa6BAACgrTkACw==" } };
            yield return new object[] { new SqlDouble(34.5), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uRGF0YS5Db21tb24sIFZlcnNpb249NC4yLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAAeU3lzdGVtLkRhdGEuU3FsVHlwZXMuU3FsRG91YmxlAgAAAAptX2ZOb3ROdWxsB21fdmFsdWUAAAEGAgAAAAEAAAAAAEBBQAs=", "AAEAAAD/////AQAAAAAAAAAMAgAAAE5TeXN0ZW0uRGF0YSwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODkFAQAAAB5TeXN0ZW0uRGF0YS5TcWxUeXBlcy5TcWxEb3VibGUCAAAACm1fZk5vdE51bGwHbV92YWx1ZQAAAQYCAAAAAQAAAAAAQEFACw==" } };
            yield return new object[] { new SqlInt16(256), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uRGF0YS5Db21tb24sIFZlcnNpb249NC4yLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAAdU3lzdGVtLkRhdGEuU3FsVHlwZXMuU3FsSW50MTYCAAAACm1fZk5vdE51bGwHbV92YWx1ZQAAAQcCAAAAAQABCw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAE5TeXN0ZW0uRGF0YSwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODkFAQAAAB1TeXN0ZW0uRGF0YS5TcWxUeXBlcy5TcWxJbnQxNgIAAAAKbV9mTm90TnVsbAdtX3ZhbHVlAAABBwIAAAABAAEL" } };
            yield return new object[] { new SqlInt32(4096314), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uRGF0YS5Db21tb24sIFZlcnNpb249NC4yLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAAdU3lzdGVtLkRhdGEuU3FsVHlwZXMuU3FsSW50MzICAAAACm1fZk5vdE51bGwHbV92YWx1ZQAAAQgCAAAAATqBPgAL", "AAEAAAD/////AQAAAAAAAAAMAgAAAE5TeXN0ZW0uRGF0YSwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODkFAQAAAB1TeXN0ZW0uRGF0YS5TcWxUeXBlcy5TcWxJbnQzMgIAAAAKbV9mTm90TnVsbAdtX3ZhbHVlAAABCAIAAAABOoE+AAs=" } };
            yield return new object[] { new SqlInt64(3492867384596), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uRGF0YS5Db21tb24sIFZlcnNpb249NC4yLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAAdU3lzdGVtLkRhdGEuU3FsVHlwZXMuU3FsSW50NjQCAAAACm1fZk5vdE51bGwHbV92YWx1ZQAAAQkCAAAAARSlHj8tAwAACw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAE5TeXN0ZW0uRGF0YSwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODkFAQAAAB1TeXN0ZW0uRGF0YS5TcWxUeXBlcy5TcWxJbnQ2NAIAAAAKbV9mTm90TnVsbAdtX3ZhbHVlAAABCQIAAAABFKUePy0DAAAL" } };
            yield return new object[] { new SqlString("abc", CultureInfo.InvariantCulture.LCID, SqlCompareOptions.BinarySort), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uRGF0YS5Db21tb24sIFZlcnNpb249NC4yLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAAeU3lzdGVtLkRhdGEuU3FsVHlwZXMuU3FsU3RyaW5nBQAAAAdtX3ZhbHVlCW1fY21wSW5mbwZtX2xjaWQGbV9mbGFnCm1fZk5vdE51bGwBAwAEACBTeXN0ZW0uR2xvYmFsaXphdGlvbi5Db21wYXJlSW5mbwgmU3lzdGVtLkRhdGEuU3FsVHlwZXMuU3FsQ29tcGFyZU9wdGlvbnMCAAAAAQIAAAAGAwAAAANhYmMKfwAAAAX8////JlN5c3RlbS5EYXRhLlNxbFR5cGVzLlNxbENvbXBhcmVPcHRpb25zAQAAAAd2YWx1ZV9fAAgCAAAAAIAAAAEL", "AAEAAAD/////AQAAAAAAAAAMAgAAAE5TeXN0ZW0uRGF0YSwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODkFAQAAAB5TeXN0ZW0uRGF0YS5TcWxUeXBlcy5TcWxTdHJpbmcFAAAAB21fdmFsdWUJbV9jbXBJbmZvBm1fbGNpZAZtX2ZsYWcKbV9mTm90TnVsbAEDAAQAIFN5c3RlbS5HbG9iYWxpemF0aW9uLkNvbXBhcmVJbmZvCCZTeXN0ZW0uRGF0YS5TcWxUeXBlcy5TcWxDb21wYXJlT3B0aW9ucwIAAAABAgAAAAYDAAAAA2FiYwoJBAAABfz///8mU3lzdGVtLkRhdGEuU3FsVHlwZXMuU3FsQ29tcGFyZU9wdGlvbnMBAAAAB3ZhbHVlX18ACAIAAAAAgAAAAQs=" } };

            yield return new object[] { new BigInteger(), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFpTeXN0ZW0uUnVudGltZS5OdW1lcmljcywgVmVyc2lvbj00LjEuMS4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2EFAQAAABpTeXN0ZW0uTnVtZXJpY3MuQmlnSW50ZWdlcgIAAAAFX3NpZ24FX2JpdHMABwgPAgAAAAAAAAAKCw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAFJTeXN0ZW0uTnVtZXJpY3MsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAAAaU3lzdGVtLk51bWVyaWNzLkJpZ0ludGVnZXICAAAABV9zaWduBV9iaXRzAAcIDwIAAAAAAAAACgs=" } };
            yield return new object[] { new BigInteger(10324176), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFpTeXN0ZW0uUnVudGltZS5OdW1lcmljcywgVmVyc2lvbj00LjEuMS4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2EFAQAAABpTeXN0ZW0uTnVtZXJpY3MuQmlnSW50ZWdlcgIAAAAFX3NpZ24FX2JpdHMABwgPAgAAANCInQAKCw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAFJTeXN0ZW0uTnVtZXJpY3MsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAAAaU3lzdGVtLk51bWVyaWNzLkJpZ0ludGVnZXICAAAABV9zaWduBV9iaXRzAAcIDwIAAADQiJ0ACgs=" } };
            yield return new object[] { new Complex(12, 6), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFpTeXN0ZW0uUnVudGltZS5OdW1lcmljcywgVmVyc2lvbj00LjEuMS4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2EFAQAAABdTeXN0ZW0uTnVtZXJpY3MuQ29tcGxleAIAAAAGbV9yZWFsC21faW1hZ2luYXJ5AAAGBgIAAAAAAAAAAAAoQAAAAAAAABhACw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAFJTeXN0ZW0uTnVtZXJpY3MsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAAAXU3lzdGVtLk51bWVyaWNzLkNvbXBsZXgCAAAABm1fcmVhbAttX2ltYWdpbmFyeQAABgYCAAAAAAAAAAAAKEAAAAAAAAAYQAs=" } };

            // Arrays of primitive types
            yield return new object[] { Enumerable.Range(0, 256).Select(i => (byte)i).ToArray(), new string[] { "AAEAAAD/////AQAAAAAAAAAPAQAAAAABAAACAAECAwQFBgcICQoLDA0ODxAREhMUFRYXGBkaGxwdHh8gISIjJCUmJygpKissLS4vMDEyMzQ1Njc4OTo7PD0+P0BBQkNERUZHSElKS0xNTk9QUVJTVFVWV1hZWltcXV5fYGFiY2RlZmdoaWprbG1ub3BxcnN0dXZ3eHl6e3x9fn+AgYKDhIWGh4iJiouMjY6PkJGSk5SVlpeYmZqbnJ2en6ChoqOkpaanqKmqq6ytrq+wsbKztLW2t7i5uru8vb6/wMHCw8TFxsfIycrLzM3Oz9DR0tPU1dbX2Nna29zd3t/g4eLj5OXm5+jp6uvs7e7v8PHy8/T19vf4+fr7/P3+/ws=", "AAEAAAD/////AQAAAAAAAAAPAQAAAAABAAACAAECAwQFBgcICQoLDA0ODxAREhMUFRYXGBkaGxwdHh8gISIjJCUmJygpKissLS4vMDEyMzQ1Njc4OTo7PD0+P0BBQkNERUZHSElKS0xNTk9QUVJTVFVWV1hZWltcXV5fYGFiY2RlZmdoaWprbG1ub3BxcnN0dXZ3eHl6e3x9fn+AgYKDhIWGh4iJiouMjY6PkJGSk5SVlpeYmZqbnJ2en6ChoqOkpaanqKmqq6ytrq+wsbKztLW2t7i5uru8vb6/wMHCw8TFxsfIycrLzM3Oz9DR0tPU1dbX2Nna29zd3t/g4eLj5OXm5+jp6uvs7e7v8PHy8/T19vf4+fr7/P3+/ws=" } };
            yield return new object[] { new int[] { }, new string[] { "AAEAAAD/////AQAAAAAAAAAPAQAAAAAAAAAICw==", "AAEAAAD/////AQAAAAAAAAAPAQAAAAAAAAAICw==" } };
            yield return new object[] { new int[] { 1 }, new string[] { "AAEAAAD/////AQAAAAAAAAAPAQAAAAEAAAAIAQAAAAs=", "AAEAAAD/////AQAAAAAAAAAPAQAAAAEAAAAIAQAAAAs=" } };
            yield return new object[] { new int[] { 1, 2, 3, 4, 5 }, new string[] { "AAEAAAD/////AQAAAAAAAAAPAQAAAAUAAAAIAQAAAAIAAAADAAAABAAAAAUAAAAL", "AAEAAAD/////AQAAAAAAAAAPAQAAAAUAAAAIAQAAAAIAAAADAAAABAAAAAUAAAAL" } };
            yield return new object[] { new char[] { 'a', 'b', 'c', 'd', 'e' }, new string[] { "AAEAAAD/////AQAAAAAAAAAPAQAAAAUAAAADYWJjZGUL", "AAEAAAD/////AQAAAAAAAAAPAQAAAAUAAAADYWJjZGUL" } };
            yield return new object[] { new string[] { }, new string[] { "AAEAAAD/////AQAAAAAAAAARAQAAAAAAAAAL", "AAEAAAD/////AQAAAAAAAAARAQAAAAAAAAAL" } };
            yield return new object[] { new string[] { "hello", "world" }, new string[] { "AAEAAAD/////AQAAAAAAAAARAQAAAAIAAAAGAgAAAAVoZWxsbwYDAAAABXdvcmxkCw==", "AAEAAAD/////AQAAAAAAAAARAQAAAAIAAAAGAgAAAAVoZWxsbwYDAAAABXdvcmxkCw==" } };
            yield return new object[] { new short[] { short.MaxValue }, new string[] { "AAEAAAD/////AQAAAAAAAAAPAQAAAAEAAAAH/38L", "AAEAAAD/////AQAAAAAAAAAPAQAAAAEAAAAH/38L" } };
            yield return new object[] { new long[] { long.MaxValue }, new string[] { "AAEAAAD/////AQAAAAAAAAAPAQAAAAEAAAAJ/////////38L", "AAEAAAD/////AQAAAAAAAAAPAQAAAAEAAAAJ/////////38L" } };
            yield return new object[] { new ushort[] { ushort.MaxValue }, new string[] { "AAEAAAD/////AQAAAAAAAAAPAQAAAAEAAAAO//8L", "AAEAAAD/////AQAAAAAAAAAPAQAAAAEAAAAO//8L" } };
            yield return new object[] { new uint[] { uint.MaxValue }, new string[] { "AAEAAAD/////AQAAAAAAAAAPAQAAAAEAAAAP/////ws=", "AAEAAAD/////AQAAAAAAAAAPAQAAAAEAAAAP/////ws=" } };
            yield return new object[] { new ulong[] { ulong.MaxValue }, new string[] { "AAEAAAD/////AQAAAAAAAAAPAQAAAAEAAAAQ//////////8L", "AAEAAAD/////AQAAAAAAAAAPAQAAAAEAAAAQ//////////8L" } };
            yield return new object[] { new bool[] { true, false }, new string[] { "AAEAAAD/////AQAAAAAAAAAPAQAAAAIAAAABAQAL", "AAEAAAD/////AQAAAAAAAAAPAQAAAAIAAAABAQAL" } };
            yield return new object[] { new double[] { 1.2 }, new string[] { "AAEAAAD/////AQAAAAAAAAAPAQAAAAEAAAAGMzMzMzMz8z8L", "AAEAAAD/////AQAAAAAAAAAPAQAAAAEAAAAGMzMzMzMz8z8L" } };
            yield return new object[] { new float[] { 1.2f, 3.4f }, new string[] { "AAEAAAD/////AQAAAAAAAAAPAQAAAAIAAAALmpmZP5qZWUAL", "AAEAAAD/////AQAAAAAAAAAPAQAAAAIAAAALmpmZP5qZWUAL" } };

            // Arrays of other types
            yield return new object[] { new object[] { }, new string[] { "AAEAAAD/////AQAAAAAAAAAQAQAAAAAAAAAL", "AAEAAAD/////AQAAAAAAAAAQAQAAAAAAAAAL" } };
            yield return new object[] { new Guid[] { new Guid("0CACAA4D-C6BD-420A-B660-2F557337CA89"), new Guid("BE4E9FF4-82D9-4B54-85EA-0957E21DE0E2") }, new string[] { "AAEAAAD/////AQAAAAAAAAAHAQAAAAABAAAAAgAAAAMLU3lzdGVtLkd1aWQE/v///wtTeXN0ZW0uR3VpZAsAAAACX2ECX2ICX2MCX2QCX2UCX2YCX2cCX2gCX2kCX2oCX2sAAAAAAAAAAAAAAAgHBwICAgICAgICTaqsDL3GCkK2YC9VczfKiQH9/////v////SfTr7ZglRLheoJV+Id4OIL", "AAEAAAD/////AQAAAAAAAAAHAQAAAAABAAAAAgAAAAMLU3lzdGVtLkd1aWQE/v///wtTeXN0ZW0uR3VpZAsAAAACX2ECX2ICX2MCX2QCX2UCX2YCX2cCX2gCX2kCX2oCX2sAAAAAAAAAAAAAAAgHBwICAgICAgICTaqsDL3GCkK2YC9VczfKiQH9/////v////SfTr7ZglRLheoJV+Id4OIL" } };
            yield return new object[] { new DayOfWeek[] { DayOfWeek.Monday, DayOfWeek.Tuesday, DayOfWeek.Wednesday, DayOfWeek.Thursday, DayOfWeek.Friday }, new string[] { "AAEAAAD/////AQAAAAAAAAAHAQAAAAABAAAABQAAAAMQU3lzdGVtLkRheU9mV2VlawT+////EFN5c3RlbS5EYXlPZldlZWsBAAAAB3ZhbHVlX18ACAEAAAAB/f////7///8CAAAAAfz////+////AwAAAAH7/////v///wQAAAAB+v////7///8FAAAACw==", "AAEAAAD/////AQAAAAAAAAAHAQAAAAABAAAABQAAAAMQU3lzdGVtLkRheU9mV2VlawT+////EFN5c3RlbS5EYXlPZldlZWsBAAAAB3ZhbHVlX18ACAEAAAAB/f////7///8CAAAAAfz////+////AwAAAAH7/////v///wQAAAAB+v////7///8FAAAACw==" } };
            yield return new object[] { new Point[] { new Point(1, 2), new Point(3, 4) }, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBwEAAAAAAQAAAAIAAAAEM1N5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5Qb2ludAIAAAAJAwAAAAkEAAAABQMAAAAzU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50AgAAAAFYAVkAAAgIAgAAAAEAAAACAAAAAQQAAAADAAAAAwAAAAQAAAAL", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBwEAAAAAAQAAAAIAAAAEM1N5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5Qb2ludAIAAAAJAwAAAAkEAAAABQMAAAAzU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50AgAAAAFYAVkAAAgIAgAAAAEAAAACAAAAAQQAAAADAAAAAwAAAAQAAAAL" } };
            yield return new object[] { new ObjectWithArrays
            {
                IntArray = new int[0],
                StringArray = new string[] { "hello", "world" },
                ByteArray = new byte[] { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 },
                JaggedArray = new int[][] { new int[] { 1, 2, 3 }, new int[] { 4, 5, 6, 7 } },
                MultiDimensionalArray = new int[,] { { 1, 2 }, { 3, 4 }, { 5, 6 } },
                TreeArray = new Tree<int>[] { new Tree<int>(1, new Tree<int>(2, null, null), new Tree<int>(3, null, null)) }
            }, new string[] { "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", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjIuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAAA+U3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLk9iamVjdFdpdGhBcnJheXMGAAAACEludEFycmF5C1N0cmluZ0FycmF5CVRyZWVBcnJheQlCeXRlQXJyYXkLSmFnZ2VkQXJyYXkVTXVsdGlEaW1lbnNpb25hbEFycmF5BwYEBwMDCJMBU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlRyZWVgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXVtdAgAAAAIQU3lzdGVtLkludDMyW11bXQ9TeXN0ZW0uSW50MzJbLF0CAAAACQMAAAAJBAAAAAkFAAAACQYAAAAJBwAAAAkIAAAADwMAAAAAAAAACBEEAAAAAgAAAAYJAAAABWhlbGxvBgoAAAAFd29ybGQHBQAAAAABAAAAAQAAAASRAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5UcmVlYDFbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0CAAAACQsAAAAPBgAAABQAAAACAAECAwQFBgcICQoLDA0ODxAREhMHBwAAAAEBAAAAAgAAAAcICQwAAAAJDQAAAAcIAAAAAgIAAAADAAAAAgAAAAAIAQAAAAIAAAADAAAABAAAAAUAAAAGAAAABQsAAACRAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5UcmVlYDFbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0DAAAAFjxWYWx1ZT5rX19CYWNraW5nRmllbGQVPExlZnQ+a19fQmFja2luZ0ZpZWxkFjxSaWdodD5rX19CYWNraW5nRmllbGQABAQIkQFTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuVHJlZWAxW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dAgAAAJEBU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlRyZWVgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQIAAAACAAAAAQAAAAkOAAAACQ8AAAAPDAAAAAMAAAAIAQAAAAIAAAADAAAADw0AAAAEAAAACAQAAAAFAAAABgAAAAcAAAABDgAAAAsAAAACAAAACgoBDwAAAAsAAAADAAAACgoL" } };
            yield return new object[] { new object[] { new int[,] { { 1, 2, 3, 4, 5 }, { 6, 7, 8, 9, 10 }, { 11, 12, 13, 14, 15 } } }, new string[] { "AAEAAAD/////AQAAAAAAAAAQAQAAAAEAAAAJAgAAAAcCAAAAAgIAAAADAAAABQAAAAAIAQAAAAIAAAADAAAABAAAAAUAAAAGAAAABwAAAAgAAAAJAAAACgAAAAsAAAAMAAAADQAAAA4AAAAPAAAACw==", "AAEAAAD/////AQAAAAAAAAAQAQAAAAEAAAAJAgAAAAcCAAAAAgIAAAADAAAABQAAAAAIAQAAAAIAAAADAAAABAAAAAUAAAAGAAAABwAAAAgAAAAJAAAACgAAAAsAAAAMAAAADQAAAA4AAAAPAAAACw==" } };
            yield return new object[] { new object[] { new int[,,] { { { 1, 2, 3, 4, 5 }, { 6, 7, 8, 9, 10 }, { 11, 12, 13, 14, 15 } } } }, new string[] { "AAEAAAD/////AQAAAAAAAAAQAQAAAAEAAAAJAgAAAAcCAAAAAgMAAAABAAAAAwAAAAUAAAAACAEAAAACAAAAAwAAAAQAAAAFAAAABgAAAAcAAAAIAAAACQAAAAoAAAALAAAADAAAAA0AAAAOAAAADwAAAAs=", "AAEAAAD/////AQAAAAAAAAAQAQAAAAEAAAAJAgAAAAcCAAAAAgMAAAABAAAAAwAAAAUAAAAACAEAAAACAAAAAwAAAAQAAAAFAAAABgAAAAcAAAAIAAAACQAAAAoAAAALAAAADAAAAA0AAAAOAAAADwAAAAs=" } };
            yield return new object[] { new object[] { new int[,,,] { { { { 1 } } } } }, new string[] { "AAEAAAD/////AQAAAAAAAAAQAQAAAAEAAAAJAgAAAAcCAAAAAgQAAAABAAAAAQAAAAEAAAABAAAAAAgBAAAACw==", "AAEAAAD/////AQAAAAAAAAAQAQAAAAEAAAAJAgAAAAcCAAAAAgQAAAABAAAAAQAAAAEAAAABAAAAAAgBAAAACw==" } };
            yield return new object[] { new ArraySegment<int>(new int[] { 1, 2, 3, 4, 5 }, 1, 2), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAIABU3lzdGVtLkFycmF5U2VnbWVudGAxW1tTeXN0ZW0uSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0DAAAABl9hcnJheQdfb2Zmc2V0Bl9jb3VudAcAAAgICAkCAAAAAQAAAAIAAAAPAgAAAAUAAAAIAQAAAAIAAAADAAAABAAAAAUAAAAL", "AAEAAAD/////AQAAAAAAAAAEAQAAAHJTeXN0ZW0uQXJyYXlTZWdtZW50YDFbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0DAAAABl9hcnJheQdfb2Zmc2V0Bl9jb3VudAcAAAgICAkCAAAAAQAAAAIAAAAPAgAAAAUAAAAIAQAAAAIAAAADAAAABAAAAAUAAAAL" } };
            yield return new object[] { Enumerable.Range(0, 10000).Select(i => (object)i).ToArray(), new string[] { "AAEAAAD/////AQAAAAAAAAAQAQAAABAnAAAICAAAAAAICAEAAAAICAIAAAAICAMAAAAICAQAAAAICAUAAAAICAYAAAAICAcAAAAICAgAAAAICAkAAAAICAoAAAAICAsAAAAICAwAAAAICA0AAAAICA4AAAAICA8AAAAICBAAAAAICBEAAAAICBIAAAAICBMAAAAICBQAAAAICBUAAAAICBYAAAAICBcAAAAICBgAAAAICBkAAAAICBoAAAAICBsAAAAICBwAAAAICB0AAAAICB4AAAAICB8AAAAICCAAAAAICCEAAAAICCIAAAAICCMAAAAICCQAAAAICCUAAAAICCYAAAAICCcAAAAICCgAAAAICCkAAAAICCoAAAAICCsAAAAICCwAAAAICC0AAAAICC4AAAAICC8AAAAICDAAAAAICDEAAAAICDIAAAAICDMAAAAICDQAAAAICDUAAAAICDYAAAAICDcAAAAICDgAAAAICDkAAAAICDoAAAAICDsAAAAICDwAAAAICD0AAAAICD4AAAAICD8AAAAICEAAAAAICEEAAAAICEIAAAAICEMAAAAICEQAAAAICEUAAAAICEYAAAAICEcAAAAICEgAAAAICEkAAAAICEoAAAAICEsAAAAICEwAAAAICE0AAAAICE4AAAAICE8AAAAICFAAAAAICFEAAAAICFIAAAAICFMAAAAICFQAAAAICFUAAAAICFYAAAAICFcAAAAICFgAAAAICFkAAAAICFoAAAAICFsAAAAICFwAAAAICF0AAAAICF4AAAAICF8AAAAICGAAAAAICGEAAAAICGIAAAAICGMAAAAICGQAAAAICGUAAAAICGYAAAAICGcAAAAICGgAAAAICGkAAAAICGoAAAAICGsAAAAICGwAAAAICG0AAAAICG4AAAAICG8AAAAICHAAAAAICHEAAAAICHIAAAAICHMAAAAICHQAAAAICHUAAAAICHYAAAAICHcAAAAICHgAAAAICHkAAAAICHoAAAAICHsAAAAICHwAAAAICH0AAAAICH4AAAAICH8AAAAICIAAAAAICIEAAAAICIIAAAAICIMAAAAICIQAAAAICIUAAAAICIYAAAAICIcAAAAICIgAAAAICIkAAAAICIoAAAAICIsAAAAICIwAAAAICI0AAAAICI4AAAAICI8AAAAICJAAAAAICJEAAAAICJIAAAAICJMAAAAICJQAAAAICJUAAAAICJYAAAAICJcAAAAICJgAAAAICJkAAAAICJoAAAAICJsAAAAICJwAAAAICJ0AAAAICJ4AAAAICJ8AAAAICKAAAAAICKEAAAAICKIAAAAICKMAAAAICKQAAAAICKUAAAAICKYAAAAICKcAAAAICKgAAAAICKkAAAAICKoAAAAICKsAAAAICKwAAAAICK0AAAAICK4AAAAICK8AAAAICLAAAAAICLEAAAAICLIAAAAICLMAAAAICLQAAAAICLUAAAAICLYAAAAICLcAAAAICLgAAAAICLkAAAAICLoAAAAICLsAAAAICLwAAAAICL0AAAAICL4AAAAICL8AAAAICMAAAAAICMEAAAAICMIAAAAICMMAAAAICMQAAAAICMUAAAAICMYAAAAICMcAAAAICMgAAAAICMkAAAAICMoAAAAICMsAAAAICMwAAAAICM0AAAAICM4AAAAICM8AAAAICNAAAAAICNEAAAAICNIAAAAICNMAAAAICNQAAAAICNUAAAAICNYAAAAICNcAAAAICNgAAAAICNkAAAAICNoAAAAICNsAAAAICNwAAAAICN0AAAAICN4AAAAICN8AAAAICOAAAAAICOEAAAAICOIAAAAICOMAAAAICOQAAAAICOUAAAAICOYAAAAICOcAAAAICOgAAAAICOkAAAAICOoAAAAICOsAAAAICOwAAAAICO0AAAAICO4AAAAICO8AAAAICPAAAAAICPEAAAAICPIAAAAICPMAAAAICPQAAAAICPUAAAAICPYAAAAICPcAAAAICPgAAAAICPkAAAAICPoAAAAICPsAAAAICPwAAAAICP0AAAAICP4AAAAICP8AAAAICAABAAAICAEBAAAICAIBAAAICAMBAAAICAQBAAAICAUBAAAICAYBAAAICAcBAAAICAgBAAAICAkBAAAICAoBAAAICAsBAAAICAwBAAAICA0BAAAICA4BAAAICA8BAAAICBABAAAICBEBAAAICBIBAAAICBMBAAAICBQBAAAICBUBAAAICBYBAAAICBcBAAAICBgBAAAICBkBAAAICBoBAAAICBsBAAAICBwBAAAICB0BAAAICB4BAAAICB8BAAAICCABAAAICCEBAAAICCIBAAAICCMBAAAICCQBAAAICCUBAAAICCYBAAAICCcBAAAICCgBAAAICCkBAAAICCoBAAAICCsBAAAICCwBAAAICC0BAAAICC4BAAAICC8BAAAICDABAAAICDEBAAAICDIBAAAICDMBAAAICDQBAAAICDUBAAAICDYBAAAICDcBAAAICDgBAAAICDkBAAAICDoBAAAICDsBAAAICDwBAAAICD0BAAAICD4BAAAICD8BAAAICEABAAAICEEBAAAICEIBAAAICEMBAAAICEQBAAAICEUBAAAICEYBAAAICEcBAAAICEgBAAAICEkBAAAICEoBAAAICEsBAAAICEwBAAAICE0BAAAICE4BAAAICE8BAAAICFABAAAICFEBAAAICFIBAAAICFMBAAAICFQBAAAICFUBAAAICFYBAAAICFcBAAAICFgBAAAICFkBAAAICFoBAAAICFsBAAAICFwBAAAICF0BAAAICF4BAAAICF8BAAAICGABAAAICGEBAAAICGIBAAAICGMBAAAICGQBAAAICGUBAAAICGYBAAAICGcBAAAICGgBAAAICGkBAAAICGoBAAAICGsBAAAICGwBAAAICG0BAAAICG4BAAAICG8BAAAICHABAAAICHEBAAAICHIBAAAICHMBAAAICHQBAAAICHUBAAAICHYBAAAICHcBAAAICHgBAAAICHkBAAAICHoBAAAICHsBAAAICHwBAAAICH0BAAAICH4BAAAICH8BAAAICIABAAAICIEBAAAICIIBAAAICIMBAAAICIQBAAAICIUBAAAICIYBAAAICIcBAAAICIgBAAAICIkBAAAICIoBAAAICIsBAAAICIwBAAAICI0BAAAICI4BAAAICI8BAAAICJABAAAICJEBAAAICJIBAAAICJMBAAAICJQBAAAICJUBAAAICJYBAAAICJcBAAAICJgBAAAICJkBAAAICJoBAAAICJsBAAAICJwBAAAICJ0BAAAICJ4BAAAICJ8BAAAICKABAAAICKEBAAAICKIBAAAICKMBAAAICKQBAAAICKUBAAAICKYBAAAICKcBAAAICKgBAAAICKkBAAAICKoBAAAICKsBAAAICKwBAAAICK0BAAAICK4BAAAICK8BAAAICLABAAAICLEBAAAICLIBAAAICLMBAAAICLQBAAAICLUBAAAICLYBAAAICLcBAAAICLgBAAAICLkBAAAICLoBAAAICLsBAAAICLwBAAAICL0BAAAICL4BAAAICL8BAAAICMABAAAICMEBAAAICMIBAAAICMMBAAAICMQBAAAICMUBAAAICMYBAAAICMcBAAAICMgBAAAICMkBAAAICMoBAAAICMsBAAAICMwBAAAICM0BAAAICM4BAAAICM8BAAAICNABAAAICNEBAAAICNIBAAAICNMBAAAICNQBAAAICNUBAAAICNYBAAAICNcBAAAICNgBAAAICNkBAAAICNoBAAAICNsBAAAICNwBAAAICN0BAAAICN4BAAAICN8BAAAICOABAAAICOEBAAAICOIBAAAICOMBAAAICOQBAAAICOUBAAAICOYBAAAICOcBAAAICOgBAAAICOkBAAAICOoBAAAICOsBAAAICOwBAAAICO0BAAAICO4BAAAICO8BAAAICPABAAAICPEBAAAICPIBAAAICPMBAAAICPQBAAAICPUBAAAICPYBAAAICPcBAAAICPgBAAAICPkBAAAICPoBAAAICPsBAAAICPwBAAAICP0BAAAICP4BAAAICP8BAAAICAACAAAICAECAAAICAICAAAICAMCAAAICAQCAAAICAUCAAAICAYCAAAICAcCAAAICAgCAAAICAkCAAAICAoCAAAICAsCAAAICAwCAAAICA0CAAAICA4CAAAICA8CAAAICBACAAAICBECAAAICBICAAAICBMCAAAICBQCAAAICBUCAAAICBYCAAAICBcCAAAICBgCAAAICBkCAAAICBoCAAAICBsCAAAICBwCAAAICB0CAAAICB4CAAAICB8CAAAICCACAAAICCECAAAICCICAAAICCMCAAAICCQCAAAICCUCAAAICCYCAAAICCcCAAAICCgCAAAICCkCAAAICCoCAAAICCsCAAAICCwCAAAICC0CAAAICC4CAAAICC8CAAAICDACAAAICDECAAAICDICAAAICDMCAAAICDQCAAAICDUCAAAICDYCAAAICDcCAAAICDgCAAAICDkCAAAICDoCAAAICDsCAAAICDwCAAAICD0CAAAICD4CAAAICD8CAAAICEACAAAICEECAAAICEICAAAICEMCAAAICEQCAAAICEUCAAAICEYCAAAICEcCAAAICEgCAAAICEkCAAAICEoCAAAICEsCAAAICEwCAAAICE0CAAAICE4CAAAICE8CAAAICFACAAAICFECAAAICFICAAAICFMCAAAICFQCAAAICFUCAAAICFYCAAAICFcCAAAICFgCAAAICFkCAAAICFoCAAAICFsCAAAICFwCAAAICF0CAAAICF4CAAAICF8CAAAICGACAAAICGECAAAICGICAAAICGMCAAAICGQCAAAICGUCAAAICGYCAAAICGcCAAAICGgCAAAICGkCAAAICGoCAAAICGsCAAAICGwCAAAICG0CAAAICG4CAAAICG8CAAAICHACAAAICHECAAAICHICAAAICHMCAAAICHQCAAAICHUCAAAICHYCAAAICHcCAAAICHgCAAAICHkCAAAICHoCAAAICHsCAAAICHwCAAAICH0CAAAICH4CAAAICH8CAAAICIACAAAICIECAAAICIICAAAICIMCAAAICIQCAAAICIUCAAAICIYCAAAICIcCAAAICIgCAAAICIkCAAAICIoCAAAICIsCAAAICIwCAAAICI0CAAAICI4CAAAICI8CAAAICJACAAAICJECAAAICJICAAAICJMCAAAICJQCAAAICJUCAAAICJYCAAAICJcCAAAICJgCAAAICJkCAAAICJoCAAAICJsCAAAICJwCAAAICJ0CAAAICJ4CAAAICJ8CAAAICKACAAAICKECAAAICKICAAAICKMCAAAICKQCAAAICKUCAAAICKYCAAAICKcCAAAICKgCAAAICKkCAAAICKoCAAAICKsCAAAICKwCAAAICK0CAAAICK4CAAAICK8CAAAICLACAAAICLECAAAICLICAAAICLMCAAAICLQCAAAICLUCAAAICLYCAAAICLcCAAAICLgCAAAICLkCAAAICLoCAAAICLsCAAAICLwCAAAICL0CAAAICL4CAAAICL8CAAAICMACAAAICMECAAAICMICAAAICMMCAAAICMQCAAAICMUCAAAICMYCAAAICMcCAAAICMgCAAAICMkCAAAICMoCAAAICMsCAAAICMwCAAAICM0CAAAICM4CAAAICM8CAAAICNACAAAICNECAAAICNICAAAICNMCAAAICNQCAAAICNUCAAAICNYCAAAICNcCAAAICNgCAAAICNkCAAAICNoCAAAICNsCAAAICNwCAAAICN0CAAAICN4CAAAICN8CAAAICOACAAAICOECAAAICOICAAAICOMCAAAICOQCAAAICOUCAAAICOYCAAAICOcCAAAICOgCAAAICOkCAAAICOoCAAAICOsCAAAICOwCAAAICO0CAAAICO4CAAAICO8CAAAICPACAAAICPECAAAICPICAAAICPMCAAAICPQCAAAICPUCAAAICPYCAAAICPcCAAAICPgCAAAICPkCAAAICPoCAAAICPsCAAAICPwCAAAICP0CAAAICP4CAAAICP8CAAAICAADAAAICAEDAAAICAIDAAAICAMDAAAICAQDAAAICAUDAAAICAYDAAAICAcDAAAICAgDAAAICAkDAAAICAoDAAAICAsDAAAICAwDAAAICA0DAAAICA4DAAAICA8DAAAICBADAAAICBEDAAAICBIDAAAICBMDAAAICBQDAAAICBUDAAAICBYDAAAICBcDAAAICBgDAAAICBkDAAAICBoDAAAICBsDAAAICBwDAAAICB0DAAAICB4DAAAICB8DAAAICCADAAAICCEDAAAICCIDAAAICCMDAAAICCQDAAAICCUDAAAICCYDAAAICCcDAAAICCgDAAAICCkDAAAICCoDAAAICCsDAAAICCwDAAAICC0DAAAICC4DAAAICC8DAAAICDADAAAICDEDAAAICDIDAAAICDMDAAAICDQDAAAICDUDAAAICDYDAAAICDcDAAAICDgDAAAICDkDAAAICDoDAAAICDsDAAAICDwDAAAICD0DAAAICD4DAAAICD8DAAAICEADAAAICEEDAAAICEIDAAAICEMDAAAICEQDAAAICEUDAAAICEYDAAAICEcDAAAICEgDAAAICEkDAAAICEoDAAAICEsDAAAICEwDAAAICE0DAAAICE4DAAAICE8DAAAICFADAAAICFEDAAAICFIDAAAICFMDAAAICFQDAAAICFUDAAAICFYDAAAICFcDAAAICFgDAAAICFkDAAAICFoDAAAICFsDAAAICFwDAAAICF0DAAAICF4DAAAICF8DAAAICGADAAAICGEDAAAICGIDAAAICGMDAAAICGQDAAAICGUDAAAICGYDAAAICGcDAAAICGgDAAAICGkDAAAICGoDAAAICGsDAAAICGwDAAAICG0DAAAICG4DAAAICG8DAAAICHADAAAICHEDAAAICHIDAAAICHMDAAAICHQDAAAICHUDAAAICHYDAAAICHcDAAAICHgDAAAICHkDAAAICHoDAAAICHsDAAAICHwDAAAICH0DAAAICH4DAAAICH8DAAAICIADAAAICIEDAAAICIIDAAAICIMDAAAICIQDAAAICIUDAAAICIYDAAAICIcDAAAICIgDAAAICIkDAAAICIoDAAAICIsDAAAICIwDAAAICI0DAAAICI4DAAAICI8DAAAICJADAAAICJEDAAAICJIDAAAICJMDAAAICJQDAAAICJUDAAAICJYDAAAICJcDAAAICJgDAAAICJkDAAAICJoDAAAICJsDAAAICJwDAAAICJ0DAAAICJ4DAAAICJ8DAAAICKADAAAICKEDAAAICKIDAAAICKMDAAAICKQDAAAICKUDAAAICKYDAAAICKcDAAAICKgDAAAICKkDAAAICKoDAAAICKsDAAAICKwDAAAICK0DAAAICK4DAAAICK8DAAAICLADAAAICLEDAAAICLIDAAAICLMDAAAICLQDAAAICLUDAAAICLYDAAAICLcDAAAICLgDAAAICLkDAAAICLoDAAAICLsDAAAICLwDAAAICL0DAAAICL4DAAAICL8DAAAICMADAAAICMEDAAAICMIDAAAICMMDAAAICMQDAAAICMUDAAAICMYDAAAICMcDAAAICMgDAAAICMkDAAAICMoDAAAICMsDAAAICMwDAAAICM0DAAAICM4DAAAICM8DAAAICNADAAAICNEDAAAICNIDAAAICNMDAAAICNQDAAAICNUDAAAICNYDAAAICNcDAAAICNgDAAAICNkDAAAICNoDAAAICNsDAAAICNwDAAAICN0DAAAICN4DAAAICN8DAAAICOADAAAICOEDAAAICOIDAAAICOMDAAAICOQDAAAICOUDAAAICOYDAAAICOcDAAAICOgDAAAICOkDAAAICOoDAAAICOsDAAAICOwDAAAICO0DAAAICO4DAAAICO8DAAAICPADAAAICPEDAAAICPIDAAAICPMDAAAICPQDAAAICPUDAAAICPYDAAAICPcDAAAICPgDAAAICPkDAAAICPoDAAAICPsDAAAICPwDAAAICP0DAAAICP4DAAAICP8DAAAICAAEAAAICAEEAAAICAIEAAAICAMEAAAICAQEAAAICAUEAAAICAYEAAAICAcEAAAICAgEAAAICAkEAAAICAoEAAAICAsEAAAICAwEAAAICA0EAAAICA4EAAAICA8EAAAICBAEAAAICBEEAAAICBIEAAAICBMEAAAICBQEAAAICBUEAAAICBYEAAAICBcEAAAICBgEAAAICBkEAAAICBoEAAAICBsEAAAICBwEAAAICB0EAAAICB4EAAAICB8EAAAICCAEAAAICCEEAAAICCIEAAAICCMEAAAICCQEAAAICCUEAAAICCYEAAAICCcEAAAICCgEAAAICCkEAAAICCoEAAAICCsEAAAICCwEAAAICC0EAAAICC4EAAAICC8EAAAICDAEAAAICDEEAAAICDIEAAAICDMEAAAICDQEAAAICDUEAAAICDYEAAAICDcEAAAICDgEAAAICDkEAAAICDoEAAAICDsEAAAICDwEAAAICD0EAAAICD4EAAAICD8EAAAICEAEAAAICEEEAAAICEIEAAAICEMEAAAICEQEAAAICEUEAAAICEYEAAAICEcEAAAICEgEAAAICEkEAAAICEoEAAAICEsEAAAICEwEAAAICE0EAAAICE4EAAAICE8EAAAICFAEAAAICFEEAAAICFIEAAAICFMEAAAICFQEAAAICFUEAAAICFYEAAAICFcEAAAICFgEAAAICFkEAAAICFoEAAAICFsEAAAICFwEAAAICF0EAAAICF4EAAAICF8EAAAICGAEAAAICGEEAAAICGIEAAAICGMEAAAICGQEAAAICGUEAAAICGYEAAAICGcEAAAICGgEAAAICGkEAAAICGoEAAAICGsEAAAICGwEAAAICG0EAAAICG4EAAAICG8EAAAICHAEAAAICHEEAAAICHIEAAAICHMEAAAICHQEAAAICHUEAAAICHYEAAAICHcEAAAICHgEAAAICHkEAAAICHoEAAAICHsEAAAICHwEAAAICH0EAAAICH4EAAAICH8EAAAICIAEAAAICIEEAAAICIIEAAAICIMEAAAICIQEAAAICIUEAAAICIYEAAAICIcEAAAICIgEAAAICIkEAAAICIoEAAAICIsEAAAICIwEAAAICI0EAAAICI4EAAAICI8EAAAICJAEAAAICJEEAAAICJIEAAAICJMEAAAICJQEAAAICJUEAAAICJYEAAAICJcEAAAICJgEAAAICJkEAAAICJoEAAAICJsEAAAICJwEAAAICJ0EAAAICJ4EAAAICJ8EAAAICKAEAAAICKEEAAAICKIEAAAICKMEAAAICKQEAAAICKUEAAAICKYEAAAICKcEAAAICKgEAAAICKkEAAAICKoEAAAICKsEAAAICKwEAAAICK0EAAAICK4EAAAICK8EAAAICLAEAAAICLEEAAAICLIEAAAICLMEAAAICLQEAAAICLUEAAAICLYEAAAICLcEAAAICLgEAAAICLkEAAAICLoEAAAICLsEAAAICLwEAAAICL0EAAAICL4EAAAICL8EAAAICMAEAAAICMEEAAAICMIEAAAICMMEAAAICMQEAAAICMUEAAAICMYEAAAICMcEAAAICMgEAAAICMkEAAAICMoEAAAICMsEAAAICMwEAAAICM0EAAAICM4EAAAICM8EAAAICNAEAAAICNEEAAAICNIEAAAICNMEAAAICNQEAAAICNUEAAAICNYEAAAICNcEAAAICNgEAAAICNkEAAAICNoEAAAICNsEAAAICNwEAAAICN0EAAAICN4EAAAICN8EAAAICOAEAAAICOEEAAAICOIEAAAICOMEAAAICOQEAAAICOUEAAAICOYEAAAICOcEAAAICOgEAAAICOkEAAAICOoEAAAICOsEAAAICOwEAAAICO0EAAAICO4EAAAICO8EAAAICPAEAAAICPEEAAAICPIEAAAICPMEAAAICPQEAAAICPUEAAAICPYEAAAICPcEAAAICPgEAAAICPkEAAAICPoEAAAICPsEAAAICPwEAAAICP0EAAAICP4EAAAICP8EAAAICAAFAAAICAEFAAAICAIFAAAICAMFAAAICAQFAAAICAUFAAAICAYFAAAICAcFAAAICAgFAAAICAkFAAAICAoFAAAICAsFAAAICAwFAAAICA0FAAAICA4FAAAICA8FAAAICBAFAAAICBEFAAAICBIFAAAICBMFAAAICBQFAAAICBUFAAAICBYFAAAICBcFAAAICBgFAAAICBkFAAAICBoFAAAICBsFAAAICBwFAAAICB0FAAAICB4FAAAICB8FAAAICCAFAAAICCEFAAAICCIFAAAICCMFAAAICCQFAAAICCUFAAAICCYFAAAICCcFAAAICCgFAAAICCkFAAAICCoFAAAICCsFAAAICCwFAAAICC0FAAAICC4FAAAICC8FAAAICDAFAAAICDEFAAAICDIFAAAICDMFAAAICDQFAAAICDUFAAAICDYFAAAICDcFAAAICDgFAAAICDkFAAAICDoFAAAICDsFAAAICDwFAAAICD0FAAAICD4FAAAICD8FAAAICEAFAAAICEEFAAAICEIFAAAICEMFAAAICEQFAAAICEUFAAAICEYFAAAICEcFAAAICEgFAAAICEkFAAAICEoFAAAICEsFAAAICEwFAAAICE0FAAAICE4FAAAICE8FAAAICFAFAAAICFEFAAAICFIFAAAICFMFAAAICFQFAAAICFUFAAAICFYFAAAICFcFAAAICFgFAAAICFkFAAAICFoFAAAICFsFAAAICFwFAAAICF0FAAAICF4FAAAICF8FAAAICGAFAAAICGEFAAAICGIFAAAICGMFAAAICGQFAAAICGUFAAAICGYFAAAICGcFAAAICGgFAAAICGkFAAAICGoFAAAICGsFAAAICGwFAAAICG0FAAAICG4FAAAICG8FAAAICHAFAAAICHEFAAAICHIFAAAICHMFAAAICHQFAAAICHUFAAAICHYFAAAICHcFAAAICHgFAAAICHkFAAAICHoFAAAICHsFAAAICHwFAAAICH0FAAAICH4FAAAICH8FAAAICIAFAAAICIEFAAAICIIFAAAICIMFAAAICIQFAAAICIUFAAAICIYFAAAICIcFAAAICIgFAAAICIkFAAAICIoFAAAICIsFAAAICIwFAAAICI0FAAAICI4FAAAICI8FAAAICJAFAAAICJEFAAAICJIFAAAICJMFAAAICJQFAAAICJUFAAAICJYFAAAICJcFAAAICJgFAAAICJkFAAAICJoFAAAICJsFAAAICJwFAAAICJ0FAAAICJ4FAAAICJ8FAAAICKAFAAAICKEFAAAICKIFAAAICKMFAAAICKQFAAAICKUFAAAICKYFAAAICKcFAAAICKgFAAAICKkFAAAICKoFAAAICKsFAAAICKwFAAAICK0FAAAICK4FAAAICK8FAAAICLAFAAAICLEFAAAICLIFAAAICLMFAAAICLQFAAAICLUFAAAICLYFAAAICLcFAAAICLgFAAAICLkFAAAICLoFAAAICLsFAAAICLwFAAAICL0FAAAICL4FAAAICL8FAAAICMAFAAAICMEFAAAICMIFAAAICMMFAAAICMQFAAAICMUFAAAICMYFAAAICMcFAAAICMgFAAAICMkFAAAICMoFAAAICMsFAAAICMwFAAAICM0FAAAICM4FAAAICM8FAAAICNAFAAAICNEFAAAICNIFAAAICNMFAAAICNQFAAAICNUFAAAICNYFAAAICNcFAAAICNgFAAAICNkFAAAICNoFAAAICNsFAAAICNwFAAAICN0FAAAICN4FAAAICN8FAAAICOAFAAAICOEFAAAICOIFAAAICOMFAAAICOQFAAAICOUFAAAICOYFAAAICOcFAAAICOgFAAAICOkFAAAICOoFAAAICOsFAAAICOwFAAAICO0FAAAICO4FAAAICO8FAAAICPAFAAAICPEFAAAICPIFAAAICPMFAAAICPQFAAAICPUFAAAICPYFAAAICPcFAAAICPgFAAAICPkFAAAICPoFAAAICPsFAAAICPwFAAAICP0FAAAICP4FAAAICP8FAAAICAAGAAAICAEGAAAICAIGAAAICAMGAAAICAQGAAAICAUGAAAICAYGAAAICAcGAAAICAgGAAAICAkGAAAICAoGAAAICAsGAAAICAwGAAAICA0GAAAICA4GAAAICA8GAAAICBAGAAAICBEGAAAICBIGAAAICBMGAAAICBQGAAAICBUGAAAICBYGAAAICBcGAAAICBgGAAAICBkGAAAICBoGAAAICBsGAAAICBwGAAAICB0GAAAICB4GAAAICB8GAAAICCAGAAAICCEGAAAICCIGAAAICCMGAAAICCQGAAAICCUGAAAICCYGAAAICCcGAAAICCgGAAAICCkGAAAICCoGAAAICCsGAAAICCwGAAAICC0GAAAICC4GAAAICC8GAAAICDAGAAAICDEGAAAICDIGAAAICDMGAAAICDQGAAAICDUGAAAICDYGAAAICDcGAAAICDgGAAAICDkGAAAICDoGAAAICDsGAAAICDwGAAAICD0GAAAICD4GAAAICD8GAAAICEAGAAAICEEGAAAICEIGAAAICEMGAAAICEQGAAAICEUGAAAICEYGAAAICEcGAAAICEgGAAAICEkGAAAICEoGAAAICEsGAAAICEwGAAAICE0GAAAICE4GAAAICE8GAAAICFAGAAAICFEGAAAICFIGAAAICFMGAAAICFQGAAAICFUGAAAICFYGAAAICFcGAAAICFgGAAAICFkGAAAICFoGAAAICFsGAAAICFwGAAAICF0GAAAICF4GAAAICF8GAAAICGAGAAAICGEGAAAICGIGAAAICGMGAAAICGQGAAAICGUGAAAICGYGAAAICGcGAAAICGgGAAAICGkGAAAICGoGAAAICGsGAAAICGwGAAAICG0GAAAICG4GAAAICG8GAAAICHAGAAAICHEGAAAICHIGAAAICHMGAAAICHQGAAAICHUGAAAICHYGAAAICHcGAAAICHgGAAAICHkGAAAICHoGAAAICHsGAAAICHwGAAAICH0GAAAICH4GAAAICH8GAAAICIAGAAAICIEGAAAICIIGAAAICIMGAAAICIQGAAAICIUGAAAICIYGAAAICIcGAAAICIgGAAAICIkGAAAICIoGAAAICIsGAAAICIwGAAAICI0GAAAICI4GAAAICI8GAAAICJAGAAAICJEGAAAICJIGAAAICJMGAAAICJQGAAAICJUGAAAICJYGAAAICJcGAAAICJgGAAAICJkGAAAICJoGAAAICJsGAAAICJwGAAAICJ0GAAAICJ4GAAAICJ8GAAAICKAGAAAICKEGAAAICKIGAAAICKMGAAAICKQGAAAICKUGAAAICKYGAAAICKcGAAAICKgGAAAICKkGAAAICKoGAAAICKsGAAAICKwGAAAICK0GAAAICK4GAAAICK8GAAAICLAGAAAICLEGAAAICLIGAAAICLMGAAAICLQGAAAICLUGAAAICLYGAAAICLcGAAAICLgGAAAICLkGAAAICLoGAAAICLsGAAAICLwGAAAICL0GAAAICL4GAAAICL8GAAAICMAGAAAICMEGAAAICMIGAAAICMMGAAAICMQGAAAICMUGAAAICMYGAAAICMcGAAAICMgGAAAICMkGAAAICMoGAAAICMsGAAAICMwGAAAICM0GAAAICM4GAAAICM8GAAAICNAGAAAICNEGAAAICNIGAAAICNMGAAAICNQGAAAICNUGAAAICNYGAAAICNcGAAAICNgGAAAICNkGAAAICNoGAAAICNsGAAAICNwGAAAICN0GAAAICN4GAAAICN8GAAAICOAGAAAICOEGAAAICOIGAAAICOMGAAAICOQGAAAICOUGAAAICOYGAAAICOcGAAAICOgGAAAICOkGAAAICOoGAAAICOsGAAAICOwGAAAICO0GAAAICO4GAAAICO8GAAAICPAGAAAICPEGAAAICPIGAAAICPMGAAAICPQGAAAICPUGAAAICPYGAAAICPcGAAAICPgGAAAICPkGAAAICPoGAAAICPsGAAAICPwGAAAICP0GAAAICP4GAAAICP8GAAAICAAHAAAICAEHAAAICAIHAAAICAMHAAAICAQHAAAICAUHAAAICAYHAAAICAcHAAAICAgHAAAICAkHAAAICAoHAAAICAsHAAAICAwHAAAICA0HAAAICA4HAAAICA8HAAAICBAHAAAICBEHAAAICBIHAAAICBMHAAAICBQHAAAICBUHAAAICBYHAAAICBcHAAAICBgHAAAICBkHAAAICBoHAAAICBsHAAAICBwHAAAICB0HAAAICB4HAAAICB8HAAAICCAHAAAICCEHAAAICCIHAAAICCMHAAAICCQHAAAICCUHAAAICCYHAAAICCcHAAAICCgHAAAICCkHAAAICCoHAAAICCsHAAAICCwHAAAICC0HAAAICC4HAAAICC8HAAAICDAHAAAICDEHAAAICDIHAAAICDMHAAAICDQHAAAICDUHAAAICDYHAAAICDcHAAAICDgHAAAICDkHAAAICDoHAAAICDsHAAAICDwHAAAICD0HAAAICD4HAAAICD8HAAAICEAHAAAICEEHAAAICEIHAAAICEMHAAAICEQHAAAICEUHAAAICEYHAAAICEcHAAAICEgHAAAICEkHAAAICEoHAAAICEsHAAAICEwHAAAICE0HAAAICE4HAAAICE8HAAAICFAHAAAICFEHAAAICFIHAAAICFMHAAAICFQHAAAICFUHAAAICFYHAAAICFcHAAAICFgHAAAICFkHAAAICFoHAAAICFsHAAAICFwHAAAICF0HAAAICF4HAAAICF8HAAAICGAHAAAICGEHAAAICGIHAAAICGMHAAAICGQHAAAICGUHAAAICGYHAAAICGcHAAAICGgHAAAICGkHAAAICGoHAAAICGsHAAAICGwHAAAICG0HAAAICG4HAAAICG8HAAAICHAHAAAICHEHAAAICHIHAAAICHMHAAAICHQHAAAICHUHAAAICHYHAAAICHcHAAAICHgHAAAICHkHAAAICHoHAAAICHsHAAAICHwHAAAICH0HAAAICH4HAAAICH8HAAAICIAHAAAICIEHAAAICIIHAAAICIMHAAAICIQHAAAICIUHAAAICIYHAAAICIcHAAAICIgHAAAICIkHAAAICIoHAAAICIsHAAAICIwHAAAICI0HAAAICI4HAAAICI8HAAAICJAHAAAICJEHAAAICJIHAAAICJMHAAAICJQHAAAICJUHAAAICJYHAAAICJcHAAAICJgHAAAICJkHAAAICJoHAAAICJsHAAAICJwHAAAICJ0HAAAICJ4HAAAICJ8HAAAICKAHAAAICKEHAAAICKIHAAAICKMHAAAICKQHAAAICKUHAAAICKYHAAAICKcHAAAICKgHAAAICKkHAAAICKoHAAAICKsHAAAICKwHAAAICK0HAAAICK4HAAAICK8HAAAICLAHAAAICLEHAAAICLIHAAAICLMHAAAICLQHAAAICLUHAAAICLYHAAAICLcHAAAICLgHAAAICLkHAAAICLoHAAAICLsHAAAICLwHAAAICL0HAAAICL4HAAAICL8HAAAICMAHAAAICMEHAAAICMIHAAAICMMHAAAICMQHAAAICMUHAAAICMYHAAAICMcHAAAICMgHAAAICMkHAAAICMoHAAAICMsHAAAICMwHAAAICM0HAAAICM4HAAAICM8HAAAICNAHAAAICNEHAAAICNIHAAAICNMHAAAICNQHAAAICNUHAAAICNYHAAAICNcHAAAICNgHAAAICNkHAAAICNoHAAAICNsHAAAICNwHAAAICN0HAAAICN4HAAAICN8HAAAICOAHAAAICOEHAAAICOIHAAAICOMHAAAICOQHAAAICOUHAAAICOYHAAAICOcHAAAICOgHAAAICOkHAAAICOoHAAAICOsHAAAICOwHAAAICO0HAAAICO4HAAAICO8HAAAICPAHAAAICPEHAAAICPIHAAAICPMHAAAICPQHAAAICPUHAAAICPYHAAAICPcHAAAICPgHAAAICPkHAAAICPoHAAAICPsHAAAICPwHAAAICP0HAAAICP4HAAAICP8HAAAICAAIAAAICAEIAAAICAIIAAAICAMIAAAICAQIAAAICAUIAAAICAYIAAAICAcIAAAICAgIAAAICAkIAAAICAoIAAAICAsIAAAICAwIAAAICA0IAAAICA4IAAAICA8IAAAICBAIAAAICBEIAAAICBIIAAAICBMIAAAICBQIAAAICBUIAAAICBYIAAAICBcIAAAICBgIAAAICBkIAAAICBoIAAAICBsIAAAICBwIAAAICB0IAAAICB4IAAAICB8IAAAICCAIAAAICCEIAAAICCIIAAAICCMIAAAICCQIAAAICCUIAAAICCYIAAAICCcIAAAICCgIAAAICCkIAAAICCoIAAAICCsIAAAICCwIAAAICC0IAAAICC4IAAAICC8IAAAICDAIAAAICDEIAAAICDIIAAAICDMIAAAICDQIAAAICDUIAAAICDYIAAAICDcIAAAICDgIAAAICDkIAAAICDoIAAAICDsIAAAICDwIAAAICD0IAAAICD4IAAAICD8IAAAICEAIAAAICEEIAAAICEIIAAAICEMIAAAICEQIAAAICEUIAAAICEYIAAAICEcIAAAICEgIAAAICEkIAAAICEoIAAAICEsIAAAICEwIAAAICE0IAAAICE4IAAAICE8IAAAICFAIAAAICFEIAAAICFIIAAAICFMIAAAICFQIAAAICFUIAAAICFYIAAAICFcIAAAICFgIAAAICFkIAAAICFoIAAAICFsIAAAICFwIAAAICF0IAAAICF4IAAAICF8IAAAICGAIAAAICGEIAAAICGIIAAAICGMIAAAICGQIAAAICGUIAAAICGYIAAAICGcIAAAICGgIAAAICGkIAAAICGoIAAAICGsIAAAICGwIAAAICG0IAAAICG4IAAAICG8IAAAICHAIAAAICHEIAAAICHIIAAAICHMIAAAICHQIAAAICHUIAAAICHYIAAAICHcIAAAICHgIAAAICHkIAAAICHoIAAAICHsIAAAICHwIAAAICH0IAAAICH4IAAAICH8IAAAICIAIAAAICIEIAAAICIIIAAAICIMIAAAICIQIAAAICIUIAAAICIYIAAAICIcIAAAICIgIAAAICIkIAAAICIoIAAAICIsIAAAICIwIAAAICI0IAAAICI4IAAAICI8IAAAICJAIAAAICJEIAAAICJIIAAAICJMIAAAICJQIAAAICJUIAAAICJYIAAAICJcIAAAICJgIAAAICJkIAAAICJoIAAAICJsIAAAICJwIAAAICJ0IAAAICJ4IAAAICJ8IAAAICKAIAAAICKEIAAAICKIIAAAICKMIAAAICKQIAAAICKUIAAAICKYIAAAICKcIAAAICKgIAAAICKkIAAAICKoIAAAICKsIAAAICKwIAAAICK0IAAAICK4IAAAICK8IAAAICLAIAAAICLEIAAAICLIIAAAICLMIAAAICLQIAAAICLUIAAAICLYIAAAICLcIAAAICLgIAAAICLkIAAAICLoIAAAICLsIAAAICLwIAAAICL0IAAAICL4IAAAICL8IAAAICMAIAAAICMEIAAAICMIIAAAICMMIAAAICMQIAAAICMUIAAAICMYIAAAICMcIAAAICMgIAAAICMkIAAAICMoIAAAICMsIAAAICMwIAAAICM0IAAAICM4IAAAICM8IAAAICNAIAAAICNEIAAAICNIIAAAICNMIAAAICNQIAAAICNUIAAAICNYIAAAICNcIAAAICNgIAAAICNkIAAAICNoIAAAICNsIAAAICNwIAAAICN0IAAAICN4IAAAICN8IAAAICOAIAAAICOEIAAAICOIIAAAICOMIAAAICOQIAAAICOUIAAAICOYIAAAICOcIAAAICOgIAAAICOkIAAAICOoIAAAICOsIAAAICOwIAAAICO0IAAAICO4IAAAICO8IAAAICPAIAAAICPEIAAAICPIIAAAICPMIAAAICPQIAAAICPUIAAAICPYIAAAICPcIAAAICPgIAAAICPkIAAAICPoIAAAICPsIAAAICPwIAAAICP0IAAAICP4IAAAICP8IAAAICAAJAAAICAEJAAAICAIJAAAICAMJAAAICAQJAAAICAUJAAAICAYJAAAICAcJAAAICAgJAAAICAkJAAAICAoJAAAICAsJAAAICAwJAAAICA0JAAAICA4JAAAICA8JAAAICBAJAAAICBEJAAAICBIJAAAICBMJAAAICBQJAAAICBUJAAAICBYJAAAICBcJAAAICBgJAAAICBkJAAAICBoJAAAICBsJAAAICBwJAAAICB0JAAAICB4JAAAICB8JAAAICCAJAAAICCEJAAAICCIJAAAICCMJAAAICCQJAAAICCUJAAAICCYJAAAICCcJAAAICCgJAAAICCkJAAAICCoJAAAICCsJAAAICCwJAAAICC0JAAAICC4JAAAICC8JAAAICDAJAAAICDEJAAAICDIJAAAICDMJAAAICDQJAAAICDUJAAAICDYJAAAICDcJAAAICDgJAAAICDkJAAAICDoJAAAICDsJAAAICDwJAAAICD0JAAAICD4JAAAICD8JAAAICEAJAAAICEEJAAAICEIJAAAICEMJAAAICEQJAAAICEUJAAAICEYJAAAICEcJAAAICEgJAAAICEkJAAAICEoJAAAICEsJAAAICEwJAAAICE0JAAAICE4JAAAICE8JAAAICFAJAAAICFEJAAAICFIJAAAICFMJAAAICFQJAAAICFUJAAAICFYJAAAICFcJAAAICFgJAAAICFkJAAAICFoJAAAICFsJAAAICFwJAAAICF0JAAAICF4JAAAICF8JAAAICGAJAAAICGEJAAAICGIJAAAICGMJAAAICGQJAAAICGUJAAAICGYJAAAICGcJAAAICGgJAAAICGkJAAAICGoJAAAICGsJAAAICGwJAAAICG0JAAAICG4JAAAICG8JAAAICHAJAAAICHEJAAAICHIJAAAICHMJAAAICHQJAAAICHUJAAAICHYJAAAICHcJAAAICHgJAAAICHkJAAAICHoJAAAICHsJAAAICHwJAAAICH0JAAAICH4JAAAICH8JAAAICIAJAAAICIEJAAAICIIJAAAICIMJAAAICIQJAAAICIUJAAAICIYJAAAICIcJAAAICIgJAAAICIkJAAAICIoJAAAICIsJAAAICIwJAAAICI0JAAAICI4JAAAICI8JAAAICJAJAAAICJEJAAAICJIJAAAICJMJAAAICJQJAAAICJUJAAAICJYJAAAICJcJAAAICJgJAAAICJkJAAAICJoJAAAICJsJAAAICJwJAAAICJ0JAAAICJ4JAAAICJ8JAAAICKAJAAAICKEJAAAICKIJAAAICKMJAAAICKQJAAAICKUJAAAICKYJAAAICKcJAAAICKgJAAAICKkJAAAICKoJAAAICKsJAAAICKwJAAAICK0JAAAICK4JAAAICK8JAAAICLAJAAAICLEJAAAICLIJAAAICLMJAAAICLQJAAAICLUJAAAICLYJAAAICLcJAAAICLgJAAAICLkJAAAICLoJAAAICLsJAAAICLwJAAAICL0JAAAICL4JAAAICL8JAAAICMAJAAAICMEJAAAICMIJAAAICMMJAAAICMQJAAAICMUJAAAICMYJAAAICMcJAAAICMgJAAAICMkJAAAICMoJAAAICMsJAAAICMwJAAAICM0JAAAICM4JAAAICM8JAAAICNAJAAAICNEJAAAICNIJAAAICNMJAAAICNQJAAAICNUJAAAICNYJAAAICNcJAAAICNgJAAAICNkJAAAICNoJAAAICNsJAAAICNwJAAAICN0JAAAICN4JAAAICN8JAAAICOAJAAAICOEJAAAICOIJAAAICOMJAAAICOQJAAAICOUJAAAICOYJAAAICOcJAAAICOgJAAAICOkJAAAICOoJAAAICOsJAAAICOwJAAAICO0JAAAICO4JAAAICO8JAAAICPAJAAAICPEJAAAICPIJAAAICPMJAAAICPQJAAAICPUJAAAICPYJAAAICPcJAAAICPgJAAAICPkJAAAICPoJAAAICPsJAAAICPwJAAAICP0JAAAICP4JAAAICP8JAAAICAAKAAAICAEKAAAICAIKAAAICAMKAAAICAQKAAAICAUKAAAICAYKAAAICAcKAAAICAgKAAAICAkKAAAICAoKAAAICAsKAAAICAwKAAAICA0KAAAICA4KAAAICA8KAAAICBAKAAAICBEKAAAICBIKAAAICBMKAAAICBQKAAAICBUKAAAICBYKAAAICBcKAAAICBgKAAAICBkKAAAICBoKAAAICBsKAAAICBwKAAAICB0KAAAICB4KAAAICB8KAAAICCAKAAAICCEKAAAICCIKAAAICCMKAAAICCQKAAAICCUKAAAICCYKAAAICCcKAAAICCgKAAAICCkKAAAICCoKAAAICCsKAAAICCwKAAAICC0KAAAICC4KAAAICC8KAAAICDAKAAAICDEKAAAICDIKAAAICDMKAAAICDQKAAAICDUKAAAICDYKAAAICDcKAAAICDgKAAAICDkKAAAICDoKAAAICDsKAAAICDwKAAAICD0KAAAICD4KAAAICD8KAAAICEAKAAAICEEKAAAICEIKAAAICEMKAAAICEQKAAAICEUKAAAICEYKAAAICEcKAAAICEgKAAAICEkKAAAICEoKAAAICEsKAAAICEwKAAAICE0KAAAICE4KAAAICE8KAAAICFAKAAAICFEKAAAICFIKAAAICFMKAAAICFQKAAAICFUKAAAICFYKAAAICFcKAAAICFgKAAAICFkKAAAICFoKAAAICFsKAAAICFwKAAAICF0KAAAICF4KAAAICF8KAAAICGAKAAAICGEKAAAICGIKAAAICGMKAAAICGQKAAAICGUKAAAICGYKAAAICGcKAAAICGgKAAAICGkKAAAICGoKAAAICGsKAAAICGwKAAAICG0KAAAICG4KAAAICG8KAAAICHAKAAAICHEKAAAICHIKAAAICHMKAAAICHQKAAAICHUKAAAICHYKAAAICHcKAAAICHgKAAAICHkKAAAICHoKAAAICHsKAAAICHwKAAAICH0KAAAICH4KAAAICH8KAAAICIAKAAAICIEKAAAICIIKAAAICIMKAAAICIQKAAAICIUKAAAICIYKAAAICIcKAAAICIgKAAAICIkKAAAICIoKAAAICIsKAAAICIwKAAAICI0KAAAICI4KAAAICI8KAAAICJAKAAAICJEKAAAICJIKAAAICJMKAAAICJQKAAAICJUKAAAICJYKAAAICJcKAAAICJgKAAAICJkKAAAICJoKAAAICJsKAAAICJwKAAAICJ0KAAAICJ4KAAAICJ8KAAAICKAKAAAICKEKAAAICKIKAAAICKMKAAAICKQKAAAICKUKAAAICKYKAAAICKcKAAAICKgKAAAICKkKAAAICKoKAAAICKsKAAAICKwKAAAICK0KAAAICK4KAAAICK8KAAAICLAKAAAICLEKAAAICLIKAAAICLMKAAAICLQKAAAICLUKAAAICLYKAAAICLcKAAAICLgKAAAICLkKAAAICLoKAAAICLsKAAAICLwKAAAICL0KAAAICL4KAAAICL8KAAAICMAKAAAICMEKAAAICMIKAAAICMMKAAAICMQKAAAICMUKAAAICMYKAAAICMcKAAAICMgKAAAICMkKAAAICMoKAAAICMsKAAAICMwKAAAICM0KAAAICM4KAAAICM8KAAAICNAKAAAICNEKAAAICNIKAAAICNMKAAAICNQKAAAICNUKAAAICNYKAAAICNcKAAAICNgKAAAICNkKAAAICNoKAAAICNsKAAAICNwKAAAICN0KAAAICN4KAAAICN8KAAAICOAKAAAICOEKAAAICOIKAAAICOMKAAAICOQKAAAICOUKAAAICOYKAAAICOcKAAAICOgKAAAICOkKAAAICOoKAAAICOsKAAAICOwKAAAICO0KAAAICO4KAAAICO8KAAAICPAKAAAICPEKAAAICPIKAAAICPMKAAAICPQKAAAICPUKAAAICPYKAAAICPcKAAAICPgKAAAICPkKAAAICPoKAAAICPsKAAAICPwKAAAICP0KAAAICP4KAAAICP8KAAAICAALAAAICAELAAAICAILAAAICAMLAAAICAQLAAAICAULAAAICAYLAAAICAcLAAAICAgLAAAICAkLAAAICAoLAAAICAsLAAAICAwLAAAICA0LAAAICA4LAAAICA8LAAAICBALAAAICBELAAAICBILAAAICBMLAAAICBQLAAAICBULAAAICBYLAAAICBcLAAAICBgLAAAICBkLAAAICBoLAAAICBsLAAAICBwLAAAICB0LAAAICB4LAAAICB8LAAAICCALAAAICCELAAAICCILAAAICCMLAAAICCQLAAAICCULAAAICCYLAAAICCcLAAAICCgLAAAICCkLAAAICCoLAAAICCsLAAAICCwLAAAICC0LAAAICC4LAAAICC8LAAAICDALAAAICDELAAAICDILAAAICDMLAAAICDQLAAAICDULAAAICDYLAAAICDcLAAAICDgLAAAICDkLAAAICDoLAAAICDsLAAAICDwLAAAICD0LAAAICD4LAAAICD8LAAAICEALAAAICEELAAAICEILAAAICEMLAAAICEQLAAAICEULAAAICEYLAAAICEcLAAAICEgLAAAICEkLAAAICEoLAAAICEsLAAAICEwLAAAICE0LAAAICE4LAAAICE8LAAAICFALAAAICFELAAAICFILAAAICFMLAAAICFQLAAAICFULAAAICFYLAAAICFcLAAAICFgLAAAICFkLAAAICFoLAAAICFsLAAAICFwLAAAICF0LAAAICF4LAAAICF8LAAAICGALAAAICGELAAAICGILAAAICGMLAAAICGQLAAAICGULAAAICGYLAAAICGcLAAAICGgLAAAICGkLAAAICGoLAAAICGsLAAAICGwLAAAICG0LAAAICG4LAAAICG8LAAAICHALAAAICHELAAAICHILAAAICHMLAAAICHQLAAAICHULAAAICHYLAAAICHcLAAAICHgLAAAICHkLAAAICHoLAAAICHsLAAAICHwLAAAICH0LAAAICH4LAAAICH8LAAAICIALAAAICIELAAAICIILAAAICIMLAAAICIQLAAAICIULAAAICIYLAAAICIcLAAAICIgLAAAICIkLAAAICIoLAAAICIsLAAAICIwLAAAICI0LAAAICI4LAAAICI8LAAAICJALAAAICJELAAAICJILAAAICJMLAAAICJQLAAAICJULAAAICJYLAAAICJcLAAAICJgLAAAICJkLAAAICJoLAAAICJsLAAAICJwLAAAICJ0LAAAICJ4LAAAICJ8LAAAICKALAAAICKELAAAICKILAAAICKMLAAAICKQLAAAICKULAAAICKYLAAAICKcLAAAICKgLAAAICKkLAAAICKoLAAAICKsLAAAICKwLAAAICK0LAAAICK4LAAAICK8LAAAICLALAAAICLELAAAICLILAAAICLMLAAAICLQLAAAICLULAAAICLYLAAAICLcLAAAICLgLAAAICLkLAAAICLoLAAAICLsLAAAICLwLAAAICL0LAAAICL4LAAAICL8LAAAICMALAAAICMELAAAICMILAAAICMMLAAAICMQLAAAICMULAAAICMYLAAAICMcLAAAICMgLAAAICMkLAAAICMoLAAAICMsLAAAICMwLAAAICM0LAAAICM4LAAAICM8LAAAICNALAAAICNELAAAICNILAAAICNMLAAAICNQLAAAICNULAAAICNYLAAAICNcLAAAICNgLAAAICNkLAAAICNoLAAAICNsLAAAICNwLAAAICN0LAAAICN4LAAAICN8LAAAICOALAAAICOELAAAICOILAAAICOMLAAAICOQLAAAICOULAAAICOYLAAAICOcLAAAICOgLAAAICOkLAAAICOoLAAAICOsLAAAICOwLAAAICO0LAAAICO4LAAAICO8LAAAICPALAAAICPELAAAICPILAAAICPMLAAAICPQLAAAICPULAAAICPYLAAAICPcLAAAICPgLAAAICPkLAAAICPoLAAAICPsLAAAICPwLAAAICP0LAAAICP4LAAAICP8LAAAICAAMAAAICAEMAAAICAIMAAAICAMMAAAICAQMAAAICAUMAAAICAYMAAAICAcMAAAICAgMAAAICAkMAAAICAoMAAAICAsMAAAICAwMAAAICA0MAAAICA4MAAAICA8MAAAICBAMAAAICBEMAAAICBIMAAAICBMMAAAICBQMAAAICBUMAAAICBYMAAAICBcMAAAICBgMAAAICBkMAAAICBoMAAAICBsMAAAICBwMAAAICB0MAAAICB4MAAAICB8MAAAICCAMAAAICCEMAAAICCIMAAAICCMMAAAICCQMAAAICCUMAAAICCYMAAAICCcMAAAICCgMAAAICCkMAAAICCoMAAAICCsMAAAICCwMAAAICC0MAAAICC4MAAAICC8MAAAICDAMAAAICDEMAAAICDIMAAAICDMMAAAICDQMAAAICDUMAAAICDYMAAAICDcMAAAICDgMAAAICDkMAAAICDoMAAAICDsMAAAICDwMAAAICD0MAAAICD4MAAAICD8MAAAICEAMAAAICEEMAAAICEIMAAAICEMMAAAICEQMAAAICEUMAAAICEYMAAAICEcMAAAICEgMAAAICEkMAAAICEoMAAAICEsMAAAICEwMAAAICE0MAAAICE4MAAAICE8MAAAICFAMAAAICFEMAAAICFIMAAAICFMMAAAICFQMAAAICFUMAAAICFYMAAAICFcMAAAICFgMAAAICFkMAAAICFoMAAAICFsMAAAICFwMAAAICF0MAAAICF4MAAAICF8MAAAICGAMAAAICGEMAAAICGIMAAAICGMMAAAICGQMAAAICGUMAAAICGYMAAAICGcMAAAICGgMAAAICGkMAAAICGoMAAAICGsMAAAICGwMAAAICG0MAAAICG4MAAAICG8MAAAICHAMAAAICHEMAAAICHIMAAAICHMMAAAICHQMAAAICHUMAAAICHYMAAAICHcMAAAICHgMAAAICHkMAAAICHoMAAAICHsMAAAICHwMAAAICH0MAAAICH4MAAAICH8MAAAICIAMAAAICIEMAAAICIIMAAAICIMMAAAICIQMAAAICIUMAAAICIYMAAAICIcMAAAICIgMAAAICIkMAAAICIoMAAAICIsMAAAICIwMAAAICI0MAAAICI4MAAAICI8MAAAICJAMAAAICJEMAAAICJIMAAAICJMMAAAICJQMAAAICJUMAAAICJYMAAAICJcMAAAICJgMAAAICJkMAAAICJoMAAAICJsMAAAICJwMAAAICJ0MAAAICJ4MAAAICJ8MAAAICKAMAAAICKEMAAAICKIMAAAICKMMAAAICKQMAAAICKUMAAAICKYMAAAICKcMAAAICKgMAAAICKkMAAAICKoMAAAICKsMAAAICKwMAAAICK0MAAAICK4MAAAICK8MAAAICLAMAAAICLEMAAAICLIMAAAICLMMAAAICLQMAAAICLUMAAAICLYMAAAICLcMAAAICLgMAAAICLkMAAAICLoMAAAICLsMAAAICLwMAAAICL0MAAAICL4MAAAICL8MAAAICMAMAAAICMEMAAAICMIMAAAICMMMAAAICMQMAAAICMUMAAAICMYMAAAICMcMAAAICMgMAAAICMkMAAAICMoMAAAICMsMAAAICMwMAAAICM0MAAAICM4MAAAICM8MAAAICNAMAAAICNEMAAAICNIMAAAICNMMAAAICNQMAAAICNUMAAAICNYMAAAICNcMAAAICNgMAAAICNkMAAAICNoMAAAICNsMAAAICNwMAAAICN0MAAAICN4MAAAICN8MAAAICOAMAAAICOEMAAAICOIMAAAICOMMAAAICOQMAAAICOUMAAAICOYMAAAICOcMAAAICOgMAAAICOkMAAAICOoMAAAICOsMAAAICOwMAAAICO0MAAAICO4MAAAICO8MAAAICPAMAAAICPEMAAAICPIMAAAICPMMAAAICPQMAAAICPUMAAAICPYMAAAICPcMAAAICPgMAAAICPkMAAAICPoMAAAICPsMAAAICPwMAAAICP0MAAAICP4MAAAICP8MAAAICAANAAAICAENAAAICAINAAAICAMNAAAICAQNAAAICAUNAAAICAYNAAAICAcNAAAICAgNAAAICAkNAAAICAoNAAAICAsNAAAICAwNAAAICA0NAAAICA4NAAAICA8NAAAICBANAAAICBENAAAICBINAAAICBMNAAAICBQNAAAICBUNAAAICBYNAAAICBcNAAAICBgNAAAICBkNAAAICBoNAAAICBsNAAAICBwNAAAICB0NAAAICB4NAAAICB8NAAAICCANAAAICCENAAAICCINAAAICCMNAAAICCQNAAAICCUNAAAICCYNAAAICCcNAAAICCgNAAAICCkNAAAICCoNAAAICCsNAAAICCwNAAAICC0NAAAICC4NAAAICC8NAAAICDANAAAICDENAAAICDINAAAICDMNAAAICDQNAAAICDUNAAAICDYNAAAICDcNAAAICDgNAAAICDkNAAAICDoNAAAICDsNAAAICDwNAAAICD0NAAAICD4NAAAICD8NAAAICEANAAAICEENAAAICEINAAAICEMNAAAICEQNAAAICEUNAAAICEYNAAAICEcNAAAICEgNAAAICEkNAAAICEoNAAAICEsNAAAICEwNAAAICE0NAAAICE4NAAAICE8NAAAICFANAAAICFENAAAICFINAAAICFMNAAAICFQNAAAICFUNAAAICFYNAAAICFcNAAAICFgNAAAICFkNAAAICFoNAAAICFsNAAAICFwNAAAICF0NAAAICF4NAAAICF8NAAAICGANAAAICGENAAAICGINAAAICGMNAAAICGQNAAAICGUNAAAICGYNAAAICGcNAAAICGgNAAAICGkNAAAICGoNAAAICGsNAAAICGwNAAAICG0NAAAICG4NAAAICG8NAAAICHANAAAICHENAAAICHINAAAICHMNAAAICHQNAAAICHUNAAAICHYNAAAICHcNAAAICHgNAAAICHkNAAAICHoNAAAICHsNAAAICHwNAAAICH0NAAAICH4NAAAICH8NAAAICIANAAAICIENAAAICIINAAAICIMNAAAICIQNAAAICIUNAAAICIYNAAAICIcNAAAICIgNAAAICIkNAAAICIoNAAAICIsNAAAICIwNAAAICI0NAAAICI4NAAAICI8NAAAICJANAAAICJENAAAICJINAAAICJMNAAAICJQNAAAICJUNAAAICJYNAAAICJcNAAAICJgNAAAICJkNAAAICJoNAAAICJsNAAAICJwNAAAICJ0NAAAICJ4NAAAICJ8NAAAICKANAAAICKENAAAICKINAAAICKMNAAAICKQNAAAICKUNAAAICKYNAAAICKcNAAAICKgNAAAICKkNAAAICKoNAAAICKsNAAAICKwNAAAICK0NAAAICK4NAAAICK8NAAAICLANAAAICLENAAAICLINAAAICLMNAAAICLQNAAAICLUNAAAICLYNAAAICLcNAAAICLgNAAAICLkNAAAICLoNAAAICLsNAAAICLwNAAAICL0NAAAICL4NAAAICL8NAAAICMANAAAICMENAAAICMINAAAICMMNAAAICMQNAAAICMUNAAAICMYNAAAICMcNAAAICMgNAAAICMkNAAAICMoNAAAICMsNAAAICMwNAAAICM0NAAAICM4NAAAICM8NAAAICNANAAAICNENAAAICNINAAAICNMNAAAICNQNAAAICNUNAAAICNYNAAAICNcNAAAICNgNAAAICNkNAAAICNoNAAAICNsNAAAICNwNAAAICN0NAAAICN4NAAAICN8NAAAICOANAAAICOENAAAICOINAAAICOMNAAAICOQNAAAICOUNAAAICOYNAAAICOcNAAAICOgNAAAICOkNAAAICOoNAAAICOsNAAAICOwNAAAICO0NAAAICO4NAAAICO8NAAAICPANAAAICPENAAAICPINAAAICPMNAAAICPQNAAAICPUNAAAICPYNAAAICPcNAAAICPgNAAAICPkNAAAICPoNAAAICPsNAAAICPwNAAAICP0NAAAICP4NAAAICP8NAAAICAAOAAAICAEOAAAICAIOAAAICAMOAAAICAQOAAAICAUOAAAICAYOAAAICAcOAAAICAgOAAAICAkOAAAICAoOAAAICAsOAAAICAwOAAAICA0OAAAICA4OAAAICA8OAAAICBAOAAAICBEOAAAICBIOAAAICBMOAAAICBQOAAAICBUOAAAICBYOAAAICBcOAAAICBgOAAAICBkOAAAICBoOAAAICBsOAAAICBwOAAAICB0OAAAICB4OAAAICB8OAAAICCAOAAAICCEOAAAICCIOAAAICCMOAAAICCQOAAAICCUOAAAICCYOAAAICCcOAAAICCgOAAAICCkOAAAICCoOAAAICCsOAAAICCwOAAAICC0OAAAICC4OAAAICC8OAAAICDAOAAAICDEOAAAICDIOAAAICDMOAAAICDQOAAAICDUOAAAICDYOAAAICDcOAAAICDgOAAAICDkOAAAICDoOAAAICDsOAAAICDwOAAAICD0OAAAICD4OAAAICD8OAAAICEAOAAAICEEOAAAICEIOAAAICEMOAAAICEQOAAAICEUOAAAICEYOAAAICEcOAAAICEgOAAAICEkOAAAICEoOAAAICEsOAAAICEwOAAAICE0OAAAICE4OAAAICE8OAAAICFAOAAAICFEOAAAICFIOAAAICFMOAAAICFQOAAAICFUOAAAICFYOAAAICFcOAAAICFgOAAAICFkOAAAICFoOAAAICFsOAAAICFwOAAAICF0OAAAICF4OAAAICF8OAAAICGAOAAAICGEOAAAICGIOAAAICGMOAAAICGQOAAAICGUOAAAICGYOAAAICGcOAAAICGgOAAAICGkOAAAICGoOAAAICGsOAAAICGwOAAAICG0OAAAICG4OAAAICG8OAAAICHAOAAAICHEOAAAICHIOAAAICHMOAAAICHQOAAAICHUOAAAICHYOAAAICHcOAAAICHgOAAAICHkOAAAICHoOAAAICHsOAAAICHwOAAAICH0OAAAICH4OAAAICH8OAAAICIAOAAAICIEOAAAICIIOAAAICIMOAAAICIQOAAAICIUOAAAICIYOAAAICIcOAAAICIgOAAAICIkOAAAICIoOAAAICIsOAAAICIwOAAAICI0OAAAICI4OAAAICI8OAAAICJAOAAAICJEOAAAICJIOAAAICJMOAAAICJQOAAAICJUOAAAICJYOAAAICJcOAAAICJgOAAAICJkOAAAICJoOAAAICJsOAAAICJwOAAAICJ0OAAAICJ4OAAAICJ8OAAAICKAOAAAICKEOAAAICKIOAAAICKMOAAAICKQOAAAICKUOAAAICKYOAAAICKcOAAAICKgOAAAICKkOAAAICKoOAAAICKsOAAAICKwOAAAICK0OAAAICK4OAAAICK8OAAAICLAOAAAICLEOAAAICLIOAAAICLMOAAAICLQOAAAICLUOAAAICLYOAAAICLcOAAAICLgOAAAICLkOAAAICLoOAAAICLsOAAAICLwOAAAICL0OAAAICL4OAAAICL8OAAAICMAOAAAICMEOAAAICMIOAAAICMMOAAAICMQOAAAICMUOAAAICMYOAAAICMcOAAAICMgOAAAICMkOAAAICMoOAAAICMsOAAAICMwOAAAICM0OAAAICM4OAAAICM8OAAAICNAOAAAICNEOAAAICNIOAAAICNMOAAAICNQOAAAICNUOAAAICNYOAAAICNcOAAAICNgOAAAICNkOAAAICNoOAAAICNsOAAAICNwOAAAICN0OAAAICN4OAAAICN8OAAAICOAOAAAICOEOAAAICOIOAAAICOMOAAAICOQOAAAICOUOAAAICOYOAAAICOcOAAAICOgOAAAICOkOAAAICOoOAAAICOsOAAAICOwOAAAICO0OAAAICO4OAAAICO8OAAAICPAOAAAICPEOAAAICPIOAAAICPMOAAAICPQOAAAICPUOAAAICPYOAAAICPcOAAAICPgOAAAICPkOAAAICPoOAAAICPsOAAAICPwOAAAICP0OAAAICP4OAAAICP8OAAAICAAPAAAICAEPAAAICAIPAAAICAMPAAAICAQPAAAICAUPAAAICAYPAAAICAcPAAAICAgPAAAICAkPAAAICAoPAAAICAsPAAAICAwPAAAICA0PAAAICA4PAAAICA8PAAAICBAPAAAICBEPAAAICBIPAAAICBMPAAAICBQPAAAICBUPAAAICBYPAAAICBcPAAAICBgPAAAICBkPAAAICBoPAAAICBsPAAAICBwPAAAICB0PAAAICB4PAAAICB8PAAAICCAPAAAICCEPAAAICCIPAAAICCMPAAAICCQPAAAICCUPAAAICCYPAAAICCcPAAAICCgPAAAICCkPAAAICCoPAAAICCsPAAAICCwPAAAICC0PAAAICC4PAAAICC8PAAAICDAPAAAICDEPAAAICDIPAAAICDMPAAAICDQPAAAICDUPAAAICDYPAAAICDcPAAAICDgPAAAICDkPAAAICDoPAAAICDsPAAAICDwPAAAICD0PAAAICD4PAAAICD8PAAAICEAPAAAICEEPAAAICEIPAAAICEMPAAAICEQPAAAICEUPAAAICEYPAAAICEcPAAAICEgPAAAICEkPAAAICEoPAAAICEsPAAAICEwPAAAICE0PAAAICE4PAAAICE8PAAAICFAPAAAICFEPAAAICFIPAAAICFMPAAAICFQPAAAICFUPAAAICFYPAAAICFcPAAAICFgPAAAICFkPAAAICFoPAAAICFsPAAAICFwPAAAICF0PAAAICF4PAAAICF8PAAAICGAPAAAICGEPAAAICGIPAAAICGMPAAAICGQPAAAICGUPAAAICGYPAAAICGcPAAAICGgPAAAICGkPAAAICGoPAAAICGsPAAAICGwPAAAICG0PAAAICG4PAAAICG8PAAAICHAPAAAICHEPAAAICHIPAAAICHMPAAAICHQPAAAICHUPAAAICHYPAAAICHcPAAAICHgPAAAICHkPAAAICHoPAAAICHsPAAAICHwPAAAICH0PAAAICH4PAAAICH8PAAAICIAPAAAICIEPAAAICIIPAAAICIMPAAAICIQPAAAICIUPAAAICIYPAAAICIcPAAAICIgPAAAICIkPAAAICIoPAAAICIsPAAAICIwPAAAICI0PAAAICI4PAAAICI8PAAAICJAPAAAICJEPAAAICJIPAAAICJMPAAAICJQPAAAICJUPAAAICJYPAAAICJcPAAAICJgPAAAICJkPAAAICJoPAAAICJsPAAAICJwPAAAICJ0PAAAICJ4PAAAICJ8PAAAICKAPAAAICKEPAAAICKIPAAAICKMPAAAICKQPAAAICKUPAAAICKYPAAAICKcPAAAICKgPAAAICKkPAAAICKoPAAAICKsPAAAICKwPAAAICK0PAAAICK4PAAAICK8PAAAICLAPAAAICLEPAAAICLIPAAAICLMPAAAICLQPAAAICLUPAAAICLYPAAAICLcPAAAICLgPAAAICLkPAAAICLoPAAAICLsPAAAICLwPAAAICL0PAAAICL4PAAAICL8PAAAICMAPAAAICMEPAAAICMIPAAAICMMPAAAICMQPAAAICMUPAAAICMYPAAAICMcPAAAICMgPAAAICMkPAAAICMoPAAAICMsPAAAICMwPAAAICM0PAAAICM4PAAAICM8PAAAICNAPAAAICNEPAAAICNIPAAAICNMPAAAICNQPAAAICNUPAAAICNYPAAAICNcPAAAICNgPAAAICNkPAAAICNoPAAAICNsPAAAICNwPAAAICN0PAAAICN4PAAAICN8PAAAICOAPAAAICOEPAAAICOIPAAAICOMPAAAICOQPAAAICOUPAAAICOYPAAAICOcPAAAICOgPAAAICOkPAAAICOoPAAAICOsPAAAICOwPAAAICO0PAAAICO4PAAAICO8PAAAICPAPAAAICPEPAAAICPIPAAAICPMPAAAICPQPAAAICPUPAAAICPYPAAAICPcPAAAICPgPAAAICPkPAAAICPoPAAAICPsPAAAICPwPAAAICP0PAAAICP4PAAAICP8PAAAICAAQAAAICAEQAAAICAIQAAAICAMQAAAICAQQAAAICAUQAAAICAYQAAAICAcQAAAICAgQAAAICAkQAAAICAoQAAAICAsQAAAICAwQAAAICA0QAAAICA4QAAAICA8QAAAICBAQAAAICBEQAAAICBIQAAAICBMQAAAICBQQAAAICBUQAAAICBYQAAAICBcQAAAICBgQAAAICBkQAAAICBoQAAAICBsQAAAICBwQAAAICB0QAAAICB4QAAAICB8QAAAICCAQAAAICCEQAAAICCIQAAAICCMQAAAICCQQAAAICCUQAAAICCYQAAAICCcQAAAICCgQAAAICCkQAAAICCoQAAAICCsQAAAICCwQAAAICC0QAAAICC4QAAAICC8QAAAICDAQAAAICDEQAAAICDIQAAAICDMQAAAICDQQAAAICDUQAAAICDYQAAAICDcQAAAICDgQAAAICDkQAAAICDoQAAAICDsQAAAICDwQAAAICD0QAAAICD4QAAAICD8QAAAICEAQAAAICEEQAAAICEIQAAAICEMQAAAICEQQAAAICEUQAAAICEYQAAAICEcQAAAICEgQAAAICEkQAAAICEoQAAAICEsQAAAICEwQAAAICE0QAAAICE4QAAAICE8QAAAICFAQAAAICFEQAAAICFIQAAAICFMQAAAICFQQAAAICFUQAAAICFYQAAAICFcQAAAICFgQAAAICFkQAAAICFoQAAAICFsQAAAICFwQAAAICF0QAAAICF4QAAAICF8QAAAICGAQAAAICGEQAAAICGIQAAAICGMQAAAICGQQAAAICGUQAAAICGYQAAAICGcQAAAICGgQAAAICGkQAAAICGoQAAAICGsQAAAICGwQAAAICG0QAAAICG4QAAAICG8QAAAICHAQAAAICHEQAAAICHIQAAAICHMQAAAICHQQAAAICHUQAAAICHYQAAAICHcQAAAICHgQAAAICHkQAAAICHoQAAAICHsQAAAICHwQAAAICH0QAAAICH4QAAAICH8QAAAICIAQAAAICIEQAAAICIIQAAAICIMQAAAICIQQAAAICIUQAAAICIYQAAAICIcQAAAICIgQAAAICIkQAAAICIoQAAAICIsQAAAICIwQAAAICI0QAAAICI4QAAAICI8QAAAICJAQAAAICJEQAAAICJIQAAAICJMQAAAICJQQAAAICJUQAAAICJYQAAAICJcQAAAICJgQAAAICJkQAAAICJoQAAAICJsQAAAICJwQAAAICJ0QAAAICJ4QAAAICJ8QAAAICKAQAAAICKEQAAAICKIQAAAICKMQAAAICKQQAAAICKUQAAAICKYQAAAICKcQAAAICKgQAAAICKkQAAAICKoQAAAICKsQAAAICKwQAAAICK0QAAAICK4QAAAICK8QAAAICLAQAAAICLEQAAAICLIQAAAICLMQAAAICLQQAAAICLUQAAAICLYQAAAICLcQAAAICLgQAAAICLkQAAAICLoQAAAICLsQAAAICLwQAAAICL0QAAAICL4QAAAICL8QAAAICMAQAAAICMEQAAAICMIQAAAICMMQAAAICMQQAAAICMUQAAAICMYQAAAICMcQAAAICMgQAAAICMkQAAAICMoQAAAICMsQAAAICMwQAAAICM0QAAAICM4QAAAICM8QAAAICNAQAAAICNEQAAAICNIQAAAICNMQAAAICNQQAAAICNUQAAAICNYQAAAICNcQAAAICNgQAAAICNkQAAAICNoQAAAICNsQAAAICNwQAAAICN0QAAAICN4QAAAICN8QAAAICOAQAAAICOEQAAAICOIQAAAICOMQAAAICOQQAAAICOUQAAAICOYQAAAICOcQAAAICOgQAAAICOkQAAAICOoQAAAICOsQAAAICOwQAAAICO0QAAAICO4QAAAICO8QAAAICPAQAAAICPEQAAAICPIQAAAICPMQAAAICPQQAAAICPUQAAAICPYQAAAICPcQAAAICPgQAAAICPkQAAAICPoQAAAICPsQAAAICPwQAAAICP0QAAAICP4QAAAICP8QAAAICAARAAAICAERAAAICAIRAAAICAMRAAAICAQRAAAICAURAAAICAYRAAAICAcRAAAICAgRAAAICAkRAAAICAoRAAAICAsRAAAICAwRAAAICA0RAAAICA4RAAAICA8RAAAICBARAAAICBERAAAICBIRAAAICBMRAAAICBQRAAAICBURAAAICBYRAAAICBcRAAAICBgRAAAICBkRAAAICBoRAAAICBsRAAAICBwRAAAICB0RAAAICB4RAAAICB8RAAAICCARAAAICCERAAAICCIRAAAICCMRAAAICCQRAAAICCURAAAICCYRAAAICCcRAAAICCgRAAAICCkRAAAICCoRAAAICCsRAAAICCwRAAAICC0RAAAICC4RAAAICC8RAAAICDARAAAICDERAAAICDIRAAAICDMRAAAICDQRAAAICDURAAAICDYRAAAICDcRAAAICDgRAAAICDkRAAAICDoRAAAICDsRAAAICDwRAAAICD0RAAAICD4RAAAICD8RAAAICEARAAAICEERAAAICEIRAAAICEMRAAAICEQRAAAICEURAAAICEYRAAAICEcRAAAICEgRAAAICEkRAAAICEoRAAAICEsRAAAICEwRAAAICE0RAAAICE4RAAAICE8RAAAICFARAAAICFERAAAICFIRAAAICFMRAAAICFQRAAAICFURAAAICFYRAAAICFcRAAAICFgRAAAICFkRAAAICFoRAAAICFsRAAAICFwRAAAICF0RAAAICF4RAAAICF8RAAAICGARAAAICGERAAAICGIRAAAICGMRAAAICGQRAAAICGURAAAICGYRAAAICGcRAAAICGgRAAAICGkRAAAICGoRAAAICGsRAAAICGwRAAAICG0RAAAICG4RAAAICG8RAAAICHARAAAICHERAAAICHIRAAAICHMRAAAICHQRAAAICHURAAAICHYRAAAICHcRAAAICHgRAAAICHkRAAAICHoRAAAICHsRAAAICHwRAAAICH0RAAAICH4RAAAICH8RAAAICIARAAAICIERAAAICIIRAAAICIMRAAAICIQRAAAICIURAAAICIYRAAAICIcRAAAICIgRAAAICIkRAAAICIoRAAAICIsRAAAICIwRAAAICI0RAAAICI4RAAAICI8RAAAICJARAAAICJERAAAICJIRAAAICJMRAAAICJQRAAAICJURAAAICJYRAAAICJcRAAAICJgRAAAICJkRAAAICJoRAAAICJsRAAAICJwRAAAICJ0RAAAICJ4RAAAICJ8RAAAICKARAAAICKERAAAICKIRAAAICKMRAAAICKQRAAAICKURAAAICKYRAAAICKcRAAAICKgRAAAICKkRAAAICKoRAAAICKsRAAAICKwRAAAICK0RAAAICK4RAAAICK8RAAAICLARAAAICLERAAAICLIRAAAICLMRAAAICLQRAAAICLURAAAICLYRAAAICLcRAAAICLgRAAAICLkRAAAICLoRAAAICLsRAAAICLwRAAAICL0RAAAICL4RAAAICL8RAAAICMARAAAICMERAAAICMIRAAAICMMRAAAICMQRAAAICMURAAAICMYRAAAICMcRAAAICMgRAAAICMkRAAAICMoRAAAICMsRAAAICMwRAAAICM0RAAAICM4RAAAICM8RAAAICNARAAAICNERAAAICNIRAAAICNMRAAAICNQRAAAICNURAAAICNYRAAAICNcRAAAICNgRAAAICNkRAAAICNoRAAAICNsRAAAICNwRAAAICN0RAAAICN4RAAAICN8RAAAICOARAAAICOERAAAICOIRAAAICOMRAAAICOQRAAAICOURAAAICOYRAAAICOcRAAAICOgRAAAICOkRAAAICOoRAAAICOsRAAAICOwRAAAICO0RAAAICO4RAAAICO8RAAAICPARAAAICPERAAAICPIRAAAICPMRAAAICPQRAAAICPURAAAICPYRAAAICPcRAAAICPgRAAAICPkRAAAICPoRAAAICPsRAAAICPwRAAAICP0RAAAICP4RAAAICP8RAAAICAASAAAICAESAAAICAISAAAICAMSAAAICAQSAAAICAUSAAAICAYSAAAICAcSAAAICAgSAAAICAkSAAAICAoSAAAICAsSAAAICAwSAAAICA0SAAAICA4SAAAICA8SAAAICBASAAAICBESAAAICBISAAAICBMSAAAICBQSAAAICBUSAAAICBYSAAAICBcSAAAICBgSAAAICBkSAAAICBoSAAAICBsSAAAICBwSAAAICB0SAAAICB4SAAAICB8SAAAICCASAAAICCESAAAICCISAAAICCMSAAAICCQSAAAICCUSAAAICCYSAAAICCcSAAAICCgSAAAICCkSAAAICCoSAAAICCsSAAAICCwSAAAICC0SAAAICC4SAAAICC8SAAAICDASAAAICDESAAAICDISAAAICDMSAAAICDQSAAAICDUSAAAICDYSAAAICDcSAAAICDgSAAAICDkSAAAICDoSAAAICDsSAAAICDwSAAAICD0SAAAICD4SAAAICD8SAAAICEASAAAICEESAAAICEISAAAICEMSAAAICEQSAAAICEUSAAAICEYSAAAICEcSAAAICEgSAAAICEkSAAAICEoSAAAICEsSAAAICEwSAAAICE0SAAAICE4SAAAICE8SAAAICFASAAAICFESAAAICFISAAAICFMSAAAICFQSAAAICFUSAAAICFYSAAAICFcSAAAICFgSAAAICFkSAAAICFoSAAAICFsSAAAICFwSAAAICF0SAAAICF4SAAAICF8SAAAICGASAAAICGESAAAICGISAAAICGMSAAAICGQSAAAICGUSAAAICGYSAAAICGcSAAAICGgSAAAICGkSAAAICGoSAAAICGsSAAAICGwSAAAICG0SAAAICG4SAAAICG8SAAAICHASAAAICHESAAAICHISAAAICHMSAAAICHQSAAAICHUSAAAICHYSAAAICHcSAAAICHgSAAAICHkSAAAICHoSAAAICHsSAAAICHwSAAAICH0SAAAICH4SAAAICH8SAAAICIASAAAICIESAAAICIISAAAICIMSAAAICIQSAAAICIUSAAAICIYSAAAICIcSAAAICIgSAAAICIkSAAAICIoSAAAICIsSAAAICIwSAAAICI0SAAAICI4SAAAICI8SAAAICJASAAAICJESAAAICJISAAAICJMSAAAICJQSAAAICJUSAAAICJYSAAAICJcSAAAICJgSAAAICJkSAAAICJoSAAAICJsSAAAICJwSAAAICJ0SAAAICJ4SAAAICJ8SAAAICKASAAAICKESAAAICKISAAAICKMSAAAICKQSAAAICKUSAAAICKYSAAAICKcSAAAICKgSAAAICKkSAAAICKoSAAAICKsSAAAICKwSAAAICK0SAAAICK4SAAAICK8SAAAICLASAAAICLESAAAICLISAAAICLMSAAAICLQSAAAICLUSAAAICLYSAAAICLcSAAAICLgSAAAICLkSAAAICLoSAAAICLsSAAAICLwSAAAICL0SAAAICL4SAAAICL8SAAAICMASAAAICMESAAAICMISAAAICMMSAAAICMQSAAAICMUSAAAICMYSAAAICMcSAAAICMgSAAAICMkSAAAICMoSAAAICMsSAAAICMwSAAAICM0SAAAICM4SAAAICM8SAAAICNASAAAICNESAAAICNISAAAICNMSAAAICNQSAAAICNUSAAAICNYSAAAICNcSAAAICNgSAAAICNkSAAAICNoSAAAICNsSAAAICNwSAAAICN0SAAAICN4SAAAICN8SAAAICOASAAAICOESAAAICOISAAAICOMSAAAICOQSAAAICOUSAAAICOYSAAAICOcSAAAICOgSAAAICOkSAAAICOoSAAAICOsSAAAICOwSAAAICO0SAAAICO4SAAAICO8SAAAICPASAAAICPESAAAICPISAAAICPMSAAAICPQSAAAICPUSAAAICPYSAAAICPcSAAAICPgSAAAICPkSAAAICPoSAAAICPsSAAAICPwSAAAICP0SAAAICP4SAAAICP8SAAAICAATAAAICAETAAAICAITAAAICAMTAAAICAQTAAAICAUTAAAICAYTAAAICAcTAAAICAgTAAAICAkTAAAICAoTAAAICAsTAAAICAwTAAAICA0TAAAICA4TAAAICA8TAAAICBATAAAICBETAAAICBITAAAICBMTAAAICBQTAAAICBUTAAAICBYTAAAICBcTAAAICBgTAAAICBkTAAAICBoTAAAICBsTAAAICBwTAAAICB0TAAAICB4TAAAICB8TAAAICCATAAAICCETAAAICCITAAAICCMTAAAICCQTAAAICCUTAAAICCYTAAAICCcTAAAICCgTAAAICCkTAAAICCoTAAAICCsTAAAICCwTAAAICC0TAAAICC4TAAAICC8TAAAICDATAAAICDETAAAICDITAAAICDMTAAAICDQTAAAICDUTAAAICDYTAAAICDcTAAAICDgTAAAICDkTAAAICDoTAAAICDsTAAAICDwTAAAICD0TAAAICD4TAAAICD8TAAAICEATAAAICEETAAAICEITAAAICEMTAAAICEQTAAAICEUTAAAICEYTAAAICEcTAAAICEgTAAAICEkTAAAICEoTAAAICEsTAAAICEwTAAAICE0TAAAICE4TAAAICE8TAAAICFATAAAICFETAAAICFITAAAICFMTAAAICFQTAAAICFUTAAAICFYTAAAICFcTAAAICFgTAAAICFkTAAAICFoTAAAICFsTAAAICFwTAAAICF0TAAAICF4TAAAICF8TAAAICGATAAAICGETAAAICGITAAAICGMTAAAICGQTAAAICGUTAAAICGYTAAAICGcTAAAICGgTAAAICGkTAAAICGoTAAAICGsTAAAICGwTAAAICG0TAAAICG4TAAAICG8TAAAICHATAAAICHETAAAICHITAAAICHMTAAAICHQTAAAICHUTAAAICHYTAAAICHcTAAAICHgTAAAICHkTAAAICHoTAAAICHsTAAAICHwTAAAICH0TAAAICH4TAAAICH8TAAAICIATAAAICIETAAAICIITAAAICIMTAAAICIQTAAAICIUTAAAICIYTAAAICIcTAAAICIgTAAAICIkTAAAICIoTAAAICIsTAAAICIwTAAAICI0TAAAICI4TAAAICI8TAAAICJATAAAICJETAAAICJITAAAICJMTAAAICJQTAAAICJUTAAAICJYTAAAICJcTAAAICJgTAAAICJkTAAAICJoTAAAICJsTAAAICJwTAAAICJ0TAAAICJ4TAAAICJ8TAAAICKATAAAICKETAAAICKITAAAICKMTAAAICKQTAAAICKUTAAAICKYTAAAICKcTAAAICKgTAAAICKkTAAAICKoTAAAICKsTAAAICKwTAAAICK0TAAAICK4TAAAICK8TAAAICLATAAAICLETAAAICLITAAAICLMTAAAICLQTAAAICLUTAAAICLYTAAAICLcTAAAICLgTAAAICLkTAAAICLoTAAAICLsTAAAICLwTAAAICL0TAAAICL4TAAAICL8TAAAICMATAAAICMETAAAICMITAAAICMMTAAAICMQTAAAICMUTAAAICMYTAAAICMcTAAAICMgTAAAICMkTAAAICMoTAAAICMsTAAAICMwTAAAICM0TAAAICM4TAAAICM8TAAAICNATAAAICNETAAAICNITAAAICNMTAAAICNQTAAAICNUTAAAICNYTAAAICNcTAAAICNgTAAAICNkTAAAICNoTAAAICNsTAAAICNwTAAAICN0TAAAICN4TAAAICN8TAAAICOATAAAICOETAAAICOITAAAICOMTAAAICOQTAAAICOUTAAAICOYTAAAICOcTAAAICOgTAAAICOkTAAAICOoTAAAICOsTAAAICOwTAAAICO0TAAAICO4TAAAICO8TAAAICPATAAAICPETAAAICPITAAAICPMTAAAICPQTAAAICPUTAAAICPYTAAAICPcTAAAICPgTAAAICPkTAAAICPoTAAAICPsTAAAICPwTAAAICP0TAAAICP4TAAAICP8TAAAICAAUAAAICAEUAAAICAIUAAAICAMUAAAICAQUAAAICAUUAAAICAYUAAAICAcUAAAICAgUAAAICAkUAAAICAoUAAAICAsUAAAICAwUAAAICA0UAAAICA4UAAAICA8UAAAICBAUAAAICBEUAAAICBIUAAAICBMUAAAICBQUAAAICBUUAAAICBYUAAAICBcUAAAICBgUAAAICBkUAAAICBoUAAAICBsUAAAICBwUAAAICB0UAAAICB4UAAAICB8UAAAICCAUAAAICCEUAAAICCIUAAAICCMUAAAICCQUAAAICCUUAAAICCYUAAAICCcUAAAICCgUAAAICCkUAAAICCoUAAAICCsUAAAICCwUAAAICC0UAAAICC4UAAAICC8UAAAICDAUAAAICDEUAAAICDIUAAAICDMUAAAICDQUAAAICDUUAAAICDYUAAAICDcUAAAICDgUAAAICDkUAAAICDoUAAAICDsUAAAICDwUAAAICD0UAAAICD4UAAAICD8UAAAICEAUAAAICEEUAAAICEIUAAAICEMUAAAICEQUAAAICEUUAAAICEYUAAAICEcUAAAICEgUAAAICEkUAAAICEoUAAAICEsUAAAICEwUAAAICE0UAAAICE4UAAAICE8UAAAICFAUAAAICFEUAAAICFIUAAAICFMUAAAICFQUAAAICFUUAAAICFYUAAAICFcUAAAICFgUAAAICFkUAAAICFoUAAAICFsUAAAICFwUAAAICF0UAAAICF4UAAAICF8UAAAICGAUAAAICGEUAAAICGIUAAAICGMUAAAICGQUAAAICGUUAAAICGYUAAAICGcUAAAICGgUAAAICGkUAAAICGoUAAAICGsUAAAICGwUAAAICG0UAAAICG4UAAAICG8UAAAICHAUAAAICHEUAAAICHIUAAAICHMUAAAICHQUAAAICHUUAAAICHYUAAAICHcUAAAICHgUAAAICHkUAAAICHoUAAAICHsUAAAICHwUAAAICH0UAAAICH4UAAAICH8UAAAICIAUAAAICIEUAAAICIIUAAAICIMUAAAICIQUAAAICIUUAAAICIYUAAAICIcUAAAICIgUAAAICIkUAAAICIoUAAAICIsUAAAICIwUAAAICI0UAAAICI4UAAAICI8UAAAICJAUAAAICJEUAAAICJIUAAAICJMUAAAICJQUAAAICJUUAAAICJYUAAAICJcUAAAICJgUAAAICJkUAAAICJoUAAAICJsUAAAICJwUAAAICJ0UAAAICJ4UAAAICJ8UAAAICKAUAAAICKEUAAAICKIUAAAICKMUAAAICKQUAAAICKUUAAAICKYUAAAICKcUAAAICKgUAAAICKkUAAAICKoUAAAICKsUAAAICKwUAAAICK0UAAAICK4UAAAICK8UAAAICLAUAAAICLEUAAAICLIUAAAICLMUAAAICLQUAAAICLUUAAAICLYUAAAICLcUAAAICLgUAAAICLkUAAAICLoUAAAICLsUAAAICLwUAAAICL0UAAAICL4UAAAICL8UAAAICMAUAAAICMEUAAAICMIUAAAICMMUAAAICMQUAAAICMUUAAAICMYUAAAICMcUAAAICMgUAAAICMkUAAAICMoUAAAICMsUAAAICMwUAAAICM0UAAAICM4UAAAICM8UAAAICNAUAAAICNEUAAAICNIUAAAICNMUAAAICNQUAAAICNUUAAAICNYUAAAICNcUAAAICNgUAAAICNkUAAAICNoUAAAICNsUAAAICNwUAAAICN0UAAAICN4UAAAICN8UAAAICOAUAAAICOEUAAAICOIUAAAICOMUAAAICOQUAAAICOUUAAAICOYUAAAICOcUAAAICOgUAAAICOkUAAAICOoUAAAICOsUAAAICOwUAAAICO0UAAAICO4UAAAICO8UAAAICPAUAAAICPEUAAAICPIUAAAICPMUAAAICPQUAAAICPUUAAAICPYUAAAICPcUAAAICPgUAAAICPkUAAAICPoUAAAICPsUAAAICPwUAAAICP0UAAAICP4UAAAICP8UAAAICAAVAAAICAEVAAAICAIVAAAICAMVAAAICAQVAAAICAUVAAAICAYVAAAICAcVAAAICAgVAAAICAkVAAAICAoVAAAICAsVAAAICAwVAAAICA0VAAAICA4VAAAICA8VAAAICBAVAAAICBEVAAAICBIVAAAICBMVAAAICBQVAAAICBUVAAAICBYVAAAICBcVAAAICBgVAAAICBkVAAAICBoVAAAICBsVAAAICBwVAAAICB0VAAAICB4VAAAICB8VAAAICCAVAAAICCEVAAAICCIVAAAICCMVAAAICCQVAAAICCUVAAAICCYVAAAICCcVAAAICCgVAAAICCkVAAAICCoVAAAICCsVAAAICCwVAAAICC0VAAAICC4VAAAICC8VAAAICDAVAAAICDEVAAAICDIVAAAICDMVAAAICDQVAAAICDUVAAAICDYVAAAICDcVAAAICDgVAAAICDkVAAAICDoVAAAICDsVAAAICDwVAAAICD0VAAAICD4VAAAICD8VAAAICEAVAAAICEEVAAAICEIVAAAICEMVAAAICEQVAAAICEUVAAAICEYVAAAICEcVAAAICEgVAAAICEkVAAAICEoVAAAICEsVAAAICEwVAAAICE0VAAAICE4VAAAICE8VAAAICFAVAAAICFEVAAAICFIVAAAICFMVAAAICFQVAAAICFUVAAAICFYVAAAICFcVAAAICFgVAAAICFkVAAAICFoVAAAICFsVAAAICFwVAAAICF0VAAAICF4VAAAICF8VAAAICGAVAAAICGEVAAAICGIVAAAICGMVAAAICGQVAAAICGUVAAAICGYVAAAICGcVAAAICGgVAAAICGkVAAAICGoVAAAICGsVAAAICGwVAAAICG0VAAAICG4VAAAICG8VAAAICHAVAAAICHEVAAAICHIVAAAICHMVAAAICHQVAAAICHUVAAAICHYVAAAICHcVAAAICHgVAAAICHkVAAAICHoVAAAICHsVAAAICHwVAAAICH0VAAAICH4VAAAICH8VAAAICIAVAAAICIEVAAAICIIVAAAICIMVAAAICIQVAAAICIUVAAAICIYVAAAICIcVAAAICIgVAAAICIkVAAAICIoVAAAICIsVAAAICIwVAAAICI0VAAAICI4VAAAICI8VAAAICJAVAAAICJEVAAAICJIVAAAICJMVAAAICJQVAAAICJUVAAAICJYVAAAICJcVAAAICJgVAAAICJkVAAAICJoVAAAICJsVAAAICJwVAAAICJ0VAAAICJ4VAAAICJ8VAAAICKAVAAAICKEVAAAICKIVAAAICKMVAAAICKQVAAAICKUVAAAICKYVAAAICKcVAAAICKgVAAAICKkVAAAICKoVAAAICKsVAAAICKwVAAAICK0VAAAICK4VAAAICK8VAAAICLAVAAAICLEVAAAICLIVAAAICLMVAAAICLQVAAAICLUVAAAICLYVAAAICLcVAAAICLgVAAAICLkVAAAICLoVAAAICLsVAAAICLwVAAAICL0VAAAICL4VAAAICL8VAAAICMAVAAAICMEVAAAICMIVAAAICMMVAAAICMQVAAAICMUVAAAICMYVAAAICMcVAAAICMgVAAAICMkVAAAICMoVAAAICMsVAAAICMwVAAAICM0VAAAICM4VAAAICM8VAAAICNAVAAAICNEVAAAICNIVAAAICNMVAAAICNQVAAAICNUVAAAICNYVAAAICNcVAAAICNgVAAAICNkVAAAICNoVAAAICNsVAAAICNwVAAAICN0VAAAICN4VAAAICN8VAAAICOAVAAAICOEVAAAICOIVAAAICOMVAAAICOQVAAAICOUVAAAICOYVAAAICOcVAAAICOgVAAAICOkVAAAICOoVAAAICOsVAAAICOwVAAAICO0VAAAICO4VAAAICO8VAAAICPAVAAAICPEVAAAICPIVAAAICPMVAAAICPQVAAAICPUVAAAICPYVAAAICPcVAAAICPgVAAAICPkVAAAICPoVAAAICPsVAAAICPwVAAAICP0VAAAICP4VAAAICP8VAAAICAAWAAAICAEWAAAICAIWAAAICAMWAAAICAQWAAAICAUWAAAICAYWAAAICAcWAAAICAgWAAAICAkWAAAICAoWAAAICAsWAAAICAwWAAAICA0WAAAICA4WAAAICA8WAAAICBAWAAAICBEWAAAICBIWAAAICBMWAAAICBQWAAAICBUWAAAICBYWAAAICBcWAAAICBgWAAAICBkWAAAICBoWAAAICBsWAAAICBwWAAAICB0WAAAICB4WAAAICB8WAAAICCAWAAAICCEWAAAICCIWAAAICCMWAAAICCQWAAAICCUWAAAICCYWAAAICCcWAAAICCgWAAAICCkWAAAICCoWAAAICCsWAAAICCwWAAAICC0WAAAICC4WAAAICC8WAAAICDAWAAAICDEWAAAICDIWAAAICDMWAAAICDQWAAAICDUWAAAICDYWAAAICDcWAAAICDgWAAAICDkWAAAICDoWAAAICDsWAAAICDwWAAAICD0WAAAICD4WAAAICD8WAAAICEAWAAAICEEWAAAICEIWAAAICEMWAAAICEQWAAAICEUWAAAICEYWAAAICEcWAAAICEgWAAAICEkWAAAICEoWAAAICEsWAAAICEwWAAAICE0WAAAICE4WAAAICE8WAAAICFAWAAAICFEWAAAICFIWAAAICFMWAAAICFQWAAAICFUWAAAICFYWAAAICFcWAAAICFgWAAAICFkWAAAICFoWAAAICFsWAAAICFwWAAAICF0WAAAICF4WAAAICF8WAAAICGAWAAAICGEWAAAICGIWAAAICGMWAAAICGQWAAAICGUWAAAICGYWAAAICGcWAAAICGgWAAAICGkWAAAICGoWAAAICGsWAAAICGwWAAAICG0WAAAICG4WAAAICG8WAAAICHAWAAAICHEWAAAICHIWAAAICHMWAAAICHQWAAAICHUWAAAICHYWAAAICHcWAAAICHgWAAAICHkWAAAICHoWAAAICHsWAAAICHwWAAAICH0WAAAICH4WAAAICH8WAAAICIAWAAAICIEWAAAICIIWAAAICIMWAAAICIQWAAAICIUWAAAICIYWAAAICIcWAAAICIgWAAAICIkWAAAICIoWAAAICIsWAAAICIwWAAAICI0WAAAICI4WAAAICI8WAAAICJAWAAAICJEWAAAICJIWAAAICJMWAAAICJQWAAAICJUWAAAICJYWAAAICJcWAAAICJgWAAAICJkWAAAICJoWAAAICJsWAAAICJwWAAAICJ0WAAAICJ4WAAAICJ8WAAAICKAWAAAICKEWAAAICKIWAAAICKMWAAAICKQWAAAICKUWAAAICKYWAAAICKcWAAAICKgWAAAICKkWAAAICKoWAAAICKsWAAAICKwWAAAICK0WAAAICK4WAAAICK8WAAAICLAWAAAICLEWAAAICLIWAAAICLMWAAAICLQWAAAICLUWAAAICLYWAAAICLcWAAAICLgWAAAICLkWAAAICLoWAAAICLsWAAAICLwWAAAICL0WAAAICL4WAAAICL8WAAAICMAWAAAICMEWAAAICMIWAAAICMMWAAAICMQWAAAICMUWAAAICMYWAAAICMcWAAAICMgWAAAICMkWAAAICMoWAAAICMsWAAAICMwWAAAICM0WAAAICM4WAAAICM8WAAAICNAWAAAICNEWAAAICNIWAAAICNMWAAAICNQWAAAICNUWAAAICNYWAAAICNcWAAAICNgWAAAICNkWAAAICNoWAAAICNsWAAAICNwWAAAICN0WAAAICN4WAAAICN8WAAAICOAWAAAICOEWAAAICOIWAAAICOMWAAAICOQWAAAICOUWAAAICOYWAAAICOcWAAAICOgWAAAICOkWAAAICOoWAAAICOsWAAAICOwWAAAICO0WAAAICO4WAAAICO8WAAAICPAWAAAICPEWAAAICPIWAAAICPMWAAAICPQWAAAICPUWAAAICPYWAAAICPcWAAAICPgWAAAICPkWAAAICPoWAAAICPsWAAAICPwWAAAICP0WAAAICP4WAAAICP8WAAAICAAXAAAICAEXAAAICAIXAAAICAMXAAAICAQXAAAICAUXAAAICAYXAAAICAcXAAAICAgXAAAICAkXAAAICAoXAAAICAsXAAAICAwXAAAICA0XAAAICA4XAAAICA8XAAAICBAXAAAICBEXAAAICBIXAAAICBMXAAAICBQXAAAICBUXAAAICBYXAAAICBcXAAAICBgXAAAICBkXAAAICBoXAAAICBsXAAAICBwXAAAICB0XAAAICB4XAAAICB8XAAAICCAXAAAICCEXAAAICCIXAAAICCMXAAAICCQXAAAICCUXAAAICCYXAAAICCcXAAAICCgXAAAICCkXAAAICCoXAAAICCsXAAAICCwXAAAICC0XAAAICC4XAAAICC8XAAAICDAXAAAICDEXAAAICDIXAAAICDMXAAAICDQXAAAICDUXAAAICDYXAAAICDcXAAAICDgXAAAICDkXAAAICDoXAAAICDsXAAAICDwXAAAICD0XAAAICD4XAAAICD8XAAAICEAXAAAICEEXAAAICEIXAAAICEMXAAAICEQXAAAICEUXAAAICEYXAAAICEcXAAAICEgXAAAICEkXAAAICEoXAAAICEsXAAAICEwXAAAICE0XAAAICE4XAAAICE8XAAAICFAXAAAICFEXAAAICFIXAAAICFMXAAAICFQXAAAICFUXAAAICFYXAAAICFcXAAAICFgXAAAICFkXAAAICFoXAAAICFsXAAAICFwXAAAICF0XAAAICF4XAAAICF8XAAAICGAXAAAICGEXAAAICGIXAAAICGMXAAAICGQXAAAICGUXAAAICGYXAAAICGcXAAAICGgXAAAICGkXAAAICGoXAAAICGsXAAAICGwXAAAICG0XAAAICG4XAAAICG8XAAAICHAXAAAICHEXAAAICHIXAAAICHMXAAAICHQXAAAICHUXAAAICHYXAAAICHcXAAAICHgXAAAICHkXAAAICHoXAAAICHsXAAAICHwXAAAICH0XAAAICH4XAAAICH8XAAAICIAXAAAICIEXAAAICIIXAAAICIMXAAAICIQXAAAICIUXAAAICIYXAAAICIcXAAAICIgXAAAICIkXAAAICIoXAAAICIsXAAAICIwXAAAICI0XAAAICI4XAAAICI8XAAAICJAXAAAICJEXAAAICJIXAAAICJMXAAAICJQXAAAICJUXAAAICJYXAAAICJcXAAAICJgXAAAICJkXAAAICJoXAAAICJsXAAAICJwXAAAICJ0XAAAICJ4XAAAICJ8XAAAICKAXAAAICKEXAAAICKIXAAAICKMXAAAICKQXAAAICKUXAAAICKYXAAAICKcXAAAICKgXAAAICKkXAAAICKoXAAAICKsXAAAICKwXAAAICK0XAAAICK4XAAAICK8XAAAICLAXAAAICLEXAAAICLIXAAAICLMXAAAICLQXAAAICLUXAAAICLYXAAAICLcXAAAICLgXAAAICLkXAAAICLoXAAAICLsXAAAICLwXAAAICL0XAAAICL4XAAAICL8XAAAICMAXAAAICMEXAAAICMIXAAAICMMXAAAICMQXAAAICMUXAAAICMYXAAAICMcXAAAICMgXAAAICMkXAAAICMoXAAAICMsXAAAICMwXAAAICM0XAAAICM4XAAAICM8XAAAICNAXAAAICNEXAAAICNIXAAAICNMXAAAICNQXAAAICNUXAAAICNYXAAAICNcXAAAICNgXAAAICNkXAAAICNoXAAAICNsXAAAICNwXAAAICN0XAAAICN4XAAAICN8XAAAICOAXAAAICOEXAAAICOIXAAAICOMXAAAICOQXAAAICOUXAAAICOYXAAAICOcXAAAICOgXAAAICOkXAAAICOoXAAAICOsXAAAICOwXAAAICO0XAAAICO4XAAAICO8XAAAICPAXAAAICPEXAAAICPIXAAAICPMXAAAICPQXAAAICPUXAAAICPYXAAAICPcXAAAICPgXAAAICPkXAAAICPoXAAAICPsXAAAICPwXAAAICP0XAAAICP4XAAAICP8XAAAICAAYAAAICAEYAAAICAIYAAAICAMYAAAICAQYAAAICAUYAAAICAYYAAAICAcYAAAICAgYAAAICAkYAAAICAoYAAAICAsYAAAICAwYAAAICA0YAAAICA4YAAAICA8YAAAICBAYAAAICBEYAAAICBIYAAAICBMYAAAICBQYAAAICBUYAAAICBYYAAAICBcYAAAICBgYAAAICBkYAAAICBoYAAAICBsYAAAICBwYAAAICB0YAAAICB4YAAAICB8YAAAICCAYAAAICCEYAAAICCIYAAAICCMYAAAICCQYAAAICCUYAAAICCYYAAAICCcYAAAICCgYAAAICCkYAAAICCoYAAAICCsYAAAICCwYAAAICC0YAAAICC4YAAAICC8YAAAICDAYAAAICDEYAAAICDIYAAAICDMYAAAICDQYAAAICDUYAAAICDYYAAAICDcYAAAICDgYAAAICDkYAAAICDoYAAAICDsYAAAICDwYAAAICD0YAAAICD4YAAAICD8YAAAICEAYAAAICEEYAAAICEIYAAAICEMYAAAICEQYAAAICEUYAAAICEYYAAAICEcYAAAICEgYAAAICEkYAAAICEoYAAAICEsYAAAICEwYAAAICE0YAAAICE4YAAAICE8YAAAICFAYAAAICFEYAAAICFIYAAAICFMYAAAICFQYAAAICFUYAAAICFYYAAAICFcYAAAICFgYAAAICFkYAAAICFoYAAAICFsYAAAICFwYAAAICF0YAAAICF4YAAAICF8YAAAICGAYAAAICGEYAAAICGIYAAAICGMYAAAICGQYAAAICGUYAAAICGYYAAAICGcYAAAICGgYAAAICGkYAAAICGoYAAAICGsYAAAICGwYAAAICG0YAAAICG4YAAAICG8YAAAICHAYAAAICHEYAAAICHIYAAAICHMYAAAICHQYAAAICHUYAAAICHYYAAAICHcYAAAICHgYAAAICHkYAAAICHoYAAAICHsYAAAICHwYAAAICH0YAAAICH4YAAAICH8YAAAICIAYAAAICIEYAAAICIIYAAAICIMYAAAICIQYAAAICIUYAAAICIYYAAAICIcYAAAICIgYAAAICIkYAAAICIoYAAAICIsYAAAICIwYAAAICI0YAAAICI4YAAAICI8YAAAICJAYAAAICJEYAAAICJIYAAAICJMYAAAICJQYAAAICJUYAAAICJYYAAAICJcYAAAICJgYAAAICJkYAAAICJoYAAAICJsYAAAICJwYAAAICJ0YAAAICJ4YAAAICJ8YAAAICKAYAAAICKEYAAAICKIYAAAICKMYAAAICKQYAAAICKUYAAAICKYYAAAICKcYAAAICKgYAAAICKkYAAAICKoYAAAICKsYAAAICKwYAAAICK0YAAAICK4YAAAICK8YAAAICLAYAAAICLEYAAAICLIYAAAICLMYAAAICLQYAAAICLUYAAAICLYYAAAICLcYAAAICLgYAAAICLkYAAAICLoYAAAICLsYAAAICLwYAAAICL0YAAAICL4YAAAICL8YAAAICMAYAAAICMEYAAAICMIYAAAICMMYAAAICMQYAAAICMUYAAAICMYYAAAICMcYAAAICMgYAAAICMkYAAAICMoYAAAICMsYAAAICMwYAAAICM0YAAAICM4YAAAICM8YAAAICNAYAAAICNEYAAAICNIYAAAICNMYAAAICNQYAAAICNUYAAAICNYYAAAICNcYAAAICNgYAAAICNkYAAAICNoYAAAICNsYAAAICNwYAAAICN0YAAAICN4YAAAICN8YAAAICOAYAAAICOEYAAAICOIYAAAICOMYAAAICOQYAAAICOUYAAAICOYYAAAICOcYAAAICOgYAAAICOkYAAAICOoYAAAICOsYAAAICOwYAAAICO0YAAAICO4YAAAICO8YAAAICPAYAAAICPEYAAAICPIYAAAICPMYAAAICPQYAAAICPUYAAAICPYYAAAICPcYAAAICPgYAAAICPkYAAAICPoYAAAICPsYAAAICPwYAAAICP0YAAAICP4YAAAICP8YAAAICAAZAAAICAEZAAAICAIZAAAICAMZAAAICAQZAAAICAUZAAAICAYZAAAICAcZAAAICAgZAAAICAkZAAAICAoZAAAICAsZAAAICAwZAAAICA0ZAAAICA4ZAAAICA8ZAAAICBAZAAAICBEZAAAICBIZAAAICBMZAAAICBQZAAAICBUZAAAICBYZAAAICBcZAAAICBgZAAAICBkZAAAICBoZAAAICBsZAAAICBwZAAAICB0ZAAAICB4ZAAAICB8ZAAAICCAZAAAICCEZAAAICCIZAAAICCMZAAAICCQZAAAICCUZAAAICCYZAAAICCcZAAAICCgZAAAICCkZAAAICCoZAAAICCsZAAAICCwZAAAICC0ZAAAICC4ZAAAICC8ZAAAICDAZAAAICDEZAAAICDIZAAAICDMZAAAICDQZAAAICDUZAAAICDYZAAAICDcZAAAICDgZAAAICDkZAAAICDoZAAAICDsZAAAICDwZAAAICD0ZAAAICD4ZAAAICD8ZAAAICEAZAAAICEEZAAAICEIZAAAICEMZAAAICEQZAAAICEUZAAAICEYZAAAICEcZAAAICEgZAAAICEkZAAAICEoZAAAICEsZAAAICEwZAAAICE0ZAAAICE4ZAAAICE8ZAAAICFAZAAAICFEZAAAICFIZAAAICFMZAAAICFQZAAAICFUZAAAICFYZAAAICFcZAAAICFgZAAAICFkZAAAICFoZAAAICFsZAAAICFwZAAAICF0ZAAAICF4ZAAAICF8ZAAAICGAZAAAICGEZAAAICGIZAAAICGMZAAAICGQZAAAICGUZAAAICGYZAAAICGcZAAAICGgZAAAICGkZAAAICGoZAAAICGsZAAAICGwZAAAICG0ZAAAICG4ZAAAICG8ZAAAICHAZAAAICHEZAAAICHIZAAAICHMZAAAICHQZAAAICHUZAAAICHYZAAAICHcZAAAICHgZAAAICHkZAAAICHoZAAAICHsZAAAICHwZAAAICH0ZAAAICH4ZAAAICH8ZAAAICIAZAAAICIEZAAAICIIZAAAICIMZAAAICIQZAAAICIUZAAAICIYZAAAICIcZAAAICIgZAAAICIkZAAAICIoZAAAICIsZAAAICIwZAAAICI0ZAAAICI4ZAAAICI8ZAAAICJAZAAAICJEZAAAICJIZAAAICJMZAAAICJQZAAAICJUZAAAICJYZAAAICJcZAAAICJgZAAAICJkZAAAICJoZAAAICJsZAAAICJwZAAAICJ0ZAAAICJ4ZAAAICJ8ZAAAICKAZAAAICKEZAAAICKIZAAAICKMZAAAICKQZAAAICKUZAAAICKYZAAAICKcZAAAICKgZAAAICKkZAAAICKoZAAAICKsZAAAICKwZAAAICK0ZAAAICK4ZAAAICK8ZAAAICLAZAAAICLEZAAAICLIZAAAICLMZAAAICLQZAAAICLUZAAAICLYZAAAICLcZAAAICLgZAAAICLkZAAAICLoZAAAICLsZAAAICLwZAAAICL0ZAAAICL4ZAAAICL8ZAAAICMAZAAAICMEZAAAICMIZAAAICMMZAAAICMQZAAAICMUZAAAICMYZAAAICMcZAAAICMgZAAAICMkZAAAICMoZAAAICMsZAAAICMwZAAAICM0ZAAAICM4ZAAAICM8ZAAAICNAZAAAICNEZAAAICNIZAAAICNMZAAAICNQZAAAICNUZAAAICNYZAAAICNcZAAAICNgZAAAICNkZAAAICNoZAAAICNsZAAAICNwZAAAICN0ZAAAICN4ZAAAICN8ZAAAICOAZAAAICOEZAAAICOIZAAAICOMZAAAICOQZAAAICOUZAAAICOYZAAAICOcZAAAICOgZAAAICOkZAAAICOoZAAAICOsZAAAICOwZAAAICO0ZAAAICO4ZAAAICO8ZAAAICPAZAAAICPEZAAAICPIZAAAICPMZAAAICPQZAAAICPUZAAAICPYZAAAICPcZAAAICPgZAAAICPkZAAAICPoZAAAICPsZAAAICPwZAAAICP0ZAAAICP4ZAAAICP8ZAAAICAAaAAAICAEaAAAICAIaAAAICAMaAAAICAQaAAAICAUaAAAICAYaAAAICAcaAAAICAgaAAAICAkaAAAICAoaAAAICAsaAAAICAwaAAAICA0aAAAICA4aAAAICA8aAAAICBAaAAAICBEaAAAICBIaAAAICBMaAAAICBQaAAAICBUaAAAICBYaAAAICBcaAAAICBgaAAAICBkaAAAICBoaAAAICBsaAAAICBwaAAAICB0aAAAICB4aAAAICB8aAAAICCAaAAAICCEaAAAICCIaAAAICCMaAAAICCQaAAAICCUaAAAICCYaAAAICCcaAAAICCgaAAAICCkaAAAICCoaAAAICCsaAAAICCwaAAAICC0aAAAICC4aAAAICC8aAAAICDAaAAAICDEaAAAICDIaAAAICDMaAAAICDQaAAAICDUaAAAICDYaAAAICDcaAAAICDgaAAAICDkaAAAICDoaAAAICDsaAAAICDwaAAAICD0aAAAICD4aAAAICD8aAAAICEAaAAAICEEaAAAICEIaAAAICEMaAAAICEQaAAAICEUaAAAICEYaAAAICEcaAAAICEgaAAAICEkaAAAICEoaAAAICEsaAAAICEwaAAAICE0aAAAICE4aAAAICE8aAAAICFAaAAAICFEaAAAICFIaAAAICFMaAAAICFQaAAAICFUaAAAICFYaAAAICFcaAAAICFgaAAAICFkaAAAICFoaAAAICFsaAAAICFwaAAAICF0aAAAICF4aAAAICF8aAAAICGAaAAAICGEaAAAICGIaAAAICGMaAAAICGQaAAAICGUaAAAICGYaAAAICGcaAAAICGgaAAAICGkaAAAICGoaAAAICGsaAAAICGwaAAAICG0aAAAICG4aAAAICG8aAAAICHAaAAAICHEaAAAICHIaAAAICHMaAAAICHQaAAAICHUaAAAICHYaAAAICHcaAAAICHgaAAAICHkaAAAICHoaAAAICHsaAAAICHwaAAAICH0aAAAICH4aAAAICH8aAAAICIAaAAAICIEaAAAICIIaAAAICIMaAAAICIQaAAAICIUaAAAICIYaAAAICIcaAAAICIgaAAAICIkaAAAICIoaAAAICIsaAAAICIwaAAAICI0aAAAICI4aAAAICI8aAAAICJAaAAAICJEaAAAICJIaAAAICJMaAAAICJQaAAAICJUaAAAICJYaAAAICJcaAAAICJgaAAAICJkaAAAICJoaAAAICJsaAAAICJwaAAAICJ0aAAAICJ4aAAAICJ8aAAAICKAaAAAICKEaAAAICKIaAAAICKMaAAAICKQaAAAICKUaAAAICKYaAAAICKcaAAAICKgaAAAICKkaAAAICKoaAAAICKsaAAAICKwaAAAICK0aAAAICK4aAAAICK8aAAAICLAaAAAICLEaAAAICLIaAAAICLMaAAAICLQaAAAICLUaAAAICLYaAAAICLcaAAAICLgaAAAICLkaAAAICLoaAAAICLsaAAAICLwaAAAICL0aAAAICL4aAAAICL8aAAAICMAaAAAICMEaAAAICMIaAAAICMMaAAAICMQaAAAICMUaAAAICMYaAAAICMcaAAAICMgaAAAICMkaAAAICMoaAAAICMsaAAAICMwaAAAICM0aAAAICM4aAAAICM8aAAAICNAaAAAICNEaAAAICNIaAAAICNMaAAAICNQaAAAICNUaAAAICNYaAAAICNcaAAAICNgaAAAICNkaAAAICNoaAAAICNsaAAAICNwaAAAICN0aAAAICN4aAAAICN8aAAAICOAaAAAICOEaAAAICOIaAAAICOMaAAAICOQaAAAICOUaAAAICOYaAAAICOcaAAAICOgaAAAICOkaAAAICOoaAAAICOsaAAAICOwaAAAICO0aAAAICO4aAAAICO8aAAAICPAaAAAICPEaAAAICPIaAAAICPMaAAAICPQaAAAICPUaAAAICPYaAAAICPcaAAAICPgaAAAICPkaAAAICPoaAAAICPsaAAAICPwaAAAICP0aAAAICP4aAAAICP8aAAAICAAbAAAICAEbAAAICAIbAAAICAMbAAAICAQbAAAICAUbAAAICAYbAAAICAcbAAAICAgbAAAICAkbAAAICAobAAAICAsbAAAICAwbAAAICA0bAAAICA4bAAAICA8bAAAICBAbAAAICBEbAAAICBIbAAAICBMbAAAICBQbAAAICBUbAAAICBYbAAAICBcbAAAICBgbAAAICBkbAAAICBobAAAICBsbAAAICBwbAAAICB0bAAAICB4bAAAICB8bAAAICCAbAAAICCEbAAAICCIbAAAICCMbAAAICCQbAAAICCUbAAAICCYbAAAICCcbAAAICCgbAAAICCkbAAAICCobAAAICCsbAAAICCwbAAAICC0bAAAICC4bAAAICC8bAAAICDAbAAAICDEbAAAICDIbAAAICDMbAAAICDQbAAAICDUbAAAICDYbAAAICDcbAAAICDgbAAAICDkbAAAICDobAAAICDsbAAAICDwbAAAICD0bAAAICD4bAAAICD8bAAAICEAbAAAICEEbAAAICEIbAAAICEMbAAAICEQbAAAICEUbAAAICEYbAAAICEcbAAAICEgbAAAICEkbAAAICEobAAAICEsbAAAICEwbAAAICE0bAAAICE4bAAAICE8bAAAICFAbAAAICFEbAAAICFIbAAAICFMbAAAICFQbAAAICFUbAAAICFYbAAAICFcbAAAICFgbAAAICFkbAAAICFobAAAICFsbAAAICFwbAAAICF0bAAAICF4bAAAICF8bAAAICGAbAAAICGEbAAAICGIbAAAICGMbAAAICGQbAAAICGUbAAAICGYbAAAICGcbAAAICGgbAAAICGkbAAAICGobAAAICGsbAAAICGwbAAAICG0bAAAICG4bAAAICG8bAAAICHAbAAAICHEbAAAICHIbAAAICHMbAAAICHQbAAAICHUbAAAICHYbAAAICHcbAAAICHgbAAAICHkbAAAICHobAAAICHsbAAAICHwbAAAICH0bAAAICH4bAAAICH8bAAAICIAbAAAICIEbAAAICIIbAAAICIMbAAAICIQbAAAICIUbAAAICIYbAAAICIcbAAAICIgbAAAICIkbAAAICIobAAAICIsbAAAICIwbAAAICI0bAAAICI4bAAAICI8bAAAICJAbAAAICJEbAAAICJIbAAAICJMbAAAICJQbAAAICJUbAAAICJYbAAAICJcbAAAICJgbAAAICJkbAAAICJobAAAICJsbAAAICJwbAAAICJ0bAAAICJ4bAAAICJ8bAAAICKAbAAAICKEbAAAICKIbAAAICKMbAAAICKQbAAAICKUbAAAICKYbAAAICKcbAAAICKgbAAAICKkbAAAICKobAAAICKsbAAAICKwbAAAICK0bAAAICK4bAAAICK8bAAAICLAbAAAICLEbAAAICLIbAAAICLMbAAAICLQbAAAICLUbAAAICLYbAAAICLcbAAAICLgbAAAICLkbAAAICLobAAAICLsbAAAICLwbAAAICL0bAAAICL4bAAAICL8bAAAICMAbAAAICMEbAAAICMIbAAAICMMbAAAICMQbAAAICMUbAAAICMYbAAAICMcbAAAICMgbAAAICMkbAAAICMobAAAICMsbAAAICMwbAAAICM0bAAAICM4bAAAICM8bAAAICNAbAAAICNEbAAAICNIbAAAICNMbAAAICNQbAAAICNUbAAAICNYbAAAICNcbAAAICNgbAAAICNkbAAAICNobAAAICNsbAAAICNwbAAAICN0bAAAICN4bAAAICN8bAAAICOAbAAAICOEbAAAICOIbAAAICOMbAAAICOQbAAAICOUbAAAICOYbAAAICOcbAAAICOgbAAAICOkbAAAICOobAAAICOsbAAAICOwbAAAICO0bAAAICO4bAAAICO8bAAAICPAbAAAICPEbAAAICPIbAAAICPMbAAAICPQbAAAICPUbAAAICPYbAAAICPcbAAAICPgbAAAICPkbAAAICPobAAAICPsbAAAICPwbAAAICP0bAAAICP4bAAAICP8bAAAICAAcAAAICAEcAAAICAIcAAAICAMcAAAICAQcAAAICAUcAAAICAYcAAAICAccAAAICAgcAAAICAkcAAAICAocAAAICAscAAAICAwcAAAICA0cAAAICA4cAAAICA8cAAAICBAcAAAICBEcAAAICBIcAAAICBMcAAAICBQcAAAICBUcAAAICBYcAAAICBccAAAICBgcAAAICBkcAAAICBocAAAICBscAAAICBwcAAAICB0cAAAICB4cAAAICB8cAAAICCAcAAAICCEcAAAICCIcAAAICCMcAAAICCQcAAAICCUcAAAICCYcAAAICCccAAAICCgcAAAICCkcAAAICCocAAAICCscAAAICCwcAAAICC0cAAAICC4cAAAICC8cAAAICDAcAAAICDEcAAAICDIcAAAICDMcAAAICDQcAAAICDUcAAAICDYcAAAICDccAAAICDgcAAAICDkcAAAICDocAAAICDscAAAICDwcAAAICD0cAAAICD4cAAAICD8cAAAICEAcAAAICEEcAAAICEIcAAAICEMcAAAICEQcAAAICEUcAAAICEYcAAAICEccAAAICEgcAAAICEkcAAAICEocAAAICEscAAAICEwcAAAICE0cAAAICE4cAAAICE8cAAAICFAcAAAICFEcAAAICFIcAAAICFMcAAAICFQcAAAICFUcAAAICFYcAAAICFccAAAICFgcAAAICFkcAAAICFocAAAICFscAAAICFwcAAAICF0cAAAICF4cAAAICF8cAAAICGAcAAAICGEcAAAICGIcAAAICGMcAAAICGQcAAAICGUcAAAICGYcAAAICGccAAAICGgcAAAICGkcAAAICGocAAAICGscAAAICGwcAAAICG0cAAAICG4cAAAICG8cAAAICHAcAAAICHEcAAAICHIcAAAICHMcAAAICHQcAAAICHUcAAAICHYcAAAICHccAAAICHgcAAAICHkcAAAICHocAAAICHscAAAICHwcAAAICH0cAAAICH4cAAAICH8cAAAICIAcAAAICIEcAAAICIIcAAAICIMcAAAICIQcAAAICIUcAAAICIYcAAAICIccAAAICIgcAAAICIkcAAAICIocAAAICIscAAAICIwcAAAICI0cAAAICI4cAAAICI8cAAAICJAcAAAICJEcAAAICJIcAAAICJMcAAAICJQcAAAICJUcAAAICJYcAAAICJccAAAICJgcAAAICJkcAAAICJocAAAICJscAAAICJwcAAAICJ0cAAAICJ4cAAAICJ8cAAAICKAcAAAICKEcAAAICKIcAAAICKMcAAAICKQcAAAICKUcAAAICKYcAAAICKccAAAICKgcAAAICKkcAAAICKocAAAICKscAAAICKwcAAAICK0cAAAICK4cAAAICK8cAAAICLAcAAAICLEcAAAICLIcAAAICLMcAAAICLQcAAAICLUcAAAICLYcAAAICLccAAAICLgcAAAICLkcAAAICLocAAAICLscAAAICLwcAAAICL0cAAAICL4cAAAICL8cAAAICMAcAAAICMEcAAAICMIcAAAICMMcAAAICMQcAAAICMUcAAAICMYcAAAICMccAAAICMgcAAAICMkcAAAICMocAAAICMscAAAICMwcAAAICM0cAAAICM4cAAAICM8cAAAICNAcAAAICNEcAAAICNIcAAAICNMcAAAICNQcAAAICNUcAAAICNYcAAAICNccAAAICNgcAAAICNkcAAAICNocAAAICNscAAAICNwcAAAICN0cAAAICN4cAAAICN8cAAAICOAcAAAICOEcAAAICOIcAAAICOMcAAAICOQcAAAICOUcAAAICOYcAAAICOccAAAICOgcAAAICOkcAAAICOocAAAICOscAAAICOwcAAAICO0cAAAICO4cAAAICO8cAAAICPAcAAAICPEcAAAICPIcAAAICPMcAAAICPQcAAAICPUcAAAICPYcAAAICPccAAAICPgcAAAICPkcAAAICPocAAAICPscAAAICPwcAAAICP0cAAAICP4cAAAICP8cAAAICAAdAAAICAEdAAAICAIdAAAICAMdAAAICAQdAAAICAUdAAAICAYdAAAICAcdAAAICAgdAAAICAkdAAAICAodAAAICAsdAAAICAwdAAAICA0dAAAICA4dAAAICA8dAAAICBAdAAAICBEdAAAICBIdAAAICBMdAAAICBQdAAAICBUdAAAICBYdAAAICBcdAAAICBgdAAAICBkdAAAICBodAAAICBsdAAAICBwdAAAICB0dAAAICB4dAAAICB8dAAAICCAdAAAICCEdAAAICCIdAAAICCMdAAAICCQdAAAICCUdAAAICCYdAAAICCcdAAAICCgdAAAICCkdAAAICCodAAAICCsdAAAICCwdAAAICC0dAAAICC4dAAAICC8dAAAICDAdAAAICDEdAAAICDIdAAAICDMdAAAICDQdAAAICDUdAAAICDYdAAAICDcdAAAICDgdAAAICDkdAAAICDodAAAICDsdAAAICDwdAAAICD0dAAAICD4dAAAICD8dAAAICEAdAAAICEEdAAAICEIdAAAICEMdAAAICEQdAAAICEUdAAAICEYdAAAICEcdAAAICEgdAAAICEkdAAAICEodAAAICEsdAAAICEwdAAAICE0dAAAICE4dAAAICE8dAAAICFAdAAAICFEdAAAICFIdAAAICFMdAAAICFQdAAAICFUdAAAICFYdAAAICFcdAAAICFgdAAAICFkdAAAICFodAAAICFsdAAAICFwdAAAICF0dAAAICF4dAAAICF8dAAAICGAdAAAICGEdAAAICGIdAAAICGMdAAAICGQdAAAICGUdAAAICGYdAAAICGcdAAAICGgdAAAICGkdAAAICGodAAAICGsdAAAICGwdAAAICG0dAAAICG4dAAAICG8dAAAICHAdAAAICHEdAAAICHIdAAAICHMdAAAICHQdAAAICHUdAAAICHYdAAAICHcdAAAICHgdAAAICHkdAAAICHodAAAICHsdAAAICHwdAAAICH0dAAAICH4dAAAICH8dAAAICIAdAAAICIEdAAAICIIdAAAICIMdAAAICIQdAAAICIUdAAAICIYdAAAICIcdAAAICIgdAAAICIkdAAAICIodAAAICIsdAAAICIwdAAAICI0dAAAICI4dAAAICI8dAAAICJAdAAAICJEdAAAICJIdAAAICJMdAAAICJQdAAAICJUdAAAICJYdAAAICJcdAAAICJgdAAAICJkdAAAICJodAAAICJsdAAAICJwdAAAICJ0dAAAICJ4dAAAICJ8dAAAICKAdAAAICKEdAAAICKIdAAAICKMdAAAICKQdAAAICKUdAAAICKYdAAAICKcdAAAICKgdAAAICKkdAAAICKodAAAICKsdAAAICKwdAAAICK0dAAAICK4dAAAICK8dAAAICLAdAAAICLEdAAAICLIdAAAICLMdAAAICLQdAAAICLUdAAAICLYdAAAICLcdAAAICLgdAAAICLkdAAAICLodAAAICLsdAAAICLwdAAAICL0dAAAICL4dAAAICL8dAAAICMAdAAAICMEdAAAICMIdAAAICMMdAAAICMQdAAAICMUdAAAICMYdAAAICMcdAAAICMgdAAAICMkdAAAICModAAAICMsdAAAICMwdAAAICM0dAAAICM4dAAAICM8dAAAICNAdAAAICNEdAAAICNIdAAAICNMdAAAICNQdAAAICNUdAAAICNYdAAAICNcdAAAICNgdAAAICNkdAAAICNodAAAICNsdAAAICNwdAAAICN0dAAAICN4dAAAICN8dAAAICOAdAAAICOEdAAAICOIdAAAICOMdAAAICOQdAAAICOUdAAAICOYdAAAICOcdAAAICOgdAAAICOkdAAAICOodAAAICOsdAAAICOwdAAAICO0dAAAICO4dAAAICO8dAAAICPAdAAAICPEdAAAICPIdAAAICPMdAAAICPQdAAAICPUdAAAICPYdAAAICPcdAAAICPgdAAAICPkdAAAICPodAAAICPsdAAAICPwdAAAICP0dAAAICP4dAAAICP8dAAAICAAeAAAICAEeAAAICAIeAAAICAMeAAAICAQeAAAICAUeAAAICAYeAAAICAceAAAICAgeAAAICAkeAAAICAoeAAAICAseAAAICAweAAAICA0eAAAICA4eAAAICA8eAAAICBAeAAAICBEeAAAICBIeAAAICBMeAAAICBQeAAAICBUeAAAICBYeAAAICBceAAAICBgeAAAICBkeAAAICBoeAAAICBseAAAICBweAAAICB0eAAAICB4eAAAICB8eAAAICCAeAAAICCEeAAAICCIeAAAICCMeAAAICCQeAAAICCUeAAAICCYeAAAICCceAAAICCgeAAAICCkeAAAICCoeAAAICCseAAAICCweAAAICC0eAAAICC4eAAAICC8eAAAICDAeAAAICDEeAAAICDIeAAAICDMeAAAICDQeAAAICDUeAAAICDYeAAAICDceAAAICDgeAAAICDkeAAAICDoeAAAICDseAAAICDweAAAICD0eAAAICD4eAAAICD8eAAAICEAeAAAICEEeAAAICEIeAAAICEMeAAAICEQeAAAICEUeAAAICEYeAAAICEceAAAICEgeAAAICEkeAAAICEoeAAAICEseAAAICEweAAAICE0eAAAICE4eAAAICE8eAAAICFAeAAAICFEeAAAICFIeAAAICFMeAAAICFQeAAAICFUeAAAICFYeAAAICFceAAAICFgeAAAICFkeAAAICFoeAAAICFseAAAICFweAAAICF0eAAAICF4eAAAICF8eAAAICGAeAAAICGEeAAAICGIeAAAICGMeAAAICGQeAAAICGUeAAAICGYeAAAICGceAAAICGgeAAAICGkeAAAICGoeAAAICGseAAAICGweAAAICG0eAAAICG4eAAAICG8eAAAICHAeAAAICHEeAAAICHIeAAAICHMeAAAICHQeAAAICHUeAAAICHYeAAAICHceAAAICHgeAAAICHkeAAAICHoeAAAICHseAAAICHweAAAICH0eAAAICH4eAAAICH8eAAAICIAeAAAICIEeAAAICIIeAAAICIMeAAAICIQeAAAICIUeAAAICIYeAAAICIceAAAICIgeAAAICIkeAAAICIoeAAAICIseAAAICIweAAAICI0eAAAICI4eAAAICI8eAAAICJAeAAAICJEeAAAICJIeAAAICJMeAAAICJQeAAAICJUeAAAICJYeAAAICJceAAAICJgeAAAICJkeAAAICJoeAAAICJseAAAICJweAAAICJ0eAAAICJ4eAAAICJ8eAAAICKAeAAAICKEeAAAICKIeAAAICKMeAAAICKQeAAAICKUeAAAICKYeAAAICKceAAAICKgeAAAICKkeAAAICKoeAAAICKseAAAICKweAAAICK0eAAAICK4eAAAICK8eAAAICLAeAAAICLEeAAAICLIeAAAICLMeAAAICLQeAAAICLUeAAAICLYeAAAICLceAAAICLgeAAAICLkeAAAICLoeAAAICLseAAAICLweAAAICL0eAAAICL4eAAAICL8eAAAICMAeAAAICMEeAAAICMIeAAAICMMeAAAICMQeAAAICMUeAAAICMYeAAAICMceAAAICMgeAAAICMkeAAAICMoeAAAICMseAAAICMweAAAICM0eAAAICM4eAAAICM8eAAAICNAeAAAICNEeAAAICNIeAAAICNMeAAAICNQeAAAICNUeAAAICNYeAAAICNceAAAICNgeAAAICNkeAAAICNoeAAAICNseAAAICNweAAAICN0eAAAICN4eAAAICN8eAAAICOAeAAAICOEeAAAICOIeAAAICOMeAAAICOQeAAAICOUeAAAICOYeAAAICOceAAAICOgeAAAICOkeAAAICOoeAAAICOseAAAICOweAAAICO0eAAAICO4eAAAICO8eAAAICPAeAAAICPEeAAAICPIeAAAICPMeAAAICPQeAAAICPUeAAAICPYeAAAICPceAAAICPgeAAAICPkeAAAICPoeAAAICPseAAAICPweAAAICP0eAAAICP4eAAAICP8eAAAICAAfAAAICAEfAAAICAIfAAAICAMfAAAICAQfAAAICAUfAAAICAYfAAAICAcfAAAICAgfAAAICAkfAAAICAofAAAICAsfAAAICAwfAAAICA0fAAAICA4fAAAICA8fAAAICBAfAAAICBEfAAAICBIfAAAICBMfAAAICBQfAAAICBUfAAAICBYfAAAICBcfAAAICBgfAAAICBkfAAAICBofAAAICBsfAAAICBwfAAAICB0fAAAICB4fAAAICB8fAAAICCAfAAAICCEfAAAICCIfAAAICCMfAAAICCQfAAAICCUfAAAICCYfAAAICCcfAAAICCgfAAAICCkfAAAICCofAAAICCsfAAAICCwfAAAICC0fAAAICC4fAAAICC8fAAAICDAfAAAICDEfAAAICDIfAAAICDMfAAAICDQfAAAICDUfAAAICDYfAAAICDcfAAAICDgfAAAICDkfAAAICDofAAAICDsfAAAICDwfAAAICD0fAAAICD4fAAAICD8fAAAICEAfAAAICEEfAAAICEIfAAAICEMfAAAICEQfAAAICEUfAAAICEYfAAAICEcfAAAICEgfAAAICEkfAAAICEofAAAICEsfAAAICEwfAAAICE0fAAAICE4fAAAICE8fAAAICFAfAAAICFEfAAAICFIfAAAICFMfAAAICFQfAAAICFUfAAAICFYfAAAICFcfAAAICFgfAAAICFkfAAAICFofAAAICFsfAAAICFwfAAAICF0fAAAICF4fAAAICF8fAAAICGAfAAAICGEfAAAICGIfAAAICGMfAAAICGQfAAAICGUfAAAICGYfAAAICGcfAAAICGgfAAAICGkfAAAICGofAAAICGsfAAAICGwfAAAICG0fAAAICG4fAAAICG8fAAAICHAfAAAICHEfAAAICHIfAAAICHMfAAAICHQfAAAICHUfAAAICHYfAAAICHcfAAAICHgfAAAICHkfAAAICHofAAAICHsfAAAICHwfAAAICH0fAAAICH4fAAAICH8fAAAICIAfAAAICIEfAAAICIIfAAAICIMfAAAICIQfAAAICIUfAAAICIYfAAAICIcfAAAICIgfAAAICIkfAAAICIofAAAICIsfAAAICIwfAAAICI0fAAAICI4fAAAICI8fAAAICJAfAAAICJEfAAAICJIfAAAICJMfAAAICJQfAAAICJUfAAAICJYfAAAICJcfAAAICJgfAAAICJkfAAAICJofAAAICJsfAAAICJwfAAAICJ0fAAAICJ4fAAAICJ8fAAAICKAfAAAICKEfAAAICKIfAAAICKMfAAAICKQfAAAICKUfAAAICKYfAAAICKcfAAAICKgfAAAICKkfAAAICKofAAAICKsfAAAICKwfAAAICK0fAAAICK4fAAAICK8fAAAICLAfAAAICLEfAAAICLIfAAAICLMfAAAICLQfAAAICLUfAAAICLYfAAAICLcfAAAICLgfAAAICLkfAAAICLofAAAICLsfAAAICLwfAAAICL0fAAAICL4fAAAICL8fAAAICMAfAAAICMEfAAAICMIfAAAICMMfAAAICMQfAAAICMUfAAAICMYfAAAICMcfAAAICMgfAAAICMkfAAAICMofAAAICMsfAAAICMwfAAAICM0fAAAICM4fAAAICM8fAAAICNAfAAAICNEfAAAICNIfAAAICNMfAAAICNQfAAAICNUfAAAICNYfAAAICNcfAAAICNgfAAAICNkfAAAICNofAAAICNsfAAAICNwfAAAICN0fAAAICN4fAAAICN8fAAAICOAfAAAICOEfAAAICOIfAAAICOMfAAAICOQfAAAICOUfAAAICOYfAAAICOcfAAAICOgfAAAICOkfAAAICOofAAAICOsfAAAICOwfAAAICO0fAAAICO4fAAAICO8fAAAICPAfAAAICPEfAAAICPIfAAAICPMfAAAICPQfAAAICPUfAAAICPYfAAAICPcfAAAICPgfAAAICPkfAAAICPofAAAICPsfAAAICPwfAAAICP0fAAAICP4fAAAICP8fAAAICAAgAAAICAEgAAAICAIgAAAICAMgAAAICAQgAAAICAUgAAAICAYgAAAICAcgAAAICAggAAAICAkgAAAICAogAAAICAsgAAAICAwgAAAICA0gAAAICA4gAAAICA8gAAAICBAgAAAICBEgAAAICBIgAAAICBMgAAAICBQgAAAICBUgAAAICBYgAAAICBcgAAAICBggAAAICBkgAAAICBogAAAICBsgAAAICBwgAAAICB0gAAAICB4gAAAICB8gAAAICCAgAAAICCEgAAAICCIgAAAICCMgAAAICCQgAAAICCUgAAAICCYgAAAICCcgAAAICCggAAAICCkgAAAICCogAAAICCsgAAAICCwgAAAICC0gAAAICC4gAAAICC8gAAAICDAgAAAICDEgAAAICDIgAAAICDMgAAAICDQgAAAICDUgAAAICDYgAAAICDcgAAAICDggAAAICDkgAAAICDogAAAICDsgAAAICDwgAAAICD0gAAAICD4gAAAICD8gAAAICEAgAAAICEEgAAAICEIgAAAICEMgAAAICEQgAAAICEUgAAAICEYgAAAICEcgAAAICEggAAAICEkgAAAICEogAAAICEsgAAAICEwgAAAICE0gAAAICE4gAAAICE8gAAAICFAgAAAICFEgAAAICFIgAAAICFMgAAAICFQgAAAICFUgAAAICFYgAAAICFcgAAAICFggAAAICFkgAAAICFogAAAICFsgAAAICFwgAAAICF0gAAAICF4gAAAICF8gAAAICGAgAAAICGEgAAAICGIgAAAICGMgAAAICGQgAAAICGUgAAAICGYgAAAICGcgAAAICGggAAAICGkgAAAICGogAAAICGsgAAAICGwgAAAICG0gAAAICG4gAAAICG8gAAAICHAgAAAICHEgAAAICHIgAAAICHMgAAAICHQgAAAICHUgAAAICHYgAAAICHcgAAAICHggAAAICHkgAAAICHogAAAICHsgAAAICHwgAAAICH0gAAAICH4gAAAICH8gAAAICIAgAAAICIEgAAAICIIgAAAICIMgAAAICIQgAAAICIUgAAAICIYgAAAICIcgAAAICIggAAAICIkgAAAICIogAAAICIsgAAAICIwgAAAICI0gAAAICI4gAAAICI8gAAAICJAgAAAICJEgAAAICJIgAAAICJMgAAAICJQgAAAICJUgAAAICJYgAAAICJcgAAAICJggAAAICJkgAAAICJogAAAICJsgAAAICJwgAAAICJ0gAAAICJ4gAAAICJ8gAAAICKAgAAAICKEgAAAICKIgAAAICKMgAAAICKQgAAAICKUgAAAICKYgAAAICKcgAAAICKggAAAICKkgAAAICKogAAAICKsgAAAICKwgAAAICK0gAAAICK4gAAAICK8gAAAICLAgAAAICLEgAAAICLIgAAAICLMgAAAICLQgAAAICLUgAAAICLYgAAAICLcgAAAICLggAAAICLkgAAAICLogAAAICLsgAAAICLwgAAAICL0gAAAICL4gAAAICL8gAAAICMAgAAAICMEgAAAICMIgAAAICMMgAAAICMQgAAAICMUgAAAICMYgAAAICMcgAAAICMggAAAICMkgAAAICMogAAAICMsgAAAICMwgAAAICM0gAAAICM4gAAAICM8gAAAICNAgAAAICNEgAAAICNIgAAAICNMgAAAICNQgAAAICNUgAAAICNYgAAAICNcgAAAICNggAAAICNkgAAAICNogAAAICNsgAAAICNwgAAAICN0gAAAICN4gAAAICN8gAAAICOAgAAAICOEgAAAICOIgAAAICOMgAAAICOQgAAAICOUgAAAICOYgAAAICOcgAAAICOggAAAICOkgAAAICOogAAAICOsgAAAICOwgAAAICO0gAAAICO4gAAAICO8gAAAICPAgAAAICPEgAAAICPIgAAAICPMgAAAICPQgAAAICPUgAAAICPYgAAAICPcgAAAICPggAAAICPkgAAAICPogAAAICPsgAAAICPwgAAAICP0gAAAICP4gAAAICP8gAAAICAAhAAAICAEhAAAICAIhAAAICAMhAAAICAQhAAAICAUhAAAICAYhAAAICAchAAAICAghAAAICAkhAAAICAohAAAICAshAAAICAwhAAAICA0hAAAICA4hAAAICA8hAAAICBAhAAAICBEhAAAICBIhAAAICBMhAAAICBQhAAAICBUhAAAICBYhAAAICBchAAAICBghAAAICBkhAAAICBohAAAICBshAAAICBwhAAAICB0hAAAICB4hAAAICB8hAAAICCAhAAAICCEhAAAICCIhAAAICCMhAAAICCQhAAAICCUhAAAICCYhAAAICCchAAAICCghAAAICCkhAAAICCohAAAICCshAAAICCwhAAAICC0hAAAICC4hAAAICC8hAAAICDAhAAAICDEhAAAICDIhAAAICDMhAAAICDQhAAAICDUhAAAICDYhAAAICDchAAAICDghAAAICDkhAAAICDohAAAICDshAAAICDwhAAAICD0hAAAICD4hAAAICD8hAAAICEAhAAAICEEhAAAICEIhAAAICEMhAAAICEQhAAAICEUhAAAICEYhAAAICEchAAAICEghAAAICEkhAAAICEohAAAICEshAAAICEwhAAAICE0hAAAICE4hAAAICE8hAAAICFAhAAAICFEhAAAICFIhAAAICFMhAAAICFQhAAAICFUhAAAICFYhAAAICFchAAAICFghAAAICFkhAAAICFohAAAICFshAAAICFwhAAAICF0hAAAICF4hAAAICF8hAAAICGAhAAAICGEhAAAICGIhAAAICGMhAAAICGQhAAAICGUhAAAICGYhAAAICGchAAAICGghAAAICGkhAAAICGohAAAICGshAAAICGwhAAAICG0hAAAICG4hAAAICG8hAAAICHAhAAAICHEhAAAICHIhAAAICHMhAAAICHQhAAAICHUhAAAICHYhAAAICHchAAAICHghAAAICHkhAAAICHohAAAICHshAAAICHwhAAAICH0hAAAICH4hAAAICH8hAAAICIAhAAAICIEhAAAICIIhAAAICIMhAAAICIQhAAAICIUhAAAICIYhAAAICIchAAAICIghAAAICIkhAAAICIohAAAICIshAAAICIwhAAAICI0hAAAICI4hAAAICI8hAAAICJAhAAAICJEhAAAICJIhAAAICJMhAAAICJQhAAAICJUhAAAICJYhAAAICJchAAAICJghAAAICJkhAAAICJohAAAICJshAAAICJwhAAAICJ0hAAAICJ4hAAAICJ8hAAAICKAhAAAICKEhAAAICKIhAAAICKMhAAAICKQhAAAICKUhAAAICKYhAAAICKchAAAICKghAAAICKkhAAAICKohAAAICKshAAAICKwhAAAICK0hAAAICK4hAAAICK8hAAAICLAhAAAICLEhAAAICLIhAAAICLMhAAAICLQhAAAICLUhAAAICLYhAAAICLchAAAICLghAAAICLkhAAAICLohAAAICLshAAAICLwhAAAICL0hAAAICL4hAAAICL8hAAAICMAhAAAICMEhAAAICMIhAAAICMMhAAAICMQhAAAICMUhAAAICMYhAAAICMchAAAICMghAAAICMkhAAAICMohAAAICMshAAAICMwhAAAICM0hAAAICM4hAAAICM8hAAAICNAhAAAICNEhAAAICNIhAAAICNMhAAAICNQhAAAICNUhAAAICNYhAAAICNchAAAICNghAAAICNkhAAAICNohAAAICNshAAAICNwhAAAICN0hAAAICN4hAAAICN8hAAAICOAhAAAICOEhAAAICOIhAAAICOMhAAAICOQhAAAICOUhAAAICOYhAAAICOchAAAICOghAAAICOkhAAAICOohAAAICOshAAAICOwhAAAICO0hAAAICO4hAAAICO8hAAAICPAhAAAICPEhAAAICPIhAAAICPMhAAAICPQhAAAICPUhAAAICPYhAAAICPchAAAICPghAAAICPkhAAAICPohAAAICPshAAAICPwhAAAICP0hAAAICP4hAAAICP8hAAAICAAiAAAICAEiAAAICAIiAAAICAMiAAAICAQiAAAICAUiAAAICAYiAAAICAciAAAICAgiAAAICAkiAAAICAoiAAAICAsiAAAICAwiAAAICA0iAAAICA4iAAAICA8iAAAICBAiAAAICBEiAAAICBIiAAAICBMiAAAICBQiAAAICBUiAAAICBYiAAAICBciAAAICBgiAAAICBkiAAAICBoiAAAICBsiAAAICBwiAAAICB0iAAAICB4iAAAICB8iAAAICCAiAAAICCEiAAAICCIiAAAICCMiAAAICCQiAAAICCUiAAAICCYiAAAICCciAAAICCgiAAAICCkiAAAICCoiAAAICCsiAAAICCwiAAAICC0iAAAICC4iAAAICC8iAAAICDAiAAAICDEiAAAICDIiAAAICDMiAAAICDQiAAAICDUiAAAICDYiAAAICDciAAAICDgiAAAICDkiAAAICDoiAAAICDsiAAAICDwiAAAICD0iAAAICD4iAAAICD8iAAAICEAiAAAICEEiAAAICEIiAAAICEMiAAAICEQiAAAICEUiAAAICEYiAAAICEciAAAICEgiAAAICEkiAAAICEoiAAAICEsiAAAICEwiAAAICE0iAAAICE4iAAAICE8iAAAICFAiAAAICFEiAAAICFIiAAAICFMiAAAICFQiAAAICFUiAAAICFYiAAAICFciAAAICFgiAAAICFkiAAAICFoiAAAICFsiAAAICFwiAAAICF0iAAAICF4iAAAICF8iAAAICGAiAAAICGEiAAAICGIiAAAICGMiAAAICGQiAAAICGUiAAAICGYiAAAICGciAAAICGgiAAAICGkiAAAICGoiAAAICGsiAAAICGwiAAAICG0iAAAICG4iAAAICG8iAAAICHAiAAAICHEiAAAICHIiAAAICHMiAAAICHQiAAAICHUiAAAICHYiAAAICHciAAAICHgiAAAICHkiAAAICHoiAAAICHsiAAAICHwiAAAICH0iAAAICH4iAAAICH8iAAAICIAiAAAICIEiAAAICIIiAAAICIMiAAAICIQiAAAICIUiAAAICIYiAAAICIciAAAICIgiAAAICIkiAAAICIoiAAAICIsiAAAICIwiAAAICI0iAAAICI4iAAAICI8iAAAICJAiAAAICJEiAAAICJIiAAAICJMiAAAICJQiAAAICJUiAAAICJYiAAAICJciAAAICJgiAAAICJkiAAAICJoiAAAICJsiAAAICJwiAAAICJ0iAAAICJ4iAAAICJ8iAAAICKAiAAAICKEiAAAICKIiAAAICKMiAAAICKQiAAAICKUiAAAICKYiAAAICKciAAAICKgiAAAICKkiAAAICKoiAAAICKsiAAAICKwiAAAICK0iAAAICK4iAAAICK8iAAAICLAiAAAICLEiAAAICLIiAAAICLMiAAAICLQiAAAICLUiAAAICLYiAAAICLciAAAICLgiAAAICLkiAAAICLoiAAAICLsiAAAICLwiAAAICL0iAAAICL4iAAAICL8iAAAICMAiAAAICMEiAAAICMIiAAAICMMiAAAICMQiAAAICMUiAAAICMYiAAAICMciAAAICMgiAAAICMkiAAAICMoiAAAICMsiAAAICMwiAAAICM0iAAAICM4iAAAICM8iAAAICNAiAAAICNEiAAAICNIiAAAICNMiAAAICNQiAAAICNUiAAAICNYiAAAICNciAAAICNgiAAAICNkiAAAICNoiAAAICNsiAAAICNwiAAAICN0iAAAICN4iAAAICN8iAAAICOAiAAAICOEiAAAICOIiAAAICOMiAAAICOQiAAAICOUiAAAICOYiAAAICOciAAAICOgiAAAICOkiAAAICOoiAAAICOsiAAAICOwiAAAICO0iAAAICO4iAAAICO8iAAAICPAiAAAICPEiAAAICPIiAAAICPMiAAAICPQiAAAICPUiAAAICPYiAAAICPciAAAICPgiAAAICPkiAAAICPoiAAAICPsiAAAICPwiAAAICP0iAAAICP4iAAAICP8iAAAICAAjAAAICAEjAAAICAIjAAAICAMjAAAICAQjAAAICAUjAAAICAYjAAAICAcjAAAICAgjAAAICAkjAAAICAojAAAICAsjAAAICAwjAAAICA0jAAAICA4jAAAICA8jAAAICBAjAAAICBEjAAAICBIjAAAICBMjAAAICBQjAAAICBUjAAAICBYjAAAICBcjAAAICBgjAAAICBkjAAAICBojAAAICBsjAAAICBwjAAAICB0jAAAICB4jAAAICB8jAAAICCAjAAAICCEjAAAICCIjAAAICCMjAAAICCQjAAAICCUjAAAICCYjAAAICCcjAAAICCgjAAAICCkjAAAICCojAAAICCsjAAAICCwjAAAICC0jAAAICC4jAAAICC8jAAAICDAjAAAICDEjAAAICDIjAAAICDMjAAAICDQjAAAICDUjAAAICDYjAAAICDcjAAAICDgjAAAICDkjAAAICDojAAAICDsjAAAICDwjAAAICD0jAAAICD4jAAAICD8jAAAICEAjAAAICEEjAAAICEIjAAAICEMjAAAICEQjAAAICEUjAAAICEYjAAAICEcjAAAICEgjAAAICEkjAAAICEojAAAICEsjAAAICEwjAAAICE0jAAAICE4jAAAICE8jAAAICFAjAAAICFEjAAAICFIjAAAICFMjAAAICFQjAAAICFUjAAAICFYjAAAICFcjAAAICFgjAAAICFkjAAAICFojAAAICFsjAAAICFwjAAAICF0jAAAICF4jAAAICF8jAAAICGAjAAAICGEjAAAICGIjAAAICGMjAAAICGQjAAAICGUjAAAICGYjAAAICGcjAAAICGgjAAAICGkjAAAICGojAAAICGsjAAAICGwjAAAICG0jAAAICG4jAAAICG8jAAAICHAjAAAICHEjAAAICHIjAAAICHMjAAAICHQjAAAICHUjAAAICHYjAAAICHcjAAAICHgjAAAICHkjAAAICHojAAAICHsjAAAICHwjAAAICH0jAAAICH4jAAAICH8jAAAICIAjAAAICIEjAAAICIIjAAAICIMjAAAICIQjAAAICIUjAAAICIYjAAAICIcjAAAICIgjAAAICIkjAAAICIojAAAICIsjAAAICIwjAAAICI0jAAAICI4jAAAICI8jAAAICJAjAAAICJEjAAAICJIjAAAICJMjAAAICJQjAAAICJUjAAAICJYjAAAICJcjAAAICJgjAAAICJkjAAAICJojAAAICJsjAAAICJwjAAAICJ0jAAAICJ4jAAAICJ8jAAAICKAjAAAICKEjAAAICKIjAAAICKMjAAAICKQjAAAICKUjAAAICKYjAAAICKcjAAAICKgjAAAICKkjAAAICKojAAAICKsjAAAICKwjAAAICK0jAAAICK4jAAAICK8jAAAICLAjAAAICLEjAAAICLIjAAAICLMjAAAICLQjAAAICLUjAAAICLYjAAAICLcjAAAICLgjAAAICLkjAAAICLojAAAICLsjAAAICLwjAAAICL0jAAAICL4jAAAICL8jAAAICMAjAAAICMEjAAAICMIjAAAICMMjAAAICMQjAAAICMUjAAAICMYjAAAICMcjAAAICMgjAAAICMkjAAAICMojAAAICMsjAAAICMwjAAAICM0jAAAICM4jAAAICM8jAAAICNAjAAAICNEjAAAICNIjAAAICNMjAAAICNQjAAAICNUjAAAICNYjAAAICNcjAAAICNgjAAAICNkjAAAICNojAAAICNsjAAAICNwjAAAICN0jAAAICN4jAAAICN8jAAAICOAjAAAICOEjAAAICOIjAAAICOMjAAAICOQjAAAICOUjAAAICOYjAAAICOcjAAAICOgjAAAICOkjAAAICOojAAAICOsjAAAICOwjAAAICO0jAAAICO4jAAAICO8jAAAICPAjAAAICPEjAAAICPIjAAAICPMjAAAICPQjAAAICPUjAAAICPYjAAAICPcjAAAICPgjAAAICPkjAAAICPojAAAICPsjAAAICPwjAAAICP0jAAAICP4jAAAICP8jAAAICAAkAAAICAEkAAAICAIkAAAICAMkAAAICAQkAAAICAUkAAAICAYkAAAICAckAAAICAgkAAAICAkkAAAICAokAAAICAskAAAICAwkAAAICA0kAAAICA4kAAAICA8kAAAICBAkAAAICBEkAAAICBIkAAAICBMkAAAICBQkAAAICBUkAAAICBYkAAAICBckAAAICBgkAAAICBkkAAAICBokAAAICBskAAAICBwkAAAICB0kAAAICB4kAAAICB8kAAAICCAkAAAICCEkAAAICCIkAAAICCMkAAAICCQkAAAICCUkAAAICCYkAAAICCckAAAICCgkAAAICCkkAAAICCokAAAICCskAAAICCwkAAAICC0kAAAICC4kAAAICC8kAAAICDAkAAAICDEkAAAICDIkAAAICDMkAAAICDQkAAAICDUkAAAICDYkAAAICDckAAAICDgkAAAICDkkAAAICDokAAAICDskAAAICDwkAAAICD0kAAAICD4kAAAICD8kAAAICEAkAAAICEEkAAAICEIkAAAICEMkAAAICEQkAAAICEUkAAAICEYkAAAICEckAAAICEgkAAAICEkkAAAICEokAAAICEskAAAICEwkAAAICE0kAAAICE4kAAAICE8kAAAICFAkAAAICFEkAAAICFIkAAAICFMkAAAICFQkAAAICFUkAAAICFYkAAAICFckAAAICFgkAAAICFkkAAAICFokAAAICFskAAAICFwkAAAICF0kAAAICF4kAAAICF8kAAAICGAkAAAICGEkAAAICGIkAAAICGMkAAAICGQkAAAICGUkAAAICGYkAAAICGckAAAICGgkAAAICGkkAAAICGokAAAICGskAAAICGwkAAAICG0kAAAICG4kAAAICG8kAAAICHAkAAAICHEkAAAICHIkAAAICHMkAAAICHQkAAAICHUkAAAICHYkAAAICHckAAAICHgkAAAICHkkAAAICHokAAAICHskAAAICHwkAAAICH0kAAAICH4kAAAICH8kAAAICIAkAAAICIEkAAAICIIkAAAICIMkAAAICIQkAAAICIUkAAAICIYkAAAICIckAAAICIgkAAAICIkkAAAICIokAAAICIskAAAICIwkAAAICI0kAAAICI4kAAAICI8kAAAICJAkAAAICJEkAAAICJIkAAAICJMkAAAICJQkAAAICJUkAAAICJYkAAAICJckAAAICJgkAAAICJkkAAAICJokAAAICJskAAAICJwkAAAICJ0kAAAICJ4kAAAICJ8kAAAICKAkAAAICKEkAAAICKIkAAAICKMkAAAICKQkAAAICKUkAAAICKYkAAAICKckAAAICKgkAAAICKkkAAAICKokAAAICKskAAAICKwkAAAICK0kAAAICK4kAAAICK8kAAAICLAkAAAICLEkAAAICLIkAAAICLMkAAAICLQkAAAICLUkAAAICLYkAAAICLckAAAICLgkAAAICLkkAAAICLokAAAICLskAAAICLwkAAAICL0kAAAICL4kAAAICL8kAAAICMAkAAAICMEkAAAICMIkAAAICMMkAAAICMQkAAAICMUkAAAICMYkAAAICMckAAAICMgkAAAICMkkAAAICMokAAAICMskAAAICMwkAAAICM0kAAAICM4kAAAICM8kAAAICNAkAAAICNEkAAAICNIkAAAICNMkAAAICNQkAAAICNUkAAAICNYkAAAICNckAAAICNgkAAAICNkkAAAICNokAAAICNskAAAICNwkAAAICN0kAAAICN4kAAAICN8kAAAICOAkAAAICOEkAAAICOIkAAAICOMkAAAICOQkAAAICOUkAAAICOYkAAAICOckAAAICOgkAAAICOkkAAAICOokAAAICOskAAAICOwkAAAICO0kAAAICO4kAAAICO8kAAAICPAkAAAICPEkAAAICPIkAAAICPMkAAAICPQkAAAICPUkAAAICPYkAAAICPckAAAICPgkAAAICPkkAAAICPokAAAICPskAAAICPwkAAAICP0kAAAICP4kAAAICP8kAAAICAAlAAAICAElAAAICAIlAAAICAMlAAAICAQlAAAICAUlAAAICAYlAAAICAclAAAICAglAAAICAklAAAICAolAAAICAslAAAICAwlAAAICA0lAAAICA4lAAAICA8lAAAICBAlAAAICBElAAAICBIlAAAICBMlAAAICBQlAAAICBUlAAAICBYlAAAICBclAAAICBglAAAICBklAAAICBolAAAICBslAAAICBwlAAAICB0lAAAICB4lAAAICB8lAAAICCAlAAAICCElAAAICCIlAAAICCMlAAAICCQlAAAICCUlAAAICCYlAAAICCclAAAICCglAAAICCklAAAICColAAAICCslAAAICCwlAAAICC0lAAAICC4lAAAICC8lAAAICDAlAAAICDElAAAICDIlAAAICDMlAAAICDQlAAAICDUlAAAICDYlAAAICDclAAAICDglAAAICDklAAAICDolAAAICDslAAAICDwlAAAICD0lAAAICD4lAAAICD8lAAAICEAlAAAICEElAAAICEIlAAAICEMlAAAICEQlAAAICEUlAAAICEYlAAAICEclAAAICEglAAAICEklAAAICEolAAAICEslAAAICEwlAAAICE0lAAAICE4lAAAICE8lAAAICFAlAAAICFElAAAICFIlAAAICFMlAAAICFQlAAAICFUlAAAICFYlAAAICFclAAAICFglAAAICFklAAAICFolAAAICFslAAAICFwlAAAICF0lAAAICF4lAAAICF8lAAAICGAlAAAICGElAAAICGIlAAAICGMlAAAICGQlAAAICGUlAAAICGYlAAAICGclAAAICGglAAAICGklAAAICGolAAAICGslAAAICGwlAAAICG0lAAAICG4lAAAICG8lAAAICHAlAAAICHElAAAICHIlAAAICHMlAAAICHQlAAAICHUlAAAICHYlAAAICHclAAAICHglAAAICHklAAAICHolAAAICHslAAAICHwlAAAICH0lAAAICH4lAAAICH8lAAAICIAlAAAICIElAAAICIIlAAAICIMlAAAICIQlAAAICIUlAAAICIYlAAAICIclAAAICIglAAAICIklAAAICIolAAAICIslAAAICIwlAAAICI0lAAAICI4lAAAICI8lAAAICJAlAAAICJElAAAICJIlAAAICJMlAAAICJQlAAAICJUlAAAICJYlAAAICJclAAAICJglAAAICJklAAAICJolAAAICJslAAAICJwlAAAICJ0lAAAICJ4lAAAICJ8lAAAICKAlAAAICKElAAAICKIlAAAICKMlAAAICKQlAAAICKUlAAAICKYlAAAICKclAAAICKglAAAICKklAAAICKolAAAICKslAAAICKwlAAAICK0lAAAICK4lAAAICK8lAAAICLAlAAAICLElAAAICLIlAAAICLMlAAAICLQlAAAICLUlAAAICLYlAAAICLclAAAICLglAAAICLklAAAICLolAAAICLslAAAICLwlAAAICL0lAAAICL4lAAAICL8lAAAICMAlAAAICMElAAAICMIlAAAICMMlAAAICMQlAAAICMUlAAAICMYlAAAICMclAAAICMglAAAICMklAAAICMolAAAICMslAAAICMwlAAAICM0lAAAICM4lAAAICM8lAAAICNAlAAAICNElAAAICNIlAAAICNMlAAAICNQlAAAICNUlAAAICNYlAAAICNclAAAICNglAAAICNklAAAICNolAAAICNslAAAICNwlAAAICN0lAAAICN4lAAAICN8lAAAICOAlAAAICOElAAAICOIlAAAICOMlAAAICOQlAAAICOUlAAAICOYlAAAICOclAAAICOglAAAICOklAAAICOolAAAICOslAAAICOwlAAAICO0lAAAICO4lAAAICO8lAAAICPAlAAAICPElAAAICPIlAAAICPMlAAAICPQlAAAICPUlAAAICPYlAAAICPclAAAICPglAAAICPklAAAICPolAAAICPslAAAICPwlAAAICP0lAAAICP4lAAAICP8lAAAICAAmAAAICAEmAAAICAImAAAICAMmAAAICAQmAAAICAUmAAAICAYmAAAICAcmAAAICAgmAAAICAkmAAAICAomAAAICAsmAAAICAwmAAAICA0mAAAICA4mAAAICA8mAAAICBAmAAAICBEmAAAICBImAAAICBMmAAAICBQmAAAICBUmAAAICBYmAAAICBcmAAAICBgmAAAICBkmAAAICBomAAAICBsmAAAICBwmAAAICB0mAAAICB4mAAAICB8mAAAICCAmAAAICCEmAAAICCImAAAICCMmAAAICCQmAAAICCUmAAAICCYmAAAICCcmAAAICCgmAAAICCkmAAAICComAAAICCsmAAAICCwmAAAICC0mAAAICC4mAAAICC8mAAAICDAmAAAICDEmAAAICDImAAAICDMmAAAICDQmAAAICDUmAAAICDYmAAAICDcmAAAICDgmAAAICDkmAAAICDomAAAICDsmAAAICDwmAAAICD0mAAAICD4mAAAICD8mAAAICEAmAAAICEEmAAAICEImAAAICEMmAAAICEQmAAAICEUmAAAICEYmAAAICEcmAAAICEgmAAAICEkmAAAICEomAAAICEsmAAAICEwmAAAICE0mAAAICE4mAAAICE8mAAAICFAmAAAICFEmAAAICFImAAAICFMmAAAICFQmAAAICFUmAAAICFYmAAAICFcmAAAICFgmAAAICFkmAAAICFomAAAICFsmAAAICFwmAAAICF0mAAAICF4mAAAICF8mAAAICGAmAAAICGEmAAAICGImAAAICGMmAAAICGQmAAAICGUmAAAICGYmAAAICGcmAAAICGgmAAAICGkmAAAICGomAAAICGsmAAAICGwmAAAICG0mAAAICG4mAAAICG8mAAAICHAmAAAICHEmAAAICHImAAAICHMmAAAICHQmAAAICHUmAAAICHYmAAAICHcmAAAICHgmAAAICHkmAAAICHomAAAICHsmAAAICHwmAAAICH0mAAAICH4mAAAICH8mAAAICIAmAAAICIEmAAAICIImAAAICIMmAAAICIQmAAAICIUmAAAICIYmAAAICIcmAAAICIgmAAAICIkmAAAICIomAAAICIsmAAAICIwmAAAICI0mAAAICI4mAAAICI8mAAAICJAmAAAICJEmAAAICJImAAAICJMmAAAICJQmAAAICJUmAAAICJYmAAAICJcmAAAICJgmAAAICJkmAAAICJomAAAICJsmAAAICJwmAAAICJ0mAAAICJ4mAAAICJ8mAAAICKAmAAAICKEmAAAICKImAAAICKMmAAAICKQmAAAICKUmAAAICKYmAAAICKcmAAAICKgmAAAICKkmAAAICKomAAAICKsmAAAICKwmAAAICK0mAAAICK4mAAAICK8mAAAICLAmAAAICLEmAAAICLImAAAICLMmAAAICLQmAAAICLUmAAAICLYmAAAICLcmAAAICLgmAAAICLkmAAAICLomAAAICLsmAAAICLwmAAAICL0mAAAICL4mAAAICL8mAAAICMAmAAAICMEmAAAICMImAAAICMMmAAAICMQmAAAICMUmAAAICMYmAAAICMcmAAAICMgmAAAICMkmAAAICMomAAAICMsmAAAICMwmAAAICM0mAAAICM4mAAAICM8mAAAICNAmAAAICNEmAAAICNImAAAICNMmAAAICNQmAAAICNUmAAAICNYmAAAICNcmAAAICNgmAAAICNkmAAAICNomAAAICNsmAAAICNwmAAAICN0mAAAICN4mAAAICN8mAAAICOAmAAAICOEmAAAICOImAAAICOMmAAAICOQmAAAICOUmAAAICOYmAAAICOcmAAAICOgmAAAICOkmAAAICOomAAAICOsmAAAICOwmAAAICO0mAAAICO4mAAAICO8mAAAICPAmAAAICPEmAAAICPImAAAICPMmAAAICPQmAAAICPUmAAAICPYmAAAICPcmAAAICPgmAAAICPkmAAAICPomAAAICPsmAAAICPwmAAAICP0mAAAICP4mAAAICP8mAAAICAAnAAAICAEnAAAICAInAAAICAMnAAAICAQnAAAICAUnAAAICAYnAAAICAcnAAAICAgnAAAICAknAAAICAonAAAICAsnAAAICAwnAAAICA0nAAAICA4nAAAICA8nAAAL", "AAEAAAD/////AQAAAAAAAAAQAQAAABAnAAAICAAAAAAICAEAAAAICAIAAAAICAMAAAAICAQAAAAICAUAAAAICAYAAAAICAcAAAAICAgAAAAICAkAAAAICAoAAAAICAsAAAAICAwAAAAICA0AAAAICA4AAAAICA8AAAAICBAAAAAICBEAAAAICBIAAAAICBMAAAAICBQAAAAICBUAAAAICBYAAAAICBcAAAAICBgAAAAICBkAAAAICBoAAAAICBsAAAAICBwAAAAICB0AAAAICB4AAAAICB8AAAAICCAAAAAICCEAAAAICCIAAAAICCMAAAAICCQAAAAICCUAAAAICCYAAAAICCcAAAAICCgAAAAICCkAAAAICCoAAAAICCsAAAAICCwAAAAICC0AAAAICC4AAAAICC8AAAAICDAAAAAICDEAAAAICDIAAAAICDMAAAAICDQAAAAICDUAAAAICDYAAAAICDcAAAAICDgAAAAICDkAAAAICDoAAAAICDsAAAAICDwAAAAICD0AAAAICD4AAAAICD8AAAAICEAAAAAICEEAAAAICEIAAAAICEMAAAAICEQAAAAICEUAAAAICEYAAAAICEcAAAAICEgAAAAICEkAAAAICEoAAAAICEsAAAAICEwAAAAICE0AAAAICE4AAAAICE8AAAAICFAAAAAICFEAAAAICFIAAAAICFMAAAAICFQAAAAICFUAAAAICFYAAAAICFcAAAAICFgAAAAICFkAAAAICFoAAAAICFsAAAAICFwAAAAICF0AAAAICF4AAAAICF8AAAAICGAAAAAICGEAAAAICGIAAAAICGMAAAAICGQAAAAICGUAAAAICGYAAAAICGcAAAAICGgAAAAICGkAAAAICGoAAAAICGsAAAAICGwAAAAICG0AAAAICG4AAAAICG8AAAAICHAAAAAICHEAAAAICHIAAAAICHMAAAAICHQAAAAICHUAAAAICHYAAAAICHcAAAAICHgAAAAICHkAAAAICHoAAAAICHsAAAAICHwAAAAICH0AAAAICH4AAAAICH8AAAAICIAAAAAICIEAAAAICIIAAAAICIMAAAAICIQAAAAICIUAAAAICIYAAAAICIcAAAAICIgAAAAICIkAAAAICIoAAAAICIsAAAAICIwAAAAICI0AAAAICI4AAAAICI8AAAAICJAAAAAICJEAAAAICJIAAAAICJMAAAAICJQAAAAICJUAAAAICJYAAAAICJcAAAAICJgAAAAICJkAAAAICJoAAAAICJsAAAAICJwAAAAICJ0AAAAICJ4AAAAICJ8AAAAICKAAAAAICKEAAAAICKIAAAAICKMAAAAICKQAAAAICKUAAAAICKYAAAAICKcAAAAICKgAAAAICKkAAAAICKoAAAAICKsAAAAICKwAAAAICK0AAAAICK4AAAAICK8AAAAICLAAAAAICLEAAAAICLIAAAAICLMAAAAICLQAAAAICLUAAAAICLYAAAAICLcAAAAICLgAAAAICLkAAAAICLoAAAAICLsAAAAICLwAAAAICL0AAAAICL4AAAAICL8AAAAICMAAAAAICMEAAAAICMIAAAAICMMAAAAICMQAAAAICMUAAAAICMYAAAAICMcAAAAICMgAAAAICMkAAAAICMoAAAAICMsAAAAICMwAAAAICM0AAAAICM4AAAAICM8AAAAICNAAAAAICNEAAAAICNIAAAAICNMAAAAICNQAAAAICNUAAAAICNYAAAAICNcAAAAICNgAAAAICNkAAAAICNoAAAAICNsAAAAICNwAAAAICN0AAAAICN4AAAAICN8AAAAICOAAAAAICOEAAAAICOIAAAAICOMAAAAICOQAAAAICOUAAAAICOYAAAAICOcAAAAICOgAAAAICOkAAAAICOoAAAAICOsAAAAICOwAAAAICO0AAAAICO4AAAAICO8AAAAICPAAAAAICPEAAAAICPIAAAAICPMAAAAICPQAAAAICPUAAAAICPYAAAAICPcAAAAICPgAAAAICPkAAAAICPoAAAAICPsAAAAICPwAAAAICP0AAAAICP4AAAAICP8AAAAICAABAAAICAEBAAAICAIBAAAICAMBAAAICAQBAAAICAUBAAAICAYBAAAICAcBAAAICAgBAAAICAkBAAAICAoBAAAICAsBAAAICAwBAAAICA0BAAAICA4BAAAICA8BAAAICBABAAAICBEBAAAICBIBAAAICBMBAAAICBQBAAAICBUBAAAICBYBAAAICBcBAAAICBgBAAAICBkBAAAICBoBAAAICBsBAAAICBwBAAAICB0BAAAICB4BAAAICB8BAAAICCABAAAICCEBAAAICCIBAAAICCMBAAAICCQBAAAICCUBAAAICCYBAAAICCcBAAAICCgBAAAICCkBAAAICCoBAAAICCsBAAAICCwBAAAICC0BAAAICC4BAAAICC8BAAAICDABAAAICDEBAAAICDIBAAAICDMBAAAICDQBAAAICDUBAAAICDYBAAAICDcBAAAICDgBAAAICDkBAAAICDoBAAAICDsBAAAICDwBAAAICD0BAAAICD4BAAAICD8BAAAICEABAAAICEEBAAAICEIBAAAICEMBAAAICEQBAAAICEUBAAAICEYBAAAICEcBAAAICEgBAAAICEkBAAAICEoBAAAICEsBAAAICEwBAAAICE0BAAAICE4BAAAICE8BAAAICFABAAAICFEBAAAICFIBAAAICFMBAAAICFQBAAAICFUBAAAICFYBAAAICFcBAAAICFgBAAAICFkBAAAICFoBAAAICFsBAAAICFwBAAAICF0BAAAICF4BAAAICF8BAAAICGABAAAICGEBAAAICGIBAAAICGMBAAAICGQBAAAICGUBAAAICGYBAAAICGcBAAAICGgBAAAICGkBAAAICGoBAAAICGsBAAAICGwBAAAICG0BAAAICG4BAAAICG8BAAAICHABAAAICHEBAAAICHIBAAAICHMBAAAICHQBAAAICHUBAAAICHYBAAAICHcBAAAICHgBAAAICHkBAAAICHoBAAAICHsBAAAICHwBAAAICH0BAAAICH4BAAAICH8BAAAICIABAAAICIEBAAAICIIBAAAICIMBAAAICIQBAAAICIUBAAAICIYBAAAICIcBAAAICIgBAAAICIkBAAAICIoBAAAICIsBAAAICIwBAAAICI0BAAAICI4BAAAICI8BAAAICJABAAAICJEBAAAICJIBAAAICJMBAAAICJQBAAAICJUBAAAICJYBAAAICJcBAAAICJgBAAAICJkBAAAICJoBAAAICJsBAAAICJwBAAAICJ0BAAAICJ4BAAAICJ8BAAAICKABAAAICKEBAAAICKIBAAAICKMBAAAICKQBAAAICKUBAAAICKYBAAAICKcBAAAICKgBAAAICKkBAAAICKoBAAAICKsBAAAICKwBAAAICK0BAAAICK4BAAAICK8BAAAICLABAAAICLEBAAAICLIBAAAICLMBAAAICLQBAAAICLUBAAAICLYBAAAICLcBAAAICLgBAAAICLkBAAAICLoBAAAICLsBAAAICLwBAAAICL0BAAAICL4BAAAICL8BAAAICMABAAAICMEBAAAICMIBAAAICMMBAAAICMQBAAAICMUBAAAICMYBAAAICMcBAAAICMgBAAAICMkBAAAICMoBAAAICMsBAAAICMwBAAAICM0BAAAICM4BAAAICM8BAAAICNABAAAICNEBAAAICNIBAAAICNMBAAAICNQBAAAICNUBAAAICNYBAAAICNcBAAAICNgBAAAICNkBAAAICNoBAAAICNsBAAAICNwBAAAICN0BAAAICN4BAAAICN8BAAAICOABAAAICOEBAAAICOIBAAAICOMBAAAICOQBAAAICOUBAAAICOYBAAAICOcBAAAICOgBAAAICOkBAAAICOoBAAAICOsBAAAICOwBAAAICO0BAAAICO4BAAAICO8BAAAICPABAAAICPEBAAAICPIBAAAICPMBAAAICPQBAAAICPUBAAAICPYBAAAICPcBAAAICPgBAAAICPkBAAAICPoBAAAICPsBAAAICPwBAAAICP0BAAAICP4BAAAICP8BAAAICAACAAAICAECAAAICAICAAAICAMCAAAICAQCAAAICAUCAAAICAYCAAAICAcCAAAICAgCAAAICAkCAAAICAoCAAAICAsCAAAICAwCAAAICA0CAAAICA4CAAAICA8CAAAICBACAAAICBECAAAICBICAAAICBMCAAAICBQCAAAICBUCAAAICBYCAAAICBcCAAAICBgCAAAICBkCAAAICBoCAAAICBsCAAAICBwCAAAICB0CAAAICB4CAAAICB8CAAAICCACAAAICCECAAAICCICAAAICCMCAAAICCQCAAAICCUCAAAICCYCAAAICCcCAAAICCgCAAAICCkCAAAICCoCAAAICCsCAAAICCwCAAAICC0CAAAICC4CAAAICC8CAAAICDACAAAICDECAAAICDICAAAICDMCAAAICDQCAAAICDUCAAAICDYCAAAICDcCAAAICDgCAAAICDkCAAAICDoCAAAICDsCAAAICDwCAAAICD0CAAAICD4CAAAICD8CAAAICEACAAAICEECAAAICEICAAAICEMCAAAICEQCAAAICEUCAAAICEYCAAAICEcCAAAICEgCAAAICEkCAAAICEoCAAAICEsCAAAICEwCAAAICE0CAAAICE4CAAAICE8CAAAICFACAAAICFECAAAICFICAAAICFMCAAAICFQCAAAICFUCAAAICFYCAAAICFcCAAAICFgCAAAICFkCAAAICFoCAAAICFsCAAAICFwCAAAICF0CAAAICF4CAAAICF8CAAAICGACAAAICGECAAAICGICAAAICGMCAAAICGQCAAAICGUCAAAICGYCAAAICGcCAAAICGgCAAAICGkCAAAICGoCAAAICGsCAAAICGwCAAAICG0CAAAICG4CAAAICG8CAAAICHACAAAICHECAAAICHICAAAICHMCAAAICHQCAAAICHUCAAAICHYCAAAICHcCAAAICHgCAAAICHkCAAAICHoCAAAICHsCAAAICHwCAAAICH0CAAAICH4CAAAICH8CAAAICIACAAAICIECAAAICIICAAAICIMCAAAICIQCAAAICIUCAAAICIYCAAAICIcCAAAICIgCAAAICIkCAAAICIoCAAAICIsCAAAICIwCAAAICI0CAAAICI4CAAAICI8CAAAICJACAAAICJECAAAICJICAAAICJMCAAAICJQCAAAICJUCAAAICJYCAAAICJcCAAAICJgCAAAICJkCAAAICJoCAAAICJsCAAAICJwCAAAICJ0CAAAICJ4CAAAICJ8CAAAICKACAAAICKECAAAICKICAAAICKMCAAAICKQCAAAICKUCAAAICKYCAAAICKcCAAAICKgCAAAICKkCAAAICKoCAAAICKsCAAAICKwCAAAICK0CAAAICK4CAAAICK8CAAAICLACAAAICLECAAAICLICAAAICLMCAAAICLQCAAAICLUCAAAICLYCAAAICLcCAAAICLgCAAAICLkCAAAICLoCAAAICLsCAAAICLwCAAAICL0CAAAICL4CAAAICL8CAAAICMACAAAICMECAAAICMICAAAICMMCAAAICMQCAAAICMUCAAAICMYCAAAICMcCAAAICMgCAAAICMkCAAAICMoCAAAICMsCAAAICMwCAAAICM0CAAAICM4CAAAICM8CAAAICNACAAAICNECAAAICNICAAAICNMCAAAICNQCAAAICNUCAAAICNYCAAAICNcCAAAICNgCAAAICNkCAAAICNoCAAAICNsCAAAICNwCAAAICN0CAAAICN4CAAAICN8CAAAICOACAAAICOECAAAICOICAAAICOMCAAAICOQCAAAICOUCAAAICOYCAAAICOcCAAAICOgCAAAICOkCAAAICOoCAAAICOsCAAAICOwCAAAICO0CAAAICO4CAAAICO8CAAAICPACAAAICPECAAAICPICAAAICPMCAAAICPQCAAAICPUCAAAICPYCAAAICPcCAAAICPgCAAAICPkCAAAICPoCAAAICPsCAAAICPwCAAAICP0CAAAICP4CAAAICP8CAAAICAADAAAICAEDAAAICAIDAAAICAMDAAAICAQDAAAICAUDAAAICAYDAAAICAcDAAAICAgDAAAICAkDAAAICAoDAAAICAsDAAAICAwDAAAICA0DAAAICA4DAAAICA8DAAAICBADAAAICBEDAAAICBIDAAAICBMDAAAICBQDAAAICBUDAAAICBYDAAAICBcDAAAICBgDAAAICBkDAAAICBoDAAAICBsDAAAICBwDAAAICB0DAAAICB4DAAAICB8DAAAICCADAAAICCEDAAAICCIDAAAICCMDAAAICCQDAAAICCUDAAAICCYDAAAICCcDAAAICCgDAAAICCkDAAAICCoDAAAICCsDAAAICCwDAAAICC0DAAAICC4DAAAICC8DAAAICDADAAAICDEDAAAICDIDAAAICDMDAAAICDQDAAAICDUDAAAICDYDAAAICDcDAAAICDgDAAAICDkDAAAICDoDAAAICDsDAAAICDwDAAAICD0DAAAICD4DAAAICD8DAAAICEADAAAICEEDAAAICEIDAAAICEMDAAAICEQDAAAICEUDAAAICEYDAAAICEcDAAAICEgDAAAICEkDAAAICEoDAAAICEsDAAAICEwDAAAICE0DAAAICE4DAAAICE8DAAAICFADAAAICFEDAAAICFIDAAAICFMDAAAICFQDAAAICFUDAAAICFYDAAAICFcDAAAICFgDAAAICFkDAAAICFoDAAAICFsDAAAICFwDAAAICF0DAAAICF4DAAAICF8DAAAICGADAAAICGEDAAAICGIDAAAICGMDAAAICGQDAAAICGUDAAAICGYDAAAICGcDAAAICGgDAAAICGkDAAAICGoDAAAICGsDAAAICGwDAAAICG0DAAAICG4DAAAICG8DAAAICHADAAAICHEDAAAICHIDAAAICHMDAAAICHQDAAAICHUDAAAICHYDAAAICHcDAAAICHgDAAAICHkDAAAICHoDAAAICHsDAAAICHwDAAAICH0DAAAICH4DAAAICH8DAAAICIADAAAICIEDAAAICIIDAAAICIMDAAAICIQDAAAICIUDAAAICIYDAAAICIcDAAAICIgDAAAICIkDAAAICIoDAAAICIsDAAAICIwDAAAICI0DAAAICI4DAAAICI8DAAAICJADAAAICJEDAAAICJIDAAAICJMDAAAICJQDAAAICJUDAAAICJYDAAAICJcDAAAICJgDAAAICJkDAAAICJoDAAAICJsDAAAICJwDAAAICJ0DAAAICJ4DAAAICJ8DAAAICKADAAAICKEDAAAICKIDAAAICKMDAAAICKQDAAAICKUDAAAICKYDAAAICKcDAAAICKgDAAAICKkDAAAICKoDAAAICKsDAAAICKwDAAAICK0DAAAICK4DAAAICK8DAAAICLADAAAICLEDAAAICLIDAAAICLMDAAAICLQDAAAICLUDAAAICLYDAAAICLcDAAAICLgDAAAICLkDAAAICLoDAAAICLsDAAAICLwDAAAICL0DAAAICL4DAAAICL8DAAAICMADAAAICMEDAAAICMIDAAAICMMDAAAICMQDAAAICMUDAAAICMYDAAAICMcDAAAICMgDAAAICMkDAAAICMoDAAAICMsDAAAICMwDAAAICM0DAAAICM4DAAAICM8DAAAICNADAAAICNEDAAAICNIDAAAICNMDAAAICNQDAAAICNUDAAAICNYDAAAICNcDAAAICNgDAAAICNkDAAAICNoDAAAICNsDAAAICNwDAAAICN0DAAAICN4DAAAICN8DAAAICOADAAAICOEDAAAICOIDAAAICOMDAAAICOQDAAAICOUDAAAICOYDAAAICOcDAAAICOgDAAAICOkDAAAICOoDAAAICOsDAAAICOwDAAAICO0DAAAICO4DAAAICO8DAAAICPADAAAICPEDAAAICPIDAAAICPMDAAAICPQDAAAICPUDAAAICPYDAAAICPcDAAAICPgDAAAICPkDAAAICPoDAAAICPsDAAAICPwDAAAICP0DAAAICP4DAAAICP8DAAAICAAEAAAICAEEAAAICAIEAAAICAMEAAAICAQEAAAICAUEAAAICAYEAAAICAcEAAAICAgEAAAICAkEAAAICAoEAAAICAsEAAAICAwEAAAICA0EAAAICA4EAAAICA8EAAAICBAEAAAICBEEAAAICBIEAAAICBMEAAAICBQEAAAICBUEAAAICBYEAAAICBcEAAAICBgEAAAICBkEAAAICBoEAAAICBsEAAAICBwEAAAICB0EAAAICB4EAAAICB8EAAAICCAEAAAICCEEAAAICCIEAAAICCMEAAAICCQEAAAICCUEAAAICCYEAAAICCcEAAAICCgEAAAICCkEAAAICCoEAAAICCsEAAAICCwEAAAICC0EAAAICC4EAAAICC8EAAAICDAEAAAICDEEAAAICDIEAAAICDMEAAAICDQEAAAICDUEAAAICDYEAAAICDcEAAAICDgEAAAICDkEAAAICDoEAAAICDsEAAAICDwEAAAICD0EAAAICD4EAAAICD8EAAAICEAEAAAICEEEAAAICEIEAAAICEMEAAAICEQEAAAICEUEAAAICEYEAAAICEcEAAAICEgEAAAICEkEAAAICEoEAAAICEsEAAAICEwEAAAICE0EAAAICE4EAAAICE8EAAAICFAEAAAICFEEAAAICFIEAAAICFMEAAAICFQEAAAICFUEAAAICFYEAAAICFcEAAAICFgEAAAICFkEAAAICFoEAAAICFsEAAAICFwEAAAICF0EAAAICF4EAAAICF8EAAAICGAEAAAICGEEAAAICGIEAAAICGMEAAAICGQEAAAICGUEAAAICGYEAAAICGcEAAAICGgEAAAICGkEAAAICGoEAAAICGsEAAAICGwEAAAICG0EAAAICG4EAAAICG8EAAAICHAEAAAICHEEAAAICHIEAAAICHMEAAAICHQEAAAICHUEAAAICHYEAAAICHcEAAAICHgEAAAICHkEAAAICHoEAAAICHsEAAAICHwEAAAICH0EAAAICH4EAAAICH8EAAAICIAEAAAICIEEAAAICIIEAAAICIMEAAAICIQEAAAICIUEAAAICIYEAAAICIcEAAAICIgEAAAICIkEAAAICIoEAAAICIsEAAAICIwEAAAICI0EAAAICI4EAAAICI8EAAAICJAEAAAICJEEAAAICJIEAAAICJMEAAAICJQEAAAICJUEAAAICJYEAAAICJcEAAAICJgEAAAICJkEAAAICJoEAAAICJsEAAAICJwEAAAICJ0EAAAICJ4EAAAICJ8EAAAICKAEAAAICKEEAAAICKIEAAAICKMEAAAICKQEAAAICKUEAAAICKYEAAAICKcEAAAICKgEAAAICKkEAAAICKoEAAAICKsEAAAICKwEAAAICK0EAAAICK4EAAAICK8EAAAICLAEAAAICLEEAAAICLIEAAAICLMEAAAICLQEAAAICLUEAAAICLYEAAAICLcEAAAICLgEAAAICLkEAAAICLoEAAAICLsEAAAICLwEAAAICL0EAAAICL4EAAAICL8EAAAICMAEAAAICMEEAAAICMIEAAAICMMEAAAICMQEAAAICMUEAAAICMYEAAAICMcEAAAICMgEAAAICMkEAAAICMoEAAAICMsEAAAICMwEAAAICM0EAAAICM4EAAAICM8EAAAICNAEAAAICNEEAAAICNIEAAAICNMEAAAICNQEAAAICNUEAAAICNYEAAAICNcEAAAICNgEAAAICNkEAAAICNoEAAAICNsEAAAICNwEAAAICN0EAAAICN4EAAAICN8EAAAICOAEAAAICOEEAAAICOIEAAAICOMEAAAICOQEAAAICOUEAAAICOYEAAAICOcEAAAICOgEAAAICOkEAAAICOoEAAAICOsEAAAICOwEAAAICO0EAAAICO4EAAAICO8EAAAICPAEAAAICPEEAAAICPIEAAAICPMEAAAICPQEAAAICPUEAAAICPYEAAAICPcEAAAICPgEAAAICPkEAAAICPoEAAAICPsEAAAICPwEAAAICP0EAAAICP4EAAAICP8EAAAICAAFAAAICAEFAAAICAIFAAAICAMFAAAICAQFAAAICAUFAAAICAYFAAAICAcFAAAICAgFAAAICAkFAAAICAoFAAAICAsFAAAICAwFAAAICA0FAAAICA4FAAAICA8FAAAICBAFAAAICBEFAAAICBIFAAAICBMFAAAICBQFAAAICBUFAAAICBYFAAAICBcFAAAICBgFAAAICBkFAAAICBoFAAAICBsFAAAICBwFAAAICB0FAAAICB4FAAAICB8FAAAICCAFAAAICCEFAAAICCIFAAAICCMFAAAICCQFAAAICCUFAAAICCYFAAAICCcFAAAICCgFAAAICCkFAAAICCoFAAAICCsFAAAICCwFAAAICC0FAAAICC4FAAAICC8FAAAICDAFAAAICDEFAAAICDIFAAAICDMFAAAICDQFAAAICDUFAAAICDYFAAAICDcFAAAICDgFAAAICDkFAAAICDoFAAAICDsFAAAICDwFAAAICD0FAAAICD4FAAAICD8FAAAICEAFAAAICEEFAAAICEIFAAAICEMFAAAICEQFAAAICEUFAAAICEYFAAAICEcFAAAICEgFAAAICEkFAAAICEoFAAAICEsFAAAICEwFAAAICE0FAAAICE4FAAAICE8FAAAICFAFAAAICFEFAAAICFIFAAAICFMFAAAICFQFAAAICFUFAAAICFYFAAAICFcFAAAICFgFAAAICFkFAAAICFoFAAAICFsFAAAICFwFAAAICF0FAAAICF4FAAAICF8FAAAICGAFAAAICGEFAAAICGIFAAAICGMFAAAICGQFAAAICGUFAAAICGYFAAAICGcFAAAICGgFAAAICGkFAAAICGoFAAAICGsFAAAICGwFAAAICG0FAAAICG4FAAAICG8FAAAICHAFAAAICHEFAAAICHIFAAAICHMFAAAICHQFAAAICHUFAAAICHYFAAAICHcFAAAICHgFAAAICHkFAAAICHoFAAAICHsFAAAICHwFAAAICH0FAAAICH4FAAAICH8FAAAICIAFAAAICIEFAAAICIIFAAAICIMFAAAICIQFAAAICIUFAAAICIYFAAAICIcFAAAICIgFAAAICIkFAAAICIoFAAAICIsFAAAICIwFAAAICI0FAAAICI4FAAAICI8FAAAICJAFAAAICJEFAAAICJIFAAAICJMFAAAICJQFAAAICJUFAAAICJYFAAAICJcFAAAICJgFAAAICJkFAAAICJoFAAAICJsFAAAICJwFAAAICJ0FAAAICJ4FAAAICJ8FAAAICKAFAAAICKEFAAAICKIFAAAICKMFAAAICKQFAAAICKUFAAAICKYFAAAICKcFAAAICKgFAAAICKkFAAAICKoFAAAICKsFAAAICKwFAAAICK0FAAAICK4FAAAICK8FAAAICLAFAAAICLEFAAAICLIFAAAICLMFAAAICLQFAAAICLUFAAAICLYFAAAICLcFAAAICLgFAAAICLkFAAAICLoFAAAICLsFAAAICLwFAAAICL0FAAAICL4FAAAICL8FAAAICMAFAAAICMEFAAAICMIFAAAICMMFAAAICMQFAAAICMUFAAAICMYFAAAICMcFAAAICMgFAAAICMkFAAAICMoFAAAICMsFAAAICMwFAAAICM0FAAAICM4FAAAICM8FAAAICNAFAAAICNEFAAAICNIFAAAICNMFAAAICNQFAAAICNUFAAAICNYFAAAICNcFAAAICNgFAAAICNkFAAAICNoFAAAICNsFAAAICNwFAAAICN0FAAAICN4FAAAICN8FAAAICOAFAAAICOEFAAAICOIFAAAICOMFAAAICOQFAAAICOUFAAAICOYFAAAICOcFAAAICOgFAAAICOkFAAAICOoFAAAICOsFAAAICOwFAAAICO0FAAAICO4FAAAICO8FAAAICPAFAAAICPEFAAAICPIFAAAICPMFAAAICPQFAAAICPUFAAAICPYFAAAICPcFAAAICPgFAAAICPkFAAAICPoFAAAICPsFAAAICPwFAAAICP0FAAAICP4FAAAICP8FAAAICAAGAAAICAEGAAAICAIGAAAICAMGAAAICAQGAAAICAUGAAAICAYGAAAICAcGAAAICAgGAAAICAkGAAAICAoGAAAICAsGAAAICAwGAAAICA0GAAAICA4GAAAICA8GAAAICBAGAAAICBEGAAAICBIGAAAICBMGAAAICBQGAAAICBUGAAAICBYGAAAICBcGAAAICBgGAAAICBkGAAAICBoGAAAICBsGAAAICBwGAAAICB0GAAAICB4GAAAICB8GAAAICCAGAAAICCEGAAAICCIGAAAICCMGAAAICCQGAAAICCUGAAAICCYGAAAICCcGAAAICCgGAAAICCkGAAAICCoGAAAICCsGAAAICCwGAAAICC0GAAAICC4GAAAICC8GAAAICDAGAAAICDEGAAAICDIGAAAICDMGAAAICDQGAAAICDUGAAAICDYGAAAICDcGAAAICDgGAAAICDkGAAAICDoGAAAICDsGAAAICDwGAAAICD0GAAAICD4GAAAICD8GAAAICEAGAAAICEEGAAAICEIGAAAICEMGAAAICEQGAAAICEUGAAAICEYGAAAICEcGAAAICEgGAAAICEkGAAAICEoGAAAICEsGAAAICEwGAAAICE0GAAAICE4GAAAICE8GAAAICFAGAAAICFEGAAAICFIGAAAICFMGAAAICFQGAAAICFUGAAAICFYGAAAICFcGAAAICFgGAAAICFkGAAAICFoGAAAICFsGAAAICFwGAAAICF0GAAAICF4GAAAICF8GAAAICGAGAAAICGEGAAAICGIGAAAICGMGAAAICGQGAAAICGUGAAAICGYGAAAICGcGAAAICGgGAAAICGkGAAAICGoGAAAICGsGAAAICGwGAAAICG0GAAAICG4GAAAICG8GAAAICHAGAAAICHEGAAAICHIGAAAICHMGAAAICHQGAAAICHUGAAAICHYGAAAICHcGAAAICHgGAAAICHkGAAAICHoGAAAICHsGAAAICHwGAAAICH0GAAAICH4GAAAICH8GAAAICIAGAAAICIEGAAAICIIGAAAICIMGAAAICIQGAAAICIUGAAAICIYGAAAICIcGAAAICIgGAAAICIkGAAAICIoGAAAICIsGAAAICIwGAAAICI0GAAAICI4GAAAICI8GAAAICJAGAAAICJEGAAAICJIGAAAICJMGAAAICJQGAAAICJUGAAAICJYGAAAICJcGAAAICJgGAAAICJkGAAAICJoGAAAICJsGAAAICJwGAAAICJ0GAAAICJ4GAAAICJ8GAAAICKAGAAAICKEGAAAICKIGAAAICKMGAAAICKQGAAAICKUGAAAICKYGAAAICKcGAAAICKgGAAAICKkGAAAICKoGAAAICKsGAAAICKwGAAAICK0GAAAICK4GAAAICK8GAAAICLAGAAAICLEGAAAICLIGAAAICLMGAAAICLQGAAAICLUGAAAICLYGAAAICLcGAAAICLgGAAAICLkGAAAICLoGAAAICLsGAAAICLwGAAAICL0GAAAICL4GAAAICL8GAAAICMAGAAAICMEGAAAICMIGAAAICMMGAAAICMQGAAAICMUGAAAICMYGAAAICMcGAAAICMgGAAAICMkGAAAICMoGAAAICMsGAAAICMwGAAAICM0GAAAICM4GAAAICM8GAAAICNAGAAAICNEGAAAICNIGAAAICNMGAAAICNQGAAAICNUGAAAICNYGAAAICNcGAAAICNgGAAAICNkGAAAICNoGAAAICNsGAAAICNwGAAAICN0GAAAICN4GAAAICN8GAAAICOAGAAAICOEGAAAICOIGAAAICOMGAAAICOQGAAAICOUGAAAICOYGAAAICOcGAAAICOgGAAAICOkGAAAICOoGAAAICOsGAAAICOwGAAAICO0GAAAICO4GAAAICO8GAAAICPAGAAAICPEGAAAICPIGAAAICPMGAAAICPQGAAAICPUGAAAICPYGAAAICPcGAAAICPgGAAAICPkGAAAICPoGAAAICPsGAAAICPwGAAAICP0GAAAICP4GAAAICP8GAAAICAAHAAAICAEHAAAICAIHAAAICAMHAAAICAQHAAAICAUHAAAICAYHAAAICAcHAAAICAgHAAAICAkHAAAICAoHAAAICAsHAAAICAwHAAAICA0HAAAICA4HAAAICA8HAAAICBAHAAAICBEHAAAICBIHAAAICBMHAAAICBQHAAAICBUHAAAICBYHAAAICBcHAAAICBgHAAAICBkHAAAICBoHAAAICBsHAAAICBwHAAAICB0HAAAICB4HAAAICB8HAAAICCAHAAAICCEHAAAICCIHAAAICCMHAAAICCQHAAAICCUHAAAICCYHAAAICCcHAAAICCgHAAAICCkHAAAICCoHAAAICCsHAAAICCwHAAAICC0HAAAICC4HAAAICC8HAAAICDAHAAAICDEHAAAICDIHAAAICDMHAAAICDQHAAAICDUHAAAICDYHAAAICDcHAAAICDgHAAAICDkHAAAICDoHAAAICDsHAAAICDwHAAAICD0HAAAICD4HAAAICD8HAAAICEAHAAAICEEHAAAICEIHAAAICEMHAAAICEQHAAAICEUHAAAICEYHAAAICEcHAAAICEgHAAAICEkHAAAICEoHAAAICEsHAAAICEwHAAAICE0HAAAICE4HAAAICE8HAAAICFAHAAAICFEHAAAICFIHAAAICFMHAAAICFQHAAAICFUHAAAICFYHAAAICFcHAAAICFgHAAAICFkHAAAICFoHAAAICFsHAAAICFwHAAAICF0HAAAICF4HAAAICF8HAAAICGAHAAAICGEHAAAICGIHAAAICGMHAAAICGQHAAAICGUHAAAICGYHAAAICGcHAAAICGgHAAAICGkHAAAICGoHAAAICGsHAAAICGwHAAAICG0HAAAICG4HAAAICG8HAAAICHAHAAAICHEHAAAICHIHAAAICHMHAAAICHQHAAAICHUHAAAICHYHAAAICHcHAAAICHgHAAAICHkHAAAICHoHAAAICHsHAAAICHwHAAAICH0HAAAICH4HAAAICH8HAAAICIAHAAAICIEHAAAICIIHAAAICIMHAAAICIQHAAAICIUHAAAICIYHAAAICIcHAAAICIgHAAAICIkHAAAICIoHAAAICIsHAAAICIwHAAAICI0HAAAICI4HAAAICI8HAAAICJAHAAAICJEHAAAICJIHAAAICJMHAAAICJQHAAAICJUHAAAICJYHAAAICJcHAAAICJgHAAAICJkHAAAICJoHAAAICJsHAAAICJwHAAAICJ0HAAAICJ4HAAAICJ8HAAAICKAHAAAICKEHAAAICKIHAAAICKMHAAAICKQHAAAICKUHAAAICKYHAAAICKcHAAAICKgHAAAICKkHAAAICKoHAAAICKsHAAAICKwHAAAICK0HAAAICK4HAAAICK8HAAAICLAHAAAICLEHAAAICLIHAAAICLMHAAAICLQHAAAICLUHAAAICLYHAAAICLcHAAAICLgHAAAICLkHAAAICLoHAAAICLsHAAAICLwHAAAICL0HAAAICL4HAAAICL8HAAAICMAHAAAICMEHAAAICMIHAAAICMMHAAAICMQHAAAICMUHAAAICMYHAAAICMcHAAAICMgHAAAICMkHAAAICMoHAAAICMsHAAAICMwHAAAICM0HAAAICM4HAAAICM8HAAAICNAHAAAICNEHAAAICNIHAAAICNMHAAAICNQHAAAICNUHAAAICNYHAAAICNcHAAAICNgHAAAICNkHAAAICNoHAAAICNsHAAAICNwHAAAICN0HAAAICN4HAAAICN8HAAAICOAHAAAICOEHAAAICOIHAAAICOMHAAAICOQHAAAICOUHAAAICOYHAAAICOcHAAAICOgHAAAICOkHAAAICOoHAAAICOsHAAAICOwHAAAICO0HAAAICO4HAAAICO8HAAAICPAHAAAICPEHAAAICPIHAAAICPMHAAAICPQHAAAICPUHAAAICPYHAAAICPcHAAAICPgHAAAICPkHAAAICPoHAAAICPsHAAAICPwHAAAICP0HAAAICP4HAAAICP8HAAAICAAIAAAICAEIAAAICAIIAAAICAMIAAAICAQIAAAICAUIAAAICAYIAAAICAcIAAAICAgIAAAICAkIAAAICAoIAAAICAsIAAAICAwIAAAICA0IAAAICA4IAAAICA8IAAAICBAIAAAICBEIAAAICBIIAAAICBMIAAAICBQIAAAICBUIAAAICBYIAAAICBcIAAAICBgIAAAICBkIAAAICBoIAAAICBsIAAAICBwIAAAICB0IAAAICB4IAAAICB8IAAAICCAIAAAICCEIAAAICCIIAAAICCMIAAAICCQIAAAICCUIAAAICCYIAAAICCcIAAAICCgIAAAICCkIAAAICCoIAAAICCsIAAAICCwIAAAICC0IAAAICC4IAAAICC8IAAAICDAIAAAICDEIAAAICDIIAAAICDMIAAAICDQIAAAICDUIAAAICDYIAAAICDcIAAAICDgIAAAICDkIAAAICDoIAAAICDsIAAAICDwIAAAICD0IAAAICD4IAAAICD8IAAAICEAIAAAICEEIAAAICEIIAAAICEMIAAAICEQIAAAICEUIAAAICEYIAAAICEcIAAAICEgIAAAICEkIAAAICEoIAAAICEsIAAAICEwIAAAICE0IAAAICE4IAAAICE8IAAAICFAIAAAICFEIAAAICFIIAAAICFMIAAAICFQIAAAICFUIAAAICFYIAAAICFcIAAAICFgIAAAICFkIAAAICFoIAAAICFsIAAAICFwIAAAICF0IAAAICF4IAAAICF8IAAAICGAIAAAICGEIAAAICGIIAAAICGMIAAAICGQIAAAICGUIAAAICGYIAAAICGcIAAAICGgIAAAICGkIAAAICGoIAAAICGsIAAAICGwIAAAICG0IAAAICG4IAAAICG8IAAAICHAIAAAICHEIAAAICHIIAAAICHMIAAAICHQIAAAICHUIAAAICHYIAAAICHcIAAAICHgIAAAICHkIAAAICHoIAAAICHsIAAAICHwIAAAICH0IAAAICH4IAAAICH8IAAAICIAIAAAICIEIAAAICIIIAAAICIMIAAAICIQIAAAICIUIAAAICIYIAAAICIcIAAAICIgIAAAICIkIAAAICIoIAAAICIsIAAAICIwIAAAICI0IAAAICI4IAAAICI8IAAAICJAIAAAICJEIAAAICJIIAAAICJMIAAAICJQIAAAICJUIAAAICJYIAAAICJcIAAAICJgIAAAICJkIAAAICJoIAAAICJsIAAAICJwIAAAICJ0IAAAICJ4IAAAICJ8IAAAICKAIAAAICKEIAAAICKIIAAAICKMIAAAICKQIAAAICKUIAAAICKYIAAAICKcIAAAICKgIAAAICKkIAAAICKoIAAAICKsIAAAICKwIAAAICK0IAAAICK4IAAAICK8IAAAICLAIAAAICLEIAAAICLIIAAAICLMIAAAICLQIAAAICLUIAAAICLYIAAAICLcIAAAICLgIAAAICLkIAAAICLoIAAAICLsIAAAICLwIAAAICL0IAAAICL4IAAAICL8IAAAICMAIAAAICMEIAAAICMIIAAAICMMIAAAICMQIAAAICMUIAAAICMYIAAAICMcIAAAICMgIAAAICMkIAAAICMoIAAAICMsIAAAICMwIAAAICM0IAAAICM4IAAAICM8IAAAICNAIAAAICNEIAAAICNIIAAAICNMIAAAICNQIAAAICNUIAAAICNYIAAAICNcIAAAICNgIAAAICNkIAAAICNoIAAAICNsIAAAICNwIAAAICN0IAAAICN4IAAAICN8IAAAICOAIAAAICOEIAAAICOIIAAAICOMIAAAICOQIAAAICOUIAAAICOYIAAAICOcIAAAICOgIAAAICOkIAAAICOoIAAAICOsIAAAICOwIAAAICO0IAAAICO4IAAAICO8IAAAICPAIAAAICPEIAAAICPIIAAAICPMIAAAICPQIAAAICPUIAAAICPYIAAAICPcIAAAICPgIAAAICPkIAAAICPoIAAAICPsIAAAICPwIAAAICP0IAAAICP4IAAAICP8IAAAICAAJAAAICAEJAAAICAIJAAAICAMJAAAICAQJAAAICAUJAAAICAYJAAAICAcJAAAICAgJAAAICAkJAAAICAoJAAAICAsJAAAICAwJAAAICA0JAAAICA4JAAAICA8JAAAICBAJAAAICBEJAAAICBIJAAAICBMJAAAICBQJAAAICBUJAAAICBYJAAAICBcJAAAICBgJAAAICBkJAAAICBoJAAAICBsJAAAICBwJAAAICB0JAAAICB4JAAAICB8JAAAICCAJAAAICCEJAAAICCIJAAAICCMJAAAICCQJAAAICCUJAAAICCYJAAAICCcJAAAICCgJAAAICCkJAAAICCoJAAAICCsJAAAICCwJAAAICC0JAAAICC4JAAAICC8JAAAICDAJAAAICDEJAAAICDIJAAAICDMJAAAICDQJAAAICDUJAAAICDYJAAAICDcJAAAICDgJAAAICDkJAAAICDoJAAAICDsJAAAICDwJAAAICD0JAAAICD4JAAAICD8JAAAICEAJAAAICEEJAAAICEIJAAAICEMJAAAICEQJAAAICEUJAAAICEYJAAAICEcJAAAICEgJAAAICEkJAAAICEoJAAAICEsJAAAICEwJAAAICE0JAAAICE4JAAAICE8JAAAICFAJAAAICFEJAAAICFIJAAAICFMJAAAICFQJAAAICFUJAAAICFYJAAAICFcJAAAICFgJAAAICFkJAAAICFoJAAAICFsJAAAICFwJAAAICF0JAAAICF4JAAAICF8JAAAICGAJAAAICGEJAAAICGIJAAAICGMJAAAICGQJAAAICGUJAAAICGYJAAAICGcJAAAICGgJAAAICGkJAAAICGoJAAAICGsJAAAICGwJAAAICG0JAAAICG4JAAAICG8JAAAICHAJAAAICHEJAAAICHIJAAAICHMJAAAICHQJAAAICHUJAAAICHYJAAAICHcJAAAICHgJAAAICHkJAAAICHoJAAAICHsJAAAICHwJAAAICH0JAAAICH4JAAAICH8JAAAICIAJAAAICIEJAAAICIIJAAAICIMJAAAICIQJAAAICIUJAAAICIYJAAAICIcJAAAICIgJAAAICIkJAAAICIoJAAAICIsJAAAICIwJAAAICI0JAAAICI4JAAAICI8JAAAICJAJAAAICJEJAAAICJIJAAAICJMJAAAICJQJAAAICJUJAAAICJYJAAAICJcJAAAICJgJAAAICJkJAAAICJoJAAAICJsJAAAICJwJAAAICJ0JAAAICJ4JAAAICJ8JAAAICKAJAAAICKEJAAAICKIJAAAICKMJAAAICKQJAAAICKUJAAAICKYJAAAICKcJAAAICKgJAAAICKkJAAAICKoJAAAICKsJAAAICKwJAAAICK0JAAAICK4JAAAICK8JAAAICLAJAAAICLEJAAAICLIJAAAICLMJAAAICLQJAAAICLUJAAAICLYJAAAICLcJAAAICLgJAAAICLkJAAAICLoJAAAICLsJAAAICLwJAAAICL0JAAAICL4JAAAICL8JAAAICMAJAAAICMEJAAAICMIJAAAICMMJAAAICMQJAAAICMUJAAAICMYJAAAICMcJAAAICMgJAAAICMkJAAAICMoJAAAICMsJAAAICMwJAAAICM0JAAAICM4JAAAICM8JAAAICNAJAAAICNEJAAAICNIJAAAICNMJAAAICNQJAAAICNUJAAAICNYJAAAICNcJAAAICNgJAAAICNkJAAAICNoJAAAICNsJAAAICNwJAAAICN0JAAAICN4JAAAICN8JAAAICOAJAAAICOEJAAAICOIJAAAICOMJAAAICOQJAAAICOUJAAAICOYJAAAICOcJAAAICOgJAAAICOkJAAAICOoJAAAICOsJAAAICOwJAAAICO0JAAAICO4JAAAICO8JAAAICPAJAAAICPEJAAAICPIJAAAICPMJAAAICPQJAAAICPUJAAAICPYJAAAICPcJAAAICPgJAAAICPkJAAAICPoJAAAICPsJAAAICPwJAAAICP0JAAAICP4JAAAICP8JAAAICAAKAAAICAEKAAAICAIKAAAICAMKAAAICAQKAAAICAUKAAAICAYKAAAICAcKAAAICAgKAAAICAkKAAAICAoKAAAICAsKAAAICAwKAAAICA0KAAAICA4KAAAICA8KAAAICBAKAAAICBEKAAAICBIKAAAICBMKAAAICBQKAAAICBUKAAAICBYKAAAICBcKAAAICBgKAAAICBkKAAAICBoKAAAICBsKAAAICBwKAAAICB0KAAAICB4KAAAICB8KAAAICCAKAAAICCEKAAAICCIKAAAICCMKAAAICCQKAAAICCUKAAAICCYKAAAICCcKAAAICCgKAAAICCkKAAAICCoKAAAICCsKAAAICCwKAAAICC0KAAAICC4KAAAICC8KAAAICDAKAAAICDEKAAAICDIKAAAICDMKAAAICDQKAAAICDUKAAAICDYKAAAICDcKAAAICDgKAAAICDkKAAAICDoKAAAICDsKAAAICDwKAAAICD0KAAAICD4KAAAICD8KAAAICEAKAAAICEEKAAAICEIKAAAICEMKAAAICEQKAAAICEUKAAAICEYKAAAICEcKAAAICEgKAAAICEkKAAAICEoKAAAICEsKAAAICEwKAAAICE0KAAAICE4KAAAICE8KAAAICFAKAAAICFEKAAAICFIKAAAICFMKAAAICFQKAAAICFUKAAAICFYKAAAICFcKAAAICFgKAAAICFkKAAAICFoKAAAICFsKAAAICFwKAAAICF0KAAAICF4KAAAICF8KAAAICGAKAAAICGEKAAAICGIKAAAICGMKAAAICGQKAAAICGUKAAAICGYKAAAICGcKAAAICGgKAAAICGkKAAAICGoKAAAICGsKAAAICGwKAAAICG0KAAAICG4KAAAICG8KAAAICHAKAAAICHEKAAAICHIKAAAICHMKAAAICHQKAAAICHUKAAAICHYKAAAICHcKAAAICHgKAAAICHkKAAAICHoKAAAICHsKAAAICHwKAAAICH0KAAAICH4KAAAICH8KAAAICIAKAAAICIEKAAAICIIKAAAICIMKAAAICIQKAAAICIUKAAAICIYKAAAICIcKAAAICIgKAAAICIkKAAAICIoKAAAICIsKAAAICIwKAAAICI0KAAAICI4KAAAICI8KAAAICJAKAAAICJEKAAAICJIKAAAICJMKAAAICJQKAAAICJUKAAAICJYKAAAICJcKAAAICJgKAAAICJkKAAAICJoKAAAICJsKAAAICJwKAAAICJ0KAAAICJ4KAAAICJ8KAAAICKAKAAAICKEKAAAICKIKAAAICKMKAAAICKQKAAAICKUKAAAICKYKAAAICKcKAAAICKgKAAAICKkKAAAICKoKAAAICKsKAAAICKwKAAAICK0KAAAICK4KAAAICK8KAAAICLAKAAAICLEKAAAICLIKAAAICLMKAAAICLQKAAAICLUKAAAICLYKAAAICLcKAAAICLgKAAAICLkKAAAICLoKAAAICLsKAAAICLwKAAAICL0KAAAICL4KAAAICL8KAAAICMAKAAAICMEKAAAICMIKAAAICMMKAAAICMQKAAAICMUKAAAICMYKAAAICMcKAAAICMgKAAAICMkKAAAICMoKAAAICMsKAAAICMwKAAAICM0KAAAICM4KAAAICM8KAAAICNAKAAAICNEKAAAICNIKAAAICNMKAAAICNQKAAAICNUKAAAICNYKAAAICNcKAAAICNgKAAAICNkKAAAICNoKAAAICNsKAAAICNwKAAAICN0KAAAICN4KAAAICN8KAAAICOAKAAAICOEKAAAICOIKAAAICOMKAAAICOQKAAAICOUKAAAICOYKAAAICOcKAAAICOgKAAAICOkKAAAICOoKAAAICOsKAAAICOwKAAAICO0KAAAICO4KAAAICO8KAAAICPAKAAAICPEKAAAICPIKAAAICPMKAAAICPQKAAAICPUKAAAICPYKAAAICPcKAAAICPgKAAAICPkKAAAICPoKAAAICPsKAAAICPwKAAAICP0KAAAICP4KAAAICP8KAAAICAALAAAICAELAAAICAILAAAICAMLAAAICAQLAAAICAULAAAICAYLAAAICAcLAAAICAgLAAAICAkLAAAICAoLAAAICAsLAAAICAwLAAAICA0LAAAICA4LAAAICA8LAAAICBALAAAICBELAAAICBILAAAICBMLAAAICBQLAAAICBULAAAICBYLAAAICBcLAAAICBgLAAAICBkLAAAICBoLAAAICBsLAAAICBwLAAAICB0LAAAICB4LAAAICB8LAAAICCALAAAICCELAAAICCILAAAICCMLAAAICCQLAAAICCULAAAICCYLAAAICCcLAAAICCgLAAAICCkLAAAICCoLAAAICCsLAAAICCwLAAAICC0LAAAICC4LAAAICC8LAAAICDALAAAICDELAAAICDILAAAICDMLAAAICDQLAAAICDULAAAICDYLAAAICDcLAAAICDgLAAAICDkLAAAICDoLAAAICDsLAAAICDwLAAAICD0LAAAICD4LAAAICD8LAAAICEALAAAICEELAAAICEILAAAICEMLAAAICEQLAAAICEULAAAICEYLAAAICEcLAAAICEgLAAAICEkLAAAICEoLAAAICEsLAAAICEwLAAAICE0LAAAICE4LAAAICE8LAAAICFALAAAICFELAAAICFILAAAICFMLAAAICFQLAAAICFULAAAICFYLAAAICFcLAAAICFgLAAAICFkLAAAICFoLAAAICFsLAAAICFwLAAAICF0LAAAICF4LAAAICF8LAAAICGALAAAICGELAAAICGILAAAICGMLAAAICGQLAAAICGULAAAICGYLAAAICGcLAAAICGgLAAAICGkLAAAICGoLAAAICGsLAAAICGwLAAAICG0LAAAICG4LAAAICG8LAAAICHALAAAICHELAAAICHILAAAICHMLAAAICHQLAAAICHULAAAICHYLAAAICHcLAAAICHgLAAAICHkLAAAICHoLAAAICHsLAAAICHwLAAAICH0LAAAICH4LAAAICH8LAAAICIALAAAICIELAAAICIILAAAICIMLAAAICIQLAAAICIULAAAICIYLAAAICIcLAAAICIgLAAAICIkLAAAICIoLAAAICIsLAAAICIwLAAAICI0LAAAICI4LAAAICI8LAAAICJALAAAICJELAAAICJILAAAICJMLAAAICJQLAAAICJULAAAICJYLAAAICJcLAAAICJgLAAAICJkLAAAICJoLAAAICJsLAAAICJwLAAAICJ0LAAAICJ4LAAAICJ8LAAAICKALAAAICKELAAAICKILAAAICKMLAAAICKQLAAAICKULAAAICKYLAAAICKcLAAAICKgLAAAICKkLAAAICKoLAAAICKsLAAAICKwLAAAICK0LAAAICK4LAAAICK8LAAAICLALAAAICLELAAAICLILAAAICLMLAAAICLQLAAAICLULAAAICLYLAAAICLcLAAAICLgLAAAICLkLAAAICLoLAAAICLsLAAAICLwLAAAICL0LAAAICL4LAAAICL8LAAAICMALAAAICMELAAAICMILAAAICMMLAAAICMQLAAAICMULAAAICMYLAAAICMcLAAAICMgLAAAICMkLAAAICMoLAAAICMsLAAAICMwLAAAICM0LAAAICM4LAAAICM8LAAAICNALAAAICNELAAAICNILAAAICNMLAAAICNQLAAAICNULAAAICNYLAAAICNcLAAAICNgLAAAICNkLAAAICNoLAAAICNsLAAAICNwLAAAICN0LAAAICN4LAAAICN8LAAAICOALAAAICOELAAAICOILAAAICOMLAAAICOQLAAAICOULAAAICOYLAAAICOcLAAAICOgLAAAICOkLAAAICOoLAAAICOsLAAAICOwLAAAICO0LAAAICO4LAAAICO8LAAAICPALAAAICPELAAAICPILAAAICPMLAAAICPQLAAAICPULAAAICPYLAAAICPcLAAAICPgLAAAICPkLAAAICPoLAAAICPsLAAAICPwLAAAICP0LAAAICP4LAAAICP8LAAAICAAMAAAICAEMAAAICAIMAAAICAMMAAAICAQMAAAICAUMAAAICAYMAAAICAcMAAAICAgMAAAICAkMAAAICAoMAAAICAsMAAAICAwMAAAICA0MAAAICA4MAAAICA8MAAAICBAMAAAICBEMAAAICBIMAAAICBMMAAAICBQMAAAICBUMAAAICBYMAAAICBcMAAAICBgMAAAICBkMAAAICBoMAAAICBsMAAAICBwMAAAICB0MAAAICB4MAAAICB8MAAAICCAMAAAICCEMAAAICCIMAAAICCMMAAAICCQMAAAICCUMAAAICCYMAAAICCcMAAAICCgMAAAICCkMAAAICCoMAAAICCsMAAAICCwMAAAICC0MAAAICC4MAAAICC8MAAAICDAMAAAICDEMAAAICDIMAAAICDMMAAAICDQMAAAICDUMAAAICDYMAAAICDcMAAAICDgMAAAICDkMAAAICDoMAAAICDsMAAAICDwMAAAICD0MAAAICD4MAAAICD8MAAAICEAMAAAICEEMAAAICEIMAAAICEMMAAAICEQMAAAICEUMAAAICEYMAAAICEcMAAAICEgMAAAICEkMAAAICEoMAAAICEsMAAAICEwMAAAICE0MAAAICE4MAAAICE8MAAAICFAMAAAICFEMAAAICFIMAAAICFMMAAAICFQMAAAICFUMAAAICFYMAAAICFcMAAAICFgMAAAICFkMAAAICFoMAAAICFsMAAAICFwMAAAICF0MAAAICF4MAAAICF8MAAAICGAMAAAICGEMAAAICGIMAAAICGMMAAAICGQMAAAICGUMAAAICGYMAAAICGcMAAAICGgMAAAICGkMAAAICGoMAAAICGsMAAAICGwMAAAICG0MAAAICG4MAAAICG8MAAAICHAMAAAICHEMAAAICHIMAAAICHMMAAAICHQMAAAICHUMAAAICHYMAAAICHcMAAAICHgMAAAICHkMAAAICHoMAAAICHsMAAAICHwMAAAICH0MAAAICH4MAAAICH8MAAAICIAMAAAICIEMAAAICIIMAAAICIMMAAAICIQMAAAICIUMAAAICIYMAAAICIcMAAAICIgMAAAICIkMAAAICIoMAAAICIsMAAAICIwMAAAICI0MAAAICI4MAAAICI8MAAAICJAMAAAICJEMAAAICJIMAAAICJMMAAAICJQMAAAICJUMAAAICJYMAAAICJcMAAAICJgMAAAICJkMAAAICJoMAAAICJsMAAAICJwMAAAICJ0MAAAICJ4MAAAICJ8MAAAICKAMAAAICKEMAAAICKIMAAAICKMMAAAICKQMAAAICKUMAAAICKYMAAAICKcMAAAICKgMAAAICKkMAAAICKoMAAAICKsMAAAICKwMAAAICK0MAAAICK4MAAAICK8MAAAICLAMAAAICLEMAAAICLIMAAAICLMMAAAICLQMAAAICLUMAAAICLYMAAAICLcMAAAICLgMAAAICLkMAAAICLoMAAAICLsMAAAICLwMAAAICL0MAAAICL4MAAAICL8MAAAICMAMAAAICMEMAAAICMIMAAAICMMMAAAICMQMAAAICMUMAAAICMYMAAAICMcMAAAICMgMAAAICMkMAAAICMoMAAAICMsMAAAICMwMAAAICM0MAAAICM4MAAAICM8MAAAICNAMAAAICNEMAAAICNIMAAAICNMMAAAICNQMAAAICNUMAAAICNYMAAAICNcMAAAICNgMAAAICNkMAAAICNoMAAAICNsMAAAICNwMAAAICN0MAAAICN4MAAAICN8MAAAICOAMAAAICOEMAAAICOIMAAAICOMMAAAICOQMAAAICOUMAAAICOYMAAAICOcMAAAICOgMAAAICOkMAAAICOoMAAAICOsMAAAICOwMAAAICO0MAAAICO4MAAAICO8MAAAICPAMAAAICPEMAAAICPIMAAAICPMMAAAICPQMAAAICPUMAAAICPYMAAAICPcMAAAICPgMAAAICPkMAAAICPoMAAAICPsMAAAICPwMAAAICP0MAAAICP4MAAAICP8MAAAICAANAAAICAENAAAICAINAAAICAMNAAAICAQNAAAICAUNAAAICAYNAAAICAcNAAAICAgNAAAICAkNAAAICAoNAAAICAsNAAAICAwNAAAICA0NAAAICA4NAAAICA8NAAAICBANAAAICBENAAAICBINAAAICBMNAAAICBQNAAAICBUNAAAICBYNAAAICBcNAAAICBgNAAAICBkNAAAICBoNAAAICBsNAAAICBwNAAAICB0NAAAICB4NAAAICB8NAAAICCANAAAICCENAAAICCINAAAICCMNAAAICCQNAAAICCUNAAAICCYNAAAICCcNAAAICCgNAAAICCkNAAAICCoNAAAICCsNAAAICCwNAAAICC0NAAAICC4NAAAICC8NAAAICDANAAAICDENAAAICDINAAAICDMNAAAICDQNAAAICDUNAAAICDYNAAAICDcNAAAICDgNAAAICDkNAAAICDoNAAAICDsNAAAICDwNAAAICD0NAAAICD4NAAAICD8NAAAICEANAAAICEENAAAICEINAAAICEMNAAAICEQNAAAICEUNAAAICEYNAAAICEcNAAAICEgNAAAICEkNAAAICEoNAAAICEsNAAAICEwNAAAICE0NAAAICE4NAAAICE8NAAAICFANAAAICFENAAAICFINAAAICFMNAAAICFQNAAAICFUNAAAICFYNAAAICFcNAAAICFgNAAAICFkNAAAICFoNAAAICFsNAAAICFwNAAAICF0NAAAICF4NAAAICF8NAAAICGANAAAICGENAAAICGINAAAICGMNAAAICGQNAAAICGUNAAAICGYNAAAICGcNAAAICGgNAAAICGkNAAAICGoNAAAICGsNAAAICGwNAAAICG0NAAAICG4NAAAICG8NAAAICHANAAAICHENAAAICHINAAAICHMNAAAICHQNAAAICHUNAAAICHYNAAAICHcNAAAICHgNAAAICHkNAAAICHoNAAAICHsNAAAICHwNAAAICH0NAAAICH4NAAAICH8NAAAICIANAAAICIENAAAICIINAAAICIMNAAAICIQNAAAICIUNAAAICIYNAAAICIcNAAAICIgNAAAICIkNAAAICIoNAAAICIsNAAAICIwNAAAICI0NAAAICI4NAAAICI8NAAAICJANAAAICJENAAAICJINAAAICJMNAAAICJQNAAAICJUNAAAICJYNAAAICJcNAAAICJgNAAAICJkNAAAICJoNAAAICJsNAAAICJwNAAAICJ0NAAAICJ4NAAAICJ8NAAAICKANAAAICKENAAAICKINAAAICKMNAAAICKQNAAAICKUNAAAICKYNAAAICKcNAAAICKgNAAAICKkNAAAICKoNAAAICKsNAAAICKwNAAAICK0NAAAICK4NAAAICK8NAAAICLANAAAICLENAAAICLINAAAICLMNAAAICLQNAAAICLUNAAAICLYNAAAICLcNAAAICLgNAAAICLkNAAAICLoNAAAICLsNAAAICLwNAAAICL0NAAAICL4NAAAICL8NAAAICMANAAAICMENAAAICMINAAAICMMNAAAICMQNAAAICMUNAAAICMYNAAAICMcNAAAICMgNAAAICMkNAAAICMoNAAAICMsNAAAICMwNAAAICM0NAAAICM4NAAAICM8NAAAICNANAAAICNENAAAICNINAAAICNMNAAAICNQNAAAICNUNAAAICNYNAAAICNcNAAAICNgNAAAICNkNAAAICNoNAAAICNsNAAAICNwNAAAICN0NAAAICN4NAAAICN8NAAAICOANAAAICOENAAAICOINAAAICOMNAAAICOQNAAAICOUNAAAICOYNAAAICOcNAAAICOgNAAAICOkNAAAICOoNAAAICOsNAAAICOwNAAAICO0NAAAICO4NAAAICO8NAAAICPANAAAICPENAAAICPINAAAICPMNAAAICPQNAAAICPUNAAAICPYNAAAICPcNAAAICPgNAAAICPkNAAAICPoNAAAICPsNAAAICPwNAAAICP0NAAAICP4NAAAICP8NAAAICAAOAAAICAEOAAAICAIOAAAICAMOAAAICAQOAAAICAUOAAAICAYOAAAICAcOAAAICAgOAAAICAkOAAAICAoOAAAICAsOAAAICAwOAAAICA0OAAAICA4OAAAICA8OAAAICBAOAAAICBEOAAAICBIOAAAICBMOAAAICBQOAAAICBUOAAAICBYOAAAICBcOAAAICBgOAAAICBkOAAAICBoOAAAICBsOAAAICBwOAAAICB0OAAAICB4OAAAICB8OAAAICCAOAAAICCEOAAAICCIOAAAICCMOAAAICCQOAAAICCUOAAAICCYOAAAICCcOAAAICCgOAAAICCkOAAAICCoOAAAICCsOAAAICCwOAAAICC0OAAAICC4OAAAICC8OAAAICDAOAAAICDEOAAAICDIOAAAICDMOAAAICDQOAAAICDUOAAAICDYOAAAICDcOAAAICDgOAAAICDkOAAAICDoOAAAICDsOAAAICDwOAAAICD0OAAAICD4OAAAICD8OAAAICEAOAAAICEEOAAAICEIOAAAICEMOAAAICEQOAAAICEUOAAAICEYOAAAICEcOAAAICEgOAAAICEkOAAAICEoOAAAICEsOAAAICEwOAAAICE0OAAAICE4OAAAICE8OAAAICFAOAAAICFEOAAAICFIOAAAICFMOAAAICFQOAAAICFUOAAAICFYOAAAICFcOAAAICFgOAAAICFkOAAAICFoOAAAICFsOAAAICFwOAAAICF0OAAAICF4OAAAICF8OAAAICGAOAAAICGEOAAAICGIOAAAICGMOAAAICGQOAAAICGUOAAAICGYOAAAICGcOAAAICGgOAAAICGkOAAAICGoOAAAICGsOAAAICGwOAAAICG0OAAAICG4OAAAICG8OAAAICHAOAAAICHEOAAAICHIOAAAICHMOAAAICHQOAAAICHUOAAAICHYOAAAICHcOAAAICHgOAAAICHkOAAAICHoOAAAICHsOAAAICHwOAAAICH0OAAAICH4OAAAICH8OAAAICIAOAAAICIEOAAAICIIOAAAICIMOAAAICIQOAAAICIUOAAAICIYOAAAICIcOAAAICIgOAAAICIkOAAAICIoOAAAICIsOAAAICIwOAAAICI0OAAAICI4OAAAICI8OAAAICJAOAAAICJEOAAAICJIOAAAICJMOAAAICJQOAAAICJUOAAAICJYOAAAICJcOAAAICJgOAAAICJkOAAAICJoOAAAICJsOAAAICJwOAAAICJ0OAAAICJ4OAAAICJ8OAAAICKAOAAAICKEOAAAICKIOAAAICKMOAAAICKQOAAAICKUOAAAICKYOAAAICKcOAAAICKgOAAAICKkOAAAICKoOAAAICKsOAAAICKwOAAAICK0OAAAICK4OAAAICK8OAAAICLAOAAAICLEOAAAICLIOAAAICLMOAAAICLQOAAAICLUOAAAICLYOAAAICLcOAAAICLgOAAAICLkOAAAICLoOAAAICLsOAAAICLwOAAAICL0OAAAICL4OAAAICL8OAAAICMAOAAAICMEOAAAICMIOAAAICMMOAAAICMQOAAAICMUOAAAICMYOAAAICMcOAAAICMgOAAAICMkOAAAICMoOAAAICMsOAAAICMwOAAAICM0OAAAICM4OAAAICM8OAAAICNAOAAAICNEOAAAICNIOAAAICNMOAAAICNQOAAAICNUOAAAICNYOAAAICNcOAAAICNgOAAAICNkOAAAICNoOAAAICNsOAAAICNwOAAAICN0OAAAICN4OAAAICN8OAAAICOAOAAAICOEOAAAICOIOAAAICOMOAAAICOQOAAAICOUOAAAICOYOAAAICOcOAAAICOgOAAAICOkOAAAICOoOAAAICOsOAAAICOwOAAAICO0OAAAICO4OAAAICO8OAAAICPAOAAAICPEOAAAICPIOAAAICPMOAAAICPQOAAAICPUOAAAICPYOAAAICPcOAAAICPgOAAAICPkOAAAICPoOAAAICPsOAAAICPwOAAAICP0OAAAICP4OAAAICP8OAAAICAAPAAAICAEPAAAICAIPAAAICAMPAAAICAQPAAAICAUPAAAICAYPAAAICAcPAAAICAgPAAAICAkPAAAICAoPAAAICAsPAAAICAwPAAAICA0PAAAICA4PAAAICA8PAAAICBAPAAAICBEPAAAICBIPAAAICBMPAAAICBQPAAAICBUPAAAICBYPAAAICBcPAAAICBgPAAAICBkPAAAICBoPAAAICBsPAAAICBwPAAAICB0PAAAICB4PAAAICB8PAAAICCAPAAAICCEPAAAICCIPAAAICCMPAAAICCQPAAAICCUPAAAICCYPAAAICCcPAAAICCgPAAAICCkPAAAICCoPAAAICCsPAAAICCwPAAAICC0PAAAICC4PAAAICC8PAAAICDAPAAAICDEPAAAICDIPAAAICDMPAAAICDQPAAAICDUPAAAICDYPAAAICDcPAAAICDgPAAAICDkPAAAICDoPAAAICDsPAAAICDwPAAAICD0PAAAICD4PAAAICD8PAAAICEAPAAAICEEPAAAICEIPAAAICEMPAAAICEQPAAAICEUPAAAICEYPAAAICEcPAAAICEgPAAAICEkPAAAICEoPAAAICEsPAAAICEwPAAAICE0PAAAICE4PAAAICE8PAAAICFAPAAAICFEPAAAICFIPAAAICFMPAAAICFQPAAAICFUPAAAICFYPAAAICFcPAAAICFgPAAAICFkPAAAICFoPAAAICFsPAAAICFwPAAAICF0PAAAICF4PAAAICF8PAAAICGAPAAAICGEPAAAICGIPAAAICGMPAAAICGQPAAAICGUPAAAICGYPAAAICGcPAAAICGgPAAAICGkPAAAICGoPAAAICGsPAAAICGwPAAAICG0PAAAICG4PAAAICG8PAAAICHAPAAAICHEPAAAICHIPAAAICHMPAAAICHQPAAAICHUPAAAICHYPAAAICHcPAAAICHgPAAAICHkPAAAICHoPAAAICHsPAAAICHwPAAAICH0PAAAICH4PAAAICH8PAAAICIAPAAAICIEPAAAICIIPAAAICIMPAAAICIQPAAAICIUPAAAICIYPAAAICIcPAAAICIgPAAAICIkPAAAICIoPAAAICIsPAAAICIwPAAAICI0PAAAICI4PAAAICI8PAAAICJAPAAAICJEPAAAICJIPAAAICJMPAAAICJQPAAAICJUPAAAICJYPAAAICJcPAAAICJgPAAAICJkPAAAICJoPAAAICJsPAAAICJwPAAAICJ0PAAAICJ4PAAAICJ8PAAAICKAPAAAICKEPAAAICKIPAAAICKMPAAAICKQPAAAICKUPAAAICKYPAAAICKcPAAAICKgPAAAICKkPAAAICKoPAAAICKsPAAAICKwPAAAICK0PAAAICK4PAAAICK8PAAAICLAPAAAICLEPAAAICLIPAAAICLMPAAAICLQPAAAICLUPAAAICLYPAAAICLcPAAAICLgPAAAICLkPAAAICLoPAAAICLsPAAAICLwPAAAICL0PAAAICL4PAAAICL8PAAAICMAPAAAICMEPAAAICMIPAAAICMMPAAAICMQPAAAICMUPAAAICMYPAAAICMcPAAAICMgPAAAICMkPAAAICMoPAAAICMsPAAAICMwPAAAICM0PAAAICM4PAAAICM8PAAAICNAPAAAICNEPAAAICNIPAAAICNMPAAAICNQPAAAICNUPAAAICNYPAAAICNcPAAAICNgPAAAICNkPAAAICNoPAAAICNsPAAAICNwPAAAICN0PAAAICN4PAAAICN8PAAAICOAPAAAICOEPAAAICOIPAAAICOMPAAAICOQPAAAICOUPAAAICOYPAAAICOcPAAAICOgPAAAICOkPAAAICOoPAAAICOsPAAAICOwPAAAICO0PAAAICO4PAAAICO8PAAAICPAPAAAICPEPAAAICPIPAAAICPMPAAAICPQPAAAICPUPAAAICPYPAAAICPcPAAAICPgPAAAICPkPAAAICPoPAAAICPsPAAAICPwPAAAICP0PAAAICP4PAAAICP8PAAAICAAQAAAICAEQAAAICAIQAAAICAMQAAAICAQQAAAICAUQAAAICAYQAAAICAcQAAAICAgQAAAICAkQAAAICAoQAAAICAsQAAAICAwQAAAICA0QAAAICA4QAAAICA8QAAAICBAQAAAICBEQAAAICBIQAAAICBMQAAAICBQQAAAICBUQAAAICBYQAAAICBcQAAAICBgQAAAICBkQAAAICBoQAAAICBsQAAAICBwQAAAICB0QAAAICB4QAAAICB8QAAAICCAQAAAICCEQAAAICCIQAAAICCMQAAAICCQQAAAICCUQAAAICCYQAAAICCcQAAAICCgQAAAICCkQAAAICCoQAAAICCsQAAAICCwQAAAICC0QAAAICC4QAAAICC8QAAAICDAQAAAICDEQAAAICDIQAAAICDMQAAAICDQQAAAICDUQAAAICDYQAAAICDcQAAAICDgQAAAICDkQAAAICDoQAAAICDsQAAAICDwQAAAICD0QAAAICD4QAAAICD8QAAAICEAQAAAICEEQAAAICEIQAAAICEMQAAAICEQQAAAICEUQAAAICEYQAAAICEcQAAAICEgQAAAICEkQAAAICEoQAAAICEsQAAAICEwQAAAICE0QAAAICE4QAAAICE8QAAAICFAQAAAICFEQAAAICFIQAAAICFMQAAAICFQQAAAICFUQAAAICFYQAAAICFcQAAAICFgQAAAICFkQAAAICFoQAAAICFsQAAAICFwQAAAICF0QAAAICF4QAAAICF8QAAAICGAQAAAICGEQAAAICGIQAAAICGMQAAAICGQQAAAICGUQAAAICGYQAAAICGcQAAAICGgQAAAICGkQAAAICGoQAAAICGsQAAAICGwQAAAICG0QAAAICG4QAAAICG8QAAAICHAQAAAICHEQAAAICHIQAAAICHMQAAAICHQQAAAICHUQAAAICHYQAAAICHcQAAAICHgQAAAICHkQAAAICHoQAAAICHsQAAAICHwQAAAICH0QAAAICH4QAAAICH8QAAAICIAQAAAICIEQAAAICIIQAAAICIMQAAAICIQQAAAICIUQAAAICIYQAAAICIcQAAAICIgQAAAICIkQAAAICIoQAAAICIsQAAAICIwQAAAICI0QAAAICI4QAAAICI8QAAAICJAQAAAICJEQAAAICJIQAAAICJMQAAAICJQQAAAICJUQAAAICJYQAAAICJcQAAAICJgQAAAICJkQAAAICJoQAAAICJsQAAAICJwQAAAICJ0QAAAICJ4QAAAICJ8QAAAICKAQAAAICKEQAAAICKIQAAAICKMQAAAICKQQAAAICKUQAAAICKYQAAAICKcQAAAICKgQAAAICKkQAAAICKoQAAAICKsQAAAICKwQAAAICK0QAAAICK4QAAAICK8QAAAICLAQAAAICLEQAAAICLIQAAAICLMQAAAICLQQAAAICLUQAAAICLYQAAAICLcQAAAICLgQAAAICLkQAAAICLoQAAAICLsQAAAICLwQAAAICL0QAAAICL4QAAAICL8QAAAICMAQAAAICMEQAAAICMIQAAAICMMQAAAICMQQAAAICMUQAAAICMYQAAAICMcQAAAICMgQAAAICMkQAAAICMoQAAAICMsQAAAICMwQAAAICM0QAAAICM4QAAAICM8QAAAICNAQAAAICNEQAAAICNIQAAAICNMQAAAICNQQAAAICNUQAAAICNYQAAAICNcQAAAICNgQAAAICNkQAAAICNoQAAAICNsQAAAICNwQAAAICN0QAAAICN4QAAAICN8QAAAICOAQAAAICOEQAAAICOIQAAAICOMQAAAICOQQAAAICOUQAAAICOYQAAAICOcQAAAICOgQAAAICOkQAAAICOoQAAAICOsQAAAICOwQAAAICO0QAAAICO4QAAAICO8QAAAICPAQAAAICPEQAAAICPIQAAAICPMQAAAICPQQAAAICPUQAAAICPYQAAAICPcQAAAICPgQAAAICPkQAAAICPoQAAAICPsQAAAICPwQAAAICP0QAAAICP4QAAAICP8QAAAICAARAAAICAERAAAICAIRAAAICAMRAAAICAQRAAAICAURAAAICAYRAAAICAcRAAAICAgRAAAICAkRAAAICAoRAAAICAsRAAAICAwRAAAICA0RAAAICA4RAAAICA8RAAAICBARAAAICBERAAAICBIRAAAICBMRAAAICBQRAAAICBURAAAICBYRAAAICBcRAAAICBgRAAAICBkRAAAICBoRAAAICBsRAAAICBwRAAAICB0RAAAICB4RAAAICB8RAAAICCARAAAICCERAAAICCIRAAAICCMRAAAICCQRAAAICCURAAAICCYRAAAICCcRAAAICCgRAAAICCkRAAAICCoRAAAICCsRAAAICCwRAAAICC0RAAAICC4RAAAICC8RAAAICDARAAAICDERAAAICDIRAAAICDMRAAAICDQRAAAICDURAAAICDYRAAAICDcRAAAICDgRAAAICDkRAAAICDoRAAAICDsRAAAICDwRAAAICD0RAAAICD4RAAAICD8RAAAICEARAAAICEERAAAICEIRAAAICEMRAAAICEQRAAAICEURAAAICEYRAAAICEcRAAAICEgRAAAICEkRAAAICEoRAAAICEsRAAAICEwRAAAICE0RAAAICE4RAAAICE8RAAAICFARAAAICFERAAAICFIRAAAICFMRAAAICFQRAAAICFURAAAICFYRAAAICFcRAAAICFgRAAAICFkRAAAICFoRAAAICFsRAAAICFwRAAAICF0RAAAICF4RAAAICF8RAAAICGARAAAICGERAAAICGIRAAAICGMRAAAICGQRAAAICGURAAAICGYRAAAICGcRAAAICGgRAAAICGkRAAAICGoRAAAICGsRAAAICGwRAAAICG0RAAAICG4RAAAICG8RAAAICHARAAAICHERAAAICHIRAAAICHMRAAAICHQRAAAICHURAAAICHYRAAAICHcRAAAICHgRAAAICHkRAAAICHoRAAAICHsRAAAICHwRAAAICH0RAAAICH4RAAAICH8RAAAICIARAAAICIERAAAICIIRAAAICIMRAAAICIQRAAAICIURAAAICIYRAAAICIcRAAAICIgRAAAICIkRAAAICIoRAAAICIsRAAAICIwRAAAICI0RAAAICI4RAAAICI8RAAAICJARAAAICJERAAAICJIRAAAICJMRAAAICJQRAAAICJURAAAICJYRAAAICJcRAAAICJgRAAAICJkRAAAICJoRAAAICJsRAAAICJwRAAAICJ0RAAAICJ4RAAAICJ8RAAAICKARAAAICKERAAAICKIRAAAICKMRAAAICKQRAAAICKURAAAICKYRAAAICKcRAAAICKgRAAAICKkRAAAICKoRAAAICKsRAAAICKwRAAAICK0RAAAICK4RAAAICK8RAAAICLARAAAICLERAAAICLIRAAAICLMRAAAICLQRAAAICLURAAAICLYRAAAICLcRAAAICLgRAAAICLkRAAAICLoRAAAICLsRAAAICLwRAAAICL0RAAAICL4RAAAICL8RAAAICMARAAAICMERAAAICMIRAAAICMMRAAAICMQRAAAICMURAAAICMYRAAAICMcRAAAICMgRAAAICMkRAAAICMoRAAAICMsRAAAICMwRAAAICM0RAAAICM4RAAAICM8RAAAICNARAAAICNERAAAICNIRAAAICNMRAAAICNQRAAAICNURAAAICNYRAAAICNcRAAAICNgRAAAICNkRAAAICNoRAAAICNsRAAAICNwRAAAICN0RAAAICN4RAAAICN8RAAAICOARAAAICOERAAAICOIRAAAICOMRAAAICOQRAAAICOURAAAICOYRAAAICOcRAAAICOgRAAAICOkRAAAICOoRAAAICOsRAAAICOwRAAAICO0RAAAICO4RAAAICO8RAAAICPARAAAICPERAAAICPIRAAAICPMRAAAICPQRAAAICPURAAAICPYRAAAICPcRAAAICPgRAAAICPkRAAAICPoRAAAICPsRAAAICPwRAAAICP0RAAAICP4RAAAICP8RAAAICAASAAAICAESAAAICAISAAAICAMSAAAICAQSAAAICAUSAAAICAYSAAAICAcSAAAICAgSAAAICAkSAAAICAoSAAAICAsSAAAICAwSAAAICA0SAAAICA4SAAAICA8SAAAICBASAAAICBESAAAICBISAAAICBMSAAAICBQSAAAICBUSAAAICBYSAAAICBcSAAAICBgSAAAICBkSAAAICBoSAAAICBsSAAAICBwSAAAICB0SAAAICB4SAAAICB8SAAAICCASAAAICCESAAAICCISAAAICCMSAAAICCQSAAAICCUSAAAICCYSAAAICCcSAAAICCgSAAAICCkSAAAICCoSAAAICCsSAAAICCwSAAAICC0SAAAICC4SAAAICC8SAAAICDASAAAICDESAAAICDISAAAICDMSAAAICDQSAAAICDUSAAAICDYSAAAICDcSAAAICDgSAAAICDkSAAAICDoSAAAICDsSAAAICDwSAAAICD0SAAAICD4SAAAICD8SAAAICEASAAAICEESAAAICEISAAAICEMSAAAICEQSAAAICEUSAAAICEYSAAAICEcSAAAICEgSAAAICEkSAAAICEoSAAAICEsSAAAICEwSAAAICE0SAAAICE4SAAAICE8SAAAICFASAAAICFESAAAICFISAAAICFMSAAAICFQSAAAICFUSAAAICFYSAAAICFcSAAAICFgSAAAICFkSAAAICFoSAAAICFsSAAAICFwSAAAICF0SAAAICF4SAAAICF8SAAAICGASAAAICGESAAAICGISAAAICGMSAAAICGQSAAAICGUSAAAICGYSAAAICGcSAAAICGgSAAAICGkSAAAICGoSAAAICGsSAAAICGwSAAAICG0SAAAICG4SAAAICG8SAAAICHASAAAICHESAAAICHISAAAICHMSAAAICHQSAAAICHUSAAAICHYSAAAICHcSAAAICHgSAAAICHkSAAAICHoSAAAICHsSAAAICHwSAAAICH0SAAAICH4SAAAICH8SAAAICIASAAAICIESAAAICIISAAAICIMSAAAICIQSAAAICIUSAAAICIYSAAAICIcSAAAICIgSAAAICIkSAAAICIoSAAAICIsSAAAICIwSAAAICI0SAAAICI4SAAAICI8SAAAICJASAAAICJESAAAICJISAAAICJMSAAAICJQSAAAICJUSAAAICJYSAAAICJcSAAAICJgSAAAICJkSAAAICJoSAAAICJsSAAAICJwSAAAICJ0SAAAICJ4SAAAICJ8SAAAICKASAAAICKESAAAICKISAAAICKMSAAAICKQSAAAICKUSAAAICKYSAAAICKcSAAAICKgSAAAICKkSAAAICKoSAAAICKsSAAAICKwSAAAICK0SAAAICK4SAAAICK8SAAAICLASAAAICLESAAAICLISAAAICLMSAAAICLQSAAAICLUSAAAICLYSAAAICLcSAAAICLgSAAAICLkSAAAICLoSAAAICLsSAAAICLwSAAAICL0SAAAICL4SAAAICL8SAAAICMASAAAICMESAAAICMISAAAICMMSAAAICMQSAAAICMUSAAAICMYSAAAICMcSAAAICMgSAAAICMkSAAAICMoSAAAICMsSAAAICMwSAAAICM0SAAAICM4SAAAICM8SAAAICNASAAAICNESAAAICNISAAAICNMSAAAICNQSAAAICNUSAAAICNYSAAAICNcSAAAICNgSAAAICNkSAAAICNoSAAAICNsSAAAICNwSAAAICN0SAAAICN4SAAAICN8SAAAICOASAAAICOESAAAICOISAAAICOMSAAAICOQSAAAICOUSAAAICOYSAAAICOcSAAAICOgSAAAICOkSAAAICOoSAAAICOsSAAAICOwSAAAICO0SAAAICO4SAAAICO8SAAAICPASAAAICPESAAAICPISAAAICPMSAAAICPQSAAAICPUSAAAICPYSAAAICPcSAAAICPgSAAAICPkSAAAICPoSAAAICPsSAAAICPwSAAAICP0SAAAICP4SAAAICP8SAAAICAATAAAICAETAAAICAITAAAICAMTAAAICAQTAAAICAUTAAAICAYTAAAICAcTAAAICAgTAAAICAkTAAAICAoTAAAICAsTAAAICAwTAAAICA0TAAAICA4TAAAICA8TAAAICBATAAAICBETAAAICBITAAAICBMTAAAICBQTAAAICBUTAAAICBYTAAAICBcTAAAICBgTAAAICBkTAAAICBoTAAAICBsTAAAICBwTAAAICB0TAAAICB4TAAAICB8TAAAICCATAAAICCETAAAICCITAAAICCMTAAAICCQTAAAICCUTAAAICCYTAAAICCcTAAAICCgTAAAICCkTAAAICCoTAAAICCsTAAAICCwTAAAICC0TAAAICC4TAAAICC8TAAAICDATAAAICDETAAAICDITAAAICDMTAAAICDQTAAAICDUTAAAICDYTAAAICDcTAAAICDgTAAAICDkTAAAICDoTAAAICDsTAAAICDwTAAAICD0TAAAICD4TAAAICD8TAAAICEATAAAICEETAAAICEITAAAICEMTAAAICEQTAAAICEUTAAAICEYTAAAICEcTAAAICEgTAAAICEkTAAAICEoTAAAICEsTAAAICEwTAAAICE0TAAAICE4TAAAICE8TAAAICFATAAAICFETAAAICFITAAAICFMTAAAICFQTAAAICFUTAAAICFYTAAAICFcTAAAICFgTAAAICFkTAAAICFoTAAAICFsTAAAICFwTAAAICF0TAAAICF4TAAAICF8TAAAICGATAAAICGETAAAICGITAAAICGMTAAAICGQTAAAICGUTAAAICGYTAAAICGcTAAAICGgTAAAICGkTAAAICGoTAAAICGsTAAAICGwTAAAICG0TAAAICG4TAAAICG8TAAAICHATAAAICHETAAAICHITAAAICHMTAAAICHQTAAAICHUTAAAICHYTAAAICHcTAAAICHgTAAAICHkTAAAICHoTAAAICHsTAAAICHwTAAAICH0TAAAICH4TAAAICH8TAAAICIATAAAICIETAAAICIITAAAICIMTAAAICIQTAAAICIUTAAAICIYTAAAICIcTAAAICIgTAAAICIkTAAAICIoTAAAICIsTAAAICIwTAAAICI0TAAAICI4TAAAICI8TAAAICJATAAAICJETAAAICJITAAAICJMTAAAICJQTAAAICJUTAAAICJYTAAAICJcTAAAICJgTAAAICJkTAAAICJoTAAAICJsTAAAICJwTAAAICJ0TAAAICJ4TAAAICJ8TAAAICKATAAAICKETAAAICKITAAAICKMTAAAICKQTAAAICKUTAAAICKYTAAAICKcTAAAICKgTAAAICKkTAAAICKoTAAAICKsTAAAICKwTAAAICK0TAAAICK4TAAAICK8TAAAICLATAAAICLETAAAICLITAAAICLMTAAAICLQTAAAICLUTAAAICLYTAAAICLcTAAAICLgTAAAICLkTAAAICLoTAAAICLsTAAAICLwTAAAICL0TAAAICL4TAAAICL8TAAAICMATAAAICMETAAAICMITAAAICMMTAAAICMQTAAAICMUTAAAICMYTAAAICMcTAAAICMgTAAAICMkTAAAICMoTAAAICMsTAAAICMwTAAAICM0TAAAICM4TAAAICM8TAAAICNATAAAICNETAAAICNITAAAICNMTAAAICNQTAAAICNUTAAAICNYTAAAICNcTAAAICNgTAAAICNkTAAAICNoTAAAICNsTAAAICNwTAAAICN0TAAAICN4TAAAICN8TAAAICOATAAAICOETAAAICOITAAAICOMTAAAICOQTAAAICOUTAAAICOYTAAAICOcTAAAICOgTAAAICOkTAAAICOoTAAAICOsTAAAICOwTAAAICO0TAAAICO4TAAAICO8TAAAICPATAAAICPETAAAICPITAAAICPMTAAAICPQTAAAICPUTAAAICPYTAAAICPcTAAAICPgTAAAICPkTAAAICPoTAAAICPsTAAAICPwTAAAICP0TAAAICP4TAAAICP8TAAAICAAUAAAICAEUAAAICAIUAAAICAMUAAAICAQUAAAICAUUAAAICAYUAAAICAcUAAAICAgUAAAICAkUAAAICAoUAAAICAsUAAAICAwUAAAICA0UAAAICA4UAAAICA8UAAAICBAUAAAICBEUAAAICBIUAAAICBMUAAAICBQUAAAICBUUAAAICBYUAAAICBcUAAAICBgUAAAICBkUAAAICBoUAAAICBsUAAAICBwUAAAICB0UAAAICB4UAAAICB8UAAAICCAUAAAICCEUAAAICCIUAAAICCMUAAAICCQUAAAICCUUAAAICCYUAAAICCcUAAAICCgUAAAICCkUAAAICCoUAAAICCsUAAAICCwUAAAICC0UAAAICC4UAAAICC8UAAAICDAUAAAICDEUAAAICDIUAAAICDMUAAAICDQUAAAICDUUAAAICDYUAAAICDcUAAAICDgUAAAICDkUAAAICDoUAAAICDsUAAAICDwUAAAICD0UAAAICD4UAAAICD8UAAAICEAUAAAICEEUAAAICEIUAAAICEMUAAAICEQUAAAICEUUAAAICEYUAAAICEcUAAAICEgUAAAICEkUAAAICEoUAAAICEsUAAAICEwUAAAICE0UAAAICE4UAAAICE8UAAAICFAUAAAICFEUAAAICFIUAAAICFMUAAAICFQUAAAICFUUAAAICFYUAAAICFcUAAAICFgUAAAICFkUAAAICFoUAAAICFsUAAAICFwUAAAICF0UAAAICF4UAAAICF8UAAAICGAUAAAICGEUAAAICGIUAAAICGMUAAAICGQUAAAICGUUAAAICGYUAAAICGcUAAAICGgUAAAICGkUAAAICGoUAAAICGsUAAAICGwUAAAICG0UAAAICG4UAAAICG8UAAAICHAUAAAICHEUAAAICHIUAAAICHMUAAAICHQUAAAICHUUAAAICHYUAAAICHcUAAAICHgUAAAICHkUAAAICHoUAAAICHsUAAAICHwUAAAICH0UAAAICH4UAAAICH8UAAAICIAUAAAICIEUAAAICIIUAAAICIMUAAAICIQUAAAICIUUAAAICIYUAAAICIcUAAAICIgUAAAICIkUAAAICIoUAAAICIsUAAAICIwUAAAICI0UAAAICI4UAAAICI8UAAAICJAUAAAICJEUAAAICJIUAAAICJMUAAAICJQUAAAICJUUAAAICJYUAAAICJcUAAAICJgUAAAICJkUAAAICJoUAAAICJsUAAAICJwUAAAICJ0UAAAICJ4UAAAICJ8UAAAICKAUAAAICKEUAAAICKIUAAAICKMUAAAICKQUAAAICKUUAAAICKYUAAAICKcUAAAICKgUAAAICKkUAAAICKoUAAAICKsUAAAICKwUAAAICK0UAAAICK4UAAAICK8UAAAICLAUAAAICLEUAAAICLIUAAAICLMUAAAICLQUAAAICLUUAAAICLYUAAAICLcUAAAICLgUAAAICLkUAAAICLoUAAAICLsUAAAICLwUAAAICL0UAAAICL4UAAAICL8UAAAICMAUAAAICMEUAAAICMIUAAAICMMUAAAICMQUAAAICMUUAAAICMYUAAAICMcUAAAICMgUAAAICMkUAAAICMoUAAAICMsUAAAICMwUAAAICM0UAAAICM4UAAAICM8UAAAICNAUAAAICNEUAAAICNIUAAAICNMUAAAICNQUAAAICNUUAAAICNYUAAAICNcUAAAICNgUAAAICNkUAAAICNoUAAAICNsUAAAICNwUAAAICN0UAAAICN4UAAAICN8UAAAICOAUAAAICOEUAAAICOIUAAAICOMUAAAICOQUAAAICOUUAAAICOYUAAAICOcUAAAICOgUAAAICOkUAAAICOoUAAAICOsUAAAICOwUAAAICO0UAAAICO4UAAAICO8UAAAICPAUAAAICPEUAAAICPIUAAAICPMUAAAICPQUAAAICPUUAAAICPYUAAAICPcUAAAICPgUAAAICPkUAAAICPoUAAAICPsUAAAICPwUAAAICP0UAAAICP4UAAAICP8UAAAICAAVAAAICAEVAAAICAIVAAAICAMVAAAICAQVAAAICAUVAAAICAYVAAAICAcVAAAICAgVAAAICAkVAAAICAoVAAAICAsVAAAICAwVAAAICA0VAAAICA4VAAAICA8VAAAICBAVAAAICBEVAAAICBIVAAAICBMVAAAICBQVAAAICBUVAAAICBYVAAAICBcVAAAICBgVAAAICBkVAAAICBoVAAAICBsVAAAICBwVAAAICB0VAAAICB4VAAAICB8VAAAICCAVAAAICCEVAAAICCIVAAAICCMVAAAICCQVAAAICCUVAAAICCYVAAAICCcVAAAICCgVAAAICCkVAAAICCoVAAAICCsVAAAICCwVAAAICC0VAAAICC4VAAAICC8VAAAICDAVAAAICDEVAAAICDIVAAAICDMVAAAICDQVAAAICDUVAAAICDYVAAAICDcVAAAICDgVAAAICDkVAAAICDoVAAAICDsVAAAICDwVAAAICD0VAAAICD4VAAAICD8VAAAICEAVAAAICEEVAAAICEIVAAAICEMVAAAICEQVAAAICEUVAAAICEYVAAAICEcVAAAICEgVAAAICEkVAAAICEoVAAAICEsVAAAICEwVAAAICE0VAAAICE4VAAAICE8VAAAICFAVAAAICFEVAAAICFIVAAAICFMVAAAICFQVAAAICFUVAAAICFYVAAAICFcVAAAICFgVAAAICFkVAAAICFoVAAAICFsVAAAICFwVAAAICF0VAAAICF4VAAAICF8VAAAICGAVAAAICGEVAAAICGIVAAAICGMVAAAICGQVAAAICGUVAAAICGYVAAAICGcVAAAICGgVAAAICGkVAAAICGoVAAAICGsVAAAICGwVAAAICG0VAAAICG4VAAAICG8VAAAICHAVAAAICHEVAAAICHIVAAAICHMVAAAICHQVAAAICHUVAAAICHYVAAAICHcVAAAICHgVAAAICHkVAAAICHoVAAAICHsVAAAICHwVAAAICH0VAAAICH4VAAAICH8VAAAICIAVAAAICIEVAAAICIIVAAAICIMVAAAICIQVAAAICIUVAAAICIYVAAAICIcVAAAICIgVAAAICIkVAAAICIoVAAAICIsVAAAICIwVAAAICI0VAAAICI4VAAAICI8VAAAICJAVAAAICJEVAAAICJIVAAAICJMVAAAICJQVAAAICJUVAAAICJYVAAAICJcVAAAICJgVAAAICJkVAAAICJoVAAAICJsVAAAICJwVAAAICJ0VAAAICJ4VAAAICJ8VAAAICKAVAAAICKEVAAAICKIVAAAICKMVAAAICKQVAAAICKUVAAAICKYVAAAICKcVAAAICKgVAAAICKkVAAAICKoVAAAICKsVAAAICKwVAAAICK0VAAAICK4VAAAICK8VAAAICLAVAAAICLEVAAAICLIVAAAICLMVAAAICLQVAAAICLUVAAAICLYVAAAICLcVAAAICLgVAAAICLkVAAAICLoVAAAICLsVAAAICLwVAAAICL0VAAAICL4VAAAICL8VAAAICMAVAAAICMEVAAAICMIVAAAICMMVAAAICMQVAAAICMUVAAAICMYVAAAICMcVAAAICMgVAAAICMkVAAAICMoVAAAICMsVAAAICMwVAAAICM0VAAAICM4VAAAICM8VAAAICNAVAAAICNEVAAAICNIVAAAICNMVAAAICNQVAAAICNUVAAAICNYVAAAICNcVAAAICNgVAAAICNkVAAAICNoVAAAICNsVAAAICNwVAAAICN0VAAAICN4VAAAICN8VAAAICOAVAAAICOEVAAAICOIVAAAICOMVAAAICOQVAAAICOUVAAAICOYVAAAICOcVAAAICOgVAAAICOkVAAAICOoVAAAICOsVAAAICOwVAAAICO0VAAAICO4VAAAICO8VAAAICPAVAAAICPEVAAAICPIVAAAICPMVAAAICPQVAAAICPUVAAAICPYVAAAICPcVAAAICPgVAAAICPkVAAAICPoVAAAICPsVAAAICPwVAAAICP0VAAAICP4VAAAICP8VAAAICAAWAAAICAEWAAAICAIWAAAICAMWAAAICAQWAAAICAUWAAAICAYWAAAICAcWAAAICAgWAAAICAkWAAAICAoWAAAICAsWAAAICAwWAAAICA0WAAAICA4WAAAICA8WAAAICBAWAAAICBEWAAAICBIWAAAICBMWAAAICBQWAAAICBUWAAAICBYWAAAICBcWAAAICBgWAAAICBkWAAAICBoWAAAICBsWAAAICBwWAAAICB0WAAAICB4WAAAICB8WAAAICCAWAAAICCEWAAAICCIWAAAICCMWAAAICCQWAAAICCUWAAAICCYWAAAICCcWAAAICCgWAAAICCkWAAAICCoWAAAICCsWAAAICCwWAAAICC0WAAAICC4WAAAICC8WAAAICDAWAAAICDEWAAAICDIWAAAICDMWAAAICDQWAAAICDUWAAAICDYWAAAICDcWAAAICDgWAAAICDkWAAAICDoWAAAICDsWAAAICDwWAAAICD0WAAAICD4WAAAICD8WAAAICEAWAAAICEEWAAAICEIWAAAICEMWAAAICEQWAAAICEUWAAAICEYWAAAICEcWAAAICEgWAAAICEkWAAAICEoWAAAICEsWAAAICEwWAAAICE0WAAAICE4WAAAICE8WAAAICFAWAAAICFEWAAAICFIWAAAICFMWAAAICFQWAAAICFUWAAAICFYWAAAICFcWAAAICFgWAAAICFkWAAAICFoWAAAICFsWAAAICFwWAAAICF0WAAAICF4WAAAICF8WAAAICGAWAAAICGEWAAAICGIWAAAICGMWAAAICGQWAAAICGUWAAAICGYWAAAICGcWAAAICGgWAAAICGkWAAAICGoWAAAICGsWAAAICGwWAAAICG0WAAAICG4WAAAICG8WAAAICHAWAAAICHEWAAAICHIWAAAICHMWAAAICHQWAAAICHUWAAAICHYWAAAICHcWAAAICHgWAAAICHkWAAAICHoWAAAICHsWAAAICHwWAAAICH0WAAAICH4WAAAICH8WAAAICIAWAAAICIEWAAAICIIWAAAICIMWAAAICIQWAAAICIUWAAAICIYWAAAICIcWAAAICIgWAAAICIkWAAAICIoWAAAICIsWAAAICIwWAAAICI0WAAAICI4WAAAICI8WAAAICJAWAAAICJEWAAAICJIWAAAICJMWAAAICJQWAAAICJUWAAAICJYWAAAICJcWAAAICJgWAAAICJkWAAAICJoWAAAICJsWAAAICJwWAAAICJ0WAAAICJ4WAAAICJ8WAAAICKAWAAAICKEWAAAICKIWAAAICKMWAAAICKQWAAAICKUWAAAICKYWAAAICKcWAAAICKgWAAAICKkWAAAICKoWAAAICKsWAAAICKwWAAAICK0WAAAICK4WAAAICK8WAAAICLAWAAAICLEWAAAICLIWAAAICLMWAAAICLQWAAAICLUWAAAICLYWAAAICLcWAAAICLgWAAAICLkWAAAICLoWAAAICLsWAAAICLwWAAAICL0WAAAICL4WAAAICL8WAAAICMAWAAAICMEWAAAICMIWAAAICMMWAAAICMQWAAAICMUWAAAICMYWAAAICMcWAAAICMgWAAAICMkWAAAICMoWAAAICMsWAAAICMwWAAAICM0WAAAICM4WAAAICM8WAAAICNAWAAAICNEWAAAICNIWAAAICNMWAAAICNQWAAAICNUWAAAICNYWAAAICNcWAAAICNgWAAAICNkWAAAICNoWAAAICNsWAAAICNwWAAAICN0WAAAICN4WAAAICN8WAAAICOAWAAAICOEWAAAICOIWAAAICOMWAAAICOQWAAAICOUWAAAICOYWAAAICOcWAAAICOgWAAAICOkWAAAICOoWAAAICOsWAAAICOwWAAAICO0WAAAICO4WAAAICO8WAAAICPAWAAAICPEWAAAICPIWAAAICPMWAAAICPQWAAAICPUWAAAICPYWAAAICPcWAAAICPgWAAAICPkWAAAICPoWAAAICPsWAAAICPwWAAAICP0WAAAICP4WAAAICP8WAAAICAAXAAAICAEXAAAICAIXAAAICAMXAAAICAQXAAAICAUXAAAICAYXAAAICAcXAAAICAgXAAAICAkXAAAICAoXAAAICAsXAAAICAwXAAAICA0XAAAICA4XAAAICA8XAAAICBAXAAAICBEXAAAICBIXAAAICBMXAAAICBQXAAAICBUXAAAICBYXAAAICBcXAAAICBgXAAAICBkXAAAICBoXAAAICBsXAAAICBwXAAAICB0XAAAICB4XAAAICB8XAAAICCAXAAAICCEXAAAICCIXAAAICCMXAAAICCQXAAAICCUXAAAICCYXAAAICCcXAAAICCgXAAAICCkXAAAICCoXAAAICCsXAAAICCwXAAAICC0XAAAICC4XAAAICC8XAAAICDAXAAAICDEXAAAICDIXAAAICDMXAAAICDQXAAAICDUXAAAICDYXAAAICDcXAAAICDgXAAAICDkXAAAICDoXAAAICDsXAAAICDwXAAAICD0XAAAICD4XAAAICD8XAAAICEAXAAAICEEXAAAICEIXAAAICEMXAAAICEQXAAAICEUXAAAICEYXAAAICEcXAAAICEgXAAAICEkXAAAICEoXAAAICEsXAAAICEwXAAAICE0XAAAICE4XAAAICE8XAAAICFAXAAAICFEXAAAICFIXAAAICFMXAAAICFQXAAAICFUXAAAICFYXAAAICFcXAAAICFgXAAAICFkXAAAICFoXAAAICFsXAAAICFwXAAAICF0XAAAICF4XAAAICF8XAAAICGAXAAAICGEXAAAICGIXAAAICGMXAAAICGQXAAAICGUXAAAICGYXAAAICGcXAAAICGgXAAAICGkXAAAICGoXAAAICGsXAAAICGwXAAAICG0XAAAICG4XAAAICG8XAAAICHAXAAAICHEXAAAICHIXAAAICHMXAAAICHQXAAAICHUXAAAICHYXAAAICHcXAAAICHgXAAAICHkXAAAICHoXAAAICHsXAAAICHwXAAAICH0XAAAICH4XAAAICH8XAAAICIAXAAAICIEXAAAICIIXAAAICIMXAAAICIQXAAAICIUXAAAICIYXAAAICIcXAAAICIgXAAAICIkXAAAICIoXAAAICIsXAAAICIwXAAAICI0XAAAICI4XAAAICI8XAAAICJAXAAAICJEXAAAICJIXAAAICJMXAAAICJQXAAAICJUXAAAICJYXAAAICJcXAAAICJgXAAAICJkXAAAICJoXAAAICJsXAAAICJwXAAAICJ0XAAAICJ4XAAAICJ8XAAAICKAXAAAICKEXAAAICKIXAAAICKMXAAAICKQXAAAICKUXAAAICKYXAAAICKcXAAAICKgXAAAICKkXAAAICKoXAAAICKsXAAAICKwXAAAICK0XAAAICK4XAAAICK8XAAAICLAXAAAICLEXAAAICLIXAAAICLMXAAAICLQXAAAICLUXAAAICLYXAAAICLcXAAAICLgXAAAICLkXAAAICLoXAAAICLsXAAAICLwXAAAICL0XAAAICL4XAAAICL8XAAAICMAXAAAICMEXAAAICMIXAAAICMMXAAAICMQXAAAICMUXAAAICMYXAAAICMcXAAAICMgXAAAICMkXAAAICMoXAAAICMsXAAAICMwXAAAICM0XAAAICM4XAAAICM8XAAAICNAXAAAICNEXAAAICNIXAAAICNMXAAAICNQXAAAICNUXAAAICNYXAAAICNcXAAAICNgXAAAICNkXAAAICNoXAAAICNsXAAAICNwXAAAICN0XAAAICN4XAAAICN8XAAAICOAXAAAICOEXAAAICOIXAAAICOMXAAAICOQXAAAICOUXAAAICOYXAAAICOcXAAAICOgXAAAICOkXAAAICOoXAAAICOsXAAAICOwXAAAICO0XAAAICO4XAAAICO8XAAAICPAXAAAICPEXAAAICPIXAAAICPMXAAAICPQXAAAICPUXAAAICPYXAAAICPcXAAAICPgXAAAICPkXAAAICPoXAAAICPsXAAAICPwXAAAICP0XAAAICP4XAAAICP8XAAAICAAYAAAICAEYAAAICAIYAAAICAMYAAAICAQYAAAICAUYAAAICAYYAAAICAcYAAAICAgYAAAICAkYAAAICAoYAAAICAsYAAAICAwYAAAICA0YAAAICA4YAAAICA8YAAAICBAYAAAICBEYAAAICBIYAAAICBMYAAAICBQYAAAICBUYAAAICBYYAAAICBcYAAAICBgYAAAICBkYAAAICBoYAAAICBsYAAAICBwYAAAICB0YAAAICB4YAAAICB8YAAAICCAYAAAICCEYAAAICCIYAAAICCMYAAAICCQYAAAICCUYAAAICCYYAAAICCcYAAAICCgYAAAICCkYAAAICCoYAAAICCsYAAAICCwYAAAICC0YAAAICC4YAAAICC8YAAAICDAYAAAICDEYAAAICDIYAAAICDMYAAAICDQYAAAICDUYAAAICDYYAAAICDcYAAAICDgYAAAICDkYAAAICDoYAAAICDsYAAAICDwYAAAICD0YAAAICD4YAAAICD8YAAAICEAYAAAICEEYAAAICEIYAAAICEMYAAAICEQYAAAICEUYAAAICEYYAAAICEcYAAAICEgYAAAICEkYAAAICEoYAAAICEsYAAAICEwYAAAICE0YAAAICE4YAAAICE8YAAAICFAYAAAICFEYAAAICFIYAAAICFMYAAAICFQYAAAICFUYAAAICFYYAAAICFcYAAAICFgYAAAICFkYAAAICFoYAAAICFsYAAAICFwYAAAICF0YAAAICF4YAAAICF8YAAAICGAYAAAICGEYAAAICGIYAAAICGMYAAAICGQYAAAICGUYAAAICGYYAAAICGcYAAAICGgYAAAICGkYAAAICGoYAAAICGsYAAAICGwYAAAICG0YAAAICG4YAAAICG8YAAAICHAYAAAICHEYAAAICHIYAAAICHMYAAAICHQYAAAICHUYAAAICHYYAAAICHcYAAAICHgYAAAICHkYAAAICHoYAAAICHsYAAAICHwYAAAICH0YAAAICH4YAAAICH8YAAAICIAYAAAICIEYAAAICIIYAAAICIMYAAAICIQYAAAICIUYAAAICIYYAAAICIcYAAAICIgYAAAICIkYAAAICIoYAAAICIsYAAAICIwYAAAICI0YAAAICI4YAAAICI8YAAAICJAYAAAICJEYAAAICJIYAAAICJMYAAAICJQYAAAICJUYAAAICJYYAAAICJcYAAAICJgYAAAICJkYAAAICJoYAAAICJsYAAAICJwYAAAICJ0YAAAICJ4YAAAICJ8YAAAICKAYAAAICKEYAAAICKIYAAAICKMYAAAICKQYAAAICKUYAAAICKYYAAAICKcYAAAICKgYAAAICKkYAAAICKoYAAAICKsYAAAICKwYAAAICK0YAAAICK4YAAAICK8YAAAICLAYAAAICLEYAAAICLIYAAAICLMYAAAICLQYAAAICLUYAAAICLYYAAAICLcYAAAICLgYAAAICLkYAAAICLoYAAAICLsYAAAICLwYAAAICL0YAAAICL4YAAAICL8YAAAICMAYAAAICMEYAAAICMIYAAAICMMYAAAICMQYAAAICMUYAAAICMYYAAAICMcYAAAICMgYAAAICMkYAAAICMoYAAAICMsYAAAICMwYAAAICM0YAAAICM4YAAAICM8YAAAICNAYAAAICNEYAAAICNIYAAAICNMYAAAICNQYAAAICNUYAAAICNYYAAAICNcYAAAICNgYAAAICNkYAAAICNoYAAAICNsYAAAICNwYAAAICN0YAAAICN4YAAAICN8YAAAICOAYAAAICOEYAAAICOIYAAAICOMYAAAICOQYAAAICOUYAAAICOYYAAAICOcYAAAICOgYAAAICOkYAAAICOoYAAAICOsYAAAICOwYAAAICO0YAAAICO4YAAAICO8YAAAICPAYAAAICPEYAAAICPIYAAAICPMYAAAICPQYAAAICPUYAAAICPYYAAAICPcYAAAICPgYAAAICPkYAAAICPoYAAAICPsYAAAICPwYAAAICP0YAAAICP4YAAAICP8YAAAICAAZAAAICAEZAAAICAIZAAAICAMZAAAICAQZAAAICAUZAAAICAYZAAAICAcZAAAICAgZAAAICAkZAAAICAoZAAAICAsZAAAICAwZAAAICA0ZAAAICA4ZAAAICA8ZAAAICBAZAAAICBEZAAAICBIZAAAICBMZAAAICBQZAAAICBUZAAAICBYZAAAICBcZAAAICBgZAAAICBkZAAAICBoZAAAICBsZAAAICBwZAAAICB0ZAAAICB4ZAAAICB8ZAAAICCAZAAAICCEZAAAICCIZAAAICCMZAAAICCQZAAAICCUZAAAICCYZAAAICCcZAAAICCgZAAAICCkZAAAICCoZAAAICCsZAAAICCwZAAAICC0ZAAAICC4ZAAAICC8ZAAAICDAZAAAICDEZAAAICDIZAAAICDMZAAAICDQZAAAICDUZAAAICDYZAAAICDcZAAAICDgZAAAICDkZAAAICDoZAAAICDsZAAAICDwZAAAICD0ZAAAICD4ZAAAICD8ZAAAICEAZAAAICEEZAAAICEIZAAAICEMZAAAICEQZAAAICEUZAAAICEYZAAAICEcZAAAICEgZAAAICEkZAAAICEoZAAAICEsZAAAICEwZAAAICE0ZAAAICE4ZAAAICE8ZAAAICFAZAAAICFEZAAAICFIZAAAICFMZAAAICFQZAAAICFUZAAAICFYZAAAICFcZAAAICFgZAAAICFkZAAAICFoZAAAICFsZAAAICFwZAAAICF0ZAAAICF4ZAAAICF8ZAAAICGAZAAAICGEZAAAICGIZAAAICGMZAAAICGQZAAAICGUZAAAICGYZAAAICGcZAAAICGgZAAAICGkZAAAICGoZAAAICGsZAAAICGwZAAAICG0ZAAAICG4ZAAAICG8ZAAAICHAZAAAICHEZAAAICHIZAAAICHMZAAAICHQZAAAICHUZAAAICHYZAAAICHcZAAAICHgZAAAICHkZAAAICHoZAAAICHsZAAAICHwZAAAICH0ZAAAICH4ZAAAICH8ZAAAICIAZAAAICIEZAAAICIIZAAAICIMZAAAICIQZAAAICIUZAAAICIYZAAAICIcZAAAICIgZAAAICIkZAAAICIoZAAAICIsZAAAICIwZAAAICI0ZAAAICI4ZAAAICI8ZAAAICJAZAAAICJEZAAAICJIZAAAICJMZAAAICJQZAAAICJUZAAAICJYZAAAICJcZAAAICJgZAAAICJkZAAAICJoZAAAICJsZAAAICJwZAAAICJ0ZAAAICJ4ZAAAICJ8ZAAAICKAZAAAICKEZAAAICKIZAAAICKMZAAAICKQZAAAICKUZAAAICKYZAAAICKcZAAAICKgZAAAICKkZAAAICKoZAAAICKsZAAAICKwZAAAICK0ZAAAICK4ZAAAICK8ZAAAICLAZAAAICLEZAAAICLIZAAAICLMZAAAICLQZAAAICLUZAAAICLYZAAAICLcZAAAICLgZAAAICLkZAAAICLoZAAAICLsZAAAICLwZAAAICL0ZAAAICL4ZAAAICL8ZAAAICMAZAAAICMEZAAAICMIZAAAICMMZAAAICMQZAAAICMUZAAAICMYZAAAICMcZAAAICMgZAAAICMkZAAAICMoZAAAICMsZAAAICMwZAAAICM0ZAAAICM4ZAAAICM8ZAAAICNAZAAAICNEZAAAICNIZAAAICNMZAAAICNQZAAAICNUZAAAICNYZAAAICNcZAAAICNgZAAAICNkZAAAICNoZAAAICNsZAAAICNwZAAAICN0ZAAAICN4ZAAAICN8ZAAAICOAZAAAICOEZAAAICOIZAAAICOMZAAAICOQZAAAICOUZAAAICOYZAAAICOcZAAAICOgZAAAICOkZAAAICOoZAAAICOsZAAAICOwZAAAICO0ZAAAICO4ZAAAICO8ZAAAICPAZAAAICPEZAAAICPIZAAAICPMZAAAICPQZAAAICPUZAAAICPYZAAAICPcZAAAICPgZAAAICPkZAAAICPoZAAAICPsZAAAICPwZAAAICP0ZAAAICP4ZAAAICP8ZAAAICAAaAAAICAEaAAAICAIaAAAICAMaAAAICAQaAAAICAUaAAAICAYaAAAICAcaAAAICAgaAAAICAkaAAAICAoaAAAICAsaAAAICAwaAAAICA0aAAAICA4aAAAICA8aAAAICBAaAAAICBEaAAAICBIaAAAICBMaAAAICBQaAAAICBUaAAAICBYaAAAICBcaAAAICBgaAAAICBkaAAAICBoaAAAICBsaAAAICBwaAAAICB0aAAAICB4aAAAICB8aAAAICCAaAAAICCEaAAAICCIaAAAICCMaAAAICCQaAAAICCUaAAAICCYaAAAICCcaAAAICCgaAAAICCkaAAAICCoaAAAICCsaAAAICCwaAAAICC0aAAAICC4aAAAICC8aAAAICDAaAAAICDEaAAAICDIaAAAICDMaAAAICDQaAAAICDUaAAAICDYaAAAICDcaAAAICDgaAAAICDkaAAAICDoaAAAICDsaAAAICDwaAAAICD0aAAAICD4aAAAICD8aAAAICEAaAAAICEEaAAAICEIaAAAICEMaAAAICEQaAAAICEUaAAAICEYaAAAICEcaAAAICEgaAAAICEkaAAAICEoaAAAICEsaAAAICEwaAAAICE0aAAAICE4aAAAICE8aAAAICFAaAAAICFEaAAAICFIaAAAICFMaAAAICFQaAAAICFUaAAAICFYaAAAICFcaAAAICFgaAAAICFkaAAAICFoaAAAICFsaAAAICFwaAAAICF0aAAAICF4aAAAICF8aAAAICGAaAAAICGEaAAAICGIaAAAICGMaAAAICGQaAAAICGUaAAAICGYaAAAICGcaAAAICGgaAAAICGkaAAAICGoaAAAICGsaAAAICGwaAAAICG0aAAAICG4aAAAICG8aAAAICHAaAAAICHEaAAAICHIaAAAICHMaAAAICHQaAAAICHUaAAAICHYaAAAICHcaAAAICHgaAAAICHkaAAAICHoaAAAICHsaAAAICHwaAAAICH0aAAAICH4aAAAICH8aAAAICIAaAAAICIEaAAAICIIaAAAICIMaAAAICIQaAAAICIUaAAAICIYaAAAICIcaAAAICIgaAAAICIkaAAAICIoaAAAICIsaAAAICIwaAAAICI0aAAAICI4aAAAICI8aAAAICJAaAAAICJEaAAAICJIaAAAICJMaAAAICJQaAAAICJUaAAAICJYaAAAICJcaAAAICJgaAAAICJkaAAAICJoaAAAICJsaAAAICJwaAAAICJ0aAAAICJ4aAAAICJ8aAAAICKAaAAAICKEaAAAICKIaAAAICKMaAAAICKQaAAAICKUaAAAICKYaAAAICKcaAAAICKgaAAAICKkaAAAICKoaAAAICKsaAAAICKwaAAAICK0aAAAICK4aAAAICK8aAAAICLAaAAAICLEaAAAICLIaAAAICLMaAAAICLQaAAAICLUaAAAICLYaAAAICLcaAAAICLgaAAAICLkaAAAICLoaAAAICLsaAAAICLwaAAAICL0aAAAICL4aAAAICL8aAAAICMAaAAAICMEaAAAICMIaAAAICMMaAAAICMQaAAAICMUaAAAICMYaAAAICMcaAAAICMgaAAAICMkaAAAICMoaAAAICMsaAAAICMwaAAAICM0aAAAICM4aAAAICM8aAAAICNAaAAAICNEaAAAICNIaAAAICNMaAAAICNQaAAAICNUaAAAICNYaAAAICNcaAAAICNgaAAAICNkaAAAICNoaAAAICNsaAAAICNwaAAAICN0aAAAICN4aAAAICN8aAAAICOAaAAAICOEaAAAICOIaAAAICOMaAAAICOQaAAAICOUaAAAICOYaAAAICOcaAAAICOgaAAAICOkaAAAICOoaAAAICOsaAAAICOwaAAAICO0aAAAICO4aAAAICO8aAAAICPAaAAAICPEaAAAICPIaAAAICPMaAAAICPQaAAAICPUaAAAICPYaAAAICPcaAAAICPgaAAAICPkaAAAICPoaAAAICPsaAAAICPwaAAAICP0aAAAICP4aAAAICP8aAAAICAAbAAAICAEbAAAICAIbAAAICAMbAAAICAQbAAAICAUbAAAICAYbAAAICAcbAAAICAgbAAAICAkbAAAICAobAAAICAsbAAAICAwbAAAICA0bAAAICA4bAAAICA8bAAAICBAbAAAICBEbAAAICBIbAAAICBMbAAAICBQbAAAICBUbAAAICBYbAAAICBcbAAAICBgbAAAICBkbAAAICBobAAAICBsbAAAICBwbAAAICB0bAAAICB4bAAAICB8bAAAICCAbAAAICCEbAAAICCIbAAAICCMbAAAICCQbAAAICCUbAAAICCYbAAAICCcbAAAICCgbAAAICCkbAAAICCobAAAICCsbAAAICCwbAAAICC0bAAAICC4bAAAICC8bAAAICDAbAAAICDEbAAAICDIbAAAICDMbAAAICDQbAAAICDUbAAAICDYbAAAICDcbAAAICDgbAAAICDkbAAAICDobAAAICDsbAAAICDwbAAAICD0bAAAICD4bAAAICD8bAAAICEAbAAAICEEbAAAICEIbAAAICEMbAAAICEQbAAAICEUbAAAICEYbAAAICEcbAAAICEgbAAAICEkbAAAICEobAAAICEsbAAAICEwbAAAICE0bAAAICE4bAAAICE8bAAAICFAbAAAICFEbAAAICFIbAAAICFMbAAAICFQbAAAICFUbAAAICFYbAAAICFcbAAAICFgbAAAICFkbAAAICFobAAAICFsbAAAICFwbAAAICF0bAAAICF4bAAAICF8bAAAICGAbAAAICGEbAAAICGIbAAAICGMbAAAICGQbAAAICGUbAAAICGYbAAAICGcbAAAICGgbAAAICGkbAAAICGobAAAICGsbAAAICGwbAAAICG0bAAAICG4bAAAICG8bAAAICHAbAAAICHEbAAAICHIbAAAICHMbAAAICHQbAAAICHUbAAAICHYbAAAICHcbAAAICHgbAAAICHkbAAAICHobAAAICHsbAAAICHwbAAAICH0bAAAICH4bAAAICH8bAAAICIAbAAAICIEbAAAICIIbAAAICIMbAAAICIQbAAAICIUbAAAICIYbAAAICIcbAAAICIgbAAAICIkbAAAICIobAAAICIsbAAAICIwbAAAICI0bAAAICI4bAAAICI8bAAAICJAbAAAICJEbAAAICJIbAAAICJMbAAAICJQbAAAICJUbAAAICJYbAAAICJcbAAAICJgbAAAICJkbAAAICJobAAAICJsbAAAICJwbAAAICJ0bAAAICJ4bAAAICJ8bAAAICKAbAAAICKEbAAAICKIbAAAICKMbAAAICKQbAAAICKUbAAAICKYbAAAICKcbAAAICKgbAAAICKkbAAAICKobAAAICKsbAAAICKwbAAAICK0bAAAICK4bAAAICK8bAAAICLAbAAAICLEbAAAICLIbAAAICLMbAAAICLQbAAAICLUbAAAICLYbAAAICLcbAAAICLgbAAAICLkbAAAICLobAAAICLsbAAAICLwbAAAICL0bAAAICL4bAAAICL8bAAAICMAbAAAICMEbAAAICMIbAAAICMMbAAAICMQbAAAICMUbAAAICMYbAAAICMcbAAAICMgbAAAICMkbAAAICMobAAAICMsbAAAICMwbAAAICM0bAAAICM4bAAAICM8bAAAICNAbAAAICNEbAAAICNIbAAAICNMbAAAICNQbAAAICNUbAAAICNYbAAAICNcbAAAICNgbAAAICNkbAAAICNobAAAICNsbAAAICNwbAAAICN0bAAAICN4bAAAICN8bAAAICOAbAAAICOEbAAAICOIbAAAICOMbAAAICOQbAAAICOUbAAAICOYbAAAICOcbAAAICOgbAAAICOkbAAAICOobAAAICOsbAAAICOwbAAAICO0bAAAICO4bAAAICO8bAAAICPAbAAAICPEbAAAICPIbAAAICPMbAAAICPQbAAAICPUbAAAICPYbAAAICPcbAAAICPgbAAAICPkbAAAICPobAAAICPsbAAAICPwbAAAICP0bAAAICP4bAAAICP8bAAAICAAcAAAICAEcAAAICAIcAAAICAMcAAAICAQcAAAICAUcAAAICAYcAAAICAccAAAICAgcAAAICAkcAAAICAocAAAICAscAAAICAwcAAAICA0cAAAICA4cAAAICA8cAAAICBAcAAAICBEcAAAICBIcAAAICBMcAAAICBQcAAAICBUcAAAICBYcAAAICBccAAAICBgcAAAICBkcAAAICBocAAAICBscAAAICBwcAAAICB0cAAAICB4cAAAICB8cAAAICCAcAAAICCEcAAAICCIcAAAICCMcAAAICCQcAAAICCUcAAAICCYcAAAICCccAAAICCgcAAAICCkcAAAICCocAAAICCscAAAICCwcAAAICC0cAAAICC4cAAAICC8cAAAICDAcAAAICDEcAAAICDIcAAAICDMcAAAICDQcAAAICDUcAAAICDYcAAAICDccAAAICDgcAAAICDkcAAAICDocAAAICDscAAAICDwcAAAICD0cAAAICD4cAAAICD8cAAAICEAcAAAICEEcAAAICEIcAAAICEMcAAAICEQcAAAICEUcAAAICEYcAAAICEccAAAICEgcAAAICEkcAAAICEocAAAICEscAAAICEwcAAAICE0cAAAICE4cAAAICE8cAAAICFAcAAAICFEcAAAICFIcAAAICFMcAAAICFQcAAAICFUcAAAICFYcAAAICFccAAAICFgcAAAICFkcAAAICFocAAAICFscAAAICFwcAAAICF0cAAAICF4cAAAICF8cAAAICGAcAAAICGEcAAAICGIcAAAICGMcAAAICGQcAAAICGUcAAAICGYcAAAICGccAAAICGgcAAAICGkcAAAICGocAAAICGscAAAICGwcAAAICG0cAAAICG4cAAAICG8cAAAICHAcAAAICHEcAAAICHIcAAAICHMcAAAICHQcAAAICHUcAAAICHYcAAAICHccAAAICHgcAAAICHkcAAAICHocAAAICHscAAAICHwcAAAICH0cAAAICH4cAAAICH8cAAAICIAcAAAICIEcAAAICIIcAAAICIMcAAAICIQcAAAICIUcAAAICIYcAAAICIccAAAICIgcAAAICIkcAAAICIocAAAICIscAAAICIwcAAAICI0cAAAICI4cAAAICI8cAAAICJAcAAAICJEcAAAICJIcAAAICJMcAAAICJQcAAAICJUcAAAICJYcAAAICJccAAAICJgcAAAICJkcAAAICJocAAAICJscAAAICJwcAAAICJ0cAAAICJ4cAAAICJ8cAAAICKAcAAAICKEcAAAICKIcAAAICKMcAAAICKQcAAAICKUcAAAICKYcAAAICKccAAAICKgcAAAICKkcAAAICKocAAAICKscAAAICKwcAAAICK0cAAAICK4cAAAICK8cAAAICLAcAAAICLEcAAAICLIcAAAICLMcAAAICLQcAAAICLUcAAAICLYcAAAICLccAAAICLgcAAAICLkcAAAICLocAAAICLscAAAICLwcAAAICL0cAAAICL4cAAAICL8cAAAICMAcAAAICMEcAAAICMIcAAAICMMcAAAICMQcAAAICMUcAAAICMYcAAAICMccAAAICMgcAAAICMkcAAAICMocAAAICMscAAAICMwcAAAICM0cAAAICM4cAAAICM8cAAAICNAcAAAICNEcAAAICNIcAAAICNMcAAAICNQcAAAICNUcAAAICNYcAAAICNccAAAICNgcAAAICNkcAAAICNocAAAICNscAAAICNwcAAAICN0cAAAICN4cAAAICN8cAAAICOAcAAAICOEcAAAICOIcAAAICOMcAAAICOQcAAAICOUcAAAICOYcAAAICOccAAAICOgcAAAICOkcAAAICOocAAAICOscAAAICOwcAAAICO0cAAAICO4cAAAICO8cAAAICPAcAAAICPEcAAAICPIcAAAICPMcAAAICPQcAAAICPUcAAAICPYcAAAICPccAAAICPgcAAAICPkcAAAICPocAAAICPscAAAICPwcAAAICP0cAAAICP4cAAAICP8cAAAICAAdAAAICAEdAAAICAIdAAAICAMdAAAICAQdAAAICAUdAAAICAYdAAAICAcdAAAICAgdAAAICAkdAAAICAodAAAICAsdAAAICAwdAAAICA0dAAAICA4dAAAICA8dAAAICBAdAAAICBEdAAAICBIdAAAICBMdAAAICBQdAAAICBUdAAAICBYdAAAICBcdAAAICBgdAAAICBkdAAAICBodAAAICBsdAAAICBwdAAAICB0dAAAICB4dAAAICB8dAAAICCAdAAAICCEdAAAICCIdAAAICCMdAAAICCQdAAAICCUdAAAICCYdAAAICCcdAAAICCgdAAAICCkdAAAICCodAAAICCsdAAAICCwdAAAICC0dAAAICC4dAAAICC8dAAAICDAdAAAICDEdAAAICDIdAAAICDMdAAAICDQdAAAICDUdAAAICDYdAAAICDcdAAAICDgdAAAICDkdAAAICDodAAAICDsdAAAICDwdAAAICD0dAAAICD4dAAAICD8dAAAICEAdAAAICEEdAAAICEIdAAAICEMdAAAICEQdAAAICEUdAAAICEYdAAAICEcdAAAICEgdAAAICEkdAAAICEodAAAICEsdAAAICEwdAAAICE0dAAAICE4dAAAICE8dAAAICFAdAAAICFEdAAAICFIdAAAICFMdAAAICFQdAAAICFUdAAAICFYdAAAICFcdAAAICFgdAAAICFkdAAAICFodAAAICFsdAAAICFwdAAAICF0dAAAICF4dAAAICF8dAAAICGAdAAAICGEdAAAICGIdAAAICGMdAAAICGQdAAAICGUdAAAICGYdAAAICGcdAAAICGgdAAAICGkdAAAICGodAAAICGsdAAAICGwdAAAICG0dAAAICG4dAAAICG8dAAAICHAdAAAICHEdAAAICHIdAAAICHMdAAAICHQdAAAICHUdAAAICHYdAAAICHcdAAAICHgdAAAICHkdAAAICHodAAAICHsdAAAICHwdAAAICH0dAAAICH4dAAAICH8dAAAICIAdAAAICIEdAAAICIIdAAAICIMdAAAICIQdAAAICIUdAAAICIYdAAAICIcdAAAICIgdAAAICIkdAAAICIodAAAICIsdAAAICIwdAAAICI0dAAAICI4dAAAICI8dAAAICJAdAAAICJEdAAAICJIdAAAICJMdAAAICJQdAAAICJUdAAAICJYdAAAICJcdAAAICJgdAAAICJkdAAAICJodAAAICJsdAAAICJwdAAAICJ0dAAAICJ4dAAAICJ8dAAAICKAdAAAICKEdAAAICKIdAAAICKMdAAAICKQdAAAICKUdAAAICKYdAAAICKcdAAAICKgdAAAICKkdAAAICKodAAAICKsdAAAICKwdAAAICK0dAAAICK4dAAAICK8dAAAICLAdAAAICLEdAAAICLIdAAAICLMdAAAICLQdAAAICLUdAAAICLYdAAAICLcdAAAICLgdAAAICLkdAAAICLodAAAICLsdAAAICLwdAAAICL0dAAAICL4dAAAICL8dAAAICMAdAAAICMEdAAAICMIdAAAICMMdAAAICMQdAAAICMUdAAAICMYdAAAICMcdAAAICMgdAAAICMkdAAAICModAAAICMsdAAAICMwdAAAICM0dAAAICM4dAAAICM8dAAAICNAdAAAICNEdAAAICNIdAAAICNMdAAAICNQdAAAICNUdAAAICNYdAAAICNcdAAAICNgdAAAICNkdAAAICNodAAAICNsdAAAICNwdAAAICN0dAAAICN4dAAAICN8dAAAICOAdAAAICOEdAAAICOIdAAAICOMdAAAICOQdAAAICOUdAAAICOYdAAAICOcdAAAICOgdAAAICOkdAAAICOodAAAICOsdAAAICOwdAAAICO0dAAAICO4dAAAICO8dAAAICPAdAAAICPEdAAAICPIdAAAICPMdAAAICPQdAAAICPUdAAAICPYdAAAICPcdAAAICPgdAAAICPkdAAAICPodAAAICPsdAAAICPwdAAAICP0dAAAICP4dAAAICP8dAAAICAAeAAAICAEeAAAICAIeAAAICAMeAAAICAQeAAAICAUeAAAICAYeAAAICAceAAAICAgeAAAICAkeAAAICAoeAAAICAseAAAICAweAAAICA0eAAAICA4eAAAICA8eAAAICBAeAAAICBEeAAAICBIeAAAICBMeAAAICBQeAAAICBUeAAAICBYeAAAICBceAAAICBgeAAAICBkeAAAICBoeAAAICBseAAAICBweAAAICB0eAAAICB4eAAAICB8eAAAICCAeAAAICCEeAAAICCIeAAAICCMeAAAICCQeAAAICCUeAAAICCYeAAAICCceAAAICCgeAAAICCkeAAAICCoeAAAICCseAAAICCweAAAICC0eAAAICC4eAAAICC8eAAAICDAeAAAICDEeAAAICDIeAAAICDMeAAAICDQeAAAICDUeAAAICDYeAAAICDceAAAICDgeAAAICDkeAAAICDoeAAAICDseAAAICDweAAAICD0eAAAICD4eAAAICD8eAAAICEAeAAAICEEeAAAICEIeAAAICEMeAAAICEQeAAAICEUeAAAICEYeAAAICEceAAAICEgeAAAICEkeAAAICEoeAAAICEseAAAICEweAAAICE0eAAAICE4eAAAICE8eAAAICFAeAAAICFEeAAAICFIeAAAICFMeAAAICFQeAAAICFUeAAAICFYeAAAICFceAAAICFgeAAAICFkeAAAICFoeAAAICFseAAAICFweAAAICF0eAAAICF4eAAAICF8eAAAICGAeAAAICGEeAAAICGIeAAAICGMeAAAICGQeAAAICGUeAAAICGYeAAAICGceAAAICGgeAAAICGkeAAAICGoeAAAICGseAAAICGweAAAICG0eAAAICG4eAAAICG8eAAAICHAeAAAICHEeAAAICHIeAAAICHMeAAAICHQeAAAICHUeAAAICHYeAAAICHceAAAICHgeAAAICHkeAAAICHoeAAAICHseAAAICHweAAAICH0eAAAICH4eAAAICH8eAAAICIAeAAAICIEeAAAICIIeAAAICIMeAAAICIQeAAAICIUeAAAICIYeAAAICIceAAAICIgeAAAICIkeAAAICIoeAAAICIseAAAICIweAAAICI0eAAAICI4eAAAICI8eAAAICJAeAAAICJEeAAAICJIeAAAICJMeAAAICJQeAAAICJUeAAAICJYeAAAICJceAAAICJgeAAAICJkeAAAICJoeAAAICJseAAAICJweAAAICJ0eAAAICJ4eAAAICJ8eAAAICKAeAAAICKEeAAAICKIeAAAICKMeAAAICKQeAAAICKUeAAAICKYeAAAICKceAAAICKgeAAAICKkeAAAICKoeAAAICKseAAAICKweAAAICK0eAAAICK4eAAAICK8eAAAICLAeAAAICLEeAAAICLIeAAAICLMeAAAICLQeAAAICLUeAAAICLYeAAAICLceAAAICLgeAAAICLkeAAAICLoeAAAICLseAAAICLweAAAICL0eAAAICL4eAAAICL8eAAAICMAeAAAICMEeAAAICMIeAAAICMMeAAAICMQeAAAICMUeAAAICMYeAAAICMceAAAICMgeAAAICMkeAAAICMoeAAAICMseAAAICMweAAAICM0eAAAICM4eAAAICM8eAAAICNAeAAAICNEeAAAICNIeAAAICNMeAAAICNQeAAAICNUeAAAICNYeAAAICNceAAAICNgeAAAICNkeAAAICNoeAAAICNseAAAICNweAAAICN0eAAAICN4eAAAICN8eAAAICOAeAAAICOEeAAAICOIeAAAICOMeAAAICOQeAAAICOUeAAAICOYeAAAICOceAAAICOgeAAAICOkeAAAICOoeAAAICOseAAAICOweAAAICO0eAAAICO4eAAAICO8eAAAICPAeAAAICPEeAAAICPIeAAAICPMeAAAICPQeAAAICPUeAAAICPYeAAAICPceAAAICPgeAAAICPkeAAAICPoeAAAICPseAAAICPweAAAICP0eAAAICP4eAAAICP8eAAAICAAfAAAICAEfAAAICAIfAAAICAMfAAAICAQfAAAICAUfAAAICAYfAAAICAcfAAAICAgfAAAICAkfAAAICAofAAAICAsfAAAICAwfAAAICA0fAAAICA4fAAAICA8fAAAICBAfAAAICBEfAAAICBIfAAAICBMfAAAICBQfAAAICBUfAAAICBYfAAAICBcfAAAICBgfAAAICBkfAAAICBofAAAICBsfAAAICBwfAAAICB0fAAAICB4fAAAICB8fAAAICCAfAAAICCEfAAAICCIfAAAICCMfAAAICCQfAAAICCUfAAAICCYfAAAICCcfAAAICCgfAAAICCkfAAAICCofAAAICCsfAAAICCwfAAAICC0fAAAICC4fAAAICC8fAAAICDAfAAAICDEfAAAICDIfAAAICDMfAAAICDQfAAAICDUfAAAICDYfAAAICDcfAAAICDgfAAAICDkfAAAICDofAAAICDsfAAAICDwfAAAICD0fAAAICD4fAAAICD8fAAAICEAfAAAICEEfAAAICEIfAAAICEMfAAAICEQfAAAICEUfAAAICEYfAAAICEcfAAAICEgfAAAICEkfAAAICEofAAAICEsfAAAICEwfAAAICE0fAAAICE4fAAAICE8fAAAICFAfAAAICFEfAAAICFIfAAAICFMfAAAICFQfAAAICFUfAAAICFYfAAAICFcfAAAICFgfAAAICFkfAAAICFofAAAICFsfAAAICFwfAAAICF0fAAAICF4fAAAICF8fAAAICGAfAAAICGEfAAAICGIfAAAICGMfAAAICGQfAAAICGUfAAAICGYfAAAICGcfAAAICGgfAAAICGkfAAAICGofAAAICGsfAAAICGwfAAAICG0fAAAICG4fAAAICG8fAAAICHAfAAAICHEfAAAICHIfAAAICHMfAAAICHQfAAAICHUfAAAICHYfAAAICHcfAAAICHgfAAAICHkfAAAICHofAAAICHsfAAAICHwfAAAICH0fAAAICH4fAAAICH8fAAAICIAfAAAICIEfAAAICIIfAAAICIMfAAAICIQfAAAICIUfAAAICIYfAAAICIcfAAAICIgfAAAICIkfAAAICIofAAAICIsfAAAICIwfAAAICI0fAAAICI4fAAAICI8fAAAICJAfAAAICJEfAAAICJIfAAAICJMfAAAICJQfAAAICJUfAAAICJYfAAAICJcfAAAICJgfAAAICJkfAAAICJofAAAICJsfAAAICJwfAAAICJ0fAAAICJ4fAAAICJ8fAAAICKAfAAAICKEfAAAICKIfAAAICKMfAAAICKQfAAAICKUfAAAICKYfAAAICKcfAAAICKgfAAAICKkfAAAICKofAAAICKsfAAAICKwfAAAICK0fAAAICK4fAAAICK8fAAAICLAfAAAICLEfAAAICLIfAAAICLMfAAAICLQfAAAICLUfAAAICLYfAAAICLcfAAAICLgfAAAICLkfAAAICLofAAAICLsfAAAICLwfAAAICL0fAAAICL4fAAAICL8fAAAICMAfAAAICMEfAAAICMIfAAAICMMfAAAICMQfAAAICMUfAAAICMYfAAAICMcfAAAICMgfAAAICMkfAAAICMofAAAICMsfAAAICMwfAAAICM0fAAAICM4fAAAICM8fAAAICNAfAAAICNEfAAAICNIfAAAICNMfAAAICNQfAAAICNUfAAAICNYfAAAICNcfAAAICNgfAAAICNkfAAAICNofAAAICNsfAAAICNwfAAAICN0fAAAICN4fAAAICN8fAAAICOAfAAAICOEfAAAICOIfAAAICOMfAAAICOQfAAAICOUfAAAICOYfAAAICOcfAAAICOgfAAAICOkfAAAICOofAAAICOsfAAAICOwfAAAICO0fAAAICO4fAAAICO8fAAAICPAfAAAICPEfAAAICPIfAAAICPMfAAAICPQfAAAICPUfAAAICPYfAAAICPcfAAAICPgfAAAICPkfAAAICPofAAAICPsfAAAICPwfAAAICP0fAAAICP4fAAAICP8fAAAICAAgAAAICAEgAAAICAIgAAAICAMgAAAICAQgAAAICAUgAAAICAYgAAAICAcgAAAICAggAAAICAkgAAAICAogAAAICAsgAAAICAwgAAAICA0gAAAICA4gAAAICA8gAAAICBAgAAAICBEgAAAICBIgAAAICBMgAAAICBQgAAAICBUgAAAICBYgAAAICBcgAAAICBggAAAICBkgAAAICBogAAAICBsgAAAICBwgAAAICB0gAAAICB4gAAAICB8gAAAICCAgAAAICCEgAAAICCIgAAAICCMgAAAICCQgAAAICCUgAAAICCYgAAAICCcgAAAICCggAAAICCkgAAAICCogAAAICCsgAAAICCwgAAAICC0gAAAICC4gAAAICC8gAAAICDAgAAAICDEgAAAICDIgAAAICDMgAAAICDQgAAAICDUgAAAICDYgAAAICDcgAAAICDggAAAICDkgAAAICDogAAAICDsgAAAICDwgAAAICD0gAAAICD4gAAAICD8gAAAICEAgAAAICEEgAAAICEIgAAAICEMgAAAICEQgAAAICEUgAAAICEYgAAAICEcgAAAICEggAAAICEkgAAAICEogAAAICEsgAAAICEwgAAAICE0gAAAICE4gAAAICE8gAAAICFAgAAAICFEgAAAICFIgAAAICFMgAAAICFQgAAAICFUgAAAICFYgAAAICFcgAAAICFggAAAICFkgAAAICFogAAAICFsgAAAICFwgAAAICF0gAAAICF4gAAAICF8gAAAICGAgAAAICGEgAAAICGIgAAAICGMgAAAICGQgAAAICGUgAAAICGYgAAAICGcgAAAICGggAAAICGkgAAAICGogAAAICGsgAAAICGwgAAAICG0gAAAICG4gAAAICG8gAAAICHAgAAAICHEgAAAICHIgAAAICHMgAAAICHQgAAAICHUgAAAICHYgAAAICHcgAAAICHggAAAICHkgAAAICHogAAAICHsgAAAICHwgAAAICH0gAAAICH4gAAAICH8gAAAICIAgAAAICIEgAAAICIIgAAAICIMgAAAICIQgAAAICIUgAAAICIYgAAAICIcgAAAICIggAAAICIkgAAAICIogAAAICIsgAAAICIwgAAAICI0gAAAICI4gAAAICI8gAAAICJAgAAAICJEgAAAICJIgAAAICJMgAAAICJQgAAAICJUgAAAICJYgAAAICJcgAAAICJggAAAICJkgAAAICJogAAAICJsgAAAICJwgAAAICJ0gAAAICJ4gAAAICJ8gAAAICKAgAAAICKEgAAAICKIgAAAICKMgAAAICKQgAAAICKUgAAAICKYgAAAICKcgAAAICKggAAAICKkgAAAICKogAAAICKsgAAAICKwgAAAICK0gAAAICK4gAAAICK8gAAAICLAgAAAICLEgAAAICLIgAAAICLMgAAAICLQgAAAICLUgAAAICLYgAAAICLcgAAAICLggAAAICLkgAAAICLogAAAICLsgAAAICLwgAAAICL0gAAAICL4gAAAICL8gAAAICMAgAAAICMEgAAAICMIgAAAICMMgAAAICMQgAAAICMUgAAAICMYgAAAICMcgAAAICMggAAAICMkgAAAICMogAAAICMsgAAAICMwgAAAICM0gAAAICM4gAAAICM8gAAAICNAgAAAICNEgAAAICNIgAAAICNMgAAAICNQgAAAICNUgAAAICNYgAAAICNcgAAAICNggAAAICNkgAAAICNogAAAICNsgAAAICNwgAAAICN0gAAAICN4gAAAICN8gAAAICOAgAAAICOEgAAAICOIgAAAICOMgAAAICOQgAAAICOUgAAAICOYgAAAICOcgAAAICOggAAAICOkgAAAICOogAAAICOsgAAAICOwgAAAICO0gAAAICO4gAAAICO8gAAAICPAgAAAICPEgAAAICPIgAAAICPMgAAAICPQgAAAICPUgAAAICPYgAAAICPcgAAAICPggAAAICPkgAAAICPogAAAICPsgAAAICPwgAAAICP0gAAAICP4gAAAICP8gAAAICAAhAAAICAEhAAAICAIhAAAICAMhAAAICAQhAAAICAUhAAAICAYhAAAICAchAAAICAghAAAICAkhAAAICAohAAAICAshAAAICAwhAAAICA0hAAAICA4hAAAICA8hAAAICBAhAAAICBEhAAAICBIhAAAICBMhAAAICBQhAAAICBUhAAAICBYhAAAICBchAAAICBghAAAICBkhAAAICBohAAAICBshAAAICBwhAAAICB0hAAAICB4hAAAICB8hAAAICCAhAAAICCEhAAAICCIhAAAICCMhAAAICCQhAAAICCUhAAAICCYhAAAICCchAAAICCghAAAICCkhAAAICCohAAAICCshAAAICCwhAAAICC0hAAAICC4hAAAICC8hAAAICDAhAAAICDEhAAAICDIhAAAICDMhAAAICDQhAAAICDUhAAAICDYhAAAICDchAAAICDghAAAICDkhAAAICDohAAAICDshAAAICDwhAAAICD0hAAAICD4hAAAICD8hAAAICEAhAAAICEEhAAAICEIhAAAICEMhAAAICEQhAAAICEUhAAAICEYhAAAICEchAAAICEghAAAICEkhAAAICEohAAAICEshAAAICEwhAAAICE0hAAAICE4hAAAICE8hAAAICFAhAAAICFEhAAAICFIhAAAICFMhAAAICFQhAAAICFUhAAAICFYhAAAICFchAAAICFghAAAICFkhAAAICFohAAAICFshAAAICFwhAAAICF0hAAAICF4hAAAICF8hAAAICGAhAAAICGEhAAAICGIhAAAICGMhAAAICGQhAAAICGUhAAAICGYhAAAICGchAAAICGghAAAICGkhAAAICGohAAAICGshAAAICGwhAAAICG0hAAAICG4hAAAICG8hAAAICHAhAAAICHEhAAAICHIhAAAICHMhAAAICHQhAAAICHUhAAAICHYhAAAICHchAAAICHghAAAICHkhAAAICHohAAAICHshAAAICHwhAAAICH0hAAAICH4hAAAICH8hAAAICIAhAAAICIEhAAAICIIhAAAICIMhAAAICIQhAAAICIUhAAAICIYhAAAICIchAAAICIghAAAICIkhAAAICIohAAAICIshAAAICIwhAAAICI0hAAAICI4hAAAICI8hAAAICJAhAAAICJEhAAAICJIhAAAICJMhAAAICJQhAAAICJUhAAAICJYhAAAICJchAAAICJghAAAICJkhAAAICJohAAAICJshAAAICJwhAAAICJ0hAAAICJ4hAAAICJ8hAAAICKAhAAAICKEhAAAICKIhAAAICKMhAAAICKQhAAAICKUhAAAICKYhAAAICKchAAAICKghAAAICKkhAAAICKohAAAICKshAAAICKwhAAAICK0hAAAICK4hAAAICK8hAAAICLAhAAAICLEhAAAICLIhAAAICLMhAAAICLQhAAAICLUhAAAICLYhAAAICLchAAAICLghAAAICLkhAAAICLohAAAICLshAAAICLwhAAAICL0hAAAICL4hAAAICL8hAAAICMAhAAAICMEhAAAICMIhAAAICMMhAAAICMQhAAAICMUhAAAICMYhAAAICMchAAAICMghAAAICMkhAAAICMohAAAICMshAAAICMwhAAAICM0hAAAICM4hAAAICM8hAAAICNAhAAAICNEhAAAICNIhAAAICNMhAAAICNQhAAAICNUhAAAICNYhAAAICNchAAAICNghAAAICNkhAAAICNohAAAICNshAAAICNwhAAAICN0hAAAICN4hAAAICN8hAAAICOAhAAAICOEhAAAICOIhAAAICOMhAAAICOQhAAAICOUhAAAICOYhAAAICOchAAAICOghAAAICOkhAAAICOohAAAICOshAAAICOwhAAAICO0hAAAICO4hAAAICO8hAAAICPAhAAAICPEhAAAICPIhAAAICPMhAAAICPQhAAAICPUhAAAICPYhAAAICPchAAAICPghAAAICPkhAAAICPohAAAICPshAAAICPwhAAAICP0hAAAICP4hAAAICP8hAAAICAAiAAAICAEiAAAICAIiAAAICAMiAAAICAQiAAAICAUiAAAICAYiAAAICAciAAAICAgiAAAICAkiAAAICAoiAAAICAsiAAAICAwiAAAICA0iAAAICA4iAAAICA8iAAAICBAiAAAICBEiAAAICBIiAAAICBMiAAAICBQiAAAICBUiAAAICBYiAAAICBciAAAICBgiAAAICBkiAAAICBoiAAAICBsiAAAICBwiAAAICB0iAAAICB4iAAAICB8iAAAICCAiAAAICCEiAAAICCIiAAAICCMiAAAICCQiAAAICCUiAAAICCYiAAAICCciAAAICCgiAAAICCkiAAAICCoiAAAICCsiAAAICCwiAAAICC0iAAAICC4iAAAICC8iAAAICDAiAAAICDEiAAAICDIiAAAICDMiAAAICDQiAAAICDUiAAAICDYiAAAICDciAAAICDgiAAAICDkiAAAICDoiAAAICDsiAAAICDwiAAAICD0iAAAICD4iAAAICD8iAAAICEAiAAAICEEiAAAICEIiAAAICEMiAAAICEQiAAAICEUiAAAICEYiAAAICEciAAAICEgiAAAICEkiAAAICEoiAAAICEsiAAAICEwiAAAICE0iAAAICE4iAAAICE8iAAAICFAiAAAICFEiAAAICFIiAAAICFMiAAAICFQiAAAICFUiAAAICFYiAAAICFciAAAICFgiAAAICFkiAAAICFoiAAAICFsiAAAICFwiAAAICF0iAAAICF4iAAAICF8iAAAICGAiAAAICGEiAAAICGIiAAAICGMiAAAICGQiAAAICGUiAAAICGYiAAAICGciAAAICGgiAAAICGkiAAAICGoiAAAICGsiAAAICGwiAAAICG0iAAAICG4iAAAICG8iAAAICHAiAAAICHEiAAAICHIiAAAICHMiAAAICHQiAAAICHUiAAAICHYiAAAICHciAAAICHgiAAAICHkiAAAICHoiAAAICHsiAAAICHwiAAAICH0iAAAICH4iAAAICH8iAAAICIAiAAAICIEiAAAICIIiAAAICIMiAAAICIQiAAAICIUiAAAICIYiAAAICIciAAAICIgiAAAICIkiAAAICIoiAAAICIsiAAAICIwiAAAICI0iAAAICI4iAAAICI8iAAAICJAiAAAICJEiAAAICJIiAAAICJMiAAAICJQiAAAICJUiAAAICJYiAAAICJciAAAICJgiAAAICJkiAAAICJoiAAAICJsiAAAICJwiAAAICJ0iAAAICJ4iAAAICJ8iAAAICKAiAAAICKEiAAAICKIiAAAICKMiAAAICKQiAAAICKUiAAAICKYiAAAICKciAAAICKgiAAAICKkiAAAICKoiAAAICKsiAAAICKwiAAAICK0iAAAICK4iAAAICK8iAAAICLAiAAAICLEiAAAICLIiAAAICLMiAAAICLQiAAAICLUiAAAICLYiAAAICLciAAAICLgiAAAICLkiAAAICLoiAAAICLsiAAAICLwiAAAICL0iAAAICL4iAAAICL8iAAAICMAiAAAICMEiAAAICMIiAAAICMMiAAAICMQiAAAICMUiAAAICMYiAAAICMciAAAICMgiAAAICMkiAAAICMoiAAAICMsiAAAICMwiAAAICM0iAAAICM4iAAAICM8iAAAICNAiAAAICNEiAAAICNIiAAAICNMiAAAICNQiAAAICNUiAAAICNYiAAAICNciAAAICNgiAAAICNkiAAAICNoiAAAICNsiAAAICNwiAAAICN0iAAAICN4iAAAICN8iAAAICOAiAAAICOEiAAAICOIiAAAICOMiAAAICOQiAAAICOUiAAAICOYiAAAICOciAAAICOgiAAAICOkiAAAICOoiAAAICOsiAAAICOwiAAAICO0iAAAICO4iAAAICO8iAAAICPAiAAAICPEiAAAICPIiAAAICPMiAAAICPQiAAAICPUiAAAICPYiAAAICPciAAAICPgiAAAICPkiAAAICPoiAAAICPsiAAAICPwiAAAICP0iAAAICP4iAAAICP8iAAAICAAjAAAICAEjAAAICAIjAAAICAMjAAAICAQjAAAICAUjAAAICAYjAAAICAcjAAAICAgjAAAICAkjAAAICAojAAAICAsjAAAICAwjAAAICA0jAAAICA4jAAAICA8jAAAICBAjAAAICBEjAAAICBIjAAAICBMjAAAICBQjAAAICBUjAAAICBYjAAAICBcjAAAICBgjAAAICBkjAAAICBojAAAICBsjAAAICBwjAAAICB0jAAAICB4jAAAICB8jAAAICCAjAAAICCEjAAAICCIjAAAICCMjAAAICCQjAAAICCUjAAAICCYjAAAICCcjAAAICCgjAAAICCkjAAAICCojAAAICCsjAAAICCwjAAAICC0jAAAICC4jAAAICC8jAAAICDAjAAAICDEjAAAICDIjAAAICDMjAAAICDQjAAAICDUjAAAICDYjAAAICDcjAAAICDgjAAAICDkjAAAICDojAAAICDsjAAAICDwjAAAICD0jAAAICD4jAAAICD8jAAAICEAjAAAICEEjAAAICEIjAAAICEMjAAAICEQjAAAICEUjAAAICEYjAAAICEcjAAAICEgjAAAICEkjAAAICEojAAAICEsjAAAICEwjAAAICE0jAAAICE4jAAAICE8jAAAICFAjAAAICFEjAAAICFIjAAAICFMjAAAICFQjAAAICFUjAAAICFYjAAAICFcjAAAICFgjAAAICFkjAAAICFojAAAICFsjAAAICFwjAAAICF0jAAAICF4jAAAICF8jAAAICGAjAAAICGEjAAAICGIjAAAICGMjAAAICGQjAAAICGUjAAAICGYjAAAICGcjAAAICGgjAAAICGkjAAAICGojAAAICGsjAAAICGwjAAAICG0jAAAICG4jAAAICG8jAAAICHAjAAAICHEjAAAICHIjAAAICHMjAAAICHQjAAAICHUjAAAICHYjAAAICHcjAAAICHgjAAAICHkjAAAICHojAAAICHsjAAAICHwjAAAICH0jAAAICH4jAAAICH8jAAAICIAjAAAICIEjAAAICIIjAAAICIMjAAAICIQjAAAICIUjAAAICIYjAAAICIcjAAAICIgjAAAICIkjAAAICIojAAAICIsjAAAICIwjAAAICI0jAAAICI4jAAAICI8jAAAICJAjAAAICJEjAAAICJIjAAAICJMjAAAICJQjAAAICJUjAAAICJYjAAAICJcjAAAICJgjAAAICJkjAAAICJojAAAICJsjAAAICJwjAAAICJ0jAAAICJ4jAAAICJ8jAAAICKAjAAAICKEjAAAICKIjAAAICKMjAAAICKQjAAAICKUjAAAICKYjAAAICKcjAAAICKgjAAAICKkjAAAICKojAAAICKsjAAAICKwjAAAICK0jAAAICK4jAAAICK8jAAAICLAjAAAICLEjAAAICLIjAAAICLMjAAAICLQjAAAICLUjAAAICLYjAAAICLcjAAAICLgjAAAICLkjAAAICLojAAAICLsjAAAICLwjAAAICL0jAAAICL4jAAAICL8jAAAICMAjAAAICMEjAAAICMIjAAAICMMjAAAICMQjAAAICMUjAAAICMYjAAAICMcjAAAICMgjAAAICMkjAAAICMojAAAICMsjAAAICMwjAAAICM0jAAAICM4jAAAICM8jAAAICNAjAAAICNEjAAAICNIjAAAICNMjAAAICNQjAAAICNUjAAAICNYjAAAICNcjAAAICNgjAAAICNkjAAAICNojAAAICNsjAAAICNwjAAAICN0jAAAICN4jAAAICN8jAAAICOAjAAAICOEjAAAICOIjAAAICOMjAAAICOQjAAAICOUjAAAICOYjAAAICOcjAAAICOgjAAAICOkjAAAICOojAAAICOsjAAAICOwjAAAICO0jAAAICO4jAAAICO8jAAAICPAjAAAICPEjAAAICPIjAAAICPMjAAAICPQjAAAICPUjAAAICPYjAAAICPcjAAAICPgjAAAICPkjAAAICPojAAAICPsjAAAICPwjAAAICP0jAAAICP4jAAAICP8jAAAICAAkAAAICAEkAAAICAIkAAAICAMkAAAICAQkAAAICAUkAAAICAYkAAAICAckAAAICAgkAAAICAkkAAAICAokAAAICAskAAAICAwkAAAICA0kAAAICA4kAAAICA8kAAAICBAkAAAICBEkAAAICBIkAAAICBMkAAAICBQkAAAICBUkAAAICBYkAAAICBckAAAICBgkAAAICBkkAAAICBokAAAICBskAAAICBwkAAAICB0kAAAICB4kAAAICB8kAAAICCAkAAAICCEkAAAICCIkAAAICCMkAAAICCQkAAAICCUkAAAICCYkAAAICCckAAAICCgkAAAICCkkAAAICCokAAAICCskAAAICCwkAAAICC0kAAAICC4kAAAICC8kAAAICDAkAAAICDEkAAAICDIkAAAICDMkAAAICDQkAAAICDUkAAAICDYkAAAICDckAAAICDgkAAAICDkkAAAICDokAAAICDskAAAICDwkAAAICD0kAAAICD4kAAAICD8kAAAICEAkAAAICEEkAAAICEIkAAAICEMkAAAICEQkAAAICEUkAAAICEYkAAAICEckAAAICEgkAAAICEkkAAAICEokAAAICEskAAAICEwkAAAICE0kAAAICE4kAAAICE8kAAAICFAkAAAICFEkAAAICFIkAAAICFMkAAAICFQkAAAICFUkAAAICFYkAAAICFckAAAICFgkAAAICFkkAAAICFokAAAICFskAAAICFwkAAAICF0kAAAICF4kAAAICF8kAAAICGAkAAAICGEkAAAICGIkAAAICGMkAAAICGQkAAAICGUkAAAICGYkAAAICGckAAAICGgkAAAICGkkAAAICGokAAAICGskAAAICGwkAAAICG0kAAAICG4kAAAICG8kAAAICHAkAAAICHEkAAAICHIkAAAICHMkAAAICHQkAAAICHUkAAAICHYkAAAICHckAAAICHgkAAAICHkkAAAICHokAAAICHskAAAICHwkAAAICH0kAAAICH4kAAAICH8kAAAICIAkAAAICIEkAAAICIIkAAAICIMkAAAICIQkAAAICIUkAAAICIYkAAAICIckAAAICIgkAAAICIkkAAAICIokAAAICIskAAAICIwkAAAICI0kAAAICI4kAAAICI8kAAAICJAkAAAICJEkAAAICJIkAAAICJMkAAAICJQkAAAICJUkAAAICJYkAAAICJckAAAICJgkAAAICJkkAAAICJokAAAICJskAAAICJwkAAAICJ0kAAAICJ4kAAAICJ8kAAAICKAkAAAICKEkAAAICKIkAAAICKMkAAAICKQkAAAICKUkAAAICKYkAAAICKckAAAICKgkAAAICKkkAAAICKokAAAICKskAAAICKwkAAAICK0kAAAICK4kAAAICK8kAAAICLAkAAAICLEkAAAICLIkAAAICLMkAAAICLQkAAAICLUkAAAICLYkAAAICLckAAAICLgkAAAICLkkAAAICLokAAAICLskAAAICLwkAAAICL0kAAAICL4kAAAICL8kAAAICMAkAAAICMEkAAAICMIkAAAICMMkAAAICMQkAAAICMUkAAAICMYkAAAICMckAAAICMgkAAAICMkkAAAICMokAAAICMskAAAICMwkAAAICM0kAAAICM4kAAAICM8kAAAICNAkAAAICNEkAAAICNIkAAAICNMkAAAICNQkAAAICNUkAAAICNYkAAAICNckAAAICNgkAAAICNkkAAAICNokAAAICNskAAAICNwkAAAICN0kAAAICN4kAAAICN8kAAAICOAkAAAICOEkAAAICOIkAAAICOMkAAAICOQkAAAICOUkAAAICOYkAAAICOckAAAICOgkAAAICOkkAAAICOokAAAICOskAAAICOwkAAAICO0kAAAICO4kAAAICO8kAAAICPAkAAAICPEkAAAICPIkAAAICPMkAAAICPQkAAAICPUkAAAICPYkAAAICPckAAAICPgkAAAICPkkAAAICPokAAAICPskAAAICPwkAAAICP0kAAAICP4kAAAICP8kAAAICAAlAAAICAElAAAICAIlAAAICAMlAAAICAQlAAAICAUlAAAICAYlAAAICAclAAAICAglAAAICAklAAAICAolAAAICAslAAAICAwlAAAICA0lAAAICA4lAAAICA8lAAAICBAlAAAICBElAAAICBIlAAAICBMlAAAICBQlAAAICBUlAAAICBYlAAAICBclAAAICBglAAAICBklAAAICBolAAAICBslAAAICBwlAAAICB0lAAAICB4lAAAICB8lAAAICCAlAAAICCElAAAICCIlAAAICCMlAAAICCQlAAAICCUlAAAICCYlAAAICCclAAAICCglAAAICCklAAAICColAAAICCslAAAICCwlAAAICC0lAAAICC4lAAAICC8lAAAICDAlAAAICDElAAAICDIlAAAICDMlAAAICDQlAAAICDUlAAAICDYlAAAICDclAAAICDglAAAICDklAAAICDolAAAICDslAAAICDwlAAAICD0lAAAICD4lAAAICD8lAAAICEAlAAAICEElAAAICEIlAAAICEMlAAAICEQlAAAICEUlAAAICEYlAAAICEclAAAICEglAAAICEklAAAICEolAAAICEslAAAICEwlAAAICE0lAAAICE4lAAAICE8lAAAICFAlAAAICFElAAAICFIlAAAICFMlAAAICFQlAAAICFUlAAAICFYlAAAICFclAAAICFglAAAICFklAAAICFolAAAICFslAAAICFwlAAAICF0lAAAICF4lAAAICF8lAAAICGAlAAAICGElAAAICGIlAAAICGMlAAAICGQlAAAICGUlAAAICGYlAAAICGclAAAICGglAAAICGklAAAICGolAAAICGslAAAICGwlAAAICG0lAAAICG4lAAAICG8lAAAICHAlAAAICHElAAAICHIlAAAICHMlAAAICHQlAAAICHUlAAAICHYlAAAICHclAAAICHglAAAICHklAAAICHolAAAICHslAAAICHwlAAAICH0lAAAICH4lAAAICH8lAAAICIAlAAAICIElAAAICIIlAAAICIMlAAAICIQlAAAICIUlAAAICIYlAAAICIclAAAICIglAAAICIklAAAICIolAAAICIslAAAICIwlAAAICI0lAAAICI4lAAAICI8lAAAICJAlAAAICJElAAAICJIlAAAICJMlAAAICJQlAAAICJUlAAAICJYlAAAICJclAAAICJglAAAICJklAAAICJolAAAICJslAAAICJwlAAAICJ0lAAAICJ4lAAAICJ8lAAAICKAlAAAICKElAAAICKIlAAAICKMlAAAICKQlAAAICKUlAAAICKYlAAAICKclAAAICKglAAAICKklAAAICKolAAAICKslAAAICKwlAAAICK0lAAAICK4lAAAICK8lAAAICLAlAAAICLElAAAICLIlAAAICLMlAAAICLQlAAAICLUlAAAICLYlAAAICLclAAAICLglAAAICLklAAAICLolAAAICLslAAAICLwlAAAICL0lAAAICL4lAAAICL8lAAAICMAlAAAICMElAAAICMIlAAAICMMlAAAICMQlAAAICMUlAAAICMYlAAAICMclAAAICMglAAAICMklAAAICMolAAAICMslAAAICMwlAAAICM0lAAAICM4lAAAICM8lAAAICNAlAAAICNElAAAICNIlAAAICNMlAAAICNQlAAAICNUlAAAICNYlAAAICNclAAAICNglAAAICNklAAAICNolAAAICNslAAAICNwlAAAICN0lAAAICN4lAAAICN8lAAAICOAlAAAICOElAAAICOIlAAAICOMlAAAICOQlAAAICOUlAAAICOYlAAAICOclAAAICOglAAAICOklAAAICOolAAAICOslAAAICOwlAAAICO0lAAAICO4lAAAICO8lAAAICPAlAAAICPElAAAICPIlAAAICPMlAAAICPQlAAAICPUlAAAICPYlAAAICPclAAAICPglAAAICPklAAAICPolAAAICPslAAAICPwlAAAICP0lAAAICP4lAAAICP8lAAAICAAmAAAICAEmAAAICAImAAAICAMmAAAICAQmAAAICAUmAAAICAYmAAAICAcmAAAICAgmAAAICAkmAAAICAomAAAICAsmAAAICAwmAAAICA0mAAAICA4mAAAICA8mAAAICBAmAAAICBEmAAAICBImAAAICBMmAAAICBQmAAAICBUmAAAICBYmAAAICBcmAAAICBgmAAAICBkmAAAICBomAAAICBsmAAAICBwmAAAICB0mAAAICB4mAAAICB8mAAAICCAmAAAICCEmAAAICCImAAAICCMmAAAICCQmAAAICCUmAAAICCYmAAAICCcmAAAICCgmAAAICCkmAAAICComAAAICCsmAAAICCwmAAAICC0mAAAICC4mAAAICC8mAAAICDAmAAAICDEmAAAICDImAAAICDMmAAAICDQmAAAICDUmAAAICDYmAAAICDcmAAAICDgmAAAICDkmAAAICDomAAAICDsmAAAICDwmAAAICD0mAAAICD4mAAAICD8mAAAICEAmAAAICEEmAAAICEImAAAICEMmAAAICEQmAAAICEUmAAAICEYmAAAICEcmAAAICEgmAAAICEkmAAAICEomAAAICEsmAAAICEwmAAAICE0mAAAICE4mAAAICE8mAAAICFAmAAAICFEmAAAICFImAAAICFMmAAAICFQmAAAICFUmAAAICFYmAAAICFcmAAAICFgmAAAICFkmAAAICFomAAAICFsmAAAICFwmAAAICF0mAAAICF4mAAAICF8mAAAICGAmAAAICGEmAAAICGImAAAICGMmAAAICGQmAAAICGUmAAAICGYmAAAICGcmAAAICGgmAAAICGkmAAAICGomAAAICGsmAAAICGwmAAAICG0mAAAICG4mAAAICG8mAAAICHAmAAAICHEmAAAICHImAAAICHMmAAAICHQmAAAICHUmAAAICHYmAAAICHcmAAAICHgmAAAICHkmAAAICHomAAAICHsmAAAICHwmAAAICH0mAAAICH4mAAAICH8mAAAICIAmAAAICIEmAAAICIImAAAICIMmAAAICIQmAAAICIUmAAAICIYmAAAICIcmAAAICIgmAAAICIkmAAAICIomAAAICIsmAAAICIwmAAAICI0mAAAICI4mAAAICI8mAAAICJAmAAAICJEmAAAICJImAAAICJMmAAAICJQmAAAICJUmAAAICJYmAAAICJcmAAAICJgmAAAICJkmAAAICJomAAAICJsmAAAICJwmAAAICJ0mAAAICJ4mAAAICJ8mAAAICKAmAAAICKEmAAAICKImAAAICKMmAAAICKQmAAAICKUmAAAICKYmAAAICKcmAAAICKgmAAAICKkmAAAICKomAAAICKsmAAAICKwmAAAICK0mAAAICK4mAAAICK8mAAAICLAmAAAICLEmAAAICLImAAAICLMmAAAICLQmAAAICLUmAAAICLYmAAAICLcmAAAICLgmAAAICLkmAAAICLomAAAICLsmAAAICLwmAAAICL0mAAAICL4mAAAICL8mAAAICMAmAAAICMEmAAAICMImAAAICMMmAAAICMQmAAAICMUmAAAICMYmAAAICMcmAAAICMgmAAAICMkmAAAICMomAAAICMsmAAAICMwmAAAICM0mAAAICM4mAAAICM8mAAAICNAmAAAICNEmAAAICNImAAAICNMmAAAICNQmAAAICNUmAAAICNYmAAAICNcmAAAICNgmAAAICNkmAAAICNomAAAICNsmAAAICNwmAAAICN0mAAAICN4mAAAICN8mAAAICOAmAAAICOEmAAAICOImAAAICOMmAAAICOQmAAAICOUmAAAICOYmAAAICOcmAAAICOgmAAAICOkmAAAICOomAAAICOsmAAAICOwmAAAICO0mAAAICO4mAAAICO8mAAAICPAmAAAICPEmAAAICPImAAAICPMmAAAICPQmAAAICPUmAAAICPYmAAAICPcmAAAICPgmAAAICPkmAAAICPomAAAICPsmAAAICPwmAAAICP0mAAAICP4mAAAICP8mAAAICAAnAAAICAEnAAAICAInAAAICAMnAAAICAQnAAAICAUnAAAICAYnAAAICAcnAAAICAgnAAAICAknAAAICAonAAAICAsnAAAICAwnAAAICA0nAAAICA4nAAAICA8nAAAL" } };
            // fewer than 256 nulls
            yield return new object[] { new object[200], new string[] { "AAEAAAD/////AQAAAAAAAAAQAQAAAMgAAAANyAs=", "AAEAAAD/////AQAAAAAAAAAQAQAAAMgAAAANyAs=" } };
            // more than 256 nulls
            yield return new object[] { new object[300], new string[] { "AAEAAAD/////AQAAAAAAAAAQAQAAACwBAAAOLAEAAAs=", "AAEAAAD/////AQAAAAAAAAAQAQAAACwBAAAOLAEAAAs=" } };

            // Non-vector arrays
            yield return new object[] { Array.CreateInstance(typeof(uint), new[] { 5 }, new[] { 1 }), new string[] { "AAEAAAD/////AQAAAAAAAAAHAQAAAAMBAAAABQAAAAEAAAAADwAAAAAAAAAAAAAAAAAAAAAAAAAACw==", "AAEAAAD/////AQAAAAAAAAAHAQAAAAMBAAAABQAAAAEAAAAADwAAAAAAAAAAAAAAAAAAAAAAAAAACw==" } };
            yield return new object[] { Array.CreateInstance(typeof(int), new[] { 0, 0, 0 }, new[] { 0, 0, 0 }), new string[] { "AAEAAAD/////AQAAAAAAAAAHAQAAAAIDAAAAAAAAAAAAAAAAAAAAAAgL", "AAEAAAD/////AQAAAAAAAAAHAQAAAAIDAAAAAAAAAAAAAAAAAAAAAAgL" } };
            var arr = Array.CreateInstance(typeof(string), new[] { 1, 2 }, new[] { 3, 4 });
            arr.SetValue("hello", new[] { 3, 5 });
            yield return new object[] { arr, new string[] { "AAEAAAD/////AQAAAAAAAAAHAQAAAAUCAAAAAQAAAAIAAAADAAAABAAAAAEKBgIAAAAFaGVsbG8L", "AAEAAAD/////AQAAAAAAAAAHAQAAAAUCAAAAAQAAAAIAAAADAAAABAAAAAEKBgIAAAAFaGVsbG8L" } };

            // Globalization types
            yield return new object[] { CultureInfo.InvariantCulture.CompareInfo, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAACBTeXN0ZW0uR2xvYmFsaXphdGlvbi5Db21wYXJlSW5mbwIAAAAGbV9uYW1lDW1fc29ydFZlcnNpb24BAyBTeXN0ZW0uR2xvYmFsaXphdGlvbi5Tb3J0VmVyc2lvbgYCAAAAAAoL", "AAEAAAD/////AQAAAAAAAAAEAQAAACBTeXN0ZW0uR2xvYmFsaXphdGlvbi5Db21wYXJlSW5mbwQAAAAGbV9uYW1lCXdpbjMyTENJRAdjdWx0dXJlDW1fU29ydFZlcnNpb24BAAADCAggU3lzdGVtLkdsb2JhbGl6YXRpb24uU29ydFZlcnNpb24GAgAAAAVlbi1VUwAAAAAJBAAACgs=" } };
            yield return new object[] { new SortVersion(12345, Guid.Parse("9fac6fbb-f683-42f5-a593-0d4a5e34b257")), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAACBTeXN0ZW0uR2xvYmFsaXphdGlvbi5Tb3J0VmVyc2lvbgIAAAAMbV9ObHNWZXJzaW9uCG1fU29ydElkAAMIC1N5c3RlbS5HdWlkOTAAAAT+////C1N5c3RlbS5HdWlkCwAAAAJfYQJfYgJfYwJfZAJfZQJfZgJfZwJfaAJfaQJfagJfawAAAAAAAAAAAAAACAcHAgICAgICAgK7b6yfg/b1QqWTDUpeNLJXCw==", "AAEAAAD/////AQAAAAAAAAAEAQAAACBTeXN0ZW0uR2xvYmFsaXphdGlvbi5Tb3J0VmVyc2lvbgIAAAAMbV9ObHNWZXJzaW9uCG1fU29ydElkAAMIC1N5c3RlbS5HdWlkOTAAAAT+////C1N5c3RlbS5HdWlkCwAAAAJfYQJfYgJfYwJfZAJfZQJfZgJfZwJfaAJfaQJfagJfawAAAAAAAAAAAAAACAcHAgICAgICAgK7b6yfg/b1QqWTDUpeNLJXCw==" } };

            // Drawing types
            yield return new object[] { new System.Drawing.Point(10, 10), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFxTeXN0ZW0uRHJhd2luZy5QcmltaXRpdmVzLCBWZXJzaW9uPTQuMS4xLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49YjAzZjVmN2YxMWQ1MGEzYQUBAAAAFFN5c3RlbS5EcmF3aW5nLlBvaW50AgAAAAF4AXkAAAgIAgAAAAoAAAAKAAAACw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAFFTeXN0ZW0uRHJhd2luZywgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2EFAQAAABRTeXN0ZW0uRHJhd2luZy5Qb2ludAIAAAABeAF5AAAICAIAAAAKAAAACgAAAAs=" } };
            yield return new object[] { System.Drawing.Color.FromArgb(255, 100, 55, 255), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFxTeXN0ZW0uRHJhd2luZy5QcmltaXRpdmVzLCBWZXJzaW9uPTQuMS4xLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49YjAzZjVmN2YxMWQ1MGEzYQUBAAAAFFN5c3RlbS5EcmF3aW5nLkNvbG9yBAAAAARuYW1lBXZhbHVlCmtub3duQ29sb3IFc3RhdGUBAAAACQcHAgAAAAr/N2T/AAAAAAAAAgAL", "AAEAAAD/////AQAAAAAAAAAMAgAAAFFTeXN0ZW0uRHJhd2luZywgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2EFAQAAABRTeXN0ZW0uRHJhd2luZy5Db2xvcgQAAAAEbmFtZQV2YWx1ZQprbm93bkNvbG9yBXN0YXRlAQAAAAkHBwIAAAAK/zdk/wAAAAAAAAIACw==" } };
            yield return new object[] { new System.Drawing.PointF(10.5f, 10.25f), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFxTeXN0ZW0uRHJhd2luZy5QcmltaXRpdmVzLCBWZXJzaW9uPTQuMS4xLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49YjAzZjVmN2YxMWQ1MGEzYQUBAAAAFVN5c3RlbS5EcmF3aW5nLlBvaW50RgIAAAABeAF5AAALCwIAAAAAAChBAAAkQQs=", "AAEAAAD/////AQAAAAAAAAAMAgAAAFFTeXN0ZW0uRHJhd2luZywgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2EFAQAAABVTeXN0ZW0uRHJhd2luZy5Qb2ludEYCAAAAAXgBeQAACwsCAAAAAAAoQQAAJEEL" } };
            yield return new object[] { new System.Drawing.Rectangle(10, 10, 100, 50), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFxTeXN0ZW0uRHJhd2luZy5QcmltaXRpdmVzLCBWZXJzaW9uPTQuMS4xLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49YjAzZjVmN2YxMWQ1MGEzYQUBAAAAGFN5c3RlbS5EcmF3aW5nLlJlY3RhbmdsZQQAAAABeAF5BXdpZHRoBmhlaWdodAAAAAAICAgIAgAAAAoAAAAKAAAAZAAAADIAAAAL", "AAEAAAD/////AQAAAAAAAAAMAgAAAFFTeXN0ZW0uRHJhd2luZywgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2EFAQAAABhTeXN0ZW0uRHJhd2luZy5SZWN0YW5nbGUEAAAAAXgBeQV3aWR0aAZoZWlnaHQAAAAACAgICAIAAAAKAAAACgAAAGQAAAAyAAAACw==" } };
            yield return new object[] { new System.Drawing.RectangleF(10.5f, 10.5f, 52.3f, 69.4f), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFxTeXN0ZW0uRHJhd2luZy5QcmltaXRpdmVzLCBWZXJzaW9uPTQuMS4xLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49YjAzZjVmN2YxMWQ1MGEzYQUBAAAAGVN5c3RlbS5EcmF3aW5nLlJlY3RhbmdsZUYEAAAAAXgBeQV3aWR0aAZoZWlnaHQAAAAACwsLCwIAAAAAAChBAAAoQTMzUULNzIpCCw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAFFTeXN0ZW0uRHJhd2luZywgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2EFAQAAABlTeXN0ZW0uRHJhd2luZy5SZWN0YW5nbGVGBAAAAAF4AXkFd2lkdGgGaGVpZ2h0AAAAAAsLCwsCAAAAAAAoQQAAKEEzM1FCzcyKQgs=" } };
            yield return new object[] { new System.Drawing.Size(10, 45), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFxTeXN0ZW0uRHJhd2luZy5QcmltaXRpdmVzLCBWZXJzaW9uPTQuMS4xLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49YjAzZjVmN2YxMWQ1MGEzYQUBAAAAE1N5c3RlbS5EcmF3aW5nLlNpemUCAAAABXdpZHRoBmhlaWdodAAACAgCAAAACgAAAC0AAAAL", "AAEAAAD/////AQAAAAAAAAAMAgAAAFFTeXN0ZW0uRHJhd2luZywgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2EFAQAAABNTeXN0ZW0uRHJhd2luZy5TaXplAgAAAAV3aWR0aAZoZWlnaHQAAAgIAgAAAAoAAAAtAAAACw==" } };
            yield return new object[] { new System.Drawing.SizeF(10.2f, 45.8f), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFxTeXN0ZW0uRHJhd2luZy5QcmltaXRpdmVzLCBWZXJzaW9uPTQuMS4xLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49YjAzZjVmN2YxMWQ1MGEzYQUBAAAAFFN5c3RlbS5EcmF3aW5nLlNpemVGAgAAAAV3aWR0aAZoZWlnaHQAAAsLAgAAADMzI0EzMzdCCw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAFFTeXN0ZW0uRHJhd2luZywgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2EFAQAAABRTeXN0ZW0uRHJhd2luZy5TaXplRgIAAAAFd2lkdGgGaGVpZ2h0AAALCwIAAAAzMyNBMzM3Qgs=" } };

            // Custom object
            var sealedObjectWithIntStringFields = new SealedObjectWithIntStringFields();
            yield return new object[] { sealedObjectWithIntStringFields, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABNU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlNlYWxlZE9iamVjdFdpdGhJbnRTdHJpbmdGaWVsZHMDAAAAB01lbWJlcjEHTWVtYmVyMgdNZW1iZXIzAAEBCAIAAAAAAAAACgoL", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABNU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlNlYWxlZE9iamVjdFdpdGhJbnRTdHJpbmdGaWVsZHMDAAAAB01lbWJlcjEHTWVtYmVyMgdNZW1iZXIzAAEBCAIAAAAAAAAACgoL" } };
            yield return new object[] { new SealedObjectWithIntStringFields() { Member1 = 42, Member2 = null, Member3 = "84" }, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABNU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlNlYWxlZE9iamVjdFdpdGhJbnRTdHJpbmdGaWVsZHMDAAAAB01lbWJlcjEHTWVtYmVyMgdNZW1iZXIzAAEBCAIAAAAqAAAACgYDAAAAAjg0Cw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABNU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlNlYWxlZE9iamVjdFdpdGhJbnRTdHJpbmdGaWVsZHMDAAAAB01lbWJlcjEHTWVtYmVyMgdNZW1iZXIzAAEBCAIAAAAqAAAACgYDAAAAAjg0Cw==" } };

            // Custom object with fields pointing to the same object
            yield return new object[] { new ObjectWithIntStringUShortUIntULongAndCustomObjectFields
            {
                Member1 = 10,
                Member2 = "hello",
                _member3 = "hello",
                Member4 = sealedObjectWithIntStringFields,
                Member4shared = sealedObjectWithIntStringFields,
                Member5 = new SealedObjectWithIntStringFields(),
                Member6 = "Hello World",
                str1 = "hello < world",
                str2 = "<",
                str3 = "< world",
                str4 = "hello < world",
                u16 = ushort.MaxValue,
                u32 = uint.MaxValue,
                u64 = ulong.MaxValue,
            }, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjIuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABlU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLk9iamVjdFdpdGhJbnRTdHJpbmdVU2hvcnRVSW50VUxvbmdBbmRDdXN0b21PYmplY3RGaWVsZHMOAAAAB01lbWJlcjEHTWVtYmVyMghfbWVtYmVyMwdNZW1iZXI0DU1lbWJlcjRzaGFyZWQHTWVtYmVyNQdNZW1iZXI2BHN0cjEEc3RyMgRzdHIzBHN0cjQDdTE2A3UzMgN1NjQAAQEEBAQBAQEBAQAAAAhNU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlNlYWxlZE9iamVjdFdpdGhJbnRTdHJpbmdGaWVsZHMCAAAATVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5TZWFsZWRPYmplY3RXaXRoSW50U3RyaW5nRmllbGRzAgAAAE1TeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU2VhbGVkT2JqZWN0V2l0aEludFN0cmluZ0ZpZWxkcwIAAAAODxACAAAACgAAAAYDAAAABWhlbGxvCQMAAAAJBAAAAAkEAAAACQUAAAAGBgAAAAtIZWxsbyBXb3JsZAYHAAAADWhlbGxvIDwgd29ybGQGCAAAAAE8BgkAAAAHPCB3b3JsZAkHAAAA//////////////////8FBAAAAE1TeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU2VhbGVkT2JqZWN0V2l0aEludFN0cmluZ0ZpZWxkcwMAAAAHTWVtYmVyMQdNZW1iZXIyB01lbWJlcjMAAQEIAgAAAAAAAAAKCgEFAAAABAAAAAAAAAAKCgs=", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjIuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABlU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLk9iamVjdFdpdGhJbnRTdHJpbmdVU2hvcnRVSW50VUxvbmdBbmRDdXN0b21PYmplY3RGaWVsZHMOAAAAB01lbWJlcjEHTWVtYmVyMghfbWVtYmVyMwdNZW1iZXI0DU1lbWJlcjRzaGFyZWQHTWVtYmVyNQdNZW1iZXI2BHN0cjEEc3RyMgRzdHIzBHN0cjQDdTE2A3UzMgN1NjQAAQEEBAQBAQEBAQAAAAhNU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlNlYWxlZE9iamVjdFdpdGhJbnRTdHJpbmdGaWVsZHMCAAAATVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5TZWFsZWRPYmplY3RXaXRoSW50U3RyaW5nRmllbGRzAgAAAE1TeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU2VhbGVkT2JqZWN0V2l0aEludFN0cmluZ0ZpZWxkcwIAAAAODxACAAAACgAAAAYDAAAABWhlbGxvCQMAAAAJBAAAAAkEAAAACQUAAAAGBgAAAAtIZWxsbyBXb3JsZAYHAAAADWhlbGxvIDwgd29ybGQGCAAAAAE8BgkAAAAHPCB3b3JsZAkHAAAA//////////////////8FBAAAAE1TeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU2VhbGVkT2JqZWN0V2l0aEludFN0cmluZ0ZpZWxkcwMAAAAHTWVtYmVyMQdNZW1iZXIyB01lbWJlcjMAAQEIAgAAAAAAAAAKCgEFAAAABAAAAAAAAAAKCgs=" } };

            // Simple type without a default ctor
            var point = new Point(1, 2);
            yield return new object[] { point, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAAAzU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50AgAAAAFYAVkAAAgIAgAAAAEAAAACAAAACw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAAAzU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50AgAAAAFYAVkAAAgIAgAAAAEAAAACAAAACw==" } };

            // Collections
            yield return new object[] { new System.Collections.BitArray(5, true), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uQ29sbGVjdGlvbnMsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAAbU3lzdGVtLkNvbGxlY3Rpb25zLkJpdEFycmF5AwAAAAdtX2FycmF5CG1fbGVuZ3RoCF92ZXJzaW9uBwAACAgIAgAAAAkDAAAABQAAAAAAAAAPAwAAAAEAAAAI/////ws=", "AAEAAAD/////AQAAAAAAAAAEAQAAABtTeXN0ZW0uQ29sbGVjdGlvbnMuQml0QXJyYXkDAAAAB21fYXJyYXkIbV9sZW5ndGgIX3ZlcnNpb24HAAAICAgJAgAAAAUAAAAAAAAADwIAAAABAAAACP////8L" } };
            yield return new object[] { new System.Collections.ArrayList(Enumerable.Range(1, 40).ToList()), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFxTeXN0ZW0uUnVudGltZS5FeHRlbnNpb25zLCBWZXJzaW9uPTQuMi4xLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49YjAzZjVmN2YxMWQ1MGEzYQUBAAAAHFN5c3RlbS5Db2xsZWN0aW9ucy5BcnJheUxpc3QDAAAABl9pdGVtcwVfc2l6ZQhfdmVyc2lvbgUAAAgIAgAAAAkDAAAAKAAAAAEAAAAQAwAAACgAAAAICAEAAAAICAIAAAAICAMAAAAICAQAAAAICAUAAAAICAYAAAAICAcAAAAICAgAAAAICAkAAAAICAoAAAAICAsAAAAICAwAAAAICA0AAAAICA4AAAAICA8AAAAICBAAAAAICBEAAAAICBIAAAAICBMAAAAICBQAAAAICBUAAAAICBYAAAAICBcAAAAICBgAAAAICBkAAAAICBoAAAAICBsAAAAICBwAAAAICB0AAAAICB4AAAAICB8AAAAICCAAAAAICCEAAAAICCIAAAAICCMAAAAICCQAAAAICCUAAAAICCYAAAAICCcAAAAICCgAAAAL", "AAEAAAD/////AQAAAAAAAAAEAQAAABxTeXN0ZW0uQ29sbGVjdGlvbnMuQXJyYXlMaXN0AwAAAAZfaXRlbXMFX3NpemUIX3ZlcnNpb24FAAAICAkCAAAAKAAAAAEAAAAQAgAAACgAAAAICAEAAAAICAIAAAAICAMAAAAICAQAAAAICAUAAAAICAYAAAAICAcAAAAICAgAAAAICAkAAAAICAoAAAAICAsAAAAICAwAAAAICA0AAAAICA4AAAAICA8AAAAICBAAAAAICBEAAAAICBIAAAAICBMAAAAICBQAAAAICBUAAAAICBYAAAAICBcAAAAICBgAAAAICBkAAAAICBoAAAAICBsAAAAICBwAAAAICB0AAAAICB4AAAAICB8AAAAICCAAAAAICCEAAAAICCIAAAAICCMAAAAICCQAAAAICCUAAAAICCYAAAAICCcAAAAICCgAAAAL" } };
            yield return new object[] { new System.Collections.ArrayList(10), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFxTeXN0ZW0uUnVudGltZS5FeHRlbnNpb25zLCBWZXJzaW9uPTQuMi4xLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49YjAzZjVmN2YxMWQ1MGEzYQUBAAAAHFN5c3RlbS5Db2xsZWN0aW9ucy5BcnJheUxpc3QDAAAABl9pdGVtcwVfc2l6ZQhfdmVyc2lvbgUAAAgIAgAAAAkDAAAAAAAAAAAAAAAQAwAAAAoAAAANCgs=", "AAEAAAD/////AQAAAAAAAAAEAQAAABxTeXN0ZW0uQ29sbGVjdGlvbnMuQXJyYXlMaXN0AwAAAAZfaXRlbXMFX3NpemUIX3ZlcnNpb24FAAAICAkCAAAAAAAAAAAAAAAQAgAAAAoAAAANCgs=" } };
            yield return new object[] { new System.Collections.Comparer(CultureInfo.InvariantCulture), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFxTeXN0ZW0uUnVudGltZS5FeHRlbnNpb25zLCBWZXJzaW9uPTQuMi4xLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49YjAzZjVmN2YxMWQ1MGEzYQUBAAAAG1N5c3RlbS5Db2xsZWN0aW9ucy5Db21wYXJlcgEAAAALQ29tcGFyZUluZm8DIFN5c3RlbS5HbG9iYWxpemF0aW9uLkNvbXBhcmVJbmZvAgAAAAkDAAAABAMAAAAgU3lzdGVtLkdsb2JhbGl6YXRpb24uQ29tcGFyZUluZm8CAAAABm1fbmFtZQ1tX3NvcnRWZXJzaW9uAQMgU3lzdGVtLkdsb2JhbGl6YXRpb24uU29ydFZlcnNpb24GBAAAAAAKCw==", "AAEAAAD/////AQAAAAAAAAAEAQAAABtTeXN0ZW0uQ29sbGVjdGlvbnMuQ29tcGFyZXIBAAAAC0NvbXBhcmVJbmZvAyBTeXN0ZW0uR2xvYmFsaXphdGlvbi5Db21wYXJlSW5mbwkCAAAABAIAAAAgU3lzdGVtLkdsb2JhbGl6YXRpb24uQ29tcGFyZUluZm8EAAAABm1fbmFtZQl3aW4zMkxDSUQHY3VsdHVyZQ1tX1NvcnRWZXJzaW9uAQAAAwgIIFN5c3RlbS5HbG9iYWxpemF0aW9uLlNvcnRWZXJzaW9uBgMAAAAFZW4tVVMAAAAACQQAAAoL" } };
            yield return new object[] { new System.Collections.DictionaryEntry("key", 5), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAACJTeXN0ZW0uQ29sbGVjdGlvbnMuRGljdGlvbmFyeUVudHJ5AgAAAARfa2V5Bl92YWx1ZQICBgIAAAADa2V5CAgFAAAACw==", "AAEAAAD/////AQAAAAAAAAAEAQAAACJTeXN0ZW0uQ29sbGVjdGlvbnMuRGljdGlvbmFyeUVudHJ5AgAAAARfa2V5Bl92YWx1ZQICBgIAAAADa2V5CAgFAAAACw==" } };
            yield return new object[] { Comparer<int>.Default, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAJcBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuR2VuZXJpY0NvbXBhcmVyYDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQAAAAAL", "AAEAAAD/////AQAAAAAAAAAEAQAAAIkBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuR2VuZXJpY0NvbXBhcmVyYDFbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0AAAAACw==" } };
            yield return new object[] { new HashSet<Point>(new[] { point }, new PointEqualityComparer()), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uQ29sbGVjdGlvbnMsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhDAMAAABwU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYgUBAAAAzQFTeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5IYXNoU2V0YDFbW1N5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5Qb2ludCwgU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYl1dBAAAAAdWZXJzaW9uCENvbXBhcmVyCENhcGFjaXR5CEVsZW1lbnRzAAQABAhDU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50RXF1YWxpdHlDb21wYXJlcgMAAAAINVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5Qb2ludFtdAwAAAAIAAAABAAAACQQAAAADAAAACQUAAAAFBAAAAENTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnRFcXVhbGl0eUNvbXBhcmVyAAAAAAMAAAAHBQAAAAABAAAAAQAAAAQzU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50AwAAAAkGAAAABQYAAAAzU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50AgAAAAFYAVkAAAgIAwAAAAEAAAACAAAACw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAE5TeXN0ZW0uQ29yZSwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODkMAwAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAADNAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLkhhc2hTZXRgMVtbU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50LCBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViXV0EAAAAB1ZlcnNpb24IQ29tcGFyZXIIQ2FwYWNpdHkIRWxlbWVudHMABAAECENTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnRFcXVhbGl0eUNvbXBhcmVyAwAAAAg1U3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50W10DAAAAAgAAAAEAAAAJBAAAAAMAAAAJBQAAAAUEAAAAQ1N5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5Qb2ludEVxdWFsaXR5Q29tcGFyZXIAAAAAAwAAAAcFAAAAAAEAAAABAAAABDNTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnQDAAAACQYAAAAFBgAAADNTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnQCAAAAAVgBWQAACAgDAAAAAQAAAAIAAAAL" } };
            yield return new object[] { new KeyValuePair<int, string>(5, "five"), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAP8BU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuS2V5VmFsdWVQYWlyYDJbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdLFtTeXN0ZW0uU3RyaW5nLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dAgAAAANrZXkFdmFsdWUAAQgFAAAABgIAAAAEZml2ZQs=", "AAEAAAD/////AQAAAAAAAAAEAQAAAOMBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuS2V5VmFsdWVQYWlyYDJbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XSxbU3lzdGVtLlN0cmluZywgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0CAAAAA2tleQV2YWx1ZQABCAUAAAAGAgAAAARmaXZlCw==" } };
            yield return new object[] { new LinkedList<Point>(new[] { point }), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uQ29sbGVjdGlvbnMsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhDAMAAABwU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYgUBAAAA0AFTeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5MaW5rZWRMaXN0YDFbW1N5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5Qb2ludCwgU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYl1dAwAAAAdWZXJzaW9uBUNvdW50BERhdGEAAAQICDVTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnRbXQMAAAACAAAAAQAAAAEAAAAJBAAAAAcEAAAAAAEAAAABAAAABDNTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnQDAAAACQUAAAAFBQAAADNTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnQCAAAAAVgBWQAACAgDAAAAAQAAAAIAAAAL", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5DAMAAABwU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYgUBAAAA0AFTeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5MaW5rZWRMaXN0YDFbW1N5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5Qb2ludCwgU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYl1dAwAAAAdWZXJzaW9uBUNvdW50BERhdGEAAAQICDVTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnRbXQMAAAACAAAAAQAAAAEAAAAJBAAAAAcEAAAAAAEAAAABAAAABDNTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnQDAAAACQUAAAAFBQAAADNTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnQCAAAAAVgBWQAACAgDAAAAAQAAAAIAAAAL" } };
            yield return new object[] { new Queue<int>(Enumerable.Range(1, 25)), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uQ29sbGVjdGlvbnMsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAACNAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLlF1ZXVlYDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQUAAAAGX2FycmF5BV9oZWFkBV90YWlsBV9zaXplCF92ZXJzaW9uBwAAAAAICAgICAIAAAAJAwAAAAAAAAAZAAAAGQAAAAAAAAAPAwAAACAAAAAIAQAAAAIAAAADAAAABAAAAAUAAAAGAAAABwAAAAgAAAAJAAAACgAAAAsAAAAMAAAADQAAAA4AAAAPAAAAEAAAABEAAAASAAAAEwAAABQAAAAVAAAAFgAAABcAAAAYAAAAGQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAL", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAAB/U3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuUXVldWVgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQUAAAAGX2FycmF5BV9oZWFkBV90YWlsBV9zaXplCF92ZXJzaW9uBwAAAAAICAgICAIAAAAJAwAAAAAAAAAZAAAAGQAAABwAAAAPAwAAACAAAAAIAQAAAAIAAAADAAAABAAAAAUAAAAGAAAABwAAAAgAAAAJAAAACgAAAAsAAAAMAAAADQAAAA4AAAAPAAAAEAAAABEAAAASAAAAEwAAABQAAAAVAAAAFgAAABcAAAAYAAAAGQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAL" } };
            yield return new object[] { new Collections.Queue(50, 5.6f), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAGBTeXN0ZW0uQ29sbGVjdGlvbnMuTm9uR2VuZXJpYywgVmVyc2lvbj00LjEuMS4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2EFAQAAABhTeXN0ZW0uQ29sbGVjdGlvbnMuUXVldWUGAAAABl9hcnJheQVfaGVhZAVfdGFpbAVfc2l6ZQtfZ3Jvd0ZhY3RvcghfdmVyc2lvbgUAAAAAAAgICAgIAgAAAAkDAAAAAAAAAAAAAAAAAAAAMAIAAAAAAAAQAwAAADIAAAANMgs=", "AAEAAAD/////AQAAAAAAAAAEAQAAABhTeXN0ZW0uQ29sbGVjdGlvbnMuUXVldWUGAAAABl9hcnJheQVfaGVhZAVfdGFpbAVfc2l6ZQtfZ3Jvd0ZhY3RvcghfdmVyc2lvbgUAAAAAAAgICAgICQIAAAAAAAAAAAAAAAAAAAAwAgAAAAAAABACAAAAMgAAAA0yCw==" } };
            yield return new object[] { new SortedDictionary<int, Point>(pointDictionary, Comparer<int>.Default), new string[] { "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", "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" } };
            yield return new object[] { new SortedList<int, Point>(pointDictionary, Comparer<int>.Default), new string[] { "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", "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" } };
            yield return new object[] { new Collections.SortedList(pointDictionary, Comparer<int>.Default), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAGBTeXN0ZW0uQ29sbGVjdGlvbnMuTm9uR2VuZXJpYywgVmVyc2lvbj00LjEuMS4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2EFAQAAAB1TeXN0ZW0uQ29sbGVjdGlvbnMuU29ydGVkTGlzdAcAAAAFX2tleXMHX3ZhbHVlcwVfc2l6ZQhfdmVyc2lvbglfY29tcGFyZXIIX2tleUxpc3QKX3ZhbHVlTGlzdAUFAAADBAQICJcBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuR2VuZXJpY0NvbXBhcmVyYDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXSVTeXN0ZW0uQ29sbGVjdGlvbnMuU29ydGVkTGlzdCtLZXlMaXN0AgAAACdTeXN0ZW0uQ29sbGVjdGlvbnMuU29ydGVkTGlzdCtWYWx1ZUxpc3QCAAAAAgAAAAkDAAAACQQAAAACAAAAAAAAAAkFAAAACgoQAwAAAAIAAAAICAEAAAAICAIAAAAQBAAAAAIAAAAJBgAAAAkHAAAABAUAAACXAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLkdlbmVyaWNDb21wYXJlcmAxW1tTeXN0ZW0uSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0AAAAADAgAAABwU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYgUGAAAAM1N5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5Qb2ludAIAAAABWAFZAAAICAgAAAABAAAAAQAAAAEHAAAABgAAAAIAAAACAAAACw==", "AAEAAAD/////AQAAAAAAAAAEAQAAAB1TeXN0ZW0uQ29sbGVjdGlvbnMuU29ydGVkTGlzdAcAAAAEa2V5cwZ2YWx1ZXMFX3NpemUHdmVyc2lvbghjb21wYXJlcgdrZXlMaXN0CXZhbHVlTGlzdAUFAAADAwMICIkBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuR2VuZXJpY0NvbXBhcmVyYDFbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0lU3lzdGVtLkNvbGxlY3Rpb25zLlNvcnRlZExpc3QrS2V5TGlzdCdTeXN0ZW0uQ29sbGVjdGlvbnMuU29ydGVkTGlzdCtWYWx1ZUxpc3QJAgAAAAkDAAAAAgAAAAAAAAAJBAAAAAoKEAIAAAACAAAACAgBAAAACAgCAAAAEAMAAAACAAAACQUAAAAJBgAAAAQEAAAAiQFTeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5HZW5lcmljQ29tcGFyZXJgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQAAAAAMBwAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQUAAAAzU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50AgAAAAFYAVkAAAgIBwAAAAEAAAABAAAAAQYAAAAFAAAAAgAAAAIAAAAL" } };
            yield return new object[] { new SortedSet<Point>(new[] { point, new Point(3, 5) }), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uQ29sbGVjdGlvbnMsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhDAMAAABwU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYgUBAAAAzwFTeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5Tb3J0ZWRTZXRgMVtbU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50LCBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViXV0EAAAABUNvdW50CENvbXBhcmVyB1ZlcnNpb24FSXRlbXMAAwAECNUBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuR2VuZXJpY0NvbXBhcmVyYDFbW1N5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5Qb2ludCwgU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYl1dCDVTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnRbXQMAAAACAAAAAQAAAAkEAAAAAAAAAAkFAAAABAQAAADVAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLkdlbmVyaWNDb21wYXJlcmAxW1tTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnQsIFN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cywgVmVyc2lvbj00LjAuMy4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTlkNzdjYzdhZDM5YjY4ZWJdXQAAAAAHBQAAAAABAAAAAQAAAAQzU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50AwAAAAkGAAAABQYAAAAzU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50AgAAAAFYAVkAAAgIAwAAAAEAAAACAAAACw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5DAMAAABwU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYgUBAAAAzwFTeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5Tb3J0ZWRTZXRgMVtbU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50LCBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViXV0EAAAABUNvdW50CENvbXBhcmVyB1ZlcnNpb24FSXRlbXMAAwAECNUBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuR2VuZXJpY0NvbXBhcmVyYDFbW1N5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5Qb2ludCwgU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYl1dCDVTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnRbXQMAAAACAAAAAQAAAAkEAAAAAAAAAAkFAAAABAQAAADVAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLkdlbmVyaWNDb21wYXJlcmAxW1tTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnQsIFN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cywgVmVyc2lvbj00LjAuMy4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTlkNzdjYzdhZDM5YjY4ZWJdXQAAAAAHBQAAAAABAAAAAQAAAAQzU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50AwAAAAkGAAAABQYAAAAzU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50AgAAAAFYAVkAAAgIAwAAAAEAAAACAAAACw==" } };
            yield return new object[] { new SortedSet<int?>(new int?[] { 2, 4, 6, null }, Comparer<int?>.Default), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uQ29sbGVjdGlvbnMsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAACBAlN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLlNvcnRlZFNldGAxW1tTeXN0ZW0uTnVsbGFibGVgMVtbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dBAAAAAVDb3VudAhDb21wYXJlcgdWZXJzaW9uBUl0ZW1zAAMAAwiYAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLk51bGxhYmxlQ29tcGFyZXJgMVtbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dCH5TeXN0ZW0uTnVsbGFibGVgMVtbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dW10CAAAABAAAAAkDAAAAAAAAAAkEAAAABAMAAACYAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLk51bGxhYmxlQ29tcGFyZXJgMVtbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dAAAAAAcEAAAAAAEAAAAEAAAAA3xTeXN0ZW0uTnVsbGFibGVgMVtbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dCggIAgAAAAgIBAAAAAgIBgAAAAs=", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAADlAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLlNvcnRlZFNldGAxW1tTeXN0ZW0uTnVsbGFibGVgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXSwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0EAAAABUNvdW50CENvbXBhcmVyB1ZlcnNpb24FSXRlbXMAAwADCIoBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuTnVsbGFibGVDb21wYXJlcmAxW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dCHBTeXN0ZW0uTnVsbGFibGVgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXVtdAgAAAAQAAAAJAwAAAAAAAAAJBAAAAAQDAAAAigFTeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5OdWxsYWJsZUNvbXBhcmVyYDFbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0AAAAABwQAAAAAAQAAAAQAAAADblN5c3RlbS5OdWxsYWJsZWAxW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dCggIAgAAAAgIBAAAAAgIBgAAAAs=" } };
            yield return new object[] { new Stack<Point>(new[] { point, new Point(2, 2) }), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uQ29sbGVjdGlvbnMsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhDAMAAABwU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYgUBAAAAywFTeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5TdGFja2AxW1tTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnQsIFN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cywgVmVyc2lvbj00LjAuMy4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTlkNzdjYzdhZDM5YjY4ZWJdXQMAAAAGX2FycmF5BV9zaXplCF92ZXJzaW9uBAAANVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5Qb2ludFtdAwAAAAgIAgAAAAkEAAAAAgAAAAAAAAAHBAAAAAABAAAAAgAAAAQzU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50AwAAAAkFAAAACQYAAAAFBQAAADNTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnQCAAAAAVgBWQAACAgDAAAAAQAAAAIAAAABBgAAAAUAAAACAAAAAgAAAAs=", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5DAMAAABwU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYgUBAAAAywFTeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5TdGFja2AxW1tTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnQsIFN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cywgVmVyc2lvbj00LjAuMy4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTlkNzdjYzdhZDM5YjY4ZWJdXQMAAAAGX2FycmF5BV9zaXplCF92ZXJzaW9uBAAANVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5Qb2ludFtdAwAAAAgIAgAAAAkEAAAAAgAAAAAAAAAHBAAAAAABAAAAAgAAAAQzU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50AwAAAAkFAAAACQYAAAAFBQAAADNTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnQCAAAAAVgBWQAACAgDAAAAAQAAAAIAAAABBgAAAAUAAAACAAAAAgAAAAs=" } };
            yield return new object[] { new System.Collections.Hashtable(pointDictionary, 0.3f, EqualityComparer<int>.Default), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFxTeXN0ZW0uUnVudGltZS5FeHRlbnNpb25zLCBWZXJzaW9uPTQuMi4xLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49YjAzZjVmN2YxMWQ1MGEzYQUBAAAAHFN5c3RlbS5Db2xsZWN0aW9ucy5IYXNodGFibGUGAAAACkxvYWRGYWN0b3IHVmVyc2lvbgtLZXlDb21wYXJlcghIYXNoU2l6ZQRLZXlzBlZhbHVlcwAAAwAFBQsInwFTeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5HZW5lcmljRXF1YWxpdHlDb21wYXJlcmAxW1tTeXN0ZW0uSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0IAgAAABwvXT4CAAAACQMAAAALAAAACQQAAAAJBQAAAAQDAAAAnwFTeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5HZW5lcmljRXF1YWxpdHlDb21wYXJlcmAxW1tTeXN0ZW0uSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0AAAAAEAQAAAACAAAACAgCAAAACAgBAAAAEAUAAAACAAAACQYAAAAJBwAAAAwIAAAAcFN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cywgVmVyc2lvbj00LjAuMy4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTlkNzdjYzdhZDM5YjY4ZWIFBgAAADNTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnQCAAAAAVgBWQAACAgIAAAAAgAAAAIAAAABBwAAAAYAAAABAAAAAQAAAAs=", "AAEAAAD/////AQAAAAAAAAAEAQAAABxTeXN0ZW0uQ29sbGVjdGlvbnMuSGFzaHRhYmxlBgAAAApMb2FkRmFjdG9yB1ZlcnNpb24LS2V5Q29tcGFyZXIISGFzaFNpemUES2V5cwZWYWx1ZXMAAAMABQULCJEBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuR2VuZXJpY0VxdWFsaXR5Q29tcGFyZXJgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQgcL10+AgAAAAkCAAAACwAAAAkDAAAACQQAAAAEAgAAAJEBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuR2VuZXJpY0VxdWFsaXR5Q29tcGFyZXJgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQAAAAAQAwAAAAIAAAAICAIAAAAICAEAAAAQBAAAAAIAAAAJBQAAAAkGAAAADAcAAABwU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYgUFAAAAM1N5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5Qb2ludAIAAAABWAFZAAAICAcAAAACAAAAAgAAAAEGAAAABQAAAAEAAAABAAAACw==" } };
            yield return new object[] { new System.ComponentModel.BindingList<int>(new[] { 34, 52 }), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAGZTeXN0ZW0uQ29tcG9uZW50TW9kZWwuVHlwZUNvbnZlcnRlciwgVmVyc2lvbj00LjIuMS4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2EFAQAAAI4BU3lzdGVtLkNvbXBvbmVudE1vZGVsLkJpbmRpbmdMaXN0YDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQgAAAAJYWRkTmV3UG9zFnJhaXNlTGlzdENoYW5nZWRFdmVudHMWcmFpc2VJdGVtQ2hhbmdlZEV2ZW50cwhhbGxvd05ldwlhbGxvd0VkaXQLYWxsb3dSZW1vdmUPdXNlclNldEFsbG93TmV3BWl0ZW1zAAAAAAAAAAMIAQEBAQEBDlN5c3RlbS5JbnQzMltdAgAAAP////8BAAEBAQAJAwAAAA8DAAAAAgAAAAgiAAAANAAAAAs=", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAACAAVN5c3RlbS5Db21wb25lbnRNb2RlbC5CaW5kaW5nTGlzdGAxW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dCAAAAAlhZGROZXdQb3MWcmFpc2VMaXN0Q2hhbmdlZEV2ZW50cxZyYWlzZUl0ZW1DaGFuZ2VkRXZlbnRzCGFsbG93TmV3CWFsbG93RWRpdAthbGxvd1JlbW92ZQ91c2VyU2V0QWxsb3dOZXcSQ29sbGVjdGlvbmAxK2l0ZW1zAAAAAAAAAAMIAQEBAQEBDlN5c3RlbS5JbnQzMltdAgAAAP////8BAAEBAQAJAwAAAA8DAAAAAgAAAAgiAAAANAAAAAs=" } };
            yield return new object[] { new System.ComponentModel.BindingList<Point>(new[] { point }), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAGZTeXN0ZW0uQ29tcG9uZW50TW9kZWwuVHlwZUNvbnZlcnRlciwgVmVyc2lvbj00LjIuMS4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2EMAwAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAADMAVN5c3RlbS5Db21wb25lbnRNb2RlbC5CaW5kaW5nTGlzdGAxW1tTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnQsIFN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cywgVmVyc2lvbj00LjAuMy4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTlkNzdjYzdhZDM5YjY4ZWJdXQgAAAAJYWRkTmV3UG9zFnJhaXNlTGlzdENoYW5nZWRFdmVudHMWcmFpc2VJdGVtQ2hhbmdlZEV2ZW50cwhhbGxvd05ldwlhbGxvd0VkaXQLYWxsb3dSZW1vdmUPdXNlclNldEFsbG93TmV3BWl0ZW1zAAAAAAAAAAQIAQEBAQEBNVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5Qb2ludFtdAwAAAAIAAAD/////AQAAAQEACQQAAAAHBAAAAAABAAAAAQAAAAQzU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50AwAAAAkFAAAABQUAAAAzU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50AgAAAAFYAVkAAAgIAwAAAAEAAAACAAAACw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5DAMAAABwU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYgUBAAAAzAFTeXN0ZW0uQ29tcG9uZW50TW9kZWwuQmluZGluZ0xpc3RgMVtbU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50LCBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViXV0IAAAACWFkZE5ld1BvcxZyYWlzZUxpc3RDaGFuZ2VkRXZlbnRzFnJhaXNlSXRlbUNoYW5nZWRFdmVudHMIYWxsb3dOZXcJYWxsb3dFZGl0C2FsbG93UmVtb3ZlD3VzZXJTZXRBbGxvd05ldxJDb2xsZWN0aW9uYDEraXRlbXMAAAAAAAAABAgBAQEBAQE1U3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50W10DAAAAAgAAAP////8BAAEBAQAJBAAAAAcEAAAAAAEAAAABAAAABDNTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnQDAAAACQUAAAAFBQAAADNTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuUG9pbnQCAAAAAVgBWQAACAgDAAAAAQAAAAIAAAAL" } };
            yield return new object[] { new Collections.Stack(new[] { point }), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAGBTeXN0ZW0uQ29sbGVjdGlvbnMuTm9uR2VuZXJpYywgVmVyc2lvbj00LjEuMS4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2EFAQAAABhTeXN0ZW0uQ29sbGVjdGlvbnMuU3RhY2sDAAAABl9hcnJheQVfc2l6ZQhfdmVyc2lvbgUAAAgIAgAAAAkDAAAAAQAAAAEAAAAQAwAAAAoAAAAJBAAAAA0JDAUAAABwU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYgUEAAAAM1N5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5Qb2ludAIAAAABWAFZAAAICAUAAAABAAAAAgAAAAs=", "AAEAAAD/////AQAAAAAAAAAEAQAAABhTeXN0ZW0uQ29sbGVjdGlvbnMuU3RhY2sDAAAABl9hcnJheQVfc2l6ZQhfdmVyc2lvbgUAAAgICQIAAAABAAAAAQAAABACAAAACgAAAAkDAAAADQkMBAAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQMAAAAzU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlBvaW50AgAAAAFYAVkAAAgIBAAAAAEAAAACAAAACw==" } };
            yield return new object[] { new System.Collections.Specialized.StringDictionary
            {
                { "key1", "val1" },
                { "keyx", "valx" }
            }, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAGFTeXN0ZW0uQ29sbGVjdGlvbnMuU3BlY2lhbGl6ZWQsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhDAMAAABcU3lzdGVtLlJ1bnRpbWUuRXh0ZW5zaW9ucywgVmVyc2lvbj00LjIuMS4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2EFAQAAAC9TeXN0ZW0uQ29sbGVjdGlvbnMuU3BlY2lhbGl6ZWQuU3RyaW5nRGljdGlvbmFyeQEAAAAJX2NvbnRlbnRzBBxTeXN0ZW0uQ29sbGVjdGlvbnMuSGFzaHRhYmxlAwAAAAIAAAAJBAAAAAUEAAAAHFN5c3RlbS5Db2xsZWN0aW9ucy5IYXNodGFibGUHAAAACkxvYWRGYWN0b3IHVmVyc2lvbghDb21wYXJlchBIYXNoQ29kZVByb3ZpZGVyCEhhc2hTaXplBEtleXMGVmFsdWVzAAADBAAFBQsIHFN5c3RlbS5Db2xsZWN0aW9ucy5JQ29tcGFyZXIkU3lzdGVtLkNvbGxlY3Rpb25zLklIYXNoQ29kZVByb3ZpZGVyAwAAAAgDAAAA7FE4PwIAAAAKCgMAAAAJBQAAAAkGAAAAEAUAAAACAAAABgcAAAAEa2V5eAYIAAAABGtleTEQBgAAAAIAAAAGCQAAAAR2YWx4BgoAAAAEdmFsMQs=", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAAAvU3lzdGVtLkNvbGxlY3Rpb25zLlNwZWNpYWxpemVkLlN0cmluZ0RpY3Rpb25hcnkBAAAACGNvbnRlbnRzAxxTeXN0ZW0uQ29sbGVjdGlvbnMuSGFzaHRhYmxlAgAAAAkDAAAABAMAAAAcU3lzdGVtLkNvbGxlY3Rpb25zLkhhc2h0YWJsZQcAAAAKTG9hZEZhY3RvcgdWZXJzaW9uCENvbXBhcmVyEEhhc2hDb2RlUHJvdmlkZXIISGFzaFNpemUES2V5cwZWYWx1ZXMAAAMDAAUFCwgcU3lzdGVtLkNvbGxlY3Rpb25zLklDb21wYXJlciRTeXN0ZW0uQ29sbGVjdGlvbnMuSUhhc2hDb2RlUHJvdmlkZXII7FE4PwIAAAAKCgMAAAAJBAAAAAkFAAAAEAQAAAACAAAABgYAAAAEa2V5MQYHAAAABGtleXgQBQAAAAIAAAAGCAAAAAR2YWwxBgkAAAAEdmFseAs=" } };
            yield return new object[] { new System.Collections.Specialized.StringCollection()
            {
                "asdf",
                "bdes",
                "Abd"
            }, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAGFTeXN0ZW0uQ29sbGVjdGlvbnMuU3BlY2lhbGl6ZWQsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhDAMAAABcU3lzdGVtLlJ1bnRpbWUuRXh0ZW5zaW9ucywgVmVyc2lvbj00LjIuMS4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2EFAQAAAC9TeXN0ZW0uQ29sbGVjdGlvbnMuU3BlY2lhbGl6ZWQuU3RyaW5nQ29sbGVjdGlvbgEAAAAEZGF0YQQcU3lzdGVtLkNvbGxlY3Rpb25zLkFycmF5TGlzdAMAAAACAAAACQQAAAAFBAAAABxTeXN0ZW0uQ29sbGVjdGlvbnMuQXJyYXlMaXN0AwAAAAZfaXRlbXMFX3NpemUIX3ZlcnNpb24FAAAICAMAAAAJBQAAAAMAAAADAAAAEAUAAAAEAAAABgYAAAAEYXNkZgYHAAAABGJkZXMGCAAAAANBYmQKCw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAAAvU3lzdGVtLkNvbGxlY3Rpb25zLlNwZWNpYWxpemVkLlN0cmluZ0NvbGxlY3Rpb24BAAAABGRhdGEDHFN5c3RlbS5Db2xsZWN0aW9ucy5BcnJheUxpc3QCAAAACQMAAAAEAwAAABxTeXN0ZW0uQ29sbGVjdGlvbnMuQXJyYXlMaXN0AwAAAAZfaXRlbXMFX3NpemUIX3ZlcnNpb24FAAAICAkEAAAAAwAAAAMAAAAQBAAAAAQAAAAGBQAAAARhc2RmBgYAAAAEYmRlcwYHAAAAA0FiZAoL" } };
            yield return new object[] { new System.Collections.Specialized.OrderedDictionary(7)
            {
                { "key1", 34 },
                { "keyx", "s2" },
                { 22, "sample" }
            }, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAGFTeXN0ZW0uQ29sbGVjdGlvbnMuU3BlY2lhbGl6ZWQsIFZlcnNpb249NC4xLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAAwU3lzdGVtLkNvbGxlY3Rpb25zLlNwZWNpYWxpemVkLk9yZGVyZWREaWN0aW9uYXJ5BAAAAAtLZXlDb21wYXJlcghSZWFkT25seQ9Jbml0aWFsQ2FwYWNpdHkJQXJyYXlMaXN0AwAABSRTeXN0ZW0uQ29sbGVjdGlvbnMuSUVxdWFsaXR5Q29tcGFyZXIBCAIAAAAKAAcAAAAJAwAAABADAAAAAwAAAAkEAAAACQUAAAAJBgAAAAQEAAAAIlN5c3RlbS5Db2xsZWN0aW9ucy5EaWN0aW9uYXJ5RW50cnkCAAAABF9rZXkGX3ZhbHVlAgIGBwAAAARrZXkxCAgiAAAAAQUAAAAEAAAABggAAAAEa2V5eAYJAAAAAnMyAQYAAAAEAAAACAgWAAAABgoAAAAGc2FtcGxlCw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAAAwU3lzdGVtLkNvbGxlY3Rpb25zLlNwZWNpYWxpemVkLk9yZGVyZWREaWN0aW9uYXJ5BAAAAAtLZXlDb21wYXJlcghSZWFkT25seQ9Jbml0aWFsQ2FwYWNpdHkJQXJyYXlMaXN0AwAABSRTeXN0ZW0uQ29sbGVjdGlvbnMuSUVxdWFsaXR5Q29tcGFyZXIBCAIAAAAKAAcAAAAJAwAAABADAAAAAwAAAAkEAAAACQUAAAAJBgAAAAQEAAAAIlN5c3RlbS5Db2xsZWN0aW9ucy5EaWN0aW9uYXJ5RW50cnkCAAAABF9rZXkGX3ZhbHVlAgIGBwAAAARrZXkxCAgiAAAAAQUAAAAEAAAABggAAAAEa2V5eAYJAAAAAnMyAQYAAAAEAAAACAgWAAAABgoAAAAGc2FtcGxlCw==" } };

            var nvCollectionIgnoreCase = new System.Collections.Specialized.NameValueCollection(10, StringComparer.Create(CultureInfo.InvariantCulture, true))
            {
                { "name1", "value1" },
                { "name2", "value2" }
            };
            yield return new object[] { nvCollectionIgnoreCase, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAGFTeXN0ZW0uQ29sbGVjdGlvbnMuU3BlY2lhbGl6ZWQsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAAyU3lzdGVtLkNvbGxlY3Rpb25zLlNwZWNpYWxpemVkLk5hbWVWYWx1ZUNvbGxlY3Rpb24GAAAACFJlYWRPbmx5C0tleUNvbXBhcmVyBUNvdW50BEtleXMGVmFsdWVzB1ZlcnNpb24AAwAGBQABG1N5c3RlbS5DdWx0dXJlQXdhcmVDb21wYXJlcggIAgAAAAAJAwAAAAIAAAAJBAAAAAkFAAAABAAAAAQDAAAAG1N5c3RlbS5DdWx0dXJlQXdhcmVDb21wYXJlcgIAAAAMX2NvbXBhcmVJbmZvCF9vcHRpb25zAwMgU3lzdGVtLkdsb2JhbGl6YXRpb24uQ29tcGFyZUluZm8jU3lzdGVtLkdsb2JhbGl6YXRpb24uQ29tcGFyZU9wdGlvbnMJBgAAAAT5////I1N5c3RlbS5HbG9iYWxpemF0aW9uLkNvbXBhcmVPcHRpb25zAQAAAAd2YWx1ZV9fAAgBAAAAEQQAAAACAAAABggAAAAFbmFtZTEGCQAAAAVuYW1lMhAFAAAAAgAAAAkKAAAACQsAAAAEBgAAACBTeXN0ZW0uR2xvYmFsaXphdGlvbi5Db21wYXJlSW5mbwIAAAAGbV9uYW1lDW1fc29ydFZlcnNpb24BAyBTeXN0ZW0uR2xvYmFsaXphdGlvbi5Tb3J0VmVyc2lvbgYMAAAAAAoMDQAAAFxTeXN0ZW0uUnVudGltZS5FeHRlbnNpb25zLCBWZXJzaW9uPTQuMi4xLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49YjAzZjVmN2YxMWQ1MGEzYQUKAAAAHFN5c3RlbS5Db2xsZWN0aW9ucy5BcnJheUxpc3QDAAAABl9pdGVtcwVfc2l6ZQhfdmVyc2lvbgUAAAgIDQAAAAkOAAAAAQAAAAEAAAABCwAAAAoAAAAJDwAAAAEAAAABAAAAEA4AAAABAAAABhAAAAAGdmFsdWUxEA8AAAABAAAABhEAAAAGdmFsdWUyCw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAAAyU3lzdGVtLkNvbGxlY3Rpb25zLlNwZWNpYWxpemVkLk5hbWVWYWx1ZUNvbGxlY3Rpb24GAAAACFJlYWRPbmx5C0tleUNvbXBhcmVyBUNvdW50BEtleXMGVmFsdWVzB1ZlcnNpb24AAwAGBQABG1N5c3RlbS5DdWx0dXJlQXdhcmVDb21wYXJlcggIAgAAAAAJAwAAAAIAAAAJBAAAAAkFAAAABAAAAAQDAAAAG1N5c3RlbS5DdWx0dXJlQXdhcmVDb21wYXJlcgIAAAAMX2NvbXBhcmVJbmZvC19pZ25vcmVDYXNlAwAgU3lzdGVtLkdsb2JhbGl6YXRpb24uQ29tcGFyZUluZm8BCQYAAAABEQQAAAACAAAABgcAAAAFbmFtZTEGCAAAAAVuYW1lMhAFAAAAAgAAAAkJAAAACQoAAAAEBgAAACBTeXN0ZW0uR2xvYmFsaXphdGlvbi5Db21wYXJlSW5mbwQAAAAGbV9uYW1lCXdpbjMyTENJRAdjdWx0dXJlDW1fU29ydFZlcnNpb24BAAADCAggU3lzdGVtLkdsb2JhbGl6YXRpb24uU29ydFZlcnNpb24GCwAAAAVlbi1VUwAAAAAJBAAACQwAAAAECQAAABxTeXN0ZW0uQ29sbGVjdGlvbnMuQXJyYXlMaXN0AwAAAAZfaXRlbXMFX3NpemUIX3ZlcnNpb24FAAAICAkNAAAAAQAAAAEAAAABCgAAAAkAAAAJDgAAAAEAAAABAAAABAwAAAAgU3lzdGVtLkdsb2JhbGl6YXRpb24uU29ydFZlcnNpb24CAAAADG1fTmxzVmVyc2lvbghtX1NvcnRJZAADCAtTeXN0ZW0uR3VpZA4CBgAE8f///wtTeXN0ZW0uR3VpZAsAAAACX2ECX2ICX2MCX2QCX2UCX2YCX2cCX2gCX2kCX2oCX2sAAAAAAAAAAAAAAAgHBwICAgICAgICAQAAAO5XXB4AtNAAC7HhHhANAAAAAQAAAAYQAAAABnZhbHVlMRAOAAAAAQAAAAYRAAAABnZhbHVlMgs=" } };

            var listDictionary = new System.Collections.Specialized.ListDictionary(StringComparer.Create(CultureInfo.InvariantCulture, false))
            {
                { "key1", "value1" },
                { "keyx", "valuex" }
            };
            yield return new object[] { listDictionary, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAGFTeXN0ZW0uQ29sbGVjdGlvbnMuU3BlY2lhbGl6ZWQsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAAtU3lzdGVtLkNvbGxlY3Rpb25zLlNwZWNpYWxpemVkLkxpc3REaWN0aW9uYXJ5BAAAAARoZWFkB3ZlcnNpb24FY291bnQIY29tcGFyZXIEAAADPFN5c3RlbS5Db2xsZWN0aW9ucy5TcGVjaWFsaXplZC5MaXN0RGljdGlvbmFyeStEaWN0aW9uYXJ5Tm9kZQIAAAAICBtTeXN0ZW0uQ3VsdHVyZUF3YXJlQ29tcGFyZXICAAAACQMAAAACAAAAAgAAAAkEAAAABQMAAAA8U3lzdGVtLkNvbGxlY3Rpb25zLlNwZWNpYWxpemVkLkxpc3REaWN0aW9uYXJ5K0RpY3Rpb25hcnlOb2RlAwAAAANrZXkFdmFsdWUEbmV4dAICBDxTeXN0ZW0uQ29sbGVjdGlvbnMuU3BlY2lhbGl6ZWQuTGlzdERpY3Rpb25hcnkrRGljdGlvbmFyeU5vZGUCAAAAAgAAAAYFAAAABGtleTEGBgAAAAZ2YWx1ZTEJBwAAAAQEAAAAG1N5c3RlbS5DdWx0dXJlQXdhcmVDb21wYXJlcgIAAAAMX2NvbXBhcmVJbmZvCF9vcHRpb25zAwMgU3lzdGVtLkdsb2JhbGl6YXRpb24uQ29tcGFyZUluZm8jU3lzdGVtLkdsb2JhbGl6YXRpb24uQ29tcGFyZU9wdGlvbnMJCAAAAAT3////I1N5c3RlbS5HbG9iYWxpemF0aW9uLkNvbXBhcmVPcHRpb25zAQAAAAd2YWx1ZV9fAAgAAAAAAQcAAAADAAAABgoAAAAEa2V5eAYLAAAABnZhbHVleAoECAAAACBTeXN0ZW0uR2xvYmFsaXphdGlvbi5Db21wYXJlSW5mbwIAAAAGbV9uYW1lDW1fc29ydFZlcnNpb24BAyBTeXN0ZW0uR2xvYmFsaXphdGlvbi5Tb3J0VmVyc2lvbgYMAAAAAAoL", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAAAtU3lzdGVtLkNvbGxlY3Rpb25zLlNwZWNpYWxpemVkLkxpc3REaWN0aW9uYXJ5BAAAAARoZWFkB3ZlcnNpb24FY291bnQIY29tcGFyZXIEAAADPFN5c3RlbS5Db2xsZWN0aW9ucy5TcGVjaWFsaXplZC5MaXN0RGljdGlvbmFyeStEaWN0aW9uYXJ5Tm9kZQIAAAAICBtTeXN0ZW0uQ3VsdHVyZUF3YXJlQ29tcGFyZXICAAAACQMAAAACAAAAAgAAAAkEAAAABQMAAAA8U3lzdGVtLkNvbGxlY3Rpb25zLlNwZWNpYWxpemVkLkxpc3REaWN0aW9uYXJ5K0RpY3Rpb25hcnlOb2RlAwAAAANrZXkFdmFsdWUEbmV4dAICBDxTeXN0ZW0uQ29sbGVjdGlvbnMuU3BlY2lhbGl6ZWQuTGlzdERpY3Rpb25hcnkrRGljdGlvbmFyeU5vZGUCAAAAAgAAAAYFAAAABGtleTEGBgAAAAZ2YWx1ZTEJBwAAAAQEAAAAG1N5c3RlbS5DdWx0dXJlQXdhcmVDb21wYXJlcgIAAAAMX2NvbXBhcmVJbmZvC19pZ25vcmVDYXNlAwAgU3lzdGVtLkdsb2JhbGl6YXRpb24uQ29tcGFyZUluZm8BCQgAAAAAAQcAAAADAAAABgkAAAAEa2V5eAYKAAAABnZhbHVleAoECAAAACBTeXN0ZW0uR2xvYmFsaXphdGlvbi5Db21wYXJlSW5mbwQAAAAGbV9uYW1lCXdpbjMyTENJRAdjdWx0dXJlDW1fU29ydFZlcnNpb24BAAADCAggU3lzdGVtLkdsb2JhbGl6YXRpb24uU29ydFZlcnNpb24GCwAAAAVlbi1VUwAAAAAJBAAACQwAAAAEDAAAACBTeXN0ZW0uR2xvYmFsaXphdGlvbi5Tb3J0VmVyc2lvbgIAAAAMbV9ObHNWZXJzaW9uCG1fU29ydElkAAMIC1N5c3RlbS5HdWlkDgIGAATz////C1N5c3RlbS5HdWlkCwAAAAJfYQJfYgJfYwJfZAJfZQJfZgJfZwJfaAJfaQJfagJfawAAAAAAAAAAAAAACAcHAgICAgICAgIBAAAA7ldcHgC00AALseEeCw==" } };
            yield return new object[] { new System.Collections.Specialized.ListDictionary(StringComparer.Ordinal), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAGFTeXN0ZW0uQ29sbGVjdGlvbnMuU3BlY2lhbGl6ZWQsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAAtU3lzdGVtLkNvbGxlY3Rpb25zLlNwZWNpYWxpemVkLkxpc3REaWN0aW9uYXJ5BAAAAARoZWFkB3ZlcnNpb24FY291bnQIY29tcGFyZXIEAAADPFN5c3RlbS5Db2xsZWN0aW9ucy5TcGVjaWFsaXplZC5MaXN0RGljdGlvbmFyeStEaWN0aW9uYXJ5Tm9kZQIAAAAICBZTeXN0ZW0uT3JkaW5hbENvbXBhcmVyAgAAAAoAAAAAAAAAAAkDAAAABAMAAAAWU3lzdGVtLk9yZGluYWxDb21wYXJlcgAAAAAL", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAAAtU3lzdGVtLkNvbGxlY3Rpb25zLlNwZWNpYWxpemVkLkxpc3REaWN0aW9uYXJ5BAAAAARoZWFkB3ZlcnNpb24FY291bnQIY29tcGFyZXIEAAADPFN5c3RlbS5Db2xsZWN0aW9ucy5TcGVjaWFsaXplZC5MaXN0RGljdGlvbmFyeStEaWN0aW9uYXJ5Tm9kZQIAAAAICBZTeXN0ZW0uT3JkaW5hbENvbXBhcmVyAgAAAAoAAAAAAAAAAAkDAAAABAMAAAAWU3lzdGVtLk9yZGluYWxDb21wYXJlcgEAAAALX2lnbm9yZUNhc2UAAQAL" } };
            yield return new object[] { new System.Collections.Specialized.ListDictionary(StringComparer.OrdinalIgnoreCase), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAGFTeXN0ZW0uQ29sbGVjdGlvbnMuU3BlY2lhbGl6ZWQsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAAtU3lzdGVtLkNvbGxlY3Rpb25zLlNwZWNpYWxpemVkLkxpc3REaWN0aW9uYXJ5BAAAAARoZWFkB3ZlcnNpb24FY291bnQIY29tcGFyZXIEAAADPFN5c3RlbS5Db2xsZWN0aW9ucy5TcGVjaWFsaXplZC5MaXN0RGljdGlvbmFyeStEaWN0aW9uYXJ5Tm9kZQIAAAAICCBTeXN0ZW0uT3JkaW5hbElnbm9yZUNhc2VDb21wYXJlcgIAAAAKAAAAAAAAAAAJAwAAAAQDAAAAIFN5c3RlbS5PcmRpbmFsSWdub3JlQ2FzZUNvbXBhcmVyAAAAAAs=", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAAAtU3lzdGVtLkNvbGxlY3Rpb25zLlNwZWNpYWxpemVkLkxpc3REaWN0aW9uYXJ5BAAAAARoZWFkB3ZlcnNpb24FY291bnQIY29tcGFyZXIEAAADPFN5c3RlbS5Db2xsZWN0aW9ucy5TcGVjaWFsaXplZC5MaXN0RGljdGlvbmFyeStEaWN0aW9uYXJ5Tm9kZQIAAAAICBZTeXN0ZW0uT3JkaW5hbENvbXBhcmVyAgAAAAoAAAAAAAAAAAkDAAAABAMAAAAWU3lzdGVtLk9yZGluYWxDb21wYXJlcgEAAAALX2lnbm9yZUNhc2UAAQEL" } };

            var hybridDictionary = new System.Collections.Specialized.HybridDictionary(10, true)
            {
                { 32, "5d" },
                { "5d", 32 }
            };
            yield return new object[] { hybridDictionary, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAGFTeXN0ZW0uQ29sbGVjdGlvbnMuU3BlY2lhbGl6ZWQsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhDAMAAABcU3lzdGVtLlJ1bnRpbWUuRXh0ZW5zaW9ucywgVmVyc2lvbj00LjIuMS4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWIwM2Y1ZjdmMTFkNTBhM2EFAQAAAC9TeXN0ZW0uQ29sbGVjdGlvbnMuU3BlY2lhbGl6ZWQuSHlicmlkRGljdGlvbmFyeQMAAAAFX2xpc3QKX2hhc2h0YWJsZRBfY2FzZUluc2Vuc2l0aXZlBAQALVN5c3RlbS5Db2xsZWN0aW9ucy5TcGVjaWFsaXplZC5MaXN0RGljdGlvbmFyeQIAAAAcU3lzdGVtLkNvbGxlY3Rpb25zLkhhc2h0YWJsZQMAAAABAgAAAAoJBAAAAAEFBAAAABxTeXN0ZW0uQ29sbGVjdGlvbnMuSGFzaHRhYmxlBgAAAApMb2FkRmFjdG9yB1ZlcnNpb24LS2V5Q29tcGFyZXIISGFzaFNpemUES2V5cwZWYWx1ZXMAAAMABQULCCBTeXN0ZW0uT3JkaW5hbElnbm9yZUNhc2VDb21wYXJlcggDAAAA7FE4PwIAAAAJBQAAABEAAAAJBgAAAAkHAAAABAUAAAAgU3lzdGVtLk9yZGluYWxJZ25vcmVDYXNlQ29tcGFyZXIAAAAAEAYAAAACAAAACAggAAAABggAAAACNWQQBwAAAAIAAAAJCAAAAAgIIAAAAAs=", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAAAvU3lzdGVtLkNvbGxlY3Rpb25zLlNwZWNpYWxpemVkLkh5YnJpZERpY3Rpb25hcnkDAAAABGxpc3QJaGFzaHRhYmxlD2Nhc2VJbnNlbnNpdGl2ZQQDAC1TeXN0ZW0uQ29sbGVjdGlvbnMuU3BlY2lhbGl6ZWQuTGlzdERpY3Rpb25hcnkCAAAAHFN5c3RlbS5Db2xsZWN0aW9ucy5IYXNodGFibGUBAgAAAAoJAwAAAAEEAwAAABxTeXN0ZW0uQ29sbGVjdGlvbnMuSGFzaHRhYmxlBgAAAApMb2FkRmFjdG9yB1ZlcnNpb24LS2V5Q29tcGFyZXIISGFzaFNpemUES2V5cwZWYWx1ZXMAAAMABQULCBZTeXN0ZW0uT3JkaW5hbENvbXBhcmVyCOxROD8CAAAACQQAAAARAAAACQUAAAAJBgAAAAQEAAAAFlN5c3RlbS5PcmRpbmFsQ29tcGFyZXIBAAAAC19pZ25vcmVDYXNlAAEBEAUAAAACAAAACAggAAAABgcAAAACNWQQBgAAAAIAAAAJBwAAAAgIIAAAAAs=" } };
            yield return new object[] { new SortedList<int, string>(dictionary, Comparer<int>.Default), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uQ29sbGVjdGlvbnMsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAAD9AVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLlNvcnRlZExpc3RgMltbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV0sW1N5c3RlbS5TdHJpbmcsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0HAAAABGtleXMGdmFsdWVzBV9zaXplB3ZlcnNpb24IY29tcGFyZXIHa2V5TGlzdAl2YWx1ZUxpc3QHBgAAAwQECAgIlwFTeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5HZW5lcmljQ29tcGFyZXJgMVtbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dhQJTeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5Tb3J0ZWRMaXN0YDIrS2V5TGlzdFtbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV0sW1N5c3RlbS5TdHJpbmcsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0CAAAAhwJTeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5Tb3J0ZWRMaXN0YDIrVmFsdWVMaXN0W1tTeXN0ZW0uSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXSxbU3lzdGVtLlN0cmluZywgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQIAAAACAAAACQMAAAAJBAAAAAIAAAAAAAAACQUAAAAKCg8DAAAAAgAAAAgBAAAAAgAAABEEAAAAAgAAAAYGAAAABHRlc3QGBwAAAAxhbm90aGVyIHRlc3QEBQAAAJcBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuR2VuZXJpY0NvbXBhcmVyYDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQAAAAAL", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAADhAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLlNvcnRlZExpc3RgMltbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldLFtTeXN0ZW0uU3RyaW5nLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQcAAAAEa2V5cwZ2YWx1ZXMFX3NpemUHdmVyc2lvbghjb21wYXJlcgdrZXlMaXN0CXZhbHVlTGlzdAcGAAADBAQICAiJAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLkdlbmVyaWNDb21wYXJlcmAxW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1d6QFTeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5Tb3J0ZWRMaXN0YDIrS2V5TGlzdFtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldLFtTeXN0ZW0uU3RyaW5nLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQIAAADrAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLlNvcnRlZExpc3RgMitWYWx1ZUxpc3RbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XSxbU3lzdGVtLlN0cmluZywgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0CAAAAAgAAAAkDAAAACQQAAAACAAAAAAAAAAkFAAAACgoPAwAAAAIAAAAIAQAAAAIAAAARBAAAAAIAAAAGBgAAAAR0ZXN0BgcAAAAMYW5vdGhlciB0ZXN0BAUAAACJAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLkdlbmVyaWNDb21wYXJlcmAxW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dAAAAAAs=" } };
            yield return new object[] { new Queue<int>(Enumerable.Range(1, 10)), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uQ29sbGVjdGlvbnMsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAACNAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLlF1ZXVlYDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQUAAAAGX2FycmF5BV9oZWFkBV90YWlsBV9zaXplCF92ZXJzaW9uBwAAAAAICAgICAIAAAAJAwAAAAAAAAAKAAAACgAAAAAAAAAPAwAAABAAAAAIAQAAAAIAAAADAAAABAAAAAUAAAAGAAAABwAAAAgAAAAJAAAACgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAs=", "AAEAAAD/////AQAAAAAAAAAMAgAAAElTeXN0ZW0sIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5BQEAAAB/U3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuUXVldWVgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQUAAAAGX2FycmF5BV9oZWFkBV90YWlsBV9zaXplCF92ZXJzaW9uBwAAAAAICAgICAIAAAAJAwAAAAAAAAAKAAAACgAAAAwAAAAPAwAAABAAAAAIAQAAAAIAAAADAAAABAAAAAUAAAAGAAAABwAAAAgAAAAJAAAACgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAs=" } };
            var observableCollection = new System.Collections.ObjectModel.ObservableCollection<int>(Enumerable.Range(1, 5));
            yield return new object[] { observableCollection, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uT2JqZWN0TW9kZWwsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAACgAVN5c3RlbS5Db2xsZWN0aW9ucy5PYmplY3RNb2RlbC5PYnNlcnZhYmxlQ29sbGVjdGlvbmAxW1tTeXN0ZW0uSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0CAAAACF9tb25pdG9yBWl0ZW1zBAOuAVN5c3RlbS5Db2xsZWN0aW9ucy5PYmplY3RNb2RlbC5PYnNlcnZhYmxlQ29sbGVjdGlvbmAxK1NpbXBsZU1vbml0b3JbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQIAAACMAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLkxpc3RgMVtbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dAgAAAAkDAAAACQQAAAAFAwAAAK4BU3lzdGVtLkNvbGxlY3Rpb25zLk9iamVjdE1vZGVsLk9ic2VydmFibGVDb2xsZWN0aW9uYDErU2ltcGxlTW9uaXRvcltbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dAQAAAApfYnVzeUNvdW50AAgCAAAAAAAAAAQEAAAAjAFTeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5MaXN0YDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQMAAAAGX2l0ZW1zBV9zaXplCF92ZXJzaW9uBwAACAgICQUAAAAFAAAAAQAAAA8FAAAACAAAAAgBAAAAAgAAAAMAAAAEAAAABQAAAAAAAAAAAAAAAAAAAAs=", "AAEAAAD/////AQAAAAAAAAAMAgAAAE5XaW5kb3dzQmFzZSwgVmVyc2lvbj0zLjAuMC4wLCBDdWx0dXJlPU5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTMxYmYzODU2YWQzNjRlMzUFAQAAAJIBU3lzdGVtLkNvbGxlY3Rpb25zLk9iamVjdE1vZGVsLk9ic2VydmFibGVDb2xsZWN0aW9uYDFbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0CAAAACF9tb25pdG9yEkNvbGxlY3Rpb25gMStpdGVtcwQDoAFTeXN0ZW0uQ29sbGVjdGlvbnMuT2JqZWN0TW9kZWwuT2JzZXJ2YWJsZUNvbGxlY3Rpb25gMStTaW1wbGVNb25pdG9yW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dAgAAAH5TeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5MaXN0YDFbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0CAAAACQMAAAAJBAAAAAUDAAAAoAFTeXN0ZW0uQ29sbGVjdGlvbnMuT2JqZWN0TW9kZWwuT2JzZXJ2YWJsZUNvbGxlY3Rpb25gMStTaW1wbGVNb25pdG9yW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dAQAAAApfYnVzeUNvdW50AAgCAAAAAAAAAAQEAAAAflN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLkxpc3RgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQMAAAAGX2l0ZW1zBV9zaXplCF92ZXJzaW9uBwAACAgICQUAAAAFAAAABQAAAA8FAAAACAAAAAgBAAAAAgAAAAMAAAAEAAAABQAAAAAAAAAAAAAAAAAAAAs=" } };
            yield return new object[] { new System.Collections.ObjectModel.ReadOnlyObservableCollection<int>(observableCollection), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAFVTeXN0ZW0uT2JqZWN0TW9kZWwsIFZlcnNpb249NC4xLjEuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iMDNmNWY3ZjExZDUwYTNhBQEAAACoAVN5c3RlbS5Db2xsZWN0aW9ucy5PYmplY3RNb2RlbC5SZWFkT25seU9ic2VydmFibGVDb2xsZWN0aW9uYDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQEAAAAEbGlzdASgAVN5c3RlbS5Db2xsZWN0aW9ucy5PYmplY3RNb2RlbC5PYnNlcnZhYmxlQ29sbGVjdGlvbmAxW1tTeXN0ZW0uSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0CAAAAAgAAAAkDAAAABQMAAACgAVN5c3RlbS5Db2xsZWN0aW9ucy5PYmplY3RNb2RlbC5PYnNlcnZhYmxlQ29sbGVjdGlvbmAxW1tTeXN0ZW0uSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0CAAAACF9tb25pdG9yBWl0ZW1zBAOuAVN5c3RlbS5Db2xsZWN0aW9ucy5PYmplY3RNb2RlbC5PYnNlcnZhYmxlQ29sbGVjdGlvbmAxK1NpbXBsZU1vbml0b3JbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQIAAACMAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLkxpc3RgMVtbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dAgAAAAkEAAAACQUAAAAFBAAAAK4BU3lzdGVtLkNvbGxlY3Rpb25zLk9iamVjdE1vZGVsLk9ic2VydmFibGVDb2xsZWN0aW9uYDErU2ltcGxlTW9uaXRvcltbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dAQAAAApfYnVzeUNvdW50AAgCAAAAAAAAAAQFAAAAjAFTeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5MaXN0YDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQMAAAAGX2l0ZW1zBV9zaXplCF92ZXJzaW9uBwAACAgICQYAAAAFAAAAAQAAAA8GAAAACAAAAAgBAAAAAgAAAAMAAAAEAAAABQAAAAAAAAAAAAAAAAAAAAs=", "AAEAAAD/////AQAAAAAAAAAMAgAAAE5XaW5kb3dzQmFzZSwgVmVyc2lvbj0zLjAuMC4wLCBDdWx0dXJlPU5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTMxYmYzODU2YWQzNjRlMzUFAQAAAJoBU3lzdGVtLkNvbGxlY3Rpb25zLk9iamVjdE1vZGVsLlJlYWRPbmx5T2JzZXJ2YWJsZUNvbGxlY3Rpb25gMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQEAAAAZUmVhZE9ubHlDb2xsZWN0aW9uYDErbGlzdASSAVN5c3RlbS5Db2xsZWN0aW9ucy5PYmplY3RNb2RlbC5PYnNlcnZhYmxlQ29sbGVjdGlvbmAxW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dAgAAAAIAAAAJAwAAAAUDAAAAkgFTeXN0ZW0uQ29sbGVjdGlvbnMuT2JqZWN0TW9kZWwuT2JzZXJ2YWJsZUNvbGxlY3Rpb25gMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQIAAAAIX21vbml0b3ISQ29sbGVjdGlvbmAxK2l0ZW1zBAOgAVN5c3RlbS5Db2xsZWN0aW9ucy5PYmplY3RNb2RlbC5PYnNlcnZhYmxlQ29sbGVjdGlvbmAxK1NpbXBsZU1vbml0b3JbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0CAAAAflN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLkxpc3RgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQIAAAAJBAAAAAkFAAAABQQAAACgAVN5c3RlbS5Db2xsZWN0aW9ucy5PYmplY3RNb2RlbC5PYnNlcnZhYmxlQ29sbGVjdGlvbmAxK1NpbXBsZU1vbml0b3JbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0BAAAACl9idXN5Q291bnQACAIAAAAAAAAABAUAAAB+U3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuTGlzdGAxW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dAwAAAAZfaXRlbXMFX3NpemUIX3ZlcnNpb24HAAAICAgJBgAAAAUAAAAFAAAADwYAAAAIAAAACAEAAAACAAAAAwAAAAQAAAAFAAAAAAAAAAAAAAAAAAAACw==" } };
            yield return new object[] { new System.Collections.ObjectModel.ReadOnlyCollection<int>(Enumerable.Range(1, 15).ToList()), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAJ4BU3lzdGVtLkNvbGxlY3Rpb25zLk9iamVjdE1vZGVsLlJlYWRPbmx5Q29sbGVjdGlvbmAxW1tTeXN0ZW0uSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0BAAAABGxpc3QDjAFTeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5MaXN0YDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQkCAAAABAIAAACMAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLkxpc3RgMVtbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dAwAAAAZfaXRlbXMFX3NpemUIX3ZlcnNpb24HAAAICAgJAwAAAA8AAAAPAAAADwMAAAAPAAAACAEAAAACAAAAAwAAAAQAAAAFAAAABgAAAAcAAAAIAAAACQAAAAoAAAALAAAADAAAAA0AAAAOAAAADwAAAAs=", "AAEAAAD/////AQAAAAAAAAAEAQAAAJABU3lzdGVtLkNvbGxlY3Rpb25zLk9iamVjdE1vZGVsLlJlYWRPbmx5Q29sbGVjdGlvbmAxW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dAQAAAARsaXN0A35TeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYy5MaXN0YDFbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0JAgAAAAQCAAAAflN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLkxpc3RgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQMAAAAGX2l0ZW1zBV9zaXplCF92ZXJzaW9uBwAACAgICQMAAAAPAAAADwAAAA8DAAAAEAAAAAgBAAAAAgAAAAMAAAAEAAAABQAAAAYAAAAHAAAACAAAAAkAAAAKAAAACwAAAAwAAAANAAAADgAAAA8AAAAAAAAACw==" } };
            yield return new object[] { new System.Collections.ObjectModel.ReadOnlyDictionary<int, string>(dictionary), new string[] { "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", "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" } };

            var simpleKeyedCollection = new SimpleKeyedCollection
            {
                point
            };
            yield return new object[] { simpleKeyedCollection, new string[] { "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", "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" } };
            yield return new object[] { new System.Collections.ObjectModel.Collection<int>(Enumerable.Range(1, 20).ToList()), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAJYBU3lzdGVtLkNvbGxlY3Rpb25zLk9iamVjdE1vZGVsLkNvbGxlY3Rpb25gMVtbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dAQAAAAVpdGVtcwOMAVN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLkxpc3RgMVtbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dCQIAAAAEAgAAAIwBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuTGlzdGAxW1tTeXN0ZW0uSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0DAAAABl9pdGVtcwVfc2l6ZQhfdmVyc2lvbgcAAAgICAkDAAAAFAAAABQAAAAPAwAAABQAAAAIAQAAAAIAAAADAAAABAAAAAUAAAAGAAAABwAAAAgAAAAJAAAACgAAAAsAAAAMAAAADQAAAA4AAAAPAAAAEAAAABEAAAASAAAAEwAAABQAAAAL", "AAEAAAD/////AQAAAAAAAAAEAQAAAIgBU3lzdGVtLkNvbGxlY3Rpb25zLk9iamVjdE1vZGVsLkNvbGxlY3Rpb25gMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQEAAAAFaXRlbXMDflN5c3RlbS5Db2xsZWN0aW9ucy5HZW5lcmljLkxpc3RgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQkCAAAABAIAAAB+U3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuTGlzdGAxW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dAwAAAAZfaXRlbXMFX3NpemUIX3ZlcnNpb24HAAAICAgJAwAAABQAAAAUAAAADwMAAAAgAAAACAEAAAACAAAAAwAAAAQAAAAFAAAABgAAAAcAAAAIAAAACQAAAAoAAAALAAAADAAAAA0AAAAOAAAADwAAABAAAAARAAAAEgAAABMAAAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACw==" } };
            
            // Graph without cycles
            yield return new object[] { new Tree<int>(42, null, null), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAACfAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5UcmVlYDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQMAAAAWPFZhbHVlPmtfX0JhY2tpbmdGaWVsZBU8TGVmdD5rX19CYWNraW5nRmllbGQWPFJpZ2h0PmtfX0JhY2tpbmdGaWVsZAAEBAifAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5UcmVlYDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQIAAACfAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5UcmVlYDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQIAAAACAAAAKgAAAAoKCw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAACRAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5UcmVlYDFbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0DAAAAFjxWYWx1ZT5rX19CYWNraW5nRmllbGQVPExlZnQ+a19fQmFja2luZ0ZpZWxkFjxSaWdodD5rX19CYWNraW5nRmllbGQABAQIkQFTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuVHJlZWAxW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dAgAAAJEBU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlRyZWVgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQIAAAACAAAAKgAAAAoKCw==" } };
            yield return new object[] { new Tree<int>(1, new Tree<int>(2, new Tree<int>(3, null, null), null), null), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAACfAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5UcmVlYDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQMAAAAWPFZhbHVlPmtfX0JhY2tpbmdGaWVsZBU8TGVmdD5rX19CYWNraW5nRmllbGQWPFJpZ2h0PmtfX0JhY2tpbmdGaWVsZAAEBAifAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5UcmVlYDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQIAAACfAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5UcmVlYDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQIAAAACAAAAAQAAAAkDAAAACgEDAAAAAQAAAAIAAAAJBAAAAAoBBAAAAAEAAAADAAAACgoL", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAACRAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5UcmVlYDFbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0DAAAAFjxWYWx1ZT5rX19CYWNraW5nRmllbGQVPExlZnQ+a19fQmFja2luZ0ZpZWxkFjxSaWdodD5rX19CYWNraW5nRmllbGQABAQIkQFTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuVHJlZWAxW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dAgAAAJEBU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlRyZWVgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQIAAAACAAAAAQAAAAkDAAAACgEDAAAAAQAAAAIAAAAJBAAAAAoBBAAAAAEAAAADAAAACgoL" } };
            yield return new object[] { new Tree<Colors>(Colors.Red, null, new Tree<Colors>(Colors.Blue, null, new Tree<Colors>(Colors.Green, null, null))), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAADeAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5UcmVlYDFbW1N5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5Db2xvcnMsIFN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cywgVmVyc2lvbj00LjAuMy4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTlkNzdjYzdhZDM5YjY4ZWJdXQMAAAAWPFZhbHVlPmtfX0JhY2tpbmdGaWVsZBU8TGVmdD5rX19CYWNraW5nRmllbGQWPFJpZ2h0PmtfX0JhY2tpbmdGaWVsZAQEBDRTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuQ29sb3JzAgAAAN4BU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlRyZWVgMVtbU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLkNvbG9ycywgU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYl1dAgAAAN4BU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlRyZWVgMVtbU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLkNvbG9ycywgU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYl1dAgAAAAIAAAAF/f///zRTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuQ29sb3JzAQAAAAd2YWx1ZV9fAAgCAAAAAAAAAAoJBAAAAAEEAAAAAQAAAAH7/////f///wQAAAAKCQYAAAABBgAAAAEAAAAB+f////3///8DAAAACgoL", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAADeAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5UcmVlYDFbW1N5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5Db2xvcnMsIFN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cywgVmVyc2lvbj00LjAuMy4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTlkNzdjYzdhZDM5YjY4ZWJdXQMAAAAWPFZhbHVlPmtfX0JhY2tpbmdGaWVsZBU8TGVmdD5rX19CYWNraW5nRmllbGQWPFJpZ2h0PmtfX0JhY2tpbmdGaWVsZAQEBDRTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuQ29sb3JzAgAAAN4BU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlRyZWVgMVtbU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLkNvbG9ycywgU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYl1dAgAAAN4BU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlRyZWVgMVtbU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLkNvbG9ycywgU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYl1dAgAAAAIAAAAF/f///zRTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuQ29sb3JzAQAAAAd2YWx1ZV9fAAgCAAAAAAAAAAoJBAAAAAEEAAAAAQAAAAH7/////f///wQAAAAKCQYAAAABBgAAAAEAAAAB+f////3///8DAAAACgoL" } };
            yield return new object[] { new Tree<int>(1, new Tree<int>(2, new Tree<int>(3, null, null), new Tree<int>(4, null, null)), new Tree<int>(5, null, null)), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAACfAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5UcmVlYDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQMAAAAWPFZhbHVlPmtfX0JhY2tpbmdGaWVsZBU8TGVmdD5rX19CYWNraW5nRmllbGQWPFJpZ2h0PmtfX0JhY2tpbmdGaWVsZAAEBAifAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5UcmVlYDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQIAAACfAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5UcmVlYDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQIAAAACAAAAAQAAAAkDAAAACQQAAAABAwAAAAEAAAACAAAACQUAAAAJBgAAAAEEAAAAAQAAAAUAAAAKCgEFAAAAAQAAAAMAAAAKCgEGAAAAAQAAAAQAAAAKCgs=", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAACRAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5UcmVlYDFbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV0DAAAAFjxWYWx1ZT5rX19CYWNraW5nRmllbGQVPExlZnQ+a19fQmFja2luZ0ZpZWxkFjxSaWdodD5rX19CYWNraW5nRmllbGQABAQIkQFTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuVHJlZWAxW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dAgAAAJEBU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlRyZWVgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQIAAAACAAAAAQAAAAkDAAAACQQAAAABAwAAAAEAAAACAAAACQUAAAAJBgAAAAEEAAAAAQAAAAUAAAAKCgEFAAAAAQAAAAMAAAAKCgEGAAAAAQAAAAQAAAAKCgs=" } };

            // Graph with cycles
            {
               var a = new Graph<int> { Value = 1 };
               var b = new Graph<int> { Value = 2, Links = new[] { a } };
               var c = new Graph<int> { Value = 3, Links = new[] { a, b } };
               var d = new Graph<int> { Value = 3, Links = new[] { a, b, c } };
                a.Links = new[] { b, c, d }; // complete the cycle
                yield return new object[] { a, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAACgAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5HcmFwaGAxW1tTeXN0ZW0uSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0CAAAABVZhbHVlBUxpbmtzAAQIogFTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuR3JhcGhgMVtbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dW10CAAAAAgAAAAEAAAAJAwAAAAcDAAAAAAEAAAADAAAABKABU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLkdyYXBoYDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQIAAAAJBAAAAAkFAAAACQYAAAABBAAAAAEAAAACAAAACQcAAAABBQAAAAEAAAADAAAACQgAAAABBgAAAAEAAAADAAAACQkAAAAHBwAAAAABAAAAAQAAAASgAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5HcmFwaGAxW1tTeXN0ZW0uSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0CAAAACQEAAAAHCAAAAAABAAAAAgAAAASgAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5HcmFwaGAxW1tTeXN0ZW0uSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0CAAAACQEAAAAJBAAAAAcJAAAAAAEAAAADAAAABKABU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLkdyYXBoYDFbW1N5c3RlbS5JbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQIAAAAJAQAAAAkEAAAACQUAAAAL", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAACSAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5HcmFwaGAxW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dAgAAAAVWYWx1ZQVMaW5rcwAECJQBU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLkdyYXBoYDFbW1N5c3RlbS5JbnQzMiwgbXNjb3JsaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1iNzdhNWM1NjE5MzRlMDg5XV1bXQIAAAACAAAAAQAAAAkDAAAABwMAAAAAAQAAAAMAAAAEkgFTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuR3JhcGhgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQIAAAAJBAAAAAkFAAAACQYAAAABBAAAAAEAAAACAAAACQcAAAABBQAAAAEAAAADAAAACQgAAAABBgAAAAEAAAADAAAACQkAAAAHBwAAAAABAAAAAQAAAASSAVN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5HcmFwaGAxW1tTeXN0ZW0uSW50MzIsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4OV1dAgAAAAkBAAAABwgAAAAAAQAAAAIAAAAEkgFTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuR3JhcGhgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQIAAAAJAQAAAAkEAAAABwkAAAAAAQAAAAMAAAAEkgFTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuR3JhcGhgMVtbU3lzdGVtLkludDMyLCBtc2NvcmxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPWI3N2E1YzU2MTkzNGUwODldXQIAAAAJAQAAAAkEAAAACQUAAAAL" } };
            }


            // Structs
            yield return new object[] { new EmptyStruct(), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAAA5U3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLkVtcHR5U3RydWN0AAAAAAIAAAAL", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAAA5U3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLkVtcHR5U3RydWN0AAAAAAIAAAAL" } };
            yield return new object[] { new StructWithIntField { X = 42 }, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABAU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdFdpdGhJbnRGaWVsZAEAAAABWAAIAgAAACoAAAAL", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABAU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdFdpdGhJbnRGaWVsZAEAAAABWAAIAgAAACoAAAAL" } };
            yield return new object[] { new StructWithStringFields { String1 = "hello", String2 = "world" }, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABEU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdFdpdGhTdHJpbmdGaWVsZHMCAAAAB1N0cmluZzEHU3RyaW5nMgEBAgAAAAYDAAAABWhlbGxvBgQAAAAFd29ybGQL", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABEU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdFdpdGhTdHJpbmdGaWVsZHMCAAAAB1N0cmluZzEHU3RyaW5nMgEBAgAAAAYDAAAABWhlbGxvBgQAAAAFd29ybGQL" } };
            yield return new object[] { new StructContainingOtherStructs { Nested1 = new StructWithStringFields { String1 = "a", String2 = "b" }, Nested2 = new StructWithStringFields { String1 = "3", String2 = "4" } }, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABKU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdENvbnRhaW5pbmdPdGhlclN0cnVjdHMCAAAAB05lc3RlZDEHTmVzdGVkMgQERFN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5TdHJ1Y3RXaXRoU3RyaW5nRmllbGRzAgAAAERTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0V2l0aFN0cmluZ0ZpZWxkcwIAAAACAAAABf3///9EU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdFdpdGhTdHJpbmdGaWVsZHMCAAAAB1N0cmluZzEHU3RyaW5nMgEBAgAAAAYEAAAAAWEGBQAAAAFiAfr////9////BgcAAAABMwYIAAAAATQL", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABKU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdENvbnRhaW5pbmdPdGhlclN0cnVjdHMCAAAAB05lc3RlZDEHTmVzdGVkMgQERFN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5TdHJ1Y3RXaXRoU3RyaW5nRmllbGRzAgAAAERTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0V2l0aFN0cmluZ0ZpZWxkcwIAAAACAAAABf3///9EU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdFdpdGhTdHJpbmdGaWVsZHMCAAAAB1N0cmluZzEHU3RyaW5nMgEBAgAAAAYEAAAAAWEGBQAAAAFiAfr////9////BgcAAAABMwYIAAAAATQL" } };
            yield return new object[] { new StructContainingArraysOfOtherStructs(), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABSU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdENvbnRhaW5pbmdBcnJheXNPZk90aGVyU3RydWN0cwEAAAAGTmVzdGVkBExTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0Q29udGFpbmluZ090aGVyU3RydWN0c1tdAgAAAAIAAAAKCw==", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABSU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdENvbnRhaW5pbmdBcnJheXNPZk90aGVyU3RydWN0cwEAAAAGTmVzdGVkBExTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0Q29udGFpbmluZ090aGVyU3RydWN0c1tdAgAAAAIAAAAKCw==" } };
            yield return new object[] { new StructContainingArraysOfOtherStructs { Nested = new StructContainingOtherStructs[0] }, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABSU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdENvbnRhaW5pbmdBcnJheXNPZk90aGVyU3RydWN0cwEAAAAGTmVzdGVkBExTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0Q29udGFpbmluZ090aGVyU3RydWN0c1tdAgAAAAIAAAAJAwAAAAcDAAAAAAEAAAAAAAAABEpTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0Q29udGFpbmluZ090aGVyU3RydWN0cwIAAAAL", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABSU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdENvbnRhaW5pbmdBcnJheXNPZk90aGVyU3RydWN0cwEAAAAGTmVzdGVkBExTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0Q29udGFpbmluZ090aGVyU3RydWN0c1tdAgAAAAIAAAAJAwAAAAcDAAAAAAEAAAAAAAAABEpTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0Q29udGFpbmluZ090aGVyU3RydWN0cwIAAAAL" } };
            var s = new StructContainingArraysOfOtherStructs
            {
                Nested = new[]
                {
                    new StructContainingOtherStructs { Nested1 = new StructWithStringFields { String1 = "a", String2 = "b" }, Nested2 = new StructWithStringFields { String1 = "3", String2 = "4" } },
                    new StructContainingOtherStructs { Nested1 = new StructWithStringFields { String1 = "e", String2 = "f" }, Nested2 = new StructWithStringFields { String1 = "7", String2 = "8" } },
                }
            };
            yield return new object[] { s, new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABSU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdENvbnRhaW5pbmdBcnJheXNPZk90aGVyU3RydWN0cwEAAAAGTmVzdGVkBExTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0Q29udGFpbmluZ090aGVyU3RydWN0c1tdAgAAAAIAAAAJAwAAAAcDAAAAAAEAAAACAAAABEpTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0Q29udGFpbmluZ090aGVyU3RydWN0cwIAAAAF/P///0pTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0Q29udGFpbmluZ090aGVyU3RydWN0cwIAAAAHTmVzdGVkMQdOZXN0ZWQyBAREU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdFdpdGhTdHJpbmdGaWVsZHMCAAAARFN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5TdHJ1Y3RXaXRoU3RyaW5nRmllbGRzAgAAAAIAAAAF+////0RTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0V2l0aFN0cmluZ0ZpZWxkcwIAAAAHU3RyaW5nMQdTdHJpbmcyAQECAAAABgYAAAABYQYHAAAAAWIB+P////v///8GCQAAAAEzBgoAAAABNAH1/////P///wH0////+////wYNAAAAAWUGDgAAAAFmAfH////7////BhAAAAABNwYRAAAAATgL", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABSU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdENvbnRhaW5pbmdBcnJheXNPZk90aGVyU3RydWN0cwEAAAAGTmVzdGVkBExTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0Q29udGFpbmluZ090aGVyU3RydWN0c1tdAgAAAAIAAAAJAwAAAAcDAAAAAAEAAAACAAAABEpTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0Q29udGFpbmluZ090aGVyU3RydWN0cwIAAAAF/P///0pTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0Q29udGFpbmluZ090aGVyU3RydWN0cwIAAAAHTmVzdGVkMQdOZXN0ZWQyBAREU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdFdpdGhTdHJpbmdGaWVsZHMCAAAARFN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5TdHJ1Y3RXaXRoU3RyaW5nRmllbGRzAgAAAAIAAAAF+////0RTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0V2l0aFN0cmluZ0ZpZWxkcwIAAAAHU3RyaW5nMQdTdHJpbmcyAQECAAAABgYAAAABYQYHAAAAAWIB+P////v///8GCQAAAAEzBgoAAAABNAH1/////P///wH0////+////wYNAAAAAWUGDgAAAAFmAfH////7////BhAAAAABNwYRAAAAATgL" } };
            yield return new object[] { new object[] { s, new StructContainingArraysOfOtherStructs?(s) }, new string[] { "AAEAAAD/////AQAAAAAAAAAQAQAAAAIAAAAJAgAAAAkDAAAADAQAAABwU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYgUCAAAAUlN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5TdHJ1Y3RDb250YWluaW5nQXJyYXlzT2ZPdGhlclN0cnVjdHMBAAAABk5lc3RlZARMU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdENvbnRhaW5pbmdPdGhlclN0cnVjdHNbXQQAAAAEAAAACQUAAAABAwAAAAIAAAAJBQAAAAcFAAAAAAEAAAACAAAABEpTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0Q29udGFpbmluZ090aGVyU3RydWN0cwQAAAAF+v///0pTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0Q29udGFpbmluZ090aGVyU3RydWN0cwIAAAAHTmVzdGVkMQdOZXN0ZWQyBAREU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdFdpdGhTdHJpbmdGaWVsZHMEAAAARFN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5TdHJ1Y3RXaXRoU3RyaW5nRmllbGRzBAAAAAQAAAAF+f///0RTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0V2l0aFN0cmluZ0ZpZWxkcwIAAAAHU3RyaW5nMQdTdHJpbmcyAQEEAAAABggAAAABYQYJAAAAAWIB9v////n///8GCwAAAAEzBgwAAAABNAHz////+v///wHy////+f///wYPAAAAAWUGEAAAAAFmAe/////5////BhIAAAABNwYTAAAAATgL", "AAEAAAD/////AQAAAAAAAAAQAQAAAAIAAAAJAgAAAAkDAAAADAQAAABwU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYgUCAAAAUlN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5TdHJ1Y3RDb250YWluaW5nQXJyYXlzT2ZPdGhlclN0cnVjdHMBAAAABk5lc3RlZARMU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdENvbnRhaW5pbmdPdGhlclN0cnVjdHNbXQQAAAAEAAAACQUAAAABAwAAAAIAAAAJBQAAAAcFAAAAAAEAAAACAAAABEpTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0Q29udGFpbmluZ090aGVyU3RydWN0cwQAAAAF+v///0pTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0Q29udGFpbmluZ090aGVyU3RydWN0cwIAAAAHTmVzdGVkMQdOZXN0ZWQyBAREU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLlN0cnVjdFdpdGhTdHJpbmdGaWVsZHMEAAAARFN5c3RlbS5SdW50aW1lLlNlcmlhbGl6YXRpb24uRm9ybWF0dGVycy5UZXN0cy5TdHJ1Y3RXaXRoU3RyaW5nRmllbGRzBAAAAAQAAAAF+f///0RTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU3RydWN0V2l0aFN0cmluZ0ZpZWxkcwIAAAAHU3RyaW5nMQdTdHJpbmcyAQEEAAAABggAAAABYQYJAAAAAWIB9v////n///8GCwAAAAEzBgwAAAABNAHz////+v///wHy////+f///wYPAAAAAWUGEAAAAAFmAe/////5////BhIAAAABNwYTAAAAATgL" } };

            // ISerializable
            yield return new object[] { new BasicISerializableObject(1, "2"), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABGU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLkJhc2ljSVNlcmlhbGl6YWJsZU9iamVjdAIAAAAGVmFsdWUxBlZhbHVlMgABCAIAAAABAAAABgMAAAABMgs=", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABGU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLkJhc2ljSVNlcmlhbGl6YWJsZU9iamVjdAIAAAAGVmFsdWUxBlZhbHVlMgABCAIAAAABAAAABgMAAAABMgs=" } };
            yield return new object[] { new DerivedISerializableWithNonPublicDeserializationCtor(1, "2"), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABiU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLkRlcml2ZWRJU2VyaWFsaXphYmxlV2l0aE5vblB1YmxpY0Rlc2VyaWFsaXphdGlvbkN0b3ICAAAABlZhbHVlMQZWYWx1ZTIAAQgCAAAAAQAAAAYDAAAAATIL", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAABiU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLkRlcml2ZWRJU2VyaWFsaXphYmxlV2l0aE5vblB1YmxpY0Rlc2VyaWFsaXphdGlvbkN0b3ICAAAABlZhbHVlMQZWYWx1ZTIAAQgCAAAAAQAAAAYDAAAAATIL" } };

            // Various other special cases
            yield return new object[] { new TypeWithoutNamespace(), new string[] { "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAAAUVHlwZVdpdGhvdXROYW1lc3BhY2UAAAAAAgAAAAs=", "AAEAAAD/////AQAAAAAAAAAMAgAAAHBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViBQEAAAAUVHlwZVdpdGhvdXROYW1lc3BhY2UAAAAAAgAAAAs=" } };

            // Extension of core serializable types
            if (/*!PlatformDetection.IsNetfxBelow471()*/ !PlatformDetection.IsFullFramework)
            {
                // ValueType isn't serializable before ntfx471.
                yield return new object[] { new ValueTuple(), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAABFTeXN0ZW0uVmFsdWVUdXBsZQAAAAAL", "" } };
                yield return new object[] { ValueTuple.Create(1), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAH5TeXN0ZW0uVmFsdWVUdXBsZWAxW1tTeXN0ZW0uSW50MzIsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0BAAAABUl0ZW0xAAgBAAAACw==", "" } };
                yield return new object[] { ValueTuple.Create(1, "2"), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAOkBU3lzdGVtLlZhbHVlVHVwbGVgMltbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV0sW1N5c3RlbS5TdHJpbmcsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0CAAAABUl0ZW0xBUl0ZW0yAAEIAQAAAAYCAAAAATIL", "" } };
                yield return new object[] { ValueTuple.Create(1, "2", 3u), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAANQCU3lzdGVtLlZhbHVlVHVwbGVgM1tbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV0sW1N5c3RlbS5TdHJpbmcsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXSxbU3lzdGVtLlVJbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQMAAAAFSXRlbTEFSXRlbTIFSXRlbTMAAQAIDwEAAAAGAgAAAAEyAwAAAAs=", "" } };
                yield return new object[] { ValueTuple.Create(1, "2", 3u, 4L), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAL4DU3lzdGVtLlZhbHVlVHVwbGVgNFtbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV0sW1N5c3RlbS5TdHJpbmcsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXSxbU3lzdGVtLlVJbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdLFtTeXN0ZW0uSW50NjQsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXV0EAAAABUl0ZW0xBUl0ZW0yBUl0ZW0zBUl0ZW00AAEAAAgPCQEAAAAGAgAAAAEyAwAAAAQAAAAAAAAACw==", "" } };
                yield return new object[] { ValueTuple.Create(1, "2", 3u, 4L, 5.6), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAKkEU3lzdGVtLlZhbHVlVHVwbGVgNVtbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV0sW1N5c3RlbS5TdHJpbmcsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXSxbU3lzdGVtLlVJbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdLFtTeXN0ZW0uSW50NjQsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXSxbU3lzdGVtLkRvdWJsZSwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdXQUAAAAFSXRlbTEFSXRlbTIFSXRlbTMFSXRlbTQFSXRlbTUAAQAAAAgPCQYBAAAABgIAAAABMgMAAAAEAAAAAAAAAGZmZmZmZhZACw==", "" } };
                yield return new object[] { ValueTuple.Create(1, "2", 3u, 4L, 5.6, 7.8f), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAJQFU3lzdGVtLlZhbHVlVHVwbGVgNltbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV0sW1N5c3RlbS5TdHJpbmcsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXSxbU3lzdGVtLlVJbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdLFtTeXN0ZW0uSW50NjQsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXSxbU3lzdGVtLkRvdWJsZSwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdLFtTeXN0ZW0uU2luZ2xlLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dBgAAAAVJdGVtMQVJdGVtMgVJdGVtMwVJdGVtNAVJdGVtNQVJdGVtNgABAAAAAAgPCQYLAQAAAAYCAAAAATIDAAAABAAAAAAAAABmZmZmZmYWQJqZ+UAL", "" } };
                yield return new object[] { ValueTuple.Create(1, "2", 3u, 4L, 5.6, 7.8f, 9m), new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAIAGU3lzdGVtLlZhbHVlVHVwbGVgN1tbU3lzdGVtLkludDMyLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV0sW1N5c3RlbS5TdHJpbmcsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXSxbU3lzdGVtLlVJbnQzMiwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdLFtTeXN0ZW0uSW50NjQsIFN5c3RlbS5Qcml2YXRlLkNvcmVMaWIsIFZlcnNpb249NC4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj03Y2VjODVkN2JlYTc3OThlXSxbU3lzdGVtLkRvdWJsZSwgU3lzdGVtLlByaXZhdGUuQ29yZUxpYiwgVmVyc2lvbj00LjAuMC4wLCBDdWx0dXJlPW5ldXRyYWwsIFB1YmxpY0tleVRva2VuPTdjZWM4NWQ3YmVhNzc5OGVdLFtTeXN0ZW0uU2luZ2xlLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV0sW1N5c3RlbS5EZWNpbWFsLCBTeXN0ZW0uUHJpdmF0ZS5Db3JlTGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49N2NlYzg1ZDdiZWE3Nzk4ZV1dBwAAAAVJdGVtMQVJdGVtMgVJdGVtMwVJdGVtNAVJdGVtNQVJdGVtNgVJdGVtNwABAAAAAAAIDwkGCwUBAAAABgIAAAABMgMAAAAEAAAAAAAAAGZmZmZmZhZAmpn5QAE5Cw==", "" } };
                yield return new object[] { ValueTuple.Create(1, "2", 3u, 4L, 5.6, 7.8f, 9m, Tuple.Create(10)), new string[] { "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", "" } };
            }
        }

        public static IEnumerable<object[]> EqualityComparers()
        {
            // Internal specialized equality comparers
            yield return new object[] { EqualityComparer<UInt32Enum>.Default, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAOEBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuT2JqZWN0RXF1YWxpdHlDb21wYXJlcmAxW1tTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuVUludDMyRW51bSwgU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYl1dAAAAAAs=", "AAEAAAD/////AQAAAAAAAAAEAQAAANUBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuT2JqZWN0RXF1YWxpdHlDb21wYXJlcmAxW1tTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuVUludDMyRW51bSwgU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTEuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49bnVsbF1dAAAAAAs=" } };
            yield return new object[] { EqualityComparer<Int64Enum>.Default, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAOABU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuT2JqZWN0RXF1YWxpdHlDb21wYXJlcmAxW1tTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuSW50NjRFbnVtLCBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViXV0AAAAACw==", "AAEAAAD/////AQAAAAAAAAAEAQAAANQBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuT2JqZWN0RXF1YWxpdHlDb21wYXJlcmAxW1tTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuSW50NjRFbnVtLCBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249MS4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1udWxsXV0AAAAACw==" } };
            yield return new object[] { EqualityComparer<UInt64Enum>.Default, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAOEBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuT2JqZWN0RXF1YWxpdHlDb21wYXJlcmAxW1tTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuVUludDY0RW51bSwgU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTQuMC4zLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49OWQ3N2NjN2FkMzliNjhlYl1dAAAAAAs=", "AAEAAAD/////AQAAAAAAAAAEAQAAANUBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuT2JqZWN0RXF1YWxpdHlDb21wYXJlcmAxW1tTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuVUludDY0RW51bSwgU3lzdGVtLlJ1bnRpbWUuU2VyaWFsaXphdGlvbi5Gb3JtYXR0ZXJzLlRlc3RzLCBWZXJzaW9uPTEuMC4wLjAsIEN1bHR1cmU9bmV1dHJhbCwgUHVibGljS2V5VG9rZW49bnVsbF1dAAAAAAs=" } };
            yield return new object[] { EqualityComparer<SByteEnum>.Default, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAOABU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuT2JqZWN0RXF1YWxpdHlDb21wYXJlcmAxW1tTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU0J5dGVFbnVtLCBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViXV0AAAAACw==", "AAEAAAD/////AQAAAAAAAAAEAQAAANQBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuT2JqZWN0RXF1YWxpdHlDb21wYXJlcmAxW1tTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuU0J5dGVFbnVtLCBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249MS4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1udWxsXV0AAAAACw==" } };
            yield return new object[] { EqualityComparer<Int16Enum>.Default, new string[] { "AAEAAAD/////AQAAAAAAAAAEAQAAAOABU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuT2JqZWN0RXF1YWxpdHlDb21wYXJlcmAxW1tTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuSW50MTZFbnVtLCBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249NC4wLjMuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj05ZDc3Y2M3YWQzOWI2OGViXV0AAAAACw==", "AAEAAAD/////AQAAAAAAAAAEAQAAANQBU3lzdGVtLkNvbGxlY3Rpb25zLkdlbmVyaWMuT2JqZWN0RXF1YWxpdHlDb21wYXJlcmAxW1tTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMuSW50MTZFbnVtLCBTeXN0ZW0uUnVudGltZS5TZXJpYWxpemF0aW9uLkZvcm1hdHRlcnMuVGVzdHMsIFZlcnNpb249MS4wLjAuMCwgQ3VsdHVyZT1uZXV0cmFsLCBQdWJsaWNLZXlUb2tlbj1udWxsXV0AAAAACw==" } };
        }

        public static IEnumerable<object> NonSerializableObjects()
        {
            yield return new NonSerializableStruct();
            yield return new NonSerializableClass();
            yield return new SerializableClassWithBadField();
            yield return new object[] { 1, 2, 3, new NonSerializableClass() };
        }
    }
}
