---
layout: "downloads"
page_title: "Download Packer Community Projects"
sidebar_current: "downloads-community"
description: |-
  Packer has a vibrant community of contributors who have built a number of
  great tools on top of Packer. There are also quite a few projects
  demonstrating the power of Packer templates.
---

# Download Community Projects

Packer has a vibrant community of contributors who have built a number of great
tools on top of Packer. There are also quite a few projects demonstrating the
power of Packer templates.

## Templates

- [bento](https://github.com/chef/bento) - Packer templates for building minimal
  Vagrant base boxes

- [boxcutter](https://github.com/boxcutter) - Community-driven templates and
  tools for creating cloud, virtual machines, containers and metal operating
  system environments

- [packer-build](https://github.com/tylert/packer-build) - Build fresh Debian
  and Ubuntu virtual machine images for Vagrant, VirtualBox and QEMU

- [packer-windows](https://github.com/joefitzgerald/packer-windows) - Windows
  Packer Templates

- [packer-baseboxes](https://github.com/taliesins/packer-baseboxes) - Templates
  for packer to build base boxes

- [packer-ubuntu](https://github.com/cbednarski/packer-ubuntu) - Ubuntu LTS
  Virtual Machines for Vagrant

## Wrappers

- [packer-config](https://github.com/ianchesal/packer-config) - a Ruby model that lets you build Packer configurations in Ruby

- [racker](https://github.com/aspring/racker) - an opinionated Ruby DSL for generating Packer templates

## Other

- [suitcase](https://github.com/tmclaugh/suitcase) - Packer based build system for CentOS OS images

## Community Maintained Plugins

The following plugins (i.e. Builders, Provisioners, and Post-Processors) are
maintained by HashiCorp. Any plugins not on this list are maintained by the
community, and not actively contributed to by HashiCorp, although they are
still distributed with Packer.

### Builders

- Amazon EC2
- Azure
- Docker
- Google Cloud
- VMware
- VirtualBox

### Provisioners

- File
- PowerShell
- Shell
- Windows Restart
- Windows Shell

### Post-Processors

- Amazon Import
- Artifice
- Atlas
- Docker
- Local Shell
- Manifest
- Vagrant
- Vagrant Cloud
