// This file implements the IRemoteDebugApplicationEvents Interface and Gateway for Python.
// Generated by makegw.py

#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "PyIRemoteDebugApplicationEvents.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIRemoteDebugApplicationEvents::PyIRemoteDebugApplicationEvents(IUnknown *pdisp) : PyIUnknown(pdisp)
{
    ob_type = &type;
}

PyIRemoteDebugApplicationEvents::~PyIRemoteDebugApplicationEvents() {}

/* static */ IRemoteDebugApplicationEvents *PyIRemoteDebugApplicationEvents::GetI(PyObject *self)
{
    return (IRemoteDebugApplicationEvents *)PyIUnknown::GetI(self);
}

// @pymethod |PyIRemoteDebugApplicationEvents|OnConnectDebugger|Description of OnConnectDebugger.
PyObject *PyIRemoteDebugApplicationEvents::OnConnectDebugger(PyObject *self, PyObject *args)
{
    IRemoteDebugApplicationEvents *pIRDAE = GetI(self);
    if (pIRDAE == NULL)
        return NULL;
    // @pyparm <o PyIApplicationDebugger>|pad||Description for pad
    PyObject *obpad;
    IApplicationDebugger *pad;
    if (!PyArg_ParseTuple(args, "O:OnConnectDebugger", &obpad))
        return NULL;
    BOOL bPythonIsHappy = TRUE;
    if (!PyCom_InterfaceFromPyInstanceOrObject(obpad, IID_IApplicationDebugger, (void **)&pad, FALSE /* bNoneOK */))
        bPythonIsHappy = FALSE;
    if (!bPythonIsHappy)
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIRDAE->OnConnectDebugger(pad);
    pad->Release();
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return OleSetOleError(hr);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIRemoteDebugApplicationEvents|OnDisconnectDebugger|Description of OnDisconnectDebugger.
PyObject *PyIRemoteDebugApplicationEvents::OnDisconnectDebugger(PyObject *self, PyObject *args)
{
    IRemoteDebugApplicationEvents *pIRDAE = GetI(self);
    if (pIRDAE == NULL)
        return NULL;
    if (!PyArg_ParseTuple(args, ":OnDisconnectDebugger"))
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIRDAE->OnDisconnectDebugger();
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return OleSetOleError(hr);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIRemoteDebugApplicationEvents|OnSetName|Description of OnSetName.
PyObject *PyIRemoteDebugApplicationEvents::OnSetName(PyObject *self, PyObject *args)
{
    IRemoteDebugApplicationEvents *pIRDAE = GetI(self);
    if (pIRDAE == NULL)
        return NULL;
    // @pyparm <o unicode>|pstrName||Description for pstrName
    PyObject *obpstrName;
    BSTR pstrName;
    if (!PyArg_ParseTuple(args, "O:OnSetName", &obpstrName))
        return NULL;
    BOOL bPythonIsHappy = TRUE;
    if (!PyCom_BstrFromPyObject(obpstrName, &pstrName))
        bPythonIsHappy = FALSE;
    if (!bPythonIsHappy)
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIRDAE->OnSetName(pstrName);
    if (pstrName)
        SysFreeString(pstrName);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return OleSetOleError(hr);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIRemoteDebugApplicationEvents|OnDebugOutput|Description of OnDebugOutput.
PyObject *PyIRemoteDebugApplicationEvents::OnDebugOutput(PyObject *self, PyObject *args)
{
    IRemoteDebugApplicationEvents *pIRDAE = GetI(self);
    if (pIRDAE == NULL)
        return NULL;
    // @pyparm <o unicode>|pstr||Description for pstr
    PyObject *obpstr;
    BSTR pstr;
    if (!PyArg_ParseTuple(args, "O:OnDebugOutput", &obpstr))
        return NULL;
    BOOL bPythonIsHappy = TRUE;
    if (!PyCom_BstrFromPyObject(obpstr, &pstr))
        bPythonIsHappy = FALSE;
    if (!bPythonIsHappy)
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIRDAE->OnDebugOutput(pstr);
    if (pstr)
        SysFreeString(pstr);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return OleSetOleError(hr);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIRemoteDebugApplicationEvents|OnClose|Description of OnClose.
PyObject *PyIRemoteDebugApplicationEvents::OnClose(PyObject *self, PyObject *args)
{
    IRemoteDebugApplicationEvents *pIRDAE = GetI(self);
    if (pIRDAE == NULL)
        return NULL;
    if (!PyArg_ParseTuple(args, ":OnClose"))
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIRDAE->OnClose();
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return OleSetOleError(hr);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIRemoteDebugApplicationEvents|OnEnterBreakPoint|Description of OnEnterBreakPoint.
PyObject *PyIRemoteDebugApplicationEvents::OnEnterBreakPoint(PyObject *self, PyObject *args)
{
    IRemoteDebugApplicationEvents *pIRDAE = GetI(self);
    if (pIRDAE == NULL)
        return NULL;
    // @pyparm <o PyIRemoteDebugApplicationThread>|prdat||Description for prdat
    PyObject *obprdat;
    IRemoteDebugApplicationThread *prdat;
    if (!PyArg_ParseTuple(args, "O:OnEnterBreakPoint", &obprdat))
        return NULL;
    BOOL bPythonIsHappy = TRUE;
    if (!PyCom_InterfaceFromPyInstanceOrObject(obprdat, IID_IRemoteDebugApplicationThread, (void **)&prdat,
                                               FALSE /* bNoneOK */))
        bPythonIsHappy = FALSE;
    if (!bPythonIsHappy)
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIRDAE->OnEnterBreakPoint(prdat);
    prdat->Release();
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return OleSetOleError(hr);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIRemoteDebugApplicationEvents|OnLeaveBreakPoint|Description of OnLeaveBreakPoint.
PyObject *PyIRemoteDebugApplicationEvents::OnLeaveBreakPoint(PyObject *self, PyObject *args)
{
    IRemoteDebugApplicationEvents *pIRDAE = GetI(self);
    if (pIRDAE == NULL)
        return NULL;
    // @pyparm <o PyIRemoteDebugApplicationThread>|prdat||Description for prdat
    PyObject *obprdat;
    IRemoteDebugApplicationThread *prdat;
    if (!PyArg_ParseTuple(args, "O:OnLeaveBreakPoint", &obprdat))
        return NULL;
    BOOL bPythonIsHappy = TRUE;
    if (!PyCom_InterfaceFromPyInstanceOrObject(obprdat, IID_IRemoteDebugApplicationThread, (void **)&prdat,
                                               FALSE /* bNoneOK */))
        bPythonIsHappy = FALSE;
    if (!bPythonIsHappy)
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIRDAE->OnLeaveBreakPoint(prdat);
    prdat->Release();
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return OleSetOleError(hr);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIRemoteDebugApplicationEvents|OnCreateThread|Description of OnCreateThread.
PyObject *PyIRemoteDebugApplicationEvents::OnCreateThread(PyObject *self, PyObject *args)
{
    IRemoteDebugApplicationEvents *pIRDAE = GetI(self);
    if (pIRDAE == NULL)
        return NULL;
    // @pyparm <o PyIRemoteDebugApplicationThread>|prdat||Description for prdat
    PyObject *obprdat;
    IRemoteDebugApplicationThread *prdat;
    if (!PyArg_ParseTuple(args, "O:OnCreateThread", &obprdat))
        return NULL;
    BOOL bPythonIsHappy = TRUE;
    if (!PyCom_InterfaceFromPyInstanceOrObject(obprdat, IID_IRemoteDebugApplicationThread, (void **)&prdat,
                                               FALSE /* bNoneOK */))
        bPythonIsHappy = FALSE;
    if (!bPythonIsHappy)
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIRDAE->OnCreateThread(prdat);
    prdat->Release();
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return OleSetOleError(hr);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIRemoteDebugApplicationEvents|OnDestroyThread|Description of OnDestroyThread.
PyObject *PyIRemoteDebugApplicationEvents::OnDestroyThread(PyObject *self, PyObject *args)
{
    IRemoteDebugApplicationEvents *pIRDAE = GetI(self);
    if (pIRDAE == NULL)
        return NULL;
    // @pyparm <o PyIRemoteDebugApplicationThread>|prdat||Description for prdat
    PyObject *obprdat;
    IRemoteDebugApplicationThread *prdat;
    if (!PyArg_ParseTuple(args, "O:OnDestroyThread", &obprdat))
        return NULL;
    BOOL bPythonIsHappy = TRUE;
    if (!PyCom_InterfaceFromPyInstanceOrObject(obprdat, IID_IRemoteDebugApplicationThread, (void **)&prdat,
                                               FALSE /* bNoneOK */))
        bPythonIsHappy = FALSE;
    if (!bPythonIsHappy)
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIRDAE->OnDestroyThread(prdat);
    prdat->Release();
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return OleSetOleError(hr);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIRemoteDebugApplicationEvents|OnBreakFlagChange|Description of OnBreakFlagChange.
PyObject *PyIRemoteDebugApplicationEvents::OnBreakFlagChange(PyObject *self, PyObject *args)
{
    IRemoteDebugApplicationEvents *pIRDAE = GetI(self);
    if (pIRDAE == NULL)
        return NULL;
    // @pyparm int|abf||Description for abf
    // @pyparm <o PyIRemoteDebugApplicationThread>|prdatSteppingThread||Description for prdatSteppingThread
    PyObject *obprdatSteppingThread;
    APPBREAKFLAGS abf;
    IRemoteDebugApplicationThread *prdatSteppingThread;
    if (!PyArg_ParseTuple(args, "iO:OnBreakFlagChange", &abf, &obprdatSteppingThread))
        return NULL;
    BOOL bPythonIsHappy = TRUE;
    if (!PyCom_InterfaceFromPyInstanceOrObject(obprdatSteppingThread, IID_IRemoteDebugApplicationThread,
                                               (void **)&prdatSteppingThread, FALSE /* bNoneOK */))
        bPythonIsHappy = FALSE;
    if (!bPythonIsHappy)
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIRDAE->OnBreakFlagChange(abf, prdatSteppingThread);
    prdatSteppingThread->Release();
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return OleSetOleError(hr);
    Py_INCREF(Py_None);
    return Py_None;
}

// @object PyIRemoteDebugApplicationEvents|Description of the interface
static struct PyMethodDef PyIRemoteDebugApplicationEvents_methods[] = {
    {"OnConnectDebugger", PyIRemoteDebugApplicationEvents::OnConnectDebugger,
     1},  // @pymeth OnConnectDebugger|Description of OnConnectDebugger
    {"OnDisconnectDebugger", PyIRemoteDebugApplicationEvents::OnDisconnectDebugger,
     1},  // @pymeth OnDisconnectDebugger|Description of OnDisconnectDebugger
    {"OnSetName", PyIRemoteDebugApplicationEvents::OnSetName, 1},  // @pymeth OnSetName|Description of OnSetName
    {"OnDebugOutput", PyIRemoteDebugApplicationEvents::OnDebugOutput,
     1},                                                       // @pymeth OnDebugOutput|Description of OnDebugOutput
    {"OnClose", PyIRemoteDebugApplicationEvents::OnClose, 1},  // @pymeth OnClose|Description of OnClose
    {"OnEnterBreakPoint", PyIRemoteDebugApplicationEvents::OnEnterBreakPoint,
     1},  // @pymeth OnEnterBreakPoint|Description of OnEnterBreakPoint
    {"OnLeaveBreakPoint", PyIRemoteDebugApplicationEvents::OnLeaveBreakPoint,
     1},  // @pymeth OnLeaveBreakPoint|Description of OnLeaveBreakPoint
    {"OnCreateThread", PyIRemoteDebugApplicationEvents::OnCreateThread,
     1},  // @pymeth OnCreateThread|Description of OnCreateThread
    {"OnDestroyThread", PyIRemoteDebugApplicationEvents::OnDestroyThread,
     1},  // @pymeth OnDestroyThread|Description of OnDestroyThread
    {"OnBreakFlagChange", PyIRemoteDebugApplicationEvents::OnBreakFlagChange,
     1},  // @pymeth OnBreakFlagChange|Description of OnBreakFlagChange
    {NULL}};

PyComTypeObject PyIRemoteDebugApplicationEvents::type("PyIRemoteDebugApplicationEvents", &PyIUnknown::type,
                                                      sizeof(PyIRemoteDebugApplicationEvents),
                                                      PyIRemoteDebugApplicationEvents_methods,
                                                      GET_PYCOM_CTOR(PyIRemoteDebugApplicationEvents));
// ---------------------------------------------------
//
// Gateway Implementation

STDMETHODIMP PyGRemoteDebugApplicationEvents::OnConnectDebugger(
    /* [in] */ IApplicationDebugger __RPC_FAR *pad)
{
    PY_GATEWAY_METHOD;
    PyObject *obpad;
    obpad = PyCom_PyObjectFromIUnknown(pad, IID_IApplicationDebugger, TRUE);
    HRESULT hr = InvokeViaPolicy("OnConnectDebugger", NULL, "O", obpad);
    Py_XDECREF(obpad);
    return hr;
}

STDMETHODIMP PyGRemoteDebugApplicationEvents::OnDisconnectDebugger(void)
{
    PY_GATEWAY_METHOD;
    HRESULT hr = InvokeViaPolicy("OnDisconnectDebugger", NULL);
    return hr;
}

STDMETHODIMP PyGRemoteDebugApplicationEvents::OnSetName(
    /* [in] */ LPCOLESTR pstrName)
{
    PY_GATEWAY_METHOD;
    PyObject *obpstrName;
    obpstrName = PyWinObject_FromOLECHAR(pstrName);
    HRESULT hr = InvokeViaPolicy("OnSetName", NULL, "O", obpstrName);
    Py_XDECREF(obpstrName);
    return hr;
}

STDMETHODIMP PyGRemoteDebugApplicationEvents::OnDebugOutput(
    /* [in] */ LPCOLESTR pstr)
{
    PY_GATEWAY_METHOD;
    PyObject *obpstr;
    obpstr = PyWinObject_FromOLECHAR(pstr);
    HRESULT hr = InvokeViaPolicy("OnDebugOutput", NULL, "O", obpstr);
    Py_XDECREF(obpstr);
    return hr;
}

STDMETHODIMP PyGRemoteDebugApplicationEvents::OnClose(void)
{
    PY_GATEWAY_METHOD;
    HRESULT hr = InvokeViaPolicy("OnClose", NULL);
    return hr;
}

STDMETHODIMP PyGRemoteDebugApplicationEvents::OnEnterBreakPoint(
    /* [in] */ IRemoteDebugApplicationThread __RPC_FAR *prdat)
{
    PY_GATEWAY_METHOD;
    PyObject *obprdat;
    obprdat = PyCom_PyObjectFromIUnknown(prdat, IID_IRemoteDebugApplicationThread, TRUE);
    HRESULT hr = InvokeViaPolicy("OnEnterBreakPoint", NULL, "O", obprdat);
    Py_XDECREF(obprdat);
    return hr;
}

STDMETHODIMP PyGRemoteDebugApplicationEvents::OnLeaveBreakPoint(
    /* [in] */ IRemoteDebugApplicationThread __RPC_FAR *prdat)
{
    PY_GATEWAY_METHOD;
    PyObject *obprdat;
    obprdat = PyCom_PyObjectFromIUnknown(prdat, IID_IRemoteDebugApplicationThread, TRUE);
    HRESULT hr = InvokeViaPolicy("OnLeaveBreakPoint", NULL, "O", obprdat);
    Py_XDECREF(obprdat);
    return hr;
}

STDMETHODIMP PyGRemoteDebugApplicationEvents::OnCreateThread(
    /* [in] */ IRemoteDebugApplicationThread __RPC_FAR *prdat)
{
    PY_GATEWAY_METHOD;
    PyObject *obprdat;
    obprdat = PyCom_PyObjectFromIUnknown(prdat, IID_IRemoteDebugApplicationThread, TRUE);
    HRESULT hr = InvokeViaPolicy("OnCreateThread", NULL, "O", obprdat);
    Py_XDECREF(obprdat);
    return hr;
}

STDMETHODIMP PyGRemoteDebugApplicationEvents::OnDestroyThread(
    /* [in] */ IRemoteDebugApplicationThread __RPC_FAR *prdat)
{
    PY_GATEWAY_METHOD;
    PyObject *obprdat;
    obprdat = PyCom_PyObjectFromIUnknown(prdat, IID_IRemoteDebugApplicationThread, TRUE);
    HRESULT hr = InvokeViaPolicy("OnDestroyThread", NULL, "O", obprdat);
    Py_XDECREF(obprdat);
    return hr;
}

STDMETHODIMP PyGRemoteDebugApplicationEvents::OnBreakFlagChange(
    /* [in] */ APPBREAKFLAGS abf,
    /* [in] */ IRemoteDebugApplicationThread __RPC_FAR *prdatSteppingThread)
{
    PY_GATEWAY_METHOD;
    PyObject *obprdatSteppingThread;
    obprdatSteppingThread = PyCom_PyObjectFromIUnknown(prdatSteppingThread, IID_IRemoteDebugApplicationThread, TRUE);
    HRESULT hr = InvokeViaPolicy("OnBreakFlagChange", NULL, "iO", abf, obprdatSteppingThread);
    Py_XDECREF(obprdatSteppingThread);
    return hr;
}
