// This file implements the IPropertyChangeArray Interface and Gateway for Python.
// Generated by makegw.py

#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "propsys.h"
#include "PyIPropertyChangeArray.h"
#include "PyPROPVARIANT.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIPropertyChangeArray::PyIPropertyChangeArray(IUnknown *pdisp) : PyIUnknown(pdisp) { ob_type = &type; }

PyIPropertyChangeArray::~PyIPropertyChangeArray() {}

/* static */ IPropertyChangeArray *PyIPropertyChangeArray::GetI(PyObject *self)
{
    return (IPropertyChangeArray *)PyIUnknown::GetI(self);
}

// @pymethod int|PyIPropertyChangeArray|GetCount|Returns the number of changes in the array
PyObject *PyIPropertyChangeArray::GetCount(PyObject *self, PyObject *args)
{
    IPropertyChangeArray *pIPCA = GetI(self);
    if (pIPCA == NULL)
        return NULL;
    UINT cOperations;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIPCA->GetCount(&cOperations);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIPCA, IID_IPropertyChangeArray);
    return PyLong_FromUnsignedLong(cOperations);
}

// @pymethod <o PyIPropertyChange>|PyIPropertyChangeArray|GetAt|Retrieves a change by zero-based index
PyObject *PyIPropertyChangeArray::GetAt(PyObject *self, PyObject *args)
{
    IPropertyChangeArray *pIPCA = GetI(self);
    if (pIPCA == NULL)
        return NULL;
    // @pyparm int|Index||Index of the change to retrieve
    // @pyparm <o PyIID>|riid|IID_IPropertyChange|The interface to return
    IID riid = IID_IPropertyChange;
    void *ret;
    UINT Index;
    if (!PyArg_ParseTuple(args, "i|O&:GetAt", &Index, PyWinObject_AsIID, &riid))
        return NULL;

    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIPCA->GetAt(Index, riid, &ret);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIPCA, IID_IPropertyChangeArray);
    return PyCom_PyObjectFromIUnknown((IUnknown *)ret, riid);
}

// @pymethod |PyIPropertyChangeArray|InsertAt|Inserts a change at a specific position
PyObject *PyIPropertyChangeArray::InsertAt(PyObject *self, PyObject *args)
{
    IPropertyChangeArray *pIPCA = GetI(self);
    if (pIPCA == NULL)
        return NULL;
    // @pyparm int|Index||Position at which to place the change
    // @pyparm <o PyIPropertyChange>|PropChange||The change to be added
    UINT Index;
    IPropertyChange *pPropChange;
    PyObject *obPropChange;

    if (!PyArg_ParseTuple(args, "iO:InsertAt", &Index, &obPropChange))
        return NULL;
    if (!PyCom_InterfaceFromPyObject(obPropChange, IID_IPropertyChange, (void **)&pPropChange, FALSE))
        return NULL;

    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIPCA->InsertAt(Index, pPropChange);
    pPropChange->Release();
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIPCA, IID_IPropertyChangeArray);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIPropertyChangeArray|Append|Adds a change to the end of the array
PyObject *PyIPropertyChangeArray::Append(PyObject *self, PyObject *args)
{
    IPropertyChangeArray *pIPCA = GetI(self);
    if (pIPCA == NULL)
        return NULL;
    // @pyparm <o PyIPropertyChange>|PropChange||The change to be added
    IPropertyChange *pPropChange;
    PyObject *obPropChange;
    if (!PyArg_ParseTuple(args, "O:Append", &obPropChange))
        return NULL;
    if (!PyCom_InterfaceFromPyObject(obPropChange, IID_IPropertyChange, (void **)&pPropChange, FALSE))
        return NULL;

    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIPCA->Append(pPropChange);
    pPropChange->Release();
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIPCA, IID_IPropertyChangeArray);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIPropertyChangeArray|AppendOrReplace|Adds a change, or replaces if an identical property key is already
// in container
PyObject *PyIPropertyChangeArray::AppendOrReplace(PyObject *self, PyObject *args)
{
    IPropertyChangeArray *pIPCA = GetI(self);
    if (pIPCA == NULL)
        return NULL;
    // @pyparm <o PyIPropertyChange>|PropChange||The change to be added or replaced
    IPropertyChange *pPropChange;
    PyObject *obPropChange;
    if (!PyArg_ParseTuple(args, "O:Append", &obPropChange))
        return NULL;
    if (!PyCom_InterfaceFromPyObject(obPropChange, IID_IPropertyChange, (void **)&pPropChange, FALSE))
        return NULL;

    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIPCA->AppendOrReplace(pPropChange);
    pPropChange->Release();
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIPCA, IID_IPropertyChangeArray);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIPropertyChangeArray|RemoveAt|Removes a change from the array
PyObject *PyIPropertyChangeArray::RemoveAt(PyObject *self, PyObject *args)
{
    IPropertyChangeArray *pIPCA = GetI(self);
    if (pIPCA == NULL)
        return NULL;
    // @pyparm int|Index||Index of change to be removed
    UINT Index;
    if (!PyArg_ParseTuple(args, "k:RemoveAt", &Index))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIPCA->RemoveAt(Index);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIPCA, IID_IPropertyChangeArray);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod boolean|PyIPropertyChangeArray|IsKeyInArray|Checks if array contains a change to a property
PyObject *PyIPropertyChangeArray::IsKeyInArray(PyObject *self, PyObject *args)
{
    IPropertyChangeArray *pIPCA = GetI(self);
    if (pIPCA == NULL)
        return NULL;
    PROPERTYKEY key;
    // @pyparm <o PyPROPERTYKEY>|key||Property key to look for
    if (!PyArg_ParseTuple(args, "O&:IsKeyInArray", PyWinObject_AsPROPERTYKEY, &key))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIPCA->IsKeyInArray(key);
    PY_INTERFACE_POSTCALL;
    return PyBool_FromLong(hr == S_OK);
}

// @object PyIPropertyChangeArray|Container for a sequence of <o PyIPropertyChange> interfaces, as used with <o
// PyIFileOperation>. <nl>Create using pythoncom.CoCreateInstance(propsys.CLSID_PropertyChangeArray, ...)
static struct PyMethodDef PyIPropertyChangeArray_methods[] = {
    {"GetCount", PyIPropertyChangeArray::GetCount,
     METH_NOARGS},                                      // @pymeth GetCount|Returns the number of changes in the array
    {"GetAt", PyIPropertyChangeArray::GetAt, 1},        // @pymeth GetAt|Returns a change by zero-based index
    {"InsertAt", PyIPropertyChangeArray::InsertAt, 1},  // @pymeth InsertAt|Inserts a change at a specific position
    {"Append", PyIPropertyChangeArray::Append, 1},      // @pymeth Append|Adds a change to the end of the array
    {"AppendOrReplace", PyIPropertyChangeArray::AppendOrReplace,
     1},  // @pymeth AppendOrReplace|Adds a change, or replaces an identical property key
    {"RemoveAt", PyIPropertyChangeArray::RemoveAt, 1},  // @pymeth RemoveAt|Removes a change from the array
    {"IsKeyInArray", PyIPropertyChangeArray::IsKeyInArray,
     1},  // @pymeth IsKeyInArray|Checks if array contains a change to a property
    {NULL}};

PyComTypeObject PyIPropertyChangeArray::type("PyIPropertyChangeArray", &PyIUnknown::type,
                                             sizeof(PyIPropertyChangeArray), PyIPropertyChangeArray_methods,
                                             GET_PYCOM_CTOR(PyIPropertyChangeArray));
