// This file implements the IPropertyStoreCache Interface and Gateway for Python.
// Generated by makegw.py

#include "PyIPropertyStoreCache.h"
#include "PyPROPVARIANT.h"
// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIPropertyStoreCache::PyIPropertyStoreCache(IUnknown *pdisp) : PyIPropertyStore(pdisp) { ob_type = &type; }

PyIPropertyStoreCache::~PyIPropertyStoreCache() {}

/* static */ IPropertyStoreCache *PyIPropertyStoreCache::GetI(PyObject *self)
{
    return (IPropertyStoreCache *)PyIPropertyStore::GetI(self);
}

// @pymethod int|PyIPropertyStoreCache|GetState|Retrieves the current state of a property
// @rdesc A value from the PSC_STATE enum (PSC_NORMAL, PSC_NOTINSOURCE. PSC_DIRTY)
PyObject *PyIPropertyStoreCache::GetState(PyObject *self, PyObject *args)
{
    IPropertyStoreCache *pIPSC = GetI(self);
    if (pIPSC == NULL)
        return NULL;
    PROPERTYKEY key;
    // @pyparm <o PyPROPERTYKEY>|key||Property identifier
    PSC_STATE state;
    if (!PyArg_ParseTuple(args, "O&:GetState", PyWinObject_AsPROPERTYKEY, &key))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIPSC->GetState(key, &state);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIPSC, IID_IPropertyStoreCache);
    return PyInt_FromLong(state);
}

// @pymethod (<o PyPROPVARIANT>, int)|PyIPropertyStoreCache|GetValueAndState|Retrieves the current value and state of a
// property
PyObject *PyIPropertyStoreCache::GetValueAndState(PyObject *self, PyObject *args)
{
    IPropertyStoreCache *pIPSC = GetI(self);
    if (pIPSC == NULL)
        return NULL;
    PSC_STATE state;
    PROPERTYKEY key;
    PROPVARIANT val;
    // @pyparm <o PyPROPERTYKEY>|key||Property identifier
    if (!PyArg_ParseTuple(args, "O&:GetValueAndState", PyWinObject_AsPROPERTYKEY, &key))
        return NULL;

    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIPSC->GetValueAndState(key, &val, &state);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIPSC, IID_IPropertyStoreCache);
    return Py_BuildValue("NN", PyWinObject_FromPROPVARIANT(&val), PyInt_FromLong(state));
}

// @pymethod |PyIPropertyStoreCache|SetState|Sets the state of a property
PyObject *PyIPropertyStoreCache::SetState(PyObject *self, PyObject *args)
{
    IPropertyStoreCache *pIPSC = GetI(self);
    if (pIPSC == NULL)
        return NULL;
    // @pyparm <o PyPROPERTYKEY>|key||Property identifier
    // @pyparm int|state||Value from the PSC_STATE enum (pscon.PSC_*)
    PSC_STATE state;
    PROPERTYKEY key;
    if (!PyArg_ParseTuple(args, "O&i:SetState", PyWinObject_AsPROPERTYKEY, &key, &state))
        return NULL;

    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIPSC->SetState(key, state);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIPSC, IID_IPropertyStoreCache);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIPropertyStoreCache|SetValueAndState|Sets the value and state of a property
PyObject *PyIPropertyStoreCache::SetValueAndState(PyObject *self, PyObject *args)
{
    IPropertyStoreCache *pIPSC = GetI(self);
    if (pIPSC == NULL)
        return NULL;

    // @pyparm <o PyPROPERTYKEY>|key||Property identifier
    // @pyparm <o PyPROPVARIANT>|value||The new value
    // @pyparm int|state||The new state (pscon.PSC_*)
    PSC_STATE state;
    PROPERTYKEY key;
    PROPVARIANT *pval;
    if (!PyArg_ParseTuple(args, "O&O&i:SetValueAndState", PyWinObject_AsPROPERTYKEY, &key, PyWinObject_AsPROPVARIANT,
                          &pval, &state))
        return NULL;

    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIPSC->SetValueAndState(key, pval, state);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIPSC, IID_IPropertyStoreCache);
    Py_INCREF(Py_None);
    return Py_None;
}

// @object PyIPropertyStoreCache|Property store that allows tracking of modification state.  Inherits all methods of <o
// PyIPropertyStore>.
static struct PyMethodDef PyIPropertyStoreCache_methods[] = {
    {"GetState", PyIPropertyStoreCache::GetState, 1},  // @pymeth GetState|Retrieves the current state of a property
    {"GetValueAndState", PyIPropertyStoreCache::GetValueAndState,
     1},  // @pymeth GetValueAndState|Retrieves the current value and state of a property
    {"SetState", PyIPropertyStoreCache::SetState, 1},  // @pymeth SetState|Sets the state of a property
    {"SetValueAndState", PyIPropertyStoreCache::SetValueAndState,
     1},  // @pymeth SetValueAndState|Sets the value and state of a property
    {NULL}};

PyComTypeObject PyIPropertyStoreCache::type("PyIPropertyStoreCache", &PyIPropertyStore::type,
                                            sizeof(PyIPropertyStoreCache), PyIPropertyStoreCache_methods,
                                            GET_PYCOM_CTOR(PyIPropertyStoreCache));
