// This file implements the IEnumShellItems Interface and Gateway for Python.
// Generated by makegw.py

#include "shell_pch.h"
#include "PyIEnumShellItems.h"

// @doc - This file contains autoduck documentation

// ---------------------------------------------------
//
// Interface Implementation

PyIEnumShellItems::PyIEnumShellItems(IUnknown *pdisp) : PyIUnknown(pdisp) { ob_type = &type; }

PyIEnumShellItems::~PyIEnumShellItems() {}

/* static */ IEnumShellItems *PyIEnumShellItems::GetI(PyObject *self)
{
    return (IEnumShellItems *)PyIUnknown::GetI(self);
}

// @pymethod (<o PyIShellItem>,...)|PyIEnumShellItems|Next|Retrieves a specified number of items in the enumeration
// sequence.
PyObject *PyIEnumShellItems::Next(PyObject *self, PyObject *args)
{
    long celt = 1;
    // @pyparm int|num|1|Number of items to retrieve.
    if (!PyArg_ParseTuple(args, "|l:Next", &celt))
        return NULL;

    IEnumShellItems *pIEShellItems = GetI(self);
    if (pIEShellItems == NULL)
        return NULL;

    IShellItem **rgVar = new IShellItem *[celt];
    if (rgVar == NULL) {
        PyErr_SetString(PyExc_MemoryError, "allocating result ShellItemss");
        return NULL;
    }

    int i;
    /*	for ( i = celt; i--; )
            // *** possibly init each structure element???
    */

    ULONG celtFetched = 0;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIEShellItems->Next(celt, rgVar, &celtFetched);
    PY_INTERFACE_POSTCALL;
    if (HRESULT_CODE(hr) != ERROR_NO_MORE_ITEMS && FAILED(hr)) {
        delete[] rgVar;
        return PyCom_BuildPyException(hr, pIEShellItems, IID_IEnumShellItems);
    }

    PyObject *result = PyTuple_New(celtFetched);
    if (result != NULL) {
        for (i = celtFetched; i--;) {
            PyObject *ob = PyCom_PyObjectFromIUnknown(rgVar[i], IID_IShellItem, FALSE);
            // PyCom_PyObjectFromIUnknown always consumes the COM reference, so set the
            // pointer to NULL allowing any remaining interfaces to be released on error.
            rgVar[i] = NULL;
            if (ob == NULL) {
                Py_DECREF(result);
                result = NULL;
                break;
            }
            PyTuple_SET_ITEM(result, i, ob);
        }
    }

    // Release any remaining interfaces if conversion fails
    if (result == NULL) {
        PY_INTERFACE_PRECALL;
        for (i = celtFetched; i--;)
            if (rgVar[i])
                rgVar[i]->Release();
        PY_INTERFACE_POSTCALL;
    }
    delete[] rgVar;
    return result;
}

// @pymethod |PyIEnumShellItems|Skip|Skips over the next specified elementes.
PyObject *PyIEnumShellItems::Skip(PyObject *self, PyObject *args)
{
    long celt;
    if (!PyArg_ParseTuple(args, "l:Skip", &celt))
        return NULL;

    IEnumShellItems *pIEShellItems = GetI(self);
    if (pIEShellItems == NULL)
        return NULL;

    PY_INTERFACE_PRECALL;
    HRESULT hr = pIEShellItems->Skip(celt);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIEShellItems, IID_IEnumShellItems);

    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIEnumShellItems|Reset|Resets the enumeration sequence to the beginning.
PyObject *PyIEnumShellItems::Reset(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ":Reset"))
        return NULL;

    IEnumShellItems *pIEShellItems = GetI(self);
    if (pIEShellItems == NULL)
        return NULL;

    PY_INTERFACE_PRECALL;
    HRESULT hr = pIEShellItems->Reset();
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIEShellItems, IID_IEnumShellItems);

    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod <o PyIEnumShellItems>|PyIEnumShellItems|Clone|Creates another enumerator that contains the same enumeration
// state as the current one
PyObject *PyIEnumShellItems::Clone(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ":Clone"))
        return NULL;

    IEnumShellItems *pIEShellItems = GetI(self);
    if (pIEShellItems == NULL)
        return NULL;

    IEnumShellItems *pClone;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIEShellItems->Clone(&pClone);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIEShellItems, IID_IEnumShellItems);

    return PyCom_PyObjectFromIUnknown(pClone, IID_IEnumShellItems, FALSE);
}

// @object PyIEnumShellItems|A Python interface to IEnumShellItems
static struct PyMethodDef PyIEnumShellItems_methods[] = {
    {"Next", PyIEnumShellItems::Next,
     1},  // @pymeth Next|Retrieves a specified number of items in the enumeration sequence.
    {"Skip", PyIEnumShellItems::Skip, 1},    // @pymeth Skip|Skips over the next specified elementes.
    {"Reset", PyIEnumShellItems::Reset, 1},  // @pymeth Reset|Resets the enumeration sequence to the beginning.
    {"Clone", PyIEnumShellItems::Clone,
     1},  // @pymeth Clone|Creates another enumerator that contains the same enumeration state as the current one.
    {NULL}};

PyComEnumTypeObject PyIEnumShellItems::type("PyIEnumShellItems", &PyIUnknown::type, sizeof(PyIEnumShellItems),
                                            PyIEnumShellItems_methods, GET_PYCOM_CTOR(PyIEnumShellItems));

// ---------------------------------------------------
//
// Gateway Implementation
STDMETHODIMP PyGEnumShellItems::Next(
    /* [in] */ ULONG celt,
    /* [length_is][size_is][out] */ IShellItem __RPC_FAR *__RPC_FAR *rgVar,
    /* [out] */ ULONG __RPC_FAR *pCeltFetched)
{
    PY_GATEWAY_METHOD;
    PyObject *result;
    HRESULT hr = InvokeViaPolicy("Next", &result, "i", celt);
    if (FAILED(hr))
        return hr;

    if (!PySequence_Check(result))
        goto error;
    int len;
    len = PyObject_Length(result);
    if (len == -1)
        goto error;
    if (len > (int)celt)
        len = celt;

    if (pCeltFetched)
        *pCeltFetched = len;

    int i;
    for (i = 0; i < len; ++i) {
        PyObject *ob = PySequence_GetItem(result, i);
        if (ob == NULL)
            goto error;

        if (!PyCom_InterfaceFromPyObject(ob, IID_IShellItem, (void **)&rgVar[i], FALSE)) {
            Py_DECREF(result);
            return PyCom_SetCOMErrorFromPyException(IID_IEnumShellItems);
        }
    }

    Py_DECREF(result);

    return len < (int)celt ? S_FALSE : S_OK;

error:
    PyErr_Clear();  // just in case
    Py_DECREF(result);
    return PyCom_SetCOMErrorFromSimple(E_FAIL, IID_IEnumShellItems, "Next() did not return a sequence of objects");
}

STDMETHODIMP PyGEnumShellItems::Skip(
    /* [in] */ ULONG celt)
{
    PY_GATEWAY_METHOD;
    return InvokeViaPolicy("Skip", NULL, "i", celt);
}

STDMETHODIMP PyGEnumShellItems::Reset(void)
{
    PY_GATEWAY_METHOD;
    return InvokeViaPolicy("Reset");
}

STDMETHODIMP PyGEnumShellItems::Clone(
    /* [out] */ IEnumShellItems __RPC_FAR *__RPC_FAR *ppEnum)
{
    PY_GATEWAY_METHOD;
    PyObject *result;
    HRESULT hr = InvokeViaPolicy("Clone", &result);
    if (FAILED(hr))
        return hr;

    /*
    ** Make sure we have the right kind of object: we should have some kind
    ** of IUnknown subclass wrapped into a PyIUnknown instance.
    */
    if (!PyIBase::is_object(result, &PyIUnknown::type)) {
        /* the wrong kind of object was returned to us */
        Py_DECREF(result);
        return PyCom_SetCOMErrorFromSimple(E_FAIL, IID_IEnumShellItems);
    }

    /*
    ** Get the IUnknown out of the thing. note that the Python ob maintains
    ** a reference, so we don't have to explicitly AddRef() here.
    */
    IUnknown *punk = ((PyIUnknown *)result)->m_obj;
    if (!punk) {
        /* damn. the object was released. */
        Py_DECREF(result);
        return PyCom_SetCOMErrorFromSimple(E_FAIL, IID_IEnumShellItems);
    }

    /*
    ** Get the interface we want. note it is returned with a refcount.
    ** This QI is actually going to instantiate a PyGEnumShellItems.
    */
    hr = punk->QueryInterface(IID_IEnumShellItems, (LPVOID *)ppEnum);

    /* done with the result; this DECREF is also for <punk> */
    Py_DECREF(result);

    return PyCom_SetCOMErrorFromSimple(
        hr, IID_IEnumShellItems, "Python could not convert the result from Next() into the required COM interface");
}
