#! /usr/bin/env python
# Copyright (c) 2023 Predibase, Inc., 2020 Uber Technologies, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================

from abc import ABC, abstractmethod
from typing import Dict

import numpy as np


class Batcher(ABC):
    @abstractmethod
    def next_batch(self) -> Dict[str, np.ndarray]:
        raise NotImplementedError()

    @abstractmethod
    def last_batch(self) -> bool:
        raise NotImplementedError()

    @abstractmethod
    def set_epoch(self, epoch: int, batch_size: int):
        raise NotImplementedError()
