// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package cloudformation provides a client for AWS CloudFormation.
package cloudformation

import (
	"net/http"
	"time"

	"github.com/awslabs/aws-sdk-go/aws"
	"github.com/awslabs/aws-sdk-go/gen/endpoints"
)

import (
	"encoding/xml"
	"io"
)

// CloudFormation is a client for AWS CloudFormation.
type CloudFormation struct {
	client *aws.QueryClient
}

// New returns a new CloudFormation client.
func New(creds aws.CredentialsProvider, region string, client *http.Client) *CloudFormation {
	if client == nil {
		client = http.DefaultClient
	}

	endpoint, service, region := endpoints.Lookup("cloudformation", region)

	return &CloudFormation{
		client: &aws.QueryClient{
			Context: aws.Context{
				Credentials: creds,
				Service:     service,
				Region:      region,
			},
			Client:     client,
			Endpoint:   endpoint,
			APIVersion: "2010-05-15",
		},
	}
}

// CancelUpdateStack cancels an update on the specified stack. If the call
// completes successfully, the stack will roll back the update and revert
// to the previous stack configuration. Only stacks that are in the state
// can be canceled.
func (c *CloudFormation) CancelUpdateStack(req *CancelUpdateStackInput) (err error) {
	// NRE
	err = c.client.Do("CancelUpdateStack", "POST", "/", req, nil)
	return
}

// CreateStack creates a stack as specified in the template. After the call
// completes successfully, the stack creation starts. You can check the
// status of the stack via the DescribeStacks
func (c *CloudFormation) CreateStack(req *CreateStackInput) (resp *CreateStackResult, err error) {
	resp = &CreateStackResult{}
	err = c.client.Do("CreateStack", "POST", "/", req, resp)
	return
}

// DeleteStack deletes a specified stack. Once the call completes
// successfully, stack deletion starts. Deleted stacks do not show up in
// the DescribeStacks API if the deletion has been completed successfully.
func (c *CloudFormation) DeleteStack(req *DeleteStackInput) (err error) {
	// NRE
	err = c.client.Do("DeleteStack", "POST", "/", req, nil)
	return
}

// DescribeStackEvents returns all stack related events for a specified
// stack. For more information about a stack's event history, go to Stacks
// in the AWS CloudFormation User Guide. You can list events for stacks
// that have failed to create or have been deleted by specifying the unique
// stack identifier (stack
func (c *CloudFormation) DescribeStackEvents(req *DescribeStackEventsInput) (resp *DescribeStackEventsResult, err error) {
	resp = &DescribeStackEventsResult{}
	err = c.client.Do("DescribeStackEvents", "POST", "/", req, resp)
	return
}

// DescribeStackResource returns a description of the specified resource in
// the specified stack. For deleted stacks, DescribeStackResource returns
// resource information for up to 90 days after the stack has been deleted.
func (c *CloudFormation) DescribeStackResource(req *DescribeStackResourceInput) (resp *DescribeStackResourceResult, err error) {
	resp = &DescribeStackResourceResult{}
	err = c.client.Do("DescribeStackResource", "POST", "/", req, resp)
	return
}

// DescribeStackResources returns AWS resource descriptions for running and
// deleted stacks. If StackName is specified, all the associated resources
// that are part of the stack are returned. If PhysicalResourceId is
// specified, the associated resources of the stack that the resource
// belongs to are returned. Only the first 100 resources will be returned.
// If your stack has more resources than this, you should use
// ListStackResources instead. For deleted stacks, DescribeStackResources
// returns resource information for up to 90 days after the stack has been
// deleted. You must specify either StackName or PhysicalResourceId , but
// not both. In addition, you can specify LogicalResourceId to filter the
// returned result. For more information about resources, the
// LogicalResourceId and PhysicalResourceId , go to the AWS CloudFormation
// User Guide A ValidationError is returned if you specify both StackName
// and PhysicalResourceId in the same request.
func (c *CloudFormation) DescribeStackResources(req *DescribeStackResourcesInput) (resp *DescribeStackResourcesResult, err error) {
	resp = &DescribeStackResourcesResult{}
	err = c.client.Do("DescribeStackResources", "POST", "/", req, resp)
	return
}

// DescribeStacks returns the description for the specified stack; if no
// stack name was specified, then it returns the description for all the
// stacks created.
func (c *CloudFormation) DescribeStacks(req *DescribeStacksInput) (resp *DescribeStacksResult, err error) {
	resp = &DescribeStacksResult{}
	err = c.client.Do("DescribeStacks", "POST", "/", req, resp)
	return
}

// EstimateTemplateCost returns the estimated monthly cost of a template.
// The return value is an AWS Simple Monthly Calculator URL with a query
// string that describes the resources required to run the template.
func (c *CloudFormation) EstimateTemplateCost(req *EstimateTemplateCostInput) (resp *EstimateTemplateCostResult, err error) {
	resp = &EstimateTemplateCostResult{}
	err = c.client.Do("EstimateTemplateCost", "POST", "/", req, resp)
	return
}

// GetStackPolicy returns the stack policy for a specified stack. If a
// stack doesn't have a policy, a null value is returned.
func (c *CloudFormation) GetStackPolicy(req *GetStackPolicyInput) (resp *GetStackPolicyResult, err error) {
	resp = &GetStackPolicyResult{}
	err = c.client.Do("GetStackPolicy", "POST", "/", req, resp)
	return
}

// GetTemplate returns the template body for a specified stack. You can get
// the template for running or deleted stacks. For deleted stacks,
// GetTemplate returns the template for up to 90 days after the stack has
// been deleted. If the template does not exist, a ValidationError is
// returned.
func (c *CloudFormation) GetTemplate(req *GetTemplateInput) (resp *GetTemplateResult, err error) {
	resp = &GetTemplateResult{}
	err = c.client.Do("GetTemplate", "POST", "/", req, resp)
	return
}

// GetTemplateSummary returns information about a new or existing template.
// The GetTemplateSummary action is useful for viewing parameter
// information, such as default parameter values and parameter types,
// before you create or update a stack. You can use the GetTemplateSummary
// action when you submit a template, or you can get template information
// for a running or deleted stack. For deleted stacks, GetTemplateSummary
// returns the template information for up to 90 days after the stack has
// been deleted. If the template does not exist, a ValidationError is
// returned.
func (c *CloudFormation) GetTemplateSummary(req *GetTemplateSummaryInput) (resp *GetTemplateSummaryResult, err error) {
	resp = &GetTemplateSummaryResult{}
	err = c.client.Do("GetTemplateSummary", "POST", "/", req, resp)
	return
}

// ListStackResources returns descriptions of all resources of the
// specified stack. For deleted stacks, ListStackResources returns resource
// information for up to 90 days after the stack has been deleted.
func (c *CloudFormation) ListStackResources(req *ListStackResourcesInput) (resp *ListStackResourcesResult, err error) {
	resp = &ListStackResourcesResult{}
	err = c.client.Do("ListStackResources", "POST", "/", req, resp)
	return
}

// ListStacks returns the summary information for stacks whose status
// matches the specified StackStatusFilter. Summary information for stacks
// that have been deleted is kept for 90 days after the stack is deleted.
// If no StackStatusFilter is specified, summary information for all stacks
// is returned (including existing stacks and stacks that have been
// deleted).
func (c *CloudFormation) ListStacks(req *ListStacksInput) (resp *ListStacksResult, err error) {
	resp = &ListStacksResult{}
	err = c.client.Do("ListStacks", "POST", "/", req, resp)
	return
}

// SetStackPolicy is undocumented.
func (c *CloudFormation) SetStackPolicy(req *SetStackPolicyInput) (err error) {
	// NRE
	err = c.client.Do("SetStackPolicy", "POST", "/", req, nil)
	return
}

// SignalResource sends a signal to the specified resource with a success
// or failure status. You can use the SignalResource API in conjunction
// with a creation policy or update policy. AWS CloudFormation doesn't
// proceed with a stack creation or update until resources receive the
// required number of signals or the timeout period is exceeded. The
// SignalResource API is useful in cases where you want to send signals
// from anywhere other than an Amazon EC2 instance.
func (c *CloudFormation) SignalResource(req *SignalResourceInput) (err error) {
	// NRE
	err = c.client.Do("SignalResource", "POST", "/", req, nil)
	return
}

// UpdateStack updates a stack as specified in the template. After the call
// completes successfully, the stack update starts. You can check the
// status of the stack via the DescribeStacks action. To get a copy of the
// template for an existing stack, you can use the GetTemplate action. Tags
// that were associated with this stack during creation time will still be
// associated with the stack after an UpdateStack operation. For more
// information about creating an update template, updating a stack, and
// monitoring the progress of the update, see Updating a Stack
func (c *CloudFormation) UpdateStack(req *UpdateStackInput) (resp *UpdateStackResult, err error) {
	resp = &UpdateStackResult{}
	err = c.client.Do("UpdateStack", "POST", "/", req, resp)
	return
}

// ValidateTemplate is undocumented.
func (c *CloudFormation) ValidateTemplate(req *ValidateTemplateInput) (resp *ValidateTemplateResult, err error) {
	resp = &ValidateTemplateResult{}
	err = c.client.Do("ValidateTemplate", "POST", "/", req, resp)
	return
}

// CancelUpdateStackInput is undocumented.
type CancelUpdateStackInput struct {
	StackName aws.StringValue `query:"StackName" xml:"StackName"`
}

// Possible values for CloudFormation.
const (
	CapabilityCapabilityIAM = "CAPABILITY_IAM"
)

// CreateStackInput is undocumented.
type CreateStackInput struct {
	Capabilities     []string         `query:"Capabilities.member" xml:"Capabilities>member"`
	DisableRollback  aws.BooleanValue `query:"DisableRollback" xml:"DisableRollback"`
	NotificationARNs []string         `query:"NotificationARNs.member" xml:"NotificationARNs>member"`
	OnFailure        aws.StringValue  `query:"OnFailure" xml:"OnFailure"`
	Parameters       []Parameter      `query:"Parameters.member" xml:"Parameters>member"`
	StackName        aws.StringValue  `query:"StackName" xml:"StackName"`
	StackPolicyBody  aws.StringValue  `query:"StackPolicyBody" xml:"StackPolicyBody"`
	StackPolicyURL   aws.StringValue  `query:"StackPolicyURL" xml:"StackPolicyURL"`
	Tags             []Tag            `query:"Tags.member" xml:"Tags>member"`
	TemplateBody     aws.StringValue  `query:"TemplateBody" xml:"TemplateBody"`
	TemplateURL      aws.StringValue  `query:"TemplateURL" xml:"TemplateURL"`
	TimeoutInMinutes aws.IntegerValue `query:"TimeoutInMinutes" xml:"TimeoutInMinutes"`
}

// CreateStackOutput is undocumented.
type CreateStackOutput struct {
	StackID aws.StringValue `query:"StackId" xml:"CreateStackResult>StackId"`
}

// DeleteStackInput is undocumented.
type DeleteStackInput struct {
	StackName aws.StringValue `query:"StackName" xml:"StackName"`
}

// DescribeStackEventsInput is undocumented.
type DescribeStackEventsInput struct {
	NextToken aws.StringValue `query:"NextToken" xml:"NextToken"`
	StackName aws.StringValue `query:"StackName" xml:"StackName"`
}

// DescribeStackEventsOutput is undocumented.
type DescribeStackEventsOutput struct {
	NextToken   aws.StringValue `query:"NextToken" xml:"DescribeStackEventsResult>NextToken"`
	StackEvents []StackEvent    `query:"StackEvents.member" xml:"DescribeStackEventsResult>StackEvents>member"`
}

// DescribeStackResourceInput is undocumented.
type DescribeStackResourceInput struct {
	LogicalResourceID aws.StringValue `query:"LogicalResourceId" xml:"LogicalResourceId"`
	StackName         aws.StringValue `query:"StackName" xml:"StackName"`
}

// DescribeStackResourceOutput is undocumented.
type DescribeStackResourceOutput struct {
	StackResourceDetail *StackResourceDetail `query:"StackResourceDetail" xml:"DescribeStackResourceResult>StackResourceDetail"`
}

// DescribeStackResourcesInput is undocumented.
type DescribeStackResourcesInput struct {
	LogicalResourceID  aws.StringValue `query:"LogicalResourceId" xml:"LogicalResourceId"`
	PhysicalResourceID aws.StringValue `query:"PhysicalResourceId" xml:"PhysicalResourceId"`
	StackName          aws.StringValue `query:"StackName" xml:"StackName"`
}

// DescribeStackResourcesOutput is undocumented.
type DescribeStackResourcesOutput struct {
	StackResources []StackResource `query:"StackResources.member" xml:"DescribeStackResourcesResult>StackResources>member"`
}

// DescribeStacksInput is undocumented.
type DescribeStacksInput struct {
	NextToken aws.StringValue `query:"NextToken" xml:"NextToken"`
	StackName aws.StringValue `query:"StackName" xml:"StackName"`
}

// DescribeStacksOutput is undocumented.
type DescribeStacksOutput struct {
	NextToken aws.StringValue `query:"NextToken" xml:"DescribeStacksResult>NextToken"`
	Stacks    []Stack         `query:"Stacks.member" xml:"DescribeStacksResult>Stacks>member"`
}

// EstimateTemplateCostInput is undocumented.
type EstimateTemplateCostInput struct {
	Parameters   []Parameter     `query:"Parameters.member" xml:"Parameters>member"`
	TemplateBody aws.StringValue `query:"TemplateBody" xml:"TemplateBody"`
	TemplateURL  aws.StringValue `query:"TemplateURL" xml:"TemplateURL"`
}

// EstimateTemplateCostOutput is undocumented.
type EstimateTemplateCostOutput struct {
	URL aws.StringValue `query:"Url" xml:"EstimateTemplateCostResult>Url"`
}

// GetStackPolicyInput is undocumented.
type GetStackPolicyInput struct {
	StackName aws.StringValue `query:"StackName" xml:"StackName"`
}

// GetStackPolicyOutput is undocumented.
type GetStackPolicyOutput struct {
	StackPolicyBody aws.StringValue `query:"StackPolicyBody" xml:"GetStackPolicyResult>StackPolicyBody"`
}

// GetTemplateInput is undocumented.
type GetTemplateInput struct {
	StackName aws.StringValue `query:"StackName" xml:"StackName"`
}

// GetTemplateOutput is undocumented.
type GetTemplateOutput struct {
	TemplateBody aws.StringValue `query:"TemplateBody" xml:"GetTemplateResult>TemplateBody"`
}

// GetTemplateSummaryInput is undocumented.
type GetTemplateSummaryInput struct {
	StackName    aws.StringValue `query:"StackName" xml:"StackName"`
	TemplateBody aws.StringValue `query:"TemplateBody" xml:"TemplateBody"`
	TemplateURL  aws.StringValue `query:"TemplateURL" xml:"TemplateURL"`
}

// GetTemplateSummaryOutput is undocumented.
type GetTemplateSummaryOutput struct {
	Capabilities       []string               `query:"Capabilities.member" xml:"GetTemplateSummaryResult>Capabilities>member"`
	CapabilitiesReason aws.StringValue        `query:"CapabilitiesReason" xml:"GetTemplateSummaryResult>CapabilitiesReason"`
	Description        aws.StringValue        `query:"Description" xml:"GetTemplateSummaryResult>Description"`
	Parameters         []ParameterDeclaration `query:"Parameters.member" xml:"GetTemplateSummaryResult>Parameters>member"`
	Version            aws.StringValue        `query:"Version" xml:"GetTemplateSummaryResult>Version"`
}

// ListStackResourcesInput is undocumented.
type ListStackResourcesInput struct {
	NextToken aws.StringValue `query:"NextToken" xml:"NextToken"`
	StackName aws.StringValue `query:"StackName" xml:"StackName"`
}

// ListStackResourcesOutput is undocumented.
type ListStackResourcesOutput struct {
	NextToken              aws.StringValue        `query:"NextToken" xml:"ListStackResourcesResult>NextToken"`
	StackResourceSummaries []StackResourceSummary `query:"StackResourceSummaries.member" xml:"ListStackResourcesResult>StackResourceSummaries>member"`
}

// ListStacksInput is undocumented.
type ListStacksInput struct {
	NextToken         aws.StringValue `query:"NextToken" xml:"NextToken"`
	StackStatusFilter []string        `query:"StackStatusFilter.member" xml:"StackStatusFilter>member"`
}

// ListStacksOutput is undocumented.
type ListStacksOutput struct {
	NextToken      aws.StringValue `query:"NextToken" xml:"ListStacksResult>NextToken"`
	StackSummaries []StackSummary  `query:"StackSummaries.member" xml:"ListStacksResult>StackSummaries>member"`
}

// Possible values for CloudFormation.
const (
	OnFailureDelete    = "DELETE"
	OnFailureDoNothing = "DO_NOTHING"
	OnFailureRollback  = "ROLLBACK"
)

// Output is undocumented.
type Output struct {
	Description aws.StringValue `query:"Description" xml:"Description"`
	OutputKey   aws.StringValue `query:"OutputKey" xml:"OutputKey"`
	OutputValue aws.StringValue `query:"OutputValue" xml:"OutputValue"`
}

// Parameter is undocumented.
type Parameter struct {
	ParameterKey     aws.StringValue  `query:"ParameterKey" xml:"ParameterKey"`
	ParameterValue   aws.StringValue  `query:"ParameterValue" xml:"ParameterValue"`
	UsePreviousValue aws.BooleanValue `query:"UsePreviousValue" xml:"UsePreviousValue"`
}

// ParameterDeclaration is undocumented.
type ParameterDeclaration struct {
	DefaultValue  aws.StringValue  `query:"DefaultValue" xml:"DefaultValue"`
	Description   aws.StringValue  `query:"Description" xml:"Description"`
	NoEcho        aws.BooleanValue `query:"NoEcho" xml:"NoEcho"`
	ParameterKey  aws.StringValue  `query:"ParameterKey" xml:"ParameterKey"`
	ParameterType aws.StringValue  `query:"ParameterType" xml:"ParameterType"`
}

// Possible values for CloudFormation.
const (
	ResourceSignalStatusFailure = "FAILURE"
	ResourceSignalStatusSuccess = "SUCCESS"
)

// Possible values for CloudFormation.
const (
	ResourceStatusCreateComplete   = "CREATE_COMPLETE"
	ResourceStatusCreateFailed     = "CREATE_FAILED"
	ResourceStatusCreateInProgress = "CREATE_IN_PROGRESS"
	ResourceStatusDeleteComplete   = "DELETE_COMPLETE"
	ResourceStatusDeleteFailed     = "DELETE_FAILED"
	ResourceStatusDeleteInProgress = "DELETE_IN_PROGRESS"
	ResourceStatusDeleteSkipped    = "DELETE_SKIPPED"
	ResourceStatusUpdateComplete   = "UPDATE_COMPLETE"
	ResourceStatusUpdateFailed     = "UPDATE_FAILED"
	ResourceStatusUpdateInProgress = "UPDATE_IN_PROGRESS"
)

// SetStackPolicyInput is undocumented.
type SetStackPolicyInput struct {
	StackName       aws.StringValue `query:"StackName" xml:"StackName"`
	StackPolicyBody aws.StringValue `query:"StackPolicyBody" xml:"StackPolicyBody"`
	StackPolicyURL  aws.StringValue `query:"StackPolicyURL" xml:"StackPolicyURL"`
}

// SignalResourceInput is undocumented.
type SignalResourceInput struct {
	LogicalResourceID aws.StringValue `query:"LogicalResourceId" xml:"LogicalResourceId"`
	StackName         aws.StringValue `query:"StackName" xml:"StackName"`
	Status            aws.StringValue `query:"Status" xml:"Status"`
	UniqueID          aws.StringValue `query:"UniqueId" xml:"UniqueId"`
}

// Stack is undocumented.
type Stack struct {
	Capabilities      []string         `query:"Capabilities.member" xml:"Capabilities>member"`
	CreationTime      time.Time        `query:"CreationTime" xml:"CreationTime"`
	Description       aws.StringValue  `query:"Description" xml:"Description"`
	DisableRollback   aws.BooleanValue `query:"DisableRollback" xml:"DisableRollback"`
	LastUpdatedTime   time.Time        `query:"LastUpdatedTime" xml:"LastUpdatedTime"`
	NotificationARNs  []string         `query:"NotificationARNs.member" xml:"NotificationARNs>member"`
	Outputs           []Output         `query:"Outputs.member" xml:"Outputs>member"`
	Parameters        []Parameter      `query:"Parameters.member" xml:"Parameters>member"`
	StackID           aws.StringValue  `query:"StackId" xml:"StackId"`
	StackName         aws.StringValue  `query:"StackName" xml:"StackName"`
	StackStatus       aws.StringValue  `query:"StackStatus" xml:"StackStatus"`
	StackStatusReason aws.StringValue  `query:"StackStatusReason" xml:"StackStatusReason"`
	Tags              []Tag            `query:"Tags.member" xml:"Tags>member"`
	TimeoutInMinutes  aws.IntegerValue `query:"TimeoutInMinutes" xml:"TimeoutInMinutes"`
}

// StackEvent is undocumented.
type StackEvent struct {
	EventID              aws.StringValue `query:"EventId" xml:"EventId"`
	LogicalResourceID    aws.StringValue `query:"LogicalResourceId" xml:"LogicalResourceId"`
	PhysicalResourceID   aws.StringValue `query:"PhysicalResourceId" xml:"PhysicalResourceId"`
	ResourceProperties   aws.StringValue `query:"ResourceProperties" xml:"ResourceProperties"`
	ResourceStatus       aws.StringValue `query:"ResourceStatus" xml:"ResourceStatus"`
	ResourceStatusReason aws.StringValue `query:"ResourceStatusReason" xml:"ResourceStatusReason"`
	ResourceType         aws.StringValue `query:"ResourceType" xml:"ResourceType"`
	StackID              aws.StringValue `query:"StackId" xml:"StackId"`
	StackName            aws.StringValue `query:"StackName" xml:"StackName"`
	Timestamp            time.Time       `query:"Timestamp" xml:"Timestamp"`
}

// StackResource is undocumented.
type StackResource struct {
	Description          aws.StringValue `query:"Description" xml:"Description"`
	LogicalResourceID    aws.StringValue `query:"LogicalResourceId" xml:"LogicalResourceId"`
	PhysicalResourceID   aws.StringValue `query:"PhysicalResourceId" xml:"PhysicalResourceId"`
	ResourceStatus       aws.StringValue `query:"ResourceStatus" xml:"ResourceStatus"`
	ResourceStatusReason aws.StringValue `query:"ResourceStatusReason" xml:"ResourceStatusReason"`
	ResourceType         aws.StringValue `query:"ResourceType" xml:"ResourceType"`
	StackID              aws.StringValue `query:"StackId" xml:"StackId"`
	StackName            aws.StringValue `query:"StackName" xml:"StackName"`
	Timestamp            time.Time       `query:"Timestamp" xml:"Timestamp"`
}

// StackResourceDetail is undocumented.
type StackResourceDetail struct {
	Description          aws.StringValue `query:"Description" xml:"Description"`
	LastUpdatedTimestamp time.Time       `query:"LastUpdatedTimestamp" xml:"LastUpdatedTimestamp"`
	LogicalResourceID    aws.StringValue `query:"LogicalResourceId" xml:"LogicalResourceId"`
	Metadata             aws.StringValue `query:"Metadata" xml:"Metadata"`
	PhysicalResourceID   aws.StringValue `query:"PhysicalResourceId" xml:"PhysicalResourceId"`
	ResourceStatus       aws.StringValue `query:"ResourceStatus" xml:"ResourceStatus"`
	ResourceStatusReason aws.StringValue `query:"ResourceStatusReason" xml:"ResourceStatusReason"`
	ResourceType         aws.StringValue `query:"ResourceType" xml:"ResourceType"`
	StackID              aws.StringValue `query:"StackId" xml:"StackId"`
	StackName            aws.StringValue `query:"StackName" xml:"StackName"`
}

// StackResourceSummary is undocumented.
type StackResourceSummary struct {
	LastUpdatedTimestamp time.Time       `query:"LastUpdatedTimestamp" xml:"LastUpdatedTimestamp"`
	LogicalResourceID    aws.StringValue `query:"LogicalResourceId" xml:"LogicalResourceId"`
	PhysicalResourceID   aws.StringValue `query:"PhysicalResourceId" xml:"PhysicalResourceId"`
	ResourceStatus       aws.StringValue `query:"ResourceStatus" xml:"ResourceStatus"`
	ResourceStatusReason aws.StringValue `query:"ResourceStatusReason" xml:"ResourceStatusReason"`
	ResourceType         aws.StringValue `query:"ResourceType" xml:"ResourceType"`
}

// Possible values for CloudFormation.
const (
	StackStatusCreateComplete                          = "CREATE_COMPLETE"
	StackStatusCreateFailed                            = "CREATE_FAILED"
	StackStatusCreateInProgress                        = "CREATE_IN_PROGRESS"
	StackStatusDeleteComplete                          = "DELETE_COMPLETE"
	StackStatusDeleteFailed                            = "DELETE_FAILED"
	StackStatusDeleteInProgress                        = "DELETE_IN_PROGRESS"
	StackStatusRollbackComplete                        = "ROLLBACK_COMPLETE"
	StackStatusRollbackFailed                          = "ROLLBACK_FAILED"
	StackStatusRollbackInProgress                      = "ROLLBACK_IN_PROGRESS"
	StackStatusUpdateComplete                          = "UPDATE_COMPLETE"
	StackStatusUpdateCompleteCleanupInProgress         = "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS"
	StackStatusUpdateInProgress                        = "UPDATE_IN_PROGRESS"
	StackStatusUpdateRollbackComplete                  = "UPDATE_ROLLBACK_COMPLETE"
	StackStatusUpdateRollbackCompleteCleanupInProgress = "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS"
	StackStatusUpdateRollbackFailed                    = "UPDATE_ROLLBACK_FAILED"
	StackStatusUpdateRollbackInProgress                = "UPDATE_ROLLBACK_IN_PROGRESS"
)

// StackSummary is undocumented.
type StackSummary struct {
	CreationTime        time.Time       `query:"CreationTime" xml:"CreationTime"`
	DeletionTime        time.Time       `query:"DeletionTime" xml:"DeletionTime"`
	LastUpdatedTime     time.Time       `query:"LastUpdatedTime" xml:"LastUpdatedTime"`
	StackID             aws.StringValue `query:"StackId" xml:"StackId"`
	StackName           aws.StringValue `query:"StackName" xml:"StackName"`
	StackStatus         aws.StringValue `query:"StackStatus" xml:"StackStatus"`
	StackStatusReason   aws.StringValue `query:"StackStatusReason" xml:"StackStatusReason"`
	TemplateDescription aws.StringValue `query:"TemplateDescription" xml:"TemplateDescription"`
}

// Tag is undocumented.
type Tag struct {
	Key   aws.StringValue `query:"Key" xml:"Key"`
	Value aws.StringValue `query:"Value" xml:"Value"`
}

// TemplateParameter is undocumented.
type TemplateParameter struct {
	DefaultValue aws.StringValue  `query:"DefaultValue" xml:"DefaultValue"`
	Description  aws.StringValue  `query:"Description" xml:"Description"`
	NoEcho       aws.BooleanValue `query:"NoEcho" xml:"NoEcho"`
	ParameterKey aws.StringValue  `query:"ParameterKey" xml:"ParameterKey"`
}

// UpdateStackInput is undocumented.
type UpdateStackInput struct {
	Capabilities                []string         `query:"Capabilities.member" xml:"Capabilities>member"`
	NotificationARNs            []string         `query:"NotificationARNs.member" xml:"NotificationARNs>member"`
	Parameters                  []Parameter      `query:"Parameters.member" xml:"Parameters>member"`
	StackName                   aws.StringValue  `query:"StackName" xml:"StackName"`
	StackPolicyBody             aws.StringValue  `query:"StackPolicyBody" xml:"StackPolicyBody"`
	StackPolicyDuringUpdateBody aws.StringValue  `query:"StackPolicyDuringUpdateBody" xml:"StackPolicyDuringUpdateBody"`
	StackPolicyDuringUpdateURL  aws.StringValue  `query:"StackPolicyDuringUpdateURL" xml:"StackPolicyDuringUpdateURL"`
	StackPolicyURL              aws.StringValue  `query:"StackPolicyURL" xml:"StackPolicyURL"`
	TemplateBody                aws.StringValue  `query:"TemplateBody" xml:"TemplateBody"`
	TemplateURL                 aws.StringValue  `query:"TemplateURL" xml:"TemplateURL"`
	UsePreviousTemplate         aws.BooleanValue `query:"UsePreviousTemplate" xml:"UsePreviousTemplate"`
}

// UpdateStackOutput is undocumented.
type UpdateStackOutput struct {
	StackID aws.StringValue `query:"StackId" xml:"UpdateStackResult>StackId"`
}

// ValidateTemplateInput is undocumented.
type ValidateTemplateInput struct {
	TemplateBody aws.StringValue `query:"TemplateBody" xml:"TemplateBody"`
	TemplateURL  aws.StringValue `query:"TemplateURL" xml:"TemplateURL"`
}

// ValidateTemplateOutput is undocumented.
type ValidateTemplateOutput struct {
	Capabilities       []string            `query:"Capabilities.member" xml:"ValidateTemplateResult>Capabilities>member"`
	CapabilitiesReason aws.StringValue     `query:"CapabilitiesReason" xml:"ValidateTemplateResult>CapabilitiesReason"`
	Description        aws.StringValue     `query:"Description" xml:"ValidateTemplateResult>Description"`
	Parameters         []TemplateParameter `query:"Parameters.member" xml:"ValidateTemplateResult>Parameters>member"`
}

// CreateStackResult is a wrapper for CreateStackOutput.
type CreateStackResult struct {
	StackID aws.StringValue `query:"StackId" xml:"CreateStackResult>StackId"`
}

// DescribeStackEventsResult is a wrapper for DescribeStackEventsOutput.
type DescribeStackEventsResult struct {
	NextToken   aws.StringValue `query:"NextToken" xml:"DescribeStackEventsResult>NextToken"`
	StackEvents []StackEvent    `query:"StackEvents.member" xml:"DescribeStackEventsResult>StackEvents>member"`
}

// DescribeStackResourceResult is a wrapper for DescribeStackResourceOutput.
type DescribeStackResourceResult struct {
	StackResourceDetail *StackResourceDetail `query:"StackResourceDetail" xml:"DescribeStackResourceResult>StackResourceDetail"`
}

// DescribeStackResourcesResult is a wrapper for DescribeStackResourcesOutput.
type DescribeStackResourcesResult struct {
	StackResources []StackResource `query:"StackResources.member" xml:"DescribeStackResourcesResult>StackResources>member"`
}

// DescribeStacksResult is a wrapper for DescribeStacksOutput.
type DescribeStacksResult struct {
	NextToken aws.StringValue `query:"NextToken" xml:"DescribeStacksResult>NextToken"`
	Stacks    []Stack         `query:"Stacks.member" xml:"DescribeStacksResult>Stacks>member"`
}

// EstimateTemplateCostResult is a wrapper for EstimateTemplateCostOutput.
type EstimateTemplateCostResult struct {
	URL aws.StringValue `query:"Url" xml:"EstimateTemplateCostResult>Url"`
}

// GetStackPolicyResult is a wrapper for GetStackPolicyOutput.
type GetStackPolicyResult struct {
	StackPolicyBody aws.StringValue `query:"StackPolicyBody" xml:"GetStackPolicyResult>StackPolicyBody"`
}

// GetTemplateResult is a wrapper for GetTemplateOutput.
type GetTemplateResult struct {
	TemplateBody aws.StringValue `query:"TemplateBody" xml:"GetTemplateResult>TemplateBody"`
}

// GetTemplateSummaryResult is a wrapper for GetTemplateSummaryOutput.
type GetTemplateSummaryResult struct {
	Capabilities       []string               `query:"Capabilities.member" xml:"GetTemplateSummaryResult>Capabilities>member"`
	CapabilitiesReason aws.StringValue        `query:"CapabilitiesReason" xml:"GetTemplateSummaryResult>CapabilitiesReason"`
	Description        aws.StringValue        `query:"Description" xml:"GetTemplateSummaryResult>Description"`
	Parameters         []ParameterDeclaration `query:"Parameters.member" xml:"GetTemplateSummaryResult>Parameters>member"`
	Version            aws.StringValue        `query:"Version" xml:"GetTemplateSummaryResult>Version"`
}

// ListStackResourcesResult is a wrapper for ListStackResourcesOutput.
type ListStackResourcesResult struct {
	NextToken              aws.StringValue        `query:"NextToken" xml:"ListStackResourcesResult>NextToken"`
	StackResourceSummaries []StackResourceSummary `query:"StackResourceSummaries.member" xml:"ListStackResourcesResult>StackResourceSummaries>member"`
}

// ListStacksResult is a wrapper for ListStacksOutput.
type ListStacksResult struct {
	NextToken      aws.StringValue `query:"NextToken" xml:"ListStacksResult>NextToken"`
	StackSummaries []StackSummary  `query:"StackSummaries.member" xml:"ListStacksResult>StackSummaries>member"`
}

// UpdateStackResult is a wrapper for UpdateStackOutput.
type UpdateStackResult struct {
	StackID aws.StringValue `query:"StackId" xml:"UpdateStackResult>StackId"`
}

// ValidateTemplateResult is a wrapper for ValidateTemplateOutput.
type ValidateTemplateResult struct {
	Capabilities       []string            `query:"Capabilities.member" xml:"ValidateTemplateResult>Capabilities>member"`
	CapabilitiesReason aws.StringValue     `query:"CapabilitiesReason" xml:"ValidateTemplateResult>CapabilitiesReason"`
	Description        aws.StringValue     `query:"Description" xml:"ValidateTemplateResult>Description"`
	Parameters         []TemplateParameter `query:"Parameters.member" xml:"ValidateTemplateResult>Parameters>member"`
}

// avoid errors if the packages aren't referenced
var _ time.Time

var _ xml.Decoder
var _ = io.EOF
