// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package cloudhsm provides a client for Amazon CloudHSM.
package cloudhsm

import (
	"net/http"
	"time"

	"github.com/awslabs/aws-sdk-go/aws"
	"github.com/awslabs/aws-sdk-go/gen/endpoints"
)

// CloudHSM is a client for Amazon CloudHSM.
type CloudHSM struct {
	client *aws.JSONClient
}

// New returns a new CloudHSM client.
func New(creds aws.CredentialsProvider, region string, client *http.Client) *CloudHSM {
	if client == nil {
		client = http.DefaultClient
	}

	endpoint, service, region := endpoints.Lookup("cloudhsm", region)

	return &CloudHSM{
		client: &aws.JSONClient{
			Context: aws.Context{
				Credentials: creds,
				Service:     service,
				Region:      region,
			}, Client: client,
			Endpoint:     endpoint,
			JSONVersion:  "1.1",
			TargetPrefix: "CloudHsmFrontendService",
		},
	}
}

// CreateHapg creates a high-availability partition group. A
// high-availability partition group is a group of partitions that spans
// multiple physical HSMs.
func (c *CloudHSM) CreateHapg(req *CreateHapgRequest) (resp *CreateHapgResponse, err error) {
	resp = &CreateHapgResponse{}
	err = c.client.Do("CreateHapg", "POST", "/", req, resp)
	return
}

// CreateHSM creates an uninitialized HSM instance. Running this command
// provisions an HSM appliance and will result in charges to your AWS
// account for the
func (c *CloudHSM) CreateHSM(req *CreateHSMRequest) (resp *CreateHSMResponse, err error) {
	resp = &CreateHSMResponse{}
	err = c.client.Do("CreateHsm", "POST", "/", req, resp)
	return
}

// CreateLunaClient is undocumented.
func (c *CloudHSM) CreateLunaClient(req *CreateLunaClientRequest) (resp *CreateLunaClientResponse, err error) {
	resp = &CreateLunaClientResponse{}
	err = c.client.Do("CreateLunaClient", "POST", "/", req, resp)
	return
}

// DeleteHapg is undocumented.
func (c *CloudHSM) DeleteHapg(req *DeleteHapgRequest) (resp *DeleteHapgResponse, err error) {
	resp = &DeleteHapgResponse{}
	err = c.client.Do("DeleteHapg", "POST", "/", req, resp)
	return
}

// DeleteHSM deletes an Once complete, this operation cannot be undone and
// your key material cannot be recovered.
func (c *CloudHSM) DeleteHSM(req *DeleteHSMRequest) (resp *DeleteHSMResponse, err error) {
	resp = &DeleteHSMResponse{}
	err = c.client.Do("DeleteHsm", "POST", "/", req, resp)
	return
}

// DeleteLunaClient is undocumented.
func (c *CloudHSM) DeleteLunaClient(req *DeleteLunaClientRequest) (resp *DeleteLunaClientResponse, err error) {
	resp = &DeleteLunaClientResponse{}
	err = c.client.Do("DeleteLunaClient", "POST", "/", req, resp)
	return
}

// DescribeHapg retrieves information about a high-availability partition
// group.
func (c *CloudHSM) DescribeHapg(req *DescribeHapgRequest) (resp *DescribeHapgResponse, err error) {
	resp = &DescribeHapgResponse{}
	err = c.client.Do("DescribeHapg", "POST", "/", req, resp)
	return
}

// DescribeHSM retrieves information about an You can identify the HSM by
// its ARN or its serial number.
func (c *CloudHSM) DescribeHSM(req *DescribeHSMRequest) (resp *DescribeHSMResponse, err error) {
	resp = &DescribeHSMResponse{}
	err = c.client.Do("DescribeHsm", "POST", "/", req, resp)
	return
}

// DescribeLunaClient is undocumented.
func (c *CloudHSM) DescribeLunaClient(req *DescribeLunaClientRequest) (resp *DescribeLunaClientResponse, err error) {
	resp = &DescribeLunaClientResponse{}
	err = c.client.Do("DescribeLunaClient", "POST", "/", req, resp)
	return
}

// GetConfig gets the configuration files necessary to connect to all high
// availability partition groups the client is associated with.
func (c *CloudHSM) GetConfig(req *GetConfigRequest) (resp *GetConfigResponse, err error) {
	resp = &GetConfigResponse{}
	err = c.client.Do("GetConfig", "POST", "/", req, resp)
	return
}

// ListAvailableZones lists the Availability Zones that have available AWS
// CloudHSM capacity.
func (c *CloudHSM) ListAvailableZones(req *ListAvailableZonesRequest) (resp *ListAvailableZonesResponse, err error) {
	resp = &ListAvailableZonesResponse{}
	err = c.client.Do("ListAvailableZones", "POST", "/", req, resp)
	return
}

// ListHapgs lists the high-availability partition groups for the account.
// This operation supports pagination with the use of the NextToken member.
// If more results are available, the NextToken member of the response
// contains a token that you pass in the next call to ListHapgs to retrieve
// the next set of items.
func (c *CloudHSM) ListHapgs(req *ListHapgsRequest) (resp *ListHapgsResponse, err error) {
	resp = &ListHapgsResponse{}
	err = c.client.Do("ListHapgs", "POST", "/", req, resp)
	return
}

// ListHSMs retrieves the identifiers of all of the HSMs provisioned for
// the current customer. This operation supports pagination with the use of
// the NextToken member. If more results are available, the NextToken
// member of the response contains a token that you pass in the next call
// to ListHsms to retrieve the next set of items.
func (c *CloudHSM) ListHSMs(req *ListHSMsRequest) (resp *ListHSMsResponse, err error) {
	resp = &ListHSMsResponse{}
	err = c.client.Do("ListHsms", "POST", "/", req, resp)
	return
}

// ListLunaClients lists all of the clients. This operation supports
// pagination with the use of the NextToken member. If more results are
// available, the NextToken member of the response contains a token that
// you pass in the next call to ListLunaClients to retrieve the next set of
// items.
func (c *CloudHSM) ListLunaClients(req *ListLunaClientsRequest) (resp *ListLunaClientsResponse, err error) {
	resp = &ListLunaClientsResponse{}
	err = c.client.Do("ListLunaClients", "POST", "/", req, resp)
	return
}

// ModifyHapg modifies an existing high-availability partition group.
func (c *CloudHSM) ModifyHapg(req *ModifyHapgRequest) (resp *ModifyHapgResponse, err error) {
	resp = &ModifyHapgResponse{}
	err = c.client.Do("ModifyHapg", "POST", "/", req, resp)
	return
}

// ModifyHSM is undocumented.
func (c *CloudHSM) ModifyHSM(req *ModifyHSMRequest) (resp *ModifyHSMResponse, err error) {
	resp = &ModifyHSMResponse{}
	err = c.client.Do("ModifyHsm", "POST", "/", req, resp)
	return
}

// ModifyLunaClient modifies the certificate used by the client. This
// action can potentially start a workflow to install the new certificate
// on the client's HSMs.
func (c *CloudHSM) ModifyLunaClient(req *ModifyLunaClientRequest) (resp *ModifyLunaClientResponse, err error) {
	resp = &ModifyLunaClientResponse{}
	err = c.client.Do("ModifyLunaClient", "POST", "/", req, resp)
	return
}

// Possible values for CloudHSM.
const (
	ClientVersion51 = "5.1"
	ClientVersion53 = "5.3"
)

// Possible values for CloudHSM.
const (
	CloudHSMObjectStateDegraded = "DEGRADED"
	CloudHSMObjectStateReady    = "READY"
	CloudHSMObjectStateUpdating = "UPDATING"
)

// CreateHapgRequest is undocumented.
type CreateHapgRequest struct {
	Label aws.StringValue `json:"Label"`
}

// CreateHapgResponse is undocumented.
type CreateHapgResponse struct {
	HapgARN aws.StringValue `json:"HapgArn,omitempty"`
}

// CreateHSMRequest is undocumented.
type CreateHSMRequest struct {
	ClientToken      aws.StringValue `json:"ClientToken,omitempty"`
	EniIP            aws.StringValue `json:"EniIp,omitempty"`
	ExternalID       aws.StringValue `json:"ExternalId,omitempty"`
	IAMRoleARN       aws.StringValue `json:"IamRoleArn"`
	SSHKey           aws.StringValue `json:"SshKey"`
	SubnetID         aws.StringValue `json:"SubnetId"`
	SubscriptionType aws.StringValue `json:"SubscriptionType"`
	SyslogIP         aws.StringValue `json:"SyslogIp,omitempty"`
}

// CreateHSMResponse is undocumented.
type CreateHSMResponse struct {
	HSMARN aws.StringValue `json:"HsmArn,omitempty"`
}

// CreateLunaClientRequest is undocumented.
type CreateLunaClientRequest struct {
	Certificate aws.StringValue `json:"Certificate"`
	Label       aws.StringValue `json:"Label,omitempty"`
}

// CreateLunaClientResponse is undocumented.
type CreateLunaClientResponse struct {
	ClientARN aws.StringValue `json:"ClientArn,omitempty"`
}

// DeleteHapgRequest is undocumented.
type DeleteHapgRequest struct {
	HapgARN aws.StringValue `json:"HapgArn"`
}

// DeleteHapgResponse is undocumented.
type DeleteHapgResponse struct {
	Status aws.StringValue `json:"Status"`
}

// DeleteHSMRequest is undocumented.
type DeleteHSMRequest struct {
	HSMARN aws.StringValue `json:"HsmArn"`
}

// DeleteHSMResponse is undocumented.
type DeleteHSMResponse struct {
	Status aws.StringValue `json:"Status"`
}

// DeleteLunaClientRequest is undocumented.
type DeleteLunaClientRequest struct {
	ClientARN aws.StringValue `json:"ClientArn"`
}

// DeleteLunaClientResponse is undocumented.
type DeleteLunaClientResponse struct {
	Status aws.StringValue `json:"Status"`
}

// DescribeHapgRequest is undocumented.
type DescribeHapgRequest struct {
	HapgARN aws.StringValue `json:"HapgArn"`
}

// DescribeHapgResponse is undocumented.
type DescribeHapgResponse struct {
	HapgARN                 aws.StringValue `json:"HapgArn,omitempty"`
	HapgSerial              aws.StringValue `json:"HapgSerial,omitempty"`
	HSMsLastActionFailed    []string        `json:"HsmsLastActionFailed,omitempty"`
	HSMsPendingDeletion     []string        `json:"HsmsPendingDeletion,omitempty"`
	HSMsPendingRegistration []string        `json:"HsmsPendingRegistration,omitempty"`
	Label                   aws.StringValue `json:"Label,omitempty"`
	LastModifiedTimestamp   aws.StringValue `json:"LastModifiedTimestamp,omitempty"`
	PartitionSerialList     []string        `json:"PartitionSerialList,omitempty"`
	State                   aws.StringValue `json:"State,omitempty"`
}

// DescribeHSMRequest is undocumented.
type DescribeHSMRequest struct {
	HSMARN          aws.StringValue `json:"HsmArn,omitempty"`
	HSMSerialNumber aws.StringValue `json:"HsmSerialNumber,omitempty"`
}

// DescribeHSMResponse is undocumented.
type DescribeHSMResponse struct {
	AvailabilityZone      aws.StringValue `json:"AvailabilityZone,omitempty"`
	EniID                 aws.StringValue `json:"EniId,omitempty"`
	EniIP                 aws.StringValue `json:"EniIp,omitempty"`
	HSMARN                aws.StringValue `json:"HsmArn,omitempty"`
	HSMType               aws.StringValue `json:"HsmType,omitempty"`
	IAMRoleARN            aws.StringValue `json:"IamRoleArn,omitempty"`
	Partitions            []string        `json:"Partitions,omitempty"`
	SerialNumber          aws.StringValue `json:"SerialNumber,omitempty"`
	ServerCertLastUpdated aws.StringValue `json:"ServerCertLastUpdated,omitempty"`
	ServerCertURI         aws.StringValue `json:"ServerCertUri,omitempty"`
	SoftwareVersion       aws.StringValue `json:"SoftwareVersion,omitempty"`
	SSHKeyLastUpdated     aws.StringValue `json:"SshKeyLastUpdated,omitempty"`
	SSHPublicKey          aws.StringValue `json:"SshPublicKey,omitempty"`
	Status                aws.StringValue `json:"Status,omitempty"`
	StatusDetails         aws.StringValue `json:"StatusDetails,omitempty"`
	SubnetID              aws.StringValue `json:"SubnetId,omitempty"`
	SubscriptionEndDate   aws.StringValue `json:"SubscriptionEndDate,omitempty"`
	SubscriptionStartDate aws.StringValue `json:"SubscriptionStartDate,omitempty"`
	SubscriptionType      aws.StringValue `json:"SubscriptionType,omitempty"`
	VendorName            aws.StringValue `json:"VendorName,omitempty"`
	VPCID                 aws.StringValue `json:"VpcId,omitempty"`
}

// DescribeLunaClientRequest is undocumented.
type DescribeLunaClientRequest struct {
	CertificateFingerprint aws.StringValue `json:"CertificateFingerprint,omitempty"`
	ClientARN              aws.StringValue `json:"ClientArn,omitempty"`
}

// DescribeLunaClientResponse is undocumented.
type DescribeLunaClientResponse struct {
	Certificate            aws.StringValue `json:"Certificate,omitempty"`
	CertificateFingerprint aws.StringValue `json:"CertificateFingerprint,omitempty"`
	ClientARN              aws.StringValue `json:"ClientArn,omitempty"`
	Label                  aws.StringValue `json:"Label,omitempty"`
	LastModifiedTimestamp  aws.StringValue `json:"LastModifiedTimestamp,omitempty"`
}

// GetConfigRequest is undocumented.
type GetConfigRequest struct {
	ClientARN     aws.StringValue `json:"ClientArn"`
	ClientVersion aws.StringValue `json:"ClientVersion"`
	HapgList      []string        `json:"HapgList"`
}

// GetConfigResponse is undocumented.
type GetConfigResponse struct {
	ConfigCred aws.StringValue `json:"ConfigCred,omitempty"`
	ConfigFile aws.StringValue `json:"ConfigFile,omitempty"`
	ConfigType aws.StringValue `json:"ConfigType,omitempty"`
}

// Possible values for CloudHSM.
const (
	HSMStatusDegraded    = "DEGRADED"
	HSMStatusPending     = "PENDING"
	HSMStatusRunning     = "RUNNING"
	HSMStatusSuspended   = "SUSPENDED"
	HSMStatusTerminated  = "TERMINATED"
	HSMStatusTerminating = "TERMINATING"
	HSMStatusUpdating    = "UPDATING"
)

// ListAvailableZonesRequest is undocumented.
type ListAvailableZonesRequest struct {
}

// ListAvailableZonesResponse is undocumented.
type ListAvailableZonesResponse struct {
	AZList []string `json:"AZList,omitempty"`
}

// ListHapgsRequest is undocumented.
type ListHapgsRequest struct {
	NextToken aws.StringValue `json:"NextToken,omitempty"`
}

// ListHapgsResponse is undocumented.
type ListHapgsResponse struct {
	HapgList  []string        `json:"HapgList"`
	NextToken aws.StringValue `json:"NextToken,omitempty"`
}

// ListHSMsRequest is undocumented.
type ListHSMsRequest struct {
	NextToken aws.StringValue `json:"NextToken,omitempty"`
}

// ListHSMsResponse is undocumented.
type ListHSMsResponse struct {
	HSMList   []string        `json:"HsmList,omitempty"`
	NextToken aws.StringValue `json:"NextToken,omitempty"`
}

// ListLunaClientsRequest is undocumented.
type ListLunaClientsRequest struct {
	NextToken aws.StringValue `json:"NextToken,omitempty"`
}

// ListLunaClientsResponse is undocumented.
type ListLunaClientsResponse struct {
	ClientList []string        `json:"ClientList"`
	NextToken  aws.StringValue `json:"NextToken,omitempty"`
}

// ModifyHapgRequest is undocumented.
type ModifyHapgRequest struct {
	HapgARN             aws.StringValue `json:"HapgArn"`
	Label               aws.StringValue `json:"Label,omitempty"`
	PartitionSerialList []string        `json:"PartitionSerialList,omitempty"`
}

// ModifyHapgResponse is undocumented.
type ModifyHapgResponse struct {
	HapgARN aws.StringValue `json:"HapgArn,omitempty"`
}

// ModifyHSMRequest is undocumented.
type ModifyHSMRequest struct {
	EniIP      aws.StringValue `json:"EniIp,omitempty"`
	ExternalID aws.StringValue `json:"ExternalId,omitempty"`
	HSMARN     aws.StringValue `json:"HsmArn"`
	IAMRoleARN aws.StringValue `json:"IamRoleArn,omitempty"`
	SubnetID   aws.StringValue `json:"SubnetId,omitempty"`
	SyslogIP   aws.StringValue `json:"SyslogIp,omitempty"`
}

// ModifyHSMResponse is undocumented.
type ModifyHSMResponse struct {
	HSMARN aws.StringValue `json:"HsmArn,omitempty"`
}

// ModifyLunaClientRequest is undocumented.
type ModifyLunaClientRequest struct {
	Certificate aws.StringValue `json:"Certificate"`
	ClientARN   aws.StringValue `json:"ClientArn"`
}

// ModifyLunaClientResponse is undocumented.
type ModifyLunaClientResponse struct {
	ClientARN aws.StringValue `json:"ClientArn,omitempty"`
}

// Possible values for CloudHSM.
const (
	SubscriptionTypeProduction = "PRODUCTION"
)

// avoid errors if the packages aren't referenced
var _ time.Time
