// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package cloudsearch provides a client for Amazon CloudSearch.
package cloudsearch

import (
	"net/http"
	"time"

	"github.com/awslabs/aws-sdk-go/aws"
	"github.com/awslabs/aws-sdk-go/gen/endpoints"
)

import (
	"encoding/xml"
	"io"
)

// CloudSearch is a client for Amazon CloudSearch.
type CloudSearch struct {
	client *aws.QueryClient
}

// New returns a new CloudSearch client.
func New(creds aws.CredentialsProvider, region string, client *http.Client) *CloudSearch {
	if client == nil {
		client = http.DefaultClient
	}

	endpoint, service, region := endpoints.Lookup("cloudsearch", region)

	return &CloudSearch{
		client: &aws.QueryClient{
			Context: aws.Context{
				Credentials: creds,
				Service:     service,
				Region:      region,
			},
			Client:     client,
			Endpoint:   endpoint,
			APIVersion: "2013-01-01",
		},
	}
}

// BuildSuggesters indexes the search suggestions. For more information,
// see Configuring Suggesters in the Amazon CloudSearch Developer Guide
func (c *CloudSearch) BuildSuggesters(req *BuildSuggestersRequest) (resp *BuildSuggestersResult, err error) {
	resp = &BuildSuggestersResult{}
	err = c.client.Do("BuildSuggesters", "POST", "/", req, resp)
	return
}

// CreateDomain creates a new search domain. For more information, see
// Creating a Search Domain in the Amazon CloudSearch Developer Guide
func (c *CloudSearch) CreateDomain(req *CreateDomainRequest) (resp *CreateDomainResult, err error) {
	resp = &CreateDomainResult{}
	err = c.client.Do("CreateDomain", "POST", "/", req, resp)
	return
}

// DefineAnalysisScheme configures an analysis scheme that can be applied
// to a text or text-array field to define language-specific text
// processing options. For more information, see Configuring Analysis
// Schemes in the Amazon CloudSearch Developer Guide
func (c *CloudSearch) DefineAnalysisScheme(req *DefineAnalysisSchemeRequest) (resp *DefineAnalysisSchemeResult, err error) {
	resp = &DefineAnalysisSchemeResult{}
	err = c.client.Do("DefineAnalysisScheme", "POST", "/", req, resp)
	return
}

// DefineExpression configures an Expression for the search domain. Used to
// create new expressions and modify existing ones. If the expression
// exists, the new configuration replaces the old one. For more
// information, see Configuring Expressions in the Amazon CloudSearch
// Developer Guide
func (c *CloudSearch) DefineExpression(req *DefineExpressionRequest) (resp *DefineExpressionResult, err error) {
	resp = &DefineExpressionResult{}
	err = c.client.Do("DefineExpression", "POST", "/", req, resp)
	return
}

// DefineIndexField configures an IndexField for the search domain. Used to
// create new fields and modify existing ones. You must specify the name of
// the domain you are configuring and an index field configuration. The
// index field configuration specifies a unique name, the index field type,
// and the options you want to configure for the field. The options you can
// specify depend on the IndexFieldType . If the field exists, the new
// configuration replaces the old one. For more information, see
// Configuring Index Fields in the Amazon CloudSearch Developer Guide .
func (c *CloudSearch) DefineIndexField(req *DefineIndexFieldRequest) (resp *DefineIndexFieldResult, err error) {
	resp = &DefineIndexFieldResult{}
	err = c.client.Do("DefineIndexField", "POST", "/", req, resp)
	return
}

// DefineSuggester configures a suggester for a domain. A suggester enables
// you to display possible matches before users finish typing their
// queries. When you configure a suggester, you must specify the name of
// the text field you want to search for possible matches and a unique name
// for the suggester. For more information, see Getting Search Suggestions
// in the Amazon CloudSearch Developer Guide
func (c *CloudSearch) DefineSuggester(req *DefineSuggesterRequest) (resp *DefineSuggesterResult, err error) {
	resp = &DefineSuggesterResult{}
	err = c.client.Do("DefineSuggester", "POST", "/", req, resp)
	return
}

// DeleteAnalysisScheme deletes an analysis scheme. For more information,
// see Configuring Analysis Schemes in the Amazon CloudSearch Developer
// Guide .
func (c *CloudSearch) DeleteAnalysisScheme(req *DeleteAnalysisSchemeRequest) (resp *DeleteAnalysisSchemeResult, err error) {
	resp = &DeleteAnalysisSchemeResult{}
	err = c.client.Do("DeleteAnalysisScheme", "POST", "/", req, resp)
	return
}

// DeleteDomain permanently deletes a search domain and all of its data.
// Once a domain has been deleted, it cannot be recovered. For more
// information, see Deleting a Search Domain in the Amazon CloudSearch
// Developer Guide .
func (c *CloudSearch) DeleteDomain(req *DeleteDomainRequest) (resp *DeleteDomainResult, err error) {
	resp = &DeleteDomainResult{}
	err = c.client.Do("DeleteDomain", "POST", "/", req, resp)
	return
}

// DeleteExpression removes an Expression from the search domain. For more
// information, see Configuring Expressions in the Amazon CloudSearch
// Developer Guide
func (c *CloudSearch) DeleteExpression(req *DeleteExpressionRequest) (resp *DeleteExpressionResult, err error) {
	resp = &DeleteExpressionResult{}
	err = c.client.Do("DeleteExpression", "POST", "/", req, resp)
	return
}

// DeleteIndexField removes an IndexField from the search domain. For more
// information, see Configuring Index Fields in the Amazon CloudSearch
// Developer Guide
func (c *CloudSearch) DeleteIndexField(req *DeleteIndexFieldRequest) (resp *DeleteIndexFieldResult, err error) {
	resp = &DeleteIndexFieldResult{}
	err = c.client.Do("DeleteIndexField", "POST", "/", req, resp)
	return
}

// DeleteSuggester deletes a suggester. For more information, see Getting
// Search Suggestions in the Amazon CloudSearch Developer Guide
func (c *CloudSearch) DeleteSuggester(req *DeleteSuggesterRequest) (resp *DeleteSuggesterResult, err error) {
	resp = &DeleteSuggesterResult{}
	err = c.client.Do("DeleteSuggester", "POST", "/", req, resp)
	return
}

// DescribeAnalysisSchemes gets the analysis schemes configured for a
// domain. An analysis scheme defines language-specific text processing
// options for a text field. Can be limited to specific analysis schemes by
// name. By default, shows all analysis schemes and includes any pending
// changes to the configuration. Set the Deployed option to true to show
// the active configuration and exclude pending changes. For more
// information, see Configuring Analysis Schemes in the Amazon CloudSearch
// Developer Guide
func (c *CloudSearch) DescribeAnalysisSchemes(req *DescribeAnalysisSchemesRequest) (resp *DescribeAnalysisSchemesResult, err error) {
	resp = &DescribeAnalysisSchemesResult{}
	err = c.client.Do("DescribeAnalysisSchemes", "POST", "/", req, resp)
	return
}

// DescribeAvailabilityOptions gets the availability options configured for
// a domain. By default, shows the configuration with any pending changes.
// Set the Deployed option to true to show the active configuration and
// exclude pending changes. For more information, see Configuring
// Availability Options in the Amazon CloudSearch Developer Guide
func (c *CloudSearch) DescribeAvailabilityOptions(req *DescribeAvailabilityOptionsRequest) (resp *DescribeAvailabilityOptionsResult, err error) {
	resp = &DescribeAvailabilityOptionsResult{}
	err = c.client.Do("DescribeAvailabilityOptions", "POST", "/", req, resp)
	return
}

// DescribeDomains gets information about the search domains owned by this
// account. Can be limited to specific domains. Shows all domains by
// default. To get the number of searchable documents in a domain, use the
// console or submit a matchall request to your domain's search endpoint:
// q=matchall&q.parser=structured&size=0 . For more information, see
// Getting Information about a Search Domain in the Amazon CloudSearch
// Developer Guide
func (c *CloudSearch) DescribeDomains(req *DescribeDomainsRequest) (resp *DescribeDomainsResult, err error) {
	resp = &DescribeDomainsResult{}
	err = c.client.Do("DescribeDomains", "POST", "/", req, resp)
	return
}

// DescribeExpressions gets the expressions configured for the search
// domain. Can be limited to specific expressions by name. By default,
// shows all expressions and includes any pending changes to the
// configuration. Set the Deployed option to true to show the active
// configuration and exclude pending changes. For more information, see
// Configuring Expressions in the Amazon CloudSearch Developer Guide
func (c *CloudSearch) DescribeExpressions(req *DescribeExpressionsRequest) (resp *DescribeExpressionsResult, err error) {
	resp = &DescribeExpressionsResult{}
	err = c.client.Do("DescribeExpressions", "POST", "/", req, resp)
	return
}

// DescribeIndexFields gets information about the index fields configured
// for the search domain. Can be limited to specific fields by name. By
// default, shows all fields and includes any pending changes to the
// configuration. Set the Deployed option to true to show the active
// configuration and exclude pending changes. For more information, see
// Getting Domain Information in the Amazon CloudSearch Developer Guide
func (c *CloudSearch) DescribeIndexFields(req *DescribeIndexFieldsRequest) (resp *DescribeIndexFieldsResult, err error) {
	resp = &DescribeIndexFieldsResult{}
	err = c.client.Do("DescribeIndexFields", "POST", "/", req, resp)
	return
}

// DescribeScalingParameters gets the scaling parameters configured for a
// domain. A domain's scaling parameters specify the desired search
// instance type and replication count. For more information, see
// Configuring Scaling Options in the Amazon CloudSearch Developer Guide
func (c *CloudSearch) DescribeScalingParameters(req *DescribeScalingParametersRequest) (resp *DescribeScalingParametersResult, err error) {
	resp = &DescribeScalingParametersResult{}
	err = c.client.Do("DescribeScalingParameters", "POST", "/", req, resp)
	return
}

// DescribeServiceAccessPolicies gets information about the access policies
// that control access to the domain's document and search endpoints. By
// default, shows the configuration with any pending changes. Set the
// Deployed option to true to show the active configuration and exclude
// pending changes. For more information, see Configuring Access for a
// Search Domain in the Amazon CloudSearch Developer Guide
func (c *CloudSearch) DescribeServiceAccessPolicies(req *DescribeServiceAccessPoliciesRequest) (resp *DescribeServiceAccessPoliciesResult, err error) {
	resp = &DescribeServiceAccessPoliciesResult{}
	err = c.client.Do("DescribeServiceAccessPolicies", "POST", "/", req, resp)
	return
}

// DescribeSuggesters gets the suggesters configured for a domain. A
// suggester enables you to display possible matches before users finish
// typing their queries. Can be limited to specific suggesters by name. By
// default, shows all suggesters and includes any pending changes to the
// configuration. Set the Deployed option to true to show the active
// configuration and exclude pending changes. For more information, see
// Getting Search Suggestions in the Amazon CloudSearch Developer Guide
func (c *CloudSearch) DescribeSuggesters(req *DescribeSuggestersRequest) (resp *DescribeSuggestersResult, err error) {
	resp = &DescribeSuggestersResult{}
	err = c.client.Do("DescribeSuggesters", "POST", "/", req, resp)
	return
}

// IndexDocuments tells the search domain to start indexing its documents
// using the latest indexing options. This operation must be invoked to
// activate options whose OptionStatus is RequiresIndexDocuments
func (c *CloudSearch) IndexDocuments(req *IndexDocumentsRequest) (resp *IndexDocumentsResult, err error) {
	resp = &IndexDocumentsResult{}
	err = c.client.Do("IndexDocuments", "POST", "/", req, resp)
	return
}

// ListDomainNames is undocumented.
func (c *CloudSearch) ListDomainNames() (resp *ListDomainNamesResult, err error) {
	resp = &ListDomainNamesResult{}
	err = c.client.Do("ListDomainNames", "POST", "/", nil, resp)
	return
}

// UpdateAvailabilityOptions configures the availability options for a
// domain. Enabling the Multi-AZ option expands an Amazon CloudSearch
// domain to an additional Availability Zone in the same Region to increase
// fault tolerance in the event of a service disruption. Changes to the
// Multi-AZ option can take about half an hour to become active. For more
// information, see Configuring Availability Options in the Amazon
// CloudSearch Developer Guide
func (c *CloudSearch) UpdateAvailabilityOptions(req *UpdateAvailabilityOptionsRequest) (resp *UpdateAvailabilityOptionsResult, err error) {
	resp = &UpdateAvailabilityOptionsResult{}
	err = c.client.Do("UpdateAvailabilityOptions", "POST", "/", req, resp)
	return
}

// UpdateScalingParameters configures scaling parameters for a domain. A
// domain's scaling parameters specify the desired search instance type and
// replication count. Amazon CloudSearch will still automatically scale
// your domain based on the volume of data and traffic, but not below the
// desired instance type and replication count. If the Multi-AZ option is
// enabled, these values control the resources used per Availability Zone.
// For more information, see Configuring Scaling Options in the Amazon
// CloudSearch Developer Guide .
func (c *CloudSearch) UpdateScalingParameters(req *UpdateScalingParametersRequest) (resp *UpdateScalingParametersResult, err error) {
	resp = &UpdateScalingParametersResult{}
	err = c.client.Do("UpdateScalingParameters", "POST", "/", req, resp)
	return
}

// UpdateServiceAccessPolicies configures the access rules that control
// access to the domain's document and search endpoints. For more
// information, see Configuring Access for an Amazon CloudSearch Domain
func (c *CloudSearch) UpdateServiceAccessPolicies(req *UpdateServiceAccessPoliciesRequest) (resp *UpdateServiceAccessPoliciesResult, err error) {
	resp = &UpdateServiceAccessPoliciesResult{}
	err = c.client.Do("UpdateServiceAccessPolicies", "POST", "/", req, resp)
	return
}

// AccessPoliciesStatus is undocumented.
type AccessPoliciesStatus struct {
	Options aws.StringValue `query:"Options" xml:"Options"`
	Status  *OptionStatus   `query:"Status" xml:"Status"`
}

// Possible values for CloudSearch.
const (
	AlgorithmicStemmingFull    = "full"
	AlgorithmicStemmingLight   = "light"
	AlgorithmicStemmingMinimal = "minimal"
	AlgorithmicStemmingNone    = "none"
)

// AnalysisOptions is undocumented.
type AnalysisOptions struct {
	AlgorithmicStemming            aws.StringValue `query:"AlgorithmicStemming" xml:"AlgorithmicStemming"`
	JapaneseTokenizationDictionary aws.StringValue `query:"JapaneseTokenizationDictionary" xml:"JapaneseTokenizationDictionary"`
	StemmingDictionary             aws.StringValue `query:"StemmingDictionary" xml:"StemmingDictionary"`
	Stopwords                      aws.StringValue `query:"Stopwords" xml:"Stopwords"`
	Synonyms                       aws.StringValue `query:"Synonyms" xml:"Synonyms"`
}

// AnalysisScheme is undocumented.
type AnalysisScheme struct {
	AnalysisOptions        *AnalysisOptions `query:"AnalysisOptions" xml:"AnalysisOptions"`
	AnalysisSchemeLanguage aws.StringValue  `query:"AnalysisSchemeLanguage" xml:"AnalysisSchemeLanguage"`
	AnalysisSchemeName     aws.StringValue  `query:"AnalysisSchemeName" xml:"AnalysisSchemeName"`
}

// Possible values for CloudSearch.
const (
	AnalysisSchemeLanguageAr     = "ar"
	AnalysisSchemeLanguageBg     = "bg"
	AnalysisSchemeLanguageCa     = "ca"
	AnalysisSchemeLanguageCs     = "cs"
	AnalysisSchemeLanguageDa     = "da"
	AnalysisSchemeLanguageDe     = "de"
	AnalysisSchemeLanguageEl     = "el"
	AnalysisSchemeLanguageEn     = "en"
	AnalysisSchemeLanguageEs     = "es"
	AnalysisSchemeLanguageEu     = "eu"
	AnalysisSchemeLanguageFa     = "fa"
	AnalysisSchemeLanguageFi     = "fi"
	AnalysisSchemeLanguageFr     = "fr"
	AnalysisSchemeLanguageGa     = "ga"
	AnalysisSchemeLanguageGl     = "gl"
	AnalysisSchemeLanguageHe     = "he"
	AnalysisSchemeLanguageHi     = "hi"
	AnalysisSchemeLanguageHu     = "hu"
	AnalysisSchemeLanguageHy     = "hy"
	AnalysisSchemeLanguageID     = "id"
	AnalysisSchemeLanguageIt     = "it"
	AnalysisSchemeLanguageJa     = "ja"
	AnalysisSchemeLanguageKo     = "ko"
	AnalysisSchemeLanguageLv     = "lv"
	AnalysisSchemeLanguageMul    = "mul"
	AnalysisSchemeLanguageNl     = "nl"
	AnalysisSchemeLanguageNo     = "no"
	AnalysisSchemeLanguagePt     = "pt"
	AnalysisSchemeLanguageRo     = "ro"
	AnalysisSchemeLanguageRu     = "ru"
	AnalysisSchemeLanguageSv     = "sv"
	AnalysisSchemeLanguageTh     = "th"
	AnalysisSchemeLanguageTr     = "tr"
	AnalysisSchemeLanguageZhHans = "zh-Hans"
	AnalysisSchemeLanguageZhHant = "zh-Hant"
)

// AnalysisSchemeStatus is undocumented.
type AnalysisSchemeStatus struct {
	Options *AnalysisScheme `query:"Options" xml:"Options"`
	Status  *OptionStatus   `query:"Status" xml:"Status"`
}

// AvailabilityOptionsStatus is undocumented.
type AvailabilityOptionsStatus struct {
	Options aws.BooleanValue `query:"Options" xml:"Options"`
	Status  *OptionStatus    `query:"Status" xml:"Status"`
}

// BuildSuggestersRequest is undocumented.
type BuildSuggestersRequest struct {
	DomainName aws.StringValue `query:"DomainName" xml:"DomainName"`
}

// BuildSuggestersResponse is undocumented.
type BuildSuggestersResponse struct {
	FieldNames []string `query:"FieldNames.member" xml:"BuildSuggestersResult>FieldNames>member"`
}

// CreateDomainRequest is undocumented.
type CreateDomainRequest struct {
	DomainName aws.StringValue `query:"DomainName" xml:"DomainName"`
}

// CreateDomainResponse is undocumented.
type CreateDomainResponse struct {
	DomainStatus *DomainStatus `query:"DomainStatus" xml:"CreateDomainResult>DomainStatus"`
}

// DateArrayOptions is undocumented.
type DateArrayOptions struct {
	DefaultValue  aws.StringValue  `query:"DefaultValue" xml:"DefaultValue"`
	FacetEnabled  aws.BooleanValue `query:"FacetEnabled" xml:"FacetEnabled"`
	ReturnEnabled aws.BooleanValue `query:"ReturnEnabled" xml:"ReturnEnabled"`
	SearchEnabled aws.BooleanValue `query:"SearchEnabled" xml:"SearchEnabled"`
	SourceFields  aws.StringValue  `query:"SourceFields" xml:"SourceFields"`
}

// DateOptions is undocumented.
type DateOptions struct {
	DefaultValue  aws.StringValue  `query:"DefaultValue" xml:"DefaultValue"`
	FacetEnabled  aws.BooleanValue `query:"FacetEnabled" xml:"FacetEnabled"`
	ReturnEnabled aws.BooleanValue `query:"ReturnEnabled" xml:"ReturnEnabled"`
	SearchEnabled aws.BooleanValue `query:"SearchEnabled" xml:"SearchEnabled"`
	SortEnabled   aws.BooleanValue `query:"SortEnabled" xml:"SortEnabled"`
	SourceField   aws.StringValue  `query:"SourceField" xml:"SourceField"`
}

// DefineAnalysisSchemeRequest is undocumented.
type DefineAnalysisSchemeRequest struct {
	AnalysisScheme *AnalysisScheme `query:"AnalysisScheme" xml:"AnalysisScheme"`
	DomainName     aws.StringValue `query:"DomainName" xml:"DomainName"`
}

// DefineAnalysisSchemeResponse is undocumented.
type DefineAnalysisSchemeResponse struct {
	AnalysisScheme *AnalysisSchemeStatus `query:"AnalysisScheme" xml:"DefineAnalysisSchemeResult>AnalysisScheme"`
}

// DefineExpressionRequest is undocumented.
type DefineExpressionRequest struct {
	DomainName aws.StringValue `query:"DomainName" xml:"DomainName"`
	Expression *Expression     `query:"Expression" xml:"Expression"`
}

// DefineExpressionResponse is undocumented.
type DefineExpressionResponse struct {
	Expression *ExpressionStatus `query:"Expression" xml:"DefineExpressionResult>Expression"`
}

// DefineIndexFieldRequest is undocumented.
type DefineIndexFieldRequest struct {
	DomainName aws.StringValue `query:"DomainName" xml:"DomainName"`
	IndexField *IndexField     `query:"IndexField" xml:"IndexField"`
}

// DefineIndexFieldResponse is undocumented.
type DefineIndexFieldResponse struct {
	IndexField *IndexFieldStatus `query:"IndexField" xml:"DefineIndexFieldResult>IndexField"`
}

// DefineSuggesterRequest is undocumented.
type DefineSuggesterRequest struct {
	DomainName aws.StringValue `query:"DomainName" xml:"DomainName"`
	Suggester  *Suggester      `query:"Suggester" xml:"Suggester"`
}

// DefineSuggesterResponse is undocumented.
type DefineSuggesterResponse struct {
	Suggester *SuggesterStatus `query:"Suggester" xml:"DefineSuggesterResult>Suggester"`
}

// DeleteAnalysisSchemeRequest is undocumented.
type DeleteAnalysisSchemeRequest struct {
	AnalysisSchemeName aws.StringValue `query:"AnalysisSchemeName" xml:"AnalysisSchemeName"`
	DomainName         aws.StringValue `query:"DomainName" xml:"DomainName"`
}

// DeleteAnalysisSchemeResponse is undocumented.
type DeleteAnalysisSchemeResponse struct {
	AnalysisScheme *AnalysisSchemeStatus `query:"AnalysisScheme" xml:"DeleteAnalysisSchemeResult>AnalysisScheme"`
}

// DeleteDomainRequest is undocumented.
type DeleteDomainRequest struct {
	DomainName aws.StringValue `query:"DomainName" xml:"DomainName"`
}

// DeleteDomainResponse is undocumented.
type DeleteDomainResponse struct {
	DomainStatus *DomainStatus `query:"DomainStatus" xml:"DeleteDomainResult>DomainStatus"`
}

// DeleteExpressionRequest is undocumented.
type DeleteExpressionRequest struct {
	DomainName     aws.StringValue `query:"DomainName" xml:"DomainName"`
	ExpressionName aws.StringValue `query:"ExpressionName" xml:"ExpressionName"`
}

// DeleteExpressionResponse is undocumented.
type DeleteExpressionResponse struct {
	Expression *ExpressionStatus `query:"Expression" xml:"DeleteExpressionResult>Expression"`
}

// DeleteIndexFieldRequest is undocumented.
type DeleteIndexFieldRequest struct {
	DomainName     aws.StringValue `query:"DomainName" xml:"DomainName"`
	IndexFieldName aws.StringValue `query:"IndexFieldName" xml:"IndexFieldName"`
}

// DeleteIndexFieldResponse is undocumented.
type DeleteIndexFieldResponse struct {
	IndexField *IndexFieldStatus `query:"IndexField" xml:"DeleteIndexFieldResult>IndexField"`
}

// DeleteSuggesterRequest is undocumented.
type DeleteSuggesterRequest struct {
	DomainName    aws.StringValue `query:"DomainName" xml:"DomainName"`
	SuggesterName aws.StringValue `query:"SuggesterName" xml:"SuggesterName"`
}

// DeleteSuggesterResponse is undocumented.
type DeleteSuggesterResponse struct {
	Suggester *SuggesterStatus `query:"Suggester" xml:"DeleteSuggesterResult>Suggester"`
}

// DescribeAnalysisSchemesRequest is undocumented.
type DescribeAnalysisSchemesRequest struct {
	AnalysisSchemeNames []string         `query:"AnalysisSchemeNames.member" xml:"AnalysisSchemeNames>member"`
	Deployed            aws.BooleanValue `query:"Deployed" xml:"Deployed"`
	DomainName          aws.StringValue  `query:"DomainName" xml:"DomainName"`
}

// DescribeAnalysisSchemesResponse is undocumented.
type DescribeAnalysisSchemesResponse struct {
	AnalysisSchemes []AnalysisSchemeStatus `query:"AnalysisSchemes.member" xml:"DescribeAnalysisSchemesResult>AnalysisSchemes>member"`
}

// DescribeAvailabilityOptionsRequest is undocumented.
type DescribeAvailabilityOptionsRequest struct {
	Deployed   aws.BooleanValue `query:"Deployed" xml:"Deployed"`
	DomainName aws.StringValue  `query:"DomainName" xml:"DomainName"`
}

// DescribeAvailabilityOptionsResponse is undocumented.
type DescribeAvailabilityOptionsResponse struct {
	AvailabilityOptions *AvailabilityOptionsStatus `query:"AvailabilityOptions" xml:"DescribeAvailabilityOptionsResult>AvailabilityOptions"`
}

// DescribeDomainsRequest is undocumented.
type DescribeDomainsRequest struct {
	DomainNames []string `query:"DomainNames.member" xml:"DomainNames>member"`
}

// DescribeDomainsResponse is undocumented.
type DescribeDomainsResponse struct {
	DomainStatusList []DomainStatus `query:"DomainStatusList.member" xml:"DescribeDomainsResult>DomainStatusList>member"`
}

// DescribeExpressionsRequest is undocumented.
type DescribeExpressionsRequest struct {
	Deployed        aws.BooleanValue `query:"Deployed" xml:"Deployed"`
	DomainName      aws.StringValue  `query:"DomainName" xml:"DomainName"`
	ExpressionNames []string         `query:"ExpressionNames.member" xml:"ExpressionNames>member"`
}

// DescribeExpressionsResponse is undocumented.
type DescribeExpressionsResponse struct {
	Expressions []ExpressionStatus `query:"Expressions.member" xml:"DescribeExpressionsResult>Expressions>member"`
}

// DescribeIndexFieldsRequest is undocumented.
type DescribeIndexFieldsRequest struct {
	Deployed   aws.BooleanValue `query:"Deployed" xml:"Deployed"`
	DomainName aws.StringValue  `query:"DomainName" xml:"DomainName"`
	FieldNames []string         `query:"FieldNames.member" xml:"FieldNames>member"`
}

// DescribeIndexFieldsResponse is undocumented.
type DescribeIndexFieldsResponse struct {
	IndexFields []IndexFieldStatus `query:"IndexFields.member" xml:"DescribeIndexFieldsResult>IndexFields>member"`
}

// DescribeScalingParametersRequest is undocumented.
type DescribeScalingParametersRequest struct {
	DomainName aws.StringValue `query:"DomainName" xml:"DomainName"`
}

// DescribeScalingParametersResponse is undocumented.
type DescribeScalingParametersResponse struct {
	ScalingParameters *ScalingParametersStatus `query:"ScalingParameters" xml:"DescribeScalingParametersResult>ScalingParameters"`
}

// DescribeServiceAccessPoliciesRequest is undocumented.
type DescribeServiceAccessPoliciesRequest struct {
	Deployed   aws.BooleanValue `query:"Deployed" xml:"Deployed"`
	DomainName aws.StringValue  `query:"DomainName" xml:"DomainName"`
}

// DescribeServiceAccessPoliciesResponse is undocumented.
type DescribeServiceAccessPoliciesResponse struct {
	AccessPolicies *AccessPoliciesStatus `query:"AccessPolicies" xml:"DescribeServiceAccessPoliciesResult>AccessPolicies"`
}

// DescribeSuggestersRequest is undocumented.
type DescribeSuggestersRequest struct {
	Deployed       aws.BooleanValue `query:"Deployed" xml:"Deployed"`
	DomainName     aws.StringValue  `query:"DomainName" xml:"DomainName"`
	SuggesterNames []string         `query:"SuggesterNames.member" xml:"SuggesterNames>member"`
}

// DescribeSuggestersResponse is undocumented.
type DescribeSuggestersResponse struct {
	Suggesters []SuggesterStatus `query:"Suggesters.member" xml:"DescribeSuggestersResult>Suggesters>member"`
}

// DocumentSuggesterOptions is undocumented.
type DocumentSuggesterOptions struct {
	FuzzyMatching  aws.StringValue `query:"FuzzyMatching" xml:"FuzzyMatching"`
	SortExpression aws.StringValue `query:"SortExpression" xml:"SortExpression"`
	SourceField    aws.StringValue `query:"SourceField" xml:"SourceField"`
}

type DomainNameMap map[string]string

// UnmarshalXML implements xml.UnmarshalXML interface for map
func (m *DomainNameMap) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	if *m == nil {
		(*m) = make(DomainNameMap)
	}
	for {
		var e struct {
			Key   string `xml:"key"`
			Value string `xml:"value"`
		}
		err := d.DecodeElement(&e, &start)
		if err != nil && err != io.EOF {
			return err
		}
		if err == io.EOF {
			break
		}
		(*m)[e.Key] = e.Value
	}
	return nil
}

// DomainStatus is undocumented.
type DomainStatus struct {
	ARN                    aws.StringValue  `query:"ARN" xml:"ARN"`
	Created                aws.BooleanValue `query:"Created" xml:"Created"`
	Deleted                aws.BooleanValue `query:"Deleted" xml:"Deleted"`
	DocService             *ServiceEndpoint `query:"DocService" xml:"DocService"`
	DomainID               aws.StringValue  `query:"DomainId" xml:"DomainId"`
	DomainName             aws.StringValue  `query:"DomainName" xml:"DomainName"`
	Limits                 *Limits          `query:"Limits" xml:"Limits"`
	Processing             aws.BooleanValue `query:"Processing" xml:"Processing"`
	RequiresIndexDocuments aws.BooleanValue `query:"RequiresIndexDocuments" xml:"RequiresIndexDocuments"`
	SearchInstanceCount    aws.IntegerValue `query:"SearchInstanceCount" xml:"SearchInstanceCount"`
	SearchInstanceType     aws.StringValue  `query:"SearchInstanceType" xml:"SearchInstanceType"`
	SearchPartitionCount   aws.IntegerValue `query:"SearchPartitionCount" xml:"SearchPartitionCount"`
	SearchService          *ServiceEndpoint `query:"SearchService" xml:"SearchService"`
}

// DoubleArrayOptions is undocumented.
type DoubleArrayOptions struct {
	DefaultValue  aws.DoubleValue  `query:"DefaultValue" xml:"DefaultValue"`
	FacetEnabled  aws.BooleanValue `query:"FacetEnabled" xml:"FacetEnabled"`
	ReturnEnabled aws.BooleanValue `query:"ReturnEnabled" xml:"ReturnEnabled"`
	SearchEnabled aws.BooleanValue `query:"SearchEnabled" xml:"SearchEnabled"`
	SourceFields  aws.StringValue  `query:"SourceFields" xml:"SourceFields"`
}

// DoubleOptions is undocumented.
type DoubleOptions struct {
	DefaultValue  aws.DoubleValue  `query:"DefaultValue" xml:"DefaultValue"`
	FacetEnabled  aws.BooleanValue `query:"FacetEnabled" xml:"FacetEnabled"`
	ReturnEnabled aws.BooleanValue `query:"ReturnEnabled" xml:"ReturnEnabled"`
	SearchEnabled aws.BooleanValue `query:"SearchEnabled" xml:"SearchEnabled"`
	SortEnabled   aws.BooleanValue `query:"SortEnabled" xml:"SortEnabled"`
	SourceField   aws.StringValue  `query:"SourceField" xml:"SourceField"`
}

// Expression is undocumented.
type Expression struct {
	ExpressionName  aws.StringValue `query:"ExpressionName" xml:"ExpressionName"`
	ExpressionValue aws.StringValue `query:"ExpressionValue" xml:"ExpressionValue"`
}

// ExpressionStatus is undocumented.
type ExpressionStatus struct {
	Options *Expression   `query:"Options" xml:"Options"`
	Status  *OptionStatus `query:"Status" xml:"Status"`
}

// IndexDocumentsRequest is undocumented.
type IndexDocumentsRequest struct {
	DomainName aws.StringValue `query:"DomainName" xml:"DomainName"`
}

// IndexDocumentsResponse is undocumented.
type IndexDocumentsResponse struct {
	FieldNames []string `query:"FieldNames.member" xml:"IndexDocumentsResult>FieldNames>member"`
}

// IndexField is undocumented.
type IndexField struct {
	DateArrayOptions    *DateArrayOptions    `query:"DateArrayOptions" xml:"DateArrayOptions"`
	DateOptions         *DateOptions         `query:"DateOptions" xml:"DateOptions"`
	DoubleArrayOptions  *DoubleArrayOptions  `query:"DoubleArrayOptions" xml:"DoubleArrayOptions"`
	DoubleOptions       *DoubleOptions       `query:"DoubleOptions" xml:"DoubleOptions"`
	IndexFieldName      aws.StringValue      `query:"IndexFieldName" xml:"IndexFieldName"`
	IndexFieldType      aws.StringValue      `query:"IndexFieldType" xml:"IndexFieldType"`
	IntArrayOptions     *IntArrayOptions     `query:"IntArrayOptions" xml:"IntArrayOptions"`
	IntOptions          *IntOptions          `query:"IntOptions" xml:"IntOptions"`
	LatLonOptions       *LatLonOptions       `query:"LatLonOptions" xml:"LatLonOptions"`
	LiteralArrayOptions *LiteralArrayOptions `query:"LiteralArrayOptions" xml:"LiteralArrayOptions"`
	LiteralOptions      *LiteralOptions      `query:"LiteralOptions" xml:"LiteralOptions"`
	TextArrayOptions    *TextArrayOptions    `query:"TextArrayOptions" xml:"TextArrayOptions"`
	TextOptions         *TextOptions         `query:"TextOptions" xml:"TextOptions"`
}

// IndexFieldStatus is undocumented.
type IndexFieldStatus struct {
	Options *IndexField   `query:"Options" xml:"Options"`
	Status  *OptionStatus `query:"Status" xml:"Status"`
}

// Possible values for CloudSearch.
const (
	IndexFieldTypeDate         = "date"
	IndexFieldTypeDateArray    = "date-array"
	IndexFieldTypeDouble       = "double"
	IndexFieldTypeDoubleArray  = "double-array"
	IndexFieldTypeInt          = "int"
	IndexFieldTypeIntArray     = "int-array"
	IndexFieldTypeLatlon       = "latlon"
	IndexFieldTypeLiteral      = "literal"
	IndexFieldTypeLiteralArray = "literal-array"
	IndexFieldTypeText         = "text"
	IndexFieldTypeTextArray    = "text-array"
)

// IntArrayOptions is undocumented.
type IntArrayOptions struct {
	DefaultValue  aws.LongValue    `query:"DefaultValue" xml:"DefaultValue"`
	FacetEnabled  aws.BooleanValue `query:"FacetEnabled" xml:"FacetEnabled"`
	ReturnEnabled aws.BooleanValue `query:"ReturnEnabled" xml:"ReturnEnabled"`
	SearchEnabled aws.BooleanValue `query:"SearchEnabled" xml:"SearchEnabled"`
	SourceFields  aws.StringValue  `query:"SourceFields" xml:"SourceFields"`
}

// IntOptions is undocumented.
type IntOptions struct {
	DefaultValue  aws.LongValue    `query:"DefaultValue" xml:"DefaultValue"`
	FacetEnabled  aws.BooleanValue `query:"FacetEnabled" xml:"FacetEnabled"`
	ReturnEnabled aws.BooleanValue `query:"ReturnEnabled" xml:"ReturnEnabled"`
	SearchEnabled aws.BooleanValue `query:"SearchEnabled" xml:"SearchEnabled"`
	SortEnabled   aws.BooleanValue `query:"SortEnabled" xml:"SortEnabled"`
	SourceField   aws.StringValue  `query:"SourceField" xml:"SourceField"`
}

// LatLonOptions is undocumented.
type LatLonOptions struct {
	DefaultValue  aws.StringValue  `query:"DefaultValue" xml:"DefaultValue"`
	FacetEnabled  aws.BooleanValue `query:"FacetEnabled" xml:"FacetEnabled"`
	ReturnEnabled aws.BooleanValue `query:"ReturnEnabled" xml:"ReturnEnabled"`
	SearchEnabled aws.BooleanValue `query:"SearchEnabled" xml:"SearchEnabled"`
	SortEnabled   aws.BooleanValue `query:"SortEnabled" xml:"SortEnabled"`
	SourceField   aws.StringValue  `query:"SourceField" xml:"SourceField"`
}

// Limits is undocumented.
type Limits struct {
	MaximumPartitionCount   aws.IntegerValue `query:"MaximumPartitionCount" xml:"MaximumPartitionCount"`
	MaximumReplicationCount aws.IntegerValue `query:"MaximumReplicationCount" xml:"MaximumReplicationCount"`
}

// ListDomainNamesResponse is undocumented.
type ListDomainNamesResponse struct {
	DomainNames DomainNameMap `query:"DomainNames.entry" xml:"ListDomainNamesResult>DomainNames>entry"`
}

// LiteralArrayOptions is undocumented.
type LiteralArrayOptions struct {
	DefaultValue  aws.StringValue  `query:"DefaultValue" xml:"DefaultValue"`
	FacetEnabled  aws.BooleanValue `query:"FacetEnabled" xml:"FacetEnabled"`
	ReturnEnabled aws.BooleanValue `query:"ReturnEnabled" xml:"ReturnEnabled"`
	SearchEnabled aws.BooleanValue `query:"SearchEnabled" xml:"SearchEnabled"`
	SourceFields  aws.StringValue  `query:"SourceFields" xml:"SourceFields"`
}

// LiteralOptions is undocumented.
type LiteralOptions struct {
	DefaultValue  aws.StringValue  `query:"DefaultValue" xml:"DefaultValue"`
	FacetEnabled  aws.BooleanValue `query:"FacetEnabled" xml:"FacetEnabled"`
	ReturnEnabled aws.BooleanValue `query:"ReturnEnabled" xml:"ReturnEnabled"`
	SearchEnabled aws.BooleanValue `query:"SearchEnabled" xml:"SearchEnabled"`
	SortEnabled   aws.BooleanValue `query:"SortEnabled" xml:"SortEnabled"`
	SourceField   aws.StringValue  `query:"SourceField" xml:"SourceField"`
}

// Possible values for CloudSearch.
const (
	OptionStateActive                 = "Active"
	OptionStateFailedToValidate       = "FailedToValidate"
	OptionStateProcessing             = "Processing"
	OptionStateRequiresIndexDocuments = "RequiresIndexDocuments"
)

// OptionStatus is undocumented.
type OptionStatus struct {
	CreationDate    time.Time        `query:"CreationDate" xml:"CreationDate"`
	PendingDeletion aws.BooleanValue `query:"PendingDeletion" xml:"PendingDeletion"`
	State           aws.StringValue  `query:"State" xml:"State"`
	UpdateDate      time.Time        `query:"UpdateDate" xml:"UpdateDate"`
	UpdateVersion   aws.IntegerValue `query:"UpdateVersion" xml:"UpdateVersion"`
}

// Possible values for CloudSearch.
const (
	PartitionInstanceTypeSearchM1Large   = "search.m1.large"
	PartitionInstanceTypeSearchM1Small   = "search.m1.small"
	PartitionInstanceTypeSearchM22xlarge = "search.m2.2xlarge"
	PartitionInstanceTypeSearchM2Xlarge  = "search.m2.xlarge"
)

// ScalingParameters is undocumented.
type ScalingParameters struct {
	DesiredInstanceType     aws.StringValue  `query:"DesiredInstanceType" xml:"DesiredInstanceType"`
	DesiredPartitionCount   aws.IntegerValue `query:"DesiredPartitionCount" xml:"DesiredPartitionCount"`
	DesiredReplicationCount aws.IntegerValue `query:"DesiredReplicationCount" xml:"DesiredReplicationCount"`
}

// ScalingParametersStatus is undocumented.
type ScalingParametersStatus struct {
	Options *ScalingParameters `query:"Options" xml:"Options"`
	Status  *OptionStatus      `query:"Status" xml:"Status"`
}

// ServiceEndpoint is undocumented.
type ServiceEndpoint struct {
	Endpoint aws.StringValue `query:"Endpoint" xml:"Endpoint"`
}

// Suggester is undocumented.
type Suggester struct {
	DocumentSuggesterOptions *DocumentSuggesterOptions `query:"DocumentSuggesterOptions" xml:"DocumentSuggesterOptions"`
	SuggesterName            aws.StringValue           `query:"SuggesterName" xml:"SuggesterName"`
}

// Possible values for CloudSearch.
const (
	SuggesterFuzzyMatchingHigh = "high"
	SuggesterFuzzyMatchingLow  = "low"
	SuggesterFuzzyMatchingNone = "none"
)

// SuggesterStatus is undocumented.
type SuggesterStatus struct {
	Options *Suggester    `query:"Options" xml:"Options"`
	Status  *OptionStatus `query:"Status" xml:"Status"`
}

// TextArrayOptions is undocumented.
type TextArrayOptions struct {
	AnalysisScheme   aws.StringValue  `query:"AnalysisScheme" xml:"AnalysisScheme"`
	DefaultValue     aws.StringValue  `query:"DefaultValue" xml:"DefaultValue"`
	HighlightEnabled aws.BooleanValue `query:"HighlightEnabled" xml:"HighlightEnabled"`
	ReturnEnabled    aws.BooleanValue `query:"ReturnEnabled" xml:"ReturnEnabled"`
	SourceFields     aws.StringValue  `query:"SourceFields" xml:"SourceFields"`
}

// TextOptions is undocumented.
type TextOptions struct {
	AnalysisScheme   aws.StringValue  `query:"AnalysisScheme" xml:"AnalysisScheme"`
	DefaultValue     aws.StringValue  `query:"DefaultValue" xml:"DefaultValue"`
	HighlightEnabled aws.BooleanValue `query:"HighlightEnabled" xml:"HighlightEnabled"`
	ReturnEnabled    aws.BooleanValue `query:"ReturnEnabled" xml:"ReturnEnabled"`
	SortEnabled      aws.BooleanValue `query:"SortEnabled" xml:"SortEnabled"`
	SourceField      aws.StringValue  `query:"SourceField" xml:"SourceField"`
}

// UpdateAvailabilityOptionsRequest is undocumented.
type UpdateAvailabilityOptionsRequest struct {
	DomainName aws.StringValue  `query:"DomainName" xml:"DomainName"`
	MultiAZ    aws.BooleanValue `query:"MultiAZ" xml:"MultiAZ"`
}

// UpdateAvailabilityOptionsResponse is undocumented.
type UpdateAvailabilityOptionsResponse struct {
	AvailabilityOptions *AvailabilityOptionsStatus `query:"AvailabilityOptions" xml:"UpdateAvailabilityOptionsResult>AvailabilityOptions"`
}

// UpdateScalingParametersRequest is undocumented.
type UpdateScalingParametersRequest struct {
	DomainName        aws.StringValue    `query:"DomainName" xml:"DomainName"`
	ScalingParameters *ScalingParameters `query:"ScalingParameters" xml:"ScalingParameters"`
}

// UpdateScalingParametersResponse is undocumented.
type UpdateScalingParametersResponse struct {
	ScalingParameters *ScalingParametersStatus `query:"ScalingParameters" xml:"UpdateScalingParametersResult>ScalingParameters"`
}

// UpdateServiceAccessPoliciesRequest is undocumented.
type UpdateServiceAccessPoliciesRequest struct {
	AccessPolicies aws.StringValue `query:"AccessPolicies" xml:"AccessPolicies"`
	DomainName     aws.StringValue `query:"DomainName" xml:"DomainName"`
}

// UpdateServiceAccessPoliciesResponse is undocumented.
type UpdateServiceAccessPoliciesResponse struct {
	AccessPolicies *AccessPoliciesStatus `query:"AccessPolicies" xml:"UpdateServiceAccessPoliciesResult>AccessPolicies"`
}

// BuildSuggestersResult is a wrapper for BuildSuggestersResponse.
type BuildSuggestersResult struct {
	FieldNames []string `query:"FieldNames.member" xml:"BuildSuggestersResult>FieldNames>member"`
}

// CreateDomainResult is a wrapper for CreateDomainResponse.
type CreateDomainResult struct {
	DomainStatus *DomainStatus `query:"DomainStatus" xml:"CreateDomainResult>DomainStatus"`
}

// DefineAnalysisSchemeResult is a wrapper for DefineAnalysisSchemeResponse.
type DefineAnalysisSchemeResult struct {
	AnalysisScheme *AnalysisSchemeStatus `query:"AnalysisScheme" xml:"DefineAnalysisSchemeResult>AnalysisScheme"`
}

// DefineExpressionResult is a wrapper for DefineExpressionResponse.
type DefineExpressionResult struct {
	Expression *ExpressionStatus `query:"Expression" xml:"DefineExpressionResult>Expression"`
}

// DefineIndexFieldResult is a wrapper for DefineIndexFieldResponse.
type DefineIndexFieldResult struct {
	IndexField *IndexFieldStatus `query:"IndexField" xml:"DefineIndexFieldResult>IndexField"`
}

// DefineSuggesterResult is a wrapper for DefineSuggesterResponse.
type DefineSuggesterResult struct {
	Suggester *SuggesterStatus `query:"Suggester" xml:"DefineSuggesterResult>Suggester"`
}

// DeleteAnalysisSchemeResult is a wrapper for DeleteAnalysisSchemeResponse.
type DeleteAnalysisSchemeResult struct {
	AnalysisScheme *AnalysisSchemeStatus `query:"AnalysisScheme" xml:"DeleteAnalysisSchemeResult>AnalysisScheme"`
}

// DeleteDomainResult is a wrapper for DeleteDomainResponse.
type DeleteDomainResult struct {
	DomainStatus *DomainStatus `query:"DomainStatus" xml:"DeleteDomainResult>DomainStatus"`
}

// DeleteExpressionResult is a wrapper for DeleteExpressionResponse.
type DeleteExpressionResult struct {
	Expression *ExpressionStatus `query:"Expression" xml:"DeleteExpressionResult>Expression"`
}

// DeleteIndexFieldResult is a wrapper for DeleteIndexFieldResponse.
type DeleteIndexFieldResult struct {
	IndexField *IndexFieldStatus `query:"IndexField" xml:"DeleteIndexFieldResult>IndexField"`
}

// DeleteSuggesterResult is a wrapper for DeleteSuggesterResponse.
type DeleteSuggesterResult struct {
	Suggester *SuggesterStatus `query:"Suggester" xml:"DeleteSuggesterResult>Suggester"`
}

// DescribeAnalysisSchemesResult is a wrapper for DescribeAnalysisSchemesResponse.
type DescribeAnalysisSchemesResult struct {
	AnalysisSchemes []AnalysisSchemeStatus `query:"AnalysisSchemes.member" xml:"DescribeAnalysisSchemesResult>AnalysisSchemes>member"`
}

// DescribeAvailabilityOptionsResult is a wrapper for DescribeAvailabilityOptionsResponse.
type DescribeAvailabilityOptionsResult struct {
	AvailabilityOptions *AvailabilityOptionsStatus `query:"AvailabilityOptions" xml:"DescribeAvailabilityOptionsResult>AvailabilityOptions"`
}

// DescribeDomainsResult is a wrapper for DescribeDomainsResponse.
type DescribeDomainsResult struct {
	DomainStatusList []DomainStatus `query:"DomainStatusList.member" xml:"DescribeDomainsResult>DomainStatusList>member"`
}

// DescribeExpressionsResult is a wrapper for DescribeExpressionsResponse.
type DescribeExpressionsResult struct {
	Expressions []ExpressionStatus `query:"Expressions.member" xml:"DescribeExpressionsResult>Expressions>member"`
}

// DescribeIndexFieldsResult is a wrapper for DescribeIndexFieldsResponse.
type DescribeIndexFieldsResult struct {
	IndexFields []IndexFieldStatus `query:"IndexFields.member" xml:"DescribeIndexFieldsResult>IndexFields>member"`
}

// DescribeScalingParametersResult is a wrapper for DescribeScalingParametersResponse.
type DescribeScalingParametersResult struct {
	ScalingParameters *ScalingParametersStatus `query:"ScalingParameters" xml:"DescribeScalingParametersResult>ScalingParameters"`
}

// DescribeServiceAccessPoliciesResult is a wrapper for DescribeServiceAccessPoliciesResponse.
type DescribeServiceAccessPoliciesResult struct {
	AccessPolicies *AccessPoliciesStatus `query:"AccessPolicies" xml:"DescribeServiceAccessPoliciesResult>AccessPolicies"`
}

// DescribeSuggestersResult is a wrapper for DescribeSuggestersResponse.
type DescribeSuggestersResult struct {
	Suggesters []SuggesterStatus `query:"Suggesters.member" xml:"DescribeSuggestersResult>Suggesters>member"`
}

// IndexDocumentsResult is a wrapper for IndexDocumentsResponse.
type IndexDocumentsResult struct {
	FieldNames []string `query:"FieldNames.member" xml:"IndexDocumentsResult>FieldNames>member"`
}

// ListDomainNamesResult is a wrapper for ListDomainNamesResponse.
type ListDomainNamesResult struct {
	DomainNames DomainNameMap `query:"DomainNames.entry" xml:"ListDomainNamesResult>DomainNames>entry"`
}

// UpdateAvailabilityOptionsResult is a wrapper for UpdateAvailabilityOptionsResponse.
type UpdateAvailabilityOptionsResult struct {
	AvailabilityOptions *AvailabilityOptionsStatus `query:"AvailabilityOptions" xml:"UpdateAvailabilityOptionsResult>AvailabilityOptions"`
}

// UpdateScalingParametersResult is a wrapper for UpdateScalingParametersResponse.
type UpdateScalingParametersResult struct {
	ScalingParameters *ScalingParametersStatus `query:"ScalingParameters" xml:"UpdateScalingParametersResult>ScalingParameters"`
}

// UpdateServiceAccessPoliciesResult is a wrapper for UpdateServiceAccessPoliciesResponse.
type UpdateServiceAccessPoliciesResult struct {
	AccessPolicies *AccessPoliciesStatus `query:"AccessPolicies" xml:"UpdateServiceAccessPoliciesResult>AccessPolicies"`
}

// avoid errors if the packages aren't referenced
var _ time.Time

var _ xml.Decoder
var _ = io.EOF
