// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package ec2 provides a client for Amazon Elastic Compute Cloud.
package ec2

import (
	"net/http"
	"time"

	"github.com/awslabs/aws-sdk-go/aws"
	"github.com/awslabs/aws-sdk-go/gen/endpoints"
)

// EC2 is a client for Amazon Elastic Compute Cloud.
type EC2 struct {
	client *aws.EC2Client
}

// New returns a new EC2 client.
func New(creds aws.CredentialsProvider, region string, client *http.Client) *EC2 {
	if client == nil {
		client = http.DefaultClient
	}

	endpoint, service, region := endpoints.Lookup("ec2", region)

	return &EC2{
		client: &aws.EC2Client{
			Context: aws.Context{
				Credentials: creds,
				Service:     service,
				Region:      region,
			},
			Client:     client,
			Endpoint:   endpoint,
			APIVersion: "2014-10-01",
		},
	}
}

// AcceptVPCPeeringConnection accept a VPC peering connection request. To
// accept a request, the VPC peering connection must be in the
// pending-acceptance state, and you must be the owner of the peer Use the
// DescribeVpcPeeringConnections request to view your outstanding VPC
// peering connection requests.
func (c *EC2) AcceptVPCPeeringConnection(req *AcceptVPCPeeringConnectionRequest) (resp *AcceptVPCPeeringConnectionResult, err error) {
	resp = &AcceptVPCPeeringConnectionResult{}
	err = c.client.Do("AcceptVpcPeeringConnection", "POST", "/", req, resp)
	return
}

// AllocateAddress acquires an Elastic IP address. An Elastic IP address is
// for use either in the EC2-Classic platform or in a For more information,
// see Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide
// for Linux
func (c *EC2) AllocateAddress(req *AllocateAddressRequest) (resp *AllocateAddressResult, err error) {
	resp = &AllocateAddressResult{}
	err = c.client.Do("AllocateAddress", "POST", "/", req, resp)
	return
}

// AssignPrivateIPAddresses assigns one or more secondary private IP
// addresses to the specified network interface. You can specify one or
// more specific secondary IP addresses, or you can specify the number of
// secondary IP addresses to be automatically assigned within the subnet's
// block range. The number of secondary IP addresses that you can assign to
// an instance varies by instance type. For information about instance
// types, see Instance Types in the Amazon Elastic Compute Cloud User Guide
// for Linux . For more information about Elastic IP addresses, see Elastic
// IP Addresses in the Amazon Elastic Compute Cloud User Guide for Linux
// AssignPrivateIpAddresses is available only in EC2-VPC.
func (c *EC2) AssignPrivateIPAddresses(req *AssignPrivateIPAddressesRequest) (err error) {
	// NRE
	err = c.client.Do("AssignPrivateIpAddresses", "POST", "/", req, nil)
	return
}

// AssociateAddress associates an Elastic IP address with an instance or a
// network interface. An Elastic IP address is for use in either the
// EC2-Classic platform or in a For more information, see Elastic IP
// Addresses in the Amazon Elastic Compute Cloud User Guide for Linux
// [EC2-Classic, VPC in an EC2-VPC-only account] If the Elastic IP address
// is already associated with a different instance, it is disassociated
// from that instance and associated with the specified instance. in an
// EC2-Classic account] If you don't specify a private IP address, the
// Elastic IP address is associated with the primary IP address. If the
// Elastic IP address is already associated with a different instance or a
// network interface, you get an error unless you allow reassociation. This
// is an idempotent operation. If you perform the operation more than once,
// Amazon EC2 doesn't return an error.
func (c *EC2) AssociateAddress(req *AssociateAddressRequest) (resp *AssociateAddressResult, err error) {
	resp = &AssociateAddressResult{}
	err = c.client.Do("AssociateAddress", "POST", "/", req, resp)
	return
}

// AssociateDHCPOptions associates a set of options (that you've previously
// created) with the specified or associates no options with the After you
// associate the options with the any existing instances and all new
// instances that you launch in that VPC use the options. You don't need to
// restart or relaunch the instances. They automatically pick up the
// changes within a few hours, depending on how frequently the instance
// renews its lease. You can explicitly renew the lease using the operating
// system on the instance. For more information, see Options Sets in the
// Amazon Virtual Private Cloud User Guide
func (c *EC2) AssociateDHCPOptions(req *AssociateDHCPOptionsRequest) (err error) {
	// NRE
	err = c.client.Do("AssociateDhcpOptions", "POST", "/", req, nil)
	return
}

// AssociateRouteTable associates a subnet with a route table. The subnet
// and route table must be in the same This association causes traffic
// originating from the subnet to be routed according to the routes in the
// route table. The action returns an association ID, which you need in
// order to disassociate the route table from the subnet later. A route
// table can be associated with multiple subnets. For more information
// about route tables, see Route Tables in the Amazon Virtual Private Cloud
// User Guide
func (c *EC2) AssociateRouteTable(req *AssociateRouteTableRequest) (resp *AssociateRouteTableResult, err error) {
	resp = &AssociateRouteTableResult{}
	err = c.client.Do("AssociateRouteTable", "POST", "/", req, resp)
	return
}

// AttachClassicLinkVPC links an EC2-Classic instance to a
// ClassicLink-enabled VPC through one or more of the VPC's security
// groups. You cannot link an EC2-Classic instance to more than one VPC at
// a time. You can only link an instance that's in the running state. An
// instance is automatically unlinked from a VPC when it's stopped - you
// can link it to the VPC again when you restart it. After you've linked an
// instance, you cannot change the VPC security groups that are associated
// with it. To change the security groups, you must first unlink the
// instance, and then link it again. Linking your instance to a VPC is
// sometimes referred to as attaching your instance.
func (c *EC2) AttachClassicLinkVPC(req *AttachClassicLinkVPCRequest) (resp *AttachClassicLinkVPCResult, err error) {
	resp = &AttachClassicLinkVPCResult{}
	err = c.client.Do("AttachClassicLinkVpc", "POST", "/", req, resp)
	return
}

// AttachInternetGateway attaches an Internet gateway to a enabling
// connectivity between the Internet and the For more information about
// your VPC and Internet gateway, see the Amazon Virtual Private Cloud User
// Guide
func (c *EC2) AttachInternetGateway(req *AttachInternetGatewayRequest) (err error) {
	// NRE
	err = c.client.Do("AttachInternetGateway", "POST", "/", req, nil)
	return
}

// AttachNetworkInterface is undocumented.
func (c *EC2) AttachNetworkInterface(req *AttachNetworkInterfaceRequest) (resp *AttachNetworkInterfaceResult, err error) {
	resp = &AttachNetworkInterfaceResult{}
	err = c.client.Do("AttachNetworkInterface", "POST", "/", req, resp)
	return
}

// AttachVolume attaches an Amazon EBS volume to a running or stopped
// instance and exposes it to the instance with the specified device name.
// Encrypted Amazon EBS volumes may only be attached to instances that
// support Amazon EBS encryption. For more information, see Amazon EBS
// Encryption in the Amazon Elastic Compute Cloud User Guide for Linux For
// a list of supported device names, see Attaching an Amazon EBS Volume to
// an Instance . Any device names that aren't reserved for instance store
// volumes can be used for Amazon EBS volumes. For more information, see
// Amazon EC2 Instance Store in the Amazon Elastic Compute Cloud User Guide
// for Linux If a volume has an AWS Marketplace product code: The volume
// can be attached only to a stopped instance. AWS Marketplace product
// codes are copied from the volume to the instance. You must be subscribed
// to the product. The instance type and operating system of the instance
// must support the product. For example, you can't detach a volume from a
// Windows instance and attach it to a Linux instance. For an overview of
// the AWS Marketplace, see Introducing AWS Marketplace For more
// information about Amazon EBS volumes, see Attaching Amazon EBS Volumes
// in the Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) AttachVolume(req *AttachVolumeRequest) (resp *VolumeAttachment, err error) {
	resp = &VolumeAttachment{}
	err = c.client.Do("AttachVolume", "POST", "/", req, resp)
	return
}

// AttachVPNGateway attaches a virtual private gateway to a For more
// information, see Adding a Hardware Virtual Private Gateway to Your in
// the Amazon Virtual Private Cloud User Guide
func (c *EC2) AttachVPNGateway(req *AttachVPNGatewayRequest) (resp *AttachVPNGatewayResult, err error) {
	resp = &AttachVPNGatewayResult{}
	err = c.client.Do("AttachVpnGateway", "POST", "/", req, resp)
	return
}

// AuthorizeSecurityGroupEgress adds one or more egress rules to a security
// group for use with a Specifically, this action permits instances to send
// traffic to one or more destination IP address ranges, or to one or more
// destination security groups for the same You can have up to 50 rules per
// security group (covering both ingress and egress rules). A security
// group is for use with instances either in the EC2-Classic platform or in
// a specific This action doesn't apply to security groups for use in
// EC2-Classic. For more information, see Security Groups for Your in the
// Amazon Virtual Private Cloud User Guide Each rule consists of the
// protocol (for example, plus either a range or a source group. For the
// TCP and UDP protocols, you must also specify the destination port or
// port range. For the protocol, you must also specify the type and code.
// You can use -1 for the type or code to mean all types or all codes. Rule
// changes are propagated to affected instances as quickly as possible.
// However, a small delay might occur.
func (c *EC2) AuthorizeSecurityGroupEgress(req *AuthorizeSecurityGroupEgressRequest) (err error) {
	// NRE
	err = c.client.Do("AuthorizeSecurityGroupEgress", "POST", "/", req, nil)
	return
}

// AuthorizeSecurityGroupIngress adds one or more ingress rules to a
// security group. EC2-Classic: You can have up to 100 rules per group.
// EC2-VPC: You can have up to 50 rules per group (covering both ingress
// and egress rules). Rule changes are propagated to instances within the
// security group as quickly as possible. However, a small delay might
// occur. [EC2-Classic] This action gives one or more IP address ranges
// permission to access a security group in your account, or gives one or
// more security groups (called the source groups ) permission to access a
// security group for your account. A source group can be for your own AWS
// account, or another. [EC2-VPC] This action gives one or more IP address
// ranges permission to access a security group in your or gives one or
// more other security groups (called the source groups ) permission to
// access a security group for your The security groups must all be for the
// same
func (c *EC2) AuthorizeSecurityGroupIngress(req *AuthorizeSecurityGroupIngressRequest) (err error) {
	// NRE
	err = c.client.Do("AuthorizeSecurityGroupIngress", "POST", "/", req, nil)
	return
}

// BundleInstance bundles an Amazon instance store-backed Windows instance.
// During bundling, only the root device volume is bundled. Data on other
// instance store volumes is not preserved. This action is not applicable
// for Linux/Unix instances or Windows instances that are backed by Amazon
// For more information, see Creating an Instance Store-Backed Windows
func (c *EC2) BundleInstance(req *BundleInstanceRequest) (resp *BundleInstanceResult, err error) {
	resp = &BundleInstanceResult{}
	err = c.client.Do("BundleInstance", "POST", "/", req, resp)
	return
}

// CancelBundleTask cancels a bundling operation for an instance
// store-backed Windows instance.
func (c *EC2) CancelBundleTask(req *CancelBundleTaskRequest) (resp *CancelBundleTaskResult, err error) {
	resp = &CancelBundleTaskResult{}
	err = c.client.Do("CancelBundleTask", "POST", "/", req, resp)
	return
}

// CancelConversionTask cancels an active conversion task. The task can be
// the import of an instance or volume. The action removes all artifacts of
// the conversion, including a partially uploaded volume or instance. If
// the conversion is complete or is in the process of transferring the
// final disk image, the command fails and returns an exception. For more
// information, see Using the Command Line Tools to Import Your Virtual
// Machine to Amazon EC2 in the Amazon Elastic Compute Cloud User Guide for
// Linux
func (c *EC2) CancelConversionTask(req *CancelConversionRequest) (err error) {
	// NRE
	err = c.client.Do("CancelConversionTask", "POST", "/", req, nil)
	return
}

// CancelExportTask cancels an active export task. The request removes all
// artifacts of the export, including any partially-created Amazon S3
// objects. If the export task is complete or is in the process of
// transferring the final disk image, the command fails and returns an
// error.
func (c *EC2) CancelExportTask(req *CancelExportTaskRequest) (err error) {
	// NRE
	err = c.client.Do("CancelExportTask", "POST", "/", req, nil)
	return
}

// CancelReservedInstancesListing cancels the specified Reserved Instance
// listing in the Reserved Instance Marketplace. For more information, see
// Reserved Instance Marketplace in the Amazon Elastic Compute Cloud User
// Guide for Linux
func (c *EC2) CancelReservedInstancesListing(req *CancelReservedInstancesListingRequest) (resp *CancelReservedInstancesListingResult, err error) {
	resp = &CancelReservedInstancesListingResult{}
	err = c.client.Do("CancelReservedInstancesListing", "POST", "/", req, resp)
	return
}

// CancelSpotInstanceRequests cancels one or more Spot Instance requests.
// Spot Instances are instances that Amazon EC2 starts on your behalf when
// the bid price that you specify exceeds the current Spot Price. Amazon
// EC2 periodically sets the Spot Price based on available Spot Instance
// capacity and current Spot Instance requests. For more information, see
// Spot Instance Requests in the Amazon Elastic Compute Cloud User Guide
// for Linux Canceling a Spot Instance request does not terminate running
// Spot Instances associated with the request.
func (c *EC2) CancelSpotInstanceRequests(req *CancelSpotInstanceRequestsRequest) (resp *CancelSpotInstanceRequestsResult, err error) {
	resp = &CancelSpotInstanceRequestsResult{}
	err = c.client.Do("CancelSpotInstanceRequests", "POST", "/", req, resp)
	return
}

// ConfirmProductInstance determines whether a product code is associated
// with an instance. This action can only be used by the owner of the
// product code. It is useful when a product code owner needs to verify
// whether another user's instance is eligible for support.
func (c *EC2) ConfirmProductInstance(req *ConfirmProductInstanceRequest) (resp *ConfirmProductInstanceResult, err error) {
	resp = &ConfirmProductInstanceResult{}
	err = c.client.Do("ConfirmProductInstance", "POST", "/", req, resp)
	return
}

// CopyImage initiates the copy of an AMI from the specified source region
// to the current region. You specify the destination region by using its
// endpoint when making the request. AMIs that use encrypted Amazon EBS
// snapshots cannot be copied with this method. For more information, see
// Copying AMIs in the Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) CopyImage(req *CopyImageRequest) (resp *CopyImageResult, err error) {
	resp = &CopyImageResult{}
	err = c.client.Do("CopyImage", "POST", "/", req, resp)
	return
}

// CopySnapshot copies a point-in-time snapshot of an Amazon EBS volume and
// stores it in Amazon S3. You can copy the snapshot within the same region
// or from one region to another. You can use the snapshot to create Amazon
// EBS volumes or Amazon Machine Images (AMIs). The snapshot is copied to
// the regional endpoint that you send the request to. Copies of encrypted
// Amazon EBS snapshots remain encrypted. Copies of unencrypted snapshots
// remain unencrypted. Copying snapshots that were encrypted with
// non-default AWS Key Management Service master keys is not supported at
// this time. For more information, see Copying an Amazon EBS Snapshot in
// the Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) CopySnapshot(req *CopySnapshotRequest) (resp *CopySnapshotResult, err error) {
	resp = &CopySnapshotResult{}
	err = c.client.Do("CopySnapshot", "POST", "/", req, resp)
	return
}

// CreateCustomerGateway provides information to AWS about your VPN
// customer gateway device. The customer gateway is the appliance at your
// end of the VPN connection. (The device on the AWS side of the VPN
// connection is the virtual private gateway.) You must provide the
// Internet-routable IP address of the customer gateway's external
// interface. The IP address must be static and can't be behind a device
// performing network address translation For devices that use Border
// Gateway Protocol you can also provide the device's BGP Autonomous System
// Number You can use an existing ASN assigned to your network. If you
// don't have an ASN already, you can use a private ASN (in the 64512 -
// 65534 range). Amazon EC2 supports all 2-byte ASN numbers in the range of
// 1 - 65534, with the exception of 7224, which is reserved in the
// us-east-1 region, and 9059, which is reserved in the eu-west-1 region.
// For more information about VPN customer gateways, see Adding a Hardware
// Virtual Private Gateway to Your in the Amazon Virtual Private Cloud User
// Guide
func (c *EC2) CreateCustomerGateway(req *CreateCustomerGatewayRequest) (resp *CreateCustomerGatewayResult, err error) {
	resp = &CreateCustomerGatewayResult{}
	err = c.client.Do("CreateCustomerGateway", "POST", "/", req, resp)
	return
}

// CreateDHCPOptions creates a set of options for your After creating the
// set, you must associate it with the causing all existing and new
// instances that you launch in the VPC to use this set of options. The
// following are the individual options you can specify. For more
// information about the options, see RFC 2132 domain-name-servers - The IP
// addresses of up to four domain name servers, or AmazonProvidedDNS . The
// default option set specifies AmazonProvidedDNS . If specifying more than
// one domain name server, specify the IP addresses in a single parameter,
// separated by commas. domain-name - If you're using AmazonProvidedDNS in
// us-east-1 , specify ec2.internal . If you're using AmazonProvidedDNS in
// another region, specify region.compute.internal (for example,
// ap-northeast-1.compute.internal ). Otherwise, specify a domain name (for
// example, MyCompany.com ). Important : Some Linux operating systems
// accept multiple domain names separated by spaces. However, Windows and
// other Linux operating systems treat the value as a single domain, which
// results in unexpected behavior. If your options set is associated with a
// VPC that has instances with multiple operating systems, specify only one
// domain name. ntp-servers - The IP addresses of up to four Network Time
// Protocol servers. netbios-name-servers - The IP addresses of up to four
// NetBIOS name servers. netbios-node-type - The NetBIOS node type (1, 2,
// 4, or 8). We recommend that you specify 2 (broadcast and multicast are
// not currently supported). For more information about these node types,
// see RFC 2132 . Your VPC automatically starts out with a set of options
// that includes only a DNS server that we provide (AmazonProvidedDNS). If
// you create a set of options, and if your VPC has an Internet gateway,
// make sure to set the domain-name-servers option either to
// AmazonProvidedDNS or to a domain name server of your choice. For more
// information about options, see Options Sets in the Amazon Virtual
// Private Cloud User Guide
func (c *EC2) CreateDHCPOptions(req *CreateDHCPOptionsRequest) (resp *CreateDHCPOptionsResult, err error) {
	resp = &CreateDHCPOptionsResult{}
	err = c.client.Do("CreateDhcpOptions", "POST", "/", req, resp)
	return
}

// CreateImage creates an Amazon EBS-backed AMI from an Amazon EBS-backed
// instance that is either running or stopped. If you customized your
// instance with instance store volumes or EBS volumes in addition to the
// root device volume, the new AMI contains block device mapping
// information for those volumes. When you launch an instance from this new
// the instance automatically launches with those additional volumes. For
// more information, see Creating Amazon EBS-Backed Linux AMIs in the
// Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) CreateImage(req *CreateImageRequest) (resp *CreateImageResult, err error) {
	resp = &CreateImageResult{}
	err = c.client.Do("CreateImage", "POST", "/", req, resp)
	return
}

// CreateInstanceExportTask exports a running or stopped instance to an
// Amazon S3 bucket. For information about the supported operating systems,
// image formats, and known limitations for the types of instances you can
// export, see Exporting EC2 Instances in the Amazon Elastic Compute Cloud
// User Guide for Linux
func (c *EC2) CreateInstanceExportTask(req *CreateInstanceExportTaskRequest) (resp *CreateInstanceExportTaskResult, err error) {
	resp = &CreateInstanceExportTaskResult{}
	err = c.client.Do("CreateInstanceExportTask", "POST", "/", req, resp)
	return
}

// CreateInternetGateway creates an Internet gateway for use with a After
// creating the Internet gateway, you attach it to a VPC using
// AttachInternetGateway For more information about your VPC and Internet
// gateway, see the Amazon Virtual Private Cloud User Guide
func (c *EC2) CreateInternetGateway(req *CreateInternetGatewayRequest) (resp *CreateInternetGatewayResult, err error) {
	resp = &CreateInternetGatewayResult{}
	err = c.client.Do("CreateInternetGateway", "POST", "/", req, resp)
	return
}

// CreateKeyPair creates a 2048-bit RSA key pair with the specified name.
// Amazon EC2 stores the public key and displays the private key for you to
// save to a file. The private key is returned as an unencrypted PEM
// encoded PKCS#8 private key. If a key with the specified name already
// exists, Amazon EC2 returns an error. You can have up to five thousand
// key pairs per region. The key pair returned to you is available only in
// the region in which you create it. To create a key pair that is
// available in all regions, use ImportKeyPair For more information about
// key pairs, see Key Pairs in the Amazon Elastic Compute Cloud User Guide
// for Linux
func (c *EC2) CreateKeyPair(req *CreateKeyPairRequest) (resp *KeyPair, err error) {
	resp = &KeyPair{}
	err = c.client.Do("CreateKeyPair", "POST", "/", req, resp)
	return
}

// CreateNetworkACL creates a network ACL in a Network ACLs provide an
// optional layer of security (in addition to security groups) for the
// instances in your For more information about network ACLs, see Network
// ACLs in the Amazon Virtual Private Cloud User Guide
func (c *EC2) CreateNetworkACL(req *CreateNetworkACLRequest) (resp *CreateNetworkACLResult, err error) {
	resp = &CreateNetworkACLResult{}
	err = c.client.Do("CreateNetworkAcl", "POST", "/", req, resp)
	return
}

// CreateNetworkACLEntry creates an entry (a rule) in a network ACL with
// the specified rule number. Each network ACL has a set of numbered
// ingress rules and a separate set of numbered egress rules. When
// determining whether a packet should be allowed in or out of a subnet
// associated with the we process the entries in the ACL according to the
// rule numbers, in ascending order. Each network ACL has a set of ingress
// rules and a separate set of egress rules. We recommend that you leave
// room between the rule numbers (for example, 100, 110, 120, and not
// number them one right after the other (for example, 101, 102, 103, This
// makes it easier to add a rule between existing ones without having to
// renumber the rules. After you add an entry, you can't modify it; you
// must either replace it, or create an entry and delete the old one. For
// more information about network ACLs, see Network ACLs in the Amazon
// Virtual Private Cloud User Guide
func (c *EC2) CreateNetworkACLEntry(req *CreateNetworkACLEntryRequest) (err error) {
	// NRE
	err = c.client.Do("CreateNetworkAclEntry", "POST", "/", req, nil)
	return
}

// CreateNetworkInterface creates a network interface in the specified
// subnet. For more information about network interfaces, see Elastic
// Network Interfaces in the Amazon Elastic Compute Cloud User Guide for
// Linux
func (c *EC2) CreateNetworkInterface(req *CreateNetworkInterfaceRequest) (resp *CreateNetworkInterfaceResult, err error) {
	resp = &CreateNetworkInterfaceResult{}
	err = c.client.Do("CreateNetworkInterface", "POST", "/", req, resp)
	return
}

// CreatePlacementGroup creates a placement group that you launch cluster
// instances into. You must give the group a name that's unique within the
// scope of your account. For more information about placement groups and
// cluster instances, see Cluster Instances in the Amazon Elastic Compute
// Cloud User Guide for Linux
func (c *EC2) CreatePlacementGroup(req *CreatePlacementGroupRequest) (err error) {
	// NRE
	err = c.client.Do("CreatePlacementGroup", "POST", "/", req, nil)
	return
}

// CreateReservedInstancesListing creates a listing for Amazon EC2 Reserved
// Instances to be sold in the Reserved Instance Marketplace. You can
// submit one Reserved Instance listing at a time. To get a list of your
// Reserved Instances, you can use the DescribeReservedInstances operation.
// The Reserved Instance Marketplace matches sellers who want to resell
// Reserved Instance capacity that they no longer need with buyers who want
// to purchase additional capacity. Reserved Instances bought and sold
// through the Reserved Instance Marketplace work like any other Reserved
// Instances. To sell your Reserved Instances, you must first register as a
// Seller in the Reserved Instance Marketplace. After completing the
// registration process, you can create a Reserved Instance Marketplace
// listing of some or all of your Reserved Instances, and specify the
// upfront price to receive for them. Your Reserved Instance listings then
// become available for purchase. To view the details of your Reserved
// Instance listing, you can use the DescribeReservedInstancesListings
// operation. For more information, see Reserved Instance Marketplace in
// the Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) CreateReservedInstancesListing(req *CreateReservedInstancesListingRequest) (resp *CreateReservedInstancesListingResult, err error) {
	resp = &CreateReservedInstancesListingResult{}
	err = c.client.Do("CreateReservedInstancesListing", "POST", "/", req, resp)
	return
}

// CreateRoute creates a route in a route table within a You must specify
// one of the following targets: Internet gateway or virtual private
// gateway, NAT instance, VPC peering connection, or network interface.
// When determining how to route traffic, we use the route with the most
// specific match. For example, let's say the traffic is destined for
// 192.0.2.3 , and the route table includes the following two routes:
// 192.0.2.0/24 (goes to some target 192.0.2.0/28 (goes to some target Both
// routes apply to the traffic destined for 192.0.2.3 . However, the second
// route in the list covers a smaller number of IP addresses and is
// therefore more specific, so we use that route to determine where to
// target the traffic. For more information about route tables, see Route
// Tables in the Amazon Virtual Private Cloud User Guide
func (c *EC2) CreateRoute(req *CreateRouteRequest) (err error) {
	// NRE
	err = c.client.Do("CreateRoute", "POST", "/", req, nil)
	return
}

// CreateRouteTable creates a route table for the specified After you
// create a route table, you can add routes and associate the table with a
// subnet. For more information about route tables, see Route Tables in the
// Amazon Virtual Private Cloud User Guide
func (c *EC2) CreateRouteTable(req *CreateRouteTableRequest) (resp *CreateRouteTableResult, err error) {
	resp = &CreateRouteTableResult{}
	err = c.client.Do("CreateRouteTable", "POST", "/", req, resp)
	return
}

// CreateSecurityGroup creates a security group. A security group is for
// use with instances either in the EC2-Classic platform or in a specific
// For more information, see Amazon EC2 Security Groups in the Amazon
// Elastic Compute Cloud User Guide for Linux and Security Groups for Your
// in the Amazon Virtual Private Cloud User Guide EC2-Classic: You can have
// up to 500 security groups. EC2-VPC: You can create up to 100 security
// groups per When you create a security group, you specify a friendly name
// of your choice. You can have a security group for use in EC2-Classic
// with the same name as a security group for use in a However, you can't
// have two security groups for use in EC2-Classic with the same name or
// two security groups for use in a VPC with the same name. You have a
// default security group for use in EC2-Classic and a default security
// group for use in your If you don't specify a security group when you
// launch an instance, the instance is launched into the appropriate
// default security group. A default security group includes a default rule
// that grants instances unrestricted network access to each other. You can
// add or remove rules from your security groups using
// AuthorizeSecurityGroupIngress , AuthorizeSecurityGroupEgress ,
// RevokeSecurityGroupIngress , and RevokeSecurityGroupEgress
func (c *EC2) CreateSecurityGroup(req *CreateSecurityGroupRequest) (resp *CreateSecurityGroupResult, err error) {
	resp = &CreateSecurityGroupResult{}
	err = c.client.Do("CreateSecurityGroup", "POST", "/", req, resp)
	return
}

// CreateSnapshot creates a snapshot of an Amazon EBS volume and stores it
// in Amazon S3. You can use snapshots for backups, to make copies of
// Amazon EBS volumes, and to save data before shutting down an instance.
// When a snapshot is created, any AWS Marketplace product codes that are
// associated with the source volume are propagated to the snapshot. You
// can take a snapshot of an attached volume that is in use. However,
// snapshots only capture data that has been written to your Amazon EBS
// volume at the time the snapshot command is issued; this may exclude any
// data that has been cached by any applications or the operating system.
// If you can pause any file systems on the volume long enough to take a
// snapshot, your snapshot should be complete. However, if you cannot pause
// all file writes to the volume, you should unmount the volume from within
// the instance, issue the snapshot command, and then remount the volume to
// ensure a consistent and complete snapshot. You may remount and use your
// volume while the snapshot status is pending To create a snapshot for
// Amazon EBS volumes that serve as root devices, you should stop the
// instance before taking the snapshot. Snapshots that are taken from
// encrypted volumes are automatically encrypted. Volumes that are created
// from encrypted snapshots are also automatically encrypted. Your
// encrypted volumes and any associated snapshots always remain protected.
// For more information, see Amazon Elastic Block Store and Amazon EBS
// Encryption in the Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) CreateSnapshot(req *CreateSnapshotRequest) (resp *Snapshot, err error) {
	resp = &Snapshot{}
	err = c.client.Do("CreateSnapshot", "POST", "/", req, resp)
	return
}

// CreateSpotDatafeedSubscription creates a data feed for Spot Instances,
// enabling you to view Spot Instance usage logs. You can create one data
// feed per AWS account. For more information, see Spot Instance Data Feed
// in the Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) CreateSpotDatafeedSubscription(req *CreateSpotDatafeedSubscriptionRequest) (resp *CreateSpotDatafeedSubscriptionResult, err error) {
	resp = &CreateSpotDatafeedSubscriptionResult{}
	err = c.client.Do("CreateSpotDatafeedSubscription", "POST", "/", req, resp)
	return
}

// CreateSubnet creates a subnet in an existing When you create each
// subnet, you provide the VPC ID and the block you want for the subnet.
// After you create a subnet, you can't change its block. The subnet's
// block can be the same as the VPC's block (assuming you want only a
// single subnet in the or a subset of the VPC's block. If you create more
// than one subnet in a the subnets' blocks must not overlap. The smallest
// subnet (and you can create uses a /28 netmask (16 IP addresses), and the
// largest uses a /16 netmask (65,536 IP addresses). AWS reserves both the
// first four and the last IP address in each subnet's block. They're not
// available for use. If you add more than one subnet to a they're set up
// in a star topology with a logical router in the middle. If you launch an
// instance in a VPC using an Amazon EBS-backed the IP address doesn't
// change if you stop and restart the instance (unlike a similar instance
// launched outside a which gets a new IP address when restarted). It's
// therefore possible to have a subnet with no running instances (they're
// all stopped), but no remaining IP addresses available. For more
// information about subnets, see Your VPC and Subnets in the Amazon
// Virtual Private Cloud User Guide
func (c *EC2) CreateSubnet(req *CreateSubnetRequest) (resp *CreateSubnetResult, err error) {
	resp = &CreateSubnetResult{}
	err = c.client.Do("CreateSubnet", "POST", "/", req, resp)
	return
}

// CreateTags adds or overwrites one or more tags for the specified Amazon
// EC2 resource or resources. Each resource can have a maximum of 10 tags.
// Each tag consists of a key and optional value. Tag keys must be unique
// per resource. For more information about tags, see Tagging Your
// Resources in the Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) CreateTags(req *CreateTagsRequest) (err error) {
	// NRE
	err = c.client.Do("CreateTags", "POST", "/", req, nil)
	return
}

// CreateVolume creates an Amazon EBS volume that can be attached to an
// instance in the same Availability Zone. The volume is created in the
// regional endpoint that you send the request to. For more information see
// Regions and Endpoints You can create a new empty volume or restore a
// volume from an Amazon EBS snapshot. Any AWS Marketplace product codes
// from the snapshot are propagated to the volume. You can create encrypted
// volumes with the Encrypted parameter. Encrypted volumes may only be
// attached to instances that support Amazon EBS encryption. Volumes that
// are created from encrypted snapshots are also automatically encrypted.
// For more information, see Amazon EBS Encryption in the Amazon Elastic
// Compute Cloud User Guide for Linux For more information, see Creating or
// Restoring an Amazon EBS Volume in the Amazon Elastic Compute Cloud User
// Guide for Linux
func (c *EC2) CreateVolume(req *CreateVolumeRequest) (resp *Volume, err error) {
	resp = &Volume{}
	err = c.client.Do("CreateVolume", "POST", "/", req, resp)
	return
}

// CreateVPC creates a VPC with the specified block. The smallest VPC you
// can create uses a /28 netmask (16 IP addresses), and the largest uses a
// /16 netmask (65,536 IP addresses). To help you decide how big to make
// your see Your VPC and Subnets in the Amazon Virtual Private Cloud User
// Guide By default, each instance you launch in the VPC has the default
// options, which includes only a default DNS server that we provide
// (AmazonProvidedDNS). For more information about options, see Options
// Sets in the Amazon Virtual Private Cloud User Guide
func (c *EC2) CreateVPC(req *CreateVPCRequest) (resp *CreateVPCResult, err error) {
	resp = &CreateVPCResult{}
	err = c.client.Do("CreateVpc", "POST", "/", req, resp)
	return
}

// CreateVPCPeeringConnection requests a VPC peering connection between two
// VPCs: a requester VPC that you own and a peer VPC with which to create
// the connection. The peer VPC can belong to another AWS account. The
// requester VPC and peer VPC cannot have overlapping blocks. The owner of
// the peer VPC must accept the peering request to activate the peering
// connection. The VPC peering connection request expires after 7 days,
// after which it cannot be accepted or rejected. A
// CreateVpcPeeringConnection request between VPCs with overlapping blocks
// results in the VPC peering connection having a status of failed
func (c *EC2) CreateVPCPeeringConnection(req *CreateVPCPeeringConnectionRequest) (resp *CreateVPCPeeringConnectionResult, err error) {
	resp = &CreateVPCPeeringConnectionResult{}
	err = c.client.Do("CreateVpcPeeringConnection", "POST", "/", req, resp)
	return
}

// CreateVPNConnection creates a VPN connection between an existing virtual
// private gateway and a VPN customer gateway. The only supported
// connection type is ipsec.1 The response includes information that you
// need to give to your network administrator to configure your customer
// gateway. We strongly recommend that you use when calling this operation
// because the response contains sensitive cryptographic information for
// configuring your customer gateway. If you decide to shut down your VPN
// connection for any reason and later create a new VPN connection, you
// must reconfigure your customer gateway with the new information returned
// from this call. For more information about VPN connections, see Adding a
// Hardware Virtual Private Gateway to Your in the Amazon Virtual Private
// Cloud User Guide
func (c *EC2) CreateVPNConnection(req *CreateVPNConnectionRequest) (resp *CreateVPNConnectionResult, err error) {
	resp = &CreateVPNConnectionResult{}
	err = c.client.Do("CreateVpnConnection", "POST", "/", req, resp)
	return
}

// CreateVPNConnectionRoute creates a static route associated with a VPN
// connection between an existing virtual private gateway and a VPN
// customer gateway. The static route allows traffic to be routed from the
// virtual private gateway to the VPN customer gateway. For more
// information about VPN connections, see Adding a Hardware Virtual Private
// Gateway to Your in the Amazon Virtual Private Cloud User Guide
func (c *EC2) CreateVPNConnectionRoute(req *CreateVPNConnectionRouteRequest) (err error) {
	// NRE
	err = c.client.Do("CreateVpnConnectionRoute", "POST", "/", req, nil)
	return
}

// CreateVPNGateway creates a virtual private gateway. A virtual private
// gateway is the endpoint on the VPC side of your VPN connection. You can
// create a virtual private gateway before creating the VPC itself. For
// more information about virtual private gateways, see Adding a Hardware
// Virtual Private Gateway to Your in the Amazon Virtual Private Cloud User
// Guide
func (c *EC2) CreateVPNGateway(req *CreateVPNGatewayRequest) (resp *CreateVPNGatewayResult, err error) {
	resp = &CreateVPNGatewayResult{}
	err = c.client.Do("CreateVpnGateway", "POST", "/", req, resp)
	return
}

// DeleteCustomerGateway deletes the specified customer gateway. You must
// delete the VPN connection before you can delete the customer gateway.
func (c *EC2) DeleteCustomerGateway(req *DeleteCustomerGatewayRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteCustomerGateway", "POST", "/", req, nil)
	return
}

// DeleteDHCPOptions deletes the specified set of options. You must
// disassociate the set of options before you can delete it. You can
// disassociate the set of options by associating either a new set of
// options or the default set of options with the
func (c *EC2) DeleteDHCPOptions(req *DeleteDHCPOptionsRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteDhcpOptions", "POST", "/", req, nil)
	return
}

// DeleteInternetGateway deletes the specified Internet gateway. You must
// detach the Internet gateway from the VPC before you can delete it.
func (c *EC2) DeleteInternetGateway(req *DeleteInternetGatewayRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteInternetGateway", "POST", "/", req, nil)
	return
}

// DeleteKeyPair deletes the specified key pair, by removing the public key
// from Amazon EC2.
func (c *EC2) DeleteKeyPair(req *DeleteKeyPairRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteKeyPair", "POST", "/", req, nil)
	return
}

// DeleteNetworkACL deletes the specified network You can't delete the ACL
// if it's associated with any subnets. You can't delete the default
// network
func (c *EC2) DeleteNetworkACL(req *DeleteNetworkACLRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteNetworkAcl", "POST", "/", req, nil)
	return
}

// DeleteNetworkACLEntry deletes the specified ingress or egress entry
// (rule) from the specified network
func (c *EC2) DeleteNetworkACLEntry(req *DeleteNetworkACLEntryRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteNetworkAclEntry", "POST", "/", req, nil)
	return
}

// DeleteNetworkInterface deletes the specified network interface. You must
// detach the network interface before you can delete it.
func (c *EC2) DeleteNetworkInterface(req *DeleteNetworkInterfaceRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteNetworkInterface", "POST", "/", req, nil)
	return
}

// DeletePlacementGroup deletes the specified placement group. You must
// terminate all instances in the placement group before you can delete the
// placement group. For more information about placement groups and cluster
// instances, see Cluster Instances in the Amazon Elastic Compute Cloud
// User Guide for Linux
func (c *EC2) DeletePlacementGroup(req *DeletePlacementGroupRequest) (err error) {
	// NRE
	err = c.client.Do("DeletePlacementGroup", "POST", "/", req, nil)
	return
}

// DeleteRoute deletes the specified route from the specified route table.
func (c *EC2) DeleteRoute(req *DeleteRouteRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteRoute", "POST", "/", req, nil)
	return
}

// DeleteRouteTable deletes the specified route table. You must
// disassociate the route table from any subnets before you can delete it.
// You can't delete the main route table.
func (c *EC2) DeleteRouteTable(req *DeleteRouteTableRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteRouteTable", "POST", "/", req, nil)
	return
}

// DeleteSecurityGroup deletes a security group. If you attempt to delete a
// security group that is associated with an instance, or is referenced by
// another security group, the operation fails with InvalidGroup.InUse in
// EC2-Classic or DependencyViolation in EC2-VPC.
func (c *EC2) DeleteSecurityGroup(req *DeleteSecurityGroupRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteSecurityGroup", "POST", "/", req, nil)
	return
}

// DeleteSnapshot deletes the specified snapshot. When you make periodic
// snapshots of a volume, the snapshots are incremental, and only the
// blocks on the device that have changed since your last snapshot are
// saved in the new snapshot. When you delete a snapshot, only the data not
// needed for any other snapshot is removed. So regardless of which prior
// snapshots have been deleted, all active snapshots will have access to
// all the information needed to restore the volume. You cannot delete a
// snapshot of the root device of an Amazon EBS volume used by a registered
// You must first de-register the AMI before you can delete the snapshot.
// For more information, see Deleting an Amazon EBS Snapshot in the Amazon
// Elastic Compute Cloud User Guide for Linux
func (c *EC2) DeleteSnapshot(req *DeleteSnapshotRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteSnapshot", "POST", "/", req, nil)
	return
}

// DeleteSpotDatafeedSubscription deletes the data feed for Spot Instances.
// For more information, see Spot Instance Data Feed in the Amazon Elastic
// Compute Cloud User Guide for Linux
func (c *EC2) DeleteSpotDatafeedSubscription(req *DeleteSpotDatafeedSubscriptionRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteSpotDatafeedSubscription", "POST", "/", req, nil)
	return
}

// DeleteSubnet deletes the specified subnet. You must terminate all
// running instances in the subnet before you can delete the subnet.
func (c *EC2) DeleteSubnet(req *DeleteSubnetRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteSubnet", "POST", "/", req, nil)
	return
}

// DeleteTags deletes the specified set of tags from the specified set of
// resources. This call is designed to follow a DescribeTags request. For
// more information about tags, see Tagging Your Resources in the Amazon
// Elastic Compute Cloud User Guide for Linux
func (c *EC2) DeleteTags(req *DeleteTagsRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteTags", "POST", "/", req, nil)
	return
}

// DeleteVolume deletes the specified Amazon EBS volume. The volume must be
// in the available state (not attached to an instance). The volume may
// remain in the deleting state for several minutes. For more information,
// see Deleting an Amazon EBS Volume in the Amazon Elastic Compute Cloud
// User Guide for Linux
func (c *EC2) DeleteVolume(req *DeleteVolumeRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteVolume", "POST", "/", req, nil)
	return
}

// DeleteVPC deletes the specified You must detach or delete all gateways
// and resources that are associated with the VPC before you can delete it.
// For example, you must terminate all instances running in the delete all
// security groups associated with the VPC (except the default one), delete
// all route tables associated with the VPC (except the default one), and
// so on.
func (c *EC2) DeleteVPC(req *DeleteVPCRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteVpc", "POST", "/", req, nil)
	return
}

// DeleteVPCPeeringConnection deletes a VPC peering connection. Either the
// owner of the requester VPC or the owner of the peer VPC can delete the
// VPC peering connection if it's in the active state. The owner of the
// requester VPC can delete a VPC peering connection in the
// pending-acceptance state.
func (c *EC2) DeleteVPCPeeringConnection(req *DeleteVPCPeeringConnectionRequest) (resp *DeleteVPCPeeringConnectionResult, err error) {
	resp = &DeleteVPCPeeringConnectionResult{}
	err = c.client.Do("DeleteVpcPeeringConnection", "POST", "/", req, resp)
	return
}

// DeleteVPNConnection deletes the specified VPN connection. If you're
// deleting the VPC and its associated components, we recommend that you
// detach the virtual private gateway from the VPC and delete the VPC
// before deleting the VPN connection. If you believe that the tunnel
// credentials for your VPN connection have been compromised, you can
// delete the VPN connection and create a new one that has new keys,
// without needing to delete the VPC or virtual private gateway. If you
// create a new VPN connection, you must reconfigure the customer gateway
// using the new configuration information returned with the new VPN
// connection
func (c *EC2) DeleteVPNConnection(req *DeleteVPNConnectionRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteVpnConnection", "POST", "/", req, nil)
	return
}

// DeleteVPNConnectionRoute deletes the specified static route associated
// with a VPN connection between an existing virtual private gateway and a
// VPN customer gateway. The static route allows traffic to be routed from
// the virtual private gateway to the VPN customer gateway.
func (c *EC2) DeleteVPNConnectionRoute(req *DeleteVPNConnectionRouteRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteVpnConnectionRoute", "POST", "/", req, nil)
	return
}

// DeleteVPNGateway deletes the specified virtual private gateway. We
// recommend that before you delete a virtual private gateway, you detach
// it from the VPC and delete the VPN connection. Note that you don't need
// to delete the virtual private gateway if you plan to delete and recreate
// the VPN connection between your VPC and your network.
func (c *EC2) DeleteVPNGateway(req *DeleteVPNGatewayRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteVpnGateway", "POST", "/", req, nil)
	return
}

// DeregisterImage deregisters the specified After you deregister an it
// can't be used to launch new instances. This command does not delete the
func (c *EC2) DeregisterImage(req *DeregisterImageRequest) (err error) {
	// NRE
	err = c.client.Do("DeregisterImage", "POST", "/", req, nil)
	return
}

// DescribeAccountAttributes describes attributes of your AWS account. The
// following are the supported account attributes: supported-platforms :
// Indicates whether your account can launch instances into EC2-Classic and
// EC2-VPC, or only into EC2-VPC. default-vpc : The ID of the default VPC
// for your account, or none max-instances : The maximum number of
// On-Demand instances that you can run.
// vpc-max-security-groups-per-interface : The maximum number of security
// groups that you can assign to a network interface. max-elastic-ips : The
// maximum number of Elastic IP addresses that you can allocate for use
// with EC2-Classic. vpc-max-elastic-ips : The maximum number of Elastic IP
// addresses that you can allocate for use with EC2-VPC.
func (c *EC2) DescribeAccountAttributes(req *DescribeAccountAttributesRequest) (resp *DescribeAccountAttributesResult, err error) {
	resp = &DescribeAccountAttributesResult{}
	err = c.client.Do("DescribeAccountAttributes", "POST", "/", req, resp)
	return
}

// DescribeAddresses describes one or more of your Elastic IP addresses. An
// Elastic IP address is for use in either the EC2-Classic platform or in a
// For more information, see Elastic IP Addresses in the Amazon Elastic
// Compute Cloud User Guide for Linux
func (c *EC2) DescribeAddresses(req *DescribeAddressesRequest) (resp *DescribeAddressesResult, err error) {
	resp = &DescribeAddressesResult{}
	err = c.client.Do("DescribeAddresses", "POST", "/", req, resp)
	return
}

// DescribeAvailabilityZones describes one or more of the Availability
// Zones that are available to you. The results include zones only for the
// region you're currently using. If there is an event impacting an
// Availability Zone, you can use this request to view the state and any
// provided message for that Availability Zone. For more information, see
// Regions and Availability Zones in the Amazon Elastic Compute Cloud User
// Guide for Linux
func (c *EC2) DescribeAvailabilityZones(req *DescribeAvailabilityZonesRequest) (resp *DescribeAvailabilityZonesResult, err error) {
	resp = &DescribeAvailabilityZonesResult{}
	err = c.client.Do("DescribeAvailabilityZones", "POST", "/", req, resp)
	return
}

// DescribeBundleTasks describes one or more of your bundling tasks.
// Completed bundle tasks are listed for only a limited time. If your
// bundle task is no longer in the list, you can still register an AMI from
// it. Just use RegisterImage with the Amazon S3 bucket name and image
// manifest name you provided to the bundle task.
func (c *EC2) DescribeBundleTasks(req *DescribeBundleTasksRequest) (resp *DescribeBundleTasksResult, err error) {
	resp = &DescribeBundleTasksResult{}
	err = c.client.Do("DescribeBundleTasks", "POST", "/", req, resp)
	return
}

// DescribeClassicLinkInstances describes one or more of your linked
// EC2-Classic instances. This request only returns information about
// EC2-Classic instances linked to a VPC through ClassicLink; you cannot
// use this request to return information about other instances.
func (c *EC2) DescribeClassicLinkInstances(req *DescribeClassicLinkInstancesRequest) (resp *DescribeClassicLinkInstancesResult, err error) {
	resp = &DescribeClassicLinkInstancesResult{}
	err = c.client.Do("DescribeClassicLinkInstances", "POST", "/", req, resp)
	return
}

// DescribeConversionTasks describes one or more of your conversion tasks.
// For more information, see Using the Command Line Tools to Import Your
// Virtual Machine to Amazon EC2 in the Amazon Elastic Compute Cloud User
// Guide for Linux
func (c *EC2) DescribeConversionTasks(req *DescribeConversionTasksRequest) (resp *DescribeConversionTasksResult, err error) {
	resp = &DescribeConversionTasksResult{}
	err = c.client.Do("DescribeConversionTasks", "POST", "/", req, resp)
	return
}

// DescribeCustomerGateways describes one or more of your VPN customer
// gateways. For more information about VPN customer gateways, see Adding a
// Hardware Virtual Private Gateway to Your in the Amazon Virtual Private
// Cloud User Guide
func (c *EC2) DescribeCustomerGateways(req *DescribeCustomerGatewaysRequest) (resp *DescribeCustomerGatewaysResult, err error) {
	resp = &DescribeCustomerGatewaysResult{}
	err = c.client.Do("DescribeCustomerGateways", "POST", "/", req, resp)
	return
}

// DescribeDHCPOptions describes one or more of your options sets. For more
// information about options sets, see Options Sets in the Amazon Virtual
// Private Cloud User Guide
func (c *EC2) DescribeDHCPOptions(req *DescribeDHCPOptionsRequest) (resp *DescribeDHCPOptionsResult, err error) {
	resp = &DescribeDHCPOptionsResult{}
	err = c.client.Do("DescribeDhcpOptions", "POST", "/", req, resp)
	return
}

// DescribeExportTasks is undocumented.
func (c *EC2) DescribeExportTasks(req *DescribeExportTasksRequest) (resp *DescribeExportTasksResult, err error) {
	resp = &DescribeExportTasksResult{}
	err = c.client.Do("DescribeExportTasks", "POST", "/", req, resp)
	return
}

// DescribeImageAttribute describes the specified attribute of the
// specified You can specify only one attribute at a time.
func (c *EC2) DescribeImageAttribute(req *DescribeImageAttributeRequest) (resp *ImageAttribute, err error) {
	resp = &ImageAttribute{}
	err = c.client.Do("DescribeImageAttribute", "POST", "/", req, resp)
	return
}

// DescribeImages describes one or more of the images (AMIs, AKIs, and
// ARIs) available to you. Images available to you include public images,
// private images that you own, and private images owned by other AWS
// accounts but for which you have explicit launch permissions.
// Deregistered images are included in the returned results for an
// unspecified interval after deregistration.
func (c *EC2) DescribeImages(req *DescribeImagesRequest) (resp *DescribeImagesResult, err error) {
	resp = &DescribeImagesResult{}
	err = c.client.Do("DescribeImages", "POST", "/", req, resp)
	return
}

// DescribeInstanceAttribute describes the specified attribute of the
// specified instance. You can specify only one attribute at a time. Valid
// attribute values are: instanceType | kernel | ramdisk | userData |
// disableApiTermination | instanceInitiatedShutdownBehavior |
// rootDeviceName | blockDeviceMapping | productCodes | sourceDestCheck |
// groupSet | ebsOptimized | sriovNetSupport
func (c *EC2) DescribeInstanceAttribute(req *DescribeInstanceAttributeRequest) (resp *InstanceAttribute, err error) {
	resp = &InstanceAttribute{}
	err = c.client.Do("DescribeInstanceAttribute", "POST", "/", req, resp)
	return
}

// DescribeInstanceStatus describes the status of one or more instances,
// including any scheduled events. Instance status has two main components:
// System Status reports impaired functionality that stems from issues
// related to the systems that support an instance, such as such as
// hardware failures and network connectivity problems. This call reports
// such problems as impaired reachability. Instance Status reports impaired
// functionality that arises from problems internal to the instance. This
// call reports such problems as impaired reachability. Instance status
// provides information about four types of scheduled events for an
// instance that may require your attention: Scheduled Reboot: When Amazon
// EC2 determines that an instance must be rebooted, the instances status
// returns one of two event codes: system-reboot or instance-reboot .
// System reboot commonly occurs if certain maintenance or upgrade
// operations require a reboot of the underlying host that supports an
// instance. Instance reboot commonly occurs if the instance must be
// rebooted, rather than the underlying host. Rebooting events include a
// scheduled start and end time. System Maintenance: When Amazon EC2
// determines that an instance requires maintenance that requires power or
// network impact, the instance status is the event code system-maintenance
// . System maintenance is either power maintenance or network maintenance.
// For power maintenance, your instance will be unavailable for a brief
// period of time and then rebooted. For network maintenance, your instance
// will experience a brief loss of network connectivity. System maintenance
// events include a scheduled start and end time. You will also be notified
// by email if one of your instances is set for system maintenance. The
// email message indicates when your instance is scheduled for maintenance.
// Scheduled Retirement: When Amazon EC2 determines that an instance must
// be shut down, the instance status is the event code instance-retirement
// . Retirement commonly occurs when the underlying host is degraded and
// must be replaced. Retirement events include a scheduled start and end
// time. You will also be notified by email if one of your instances is set
// to retiring. The email message indicates when your instance will be
// permanently retired. Scheduled Stop: When Amazon EC2 determines that an
// instance must be shut down, the instances status returns an event code
// called instance-stop . Stop events include a scheduled start and end
// time. You will also be notified by email if one of your instances is set
// to stop. The email message indicates when your instance will be stopped.
// When your instance is retired, it will either be terminated (if its root
// device type is the instance-store) or stopped (if its root device type
// is an EBS volume). Instances stopped due to retirement will not be
// restarted, but you can do so manually. You can also avoid retirement of
// EBS-backed instances by manually restarting your instance when its event
// code is instance-retirement . This ensures that your instance is started
// on a different underlying host. For more information about failed status
// checks, see Troubleshooting Instances with Failed Status Checks in the
// Amazon Elastic Compute Cloud User Guide for Linux . For more information
// about working with scheduled events, see Working with an Instance That
// Has a Scheduled Event in the Amazon Elastic Compute Cloud User Guide for
// Linux
func (c *EC2) DescribeInstanceStatus(req *DescribeInstanceStatusRequest) (resp *DescribeInstanceStatusResult, err error) {
	resp = &DescribeInstanceStatusResult{}
	err = c.client.Do("DescribeInstanceStatus", "POST", "/", req, resp)
	return
}

// DescribeInstances describes one or more of your instances. If you
// specify one or more instance IDs, Amazon EC2 returns information for
// those instances. If you do not specify instance IDs, Amazon EC2 returns
// information for all relevant instances. If you specify an instance ID
// that is not valid, an error is returned. If you specify an instance that
// you do not own, it is not included in the returned results. Recently
// terminated instances might appear in the returned results. This interval
// is usually less than one hour.
func (c *EC2) DescribeInstances(req *DescribeInstancesRequest) (resp *DescribeInstancesResult, err error) {
	resp = &DescribeInstancesResult{}
	err = c.client.Do("DescribeInstances", "POST", "/", req, resp)
	return
}

// DescribeInternetGateways is undocumented.
func (c *EC2) DescribeInternetGateways(req *DescribeInternetGatewaysRequest) (resp *DescribeInternetGatewaysResult, err error) {
	resp = &DescribeInternetGatewaysResult{}
	err = c.client.Do("DescribeInternetGateways", "POST", "/", req, resp)
	return
}

// DescribeKeyPairs describes one or more of your key pairs. For more
// information about key pairs, see Key Pairs in the Amazon Elastic Compute
// Cloud User Guide for Linux
func (c *EC2) DescribeKeyPairs(req *DescribeKeyPairsRequest) (resp *DescribeKeyPairsResult, err error) {
	resp = &DescribeKeyPairsResult{}
	err = c.client.Do("DescribeKeyPairs", "POST", "/", req, resp)
	return
}

// DescribeNetworkACLs describes one or more of your network ACLs. For more
// information about network ACLs, see Network ACLs in the Amazon Virtual
// Private Cloud User Guide
func (c *EC2) DescribeNetworkACLs(req *DescribeNetworkACLsRequest) (resp *DescribeNetworkACLsResult, err error) {
	resp = &DescribeNetworkACLsResult{}
	err = c.client.Do("DescribeNetworkAcls", "POST", "/", req, resp)
	return
}

// DescribeNetworkInterfaceAttribute describes a network interface
// attribute. You can specify only one attribute at a time.
func (c *EC2) DescribeNetworkInterfaceAttribute(req *DescribeNetworkInterfaceAttributeRequest) (resp *DescribeNetworkInterfaceAttributeResult, err error) {
	resp = &DescribeNetworkInterfaceAttributeResult{}
	err = c.client.Do("DescribeNetworkInterfaceAttribute", "POST", "/", req, resp)
	return
}

// DescribeNetworkInterfaces is undocumented.
func (c *EC2) DescribeNetworkInterfaces(req *DescribeNetworkInterfacesRequest) (resp *DescribeNetworkInterfacesResult, err error) {
	resp = &DescribeNetworkInterfacesResult{}
	err = c.client.Do("DescribeNetworkInterfaces", "POST", "/", req, resp)
	return
}

// DescribePlacementGroups describes one or more of your placement groups.
// For more information about placement groups and cluster instances, see
// Cluster Instances in the Amazon Elastic Compute Cloud User Guide for
// Linux
func (c *EC2) DescribePlacementGroups(req *DescribePlacementGroupsRequest) (resp *DescribePlacementGroupsResult, err error) {
	resp = &DescribePlacementGroupsResult{}
	err = c.client.Do("DescribePlacementGroups", "POST", "/", req, resp)
	return
}

// DescribeRegions describes one or more regions that are currently
// available to you. For a list of the regions supported by Amazon EC2, see
// Regions and Endpoints
func (c *EC2) DescribeRegions(req *DescribeRegionsRequest) (resp *DescribeRegionsResult, err error) {
	resp = &DescribeRegionsResult{}
	err = c.client.Do("DescribeRegions", "POST", "/", req, resp)
	return
}

// DescribeReservedInstances describes one or more of the Reserved
// Instances that you purchased. For more information about Reserved
// Instances, see Reserved Instances in the Amazon Elastic Compute Cloud
// User Guide for Linux
func (c *EC2) DescribeReservedInstances(req *DescribeReservedInstancesRequest) (resp *DescribeReservedInstancesResult, err error) {
	resp = &DescribeReservedInstancesResult{}
	err = c.client.Do("DescribeReservedInstances", "POST", "/", req, resp)
	return
}

// DescribeReservedInstancesListings describes your account's Reserved
// Instance listings in the Reserved Instance Marketplace. The Reserved
// Instance Marketplace matches sellers who want to resell Reserved
// Instance capacity that they no longer need with buyers who want to
// purchase additional capacity. Reserved Instances bought and sold through
// the Reserved Instance Marketplace work like any other Reserved
// Instances. As a seller, you choose to list some or all of your Reserved
// Instances, and you specify the upfront price to receive for them. Your
// Reserved Instances are then listed in the Reserved Instance Marketplace
// and are available for purchase. As a buyer, you specify the
// configuration of the Reserved Instance to purchase, and the Marketplace
// matches what you're searching for with what's available. The Marketplace
// first sells the lowest priced Reserved Instances to you, and continues
// to sell available Reserved Instance listings to you until your demand is
// met. You are charged based on the total price of all of the listings
// that you purchase. For more information, see Reserved Instance
// Marketplace in the Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) DescribeReservedInstancesListings(req *DescribeReservedInstancesListingsRequest) (resp *DescribeReservedInstancesListingsResult, err error) {
	resp = &DescribeReservedInstancesListingsResult{}
	err = c.client.Do("DescribeReservedInstancesListings", "POST", "/", req, resp)
	return
}

// DescribeReservedInstancesModifications describes the modifications made
// to your Reserved Instances. If no parameter is specified, information
// about all your Reserved Instances modification requests is returned. If
// a modification ID is specified, only information about the specific
// modification is returned. For more information, see Modifying Reserved
// Instances in the Amazon Elastic Compute Cloud User Guide for Linux.
func (c *EC2) DescribeReservedInstancesModifications(req *DescribeReservedInstancesModificationsRequest) (resp *DescribeReservedInstancesModificationsResult, err error) {
	resp = &DescribeReservedInstancesModificationsResult{}
	err = c.client.Do("DescribeReservedInstancesModifications", "POST", "/", req, resp)
	return
}

// DescribeReservedInstancesOfferings describes Reserved Instance offerings
// that are available for purchase. With Reserved Instances, you purchase
// the right to launch instances for a period of time. During that time
// period, you do not receive insufficient capacity errors, and you pay a
// lower usage rate than the rate charged for On-Demand instances for the
// actual time used. For more information, see Reserved Instance
// Marketplace in the Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) DescribeReservedInstancesOfferings(req *DescribeReservedInstancesOfferingsRequest) (resp *DescribeReservedInstancesOfferingsResult, err error) {
	resp = &DescribeReservedInstancesOfferingsResult{}
	err = c.client.Do("DescribeReservedInstancesOfferings", "POST", "/", req, resp)
	return
}

// DescribeRouteTables describes one or more of your route tables. For more
// information about route tables, see Route Tables in the Amazon Virtual
// Private Cloud User Guide
func (c *EC2) DescribeRouteTables(req *DescribeRouteTablesRequest) (resp *DescribeRouteTablesResult, err error) {
	resp = &DescribeRouteTablesResult{}
	err = c.client.Do("DescribeRouteTables", "POST", "/", req, resp)
	return
}

// DescribeSecurityGroups describes one or more of your security groups. A
// security group is for use with instances either in the EC2-Classic
// platform or in a specific For more information, see Amazon EC2 Security
// Groups in the Amazon Elastic Compute Cloud User Guide for Linux and
// Security Groups for Your in the Amazon Virtual Private Cloud User Guide
func (c *EC2) DescribeSecurityGroups(req *DescribeSecurityGroupsRequest) (resp *DescribeSecurityGroupsResult, err error) {
	resp = &DescribeSecurityGroupsResult{}
	err = c.client.Do("DescribeSecurityGroups", "POST", "/", req, resp)
	return
}

// DescribeSnapshotAttribute describes the specified attribute of the
// specified snapshot. You can specify only one attribute at a time. For
// more information about Amazon EBS snapshots, see Amazon EBS Snapshots in
// the Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) DescribeSnapshotAttribute(req *DescribeSnapshotAttributeRequest) (resp *DescribeSnapshotAttributeResult, err error) {
	resp = &DescribeSnapshotAttributeResult{}
	err = c.client.Do("DescribeSnapshotAttribute", "POST", "/", req, resp)
	return
}

// DescribeSnapshots describes one or more of the Amazon EBS snapshots
// available to you. Available snapshots include public snapshots available
// for any AWS account to launch, private snapshots that you own, and
// private snapshots owned by another AWS account but for which you've been
// given explicit create volume permissions. The create volume permissions
// fall into the following categories: public : The owner of the snapshot
// granted create volume permissions for the snapshot to the all group. All
// AWS accounts have create volume permissions for these snapshots.
// explicit : The owner of the snapshot granted create volume permissions
// to a specific AWS account. implicit : An AWS account has implicit create
// volume permissions for all snapshots it owns. The list of snapshots
// returned can be modified by specifying snapshot IDs, snapshot owners, or
// AWS accounts with create volume permissions. If no options are
// specified, Amazon EC2 returns all snapshots for which you have create
// volume permissions. If you specify one or more snapshot IDs, only
// snapshots that have the specified IDs are returned. If you specify an
// invalid snapshot ID, an error is returned. If you specify a snapshot ID
// for which you do not have access, it is not included in the returned
// results. If you specify one or more snapshot owners, only snapshots from
// the specified owners and for which you have access are returned. The
// results can include the AWS account IDs of the specified owners, amazon
// for snapshots owned by Amazon, or self for snapshots that you own. If
// you specify a list of restorable users, only snapshots with create
// snapshot permissions for those users are returned. You can specify AWS
// account IDs (if you own the snapshots), self for snapshots for which you
// own or have explicit permissions, or all for public snapshots. For more
// information about Amazon EBS snapshots, see Amazon EBS Snapshots in the
// Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) DescribeSnapshots(req *DescribeSnapshotsRequest) (resp *DescribeSnapshotsResult, err error) {
	resp = &DescribeSnapshotsResult{}
	err = c.client.Do("DescribeSnapshots", "POST", "/", req, resp)
	return
}

// DescribeSpotDatafeedSubscription describes the data feed for Spot
// Instances. For more information, see Spot Instance Data Feed in the
// Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) DescribeSpotDatafeedSubscription(req *DescribeSpotDatafeedSubscriptionRequest) (resp *DescribeSpotDatafeedSubscriptionResult, err error) {
	resp = &DescribeSpotDatafeedSubscriptionResult{}
	err = c.client.Do("DescribeSpotDatafeedSubscription", "POST", "/", req, resp)
	return
}

// DescribeSpotInstanceRequests describes the Spot Instance requests that
// belong to your account. Spot Instances are instances that Amazon EC2
// launches when the bid price that you specify exceeds the current Spot
// Price. Amazon EC2 periodically sets the Spot Price based on available
// Spot Instance capacity and current Spot Instance requests. For more
// information, see Spot Instance Requests in the Amazon Elastic Compute
// Cloud User Guide for Linux You can use DescribeSpotInstanceRequests to
// find a running Spot Instance by examining the response. If the status of
// the Spot Instance is fulfilled , the instance ID appears in the response
// and contains the identifier of the instance. Alternatively, you can use
// DescribeInstances with a filter to look for instances where the instance
// lifecycle is spot
func (c *EC2) DescribeSpotInstanceRequests(req *DescribeSpotInstanceRequestsRequest) (resp *DescribeSpotInstanceRequestsResult, err error) {
	resp = &DescribeSpotInstanceRequestsResult{}
	err = c.client.Do("DescribeSpotInstanceRequests", "POST", "/", req, resp)
	return
}

// DescribeSpotPriceHistory describes the Spot Price history. Spot
// Instances are instances that Amazon EC2 starts on your behalf when the
// maximum price that you specify exceeds the current Spot Price. Amazon
// EC2 periodically sets the Spot Price based on available Spot Instance
// capacity and current Spot Instance requests. For more information, see
// Spot Instance Pricing History in the Amazon Elastic Compute Cloud User
// Guide for Linux When you specify an Availability Zone, this operation
// describes the price history for the specified Availability Zone with the
// most recent set of prices listed first. If you don't specify an
// Availability Zone, you get the prices across all Availability Zones,
// starting with the most recent set. However, if you're using an API
// version earlier than 2011-05-15, you get the lowest price across the
// region for the specified time period. The prices returned are listed in
// chronological order, from the oldest to the most recent. When you
// specify the start and end time options, this operation returns two
// pieces of data: the prices of the instance types within the time range
// that you specified and the time when the price changed. The price is
// valid within the time period that you specified; the response merely
// indicates the last time that the price changed.
func (c *EC2) DescribeSpotPriceHistory(req *DescribeSpotPriceHistoryRequest) (resp *DescribeSpotPriceHistoryResult, err error) {
	resp = &DescribeSpotPriceHistoryResult{}
	err = c.client.Do("DescribeSpotPriceHistory", "POST", "/", req, resp)
	return
}

// DescribeSubnets describes one or more of your subnets. For more
// information about subnets, see Your VPC and Subnets in the Amazon
// Virtual Private Cloud User Guide
func (c *EC2) DescribeSubnets(req *DescribeSubnetsRequest) (resp *DescribeSubnetsResult, err error) {
	resp = &DescribeSubnetsResult{}
	err = c.client.Do("DescribeSubnets", "POST", "/", req, resp)
	return
}

// DescribeTags describes one or more of the tags for your EC2 resources.
// For more information about tags, see Tagging Your Resources in the
// Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) DescribeTags(req *DescribeTagsRequest) (resp *DescribeTagsResult, err error) {
	resp = &DescribeTagsResult{}
	err = c.client.Do("DescribeTags", "POST", "/", req, resp)
	return
}

// DescribeVolumeAttribute describes the specified attribute of the
// specified volume. You can specify only one attribute at a time. For more
// information about Amazon EBS volumes, see Amazon EBS Volumes in the
// Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) DescribeVolumeAttribute(req *DescribeVolumeAttributeRequest) (resp *DescribeVolumeAttributeResult, err error) {
	resp = &DescribeVolumeAttributeResult{}
	err = c.client.Do("DescribeVolumeAttribute", "POST", "/", req, resp)
	return
}

// DescribeVolumeStatus describes the status of the specified volumes.
// Volume status provides the result of the checks performed on your
// volumes to determine events that can impair the performance of your
// volumes. The performance of a volume can be affected if an issue occurs
// on the volume's underlying host. If the volume's underlying host
// experiences a power outage or system issue, after the system is
// restored, there could be data inconsistencies on the volume. Volume
// events notify you if this occurs. Volume actions notify you if any
// action needs to be taken in response to the event. The
// DescribeVolumeStatus operation provides the following information about
// the specified volumes: Status : Reflects the current status of the
// volume. The possible values are ok , impaired , warning , or
// insufficient-data . If all checks pass, the overall status of the volume
// is ok . If the check fails, the overall status is impaired . If the
// status is insufficient-data , then the checks may still be taking place
// on your volume at the time. We recommend that you retry the request. For
// more information on volume status, see Monitoring the Status of Your
// Volumes Events : Reflect the cause of a volume status and may require
// you to take action. For example, if your volume returns an impaired
// status, then the volume event might be potential-data-inconsistency .
// This means that your volume has been affected by an issue with the
// underlying host, has all I/O operations disabled, and may have
// inconsistent data. Actions : Reflect the actions you may have to take in
// response to an event. For example, if the status of the volume is
// impaired and the volume event shows potential-data-inconsistency , then
// the action shows enable-volume-io . This means that you may want to
// enable the I/O operations for the volume by calling the EnableVolumeIO
// action and then check the volume for data consistency. Volume status is
// based on the volume status checks, and does not reflect the volume
// state. Therefore, volume status does not indicate volumes in the error
// state (for example, when a volume is incapable of accepting
func (c *EC2) DescribeVolumeStatus(req *DescribeVolumeStatusRequest) (resp *DescribeVolumeStatusResult, err error) {
	resp = &DescribeVolumeStatusResult{}
	err = c.client.Do("DescribeVolumeStatus", "POST", "/", req, resp)
	return
}

// DescribeVolumes describes the specified Amazon EBS volumes. If you are
// describing a long list of volumes, you can paginate the output to make
// the list more manageable. The MaxResults parameter sets the maximum
// number of results returned in a single page. If the list of results
// exceeds your MaxResults value, then that number of results is returned
// along with a NextToken value that can be passed to a subsequent
// DescribeVolumes request to retrieve the remaining results. For more
// information about Amazon EBS volumes, see Amazon EBS Volumes in the
// Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) DescribeVolumes(req *DescribeVolumesRequest) (resp *DescribeVolumesResult, err error) {
	resp = &DescribeVolumesResult{}
	err = c.client.Do("DescribeVolumes", "POST", "/", req, resp)
	return
}

// DescribeVPCAttribute describes the specified attribute of the specified
// You can specify only one attribute at a time.
func (c *EC2) DescribeVPCAttribute(req *DescribeVPCAttributeRequest) (resp *DescribeVPCAttributeResult, err error) {
	resp = &DescribeVPCAttributeResult{}
	err = c.client.Do("DescribeVpcAttribute", "POST", "/", req, resp)
	return
}

// DescribeVPCClassicLink describes the ClassicLink status of one or more
// VPCs.
func (c *EC2) DescribeVPCClassicLink(req *DescribeVPCClassicLinkRequest) (resp *DescribeVPCClassicLinkResult, err error) {
	resp = &DescribeVPCClassicLinkResult{}
	err = c.client.Do("DescribeVpcClassicLink", "POST", "/", req, resp)
	return
}

// DescribeVPCPeeringConnections describes one or more of your VPC peering
// connections.
func (c *EC2) DescribeVPCPeeringConnections(req *DescribeVPCPeeringConnectionsRequest) (resp *DescribeVPCPeeringConnectionsResult, err error) {
	resp = &DescribeVPCPeeringConnectionsResult{}
	err = c.client.Do("DescribeVpcPeeringConnections", "POST", "/", req, resp)
	return
}

// DescribeVPCs is undocumented.
func (c *EC2) DescribeVPCs(req *DescribeVPCsRequest) (resp *DescribeVPCsResult, err error) {
	resp = &DescribeVPCsResult{}
	err = c.client.Do("DescribeVpcs", "POST", "/", req, resp)
	return
}

// DescribeVPNConnections describes one or more of your VPN connections.
// For more information about VPN connections, see Adding a Hardware
// Virtual Private Gateway to Your in the Amazon Virtual Private Cloud User
// Guide
func (c *EC2) DescribeVPNConnections(req *DescribeVPNConnectionsRequest) (resp *DescribeVPNConnectionsResult, err error) {
	resp = &DescribeVPNConnectionsResult{}
	err = c.client.Do("DescribeVpnConnections", "POST", "/", req, resp)
	return
}

// DescribeVPNGateways describes one or more of your virtual private
// gateways. For more information about virtual private gateways, see
// Adding an IPsec Hardware VPN to Your in the Amazon Virtual Private Cloud
// User Guide
func (c *EC2) DescribeVPNGateways(req *DescribeVPNGatewaysRequest) (resp *DescribeVPNGatewaysResult, err error) {
	resp = &DescribeVPNGatewaysResult{}
	err = c.client.Do("DescribeVpnGateways", "POST", "/", req, resp)
	return
}

// DetachClassicLinkVPC unlinks (detaches) a linked EC2-Classic instance
// from a After the instance has been unlinked, the VPC security groups are
// no longer associated with it. An instance is automatically unlinked from
// a VPC when it's stopped.
func (c *EC2) DetachClassicLinkVPC(req *DetachClassicLinkVPCRequest) (resp *DetachClassicLinkVPCResult, err error) {
	resp = &DetachClassicLinkVPCResult{}
	err = c.client.Do("DetachClassicLinkVpc", "POST", "/", req, resp)
	return
}

// DetachInternetGateway detaches an Internet gateway from a disabling
// connectivity between the Internet and the The VPC must not contain any
// running instances with Elastic IP addresses.
func (c *EC2) DetachInternetGateway(req *DetachInternetGatewayRequest) (err error) {
	// NRE
	err = c.client.Do("DetachInternetGateway", "POST", "/", req, nil)
	return
}

// DetachNetworkInterface is undocumented.
func (c *EC2) DetachNetworkInterface(req *DetachNetworkInterfaceRequest) (err error) {
	// NRE
	err = c.client.Do("DetachNetworkInterface", "POST", "/", req, nil)
	return
}

// DetachVolume detaches an Amazon EBS volume from an instance. Make sure
// to unmount any file systems on the device within your operating system
// before detaching the volume. Failure to do so results in the volume
// being stuck in a busy state while detaching. If an Amazon EBS volume is
// the root device of an instance, it can't be detached while the instance
// is running. To detach the root volume, stop the instance first. When a
// volume with an AWS Marketplace product code is detached from an
// instance, the product code is no longer associated with the instance.
// For more information, see Detaching an Amazon EBS Volume in the Amazon
// Elastic Compute Cloud User Guide for Linux
func (c *EC2) DetachVolume(req *DetachVolumeRequest) (resp *VolumeAttachment, err error) {
	resp = &VolumeAttachment{}
	err = c.client.Do("DetachVolume", "POST", "/", req, resp)
	return
}

// DetachVPNGateway detaches a virtual private gateway from a You do this
// if you're planning to turn off the VPC and not use it anymore. You can
// confirm a virtual private gateway has been completely detached from a
// VPC by describing the virtual private gateway (any attachments to the
// virtual private gateway are also described). You must wait for the
// attachment's state to switch to detached before you can delete the VPC
// or attach a different VPC to the virtual private gateway.
func (c *EC2) DetachVPNGateway(req *DetachVPNGatewayRequest) (err error) {
	// NRE
	err = c.client.Do("DetachVpnGateway", "POST", "/", req, nil)
	return
}

// DisableVGWRoutePropagation disables a virtual private gateway from
// propagating routes to a specified route table of a
func (c *EC2) DisableVGWRoutePropagation(req *DisableVGWRoutePropagationRequest) (err error) {
	// NRE
	err = c.client.Do("DisableVgwRoutePropagation", "POST", "/", req, nil)
	return
}

// DisableVPCClassicLink disables ClassicLink for a You cannot disable
// ClassicLink for a VPC that has EC2-Classic instances linked to it.
func (c *EC2) DisableVPCClassicLink(req *DisableVPCClassicLinkRequest) (resp *DisableVPCClassicLinkResult, err error) {
	resp = &DisableVPCClassicLinkResult{}
	err = c.client.Do("DisableVpcClassicLink", "POST", "/", req, resp)
	return
}

// DisassociateAddress disassociates an Elastic IP address from the
// instance or network interface it's associated with. An Elastic IP
// address is for use in either the EC2-Classic platform or in a For more
// information, see Elastic IP Addresses in the Amazon Elastic Compute
// Cloud User Guide for Linux This is an idempotent operation. If you
// perform the operation more than once, Amazon EC2 doesn't return an
// error.
func (c *EC2) DisassociateAddress(req *DisassociateAddressRequest) (err error) {
	// NRE
	err = c.client.Do("DisassociateAddress", "POST", "/", req, nil)
	return
}

// DisassociateRouteTable disassociates a subnet from a route table. After
// you perform this action, the subnet no longer uses the routes in the
// route table. Instead, it uses the routes in the VPC's main route table.
// For more information about route tables, see Route Tables in the Amazon
// Virtual Private Cloud User Guide
func (c *EC2) DisassociateRouteTable(req *DisassociateRouteTableRequest) (err error) {
	// NRE
	err = c.client.Do("DisassociateRouteTable", "POST", "/", req, nil)
	return
}

// EnableVGWRoutePropagation enables a virtual private gateway to propagate
// routes to the specified route table of a
func (c *EC2) EnableVGWRoutePropagation(req *EnableVGWRoutePropagationRequest) (err error) {
	// NRE
	err = c.client.Do("EnableVgwRoutePropagation", "POST", "/", req, nil)
	return
}

// EnableVolumeIO enables I/O operations for a volume that had I/O
// operations disabled because the data on the volume was potentially
// inconsistent.
func (c *EC2) EnableVolumeIO(req *EnableVolumeIORequest) (err error) {
	// NRE
	err = c.client.Do("EnableVolumeIO", "POST", "/", req, nil)
	return
}

// EnableVPCClassicLink enables a VPC for ClassicLink. You can then link
// EC2-Classic instances to your ClassicLink-enabled VPC to allow
// communication over private IP addresses. You cannot enable your VPC for
// ClassicLink if any of your VPC's route tables have existing routes for
// address ranges within the 10.0.0.0/8 IP address range, excluding local
// routes for VPCs in the 10.0.0.0/16 and 10.1.0.0/16 IP address ranges.
// For more information, see ClassicLink in the Amazon Elastic Compute
// Cloud User Guide for Linux.
func (c *EC2) EnableVPCClassicLink(req *EnableVPCClassicLinkRequest) (resp *EnableVPCClassicLinkResult, err error) {
	resp = &EnableVPCClassicLinkResult{}
	err = c.client.Do("EnableVpcClassicLink", "POST", "/", req, resp)
	return
}

// GetConsoleOutput gets the console output for the specified instance.
// Instances do not have a physical monitor through which you can view
// their console output. They also lack physical controls that allow you to
// power up, reboot, or shut them down. To allow these actions, we provide
// them through the Amazon EC2 API and command line interface. Instance
// console output is buffered and posted shortly after instance boot,
// reboot, and termination. Amazon EC2 preserves the most recent 64 KB
// output which is available for at least one hour after the most recent
// post. For Linux/Unix instances, the instance console output displays the
// exact console output that would normally be displayed on a physical
// monitor attached to a machine. This output is buffered because the
// instance produces it and then posts it to a store where the instance's
// owner can retrieve it. For Windows instances, the instance console
// output displays the last three system event log errors.
func (c *EC2) GetConsoleOutput(req *GetConsoleOutputRequest) (resp *GetConsoleOutputResult, err error) {
	resp = &GetConsoleOutputResult{}
	err = c.client.Do("GetConsoleOutput", "POST", "/", req, resp)
	return
}

// GetPasswordData retrieves the encrypted administrator password for an
// instance running Windows. The Windows password is generated at boot if
// the EC2Config service plugin, Ec2SetPassword , is enabled. This usually
// only happens the first time an AMI is launched, and then Ec2SetPassword
// is automatically disabled. The password is not generated for rebundled
// AMIs unless Ec2SetPassword is enabled before bundling. The password is
// encrypted using the key pair that you specified when you launched the
// instance. You must provide the corresponding key pair file. Password
// generation and encryption takes a few moments. We recommend that you
// wait up to 15 minutes after launching an instance before trying to
// retrieve the generated password.
func (c *EC2) GetPasswordData(req *GetPasswordDataRequest) (resp *GetPasswordDataResult, err error) {
	resp = &GetPasswordDataResult{}
	err = c.client.Do("GetPasswordData", "POST", "/", req, resp)
	return
}

// ImportInstance creates an import instance task using metadata from the
// specified disk image. After importing the image, you then upload it
// using the command in the EC2 command line tools. For more information,
// see Using the Command Line Tools to Import Your Virtual Machine to
// Amazon EC2
func (c *EC2) ImportInstance(req *ImportInstanceRequest) (resp *ImportInstanceResult, err error) {
	resp = &ImportInstanceResult{}
	err = c.client.Do("ImportInstance", "POST", "/", req, resp)
	return
}

// ImportKeyPair imports the public key from an RSA key pair that you
// created with a third-party tool. Compare this with CreateKeyPair , in
// which AWS creates the key pair and gives the keys to you keeps a copy of
// the public key). With ImportKeyPair, you create the key pair and give
// AWS just the public key. The private key is never transferred between
// you and For more information about key pairs, see Key Pairs in the
// Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) ImportKeyPair(req *ImportKeyPairRequest) (resp *ImportKeyPairResult, err error) {
	resp = &ImportKeyPairResult{}
	err = c.client.Do("ImportKeyPair", "POST", "/", req, resp)
	return
}

// ImportVolume creates an import volume task using metadata from the
// specified disk image. After importing the image, you then upload it
// using the command in the Amazon EC2 command-line interface tools. For
// more information, see Using the Command Line Tools to Import Your
// Virtual Machine to Amazon EC2 in the Amazon Elastic Compute Cloud User
// Guide for Linux
func (c *EC2) ImportVolume(req *ImportVolumeRequest) (resp *ImportVolumeResult, err error) {
	resp = &ImportVolumeResult{}
	err = c.client.Do("ImportVolume", "POST", "/", req, resp)
	return
}

// ModifyImageAttribute modifies the specified attribute of the specified
// You can specify only one attribute at a time. AWS Marketplace product
// codes cannot be modified. Images with an AWS Marketplace product code
// cannot be made public.
func (c *EC2) ModifyImageAttribute(req *ModifyImageAttributeRequest) (err error) {
	// NRE
	err = c.client.Do("ModifyImageAttribute", "POST", "/", req, nil)
	return
}

// ModifyInstanceAttribute modifies the specified attribute of the
// specified instance. You can specify only one attribute at a time. To
// modify some attributes, the instance must be stopped. For more
// information, see Modifying Attributes of a Stopped Instance in the
// Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) ModifyInstanceAttribute(req *ModifyInstanceAttributeRequest) (err error) {
	// NRE
	err = c.client.Do("ModifyInstanceAttribute", "POST", "/", req, nil)
	return
}

// ModifyNetworkInterfaceAttribute modifies the specified network interface
// attribute. You can specify only one attribute at a time.
func (c *EC2) ModifyNetworkInterfaceAttribute(req *ModifyNetworkInterfaceAttributeRequest) (err error) {
	// NRE
	err = c.client.Do("ModifyNetworkInterfaceAttribute", "POST", "/", req, nil)
	return
}

// ModifyReservedInstances modifies the Availability Zone, instance count,
// instance type, or network platform (EC2-Classic or EC2-VPC) of your
// Reserved Instances. The Reserved Instances to be modified must be
// identical, except for Availability Zone, network platform, and instance
// type. For more information, see Modifying Reserved Instances in the
// Amazon Elastic Compute Cloud User Guide for Linux.
func (c *EC2) ModifyReservedInstances(req *ModifyReservedInstancesRequest) (resp *ModifyReservedInstancesResult, err error) {
	resp = &ModifyReservedInstancesResult{}
	err = c.client.Do("ModifyReservedInstances", "POST", "/", req, resp)
	return
}

// ModifySnapshotAttribute adds or removes permission settings for the
// specified snapshot. You may add or remove specified AWS account IDs from
// a snapshot's list of create volume permissions, but you cannot do both
// in a single API call. If you need to both add and remove account IDs for
// a snapshot, you must use multiple API calls. For more information on
// modifying snapshot permissions, see Sharing Snapshots in the Amazon
// Elastic Compute Cloud User Guide for Linux Snapshots with AWS
// Marketplace product codes cannot be made public.
func (c *EC2) ModifySnapshotAttribute(req *ModifySnapshotAttributeRequest) (err error) {
	// NRE
	err = c.client.Do("ModifySnapshotAttribute", "POST", "/", req, nil)
	return
}

// ModifySubnetAttribute is undocumented.
func (c *EC2) ModifySubnetAttribute(req *ModifySubnetAttributeRequest) (err error) {
	// NRE
	err = c.client.Do("ModifySubnetAttribute", "POST", "/", req, nil)
	return
}

// ModifyVolumeAttribute modifies a volume attribute. By default, all I/O
// operations for the volume are suspended when the data on the volume is
// determined to be potentially inconsistent, to prevent undetectable,
// latent data corruption. The I/O access to the volume can be resumed by
// first enabling I/O access and then checking the data consistency on your
// volume. You can change the default behavior to resume I/O operations. We
// recommend that you change this only for boot volumes or for volumes that
// are stateless or disposable.
func (c *EC2) ModifyVolumeAttribute(req *ModifyVolumeAttributeRequest) (err error) {
	// NRE
	err = c.client.Do("ModifyVolumeAttribute", "POST", "/", req, nil)
	return
}

// ModifyVPCAttribute is undocumented.
func (c *EC2) ModifyVPCAttribute(req *ModifyVPCAttributeRequest) (err error) {
	// NRE
	err = c.client.Do("ModifyVpcAttribute", "POST", "/", req, nil)
	return
}

// MonitorInstances enables monitoring for a running instance. For more
// information about monitoring instances, see Monitoring Your Instances
// and Volumes in the Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) MonitorInstances(req *MonitorInstancesRequest) (resp *MonitorInstancesResult, err error) {
	resp = &MonitorInstancesResult{}
	err = c.client.Do("MonitorInstances", "POST", "/", req, resp)
	return
}

// PurchaseReservedInstancesOffering purchases a Reserved Instance for use
// with your account. With Amazon EC2 Reserved Instances, you obtain a
// capacity reservation for a certain instance configuration over a
// specified period of time. You pay a lower usage rate than with On-Demand
// instances for the time that you actually use the capacity reservation.
// Use DescribeReservedInstancesOfferings to get a list of Reserved
// Instance offerings that match your specifications. After you've
// purchased a Reserved Instance, you can check for your new Reserved
// Instance with DescribeReservedInstances For more information, see
// Reserved Instances and Reserved Instance Marketplace in the Amazon
// Elastic Compute Cloud User Guide for Linux
func (c *EC2) PurchaseReservedInstancesOffering(req *PurchaseReservedInstancesOfferingRequest) (resp *PurchaseReservedInstancesOfferingResult, err error) {
	resp = &PurchaseReservedInstancesOfferingResult{}
	err = c.client.Do("PurchaseReservedInstancesOffering", "POST", "/", req, resp)
	return
}

// RebootInstances requests a reboot of one or more instances. This
// operation is asynchronous; it only queues a request to reboot the
// specified instances. The operation succeeds if the instances are valid
// and belong to you. Requests to reboot terminated instances are ignored.
// If a Linux/Unix instance does not cleanly shut down within four minutes,
// Amazon EC2 performs a hard reboot. For more information about
// troubleshooting, see Getting Console Output and Rebooting Instances in
// the Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) RebootInstances(req *RebootInstancesRequest) (err error) {
	// NRE
	err = c.client.Do("RebootInstances", "POST", "/", req, nil)
	return
}

// RegisterImage registers an When you're creating an this is the final
// step you must complete before you can launch an instance from the For
// more information about creating AMIs, see Creating Your Own AMIs in the
// Amazon Elastic Compute Cloud User Guide for Linux For Amazon EBS-backed
// instances, CreateImage creates and registers the AMI in a single
// request, so you don't have to register the AMI yourself. You can also
// use RegisterImage to create an Amazon EBS-backed AMI from a snapshot of
// a root device volume. For more information, see Launching an Instance
// from a Snapshot in the Amazon Elastic Compute Cloud User Guide for Linux
// If needed, you can deregister an AMI at any time. Any modifications you
// make to an AMI backed by an instance store volume invalidates its
// registration. If you make changes to an image, deregister the previous
// image and register the new image. You can't register an image where a
// secondary (non-root) snapshot has AWS Marketplace product codes.
func (c *EC2) RegisterImage(req *RegisterImageRequest) (resp *RegisterImageResult, err error) {
	resp = &RegisterImageResult{}
	err = c.client.Do("RegisterImage", "POST", "/", req, resp)
	return
}

// RejectVPCPeeringConnection rejects a VPC peering connection request. The
// VPC peering connection must be in the pending-acceptance state. Use the
// DescribeVpcPeeringConnections request to view your outstanding VPC
// peering connection requests. To delete an active VPC peering connection,
// or to delete a VPC peering connection request that you initiated, use
// DeleteVpcPeeringConnection
func (c *EC2) RejectVPCPeeringConnection(req *RejectVPCPeeringConnectionRequest) (resp *RejectVPCPeeringConnectionResult, err error) {
	resp = &RejectVPCPeeringConnectionResult{}
	err = c.client.Do("RejectVpcPeeringConnection", "POST", "/", req, resp)
	return
}

// ReleaseAddress releases the specified Elastic IP address. After
// releasing an Elastic IP address, it is released to the IP address pool
// and might be unavailable to you. Be sure to update your DNS records and
// any servers or devices that communicate with the address. If you attempt
// to release an Elastic IP address that you already released, you'll get
// an AuthFailure error if the address is already allocated to another AWS
// account. [EC2-Classic, default Releasing an Elastic IP address
// automatically disassociates it from any instance that it's associated
// with. To disassociate an Elastic IP address without releasing it, use
// DisassociateAddress [Nondefault You must use DisassociateAddress to
// disassociate the Elastic IP address before you try to release it.
// Otherwise, Amazon EC2 returns an error InvalidIPAddress.InUse
func (c *EC2) ReleaseAddress(req *ReleaseAddressRequest) (err error) {
	// NRE
	err = c.client.Do("ReleaseAddress", "POST", "/", req, nil)
	return
}

// ReplaceNetworkACLAssociation changes which network ACL a subnet is
// associated with. By default when you create a subnet, it's automatically
// associated with the default network For more information about network
// ACLs, see Network ACLs in the Amazon Virtual Private Cloud User Guide
func (c *EC2) ReplaceNetworkACLAssociation(req *ReplaceNetworkACLAssociationRequest) (resp *ReplaceNetworkACLAssociationResult, err error) {
	resp = &ReplaceNetworkACLAssociationResult{}
	err = c.client.Do("ReplaceNetworkAclAssociation", "POST", "/", req, resp)
	return
}

// ReplaceNetworkACLEntry replaces an entry (rule) in a network For more
// information about network ACLs, see Network ACLs in the Amazon Virtual
// Private Cloud User Guide
func (c *EC2) ReplaceNetworkACLEntry(req *ReplaceNetworkACLEntryRequest) (err error) {
	// NRE
	err = c.client.Do("ReplaceNetworkAclEntry", "POST", "/", req, nil)
	return
}

// ReplaceRoute replaces an existing route within a route table in a You
// must provide only one of the following: Internet gateway or virtual
// private gateway, NAT instance, VPC peering connection, or network
// interface. For more information about route tables, see Route Tables in
// the Amazon Virtual Private Cloud User Guide
func (c *EC2) ReplaceRoute(req *ReplaceRouteRequest) (err error) {
	// NRE
	err = c.client.Do("ReplaceRoute", "POST", "/", req, nil)
	return
}

// ReplaceRouteTableAssociation changes the route table associated with a
// given subnet in a After the operation completes, the subnet uses the
// routes in the new route table it's associated with. For more information
// about route tables, see Route Tables in the Amazon Virtual Private Cloud
// User Guide You can also use ReplaceRouteTableAssociation to change which
// table is the main route table in the You just specify the main route
// table's association ID and the route table to be the new main route
// table.
func (c *EC2) ReplaceRouteTableAssociation(req *ReplaceRouteTableAssociationRequest) (resp *ReplaceRouteTableAssociationResult, err error) {
	resp = &ReplaceRouteTableAssociationResult{}
	err = c.client.Do("ReplaceRouteTableAssociation", "POST", "/", req, resp)
	return
}

// ReportInstanceStatus submits feedback about the status of an instance.
// The instance must be in the running state. If your experience with the
// instance differs from the instance status returned by
// DescribeInstanceStatus , use ReportInstanceStatus to report your
// experience with the instance. Amazon EC2 collects this information to
// improve the accuracy of status checks. Use of this action does not
// change the value returned by DescribeInstanceStatus
func (c *EC2) ReportInstanceStatus(req *ReportInstanceStatusRequest) (err error) {
	// NRE
	err = c.client.Do("ReportInstanceStatus", "POST", "/", req, nil)
	return
}

// RequestSpotInstances creates a Spot Instance request. Spot Instances are
// instances that Amazon EC2 starts on your behalf when the maximum price
// that you specify exceeds the current Spot Price. Amazon EC2 periodically
// sets the Spot Price based on available Spot Instance capacity and
// current Spot Instance requests. For more information, see Spot Instance
// Requests in the Amazon Elastic Compute Cloud User Guide for Linux Users
// must be subscribed to the required product to run an instance with AWS
// Marketplace product codes.
func (c *EC2) RequestSpotInstances(req *RequestSpotInstancesRequest) (resp *RequestSpotInstancesResult, err error) {
	resp = &RequestSpotInstancesResult{}
	err = c.client.Do("RequestSpotInstances", "POST", "/", req, resp)
	return
}

// ResetImageAttribute resets an attribute of an AMI to its default value.
// The productCodes attribute can't be reset.
func (c *EC2) ResetImageAttribute(req *ResetImageAttributeRequest) (err error) {
	// NRE
	err = c.client.Do("ResetImageAttribute", "POST", "/", req, nil)
	return
}

// ResetInstanceAttribute resets an attribute of an instance to its default
// value. To reset the kernel or ramdisk , the instance must be in a
// stopped state. To reset the SourceDestCheck , the instance can be either
// running or stopped. The SourceDestCheck attribute controls whether
// source/destination checking is enabled. The default value is true ,
// which means checking is enabled. This value must be false for a NAT
// instance to perform For more information, see NAT Instances in the
// Amazon Virtual Private Cloud User Guide
func (c *EC2) ResetInstanceAttribute(req *ResetInstanceAttributeRequest) (err error) {
	// NRE
	err = c.client.Do("ResetInstanceAttribute", "POST", "/", req, nil)
	return
}

// ResetNetworkInterfaceAttribute resets a network interface attribute. You
// can specify only one attribute at a time.
func (c *EC2) ResetNetworkInterfaceAttribute(req *ResetNetworkInterfaceAttributeRequest) (err error) {
	// NRE
	err = c.client.Do("ResetNetworkInterfaceAttribute", "POST", "/", req, nil)
	return
}

// ResetSnapshotAttribute resets permission settings for the specified
// snapshot. For more information on modifying snapshot permissions, see
// Sharing Snapshots in the Amazon Elastic Compute Cloud User Guide for
// Linux
func (c *EC2) ResetSnapshotAttribute(req *ResetSnapshotAttributeRequest) (err error) {
	// NRE
	err = c.client.Do("ResetSnapshotAttribute", "POST", "/", req, nil)
	return
}

// RevokeSecurityGroupEgress removes one or more egress rules from a
// security group for EC2-VPC. The values that you specify in the revoke
// request (for example, ports) must match the existing rule's values for
// the rule to be revoked. Each rule consists of the protocol and the range
// or source security group. For the TCP and UDP protocols, you must also
// specify the destination port or range of ports. For the protocol, you
// must also specify the type and code. Rule changes are propagated to
// instances within the security group as quickly as possible. However, a
// small delay might occur.
func (c *EC2) RevokeSecurityGroupEgress(req *RevokeSecurityGroupEgressRequest) (err error) {
	// NRE
	err = c.client.Do("RevokeSecurityGroupEgress", "POST", "/", req, nil)
	return
}

// RevokeSecurityGroupIngress removes one or more ingress rules from a
// security group. The values that you specify in the revoke request (for
// example, ports) must match the existing rule's values for the rule to be
// removed. Each rule consists of the protocol and the range or source
// security group. For the TCP and UDP protocols, you must also specify the
// destination port or range of ports. For the protocol, you must also
// specify the type and code. Rule changes are propagated to instances
// within the security group as quickly as possible. However, a small delay
// might occur.
func (c *EC2) RevokeSecurityGroupIngress(req *RevokeSecurityGroupIngressRequest) (err error) {
	// NRE
	err = c.client.Do("RevokeSecurityGroupIngress", "POST", "/", req, nil)
	return
}

// RunInstances launches the specified number of instances using an AMI for
// which you have permissions. When you launch an instance, it enters the
// pending state. After the instance is ready for you, it enters the
// running state. To check the state of your instance, call
// DescribeInstances If you don't specify a security group when launching
// an instance, Amazon EC2 uses the default security group. For more
// information, see Security Groups in the Amazon Elastic Compute Cloud
// User Guide for Linux Linux instances have access to the public key of
// the key pair at boot. You can use this key to provide secure access to
// the instance. Amazon EC2 public images use this feature to provide
// secure access without passwords. For more information, see Key Pairs in
// the Amazon Elastic Compute Cloud User Guide for Linux You can provide
// optional user data when launching an instance. For more information, see
// Instance Metadata in the Amazon Elastic Compute Cloud User Guide for
// Linux If any of the AMIs have a product code attached for which the user
// has not subscribed, RunInstances fails. T2 instance types can only be
// launched into a If you do not have a default or if you do not specify a
// subnet ID in the request, RunInstances fails. For more information about
// troubleshooting, see What To Do If An Instance Immediately Terminates ,
// and Troubleshooting Connecting to Your Instance in the Amazon Elastic
// Compute Cloud User Guide for Linux
func (c *EC2) RunInstances(req *RunInstancesRequest) (resp *Reservation, err error) {
	resp = &Reservation{}
	err = c.client.Do("RunInstances", "POST", "/", req, resp)
	return
}

// StartInstances starts an Amazon EBS-backed AMI that you've previously
// stopped. Instances that use Amazon EBS volumes as their root devices can
// be quickly stopped and started. When an instance is stopped, the compute
// resources are released and you are not billed for hourly instance usage.
// However, your root partition Amazon EBS volume remains, continues to
// persist your data, and you are charged for Amazon EBS volume usage. You
// can restart your instance at any time. Each time you transition an
// instance from stopped to started, Amazon EC2 charges a full instance
// hour, even if transitions happen multiple times within a single hour.
// Before stopping an instance, make sure it is in a state from which it
// can be restarted. Stopping an instance does not preserve data stored in
// Performing this operation on an instance that uses an instance store as
// its root device returns an error. For more information, see Stopping
// Instances in the Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) StartInstances(req *StartInstancesRequest) (resp *StartInstancesResult, err error) {
	resp = &StartInstancesResult{}
	err = c.client.Do("StartInstances", "POST", "/", req, resp)
	return
}

// StopInstances stops an Amazon EBS-backed instance. Each time you
// transition an instance from stopped to started, Amazon EC2 charges a
// full instance hour, even if transitions happen multiple times within a
// single hour. You can't start or stop Spot Instances. Instances that use
// Amazon EBS volumes as their root devices can be quickly stopped and
// started. When an instance is stopped, the compute resources are released
// and you are not billed for hourly instance usage. However, your root
// partition Amazon EBS volume remains, continues to persist your data, and
// you are charged for Amazon EBS volume usage. You can restart your
// instance at any time. Before stopping an instance, make sure it is in a
// state from which it can be restarted. Stopping an instance does not
// preserve data stored in Performing this operation on an instance that
// uses an instance store as its root device returns an error. You can
// stop, start, and terminate EBS-backed instances. You can only terminate
// instance store-backed instances. What happens to an instance differs if
// you stop it or terminate it. For example, when you stop an instance, the
// root device and any other devices attached to the instance persist. When
// you terminate an instance, the root device and any other devices
// attached during the instance launch are automatically deleted. For more
// information about the differences between stopping and terminating
// instances, see Instance Lifecycle in the Amazon Elastic Compute Cloud
// User Guide for Linux For more information about troubleshooting, see
// Troubleshooting Stopping Your Instance in the Amazon Elastic Compute
// Cloud User Guide for Linux
func (c *EC2) StopInstances(req *StopInstancesRequest) (resp *StopInstancesResult, err error) {
	resp = &StopInstancesResult{}
	err = c.client.Do("StopInstances", "POST", "/", req, resp)
	return
}

// TerminateInstances shuts down one or more instances. This operation is
// idempotent; if you terminate an instance more than once, each call
// succeeds. Terminated instances remain visible after termination (for
// approximately one hour). By default, Amazon EC2 deletes all Amazon EBS
// volumes that were attached when the instance launched. Volumes attached
// after instance launch continue running. You can stop, start, and
// terminate EBS-backed instances. You can only terminate instance
// store-backed instances. What happens to an instance differs if you stop
// it or terminate it. For example, when you stop an instance, the root
// device and any other devices attached to the instance persist. When you
// terminate an instance, the root device and any other devices attached
// during the instance launch are automatically deleted. For more
// information about the differences between stopping and terminating
// instances, see Instance Lifecycle in the Amazon Elastic Compute Cloud
// User Guide for Linux For more information about troubleshooting, see
// Troubleshooting Terminating Your Instance in the Amazon Elastic Compute
// Cloud User Guide for Linux
func (c *EC2) TerminateInstances(req *TerminateInstancesRequest) (resp *TerminateInstancesResult, err error) {
	resp = &TerminateInstancesResult{}
	err = c.client.Do("TerminateInstances", "POST", "/", req, resp)
	return
}

// UnassignPrivateIPAddresses unassigns one or more secondary private IP
// addresses from a network interface.
func (c *EC2) UnassignPrivateIPAddresses(req *UnassignPrivateIPAddressesRequest) (err error) {
	// NRE
	err = c.client.Do("UnassignPrivateIpAddresses", "POST", "/", req, nil)
	return
}

// UnmonitorInstances disables monitoring for a running instance. For more
// information about monitoring instances, see Monitoring Your Instances
// and Volumes in the Amazon Elastic Compute Cloud User Guide for Linux
func (c *EC2) UnmonitorInstances(req *UnmonitorInstancesRequest) (resp *UnmonitorInstancesResult, err error) {
	resp = &UnmonitorInstancesResult{}
	err = c.client.Do("UnmonitorInstances", "POST", "/", req, resp)
	return
}

// AcceptVPCPeeringConnectionRequest is undocumented.
type AcceptVPCPeeringConnectionRequest struct {
	DryRun                 aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	VPCPeeringConnectionID aws.StringValue  `ec2:"VpcPeeringConnectionId" xml:"vpcPeeringConnectionId"`
}

// AcceptVPCPeeringConnectionResult is undocumented.
type AcceptVPCPeeringConnectionResult struct {
	VPCPeeringConnection *VPCPeeringConnection `ec2:"VpcPeeringConnection" xml:"vpcPeeringConnection"`
}

// AccountAttribute is undocumented.
type AccountAttribute struct {
	AttributeName   aws.StringValue         `ec2:"AttributeName" xml:"attributeName"`
	AttributeValues []AccountAttributeValue `ec2:"AttributeValues" xml:"attributeValueSet>item"`
}

// Possible values for EC2.
const (
	AccountAttributeNameDefaultVPC         = "default-vpc"
	AccountAttributeNameSupportedPlatforms = "supported-platforms"
)

// AccountAttributeValue is undocumented.
type AccountAttributeValue struct {
	AttributeValue aws.StringValue `ec2:"AttributeValue" xml:"attributeValue"`
}

// Address is undocumented.
type Address struct {
	AllocationID            aws.StringValue `ec2:"AllocationId" xml:"allocationId"`
	AssociationID           aws.StringValue `ec2:"AssociationId" xml:"associationId"`
	Domain                  aws.StringValue `ec2:"Domain" xml:"domain"`
	InstanceID              aws.StringValue `ec2:"InstanceId" xml:"instanceId"`
	NetworkInterfaceID      aws.StringValue `ec2:"NetworkInterfaceId" xml:"networkInterfaceId"`
	NetworkInterfaceOwnerID aws.StringValue `ec2:"NetworkInterfaceOwnerId" xml:"networkInterfaceOwnerId"`
	PrivateIPAddress        aws.StringValue `ec2:"PrivateIpAddress" xml:"privateIpAddress"`
	PublicIP                aws.StringValue `ec2:"PublicIp" xml:"publicIp"`
}

// AllocateAddressRequest is undocumented.
type AllocateAddressRequest struct {
	Domain aws.StringValue  `ec2:"Domain" xml:"Domain"`
	DryRun aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
}

// AllocateAddressResult is undocumented.
type AllocateAddressResult struct {
	AllocationID aws.StringValue `ec2:"AllocationId" xml:"allocationId"`
	Domain       aws.StringValue `ec2:"Domain" xml:"domain"`
	PublicIP     aws.StringValue `ec2:"PublicIp" xml:"publicIp"`
}

// Possible values for EC2.
const (
	ArchitectureValuesI386  = "i386"
	ArchitectureValuesX8664 = "x86_64"
)

// AssignPrivateIPAddressesRequest is undocumented.
type AssignPrivateIPAddressesRequest struct {
	AllowReassignment              aws.BooleanValue `ec2:"AllowReassignment" xml:"allowReassignment"`
	NetworkInterfaceID             aws.StringValue  `ec2:"NetworkInterfaceId" xml:"networkInterfaceId"`
	PrivateIPAddresses             []string         `ec2:"PrivateIpAddresses" xml:"privateIpAddress>PrivateIpAddress"`
	SecondaryPrivateIPAddressCount aws.IntegerValue `ec2:"SecondaryPrivateIpAddressCount" xml:"secondaryPrivateIpAddressCount"`
}

// AssociateAddressRequest is undocumented.
type AssociateAddressRequest struct {
	AllocationID       aws.StringValue  `ec2:"AllocationId" xml:"AllocationId"`
	AllowReassociation aws.BooleanValue `ec2:"AllowReassociation" xml:"allowReassociation"`
	DryRun             aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	InstanceID         aws.StringValue  `ec2:"InstanceId" xml:"InstanceId"`
	NetworkInterfaceID aws.StringValue  `ec2:"NetworkInterfaceId" xml:"networkInterfaceId"`
	PrivateIPAddress   aws.StringValue  `ec2:"PrivateIpAddress" xml:"privateIpAddress"`
	PublicIP           aws.StringValue  `ec2:"PublicIp" xml:"PublicIp"`
}

// AssociateAddressResult is undocumented.
type AssociateAddressResult struct {
	AssociationID aws.StringValue `ec2:"AssociationId" xml:"associationId"`
}

// AssociateDHCPOptionsRequest is undocumented.
type AssociateDHCPOptionsRequest struct {
	DHCPOptionsID aws.StringValue  `ec2:"DhcpOptionsId" xml:"DhcpOptionsId"`
	DryRun        aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	VPCID         aws.StringValue  `ec2:"VpcId" xml:"VpcId"`
}

// AssociateRouteTableRequest is undocumented.
type AssociateRouteTableRequest struct {
	DryRun       aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	RouteTableID aws.StringValue  `ec2:"RouteTableId" xml:"routeTableId"`
	SubnetID     aws.StringValue  `ec2:"SubnetId" xml:"subnetId"`
}

// AssociateRouteTableResult is undocumented.
type AssociateRouteTableResult struct {
	AssociationID aws.StringValue `ec2:"AssociationId" xml:"associationId"`
}

// AttachClassicLinkVPCRequest is undocumented.
type AttachClassicLinkVPCRequest struct {
	DryRun     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Groups     []string         `ec2:"SecurityGroupId" xml:"SecurityGroupId>groupId"`
	InstanceID aws.StringValue  `ec2:"InstanceId" xml:"instanceId"`
	VPCID      aws.StringValue  `ec2:"VpcId" xml:"vpcId"`
}

// AttachClassicLinkVPCResult is undocumented.
type AttachClassicLinkVPCResult struct {
	Return aws.BooleanValue `ec2:"Return" xml:"return"`
}

// AttachInternetGatewayRequest is undocumented.
type AttachInternetGatewayRequest struct {
	DryRun            aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	InternetGatewayID aws.StringValue  `ec2:"InternetGatewayId" xml:"internetGatewayId"`
	VPCID             aws.StringValue  `ec2:"VpcId" xml:"vpcId"`
}

// AttachNetworkInterfaceRequest is undocumented.
type AttachNetworkInterfaceRequest struct {
	DeviceIndex        aws.IntegerValue `ec2:"DeviceIndex" xml:"deviceIndex"`
	DryRun             aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	InstanceID         aws.StringValue  `ec2:"InstanceId" xml:"instanceId"`
	NetworkInterfaceID aws.StringValue  `ec2:"NetworkInterfaceId" xml:"networkInterfaceId"`
}

// AttachNetworkInterfaceResult is undocumented.
type AttachNetworkInterfaceResult struct {
	AttachmentID aws.StringValue `ec2:"AttachmentId" xml:"attachmentId"`
}

// AttachVolumeRequest is undocumented.
type AttachVolumeRequest struct {
	Device     aws.StringValue  `ec2:"Device" xml:"Device"`
	DryRun     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	InstanceID aws.StringValue  `ec2:"InstanceId" xml:"InstanceId"`
	VolumeID   aws.StringValue  `ec2:"VolumeId" xml:"VolumeId"`
}

// AttachVPNGatewayRequest is undocumented.
type AttachVPNGatewayRequest struct {
	DryRun       aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	VPCID        aws.StringValue  `ec2:"VpcId" xml:"VpcId"`
	VPNGatewayID aws.StringValue  `ec2:"VpnGatewayId" xml:"VpnGatewayId"`
}

// AttachVPNGatewayResult is undocumented.
type AttachVPNGatewayResult struct {
	VPCAttachment *VPCAttachment `ec2:"VpcAttachment" xml:"attachment"`
}

// Possible values for EC2.
const (
	AttachmentStatusAttached  = "attached"
	AttachmentStatusAttaching = "attaching"
	AttachmentStatusDetached  = "detached"
	AttachmentStatusDetaching = "detaching"
)

// AttributeBooleanValue is undocumented.
type AttributeBooleanValue struct {
	Value aws.BooleanValue `ec2:"Value" xml:"value"`
}

// AttributeValue is undocumented.
type AttributeValue struct {
	Value aws.StringValue `ec2:"Value" xml:"value"`
}

// AuthorizeSecurityGroupEgressRequest is undocumented.
type AuthorizeSecurityGroupEgressRequest struct {
	CIDRIP                     aws.StringValue  `ec2:"CidrIp" xml:"cidrIp"`
	DryRun                     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	FromPort                   aws.IntegerValue `ec2:"FromPort" xml:"fromPort"`
	GroupID                    aws.StringValue  `ec2:"GroupId" xml:"groupId"`
	IPPermissions              []IPPermission   `ec2:"IpPermissions" xml:"ipPermissions>item"`
	IPProtocol                 aws.StringValue  `ec2:"IpProtocol" xml:"ipProtocol"`
	SourceSecurityGroupName    aws.StringValue  `ec2:"SourceSecurityGroupName" xml:"sourceSecurityGroupName"`
	SourceSecurityGroupOwnerID aws.StringValue  `ec2:"SourceSecurityGroupOwnerId" xml:"sourceSecurityGroupOwnerId"`
	ToPort                     aws.IntegerValue `ec2:"ToPort" xml:"toPort"`
}

// AuthorizeSecurityGroupIngressRequest is undocumented.
type AuthorizeSecurityGroupIngressRequest struct {
	CIDRIP                     aws.StringValue  `ec2:"CidrIp" xml:"CidrIp"`
	DryRun                     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	FromPort                   aws.IntegerValue `ec2:"FromPort" xml:"FromPort"`
	GroupID                    aws.StringValue  `ec2:"GroupId" xml:"GroupId"`
	GroupName                  aws.StringValue  `ec2:"GroupName" xml:"GroupName"`
	IPPermissions              []IPPermission   `ec2:"IpPermissions" xml:"IpPermissions>item"`
	IPProtocol                 aws.StringValue  `ec2:"IpProtocol" xml:"IpProtocol"`
	SourceSecurityGroupName    aws.StringValue  `ec2:"SourceSecurityGroupName" xml:"SourceSecurityGroupName"`
	SourceSecurityGroupOwnerID aws.StringValue  `ec2:"SourceSecurityGroupOwnerId" xml:"SourceSecurityGroupOwnerId"`
	ToPort                     aws.IntegerValue `ec2:"ToPort" xml:"ToPort"`
}

// AvailabilityZone is undocumented.
type AvailabilityZone struct {
	Messages   []AvailabilityZoneMessage `ec2:"Messages" xml:"messageSet>item"`
	RegionName aws.StringValue           `ec2:"RegionName" xml:"regionName"`
	State      aws.StringValue           `ec2:"State" xml:"zoneState"`
	ZoneName   aws.StringValue           `ec2:"ZoneName" xml:"zoneName"`
}

// AvailabilityZoneMessage is undocumented.
type AvailabilityZoneMessage struct {
	Message aws.StringValue `ec2:"Message" xml:"message"`
}

// Possible values for EC2.
const (
	AvailabilityZoneStateAvailable = "available"
)

// BlobAttributeValue is undocumented.
type BlobAttributeValue struct {
	Value []byte `ec2:"Value" xml:"value"`
}

// BlockDeviceMapping is undocumented.
type BlockDeviceMapping struct {
	DeviceName  aws.StringValue `ec2:"DeviceName" xml:"deviceName"`
	EBS         *EBSBlockDevice `ec2:"Ebs" xml:"ebs"`
	NoDevice    aws.StringValue `ec2:"NoDevice" xml:"noDevice"`
	VirtualName aws.StringValue `ec2:"VirtualName" xml:"virtualName"`
}

// BundleInstanceRequest is undocumented.
type BundleInstanceRequest struct {
	DryRun     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	InstanceID aws.StringValue  `ec2:"InstanceId" xml:"InstanceId"`
	Storage    *Storage         `ec2:"Storage" xml:"Storage"`
}

// BundleInstanceResult is undocumented.
type BundleInstanceResult struct {
	BundleTask *BundleTask `ec2:"BundleTask" xml:"bundleInstanceTask"`
}

// BundleTask is undocumented.
type BundleTask struct {
	BundleID        aws.StringValue  `ec2:"BundleId" xml:"bundleId"`
	BundleTaskError *BundleTaskError `ec2:"BundleTaskError" xml:"error"`
	InstanceID      aws.StringValue  `ec2:"InstanceId" xml:"instanceId"`
	Progress        aws.StringValue  `ec2:"Progress" xml:"progress"`
	StartTime       time.Time        `ec2:"StartTime" xml:"startTime"`
	State           aws.StringValue  `ec2:"State" xml:"state"`
	Storage         *Storage         `ec2:"Storage" xml:"storage"`
	UpdateTime      time.Time        `ec2:"UpdateTime" xml:"updateTime"`
}

// BundleTaskError is undocumented.
type BundleTaskError struct {
	Code    aws.StringValue `ec2:"Code" xml:"code"`
	Message aws.StringValue `ec2:"Message" xml:"message"`
}

// Possible values for EC2.
const (
	BundleTaskStateBundling           = "bundling"
	BundleTaskStateCancelling         = "cancelling"
	BundleTaskStateComplete           = "complete"
	BundleTaskStateFailed             = "failed"
	BundleTaskStatePending            = "pending"
	BundleTaskStateStoring            = "storing"
	BundleTaskStateWaitingForShutdown = "waiting-for-shutdown"
)

// CancelBundleTaskRequest is undocumented.
type CancelBundleTaskRequest struct {
	BundleID aws.StringValue  `ec2:"BundleId" xml:"BundleId"`
	DryRun   aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
}

// CancelBundleTaskResult is undocumented.
type CancelBundleTaskResult struct {
	BundleTask *BundleTask `ec2:"BundleTask" xml:"bundleInstanceTask"`
}

// CancelConversionRequest is undocumented.
type CancelConversionRequest struct {
	ConversionTaskID aws.StringValue  `ec2:"ConversionTaskId" xml:"conversionTaskId"`
	DryRun           aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	ReasonMessage    aws.StringValue  `ec2:"ReasonMessage" xml:"reasonMessage"`
}

// CancelExportTaskRequest is undocumented.
type CancelExportTaskRequest struct {
	ExportTaskID aws.StringValue `ec2:"ExportTaskId" xml:"exportTaskId"`
}

// CancelReservedInstancesListingRequest is undocumented.
type CancelReservedInstancesListingRequest struct {
	ReservedInstancesListingID aws.StringValue `ec2:"ReservedInstancesListingId" xml:"reservedInstancesListingId"`
}

// CancelReservedInstancesListingResult is undocumented.
type CancelReservedInstancesListingResult struct {
	ReservedInstancesListings []ReservedInstancesListing `ec2:"ReservedInstancesListings" xml:"reservedInstancesListingsSet>item"`
}

// Possible values for EC2.
const (
	CancelSpotInstanceRequestStateActive    = "active"
	CancelSpotInstanceRequestStateCancelled = "cancelled"
	CancelSpotInstanceRequestStateClosed    = "closed"
	CancelSpotInstanceRequestStateCompleted = "completed"
	CancelSpotInstanceRequestStateOpen      = "open"
)

// CancelSpotInstanceRequestsRequest is undocumented.
type CancelSpotInstanceRequestsRequest struct {
	DryRun                 aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	SpotInstanceRequestIDs []string         `ec2:"SpotInstanceRequestId" xml:"SpotInstanceRequestId>SpotInstanceRequestId"`
}

// CancelSpotInstanceRequestsResult is undocumented.
type CancelSpotInstanceRequestsResult struct {
	CancelledSpotInstanceRequests []CancelledSpotInstanceRequest `ec2:"CancelledSpotInstanceRequests" xml:"spotInstanceRequestSet>item"`
}

// CancelledSpotInstanceRequest is undocumented.
type CancelledSpotInstanceRequest struct {
	SpotInstanceRequestID aws.StringValue `ec2:"SpotInstanceRequestId" xml:"spotInstanceRequestId"`
	State                 aws.StringValue `ec2:"State" xml:"state"`
}

// ClassicLinkInstance is undocumented.
type ClassicLinkInstance struct {
	Groups     []GroupIdentifier `ec2:"Groups" xml:"groupSet>item"`
	InstanceID aws.StringValue   `ec2:"InstanceId" xml:"instanceId"`
	Tags       []Tag             `ec2:"Tags" xml:"tagSet>item"`
	VPCID      aws.StringValue   `ec2:"VpcId" xml:"vpcId"`
}

// ConfirmProductInstanceRequest is undocumented.
type ConfirmProductInstanceRequest struct {
	DryRun      aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	InstanceID  aws.StringValue  `ec2:"InstanceId" xml:"InstanceId"`
	ProductCode aws.StringValue  `ec2:"ProductCode" xml:"ProductCode"`
}

// ConfirmProductInstanceResult is undocumented.
type ConfirmProductInstanceResult struct {
	OwnerID aws.StringValue `ec2:"OwnerId" xml:"ownerId"`
}

// Possible values for EC2.
const (
	ContainerFormatOva = "ova"
)

// ConversionTask is undocumented.
type ConversionTask struct {
	ConversionTaskID aws.StringValue            `ec2:"ConversionTaskId" xml:"conversionTaskId"`
	ExpirationTime   aws.StringValue            `ec2:"ExpirationTime" xml:"expirationTime"`
	ImportInstance   *ImportInstanceTaskDetails `ec2:"ImportInstance" xml:"importInstance"`
	ImportVolume     *ImportVolumeTaskDetails   `ec2:"ImportVolume" xml:"importVolume"`
	State            aws.StringValue            `ec2:"State" xml:"state"`
	StatusMessage    aws.StringValue            `ec2:"StatusMessage" xml:"statusMessage"`
	Tags             []Tag                      `ec2:"Tags" xml:"tagSet>item"`
}

// Possible values for EC2.
const (
	ConversionTaskStateActive     = "active"
	ConversionTaskStateCancelled  = "cancelled"
	ConversionTaskStateCancelling = "cancelling"
	ConversionTaskStateCompleted  = "completed"
)

// CopyImageRequest is undocumented.
type CopyImageRequest struct {
	ClientToken   aws.StringValue  `ec2:"ClientToken" xml:"ClientToken"`
	Description   aws.StringValue  `ec2:"Description" xml:"Description"`
	DryRun        aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Name          aws.StringValue  `ec2:"Name" xml:"Name"`
	SourceImageID aws.StringValue  `ec2:"SourceImageId" xml:"SourceImageId"`
	SourceRegion  aws.StringValue  `ec2:"SourceRegion" xml:"SourceRegion"`
}

// CopyImageResult is undocumented.
type CopyImageResult struct {
	ImageID aws.StringValue `ec2:"ImageId" xml:"imageId"`
}

// CopySnapshotRequest is undocumented.
type CopySnapshotRequest struct {
	Description       aws.StringValue  `ec2:"Description" xml:"Description"`
	DestinationRegion aws.StringValue  `ec2:"DestinationRegion" xml:"destinationRegion"`
	DryRun            aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	PresignedURL      aws.StringValue  `ec2:"PresignedUrl" xml:"presignedUrl"`
	SourceRegion      aws.StringValue  `ec2:"SourceRegion" xml:"SourceRegion"`
	SourceSnapshotID  aws.StringValue  `ec2:"SourceSnapshotId" xml:"SourceSnapshotId"`
}

// CopySnapshotResult is undocumented.
type CopySnapshotResult struct {
	SnapshotID aws.StringValue `ec2:"SnapshotId" xml:"snapshotId"`
}

// CreateCustomerGatewayRequest is undocumented.
type CreateCustomerGatewayRequest struct {
	BGPASN   aws.IntegerValue `ec2:"BgpAsn" xml:"BgpAsn"`
	DryRun   aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	PublicIP aws.StringValue  `ec2:"IpAddress" xml:"IpAddress"`
	Type     aws.StringValue  `ec2:"Type" xml:"Type"`
}

// CreateCustomerGatewayResult is undocumented.
type CreateCustomerGatewayResult struct {
	CustomerGateway *CustomerGateway `ec2:"CustomerGateway" xml:"customerGateway"`
}

// CreateDHCPOptionsRequest is undocumented.
type CreateDHCPOptionsRequest struct {
	DHCPConfigurations []NewDHCPConfiguration `ec2:"DhcpConfigurations" xml:"dhcpConfiguration>item"`
	DryRun             aws.BooleanValue       `ec2:"DryRun" xml:"dryRun"`
}

// CreateDHCPOptionsResult is undocumented.
type CreateDHCPOptionsResult struct {
	DHCPOptions *DHCPOptions `ec2:"DhcpOptions" xml:"dhcpOptions"`
}

// CreateImageRequest is undocumented.
type CreateImageRequest struct {
	BlockDeviceMappings []BlockDeviceMapping `ec2:"BlockDeviceMappings" xml:"blockDeviceMapping>BlockDeviceMapping"`
	Description         aws.StringValue      `ec2:"Description" xml:"description"`
	DryRun              aws.BooleanValue     `ec2:"DryRun" xml:"dryRun"`
	InstanceID          aws.StringValue      `ec2:"InstanceId" xml:"instanceId"`
	Name                aws.StringValue      `ec2:"Name" xml:"name"`
	NoReboot            aws.BooleanValue     `ec2:"NoReboot" xml:"noReboot"`
}

// CreateImageResult is undocumented.
type CreateImageResult struct {
	ImageID aws.StringValue `ec2:"ImageId" xml:"imageId"`
}

// CreateInstanceExportTaskRequest is undocumented.
type CreateInstanceExportTaskRequest struct {
	Description       aws.StringValue              `ec2:"Description" xml:"description"`
	ExportToS3Task    *ExportToS3TaskSpecification `ec2:"ExportToS3Task" xml:"exportToS3"`
	InstanceID        aws.StringValue              `ec2:"InstanceId" xml:"instanceId"`
	TargetEnvironment aws.StringValue              `ec2:"TargetEnvironment" xml:"targetEnvironment"`
}

// CreateInstanceExportTaskResult is undocumented.
type CreateInstanceExportTaskResult struct {
	ExportTask *ExportTask `ec2:"ExportTask" xml:"exportTask"`
}

// CreateInternetGatewayRequest is undocumented.
type CreateInternetGatewayRequest struct {
	DryRun aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
}

// CreateInternetGatewayResult is undocumented.
type CreateInternetGatewayResult struct {
	InternetGateway *InternetGateway `ec2:"InternetGateway" xml:"internetGateway"`
}

// CreateKeyPairRequest is undocumented.
type CreateKeyPairRequest struct {
	DryRun  aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	KeyName aws.StringValue  `ec2:"KeyName" xml:"KeyName"`
}

// CreateNetworkACLEntryRequest is undocumented.
type CreateNetworkACLEntryRequest struct {
	CIDRBlock    aws.StringValue  `ec2:"CidrBlock" xml:"cidrBlock"`
	DryRun       aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Egress       aws.BooleanValue `ec2:"Egress" xml:"egress"`
	ICMPTypeCode *ICMPTypeCode    `ec2:"Icmp" xml:"Icmp"`
	NetworkACLID aws.StringValue  `ec2:"NetworkAclId" xml:"networkAclId"`
	PortRange    *PortRange       `ec2:"PortRange" xml:"portRange"`
	Protocol     aws.StringValue  `ec2:"Protocol" xml:"protocol"`
	RuleAction   aws.StringValue  `ec2:"RuleAction" xml:"ruleAction"`
	RuleNumber   aws.IntegerValue `ec2:"RuleNumber" xml:"ruleNumber"`
}

// CreateNetworkACLRequest is undocumented.
type CreateNetworkACLRequest struct {
	DryRun aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	VPCID  aws.StringValue  `ec2:"VpcId" xml:"vpcId"`
}

// CreateNetworkACLResult is undocumented.
type CreateNetworkACLResult struct {
	NetworkACL *NetworkACL `ec2:"NetworkAcl" xml:"networkAcl"`
}

// CreateNetworkInterfaceRequest is undocumented.
type CreateNetworkInterfaceRequest struct {
	Description                    aws.StringValue                 `ec2:"Description" xml:"description"`
	DryRun                         aws.BooleanValue                `ec2:"DryRun" xml:"dryRun"`
	Groups                         []string                        `ec2:"SecurityGroupId" xml:"SecurityGroupId>SecurityGroupId"`
	PrivateIPAddress               aws.StringValue                 `ec2:"PrivateIpAddress" xml:"privateIpAddress"`
	PrivateIPAddresses             []PrivateIPAddressSpecification `ec2:"PrivateIpAddresses" xml:"privateIpAddresses>item"`
	SecondaryPrivateIPAddressCount aws.IntegerValue                `ec2:"SecondaryPrivateIpAddressCount" xml:"secondaryPrivateIpAddressCount"`
	SubnetID                       aws.StringValue                 `ec2:"SubnetId" xml:"subnetId"`
}

// CreateNetworkInterfaceResult is undocumented.
type CreateNetworkInterfaceResult struct {
	NetworkInterface *NetworkInterface `ec2:"NetworkInterface" xml:"networkInterface"`
}

// CreatePlacementGroupRequest is undocumented.
type CreatePlacementGroupRequest struct {
	DryRun    aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	GroupName aws.StringValue  `ec2:"GroupName" xml:"groupName"`
	Strategy  aws.StringValue  `ec2:"Strategy" xml:"strategy"`
}

// CreateReservedInstancesListingRequest is undocumented.
type CreateReservedInstancesListingRequest struct {
	ClientToken         aws.StringValue              `ec2:"ClientToken" xml:"clientToken"`
	InstanceCount       aws.IntegerValue             `ec2:"InstanceCount" xml:"instanceCount"`
	PriceSchedules      []PriceScheduleSpecification `ec2:"PriceSchedules" xml:"priceSchedules>item"`
	ReservedInstancesID aws.StringValue              `ec2:"ReservedInstancesId" xml:"reservedInstancesId"`
}

// CreateReservedInstancesListingResult is undocumented.
type CreateReservedInstancesListingResult struct {
	ReservedInstancesListings []ReservedInstancesListing `ec2:"ReservedInstancesListings" xml:"reservedInstancesListingsSet>item"`
}

// CreateRouteRequest is undocumented.
type CreateRouteRequest struct {
	DestinationCIDRBlock   aws.StringValue  `ec2:"DestinationCidrBlock" xml:"destinationCidrBlock"`
	DryRun                 aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	GatewayID              aws.StringValue  `ec2:"GatewayId" xml:"gatewayId"`
	InstanceID             aws.StringValue  `ec2:"InstanceId" xml:"instanceId"`
	NetworkInterfaceID     aws.StringValue  `ec2:"NetworkInterfaceId" xml:"networkInterfaceId"`
	RouteTableID           aws.StringValue  `ec2:"RouteTableId" xml:"routeTableId"`
	VPCPeeringConnectionID aws.StringValue  `ec2:"VpcPeeringConnectionId" xml:"vpcPeeringConnectionId"`
}

// CreateRouteTableRequest is undocumented.
type CreateRouteTableRequest struct {
	DryRun aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	VPCID  aws.StringValue  `ec2:"VpcId" xml:"vpcId"`
}

// CreateRouteTableResult is undocumented.
type CreateRouteTableResult struct {
	RouteTable *RouteTable `ec2:"RouteTable" xml:"routeTable"`
}

// CreateSecurityGroupRequest is undocumented.
type CreateSecurityGroupRequest struct {
	Description aws.StringValue  `ec2:"GroupDescription" xml:"GroupDescription"`
	DryRun      aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	GroupName   aws.StringValue  `ec2:"GroupName" xml:"GroupName"`
	VPCID       aws.StringValue  `ec2:"VpcId" xml:"VpcId"`
}

// CreateSecurityGroupResult is undocumented.
type CreateSecurityGroupResult struct {
	GroupID aws.StringValue `ec2:"GroupId" xml:"groupId"`
}

// CreateSnapshotRequest is undocumented.
type CreateSnapshotRequest struct {
	Description aws.StringValue  `ec2:"Description" xml:"Description"`
	DryRun      aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	VolumeID    aws.StringValue  `ec2:"VolumeId" xml:"VolumeId"`
}

// CreateSpotDatafeedSubscriptionRequest is undocumented.
type CreateSpotDatafeedSubscriptionRequest struct {
	Bucket aws.StringValue  `ec2:"Bucket" xml:"bucket"`
	DryRun aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Prefix aws.StringValue  `ec2:"Prefix" xml:"prefix"`
}

// CreateSpotDatafeedSubscriptionResult is undocumented.
type CreateSpotDatafeedSubscriptionResult struct {
	SpotDatafeedSubscription *SpotDatafeedSubscription `ec2:"SpotDatafeedSubscription" xml:"spotDatafeedSubscription"`
}

// CreateSubnetRequest is undocumented.
type CreateSubnetRequest struct {
	AvailabilityZone aws.StringValue  `ec2:"AvailabilityZone" xml:"AvailabilityZone"`
	CIDRBlock        aws.StringValue  `ec2:"CidrBlock" xml:"CidrBlock"`
	DryRun           aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	VPCID            aws.StringValue  `ec2:"VpcId" xml:"VpcId"`
}

// CreateSubnetResult is undocumented.
type CreateSubnetResult struct {
	Subnet *Subnet `ec2:"Subnet" xml:"subnet"`
}

// CreateTagsRequest is undocumented.
type CreateTagsRequest struct {
	DryRun    aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Resources []string         `ec2:"ResourceId" xml:"ResourceId>member"`
	Tags      []Tag            `ec2:"Tag" xml:"Tag>item"`
}

// CreateVolumePermission is undocumented.
type CreateVolumePermission struct {
	Group  aws.StringValue `ec2:"Group" xml:"group"`
	UserID aws.StringValue `ec2:"UserId" xml:"userId"`
}

// CreateVolumePermissionModifications is undocumented.
type CreateVolumePermissionModifications struct {
	Add    []CreateVolumePermission `ec2:"Add" xml:"Add>item"`
	Remove []CreateVolumePermission `ec2:"Remove" xml:"Remove>item"`
}

// CreateVolumeRequest is undocumented.
type CreateVolumeRequest struct {
	AvailabilityZone aws.StringValue  `ec2:"AvailabilityZone" xml:"AvailabilityZone"`
	DryRun           aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Encrypted        aws.BooleanValue `ec2:"Encrypted" xml:"encrypted"`
	IOPS             aws.IntegerValue `ec2:"Iops" xml:"Iops"`
	KMSKeyID         aws.StringValue  `ec2:"KmsKeyId" xml:"KmsKeyId"`
	Size             aws.IntegerValue `ec2:"Size" xml:"Size"`
	SnapshotID       aws.StringValue  `ec2:"SnapshotId" xml:"SnapshotId"`
	VolumeType       aws.StringValue  `ec2:"VolumeType" xml:"VolumeType"`
}

// CreateVPCPeeringConnectionRequest is undocumented.
type CreateVPCPeeringConnectionRequest struct {
	DryRun      aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	PeerOwnerID aws.StringValue  `ec2:"PeerOwnerId" xml:"peerOwnerId"`
	PeerVPCID   aws.StringValue  `ec2:"PeerVpcId" xml:"peerVpcId"`
	VPCID       aws.StringValue  `ec2:"VpcId" xml:"vpcId"`
}

// CreateVPCPeeringConnectionResult is undocumented.
type CreateVPCPeeringConnectionResult struct {
	VPCPeeringConnection *VPCPeeringConnection `ec2:"VpcPeeringConnection" xml:"vpcPeeringConnection"`
}

// CreateVPCRequest is undocumented.
type CreateVPCRequest struct {
	CIDRBlock       aws.StringValue  `ec2:"CidrBlock" xml:"CidrBlock"`
	DryRun          aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	InstanceTenancy aws.StringValue  `ec2:"InstanceTenancy" xml:"instanceTenancy"`
}

// CreateVPCResult is undocumented.
type CreateVPCResult struct {
	VPC *VPC `ec2:"Vpc" xml:"vpc"`
}

// CreateVPNConnectionRequest is undocumented.
type CreateVPNConnectionRequest struct {
	CustomerGatewayID aws.StringValue                    `ec2:"CustomerGatewayId" xml:"CustomerGatewayId"`
	DryRun            aws.BooleanValue                   `ec2:"DryRun" xml:"dryRun"`
	Options           *VPNConnectionOptionsSpecification `ec2:"Options" xml:"options"`
	Type              aws.StringValue                    `ec2:"Type" xml:"Type"`
	VPNGatewayID      aws.StringValue                    `ec2:"VpnGatewayId" xml:"VpnGatewayId"`
}

// CreateVPNConnectionResult is undocumented.
type CreateVPNConnectionResult struct {
	VPNConnection *VPNConnection `ec2:"VpnConnection" xml:"vpnConnection"`
}

// CreateVPNConnectionRouteRequest is undocumented.
type CreateVPNConnectionRouteRequest struct {
	DestinationCIDRBlock aws.StringValue `ec2:"DestinationCidrBlock" xml:"DestinationCidrBlock"`
	VPNConnectionID      aws.StringValue `ec2:"VpnConnectionId" xml:"VpnConnectionId"`
}

// CreateVPNGatewayRequest is undocumented.
type CreateVPNGatewayRequest struct {
	AvailabilityZone aws.StringValue  `ec2:"AvailabilityZone" xml:"AvailabilityZone"`
	DryRun           aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Type             aws.StringValue  `ec2:"Type" xml:"Type"`
}

// CreateVPNGatewayResult is undocumented.
type CreateVPNGatewayResult struct {
	VPNGateway *VPNGateway `ec2:"VpnGateway" xml:"vpnGateway"`
}

// Possible values for EC2.
const (
	CurrencyCodeValuesUsd = "USD"
)

// CustomerGateway is undocumented.
type CustomerGateway struct {
	BGPASN            aws.StringValue `ec2:"BgpAsn" xml:"bgpAsn"`
	CustomerGatewayID aws.StringValue `ec2:"CustomerGatewayId" xml:"customerGatewayId"`
	IPAddress         aws.StringValue `ec2:"IpAddress" xml:"ipAddress"`
	State             aws.StringValue `ec2:"State" xml:"state"`
	Tags              []Tag           `ec2:"Tags" xml:"tagSet>item"`
	Type              aws.StringValue `ec2:"Type" xml:"type"`
}

// Possible values for EC2.
const (
	DatafeedSubscriptionStateActive   = "Active"
	DatafeedSubscriptionStateInactive = "Inactive"
)

// DeleteCustomerGatewayRequest is undocumented.
type DeleteCustomerGatewayRequest struct {
	CustomerGatewayID aws.StringValue  `ec2:"CustomerGatewayId" xml:"CustomerGatewayId"`
	DryRun            aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
}

// DeleteDHCPOptionsRequest is undocumented.
type DeleteDHCPOptionsRequest struct {
	DHCPOptionsID aws.StringValue  `ec2:"DhcpOptionsId" xml:"DhcpOptionsId"`
	DryRun        aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
}

// DeleteInternetGatewayRequest is undocumented.
type DeleteInternetGatewayRequest struct {
	DryRun            aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	InternetGatewayID aws.StringValue  `ec2:"InternetGatewayId" xml:"internetGatewayId"`
}

// DeleteKeyPairRequest is undocumented.
type DeleteKeyPairRequest struct {
	DryRun  aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	KeyName aws.StringValue  `ec2:"KeyName" xml:"KeyName"`
}

// DeleteNetworkACLEntryRequest is undocumented.
type DeleteNetworkACLEntryRequest struct {
	DryRun       aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Egress       aws.BooleanValue `ec2:"Egress" xml:"egress"`
	NetworkACLID aws.StringValue  `ec2:"NetworkAclId" xml:"networkAclId"`
	RuleNumber   aws.IntegerValue `ec2:"RuleNumber" xml:"ruleNumber"`
}

// DeleteNetworkACLRequest is undocumented.
type DeleteNetworkACLRequest struct {
	DryRun       aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	NetworkACLID aws.StringValue  `ec2:"NetworkAclId" xml:"networkAclId"`
}

// DeleteNetworkInterfaceRequest is undocumented.
type DeleteNetworkInterfaceRequest struct {
	DryRun             aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	NetworkInterfaceID aws.StringValue  `ec2:"NetworkInterfaceId" xml:"networkInterfaceId"`
}

// DeletePlacementGroupRequest is undocumented.
type DeletePlacementGroupRequest struct {
	DryRun    aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	GroupName aws.StringValue  `ec2:"GroupName" xml:"groupName"`
}

// DeleteRouteRequest is undocumented.
type DeleteRouteRequest struct {
	DestinationCIDRBlock aws.StringValue  `ec2:"DestinationCidrBlock" xml:"destinationCidrBlock"`
	DryRun               aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	RouteTableID         aws.StringValue  `ec2:"RouteTableId" xml:"routeTableId"`
}

// DeleteRouteTableRequest is undocumented.
type DeleteRouteTableRequest struct {
	DryRun       aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	RouteTableID aws.StringValue  `ec2:"RouteTableId" xml:"routeTableId"`
}

// DeleteSecurityGroupRequest is undocumented.
type DeleteSecurityGroupRequest struct {
	DryRun    aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	GroupID   aws.StringValue  `ec2:"GroupId" xml:"GroupId"`
	GroupName aws.StringValue  `ec2:"GroupName" xml:"GroupName"`
}

// DeleteSnapshotRequest is undocumented.
type DeleteSnapshotRequest struct {
	DryRun     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	SnapshotID aws.StringValue  `ec2:"SnapshotId" xml:"SnapshotId"`
}

// DeleteSpotDatafeedSubscriptionRequest is undocumented.
type DeleteSpotDatafeedSubscriptionRequest struct {
	DryRun aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
}

// DeleteSubnetRequest is undocumented.
type DeleteSubnetRequest struct {
	DryRun   aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	SubnetID aws.StringValue  `ec2:"SubnetId" xml:"SubnetId"`
}

// DeleteTagsRequest is undocumented.
type DeleteTagsRequest struct {
	DryRun    aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Resources []string         `ec2:"Resources" xml:"resourceId>member"`
	Tags      []Tag            `ec2:"Tags" xml:"tag>item"`
}

// DeleteVolumeRequest is undocumented.
type DeleteVolumeRequest struct {
	DryRun   aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	VolumeID aws.StringValue  `ec2:"VolumeId" xml:"VolumeId"`
}

// DeleteVPCPeeringConnectionRequest is undocumented.
type DeleteVPCPeeringConnectionRequest struct {
	DryRun                 aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	VPCPeeringConnectionID aws.StringValue  `ec2:"VpcPeeringConnectionId" xml:"vpcPeeringConnectionId"`
}

// DeleteVPCPeeringConnectionResult is undocumented.
type DeleteVPCPeeringConnectionResult struct {
	Return aws.BooleanValue `ec2:"Return" xml:"return"`
}

// DeleteVPCRequest is undocumented.
type DeleteVPCRequest struct {
	DryRun aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	VPCID  aws.StringValue  `ec2:"VpcId" xml:"VpcId"`
}

// DeleteVPNConnectionRequest is undocumented.
type DeleteVPNConnectionRequest struct {
	DryRun          aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	VPNConnectionID aws.StringValue  `ec2:"VpnConnectionId" xml:"VpnConnectionId"`
}

// DeleteVPNConnectionRouteRequest is undocumented.
type DeleteVPNConnectionRouteRequest struct {
	DestinationCIDRBlock aws.StringValue `ec2:"DestinationCidrBlock" xml:"DestinationCidrBlock"`
	VPNConnectionID      aws.StringValue `ec2:"VpnConnectionId" xml:"VpnConnectionId"`
}

// DeleteVPNGatewayRequest is undocumented.
type DeleteVPNGatewayRequest struct {
	DryRun       aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	VPNGatewayID aws.StringValue  `ec2:"VpnGatewayId" xml:"VpnGatewayId"`
}

// DeregisterImageRequest is undocumented.
type DeregisterImageRequest struct {
	DryRun  aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	ImageID aws.StringValue  `ec2:"ImageId" xml:"ImageId"`
}

// DescribeAccountAttributesRequest is undocumented.
type DescribeAccountAttributesRequest struct {
	AttributeNames []string         `ec2:"AttributeNames" xml:"attributeName>attributeName"`
	DryRun         aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
}

// DescribeAccountAttributesResult is undocumented.
type DescribeAccountAttributesResult struct {
	AccountAttributes []AccountAttribute `ec2:"AccountAttributes" xml:"accountAttributeSet>item"`
}

// DescribeAddressesRequest is undocumented.
type DescribeAddressesRequest struct {
	AllocationIDs []string         `ec2:"AllocationId" xml:"AllocationId>AllocationId"`
	DryRun        aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters       []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	PublicIPs     []string         `ec2:"PublicIp" xml:"PublicIp>PublicIp"`
}

// DescribeAddressesResult is undocumented.
type DescribeAddressesResult struct {
	Addresses []Address `ec2:"Addresses" xml:"addressesSet>item"`
}

// DescribeAvailabilityZonesRequest is undocumented.
type DescribeAvailabilityZonesRequest struct {
	DryRun    aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters   []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	ZoneNames []string         `ec2:"ZoneName" xml:"ZoneName>ZoneName"`
}

// DescribeAvailabilityZonesResult is undocumented.
type DescribeAvailabilityZonesResult struct {
	AvailabilityZones []AvailabilityZone `ec2:"AvailabilityZones" xml:"availabilityZoneInfo>item"`
}

// DescribeBundleTasksRequest is undocumented.
type DescribeBundleTasksRequest struct {
	BundleIDs []string         `ec2:"BundleId" xml:"BundleId>BundleId"`
	DryRun    aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters   []Filter         `ec2:"Filter" xml:"Filter>Filter"`
}

// DescribeBundleTasksResult is undocumented.
type DescribeBundleTasksResult struct {
	BundleTasks []BundleTask `ec2:"BundleTasks" xml:"bundleInstanceTasksSet>item"`
}

// DescribeClassicLinkInstancesRequest is undocumented.
type DescribeClassicLinkInstancesRequest struct {
	DryRun      aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters     []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	InstanceIDs []string         `ec2:"InstanceId" xml:"InstanceId>InstanceId"`
	MaxResults  aws.IntegerValue `ec2:"MaxResults" xml:"maxResults"`
	NextToken   aws.StringValue  `ec2:"NextToken" xml:"nextToken"`
}

// DescribeClassicLinkInstancesResult is undocumented.
type DescribeClassicLinkInstancesResult struct {
	Instances []ClassicLinkInstance `ec2:"Instances" xml:"instancesSet>item"`
	NextToken aws.StringValue       `ec2:"NextToken" xml:"nextToken"`
}

// DescribeConversionTasksRequest is undocumented.
type DescribeConversionTasksRequest struct {
	ConversionTaskIDs []string         `ec2:"ConversionTaskIds" xml:"conversionTaskId>item"`
	DryRun            aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters           []Filter         `ec2:"Filters" xml:"filter>Filter"`
}

// DescribeConversionTasksResult is undocumented.
type DescribeConversionTasksResult struct {
	ConversionTasks []ConversionTask `ec2:"ConversionTasks" xml:"conversionTasks>item"`
}

// DescribeCustomerGatewaysRequest is undocumented.
type DescribeCustomerGatewaysRequest struct {
	CustomerGatewayIDs []string         `ec2:"CustomerGatewayId" xml:"CustomerGatewayId>CustomerGatewayId"`
	DryRun             aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters            []Filter         `ec2:"Filter" xml:"Filter>Filter"`
}

// DescribeCustomerGatewaysResult is undocumented.
type DescribeCustomerGatewaysResult struct {
	CustomerGateways []CustomerGateway `ec2:"CustomerGateways" xml:"customerGatewaySet>item"`
}

// DescribeDHCPOptionsRequest is undocumented.
type DescribeDHCPOptionsRequest struct {
	DHCPOptionsIDs []string         `ec2:"DhcpOptionsId" xml:"DhcpOptionsId>DhcpOptionsId"`
	DryRun         aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters        []Filter         `ec2:"Filter" xml:"Filter>Filter"`
}

// DescribeDHCPOptionsResult is undocumented.
type DescribeDHCPOptionsResult struct {
	DHCPOptions []DHCPOptions `ec2:"DhcpOptions" xml:"dhcpOptionsSet>item"`
}

// DescribeExportTasksRequest is undocumented.
type DescribeExportTasksRequest struct {
	ExportTaskIDs []string `ec2:"ExportTaskIds" xml:"exportTaskId>ExportTaskId"`
}

// DescribeExportTasksResult is undocumented.
type DescribeExportTasksResult struct {
	ExportTasks []ExportTask `ec2:"ExportTasks" xml:"exportTaskSet>item"`
}

// DescribeImageAttributeRequest is undocumented.
type DescribeImageAttributeRequest struct {
	Attribute aws.StringValue  `ec2:"Attribute" xml:"Attribute"`
	DryRun    aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	ImageID   aws.StringValue  `ec2:"ImageId" xml:"ImageId"`
}

// DescribeImagesRequest is undocumented.
type DescribeImagesRequest struct {
	DryRun          aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	ExecutableUsers []string         `ec2:"ExecutableBy" xml:"ExecutableBy>ExecutableBy"`
	Filters         []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	ImageIDs        []string         `ec2:"ImageId" xml:"ImageId>ImageId"`
	Owners          []string         `ec2:"Owner" xml:"Owner>Owner"`
}

// DescribeImagesResult is undocumented.
type DescribeImagesResult struct {
	Images []Image `ec2:"Images" xml:"imagesSet>item"`
}

// DescribeInstanceAttributeRequest is undocumented.
type DescribeInstanceAttributeRequest struct {
	Attribute  aws.StringValue  `ec2:"Attribute" xml:"attribute"`
	DryRun     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	InstanceID aws.StringValue  `ec2:"InstanceId" xml:"instanceId"`
}

// DescribeInstanceStatusRequest is undocumented.
type DescribeInstanceStatusRequest struct {
	DryRun              aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters             []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	IncludeAllInstances aws.BooleanValue `ec2:"IncludeAllInstances" xml:"includeAllInstances"`
	InstanceIDs         []string         `ec2:"InstanceId" xml:"InstanceId>InstanceId"`
	MaxResults          aws.IntegerValue `ec2:"MaxResults" xml:"MaxResults"`
	NextToken           aws.StringValue  `ec2:"NextToken" xml:"NextToken"`
}

// DescribeInstanceStatusResult is undocumented.
type DescribeInstanceStatusResult struct {
	InstanceStatuses []InstanceStatus `ec2:"InstanceStatuses" xml:"instanceStatusSet>item"`
	NextToken        aws.StringValue  `ec2:"NextToken" xml:"nextToken"`
}

// DescribeInstancesRequest is undocumented.
type DescribeInstancesRequest struct {
	DryRun      aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters     []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	InstanceIDs []string         `ec2:"InstanceId" xml:"InstanceId>InstanceId"`
	MaxResults  aws.IntegerValue `ec2:"MaxResults" xml:"maxResults"`
	NextToken   aws.StringValue  `ec2:"NextToken" xml:"nextToken"`
}

// DescribeInstancesResult is undocumented.
type DescribeInstancesResult struct {
	NextToken    aws.StringValue `ec2:"NextToken" xml:"nextToken"`
	Reservations []Reservation   `ec2:"Reservations" xml:"reservationSet>item"`
}

// DescribeInternetGatewaysRequest is undocumented.
type DescribeInternetGatewaysRequest struct {
	DryRun             aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters            []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	InternetGatewayIDs []string         `ec2:"InternetGatewayIds" xml:"internetGatewayId>item"`
}

// DescribeInternetGatewaysResult is undocumented.
type DescribeInternetGatewaysResult struct {
	InternetGateways []InternetGateway `ec2:"InternetGateways" xml:"internetGatewaySet>item"`
}

// DescribeKeyPairsRequest is undocumented.
type DescribeKeyPairsRequest struct {
	DryRun   aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters  []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	KeyNames []string         `ec2:"KeyName" xml:"KeyName>KeyName"`
}

// DescribeKeyPairsResult is undocumented.
type DescribeKeyPairsResult struct {
	KeyPairs []KeyPairInfo `ec2:"KeyPairs" xml:"keySet>item"`
}

// DescribeNetworkACLsRequest is undocumented.
type DescribeNetworkACLsRequest struct {
	DryRun        aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters       []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	NetworkACLIDs []string         `ec2:"NetworkAclId" xml:"NetworkAclId>item"`
}

// DescribeNetworkACLsResult is undocumented.
type DescribeNetworkACLsResult struct {
	NetworkACLs []NetworkACL `ec2:"NetworkAcls" xml:"networkAclSet>item"`
}

// DescribeNetworkInterfaceAttributeRequest is undocumented.
type DescribeNetworkInterfaceAttributeRequest struct {
	Attribute          aws.StringValue  `ec2:"Attribute" xml:"attribute"`
	DryRun             aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	NetworkInterfaceID aws.StringValue  `ec2:"NetworkInterfaceId" xml:"networkInterfaceId"`
}

// DescribeNetworkInterfaceAttributeResult is undocumented.
type DescribeNetworkInterfaceAttributeResult struct {
	Attachment         *NetworkInterfaceAttachment `ec2:"Attachment" xml:"attachment"`
	Description        *AttributeValue             `ec2:"Description" xml:"description"`
	Groups             []GroupIdentifier           `ec2:"Groups" xml:"groupSet>item"`
	NetworkInterfaceID aws.StringValue             `ec2:"NetworkInterfaceId" xml:"networkInterfaceId"`
	SourceDestCheck    *AttributeBooleanValue      `ec2:"SourceDestCheck" xml:"sourceDestCheck"`
}

// DescribeNetworkInterfacesRequest is undocumented.
type DescribeNetworkInterfacesRequest struct {
	DryRun              aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters             []Filter         `ec2:"Filters" xml:"filter>Filter"`
	NetworkInterfaceIDs []string         `ec2:"NetworkInterfaceId" xml:"NetworkInterfaceId>item"`
}

// DescribeNetworkInterfacesResult is undocumented.
type DescribeNetworkInterfacesResult struct {
	NetworkInterfaces []NetworkInterface `ec2:"NetworkInterfaces" xml:"networkInterfaceSet>item"`
}

// DescribePlacementGroupsRequest is undocumented.
type DescribePlacementGroupsRequest struct {
	DryRun     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters    []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	GroupNames []string         `ec2:"GroupNames" xml:"groupName>member"`
}

// DescribePlacementGroupsResult is undocumented.
type DescribePlacementGroupsResult struct {
	PlacementGroups []PlacementGroup `ec2:"PlacementGroups" xml:"placementGroupSet>item"`
}

// DescribeRegionsRequest is undocumented.
type DescribeRegionsRequest struct {
	DryRun      aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters     []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	RegionNames []string         `ec2:"RegionName" xml:"RegionName>RegionName"`
}

// DescribeRegionsResult is undocumented.
type DescribeRegionsResult struct {
	Regions []Region `ec2:"Regions" xml:"regionInfo>item"`
}

// DescribeReservedInstancesListingsRequest is undocumented.
type DescribeReservedInstancesListingsRequest struct {
	Filters                    []Filter        `ec2:"Filters" xml:"filters>Filter"`
	ReservedInstancesID        aws.StringValue `ec2:"ReservedInstancesId" xml:"reservedInstancesId"`
	ReservedInstancesListingID aws.StringValue `ec2:"ReservedInstancesListingId" xml:"reservedInstancesListingId"`
}

// DescribeReservedInstancesListingsResult is undocumented.
type DescribeReservedInstancesListingsResult struct {
	ReservedInstancesListings []ReservedInstancesListing `ec2:"ReservedInstancesListings" xml:"reservedInstancesListingsSet>item"`
}

// DescribeReservedInstancesModificationsRequest is undocumented.
type DescribeReservedInstancesModificationsRequest struct {
	Filters                          []Filter        `ec2:"Filter" xml:"Filter>Filter"`
	NextToken                        aws.StringValue `ec2:"NextToken" xml:"nextToken"`
	ReservedInstancesModificationIDs []string        `ec2:"ReservedInstancesModificationId" xml:"ReservedInstancesModificationId>ReservedInstancesModificationId"`
}

// DescribeReservedInstancesModificationsResult is undocumented.
type DescribeReservedInstancesModificationsResult struct {
	NextToken                      aws.StringValue                 `ec2:"NextToken" xml:"nextToken"`
	ReservedInstancesModifications []ReservedInstancesModification `ec2:"ReservedInstancesModifications" xml:"reservedInstancesModificationsSet>item"`
}

// DescribeReservedInstancesOfferingsRequest is undocumented.
type DescribeReservedInstancesOfferingsRequest struct {
	AvailabilityZone             aws.StringValue  `ec2:"AvailabilityZone" xml:"AvailabilityZone"`
	DryRun                       aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters                      []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	IncludeMarketplace           aws.BooleanValue `ec2:"IncludeMarketplace" xml:"IncludeMarketplace"`
	InstanceTenancy              aws.StringValue  `ec2:"InstanceTenancy" xml:"instanceTenancy"`
	InstanceType                 aws.StringValue  `ec2:"InstanceType" xml:"InstanceType"`
	MaxDuration                  aws.LongValue    `ec2:"MaxDuration" xml:"MaxDuration"`
	MaxInstanceCount             aws.IntegerValue `ec2:"MaxInstanceCount" xml:"MaxInstanceCount"`
	MaxResults                   aws.IntegerValue `ec2:"MaxResults" xml:"maxResults"`
	MinDuration                  aws.LongValue    `ec2:"MinDuration" xml:"MinDuration"`
	NextToken                    aws.StringValue  `ec2:"NextToken" xml:"nextToken"`
	OfferingType                 aws.StringValue  `ec2:"OfferingType" xml:"offeringType"`
	ProductDescription           aws.StringValue  `ec2:"ProductDescription" xml:"ProductDescription"`
	ReservedInstancesOfferingIDs []string         `ec2:"ReservedInstancesOfferingId" xml:"ReservedInstancesOfferingId>member"`
}

// DescribeReservedInstancesOfferingsResult is undocumented.
type DescribeReservedInstancesOfferingsResult struct {
	NextToken                  aws.StringValue             `ec2:"NextToken" xml:"nextToken"`
	ReservedInstancesOfferings []ReservedInstancesOffering `ec2:"ReservedInstancesOfferings" xml:"reservedInstancesOfferingsSet>item"`
}

// DescribeReservedInstancesRequest is undocumented.
type DescribeReservedInstancesRequest struct {
	DryRun               aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters              []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	OfferingType         aws.StringValue  `ec2:"OfferingType" xml:"offeringType"`
	ReservedInstancesIDs []string         `ec2:"ReservedInstancesId" xml:"ReservedInstancesId>ReservedInstancesId"`
}

// DescribeReservedInstancesResult is undocumented.
type DescribeReservedInstancesResult struct {
	ReservedInstances []ReservedInstances `ec2:"ReservedInstances" xml:"reservedInstancesSet>item"`
}

// DescribeRouteTablesRequest is undocumented.
type DescribeRouteTablesRequest struct {
	DryRun        aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters       []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	RouteTableIDs []string         `ec2:"RouteTableId" xml:"RouteTableId>item"`
}

// DescribeRouteTablesResult is undocumented.
type DescribeRouteTablesResult struct {
	RouteTables []RouteTable `ec2:"RouteTables" xml:"routeTableSet>item"`
}

// DescribeSecurityGroupsRequest is undocumented.
type DescribeSecurityGroupsRequest struct {
	DryRun     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters    []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	GroupIDs   []string         `ec2:"GroupId" xml:"GroupId>groupId"`
	GroupNames []string         `ec2:"GroupName" xml:"GroupName>GroupName"`
}

// DescribeSecurityGroupsResult is undocumented.
type DescribeSecurityGroupsResult struct {
	SecurityGroups []SecurityGroup `ec2:"SecurityGroups" xml:"securityGroupInfo>item"`
}

// DescribeSnapshotAttributeRequest is undocumented.
type DescribeSnapshotAttributeRequest struct {
	Attribute  aws.StringValue  `ec2:"Attribute" xml:"Attribute"`
	DryRun     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	SnapshotID aws.StringValue  `ec2:"SnapshotId" xml:"SnapshotId"`
}

// DescribeSnapshotAttributeResult is undocumented.
type DescribeSnapshotAttributeResult struct {
	CreateVolumePermissions []CreateVolumePermission `ec2:"CreateVolumePermissions" xml:"createVolumePermission>item"`
	ProductCodes            []ProductCode            `ec2:"ProductCodes" xml:"productCodes>item"`
	SnapshotID              aws.StringValue          `ec2:"SnapshotId" xml:"snapshotId"`
}

// DescribeSnapshotsRequest is undocumented.
type DescribeSnapshotsRequest struct {
	DryRun              aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters             []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	OwnerIDs            []string         `ec2:"Owner" xml:"Owner>Owner"`
	RestorableByUserIDs []string         `ec2:"RestorableBy" xml:"RestorableBy>member"`
	SnapshotIDs         []string         `ec2:"SnapshotId" xml:"SnapshotId>SnapshotId"`
}

// DescribeSnapshotsResult is undocumented.
type DescribeSnapshotsResult struct {
	Snapshots []Snapshot `ec2:"Snapshots" xml:"snapshotSet>item"`
}

// DescribeSpotDatafeedSubscriptionRequest is undocumented.
type DescribeSpotDatafeedSubscriptionRequest struct {
	DryRun aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
}

// DescribeSpotDatafeedSubscriptionResult is undocumented.
type DescribeSpotDatafeedSubscriptionResult struct {
	SpotDatafeedSubscription *SpotDatafeedSubscription `ec2:"SpotDatafeedSubscription" xml:"spotDatafeedSubscription"`
}

// DescribeSpotInstanceRequestsRequest is undocumented.
type DescribeSpotInstanceRequestsRequest struct {
	DryRun                 aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters                []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	SpotInstanceRequestIDs []string         `ec2:"SpotInstanceRequestId" xml:"SpotInstanceRequestId>SpotInstanceRequestId"`
}

// DescribeSpotInstanceRequestsResult is undocumented.
type DescribeSpotInstanceRequestsResult struct {
	SpotInstanceRequests []SpotInstanceRequest `ec2:"SpotInstanceRequests" xml:"spotInstanceRequestSet>item"`
}

// DescribeSpotPriceHistoryRequest is undocumented.
type DescribeSpotPriceHistoryRequest struct {
	AvailabilityZone    aws.StringValue  `ec2:"AvailabilityZone" xml:"availabilityZone"`
	DryRun              aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	EndTime             time.Time        `ec2:"EndTime" xml:"endTime"`
	Filters             []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	InstanceTypes       []string         `ec2:"InstanceType" xml:"InstanceType>member"`
	MaxResults          aws.IntegerValue `ec2:"MaxResults" xml:"maxResults"`
	NextToken           aws.StringValue  `ec2:"NextToken" xml:"nextToken"`
	ProductDescriptions []string         `ec2:"ProductDescription" xml:"ProductDescription>member"`
	StartTime           time.Time        `ec2:"StartTime" xml:"startTime"`
}

// DescribeSpotPriceHistoryResult is undocumented.
type DescribeSpotPriceHistoryResult struct {
	NextToken        aws.StringValue `ec2:"NextToken" xml:"nextToken"`
	SpotPriceHistory []SpotPrice     `ec2:"SpotPriceHistory" xml:"spotPriceHistorySet>item"`
}

// DescribeSubnetsRequest is undocumented.
type DescribeSubnetsRequest struct {
	DryRun    aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters   []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	SubnetIDs []string         `ec2:"SubnetId" xml:"SubnetId>SubnetId"`
}

// DescribeSubnetsResult is undocumented.
type DescribeSubnetsResult struct {
	Subnets []Subnet `ec2:"Subnets" xml:"subnetSet>item"`
}

// DescribeTagsRequest is undocumented.
type DescribeTagsRequest struct {
	DryRun     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters    []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	MaxResults aws.IntegerValue `ec2:"MaxResults" xml:"maxResults"`
	NextToken  aws.StringValue  `ec2:"NextToken" xml:"nextToken"`
}

// DescribeTagsResult is undocumented.
type DescribeTagsResult struct {
	NextToken aws.StringValue  `ec2:"NextToken" xml:"nextToken"`
	Tags      []TagDescription `ec2:"Tags" xml:"tagSet>item"`
}

// DescribeVolumeAttributeRequest is undocumented.
type DescribeVolumeAttributeRequest struct {
	Attribute aws.StringValue  `ec2:"Attribute" xml:"Attribute"`
	DryRun    aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	VolumeID  aws.StringValue  `ec2:"VolumeId" xml:"VolumeId"`
}

// DescribeVolumeAttributeResult is undocumented.
type DescribeVolumeAttributeResult struct {
	AutoEnableIO *AttributeBooleanValue `ec2:"AutoEnableIO" xml:"autoEnableIO"`
	ProductCodes []ProductCode          `ec2:"ProductCodes" xml:"productCodes>item"`
	VolumeID     aws.StringValue        `ec2:"VolumeId" xml:"volumeId"`
}

// DescribeVolumeStatusRequest is undocumented.
type DescribeVolumeStatusRequest struct {
	DryRun     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters    []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	MaxResults aws.IntegerValue `ec2:"MaxResults" xml:"MaxResults"`
	NextToken  aws.StringValue  `ec2:"NextToken" xml:"NextToken"`
	VolumeIDs  []string         `ec2:"VolumeId" xml:"VolumeId>VolumeId"`
}

// DescribeVolumeStatusResult is undocumented.
type DescribeVolumeStatusResult struct {
	NextToken      aws.StringValue    `ec2:"NextToken" xml:"nextToken"`
	VolumeStatuses []VolumeStatusItem `ec2:"VolumeStatuses" xml:"volumeStatusSet>item"`
}

// DescribeVolumesRequest is undocumented.
type DescribeVolumesRequest struct {
	DryRun     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters    []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	MaxResults aws.IntegerValue `ec2:"MaxResults" xml:"maxResults"`
	NextToken  aws.StringValue  `ec2:"NextToken" xml:"nextToken"`
	VolumeIDs  []string         `ec2:"VolumeId" xml:"VolumeId>VolumeId"`
}

// DescribeVolumesResult is undocumented.
type DescribeVolumesResult struct {
	NextToken aws.StringValue `ec2:"NextToken" xml:"nextToken"`
	Volumes   []Volume        `ec2:"Volumes" xml:"volumeSet>item"`
}

// DescribeVPCAttributeRequest is undocumented.
type DescribeVPCAttributeRequest struct {
	Attribute aws.StringValue  `ec2:"Attribute" xml:"Attribute"`
	DryRun    aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	VPCID     aws.StringValue  `ec2:"VpcId" xml:"VpcId"`
}

// DescribeVPCAttributeResult is undocumented.
type DescribeVPCAttributeResult struct {
	EnableDNSHostnames *AttributeBooleanValue `ec2:"EnableDnsHostnames" xml:"enableDnsHostnames"`
	EnableDNSSupport   *AttributeBooleanValue `ec2:"EnableDnsSupport" xml:"enableDnsSupport"`
	VPCID              aws.StringValue        `ec2:"VpcId" xml:"vpcId"`
}

// DescribeVPCClassicLinkRequest is undocumented.
type DescribeVPCClassicLinkRequest struct {
	DryRun  aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	VPCIDs  []string         `ec2:"VpcId" xml:"VpcId>VpcId"`
}

// DescribeVPCClassicLinkResult is undocumented.
type DescribeVPCClassicLinkResult struct {
	VPCs []VPCClassicLink `ec2:"Vpcs" xml:"vpcSet>item"`
}

// DescribeVPCPeeringConnectionsRequest is undocumented.
type DescribeVPCPeeringConnectionsRequest struct {
	DryRun                  aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters                 []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	VPCPeeringConnectionIDs []string         `ec2:"VpcPeeringConnectionId" xml:"VpcPeeringConnectionId>item"`
}

// DescribeVPCPeeringConnectionsResult is undocumented.
type DescribeVPCPeeringConnectionsResult struct {
	VPCPeeringConnections []VPCPeeringConnection `ec2:"VpcPeeringConnections" xml:"vpcPeeringConnectionSet>item"`
}

// DescribeVPCsRequest is undocumented.
type DescribeVPCsRequest struct {
	DryRun  aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	VPCIDs  []string         `ec2:"VpcId" xml:"VpcId>VpcId"`
}

// DescribeVPCsResult is undocumented.
type DescribeVPCsResult struct {
	VPCs []VPC `ec2:"Vpcs" xml:"vpcSet>item"`
}

// DescribeVPNConnectionsRequest is undocumented.
type DescribeVPNConnectionsRequest struct {
	DryRun           aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters          []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	VPNConnectionIDs []string         `ec2:"VpnConnectionId" xml:"VpnConnectionId>VpnConnectionId"`
}

// DescribeVPNConnectionsResult is undocumented.
type DescribeVPNConnectionsResult struct {
	VPNConnections []VPNConnection `ec2:"VpnConnections" xml:"vpnConnectionSet>item"`
}

// DescribeVPNGatewaysRequest is undocumented.
type DescribeVPNGatewaysRequest struct {
	DryRun        aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Filters       []Filter         `ec2:"Filter" xml:"Filter>Filter"`
	VPNGatewayIDs []string         `ec2:"VpnGatewayId" xml:"VpnGatewayId>VpnGatewayId"`
}

// DescribeVPNGatewaysResult is undocumented.
type DescribeVPNGatewaysResult struct {
	VPNGateways []VPNGateway `ec2:"VpnGateways" xml:"vpnGatewaySet>item"`
}

// DetachClassicLinkVPCRequest is undocumented.
type DetachClassicLinkVPCRequest struct {
	DryRun     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	InstanceID aws.StringValue  `ec2:"InstanceId" xml:"instanceId"`
	VPCID      aws.StringValue  `ec2:"VpcId" xml:"vpcId"`
}

// DetachClassicLinkVPCResult is undocumented.
type DetachClassicLinkVPCResult struct {
	Return aws.BooleanValue `ec2:"Return" xml:"return"`
}

// DetachInternetGatewayRequest is undocumented.
type DetachInternetGatewayRequest struct {
	DryRun            aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	InternetGatewayID aws.StringValue  `ec2:"InternetGatewayId" xml:"internetGatewayId"`
	VPCID             aws.StringValue  `ec2:"VpcId" xml:"vpcId"`
}

// DetachNetworkInterfaceRequest is undocumented.
type DetachNetworkInterfaceRequest struct {
	AttachmentID aws.StringValue  `ec2:"AttachmentId" xml:"attachmentId"`
	DryRun       aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Force        aws.BooleanValue `ec2:"Force" xml:"force"`
}

// DetachVolumeRequest is undocumented.
type DetachVolumeRequest struct {
	Device     aws.StringValue  `ec2:"Device" xml:"Device"`
	DryRun     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Force      aws.BooleanValue `ec2:"Force" xml:"Force"`
	InstanceID aws.StringValue  `ec2:"InstanceId" xml:"InstanceId"`
	VolumeID   aws.StringValue  `ec2:"VolumeId" xml:"VolumeId"`
}

// DetachVPNGatewayRequest is undocumented.
type DetachVPNGatewayRequest struct {
	DryRun       aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	VPCID        aws.StringValue  `ec2:"VpcId" xml:"VpcId"`
	VPNGatewayID aws.StringValue  `ec2:"VpnGatewayId" xml:"VpnGatewayId"`
}

// Possible values for EC2.
const (
	DeviceTypeEBS           = "ebs"
	DeviceTypeInstanceStore = "instance-store"
)

// DHCPConfiguration is undocumented.
type DHCPConfiguration struct {
	Key    aws.StringValue  `ec2:"Key" xml:"key"`
	Values []AttributeValue `ec2:"Values" xml:"valueSet>item"`
}

// DHCPOptions is undocumented.
type DHCPOptions struct {
	DHCPConfigurations []DHCPConfiguration `ec2:"DhcpConfigurations" xml:"dhcpConfigurationSet>item"`
	DHCPOptionsID      aws.StringValue     `ec2:"DhcpOptionsId" xml:"dhcpOptionsId"`
	Tags               []Tag               `ec2:"Tags" xml:"tagSet>item"`
}

// DisableVGWRoutePropagationRequest is undocumented.
type DisableVGWRoutePropagationRequest struct {
	GatewayID    aws.StringValue `ec2:"GatewayId" xml:"GatewayId"`
	RouteTableID aws.StringValue `ec2:"RouteTableId" xml:"RouteTableId"`
}

// DisableVPCClassicLinkRequest is undocumented.
type DisableVPCClassicLinkRequest struct {
	DryRun aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	VPCID  aws.StringValue  `ec2:"VpcId" xml:"vpcId"`
}

// DisableVPCClassicLinkResult is undocumented.
type DisableVPCClassicLinkResult struct {
	Return aws.BooleanValue `ec2:"Return" xml:"return"`
}

// DisassociateAddressRequest is undocumented.
type DisassociateAddressRequest struct {
	AssociationID aws.StringValue  `ec2:"AssociationId" xml:"AssociationId"`
	DryRun        aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	PublicIP      aws.StringValue  `ec2:"PublicIp" xml:"PublicIp"`
}

// DisassociateRouteTableRequest is undocumented.
type DisassociateRouteTableRequest struct {
	AssociationID aws.StringValue  `ec2:"AssociationId" xml:"associationId"`
	DryRun        aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
}

// DiskImage is undocumented.
type DiskImage struct {
	Description aws.StringValue  `ec2:"Description" xml:"Description"`
	Image       *DiskImageDetail `ec2:"Image" xml:"Image"`
	Volume      *VolumeDetail    `ec2:"Volume" xml:"Volume"`
}

// DiskImageDescription is undocumented.
type DiskImageDescription struct {
	Checksum          aws.StringValue `ec2:"Checksum" xml:"checksum"`
	Format            aws.StringValue `ec2:"Format" xml:"format"`
	ImportManifestURL aws.StringValue `ec2:"ImportManifestUrl" xml:"importManifestUrl"`
	Size              aws.LongValue   `ec2:"Size" xml:"size"`
}

// DiskImageDetail is undocumented.
type DiskImageDetail struct {
	Bytes             aws.LongValue   `ec2:"Bytes" xml:"bytes"`
	Format            aws.StringValue `ec2:"Format" xml:"format"`
	ImportManifestURL aws.StringValue `ec2:"ImportManifestUrl" xml:"importManifestUrl"`
}

// Possible values for EC2.
const (
	DiskImageFormatRaw  = "RAW"
	DiskImageFormatVHD  = "VHD"
	DiskImageFormatVMDK = "VMDK"
)

// DiskImageVolumeDescription is undocumented.
type DiskImageVolumeDescription struct {
	ID   aws.StringValue `ec2:"Id" xml:"id"`
	Size aws.LongValue   `ec2:"Size" xml:"size"`
}

// Possible values for EC2.
const (
	DomainTypeStandard = "standard"
	DomainTypeVPC      = "vpc"
)

// EBSBlockDevice is undocumented.
type EBSBlockDevice struct {
	DeleteOnTermination aws.BooleanValue `ec2:"DeleteOnTermination" xml:"deleteOnTermination"`
	Encrypted           aws.BooleanValue `ec2:"Encrypted" xml:"encrypted"`
	IOPS                aws.IntegerValue `ec2:"Iops" xml:"iops"`
	SnapshotID          aws.StringValue  `ec2:"SnapshotId" xml:"snapshotId"`
	VolumeSize          aws.IntegerValue `ec2:"VolumeSize" xml:"volumeSize"`
	VolumeType          aws.StringValue  `ec2:"VolumeType" xml:"volumeType"`
}

// EBSInstanceBlockDevice is undocumented.
type EBSInstanceBlockDevice struct {
	AttachTime          time.Time        `ec2:"AttachTime" xml:"attachTime"`
	DeleteOnTermination aws.BooleanValue `ec2:"DeleteOnTermination" xml:"deleteOnTermination"`
	Status              aws.StringValue  `ec2:"Status" xml:"status"`
	VolumeID            aws.StringValue  `ec2:"VolumeId" xml:"volumeId"`
}

// EBSInstanceBlockDeviceSpecification is undocumented.
type EBSInstanceBlockDeviceSpecification struct {
	DeleteOnTermination aws.BooleanValue `ec2:"DeleteOnTermination" xml:"deleteOnTermination"`
	VolumeID            aws.StringValue  `ec2:"VolumeId" xml:"volumeId"`
}

// EnableVGWRoutePropagationRequest is undocumented.
type EnableVGWRoutePropagationRequest struct {
	GatewayID    aws.StringValue `ec2:"GatewayId" xml:"GatewayId"`
	RouteTableID aws.StringValue `ec2:"RouteTableId" xml:"RouteTableId"`
}

// EnableVolumeIORequest is undocumented.
type EnableVolumeIORequest struct {
	DryRun   aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	VolumeID aws.StringValue  `ec2:"VolumeId" xml:"volumeId"`
}

// EnableVPCClassicLinkRequest is undocumented.
type EnableVPCClassicLinkRequest struct {
	DryRun aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	VPCID  aws.StringValue  `ec2:"VpcId" xml:"vpcId"`
}

// EnableVPCClassicLinkResult is undocumented.
type EnableVPCClassicLinkResult struct {
	Return aws.BooleanValue `ec2:"Return" xml:"return"`
}

// Possible values for EC2.
const (
	EventCodeInstanceReboot     = "instance-reboot"
	EventCodeInstanceRetirement = "instance-retirement"
	EventCodeInstanceStop       = "instance-stop"
	EventCodeSystemMaintenance  = "system-maintenance"
	EventCodeSystemReboot       = "system-reboot"
)

// Possible values for EC2.
const (
	ExportEnvironmentCitrix    = "citrix"
	ExportEnvironmentMicrosoft = "microsoft"
	ExportEnvironmentVMware    = "vmware"
)

// ExportTask is undocumented.
type ExportTask struct {
	Description           aws.StringValue        `ec2:"Description" xml:"description"`
	ExportTaskID          aws.StringValue        `ec2:"ExportTaskId" xml:"exportTaskId"`
	ExportToS3Task        *ExportToS3Task        `ec2:"ExportToS3Task" xml:"exportToS3"`
	InstanceExportDetails *InstanceExportDetails `ec2:"InstanceExportDetails" xml:"instanceExport"`
	State                 aws.StringValue        `ec2:"State" xml:"state"`
	StatusMessage         aws.StringValue        `ec2:"StatusMessage" xml:"statusMessage"`
}

// Possible values for EC2.
const (
	ExportTaskStateActive     = "active"
	ExportTaskStateCancelled  = "cancelled"
	ExportTaskStateCancelling = "cancelling"
	ExportTaskStateCompleted  = "completed"
)

// ExportToS3Task is undocumented.
type ExportToS3Task struct {
	ContainerFormat aws.StringValue `ec2:"ContainerFormat" xml:"containerFormat"`
	DiskImageFormat aws.StringValue `ec2:"DiskImageFormat" xml:"diskImageFormat"`
	S3Bucket        aws.StringValue `ec2:"S3Bucket" xml:"s3Bucket"`
	S3Key           aws.StringValue `ec2:"S3Key" xml:"s3Key"`
}

// ExportToS3TaskSpecification is undocumented.
type ExportToS3TaskSpecification struct {
	ContainerFormat aws.StringValue `ec2:"ContainerFormat" xml:"containerFormat"`
	DiskImageFormat aws.StringValue `ec2:"DiskImageFormat" xml:"diskImageFormat"`
	S3Bucket        aws.StringValue `ec2:"S3Bucket" xml:"s3Bucket"`
	S3Prefix        aws.StringValue `ec2:"S3Prefix" xml:"s3Prefix"`
}

// Filter is undocumented.
type Filter struct {
	Name   aws.StringValue `ec2:"Name" xml:"Name"`
	Values []string        `ec2:"Value" xml:"Value>item"`
}

// Possible values for EC2.
const (
	GatewayTypeIPsec1 = "ipsec.1"
)

// GetConsoleOutputRequest is undocumented.
type GetConsoleOutputRequest struct {
	DryRun     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	InstanceID aws.StringValue  `ec2:"InstanceId" xml:"InstanceId"`
}

// GetConsoleOutputResult is undocumented.
type GetConsoleOutputResult struct {
	InstanceID aws.StringValue `ec2:"InstanceId" xml:"instanceId"`
	Output     aws.StringValue `ec2:"Output" xml:"output"`
	Timestamp  time.Time       `ec2:"Timestamp" xml:"timestamp"`
}

// GetPasswordDataRequest is undocumented.
type GetPasswordDataRequest struct {
	DryRun     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	InstanceID aws.StringValue  `ec2:"InstanceId" xml:"InstanceId"`
}

// GetPasswordDataResult is undocumented.
type GetPasswordDataResult struct {
	InstanceID   aws.StringValue `ec2:"InstanceId" xml:"instanceId"`
	PasswordData aws.StringValue `ec2:"PasswordData" xml:"passwordData"`
	Timestamp    time.Time       `ec2:"Timestamp" xml:"timestamp"`
}

// GroupIdentifier is undocumented.
type GroupIdentifier struct {
	GroupID   aws.StringValue `ec2:"GroupId" xml:"groupId"`
	GroupName aws.StringValue `ec2:"GroupName" xml:"groupName"`
}

// Possible values for EC2.
const (
	HypervisorTypeOvm = "ovm"
	HypervisorTypeXen = "xen"
)

// IAMInstanceProfile is undocumented.
type IAMInstanceProfile struct {
	ARN aws.StringValue `ec2:"Arn" xml:"arn"`
	ID  aws.StringValue `ec2:"Id" xml:"id"`
}

// IAMInstanceProfileSpecification is undocumented.
type IAMInstanceProfileSpecification struct {
	ARN  aws.StringValue `ec2:"Arn" xml:"arn"`
	Name aws.StringValue `ec2:"Name" xml:"name"`
}

// ICMPTypeCode is undocumented.
type ICMPTypeCode struct {
	Code aws.IntegerValue `ec2:"Code" xml:"code"`
	Type aws.IntegerValue `ec2:"Type" xml:"type"`
}

// Image is undocumented.
type Image struct {
	Architecture        aws.StringValue      `ec2:"Architecture" xml:"architecture"`
	BlockDeviceMappings []BlockDeviceMapping `ec2:"BlockDeviceMappings" xml:"blockDeviceMapping>item"`
	CreationDate        aws.StringValue      `ec2:"CreationDate" xml:"creationDate"`
	Description         aws.StringValue      `ec2:"Description" xml:"description"`
	Hypervisor          aws.StringValue      `ec2:"Hypervisor" xml:"hypervisor"`
	ImageID             aws.StringValue      `ec2:"ImageId" xml:"imageId"`
	ImageLocation       aws.StringValue      `ec2:"ImageLocation" xml:"imageLocation"`
	ImageOwnerAlias     aws.StringValue      `ec2:"ImageOwnerAlias" xml:"imageOwnerAlias"`
	ImageType           aws.StringValue      `ec2:"ImageType" xml:"imageType"`
	KernelID            aws.StringValue      `ec2:"KernelId" xml:"kernelId"`
	Name                aws.StringValue      `ec2:"Name" xml:"name"`
	OwnerID             aws.StringValue      `ec2:"OwnerId" xml:"imageOwnerId"`
	Platform            aws.StringValue      `ec2:"Platform" xml:"platform"`
	ProductCodes        []ProductCode        `ec2:"ProductCodes" xml:"productCodes>item"`
	Public              aws.BooleanValue     `ec2:"Public" xml:"isPublic"`
	RAMDiskID           aws.StringValue      `ec2:"RamdiskId" xml:"ramdiskId"`
	RootDeviceName      aws.StringValue      `ec2:"RootDeviceName" xml:"rootDeviceName"`
	RootDeviceType      aws.StringValue      `ec2:"RootDeviceType" xml:"rootDeviceType"`
	SRIOVNetSupport     aws.StringValue      `ec2:"SriovNetSupport" xml:"sriovNetSupport"`
	State               aws.StringValue      `ec2:"State" xml:"imageState"`
	StateReason         *StateReason         `ec2:"StateReason" xml:"stateReason"`
	Tags                []Tag                `ec2:"Tags" xml:"tagSet>item"`
	VirtualizationType  aws.StringValue      `ec2:"VirtualizationType" xml:"virtualizationType"`
}

// ImageAttribute is undocumented.
type ImageAttribute struct {
	BlockDeviceMappings []BlockDeviceMapping `ec2:"BlockDeviceMappings" xml:"blockDeviceMapping>item"`
	Description         *AttributeValue      `ec2:"Description" xml:"description"`
	ImageID             aws.StringValue      `ec2:"ImageId" xml:"imageId"`
	KernelID            *AttributeValue      `ec2:"KernelId" xml:"kernel"`
	LaunchPermissions   []LaunchPermission   `ec2:"LaunchPermissions" xml:"launchPermission>item"`
	ProductCodes        []ProductCode        `ec2:"ProductCodes" xml:"productCodes>item"`
	RAMDiskID           *AttributeValue      `ec2:"RamdiskId" xml:"ramdisk"`
	SRIOVNetSupport     *AttributeValue      `ec2:"SriovNetSupport" xml:"sriovNetSupport"`
}

// Possible values for EC2.
const (
	ImageAttributeNameBlockDeviceMapping = "blockDeviceMapping"
	ImageAttributeNameDescription        = "description"
	ImageAttributeNameKernel             = "kernel"
	ImageAttributeNameLaunchPermission   = "launchPermission"
	ImageAttributeNameProductCodes       = "productCodes"
	ImageAttributeNameRAMDisk            = "ramdisk"
)

// Possible values for EC2.
const (
	ImageStateAvailable    = "available"
	ImageStateDeregistered = "deregistered"
)

// Possible values for EC2.
const (
	ImageTypeValuesKernel  = "kernel"
	ImageTypeValuesMachine = "machine"
	ImageTypeValuesRAMDisk = "ramdisk"
)

// ImportInstanceLaunchSpecification is undocumented.
type ImportInstanceLaunchSpecification struct {
	AdditionalInfo                    aws.StringValue  `ec2:"AdditionalInfo" xml:"additionalInfo"`
	Architecture                      aws.StringValue  `ec2:"Architecture" xml:"architecture"`
	GroupIDs                          []string         `ec2:"GroupId" xml:"GroupId>SecurityGroupId"`
	GroupNames                        []string         `ec2:"GroupName" xml:"GroupName>SecurityGroup"`
	InstanceInitiatedShutdownBehavior aws.StringValue  `ec2:"InstanceInitiatedShutdownBehavior" xml:"instanceInitiatedShutdownBehavior"`
	InstanceType                      aws.StringValue  `ec2:"InstanceType" xml:"instanceType"`
	Monitoring                        aws.BooleanValue `ec2:"Monitoring" xml:"monitoring"`
	Placement                         *Placement       `ec2:"Placement" xml:"placement"`
	PrivateIPAddress                  aws.StringValue  `ec2:"PrivateIpAddress" xml:"privateIpAddress"`
	SubnetID                          aws.StringValue  `ec2:"SubnetId" xml:"subnetId"`
	UserData                          *UserData        `ec2:"UserData" xml:"userData"`
}

// ImportInstanceRequest is undocumented.
type ImportInstanceRequest struct {
	Description         aws.StringValue                    `ec2:"Description" xml:"description"`
	DiskImages          []DiskImage                        `ec2:"DiskImages" xml:"diskImage>member"`
	DryRun              aws.BooleanValue                   `ec2:"DryRun" xml:"dryRun"`
	LaunchSpecification *ImportInstanceLaunchSpecification `ec2:"LaunchSpecification" xml:"launchSpecification"`
	Platform            aws.StringValue                    `ec2:"Platform" xml:"platform"`
}

// ImportInstanceResult is undocumented.
type ImportInstanceResult struct {
	ConversionTask *ConversionTask `ec2:"ConversionTask" xml:"conversionTask"`
}

// ImportInstanceTaskDetails is undocumented.
type ImportInstanceTaskDetails struct {
	Description aws.StringValue                  `ec2:"Description" xml:"description"`
	InstanceID  aws.StringValue                  `ec2:"InstanceId" xml:"instanceId"`
	Platform    aws.StringValue                  `ec2:"Platform" xml:"platform"`
	Volumes     []ImportInstanceVolumeDetailItem `ec2:"Volumes" xml:"volumes>item"`
}

// ImportInstanceVolumeDetailItem is undocumented.
type ImportInstanceVolumeDetailItem struct {
	AvailabilityZone aws.StringValue             `ec2:"AvailabilityZone" xml:"availabilityZone"`
	BytesConverted   aws.LongValue               `ec2:"BytesConverted" xml:"bytesConverted"`
	Description      aws.StringValue             `ec2:"Description" xml:"description"`
	Image            *DiskImageDescription       `ec2:"Image" xml:"image"`
	Status           aws.StringValue             `ec2:"Status" xml:"status"`
	StatusMessage    aws.StringValue             `ec2:"StatusMessage" xml:"statusMessage"`
	Volume           *DiskImageVolumeDescription `ec2:"Volume" xml:"volume"`
}

// ImportKeyPairRequest is undocumented.
type ImportKeyPairRequest struct {
	DryRun            aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	KeyName           aws.StringValue  `ec2:"KeyName" xml:"keyName"`
	PublicKeyMaterial []byte           `ec2:"PublicKeyMaterial" xml:"publicKeyMaterial"`
}

// ImportKeyPairResult is undocumented.
type ImportKeyPairResult struct {
	KeyFingerprint aws.StringValue `ec2:"KeyFingerprint" xml:"keyFingerprint"`
	KeyName        aws.StringValue `ec2:"KeyName" xml:"keyName"`
}

// ImportVolumeRequest is undocumented.
type ImportVolumeRequest struct {
	AvailabilityZone aws.StringValue  `ec2:"AvailabilityZone" xml:"availabilityZone"`
	Description      aws.StringValue  `ec2:"Description" xml:"description"`
	DryRun           aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Image            *DiskImageDetail `ec2:"Image" xml:"image"`
	Volume           *VolumeDetail    `ec2:"Volume" xml:"volume"`
}

// ImportVolumeResult is undocumented.
type ImportVolumeResult struct {
	ConversionTask *ConversionTask `ec2:"ConversionTask" xml:"conversionTask"`
}

// ImportVolumeTaskDetails is undocumented.
type ImportVolumeTaskDetails struct {
	AvailabilityZone aws.StringValue             `ec2:"AvailabilityZone" xml:"availabilityZone"`
	BytesConverted   aws.LongValue               `ec2:"BytesConverted" xml:"bytesConverted"`
	Description      aws.StringValue             `ec2:"Description" xml:"description"`
	Image            *DiskImageDescription       `ec2:"Image" xml:"image"`
	Volume           *DiskImageVolumeDescription `ec2:"Volume" xml:"volume"`
}

// Instance is undocumented.
type Instance struct {
	AMILaunchIndex        aws.IntegerValue             `ec2:"AmiLaunchIndex" xml:"amiLaunchIndex"`
	Architecture          aws.StringValue              `ec2:"Architecture" xml:"architecture"`
	BlockDeviceMappings   []InstanceBlockDeviceMapping `ec2:"BlockDeviceMappings" xml:"blockDeviceMapping>item"`
	ClientToken           aws.StringValue              `ec2:"ClientToken" xml:"clientToken"`
	EBSOptimized          aws.BooleanValue             `ec2:"EbsOptimized" xml:"ebsOptimized"`
	Hypervisor            aws.StringValue              `ec2:"Hypervisor" xml:"hypervisor"`
	IAMInstanceProfile    *IAMInstanceProfile          `ec2:"IamInstanceProfile" xml:"iamInstanceProfile"`
	ImageID               aws.StringValue              `ec2:"ImageId" xml:"imageId"`
	InstanceID            aws.StringValue              `ec2:"InstanceId" xml:"instanceId"`
	InstanceLifecycle     aws.StringValue              `ec2:"InstanceLifecycle" xml:"instanceLifecycle"`
	InstanceType          aws.StringValue              `ec2:"InstanceType" xml:"instanceType"`
	KernelID              aws.StringValue              `ec2:"KernelId" xml:"kernelId"`
	KeyName               aws.StringValue              `ec2:"KeyName" xml:"keyName"`
	LaunchTime            time.Time                    `ec2:"LaunchTime" xml:"launchTime"`
	Monitoring            *Monitoring                  `ec2:"Monitoring" xml:"monitoring"`
	NetworkInterfaces     []InstanceNetworkInterface   `ec2:"NetworkInterfaces" xml:"networkInterfaceSet>item"`
	Placement             *Placement                   `ec2:"Placement" xml:"placement"`
	Platform              aws.StringValue              `ec2:"Platform" xml:"platform"`
	PrivateDNSName        aws.StringValue              `ec2:"PrivateDnsName" xml:"privateDnsName"`
	PrivateIPAddress      aws.StringValue              `ec2:"PrivateIpAddress" xml:"privateIpAddress"`
	ProductCodes          []ProductCode                `ec2:"ProductCodes" xml:"productCodes>item"`
	PublicDNSName         aws.StringValue              `ec2:"PublicDnsName" xml:"dnsName"`
	PublicIPAddress       aws.StringValue              `ec2:"PublicIpAddress" xml:"ipAddress"`
	RAMDiskID             aws.StringValue              `ec2:"RamdiskId" xml:"ramdiskId"`
	RootDeviceName        aws.StringValue              `ec2:"RootDeviceName" xml:"rootDeviceName"`
	RootDeviceType        aws.StringValue              `ec2:"RootDeviceType" xml:"rootDeviceType"`
	SecurityGroups        []GroupIdentifier            `ec2:"SecurityGroups" xml:"groupSet>item"`
	SourceDestCheck       aws.BooleanValue             `ec2:"SourceDestCheck" xml:"sourceDestCheck"`
	SpotInstanceRequestID aws.StringValue              `ec2:"SpotInstanceRequestId" xml:"spotInstanceRequestId"`
	SRIOVNetSupport       aws.StringValue              `ec2:"SriovNetSupport" xml:"sriovNetSupport"`
	State                 *InstanceState               `ec2:"State" xml:"instanceState"`
	StateReason           *StateReason                 `ec2:"StateReason" xml:"stateReason"`
	StateTransitionReason aws.StringValue              `ec2:"StateTransitionReason" xml:"reason"`
	SubnetID              aws.StringValue              `ec2:"SubnetId" xml:"subnetId"`
	Tags                  []Tag                        `ec2:"Tags" xml:"tagSet>item"`
	VirtualizationType    aws.StringValue              `ec2:"VirtualizationType" xml:"virtualizationType"`
	VPCID                 aws.StringValue              `ec2:"VpcId" xml:"vpcId"`
}

// InstanceAttribute is undocumented.
type InstanceAttribute struct {
	BlockDeviceMappings               []InstanceBlockDeviceMapping `ec2:"BlockDeviceMappings" xml:"blockDeviceMapping>item"`
	DisableAPITermination             *AttributeBooleanValue       `ec2:"DisableApiTermination" xml:"disableApiTermination"`
	EBSOptimized                      *AttributeBooleanValue       `ec2:"EbsOptimized" xml:"ebsOptimized"`
	Groups                            []GroupIdentifier            `ec2:"Groups" xml:"groupSet>item"`
	InstanceID                        aws.StringValue              `ec2:"InstanceId" xml:"instanceId"`
	InstanceInitiatedShutdownBehavior *AttributeValue              `ec2:"InstanceInitiatedShutdownBehavior" xml:"instanceInitiatedShutdownBehavior"`
	InstanceType                      *AttributeValue              `ec2:"InstanceType" xml:"instanceType"`
	KernelID                          *AttributeValue              `ec2:"KernelId" xml:"kernel"`
	ProductCodes                      []ProductCode                `ec2:"ProductCodes" xml:"productCodes>item"`
	RAMDiskID                         *AttributeValue              `ec2:"RamdiskId" xml:"ramdisk"`
	RootDeviceName                    *AttributeValue              `ec2:"RootDeviceName" xml:"rootDeviceName"`
	SourceDestCheck                   *AttributeBooleanValue       `ec2:"SourceDestCheck" xml:"sourceDestCheck"`
	SRIOVNetSupport                   *AttributeValue              `ec2:"SriovNetSupport" xml:"sriovNetSupport"`
	UserData                          *AttributeValue              `ec2:"UserData" xml:"userData"`
}

// Possible values for EC2.
const (
	InstanceAttributeNameBlockDeviceMapping                = "blockDeviceMapping"
	InstanceAttributeNameDisableAPITermination             = "disableApiTermination"
	InstanceAttributeNameEBSOptimized                      = "ebsOptimized"
	InstanceAttributeNameGroupSet                          = "groupSet"
	InstanceAttributeNameInstanceInitiatedShutdownBehavior = "instanceInitiatedShutdownBehavior"
	InstanceAttributeNameInstanceType                      = "instanceType"
	InstanceAttributeNameKernel                            = "kernel"
	InstanceAttributeNameProductCodes                      = "productCodes"
	InstanceAttributeNameRAMDisk                           = "ramdisk"
	InstanceAttributeNameRootDeviceName                    = "rootDeviceName"
	InstanceAttributeNameSRIOVNetSupport                   = "sriovNetSupport"
	InstanceAttributeNameSourceDestCheck                   = "sourceDestCheck"
	InstanceAttributeNameUserData                          = "userData"
)

// InstanceBlockDeviceMapping is undocumented.
type InstanceBlockDeviceMapping struct {
	DeviceName aws.StringValue         `ec2:"DeviceName" xml:"deviceName"`
	EBS        *EBSInstanceBlockDevice `ec2:"Ebs" xml:"ebs"`
}

// InstanceBlockDeviceMappingSpecification is undocumented.
type InstanceBlockDeviceMappingSpecification struct {
	DeviceName  aws.StringValue                      `ec2:"DeviceName" xml:"deviceName"`
	EBS         *EBSInstanceBlockDeviceSpecification `ec2:"Ebs" xml:"ebs"`
	NoDevice    aws.StringValue                      `ec2:"NoDevice" xml:"noDevice"`
	VirtualName aws.StringValue                      `ec2:"VirtualName" xml:"virtualName"`
}

// InstanceCount is undocumented.
type InstanceCount struct {
	InstanceCount aws.IntegerValue `ec2:"InstanceCount" xml:"instanceCount"`
	State         aws.StringValue  `ec2:"State" xml:"state"`
}

// InstanceExportDetails is undocumented.
type InstanceExportDetails struct {
	InstanceID        aws.StringValue `ec2:"InstanceId" xml:"instanceId"`
	TargetEnvironment aws.StringValue `ec2:"TargetEnvironment" xml:"targetEnvironment"`
}

// Possible values for EC2.
const (
	InstanceLifecycleTypeSpot = "spot"
)

// InstanceMonitoring is undocumented.
type InstanceMonitoring struct {
	InstanceID aws.StringValue `ec2:"InstanceId" xml:"instanceId"`
	Monitoring *Monitoring     `ec2:"Monitoring" xml:"monitoring"`
}

// InstanceNetworkInterface is undocumented.
type InstanceNetworkInterface struct {
	Association        *InstanceNetworkInterfaceAssociation `ec2:"Association" xml:"association"`
	Attachment         *InstanceNetworkInterfaceAttachment  `ec2:"Attachment" xml:"attachment"`
	Description        aws.StringValue                      `ec2:"Description" xml:"description"`
	Groups             []GroupIdentifier                    `ec2:"Groups" xml:"groupSet>item"`
	MACAddress         aws.StringValue                      `ec2:"MacAddress" xml:"macAddress"`
	NetworkInterfaceID aws.StringValue                      `ec2:"NetworkInterfaceId" xml:"networkInterfaceId"`
	OwnerID            aws.StringValue                      `ec2:"OwnerId" xml:"ownerId"`
	PrivateDNSName     aws.StringValue                      `ec2:"PrivateDnsName" xml:"privateDnsName"`
	PrivateIPAddress   aws.StringValue                      `ec2:"PrivateIpAddress" xml:"privateIpAddress"`
	PrivateIPAddresses []InstancePrivateIPAddress           `ec2:"PrivateIpAddresses" xml:"privateIpAddressesSet>item"`
	SourceDestCheck    aws.BooleanValue                     `ec2:"SourceDestCheck" xml:"sourceDestCheck"`
	Status             aws.StringValue                      `ec2:"Status" xml:"status"`
	SubnetID           aws.StringValue                      `ec2:"SubnetId" xml:"subnetId"`
	VPCID              aws.StringValue                      `ec2:"VpcId" xml:"vpcId"`
}

// InstanceNetworkInterfaceAssociation is undocumented.
type InstanceNetworkInterfaceAssociation struct {
	IPOwnerID     aws.StringValue `ec2:"IpOwnerId" xml:"ipOwnerId"`
	PublicDNSName aws.StringValue `ec2:"PublicDnsName" xml:"publicDnsName"`
	PublicIP      aws.StringValue `ec2:"PublicIp" xml:"publicIp"`
}

// InstanceNetworkInterfaceAttachment is undocumented.
type InstanceNetworkInterfaceAttachment struct {
	AttachTime          time.Time        `ec2:"AttachTime" xml:"attachTime"`
	AttachmentID        aws.StringValue  `ec2:"AttachmentId" xml:"attachmentId"`
	DeleteOnTermination aws.BooleanValue `ec2:"DeleteOnTermination" xml:"deleteOnTermination"`
	DeviceIndex         aws.IntegerValue `ec2:"DeviceIndex" xml:"deviceIndex"`
	Status              aws.StringValue  `ec2:"Status" xml:"status"`
}

// InstanceNetworkInterfaceSpecification is undocumented.
type InstanceNetworkInterfaceSpecification struct {
	AssociatePublicIPAddress       aws.BooleanValue                `ec2:"AssociatePublicIpAddress" xml:"associatePublicIpAddress"`
	DeleteOnTermination            aws.BooleanValue                `ec2:"DeleteOnTermination" xml:"deleteOnTermination"`
	Description                    aws.StringValue                 `ec2:"Description" xml:"description"`
	DeviceIndex                    aws.IntegerValue                `ec2:"DeviceIndex" xml:"deviceIndex"`
	Groups                         []string                        `ec2:"SecurityGroupId" xml:"SecurityGroupId>SecurityGroupId"`
	NetworkInterfaceID             aws.StringValue                 `ec2:"NetworkInterfaceId" xml:"networkInterfaceId"`
	PrivateIPAddress               aws.StringValue                 `ec2:"PrivateIpAddress" xml:"privateIpAddress"`
	PrivateIPAddresses             []PrivateIPAddressSpecification `ec2:"PrivateIpAddresses" xml:"privateIpAddressesSet>item"`
	SecondaryPrivateIPAddressCount aws.IntegerValue                `ec2:"SecondaryPrivateIpAddressCount" xml:"secondaryPrivateIpAddressCount"`
	SubnetID                       aws.StringValue                 `ec2:"SubnetId" xml:"subnetId"`
}

// InstancePrivateIPAddress is undocumented.
type InstancePrivateIPAddress struct {
	Association      *InstanceNetworkInterfaceAssociation `ec2:"Association" xml:"association"`
	Primary          aws.BooleanValue                     `ec2:"Primary" xml:"primary"`
	PrivateDNSName   aws.StringValue                      `ec2:"PrivateDnsName" xml:"privateDnsName"`
	PrivateIPAddress aws.StringValue                      `ec2:"PrivateIpAddress" xml:"privateIpAddress"`
}

// InstanceState is undocumented.
type InstanceState struct {
	Code aws.IntegerValue `ec2:"Code" xml:"code"`
	Name aws.StringValue  `ec2:"Name" xml:"name"`
}

// InstanceStateChange is undocumented.
type InstanceStateChange struct {
	CurrentState  *InstanceState  `ec2:"CurrentState" xml:"currentState"`
	InstanceID    aws.StringValue `ec2:"InstanceId" xml:"instanceId"`
	PreviousState *InstanceState  `ec2:"PreviousState" xml:"previousState"`
}

// Possible values for EC2.
const (
	InstanceStateNamePending      = "pending"
	InstanceStateNameRunning      = "running"
	InstanceStateNameShuttingDown = "shutting-down"
	InstanceStateNameStopped      = "stopped"
	InstanceStateNameStopping     = "stopping"
	InstanceStateNameTerminated   = "terminated"
)

// InstanceStatus is undocumented.
type InstanceStatus struct {
	AvailabilityZone aws.StringValue        `ec2:"AvailabilityZone" xml:"availabilityZone"`
	Events           []InstanceStatusEvent  `ec2:"Events" xml:"eventsSet>item"`
	InstanceID       aws.StringValue        `ec2:"InstanceId" xml:"instanceId"`
	InstanceState    *InstanceState         `ec2:"InstanceState" xml:"instanceState"`
	InstanceStatus   *InstanceStatusSummary `ec2:"InstanceStatus" xml:"instanceStatus"`
	SystemStatus     *InstanceStatusSummary `ec2:"SystemStatus" xml:"systemStatus"`
}

// InstanceStatusDetails is undocumented.
type InstanceStatusDetails struct {
	ImpairedSince time.Time       `ec2:"ImpairedSince" xml:"impairedSince"`
	Name          aws.StringValue `ec2:"Name" xml:"name"`
	Status        aws.StringValue `ec2:"Status" xml:"status"`
}

// InstanceStatusEvent is undocumented.
type InstanceStatusEvent struct {
	Code        aws.StringValue `ec2:"Code" xml:"code"`
	Description aws.StringValue `ec2:"Description" xml:"description"`
	NotAfter    time.Time       `ec2:"NotAfter" xml:"notAfter"`
	NotBefore   time.Time       `ec2:"NotBefore" xml:"notBefore"`
}

// InstanceStatusSummary is undocumented.
type InstanceStatusSummary struct {
	Details []InstanceStatusDetails `ec2:"Details" xml:"details>item"`
	Status  aws.StringValue         `ec2:"Status" xml:"status"`
}

// Possible values for EC2.
const (
	InstanceTypeC1Medium   = "c1.medium"
	InstanceTypeC1Xlarge   = "c1.xlarge"
	InstanceTypeC32xlarge  = "c3.2xlarge"
	InstanceTypeC34xlarge  = "c3.4xlarge"
	InstanceTypeC38xlarge  = "c3.8xlarge"
	InstanceTypeC3Large    = "c3.large"
	InstanceTypeC3Xlarge   = "c3.xlarge"
	InstanceTypeC42xlarge  = "c4.2xlarge"
	InstanceTypeC44xlarge  = "c4.4xlarge"
	InstanceTypeC48xlarge  = "c4.8xlarge"
	InstanceTypeC4Large    = "c4.large"
	InstanceTypeC4Xlarge   = "c4.xlarge"
	InstanceTypeCc14xlarge = "cc1.4xlarge"
	InstanceTypeCc28xlarge = "cc2.8xlarge"
	InstanceTypeCg14xlarge = "cg1.4xlarge"
	InstanceTypeCr18xlarge = "cr1.8xlarge"
	InstanceTypeG22xlarge  = "g2.2xlarge"
	InstanceTypeHi14xlarge = "hi1.4xlarge"
	InstanceTypeHs18xlarge = "hs1.8xlarge"
	InstanceTypeI22xlarge  = "i2.2xlarge"
	InstanceTypeI24xlarge  = "i2.4xlarge"
	InstanceTypeI28xlarge  = "i2.8xlarge"
	InstanceTypeI2Xlarge   = "i2.xlarge"
	InstanceTypeM1Large    = "m1.large"
	InstanceTypeM1Medium   = "m1.medium"
	InstanceTypeM1Small    = "m1.small"
	InstanceTypeM1Xlarge   = "m1.xlarge"
	InstanceTypeM22xlarge  = "m2.2xlarge"
	InstanceTypeM24xlarge  = "m2.4xlarge"
	InstanceTypeM2Xlarge   = "m2.xlarge"
	InstanceTypeM32xlarge  = "m3.2xlarge"
	InstanceTypeM3Large    = "m3.large"
	InstanceTypeM3Medium   = "m3.medium"
	InstanceTypeM3Xlarge   = "m3.xlarge"
	InstanceTypeR32xlarge  = "r3.2xlarge"
	InstanceTypeR34xlarge  = "r3.4xlarge"
	InstanceTypeR38xlarge  = "r3.8xlarge"
	InstanceTypeR3Large    = "r3.large"
	InstanceTypeR3Xlarge   = "r3.xlarge"
	InstanceTypeT1Micro    = "t1.micro"
	InstanceTypeT2Medium   = "t2.medium"
	InstanceTypeT2Micro    = "t2.micro"
	InstanceTypeT2Small    = "t2.small"
)

// InternetGateway is undocumented.
type InternetGateway struct {
	Attachments       []InternetGatewayAttachment `ec2:"Attachments" xml:"attachmentSet>item"`
	InternetGatewayID aws.StringValue             `ec2:"InternetGatewayId" xml:"internetGatewayId"`
	Tags              []Tag                       `ec2:"Tags" xml:"tagSet>item"`
}

// InternetGatewayAttachment is undocumented.
type InternetGatewayAttachment struct {
	State aws.StringValue `ec2:"State" xml:"state"`
	VPCID aws.StringValue `ec2:"VpcId" xml:"vpcId"`
}

// IPPermission is undocumented.
type IPPermission struct {
	FromPort         aws.IntegerValue  `ec2:"FromPort" xml:"fromPort"`
	IPProtocol       aws.StringValue   `ec2:"IpProtocol" xml:"ipProtocol"`
	IPRanges         []IPRange         `ec2:"IpRanges" xml:"ipRanges>item"`
	ToPort           aws.IntegerValue  `ec2:"ToPort" xml:"toPort"`
	UserIDGroupPairs []UserIDGroupPair `ec2:"UserIdGroupPairs" xml:"groups>item"`
}

// IPRange is undocumented.
type IPRange struct {
	CIDRIP aws.StringValue `ec2:"CidrIp" xml:"cidrIp"`
}

// KeyPair is undocumented.
type KeyPair struct {
	KeyFingerprint aws.StringValue `ec2:"KeyFingerprint" xml:"keyFingerprint"`
	KeyMaterial    aws.StringValue `ec2:"KeyMaterial" xml:"keyMaterial"`
	KeyName        aws.StringValue `ec2:"KeyName" xml:"keyName"`
}

// KeyPairInfo is undocumented.
type KeyPairInfo struct {
	KeyFingerprint aws.StringValue `ec2:"KeyFingerprint" xml:"keyFingerprint"`
	KeyName        aws.StringValue `ec2:"KeyName" xml:"keyName"`
}

// LaunchPermission is undocumented.
type LaunchPermission struct {
	Group  aws.StringValue `ec2:"Group" xml:"group"`
	UserID aws.StringValue `ec2:"UserId" xml:"userId"`
}

// LaunchPermissionModifications is undocumented.
type LaunchPermissionModifications struct {
	Add    []LaunchPermission `ec2:"Add" xml:"Add>item"`
	Remove []LaunchPermission `ec2:"Remove" xml:"Remove>item"`
}

// LaunchSpecification is undocumented.
type LaunchSpecification struct {
	AddressingType      aws.StringValue                         `ec2:"AddressingType" xml:"addressingType"`
	BlockDeviceMappings []BlockDeviceMapping                    `ec2:"BlockDeviceMappings" xml:"blockDeviceMapping>item"`
	EBSOptimized        aws.BooleanValue                        `ec2:"EbsOptimized" xml:"ebsOptimized"`
	IAMInstanceProfile  *IAMInstanceProfileSpecification        `ec2:"IamInstanceProfile" xml:"iamInstanceProfile"`
	ImageID             aws.StringValue                         `ec2:"ImageId" xml:"imageId"`
	InstanceType        aws.StringValue                         `ec2:"InstanceType" xml:"instanceType"`
	KernelID            aws.StringValue                         `ec2:"KernelId" xml:"kernelId"`
	KeyName             aws.StringValue                         `ec2:"KeyName" xml:"keyName"`
	Monitoring          *RunInstancesMonitoringEnabled          `ec2:"Monitoring" xml:"monitoring"`
	NetworkInterfaces   []InstanceNetworkInterfaceSpecification `ec2:"NetworkInterfaces" xml:"networkInterfaceSet>item"`
	Placement           *SpotPlacement                          `ec2:"Placement" xml:"placement"`
	RAMDiskID           aws.StringValue                         `ec2:"RamdiskId" xml:"ramdiskId"`
	SecurityGroups      []GroupIdentifier                       `ec2:"SecurityGroups" xml:"groupSet>item"`
	SubnetID            aws.StringValue                         `ec2:"SubnetId" xml:"subnetId"`
	UserData            aws.StringValue                         `ec2:"UserData" xml:"userData"`
}

// Possible values for EC2.
const (
	ListingStateAvailable = "available"
	ListingStateCancelled = "cancelled"
	ListingStatePending   = "pending"
	ListingStateSold      = "sold"
)

// Possible values for EC2.
const (
	ListingStatusActive    = "active"
	ListingStatusCancelled = "cancelled"
	ListingStatusClosed    = "closed"
	ListingStatusPending   = "pending"
)

// ModifyImageAttributeRequest is undocumented.
type ModifyImageAttributeRequest struct {
	Attribute        aws.StringValue                `ec2:"Attribute" xml:"Attribute"`
	Description      *AttributeValue                `ec2:"Description" xml:"Description"`
	DryRun           aws.BooleanValue               `ec2:"DryRun" xml:"dryRun"`
	ImageID          aws.StringValue                `ec2:"ImageId" xml:"ImageId"`
	LaunchPermission *LaunchPermissionModifications `ec2:"LaunchPermission" xml:"LaunchPermission"`
	OperationType    aws.StringValue                `ec2:"OperationType" xml:"OperationType"`
	ProductCodes     []string                       `ec2:"ProductCode" xml:"ProductCode>ProductCode"`
	UserGroups       []string                       `ec2:"UserGroup" xml:"UserGroup>UserGroup"`
	UserIDs          []string                       `ec2:"UserId" xml:"UserId>UserId"`
	Value            aws.StringValue                `ec2:"Value" xml:"Value"`
}

// ModifyInstanceAttributeRequest is undocumented.
type ModifyInstanceAttributeRequest struct {
	Attribute                         aws.StringValue                           `ec2:"Attribute" xml:"attribute"`
	BlockDeviceMappings               []InstanceBlockDeviceMappingSpecification `ec2:"BlockDeviceMappings" xml:"blockDeviceMapping>item"`
	DisableAPITermination             *AttributeBooleanValue                    `ec2:"DisableApiTermination" xml:"disableApiTermination"`
	DryRun                            aws.BooleanValue                          `ec2:"DryRun" xml:"dryRun"`
	EBSOptimized                      *AttributeBooleanValue                    `ec2:"EbsOptimized" xml:"ebsOptimized"`
	Groups                            []string                                  `ec2:"GroupId" xml:"GroupId>groupId"`
	InstanceID                        aws.StringValue                           `ec2:"InstanceId" xml:"instanceId"`
	InstanceInitiatedShutdownBehavior *AttributeValue                           `ec2:"InstanceInitiatedShutdownBehavior" xml:"instanceInitiatedShutdownBehavior"`
	InstanceType                      *AttributeValue                           `ec2:"InstanceType" xml:"instanceType"`
	Kernel                            *AttributeValue                           `ec2:"Kernel" xml:"kernel"`
	RAMDisk                           *AttributeValue                           `ec2:"Ramdisk" xml:"ramdisk"`
	SourceDestCheck                   *AttributeBooleanValue                    `ec2:"SourceDestCheck" xml:"SourceDestCheck"`
	SRIOVNetSupport                   *AttributeValue                           `ec2:"SriovNetSupport" xml:"sriovNetSupport"`
	UserData                          *BlobAttributeValue                       `ec2:"UserData" xml:"userData"`
	Value                             aws.StringValue                           `ec2:"Value" xml:"value"`
}

// ModifyNetworkInterfaceAttributeRequest is undocumented.
type ModifyNetworkInterfaceAttributeRequest struct {
	Attachment         *NetworkInterfaceAttachmentChanges `ec2:"Attachment" xml:"attachment"`
	Description        *AttributeValue                    `ec2:"Description" xml:"description"`
	DryRun             aws.BooleanValue                   `ec2:"DryRun" xml:"dryRun"`
	Groups             []string                           `ec2:"SecurityGroupId" xml:"SecurityGroupId>SecurityGroupId"`
	NetworkInterfaceID aws.StringValue                    `ec2:"NetworkInterfaceId" xml:"networkInterfaceId"`
	SourceDestCheck    *AttributeBooleanValue             `ec2:"SourceDestCheck" xml:"sourceDestCheck"`
}

// ModifyReservedInstancesRequest is undocumented.
type ModifyReservedInstancesRequest struct {
	ClientToken          aws.StringValue                  `ec2:"ClientToken" xml:"clientToken"`
	ReservedInstancesIDs []string                         `ec2:"ReservedInstancesId" xml:"ReservedInstancesId>ReservedInstancesId"`
	TargetConfigurations []ReservedInstancesConfiguration `ec2:"ReservedInstancesConfigurationSetItemType" xml:"ReservedInstancesConfigurationSetItemType>item"`
}

// ModifyReservedInstancesResult is undocumented.
type ModifyReservedInstancesResult struct {
	ReservedInstancesModificationID aws.StringValue `ec2:"ReservedInstancesModificationId" xml:"reservedInstancesModificationId"`
}

// ModifySnapshotAttributeRequest is undocumented.
type ModifySnapshotAttributeRequest struct {
	Attribute              aws.StringValue                      `ec2:"Attribute" xml:"Attribute"`
	CreateVolumePermission *CreateVolumePermissionModifications `ec2:"CreateVolumePermission" xml:"CreateVolumePermission"`
	DryRun                 aws.BooleanValue                     `ec2:"DryRun" xml:"dryRun"`
	GroupNames             []string                             `ec2:"UserGroup" xml:"UserGroup>GroupName"`
	OperationType          aws.StringValue                      `ec2:"OperationType" xml:"OperationType"`
	SnapshotID             aws.StringValue                      `ec2:"SnapshotId" xml:"SnapshotId"`
	UserIDs                []string                             `ec2:"UserId" xml:"UserId>UserId"`
}

// ModifySubnetAttributeRequest is undocumented.
type ModifySubnetAttributeRequest struct {
	MapPublicIPOnLaunch *AttributeBooleanValue `ec2:"MapPublicIpOnLaunch" xml:"MapPublicIpOnLaunch"`
	SubnetID            aws.StringValue        `ec2:"SubnetId" xml:"subnetId"`
}

// ModifyVolumeAttributeRequest is undocumented.
type ModifyVolumeAttributeRequest struct {
	AutoEnableIO *AttributeBooleanValue `ec2:"AutoEnableIO" xml:"AutoEnableIO"`
	DryRun       aws.BooleanValue       `ec2:"DryRun" xml:"dryRun"`
	VolumeID     aws.StringValue        `ec2:"VolumeId" xml:"VolumeId"`
}

// ModifyVPCAttributeRequest is undocumented.
type ModifyVPCAttributeRequest struct {
	EnableDNSHostnames *AttributeBooleanValue `ec2:"EnableDnsHostnames" xml:"EnableDnsHostnames"`
	EnableDNSSupport   *AttributeBooleanValue `ec2:"EnableDnsSupport" xml:"EnableDnsSupport"`
	VPCID              aws.StringValue        `ec2:"VpcId" xml:"vpcId"`
}

// MonitorInstancesRequest is undocumented.
type MonitorInstancesRequest struct {
	DryRun      aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	InstanceIDs []string         `ec2:"InstanceId" xml:"InstanceId>InstanceId"`
}

// MonitorInstancesResult is undocumented.
type MonitorInstancesResult struct {
	InstanceMonitorings []InstanceMonitoring `ec2:"InstanceMonitorings" xml:"instancesSet>item"`
}

// Monitoring is undocumented.
type Monitoring struct {
	State aws.StringValue `ec2:"State" xml:"state"`
}

// Possible values for EC2.
const (
	MonitoringStateDisabled = "disabled"
	MonitoringStateEnabled  = "enabled"
	MonitoringStatePending  = "pending"
)

// NetworkACL is undocumented.
type NetworkACL struct {
	Associations []NetworkACLAssociation `ec2:"Associations" xml:"associationSet>item"`
	Entries      []NetworkACLEntry       `ec2:"Entries" xml:"entrySet>item"`
	IsDefault    aws.BooleanValue        `ec2:"IsDefault" xml:"default"`
	NetworkACLID aws.StringValue         `ec2:"NetworkAclId" xml:"networkAclId"`
	Tags         []Tag                   `ec2:"Tags" xml:"tagSet>item"`
	VPCID        aws.StringValue         `ec2:"VpcId" xml:"vpcId"`
}

// NetworkACLAssociation is undocumented.
type NetworkACLAssociation struct {
	NetworkACLAssociationID aws.StringValue `ec2:"NetworkAclAssociationId" xml:"networkAclAssociationId"`
	NetworkACLID            aws.StringValue `ec2:"NetworkAclId" xml:"networkAclId"`
	SubnetID                aws.StringValue `ec2:"SubnetId" xml:"subnetId"`
}

// NetworkACLEntry is undocumented.
type NetworkACLEntry struct {
	CIDRBlock    aws.StringValue  `ec2:"CidrBlock" xml:"cidrBlock"`
	Egress       aws.BooleanValue `ec2:"Egress" xml:"egress"`
	ICMPTypeCode *ICMPTypeCode    `ec2:"IcmpTypeCode" xml:"icmpTypeCode"`
	PortRange    *PortRange       `ec2:"PortRange" xml:"portRange"`
	Protocol     aws.StringValue  `ec2:"Protocol" xml:"protocol"`
	RuleAction   aws.StringValue  `ec2:"RuleAction" xml:"ruleAction"`
	RuleNumber   aws.IntegerValue `ec2:"RuleNumber" xml:"ruleNumber"`
}

// NetworkInterface is undocumented.
type NetworkInterface struct {
	Association        *NetworkInterfaceAssociation       `ec2:"Association" xml:"association"`
	Attachment         *NetworkInterfaceAttachment        `ec2:"Attachment" xml:"attachment"`
	AvailabilityZone   aws.StringValue                    `ec2:"AvailabilityZone" xml:"availabilityZone"`
	Description        aws.StringValue                    `ec2:"Description" xml:"description"`
	Groups             []GroupIdentifier                  `ec2:"Groups" xml:"groupSet>item"`
	MACAddress         aws.StringValue                    `ec2:"MacAddress" xml:"macAddress"`
	NetworkInterfaceID aws.StringValue                    `ec2:"NetworkInterfaceId" xml:"networkInterfaceId"`
	OwnerID            aws.StringValue                    `ec2:"OwnerId" xml:"ownerId"`
	PrivateDNSName     aws.StringValue                    `ec2:"PrivateDnsName" xml:"privateDnsName"`
	PrivateIPAddress   aws.StringValue                    `ec2:"PrivateIpAddress" xml:"privateIpAddress"`
	PrivateIPAddresses []NetworkInterfacePrivateIPAddress `ec2:"PrivateIpAddresses" xml:"privateIpAddressesSet>item"`
	RequesterID        aws.StringValue                    `ec2:"RequesterId" xml:"requesterId"`
	RequesterManaged   aws.BooleanValue                   `ec2:"RequesterManaged" xml:"requesterManaged"`
	SourceDestCheck    aws.BooleanValue                   `ec2:"SourceDestCheck" xml:"sourceDestCheck"`
	Status             aws.StringValue                    `ec2:"Status" xml:"status"`
	SubnetID           aws.StringValue                    `ec2:"SubnetId" xml:"subnetId"`
	TagSet             []Tag                              `ec2:"TagSet" xml:"tagSet>item"`
	VPCID              aws.StringValue                    `ec2:"VpcId" xml:"vpcId"`
}

// NetworkInterfaceAssociation is undocumented.
type NetworkInterfaceAssociation struct {
	AllocationID  aws.StringValue `ec2:"AllocationId" xml:"allocationId"`
	AssociationID aws.StringValue `ec2:"AssociationId" xml:"associationId"`
	IPOwnerID     aws.StringValue `ec2:"IpOwnerId" xml:"ipOwnerId"`
	PublicDNSName aws.StringValue `ec2:"PublicDnsName" xml:"publicDnsName"`
	PublicIP      aws.StringValue `ec2:"PublicIp" xml:"publicIp"`
}

// NetworkInterfaceAttachment is undocumented.
type NetworkInterfaceAttachment struct {
	AttachTime          time.Time        `ec2:"AttachTime" xml:"attachTime"`
	AttachmentID        aws.StringValue  `ec2:"AttachmentId" xml:"attachmentId"`
	DeleteOnTermination aws.BooleanValue `ec2:"DeleteOnTermination" xml:"deleteOnTermination"`
	DeviceIndex         aws.IntegerValue `ec2:"DeviceIndex" xml:"deviceIndex"`
	InstanceID          aws.StringValue  `ec2:"InstanceId" xml:"instanceId"`
	InstanceOwnerID     aws.StringValue  `ec2:"InstanceOwnerId" xml:"instanceOwnerId"`
	Status              aws.StringValue  `ec2:"Status" xml:"status"`
}

// NetworkInterfaceAttachmentChanges is undocumented.
type NetworkInterfaceAttachmentChanges struct {
	AttachmentID        aws.StringValue  `ec2:"AttachmentId" xml:"attachmentId"`
	DeleteOnTermination aws.BooleanValue `ec2:"DeleteOnTermination" xml:"deleteOnTermination"`
}

// Possible values for EC2.
const (
	NetworkInterfaceAttributeAttachment      = "attachment"
	NetworkInterfaceAttributeDescription     = "description"
	NetworkInterfaceAttributeGroupSet        = "groupSet"
	NetworkInterfaceAttributeSourceDestCheck = "sourceDestCheck"
)

// NetworkInterfacePrivateIPAddress is undocumented.
type NetworkInterfacePrivateIPAddress struct {
	Association      *NetworkInterfaceAssociation `ec2:"Association" xml:"association"`
	Primary          aws.BooleanValue             `ec2:"Primary" xml:"primary"`
	PrivateDNSName   aws.StringValue              `ec2:"PrivateDnsName" xml:"privateDnsName"`
	PrivateIPAddress aws.StringValue              `ec2:"PrivateIpAddress" xml:"privateIpAddress"`
}

// Possible values for EC2.
const (
	NetworkInterfaceStatusAttaching = "attaching"
	NetworkInterfaceStatusAvailable = "available"
	NetworkInterfaceStatusDetaching = "detaching"
	NetworkInterfaceStatusInUse     = "in-use"
)

// NewDHCPConfiguration is undocumented.
type NewDHCPConfiguration struct {
	Key    aws.StringValue `ec2:"Key" xml:"key"`
	Values []string        `ec2:"Value" xml:"Value>item"`
}

// Possible values for EC2.
const (
	OfferingTypeValuesHeavyUtilization  = "Heavy Utilization"
	OfferingTypeValuesLightUtilization  = "Light Utilization"
	OfferingTypeValuesMediumUtilization = "Medium Utilization"
)

// Possible values for EC2.
const (
	PermissionGroupAll = "all"
)

// Placement is undocumented.
type Placement struct {
	AvailabilityZone aws.StringValue `ec2:"AvailabilityZone" xml:"availabilityZone"`
	GroupName        aws.StringValue `ec2:"GroupName" xml:"groupName"`
	Tenancy          aws.StringValue `ec2:"Tenancy" xml:"tenancy"`
}

// PlacementGroup is undocumented.
type PlacementGroup struct {
	GroupName aws.StringValue `ec2:"GroupName" xml:"groupName"`
	State     aws.StringValue `ec2:"State" xml:"state"`
	Strategy  aws.StringValue `ec2:"Strategy" xml:"strategy"`
}

// Possible values for EC2.
const (
	PlacementGroupStateAvailable = "available"
	PlacementGroupStateDeleted   = "deleted"
	PlacementGroupStateDeleting  = "deleting"
	PlacementGroupStatePending   = "pending"
)

// Possible values for EC2.
const (
	PlacementStrategyCluster = "cluster"
)

// Possible values for EC2.
const (
	PlatformValuesWindows = "Windows"
)

// PortRange is undocumented.
type PortRange struct {
	From aws.IntegerValue `ec2:"From" xml:"from"`
	To   aws.IntegerValue `ec2:"To" xml:"to"`
}

// PriceSchedule is undocumented.
type PriceSchedule struct {
	Active       aws.BooleanValue `ec2:"Active" xml:"active"`
	CurrencyCode aws.StringValue  `ec2:"CurrencyCode" xml:"currencyCode"`
	Price        aws.DoubleValue  `ec2:"Price" xml:"price"`
	Term         aws.LongValue    `ec2:"Term" xml:"term"`
}

// PriceScheduleSpecification is undocumented.
type PriceScheduleSpecification struct {
	CurrencyCode aws.StringValue `ec2:"CurrencyCode" xml:"currencyCode"`
	Price        aws.DoubleValue `ec2:"Price" xml:"price"`
	Term         aws.LongValue   `ec2:"Term" xml:"term"`
}

// PricingDetail is undocumented.
type PricingDetail struct {
	Count aws.IntegerValue `ec2:"Count" xml:"count"`
	Price aws.DoubleValue  `ec2:"Price" xml:"price"`
}

// PrivateIPAddressSpecification is undocumented.
type PrivateIPAddressSpecification struct {
	Primary          aws.BooleanValue `ec2:"Primary" xml:"primary"`
	PrivateIPAddress aws.StringValue  `ec2:"PrivateIpAddress" xml:"privateIpAddress"`
}

// ProductCode is undocumented.
type ProductCode struct {
	ProductCodeID   aws.StringValue `ec2:"ProductCodeId" xml:"productCode"`
	ProductCodeType aws.StringValue `ec2:"ProductCodeType" xml:"type"`
}

// Possible values for EC2.
const (
	ProductCodeValuesDevpay      = "devpay"
	ProductCodeValuesMarketplace = "marketplace"
)

// PropagatingVGW is undocumented.
type PropagatingVGW struct {
	GatewayID aws.StringValue `ec2:"GatewayId" xml:"gatewayId"`
}

// PurchaseReservedInstancesOfferingRequest is undocumented.
type PurchaseReservedInstancesOfferingRequest struct {
	DryRun                      aws.BooleanValue            `ec2:"DryRun" xml:"dryRun"`
	InstanceCount               aws.IntegerValue            `ec2:"InstanceCount" xml:"InstanceCount"`
	LimitPrice                  *ReservedInstanceLimitPrice `ec2:"LimitPrice" xml:"limitPrice"`
	ReservedInstancesOfferingID aws.StringValue             `ec2:"ReservedInstancesOfferingId" xml:"ReservedInstancesOfferingId"`
}

// PurchaseReservedInstancesOfferingResult is undocumented.
type PurchaseReservedInstancesOfferingResult struct {
	ReservedInstancesID aws.StringValue `ec2:"ReservedInstancesId" xml:"reservedInstancesId"`
}

// Possible values for EC2.
const (
	RIProductDescriptionLinuxUnix          = "Linux/UNIX"
	RIProductDescriptionLinuxUnixamazonVPC = "Linux/UNIX (Amazon VPC)"
	RIProductDescriptionWindows            = "Windows"
	RIProductDescriptionWindowsAmazonVPC   = "Windows (Amazon VPC)"
)

// RebootInstancesRequest is undocumented.
type RebootInstancesRequest struct {
	DryRun      aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	InstanceIDs []string         `ec2:"InstanceId" xml:"InstanceId>InstanceId"`
}

// RecurringCharge is undocumented.
type RecurringCharge struct {
	Amount    aws.DoubleValue `ec2:"Amount" xml:"amount"`
	Frequency aws.StringValue `ec2:"Frequency" xml:"frequency"`
}

// Possible values for EC2.
const (
	RecurringChargeFrequencyHourly = "Hourly"
)

// Region is undocumented.
type Region struct {
	Endpoint   aws.StringValue `ec2:"Endpoint" xml:"regionEndpoint"`
	RegionName aws.StringValue `ec2:"RegionName" xml:"regionName"`
}

// RegisterImageRequest is undocumented.
type RegisterImageRequest struct {
	Architecture        aws.StringValue      `ec2:"Architecture" xml:"architecture"`
	BlockDeviceMappings []BlockDeviceMapping `ec2:"BlockDeviceMapping" xml:"BlockDeviceMapping>BlockDeviceMapping"`
	Description         aws.StringValue      `ec2:"Description" xml:"description"`
	DryRun              aws.BooleanValue     `ec2:"DryRun" xml:"dryRun"`
	ImageLocation       aws.StringValue      `ec2:"ImageLocation" xml:"ImageLocation"`
	KernelID            aws.StringValue      `ec2:"KernelId" xml:"kernelId"`
	Name                aws.StringValue      `ec2:"Name" xml:"name"`
	RAMDiskID           aws.StringValue      `ec2:"RamdiskId" xml:"ramdiskId"`
	RootDeviceName      aws.StringValue      `ec2:"RootDeviceName" xml:"rootDeviceName"`
	SRIOVNetSupport     aws.StringValue      `ec2:"SriovNetSupport" xml:"sriovNetSupport"`
	VirtualizationType  aws.StringValue      `ec2:"VirtualizationType" xml:"virtualizationType"`
}

// RegisterImageResult is undocumented.
type RegisterImageResult struct {
	ImageID aws.StringValue `ec2:"ImageId" xml:"imageId"`
}

// RejectVPCPeeringConnectionRequest is undocumented.
type RejectVPCPeeringConnectionRequest struct {
	DryRun                 aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	VPCPeeringConnectionID aws.StringValue  `ec2:"VpcPeeringConnectionId" xml:"vpcPeeringConnectionId"`
}

// RejectVPCPeeringConnectionResult is undocumented.
type RejectVPCPeeringConnectionResult struct {
	Return aws.BooleanValue `ec2:"Return" xml:"return"`
}

// ReleaseAddressRequest is undocumented.
type ReleaseAddressRequest struct {
	AllocationID aws.StringValue  `ec2:"AllocationId" xml:"AllocationId"`
	DryRun       aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	PublicIP     aws.StringValue  `ec2:"PublicIp" xml:"PublicIp"`
}

// ReplaceNetworkACLAssociationRequest is undocumented.
type ReplaceNetworkACLAssociationRequest struct {
	AssociationID aws.StringValue  `ec2:"AssociationId" xml:"associationId"`
	DryRun        aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	NetworkACLID  aws.StringValue  `ec2:"NetworkAclId" xml:"networkAclId"`
}

// ReplaceNetworkACLAssociationResult is undocumented.
type ReplaceNetworkACLAssociationResult struct {
	NewAssociationID aws.StringValue `ec2:"NewAssociationId" xml:"newAssociationId"`
}

// ReplaceNetworkACLEntryRequest is undocumented.
type ReplaceNetworkACLEntryRequest struct {
	CIDRBlock    aws.StringValue  `ec2:"CidrBlock" xml:"cidrBlock"`
	DryRun       aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Egress       aws.BooleanValue `ec2:"Egress" xml:"egress"`
	ICMPTypeCode *ICMPTypeCode    `ec2:"Icmp" xml:"Icmp"`
	NetworkACLID aws.StringValue  `ec2:"NetworkAclId" xml:"networkAclId"`
	PortRange    *PortRange       `ec2:"PortRange" xml:"portRange"`
	Protocol     aws.StringValue  `ec2:"Protocol" xml:"protocol"`
	RuleAction   aws.StringValue  `ec2:"RuleAction" xml:"ruleAction"`
	RuleNumber   aws.IntegerValue `ec2:"RuleNumber" xml:"ruleNumber"`
}

// ReplaceRouteRequest is undocumented.
type ReplaceRouteRequest struct {
	DestinationCIDRBlock   aws.StringValue  `ec2:"DestinationCidrBlock" xml:"destinationCidrBlock"`
	DryRun                 aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	GatewayID              aws.StringValue  `ec2:"GatewayId" xml:"gatewayId"`
	InstanceID             aws.StringValue  `ec2:"InstanceId" xml:"instanceId"`
	NetworkInterfaceID     aws.StringValue  `ec2:"NetworkInterfaceId" xml:"networkInterfaceId"`
	RouteTableID           aws.StringValue  `ec2:"RouteTableId" xml:"routeTableId"`
	VPCPeeringConnectionID aws.StringValue  `ec2:"VpcPeeringConnectionId" xml:"vpcPeeringConnectionId"`
}

// ReplaceRouteTableAssociationRequest is undocumented.
type ReplaceRouteTableAssociationRequest struct {
	AssociationID aws.StringValue  `ec2:"AssociationId" xml:"associationId"`
	DryRun        aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	RouteTableID  aws.StringValue  `ec2:"RouteTableId" xml:"routeTableId"`
}

// ReplaceRouteTableAssociationResult is undocumented.
type ReplaceRouteTableAssociationResult struct {
	NewAssociationID aws.StringValue `ec2:"NewAssociationId" xml:"newAssociationId"`
}

// Possible values for EC2.
const (
	ReportInstanceReasonCodesInstanceStuckInState     = "instance-stuck-in-state"
	ReportInstanceReasonCodesNotAcceptingCredentials  = "not-accepting-credentials"
	ReportInstanceReasonCodesOther                    = "other"
	ReportInstanceReasonCodesPasswordNotAvailable     = "password-not-available"
	ReportInstanceReasonCodesPerformanceEBSVolume     = "performance-ebs-volume"
	ReportInstanceReasonCodesPerformanceInstanceStore = "performance-instance-store"
	ReportInstanceReasonCodesPerformanceNetwork       = "performance-network"
	ReportInstanceReasonCodesPerformanceOther         = "performance-other"
	ReportInstanceReasonCodesUnresponsive             = "unresponsive"
)

// ReportInstanceStatusRequest is undocumented.
type ReportInstanceStatusRequest struct {
	Description aws.StringValue  `ec2:"Description" xml:"description"`
	DryRun      aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	EndTime     time.Time        `ec2:"EndTime" xml:"endTime"`
	Instances   []string         `ec2:"Instances" xml:"instanceId>InstanceId"`
	ReasonCodes []string         `ec2:"ReasonCodes" xml:"reasonCode>item"`
	StartTime   time.Time        `ec2:"StartTime" xml:"startTime"`
	Status      aws.StringValue  `ec2:"Status" xml:"status"`
}

// Possible values for EC2.
const (
	ReportStatusTypeImpaired = "impaired"
	ReportStatusTypeOK       = "ok"
)

// RequestSpotInstancesRequest is undocumented.
type RequestSpotInstancesRequest struct {
	AvailabilityZoneGroup aws.StringValue                 `ec2:"AvailabilityZoneGroup" xml:"availabilityZoneGroup"`
	DryRun                aws.BooleanValue                `ec2:"DryRun" xml:"dryRun"`
	InstanceCount         aws.IntegerValue                `ec2:"InstanceCount" xml:"instanceCount"`
	LaunchGroup           aws.StringValue                 `ec2:"LaunchGroup" xml:"launchGroup"`
	LaunchSpecification   *RequestSpotLaunchSpecification `ec2:"LaunchSpecification" xml:"LaunchSpecification"`
	SpotPrice             aws.StringValue                 `ec2:"SpotPrice" xml:"spotPrice"`
	Type                  aws.StringValue                 `ec2:"Type" xml:"type"`
	ValidFrom             time.Time                       `ec2:"ValidFrom" xml:"validFrom"`
	ValidUntil            time.Time                       `ec2:"ValidUntil" xml:"validUntil"`
}

// RequestSpotInstancesResult is undocumented.
type RequestSpotInstancesResult struct {
	SpotInstanceRequests []SpotInstanceRequest `ec2:"SpotInstanceRequests" xml:"spotInstanceRequestSet>item"`
}

// RequestSpotLaunchSpecification is undocumented.
type RequestSpotLaunchSpecification struct {
	AddressingType      aws.StringValue                         `ec2:"AddressingType" xml:"addressingType"`
	BlockDeviceMappings []BlockDeviceMapping                    `ec2:"BlockDeviceMappings" xml:"blockDeviceMapping>item"`
	EBSOptimized        aws.BooleanValue                        `ec2:"EbsOptimized" xml:"ebsOptimized"`
	IAMInstanceProfile  *IAMInstanceProfileSpecification        `ec2:"IamInstanceProfile" xml:"iamInstanceProfile"`
	ImageID             aws.StringValue                         `ec2:"ImageId" xml:"imageId"`
	InstanceType        aws.StringValue                         `ec2:"InstanceType" xml:"instanceType"`
	KernelID            aws.StringValue                         `ec2:"KernelId" xml:"kernelId"`
	KeyName             aws.StringValue                         `ec2:"KeyName" xml:"keyName"`
	Monitoring          *RunInstancesMonitoringEnabled          `ec2:"Monitoring" xml:"monitoring"`
	NetworkInterfaces   []InstanceNetworkInterfaceSpecification `ec2:"NetworkInterface" xml:"NetworkInterface>item"`
	Placement           *SpotPlacement                          `ec2:"Placement" xml:"placement"`
	RAMDiskID           aws.StringValue                         `ec2:"RamdiskId" xml:"ramdiskId"`
	SecurityGroupIDs    []string                                `ec2:"SecurityGroupId" xml:"SecurityGroupId>item"`
	SecurityGroups      []string                                `ec2:"SecurityGroup" xml:"SecurityGroup>item"`
	SubnetID            aws.StringValue                         `ec2:"SubnetId" xml:"subnetId"`
	UserData            aws.StringValue                         `ec2:"UserData" xml:"userData"`
}

// Reservation is undocumented.
type Reservation struct {
	Groups        []GroupIdentifier `ec2:"Groups" xml:"groupSet>item"`
	Instances     []Instance        `ec2:"Instances" xml:"instancesSet>item"`
	OwnerID       aws.StringValue   `ec2:"OwnerId" xml:"ownerId"`
	RequesterID   aws.StringValue   `ec2:"RequesterId" xml:"requesterId"`
	ReservationID aws.StringValue   `ec2:"ReservationId" xml:"reservationId"`
}

// ReservedInstanceLimitPrice is undocumented.
type ReservedInstanceLimitPrice struct {
	Amount       aws.DoubleValue `ec2:"Amount" xml:"amount"`
	CurrencyCode aws.StringValue `ec2:"CurrencyCode" xml:"currencyCode"`
}

// Possible values for EC2.
const (
	ReservedInstanceStateActive         = "active"
	ReservedInstanceStatePaymentFailed  = "payment-failed"
	ReservedInstanceStatePaymentPending = "payment-pending"
	ReservedInstanceStateRetired        = "retired"
)

// ReservedInstances is undocumented.
type ReservedInstances struct {
	AvailabilityZone    aws.StringValue   `ec2:"AvailabilityZone" xml:"availabilityZone"`
	CurrencyCode        aws.StringValue   `ec2:"CurrencyCode" xml:"currencyCode"`
	Duration            aws.LongValue     `ec2:"Duration" xml:"duration"`
	End                 time.Time         `ec2:"End" xml:"end"`
	FixedPrice          aws.FloatValue    `ec2:"FixedPrice" xml:"fixedPrice"`
	InstanceCount       aws.IntegerValue  `ec2:"InstanceCount" xml:"instanceCount"`
	InstanceTenancy     aws.StringValue   `ec2:"InstanceTenancy" xml:"instanceTenancy"`
	InstanceType        aws.StringValue   `ec2:"InstanceType" xml:"instanceType"`
	OfferingType        aws.StringValue   `ec2:"OfferingType" xml:"offeringType"`
	ProductDescription  aws.StringValue   `ec2:"ProductDescription" xml:"productDescription"`
	RecurringCharges    []RecurringCharge `ec2:"RecurringCharges" xml:"recurringCharges>item"`
	ReservedInstancesID aws.StringValue   `ec2:"ReservedInstancesId" xml:"reservedInstancesId"`
	Start               time.Time         `ec2:"Start" xml:"start"`
	State               aws.StringValue   `ec2:"State" xml:"state"`
	Tags                []Tag             `ec2:"Tags" xml:"tagSet>item"`
	UsagePrice          aws.FloatValue    `ec2:"UsagePrice" xml:"usagePrice"`
}

// ReservedInstancesConfiguration is undocumented.
type ReservedInstancesConfiguration struct {
	AvailabilityZone aws.StringValue  `ec2:"AvailabilityZone" xml:"availabilityZone"`
	InstanceCount    aws.IntegerValue `ec2:"InstanceCount" xml:"instanceCount"`
	InstanceType     aws.StringValue  `ec2:"InstanceType" xml:"instanceType"`
	Platform         aws.StringValue  `ec2:"Platform" xml:"platform"`
}

// ReservedInstancesID is undocumented.
type ReservedInstancesID struct {
	ReservedInstancesID aws.StringValue `ec2:"ReservedInstancesId" xml:"reservedInstancesId"`
}

// ReservedInstancesListing is undocumented.
type ReservedInstancesListing struct {
	ClientToken                aws.StringValue `ec2:"ClientToken" xml:"clientToken"`
	CreateDate                 time.Time       `ec2:"CreateDate" xml:"createDate"`
	InstanceCounts             []InstanceCount `ec2:"InstanceCounts" xml:"instanceCounts>item"`
	PriceSchedules             []PriceSchedule `ec2:"PriceSchedules" xml:"priceSchedules>item"`
	ReservedInstancesID        aws.StringValue `ec2:"ReservedInstancesId" xml:"reservedInstancesId"`
	ReservedInstancesListingID aws.StringValue `ec2:"ReservedInstancesListingId" xml:"reservedInstancesListingId"`
	Status                     aws.StringValue `ec2:"Status" xml:"status"`
	StatusMessage              aws.StringValue `ec2:"StatusMessage" xml:"statusMessage"`
	Tags                       []Tag           `ec2:"Tags" xml:"tagSet>item"`
	UpdateDate                 time.Time       `ec2:"UpdateDate" xml:"updateDate"`
}

// ReservedInstancesModification is undocumented.
type ReservedInstancesModification struct {
	ClientToken                     aws.StringValue                       `ec2:"ClientToken" xml:"clientToken"`
	CreateDate                      time.Time                             `ec2:"CreateDate" xml:"createDate"`
	EffectiveDate                   time.Time                             `ec2:"EffectiveDate" xml:"effectiveDate"`
	ModificationResults             []ReservedInstancesModificationResult `ec2:"ModificationResults" xml:"modificationResultSet>item"`
	ReservedInstancesIDs            []ReservedInstancesID                 `ec2:"ReservedInstancesIds" xml:"reservedInstancesSet>item"`
	ReservedInstancesModificationID aws.StringValue                       `ec2:"ReservedInstancesModificationId" xml:"reservedInstancesModificationId"`
	Status                          aws.StringValue                       `ec2:"Status" xml:"status"`
	StatusMessage                   aws.StringValue                       `ec2:"StatusMessage" xml:"statusMessage"`
	UpdateDate                      time.Time                             `ec2:"UpdateDate" xml:"updateDate"`
}

// ReservedInstancesModificationResult is undocumented.
type ReservedInstancesModificationResult struct {
	ReservedInstancesID aws.StringValue                 `ec2:"ReservedInstancesId" xml:"reservedInstancesId"`
	TargetConfiguration *ReservedInstancesConfiguration `ec2:"TargetConfiguration" xml:"targetConfiguration"`
}

// ReservedInstancesOffering is undocumented.
type ReservedInstancesOffering struct {
	AvailabilityZone            aws.StringValue   `ec2:"AvailabilityZone" xml:"availabilityZone"`
	CurrencyCode                aws.StringValue   `ec2:"CurrencyCode" xml:"currencyCode"`
	Duration                    aws.LongValue     `ec2:"Duration" xml:"duration"`
	FixedPrice                  aws.FloatValue    `ec2:"FixedPrice" xml:"fixedPrice"`
	InstanceTenancy             aws.StringValue   `ec2:"InstanceTenancy" xml:"instanceTenancy"`
	InstanceType                aws.StringValue   `ec2:"InstanceType" xml:"instanceType"`
	Marketplace                 aws.BooleanValue  `ec2:"Marketplace" xml:"marketplace"`
	OfferingType                aws.StringValue   `ec2:"OfferingType" xml:"offeringType"`
	PricingDetails              []PricingDetail   `ec2:"PricingDetails" xml:"pricingDetailsSet>item"`
	ProductDescription          aws.StringValue   `ec2:"ProductDescription" xml:"productDescription"`
	RecurringCharges            []RecurringCharge `ec2:"RecurringCharges" xml:"recurringCharges>item"`
	ReservedInstancesOfferingID aws.StringValue   `ec2:"ReservedInstancesOfferingId" xml:"reservedInstancesOfferingId"`
	UsagePrice                  aws.FloatValue    `ec2:"UsagePrice" xml:"usagePrice"`
}

// Possible values for EC2.
const (
	ResetImageAttributeNameLaunchPermission = "launchPermission"
)

// ResetImageAttributeRequest is undocumented.
type ResetImageAttributeRequest struct {
	Attribute aws.StringValue  `ec2:"Attribute" xml:"Attribute"`
	DryRun    aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	ImageID   aws.StringValue  `ec2:"ImageId" xml:"ImageId"`
}

// ResetInstanceAttributeRequest is undocumented.
type ResetInstanceAttributeRequest struct {
	Attribute  aws.StringValue  `ec2:"Attribute" xml:"attribute"`
	DryRun     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	InstanceID aws.StringValue  `ec2:"InstanceId" xml:"instanceId"`
}

// ResetNetworkInterfaceAttributeRequest is undocumented.
type ResetNetworkInterfaceAttributeRequest struct {
	DryRun             aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	NetworkInterfaceID aws.StringValue  `ec2:"NetworkInterfaceId" xml:"networkInterfaceId"`
	SourceDestCheck    aws.StringValue  `ec2:"SourceDestCheck" xml:"sourceDestCheck"`
}

// ResetSnapshotAttributeRequest is undocumented.
type ResetSnapshotAttributeRequest struct {
	Attribute  aws.StringValue  `ec2:"Attribute" xml:"Attribute"`
	DryRun     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	SnapshotID aws.StringValue  `ec2:"SnapshotId" xml:"SnapshotId"`
}

// Possible values for EC2.
const (
	ResourceTypeCustomerGateway      = "customer-gateway"
	ResourceTypeDHCPOptions          = "dhcp-options"
	ResourceTypeImage                = "image"
	ResourceTypeInstance             = "instance"
	ResourceTypeInternetGateway      = "internet-gateway"
	ResourceTypeNetworkACL           = "network-acl"
	ResourceTypeNetworkInterface     = "network-interface"
	ResourceTypeReservedInstances    = "reserved-instances"
	ResourceTypeRouteTable           = "route-table"
	ResourceTypeSecurityGroup        = "security-group"
	ResourceTypeSnapshot             = "snapshot"
	ResourceTypeSpotInstancesRequest = "spot-instances-request"
	ResourceTypeSubnet               = "subnet"
	ResourceTypeVPC                  = "vpc"
	ResourceTypeVPNConnection        = "vpn-connection"
	ResourceTypeVPNGateway           = "vpn-gateway"
	ResourceTypeVolume               = "volume"
)

// RevokeSecurityGroupEgressRequest is undocumented.
type RevokeSecurityGroupEgressRequest struct {
	CIDRIP                     aws.StringValue  `ec2:"CidrIp" xml:"cidrIp"`
	DryRun                     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	FromPort                   aws.IntegerValue `ec2:"FromPort" xml:"fromPort"`
	GroupID                    aws.StringValue  `ec2:"GroupId" xml:"groupId"`
	IPPermissions              []IPPermission   `ec2:"IpPermissions" xml:"ipPermissions>item"`
	IPProtocol                 aws.StringValue  `ec2:"IpProtocol" xml:"ipProtocol"`
	SourceSecurityGroupName    aws.StringValue  `ec2:"SourceSecurityGroupName" xml:"sourceSecurityGroupName"`
	SourceSecurityGroupOwnerID aws.StringValue  `ec2:"SourceSecurityGroupOwnerId" xml:"sourceSecurityGroupOwnerId"`
	ToPort                     aws.IntegerValue `ec2:"ToPort" xml:"toPort"`
}

// RevokeSecurityGroupIngressRequest is undocumented.
type RevokeSecurityGroupIngressRequest struct {
	CIDRIP                     aws.StringValue  `ec2:"CidrIp" xml:"CidrIp"`
	DryRun                     aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	FromPort                   aws.IntegerValue `ec2:"FromPort" xml:"FromPort"`
	GroupID                    aws.StringValue  `ec2:"GroupId" xml:"GroupId"`
	GroupName                  aws.StringValue  `ec2:"GroupName" xml:"GroupName"`
	IPPermissions              []IPPermission   `ec2:"IpPermissions" xml:"IpPermissions>item"`
	IPProtocol                 aws.StringValue  `ec2:"IpProtocol" xml:"IpProtocol"`
	SourceSecurityGroupName    aws.StringValue  `ec2:"SourceSecurityGroupName" xml:"SourceSecurityGroupName"`
	SourceSecurityGroupOwnerID aws.StringValue  `ec2:"SourceSecurityGroupOwnerId" xml:"SourceSecurityGroupOwnerId"`
	ToPort                     aws.IntegerValue `ec2:"ToPort" xml:"ToPort"`
}

// Route is undocumented.
type Route struct {
	DestinationCIDRBlock   aws.StringValue `ec2:"DestinationCidrBlock" xml:"destinationCidrBlock"`
	GatewayID              aws.StringValue `ec2:"GatewayId" xml:"gatewayId"`
	InstanceID             aws.StringValue `ec2:"InstanceId" xml:"instanceId"`
	InstanceOwnerID        aws.StringValue `ec2:"InstanceOwnerId" xml:"instanceOwnerId"`
	NetworkInterfaceID     aws.StringValue `ec2:"NetworkInterfaceId" xml:"networkInterfaceId"`
	Origin                 aws.StringValue `ec2:"Origin" xml:"origin"`
	State                  aws.StringValue `ec2:"State" xml:"state"`
	VPCPeeringConnectionID aws.StringValue `ec2:"VpcPeeringConnectionId" xml:"vpcPeeringConnectionId"`
}

// Possible values for EC2.
const (
	RouteOriginCreateRoute               = "CreateRoute"
	RouteOriginCreateRouteTable          = "CreateRouteTable"
	RouteOriginEnableVGWRoutePropagation = "EnableVgwRoutePropagation"
)

// Possible values for EC2.
const (
	RouteStateActive    = "active"
	RouteStateBlackhole = "blackhole"
)

// RouteTable is undocumented.
type RouteTable struct {
	Associations    []RouteTableAssociation `ec2:"Associations" xml:"associationSet>item"`
	PropagatingVGWs []PropagatingVGW        `ec2:"PropagatingVgws" xml:"propagatingVgwSet>item"`
	RouteTableID    aws.StringValue         `ec2:"RouteTableId" xml:"routeTableId"`
	Routes          []Route                 `ec2:"Routes" xml:"routeSet>item"`
	Tags            []Tag                   `ec2:"Tags" xml:"tagSet>item"`
	VPCID           aws.StringValue         `ec2:"VpcId" xml:"vpcId"`
}

// RouteTableAssociation is undocumented.
type RouteTableAssociation struct {
	Main                    aws.BooleanValue `ec2:"Main" xml:"main"`
	RouteTableAssociationID aws.StringValue  `ec2:"RouteTableAssociationId" xml:"routeTableAssociationId"`
	RouteTableID            aws.StringValue  `ec2:"RouteTableId" xml:"routeTableId"`
	SubnetID                aws.StringValue  `ec2:"SubnetId" xml:"subnetId"`
}

// Possible values for EC2.
const (
	RuleActionAllow = "allow"
	RuleActionDeny  = "deny"
)

// RunInstancesMonitoringEnabled is undocumented.
type RunInstancesMonitoringEnabled struct {
	Enabled aws.BooleanValue `ec2:"Enabled" xml:"enabled"`
}

// RunInstancesRequest is undocumented.
type RunInstancesRequest struct {
	AdditionalInfo                    aws.StringValue                         `ec2:"AdditionalInfo" xml:"additionalInfo"`
	BlockDeviceMappings               []BlockDeviceMapping                    `ec2:"BlockDeviceMapping" xml:"BlockDeviceMapping>BlockDeviceMapping"`
	ClientToken                       aws.StringValue                         `ec2:"ClientToken" xml:"clientToken"`
	DisableAPITermination             aws.BooleanValue                        `ec2:"DisableApiTermination" xml:"disableApiTermination"`
	DryRun                            aws.BooleanValue                        `ec2:"DryRun" xml:"dryRun"`
	EBSOptimized                      aws.BooleanValue                        `ec2:"EbsOptimized" xml:"ebsOptimized"`
	IAMInstanceProfile                *IAMInstanceProfileSpecification        `ec2:"IamInstanceProfile" xml:"iamInstanceProfile"`
	ImageID                           aws.StringValue                         `ec2:"ImageId" xml:"ImageId"`
	InstanceInitiatedShutdownBehavior aws.StringValue                         `ec2:"InstanceInitiatedShutdownBehavior" xml:"instanceInitiatedShutdownBehavior"`
	InstanceType                      aws.StringValue                         `ec2:"InstanceType" xml:"InstanceType"`
	KernelID                          aws.StringValue                         `ec2:"KernelId" xml:"KernelId"`
	KeyName                           aws.StringValue                         `ec2:"KeyName" xml:"KeyName"`
	MaxCount                          aws.IntegerValue                        `ec2:"MaxCount" xml:"MaxCount"`
	MinCount                          aws.IntegerValue                        `ec2:"MinCount" xml:"MinCount"`
	Monitoring                        *RunInstancesMonitoringEnabled          `ec2:"Monitoring" xml:"Monitoring"`
	NetworkInterfaces                 []InstanceNetworkInterfaceSpecification `ec2:"NetworkInterfaces" xml:"networkInterface>item"`
	Placement                         *Placement                              `ec2:"Placement" xml:"Placement"`
	PrivateIPAddress                  aws.StringValue                         `ec2:"PrivateIpAddress" xml:"privateIpAddress"`
	RAMDiskID                         aws.StringValue                         `ec2:"RamdiskId" xml:"RamdiskId"`
	SecurityGroupIDs                  []string                                `ec2:"SecurityGroupId" xml:"SecurityGroupId>SecurityGroupId"`
	SecurityGroups                    []string                                `ec2:"SecurityGroup" xml:"SecurityGroup>SecurityGroup"`
	SubnetID                          aws.StringValue                         `ec2:"SubnetId" xml:"SubnetId"`
	UserData                          aws.StringValue                         `ec2:"UserData" xml:"UserData"`
}

// S3Storage is undocumented.
type S3Storage struct {
	AWSAccessKeyID        aws.StringValue `ec2:"AWSAccessKeyId" xml:"AWSAccessKeyId"`
	Bucket                aws.StringValue `ec2:"Bucket" xml:"bucket"`
	Prefix                aws.StringValue `ec2:"Prefix" xml:"prefix"`
	UploadPolicy          []byte          `ec2:"UploadPolicy" xml:"uploadPolicy"`
	UploadPolicySignature aws.StringValue `ec2:"UploadPolicySignature" xml:"uploadPolicySignature"`
}

// SecurityGroup is undocumented.
type SecurityGroup struct {
	Description         aws.StringValue `ec2:"Description" xml:"groupDescription"`
	GroupID             aws.StringValue `ec2:"GroupId" xml:"groupId"`
	GroupName           aws.StringValue `ec2:"GroupName" xml:"groupName"`
	IPPermissions       []IPPermission  `ec2:"IpPermissions" xml:"ipPermissions>item"`
	IPPermissionsEgress []IPPermission  `ec2:"IpPermissionsEgress" xml:"ipPermissionsEgress>item"`
	OwnerID             aws.StringValue `ec2:"OwnerId" xml:"ownerId"`
	Tags                []Tag           `ec2:"Tags" xml:"tagSet>item"`
	VPCID               aws.StringValue `ec2:"VpcId" xml:"vpcId"`
}

// Possible values for EC2.
const (
	ShutdownBehaviorStop      = "stop"
	ShutdownBehaviorTerminate = "terminate"
)

// Snapshot is undocumented.
type Snapshot struct {
	Description aws.StringValue  `ec2:"Description" xml:"description"`
	Encrypted   aws.BooleanValue `ec2:"Encrypted" xml:"encrypted"`
	KMSKeyID    aws.StringValue  `ec2:"KmsKeyId" xml:"kmsKeyId"`
	OwnerAlias  aws.StringValue  `ec2:"OwnerAlias" xml:"ownerAlias"`
	OwnerID     aws.StringValue  `ec2:"OwnerId" xml:"ownerId"`
	Progress    aws.StringValue  `ec2:"Progress" xml:"progress"`
	SnapshotID  aws.StringValue  `ec2:"SnapshotId" xml:"snapshotId"`
	StartTime   time.Time        `ec2:"StartTime" xml:"startTime"`
	State       aws.StringValue  `ec2:"State" xml:"status"`
	Tags        []Tag            `ec2:"Tags" xml:"tagSet>item"`
	VolumeID    aws.StringValue  `ec2:"VolumeId" xml:"volumeId"`
	VolumeSize  aws.IntegerValue `ec2:"VolumeSize" xml:"volumeSize"`
}

// Possible values for EC2.
const (
	SnapshotAttributeNameCreateVolumePermission = "createVolumePermission"
	SnapshotAttributeNameProductCodes           = "productCodes"
)

// Possible values for EC2.
const (
	SnapshotStateCompleted = "completed"
	SnapshotStateError     = "error"
	SnapshotStatePending   = "pending"
)

// SpotDatafeedSubscription is undocumented.
type SpotDatafeedSubscription struct {
	Bucket  aws.StringValue         `ec2:"Bucket" xml:"bucket"`
	Fault   *SpotInstanceStateFault `ec2:"Fault" xml:"fault"`
	OwnerID aws.StringValue         `ec2:"OwnerId" xml:"ownerId"`
	Prefix  aws.StringValue         `ec2:"Prefix" xml:"prefix"`
	State   aws.StringValue         `ec2:"State" xml:"state"`
}

// SpotInstanceRequest is undocumented.
type SpotInstanceRequest struct {
	AvailabilityZoneGroup    aws.StringValue         `ec2:"AvailabilityZoneGroup" xml:"availabilityZoneGroup"`
	CreateTime               time.Time               `ec2:"CreateTime" xml:"createTime"`
	Fault                    *SpotInstanceStateFault `ec2:"Fault" xml:"fault"`
	InstanceID               aws.StringValue         `ec2:"InstanceId" xml:"instanceId"`
	LaunchGroup              aws.StringValue         `ec2:"LaunchGroup" xml:"launchGroup"`
	LaunchSpecification      *LaunchSpecification    `ec2:"LaunchSpecification" xml:"launchSpecification"`
	LaunchedAvailabilityZone aws.StringValue         `ec2:"LaunchedAvailabilityZone" xml:"launchedAvailabilityZone"`
	ProductDescription       aws.StringValue         `ec2:"ProductDescription" xml:"productDescription"`
	SpotInstanceRequestID    aws.StringValue         `ec2:"SpotInstanceRequestId" xml:"spotInstanceRequestId"`
	SpotPrice                aws.StringValue         `ec2:"SpotPrice" xml:"spotPrice"`
	State                    aws.StringValue         `ec2:"State" xml:"state"`
	Status                   *SpotInstanceStatus     `ec2:"Status" xml:"status"`
	Tags                     []Tag                   `ec2:"Tags" xml:"tagSet>item"`
	Type                     aws.StringValue         `ec2:"Type" xml:"type"`
	ValidFrom                time.Time               `ec2:"ValidFrom" xml:"validFrom"`
	ValidUntil               time.Time               `ec2:"ValidUntil" xml:"validUntil"`
}

// Possible values for EC2.
const (
	SpotInstanceStateActive    = "active"
	SpotInstanceStateCancelled = "cancelled"
	SpotInstanceStateClosed    = "closed"
	SpotInstanceStateFailed    = "failed"
	SpotInstanceStateOpen      = "open"
)

// SpotInstanceStateFault is undocumented.
type SpotInstanceStateFault struct {
	Code    aws.StringValue `ec2:"Code" xml:"code"`
	Message aws.StringValue `ec2:"Message" xml:"message"`
}

// SpotInstanceStatus is undocumented.
type SpotInstanceStatus struct {
	Code       aws.StringValue `ec2:"Code" xml:"code"`
	Message    aws.StringValue `ec2:"Message" xml:"message"`
	UpdateTime time.Time       `ec2:"UpdateTime" xml:"updateTime"`
}

// Possible values for EC2.
const (
	SpotInstanceTypeOneTime    = "one-time"
	SpotInstanceTypePersistent = "persistent"
)

// SpotPlacement is undocumented.
type SpotPlacement struct {
	AvailabilityZone aws.StringValue `ec2:"AvailabilityZone" xml:"availabilityZone"`
	GroupName        aws.StringValue `ec2:"GroupName" xml:"groupName"`
}

// SpotPrice is undocumented.
type SpotPrice struct {
	AvailabilityZone   aws.StringValue `ec2:"AvailabilityZone" xml:"availabilityZone"`
	InstanceType       aws.StringValue `ec2:"InstanceType" xml:"instanceType"`
	ProductDescription aws.StringValue `ec2:"ProductDescription" xml:"productDescription"`
	SpotPrice          aws.StringValue `ec2:"SpotPrice" xml:"spotPrice"`
	Timestamp          time.Time       `ec2:"Timestamp" xml:"timestamp"`
}

// StartInstancesRequest is undocumented.
type StartInstancesRequest struct {
	AdditionalInfo aws.StringValue  `ec2:"AdditionalInfo" xml:"additionalInfo"`
	DryRun         aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	InstanceIDs    []string         `ec2:"InstanceId" xml:"InstanceId>InstanceId"`
}

// StartInstancesResult is undocumented.
type StartInstancesResult struct {
	StartingInstances []InstanceStateChange `ec2:"StartingInstances" xml:"instancesSet>item"`
}

// StateReason is undocumented.
type StateReason struct {
	Code    aws.StringValue `ec2:"Code" xml:"code"`
	Message aws.StringValue `ec2:"Message" xml:"message"`
}

// Possible values for EC2.
const (
	StatusNameReachability = "reachability"
)

// Possible values for EC2.
const (
	StatusTypeFailed           = "failed"
	StatusTypeInsufficientData = "insufficient-data"
	StatusTypePassed           = "passed"
)

// StopInstancesRequest is undocumented.
type StopInstancesRequest struct {
	DryRun      aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	Force       aws.BooleanValue `ec2:"Force" xml:"force"`
	InstanceIDs []string         `ec2:"InstanceId" xml:"InstanceId>InstanceId"`
}

// StopInstancesResult is undocumented.
type StopInstancesResult struct {
	StoppingInstances []InstanceStateChange `ec2:"StoppingInstances" xml:"instancesSet>item"`
}

// Storage is undocumented.
type Storage struct {
	S3 *S3Storage `ec2:"S3" xml:"S3"`
}

// Subnet is undocumented.
type Subnet struct {
	AvailabilityZone        aws.StringValue  `ec2:"AvailabilityZone" xml:"availabilityZone"`
	AvailableIPAddressCount aws.IntegerValue `ec2:"AvailableIpAddressCount" xml:"availableIpAddressCount"`
	CIDRBlock               aws.StringValue  `ec2:"CidrBlock" xml:"cidrBlock"`
	DefaultForAz            aws.BooleanValue `ec2:"DefaultForAz" xml:"defaultForAz"`
	MapPublicIPOnLaunch     aws.BooleanValue `ec2:"MapPublicIpOnLaunch" xml:"mapPublicIpOnLaunch"`
	State                   aws.StringValue  `ec2:"State" xml:"state"`
	SubnetID                aws.StringValue  `ec2:"SubnetId" xml:"subnetId"`
	Tags                    []Tag            `ec2:"Tags" xml:"tagSet>item"`
	VPCID                   aws.StringValue  `ec2:"VpcId" xml:"vpcId"`
}

// Possible values for EC2.
const (
	SubnetStateAvailable = "available"
	SubnetStatePending   = "pending"
)

// Possible values for EC2.
const (
	SummaryStatusImpaired         = "impaired"
	SummaryStatusInsufficientData = "insufficient-data"
	SummaryStatusNotApplicable    = "not-applicable"
	SummaryStatusOK               = "ok"
)

// Tag is undocumented.
type Tag struct {
	Key   aws.StringValue `ec2:"Key" xml:"key"`
	Value aws.StringValue `ec2:"Value" xml:"value"`
}

// TagDescription is undocumented.
type TagDescription struct {
	Key          aws.StringValue `ec2:"Key" xml:"key"`
	ResourceID   aws.StringValue `ec2:"ResourceId" xml:"resourceId"`
	ResourceType aws.StringValue `ec2:"ResourceType" xml:"resourceType"`
	Value        aws.StringValue `ec2:"Value" xml:"value"`
}

// Possible values for EC2.
const (
	TelemetryStatusDown = "DOWN"
	TelemetryStatusUp   = "UP"
)

// Possible values for EC2.
const (
	TenancyDedicated = "dedicated"
	TenancyDefault   = "default"
)

// TerminateInstancesRequest is undocumented.
type TerminateInstancesRequest struct {
	DryRun      aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	InstanceIDs []string         `ec2:"InstanceId" xml:"InstanceId>InstanceId"`
}

// TerminateInstancesResult is undocumented.
type TerminateInstancesResult struct {
	TerminatingInstances []InstanceStateChange `ec2:"TerminatingInstances" xml:"instancesSet>item"`
}

// UnassignPrivateIPAddressesRequest is undocumented.
type UnassignPrivateIPAddressesRequest struct {
	NetworkInterfaceID aws.StringValue `ec2:"NetworkInterfaceId" xml:"networkInterfaceId"`
	PrivateIPAddresses []string        `ec2:"PrivateIpAddresses" xml:"privateIpAddress>PrivateIpAddress"`
}

// UnmonitorInstancesRequest is undocumented.
type UnmonitorInstancesRequest struct {
	DryRun      aws.BooleanValue `ec2:"DryRun" xml:"dryRun"`
	InstanceIDs []string         `ec2:"InstanceId" xml:"InstanceId>InstanceId"`
}

// UnmonitorInstancesResult is undocumented.
type UnmonitorInstancesResult struct {
	InstanceMonitorings []InstanceMonitoring `ec2:"InstanceMonitorings" xml:"instancesSet>item"`
}

// UserData is undocumented.
type UserData struct {
	Data aws.StringValue `ec2:"Data" xml:"data"`
}

// UserIDGroupPair is undocumented.
type UserIDGroupPair struct {
	GroupID   aws.StringValue `ec2:"GroupId" xml:"groupId"`
	GroupName aws.StringValue `ec2:"GroupName" xml:"groupName"`
	UserID    aws.StringValue `ec2:"UserId" xml:"userId"`
}

// VGWTelemetry is undocumented.
type VGWTelemetry struct {
	AcceptedRouteCount aws.IntegerValue `ec2:"AcceptedRouteCount" xml:"acceptedRouteCount"`
	LastStatusChange   time.Time        `ec2:"LastStatusChange" xml:"lastStatusChange"`
	OutsideIPAddress   aws.StringValue  `ec2:"OutsideIpAddress" xml:"outsideIpAddress"`
	Status             aws.StringValue  `ec2:"Status" xml:"status"`
	StatusMessage      aws.StringValue  `ec2:"StatusMessage" xml:"statusMessage"`
}

// Possible values for EC2.
const (
	VirtualizationTypeHVM         = "hvm"
	VirtualizationTypeParavirtual = "paravirtual"
)

// Volume is undocumented.
type Volume struct {
	Attachments      []VolumeAttachment `ec2:"Attachments" xml:"attachmentSet>item"`
	AvailabilityZone aws.StringValue    `ec2:"AvailabilityZone" xml:"availabilityZone"`
	CreateTime       time.Time          `ec2:"CreateTime" xml:"createTime"`
	Encrypted        aws.BooleanValue   `ec2:"Encrypted" xml:"encrypted"`
	IOPS             aws.IntegerValue   `ec2:"Iops" xml:"iops"`
	KMSKeyID         aws.StringValue    `ec2:"KmsKeyId" xml:"kmsKeyId"`
	Size             aws.IntegerValue   `ec2:"Size" xml:"size"`
	SnapshotID       aws.StringValue    `ec2:"SnapshotId" xml:"snapshotId"`
	State            aws.StringValue    `ec2:"State" xml:"status"`
	Tags             []Tag              `ec2:"Tags" xml:"tagSet>item"`
	VolumeID         aws.StringValue    `ec2:"VolumeId" xml:"volumeId"`
	VolumeType       aws.StringValue    `ec2:"VolumeType" xml:"volumeType"`
}

// VolumeAttachment is undocumented.
type VolumeAttachment struct {
	AttachTime          time.Time        `ec2:"AttachTime" xml:"attachTime"`
	DeleteOnTermination aws.BooleanValue `ec2:"DeleteOnTermination" xml:"deleteOnTermination"`
	Device              aws.StringValue  `ec2:"Device" xml:"device"`
	InstanceID          aws.StringValue  `ec2:"InstanceId" xml:"instanceId"`
	State               aws.StringValue  `ec2:"State" xml:"status"`
	VolumeID            aws.StringValue  `ec2:"VolumeId" xml:"volumeId"`
}

// Possible values for EC2.
const (
	VolumeAttachmentStateAttached  = "attached"
	VolumeAttachmentStateAttaching = "attaching"
	VolumeAttachmentStateDetached  = "detached"
	VolumeAttachmentStateDetaching = "detaching"
)

// Possible values for EC2.
const (
	VolumeAttributeNameAutoEnableIo = "autoEnableIO"
	VolumeAttributeNameProductCodes = "productCodes"
)

// VolumeDetail is undocumented.
type VolumeDetail struct {
	Size aws.LongValue `ec2:"Size" xml:"size"`
}

// Possible values for EC2.
const (
	VolumeStateAvailable = "available"
	VolumeStateCreating  = "creating"
	VolumeStateDeleted   = "deleted"
	VolumeStateDeleting  = "deleting"
	VolumeStateError     = "error"
	VolumeStateInUse     = "in-use"
)

// VolumeStatusAction is undocumented.
type VolumeStatusAction struct {
	Code        aws.StringValue `ec2:"Code" xml:"code"`
	Description aws.StringValue `ec2:"Description" xml:"description"`
	EventID     aws.StringValue `ec2:"EventId" xml:"eventId"`
	EventType   aws.StringValue `ec2:"EventType" xml:"eventType"`
}

// VolumeStatusDetails is undocumented.
type VolumeStatusDetails struct {
	Name   aws.StringValue `ec2:"Name" xml:"name"`
	Status aws.StringValue `ec2:"Status" xml:"status"`
}

// VolumeStatusEvent is undocumented.
type VolumeStatusEvent struct {
	Description aws.StringValue `ec2:"Description" xml:"description"`
	EventID     aws.StringValue `ec2:"EventId" xml:"eventId"`
	EventType   aws.StringValue `ec2:"EventType" xml:"eventType"`
	NotAfter    time.Time       `ec2:"NotAfter" xml:"notAfter"`
	NotBefore   time.Time       `ec2:"NotBefore" xml:"notBefore"`
}

// VolumeStatusInfo is undocumented.
type VolumeStatusInfo struct {
	Details []VolumeStatusDetails `ec2:"Details" xml:"details>item"`
	Status  aws.StringValue       `ec2:"Status" xml:"status"`
}

// Possible values for EC2.
const (
	VolumeStatusInfoStatusImpaired         = "impaired"
	VolumeStatusInfoStatusInsufficientData = "insufficient-data"
	VolumeStatusInfoStatusOK               = "ok"
)

// VolumeStatusItem is undocumented.
type VolumeStatusItem struct {
	Actions          []VolumeStatusAction `ec2:"Actions" xml:"actionsSet>item"`
	AvailabilityZone aws.StringValue      `ec2:"AvailabilityZone" xml:"availabilityZone"`
	Events           []VolumeStatusEvent  `ec2:"Events" xml:"eventsSet>item"`
	VolumeID         aws.StringValue      `ec2:"VolumeId" xml:"volumeId"`
	VolumeStatus     *VolumeStatusInfo    `ec2:"VolumeStatus" xml:"volumeStatus"`
}

// Possible values for EC2.
const (
	VolumeStatusNameIoEnabled     = "io-enabled"
	VolumeStatusNameIoPerformance = "io-performance"
)

// Possible values for EC2.
const (
	VolumeTypeGp2      = "gp2"
	VolumeTypeIo1      = "io1"
	VolumeTypeStandard = "standard"
)

// VPC is undocumented.
type VPC struct {
	CIDRBlock       aws.StringValue  `ec2:"CidrBlock" xml:"cidrBlock"`
	DHCPOptionsID   aws.StringValue  `ec2:"DhcpOptionsId" xml:"dhcpOptionsId"`
	InstanceTenancy aws.StringValue  `ec2:"InstanceTenancy" xml:"instanceTenancy"`
	IsDefault       aws.BooleanValue `ec2:"IsDefault" xml:"isDefault"`
	State           aws.StringValue  `ec2:"State" xml:"state"`
	Tags            []Tag            `ec2:"Tags" xml:"tagSet>item"`
	VPCID           aws.StringValue  `ec2:"VpcId" xml:"vpcId"`
}

// VPCAttachment is undocumented.
type VPCAttachment struct {
	State aws.StringValue `ec2:"State" xml:"state"`
	VPCID aws.StringValue `ec2:"VpcId" xml:"vpcId"`
}

// Possible values for EC2.
const (
	VPCAttributeNameEnableDNSHostnames = "enableDnsHostnames"
	VPCAttributeNameEnableDNSSupport   = "enableDnsSupport"
)

// VPCClassicLink is undocumented.
type VPCClassicLink struct {
	ClassicLinkEnabled aws.BooleanValue `ec2:"ClassicLinkEnabled" xml:"classicLinkEnabled"`
	Tags               []Tag            `ec2:"Tags" xml:"tagSet>item"`
	VPCID              aws.StringValue  `ec2:"VpcId" xml:"vpcId"`
}

// VPCPeeringConnection is undocumented.
type VPCPeeringConnection struct {
	AccepterVPCInfo        *VPCPeeringConnectionVPCInfo     `ec2:"AccepterVpcInfo" xml:"accepterVpcInfo"`
	ExpirationTime         time.Time                        `ec2:"ExpirationTime" xml:"expirationTime"`
	RequesterVPCInfo       *VPCPeeringConnectionVPCInfo     `ec2:"RequesterVpcInfo" xml:"requesterVpcInfo"`
	Status                 *VPCPeeringConnectionStateReason `ec2:"Status" xml:"status"`
	Tags                   []Tag                            `ec2:"Tags" xml:"tagSet>item"`
	VPCPeeringConnectionID aws.StringValue                  `ec2:"VpcPeeringConnectionId" xml:"vpcPeeringConnectionId"`
}

// VPCPeeringConnectionStateReason is undocumented.
type VPCPeeringConnectionStateReason struct {
	Code    aws.StringValue `ec2:"Code" xml:"code"`
	Message aws.StringValue `ec2:"Message" xml:"message"`
}

// VPCPeeringConnectionVPCInfo is undocumented.
type VPCPeeringConnectionVPCInfo struct {
	CIDRBlock aws.StringValue `ec2:"CidrBlock" xml:"cidrBlock"`
	OwnerID   aws.StringValue `ec2:"OwnerId" xml:"ownerId"`
	VPCID     aws.StringValue `ec2:"VpcId" xml:"vpcId"`
}

// Possible values for EC2.
const (
	VPCStateAvailable = "available"
	VPCStatePending   = "pending"
)

// VPNConnection is undocumented.
type VPNConnection struct {
	CustomerGatewayConfiguration aws.StringValue       `ec2:"CustomerGatewayConfiguration" xml:"customerGatewayConfiguration"`
	CustomerGatewayID            aws.StringValue       `ec2:"CustomerGatewayId" xml:"customerGatewayId"`
	Options                      *VPNConnectionOptions `ec2:"Options" xml:"options"`
	Routes                       []VPNStaticRoute      `ec2:"Routes" xml:"routes>item"`
	State                        aws.StringValue       `ec2:"State" xml:"state"`
	Tags                         []Tag                 `ec2:"Tags" xml:"tagSet>item"`
	Type                         aws.StringValue       `ec2:"Type" xml:"type"`
	VGWTelemetry                 []VGWTelemetry        `ec2:"VgwTelemetry" xml:"vgwTelemetry>item"`
	VPNConnectionID              aws.StringValue       `ec2:"VpnConnectionId" xml:"vpnConnectionId"`
	VPNGatewayID                 aws.StringValue       `ec2:"VpnGatewayId" xml:"vpnGatewayId"`
}

// VPNConnectionOptions is undocumented.
type VPNConnectionOptions struct {
	StaticRoutesOnly aws.BooleanValue `ec2:"StaticRoutesOnly" xml:"staticRoutesOnly"`
}

// VPNConnectionOptionsSpecification is undocumented.
type VPNConnectionOptionsSpecification struct {
	StaticRoutesOnly aws.BooleanValue `ec2:"StaticRoutesOnly" xml:"staticRoutesOnly"`
}

// VPNGateway is undocumented.
type VPNGateway struct {
	AvailabilityZone aws.StringValue `ec2:"AvailabilityZone" xml:"availabilityZone"`
	State            aws.StringValue `ec2:"State" xml:"state"`
	Tags             []Tag           `ec2:"Tags" xml:"tagSet>item"`
	Type             aws.StringValue `ec2:"Type" xml:"type"`
	VPCAttachments   []VPCAttachment `ec2:"VpcAttachments" xml:"attachments>item"`
	VPNGatewayID     aws.StringValue `ec2:"VpnGatewayId" xml:"vpnGatewayId"`
}

// Possible values for EC2.
const (
	VPNStateAvailable = "available"
	VPNStateDeleted   = "deleted"
	VPNStateDeleting  = "deleting"
	VPNStatePending   = "pending"
)

// VPNStaticRoute is undocumented.
type VPNStaticRoute struct {
	DestinationCIDRBlock aws.StringValue `ec2:"DestinationCidrBlock" xml:"destinationCidrBlock"`
	Source               aws.StringValue `ec2:"Source" xml:"source"`
	State                aws.StringValue `ec2:"State" xml:"state"`
}

// Possible values for EC2.
const (
	VPNStaticRouteSourceStatic = "Static"
)

// avoid errors if the packages aren't referenced
var _ time.Time
