// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package elasticcache provides a client for Amazon ElastiCache.
package elasticcache

import (
	"net/http"
	"time"

	"github.com/awslabs/aws-sdk-go/aws"
	"github.com/awslabs/aws-sdk-go/gen/endpoints"
)

import (
	"encoding/xml"
	"io"
)

// ElasticCache is a client for Amazon ElastiCache.
type ElasticCache struct {
	client *aws.QueryClient
}

// New returns a new ElasticCache client.
func New(creds aws.CredentialsProvider, region string, client *http.Client) *ElasticCache {
	if client == nil {
		client = http.DefaultClient
	}

	endpoint, service, region := endpoints.Lookup("elasticache", region)

	return &ElasticCache{
		client: &aws.QueryClient{
			Context: aws.Context{
				Credentials: creds,
				Service:     service,
				Region:      region,
			},
			Client:     client,
			Endpoint:   endpoint,
			APIVersion: "2014-09-30",
		},
	}
}

// AuthorizeCacheSecurityGroupIngress the
// AuthorizeCacheSecurityGroupIngress operation allows network ingress to a
// cache security group. Applications using ElastiCache must be running on
// Amazon EC2, and Amazon EC2 security groups are used as the authorization
// mechanism.
func (c *ElasticCache) AuthorizeCacheSecurityGroupIngress(req *AuthorizeCacheSecurityGroupIngressMessage) (resp *AuthorizeCacheSecurityGroupIngressResult, err error) {
	resp = &AuthorizeCacheSecurityGroupIngressResult{}
	err = c.client.Do("AuthorizeCacheSecurityGroupIngress", "POST", "/", req, resp)
	return
}

// CopySnapshot the CopySnapshot operation makes a copy of an existing
// snapshot.
func (c *ElasticCache) CopySnapshot(req *CopySnapshotMessage) (resp *CopySnapshotResult, err error) {
	resp = &CopySnapshotResult{}
	err = c.client.Do("CopySnapshot", "POST", "/", req, resp)
	return
}

// CreateCacheCluster the CreateCacheCluster operation creates a cache
// cluster. All nodes in the cache cluster run the same protocol-compliant
// cache engine software, either Memcached or Redis.
func (c *ElasticCache) CreateCacheCluster(req *CreateCacheClusterMessage) (resp *CreateCacheClusterResult, err error) {
	resp = &CreateCacheClusterResult{}
	err = c.client.Do("CreateCacheCluster", "POST", "/", req, resp)
	return
}

// CreateCacheParameterGroup the CreateCacheParameterGroup operation
// creates a new cache parameter group. A cache parameter group is a
// collection of parameters that you apply to all of the nodes in a cache
// cluster.
func (c *ElasticCache) CreateCacheParameterGroup(req *CreateCacheParameterGroupMessage) (resp *CreateCacheParameterGroupResult, err error) {
	resp = &CreateCacheParameterGroupResult{}
	err = c.client.Do("CreateCacheParameterGroup", "POST", "/", req, resp)
	return
}

// CreateCacheSecurityGroup the CreateCacheSecurityGroup operation creates
// a new cache security group. Use a cache security group to control access
// to one or more cache clusters. Cache security groups are only used when
// you are creating a cache cluster outside of an Amazon Virtual Private
// Cloud If you are creating a cache cluster inside of a use a cache subnet
// group instead. For more information, see CreateCacheSubnetGroup
func (c *ElasticCache) CreateCacheSecurityGroup(req *CreateCacheSecurityGroupMessage) (resp *CreateCacheSecurityGroupResult, err error) {
	resp = &CreateCacheSecurityGroupResult{}
	err = c.client.Do("CreateCacheSecurityGroup", "POST", "/", req, resp)
	return
}

// CreateCacheSubnetGroup the CreateCacheSubnetGroup operation creates a
// new cache subnet group. Use this parameter only when you are creating a
// cluster in an Amazon Virtual Private Cloud
func (c *ElasticCache) CreateCacheSubnetGroup(req *CreateCacheSubnetGroupMessage) (resp *CreateCacheSubnetGroupResult, err error) {
	resp = &CreateCacheSubnetGroupResult{}
	err = c.client.Do("CreateCacheSubnetGroup", "POST", "/", req, resp)
	return
}

// CreateReplicationGroup the CreateReplicationGroup operation creates a
// replication group. A replication group is a collection of cache
// clusters, where one of the cache clusters is a read/write primary and
// the others are read-only replicas. Writes to the primary are
// automatically propagated to the replicas. When you create a replication
// group, you must specify an existing cache cluster that is in the primary
// role. When the replication group has been successfully created, you can
// add one or more read replica replicas to it, up to a total of five read
// replicas. Note: This action is valid only for Redis.
func (c *ElasticCache) CreateReplicationGroup(req *CreateReplicationGroupMessage) (resp *CreateReplicationGroupResult, err error) {
	resp = &CreateReplicationGroupResult{}
	err = c.client.Do("CreateReplicationGroup", "POST", "/", req, resp)
	return
}

// CreateSnapshot the CreateSnapshot operation creates a copy of an entire
// cache cluster at a specific moment in time.
func (c *ElasticCache) CreateSnapshot(req *CreateSnapshotMessage) (resp *CreateSnapshotResult, err error) {
	resp = &CreateSnapshotResult{}
	err = c.client.Do("CreateSnapshot", "POST", "/", req, resp)
	return
}

// DeleteCacheCluster the DeleteCacheCluster operation deletes a previously
// provisioned cache cluster. DeleteCacheCluster deletes all associated
// cache nodes, node endpoints and the cache cluster itself. When you
// receive a successful response from this operation, Amazon ElastiCache
// immediately begins deleting the cache cluster; you cannot cancel or
// revert this operation. This API cannot be used to delete a cache cluster
// that is the last read replica of a replication group that has automatic
// failover mode enabled.
func (c *ElasticCache) DeleteCacheCluster(req *DeleteCacheClusterMessage) (resp *DeleteCacheClusterResult, err error) {
	resp = &DeleteCacheClusterResult{}
	err = c.client.Do("DeleteCacheCluster", "POST", "/", req, resp)
	return
}

// DeleteCacheParameterGroup the DeleteCacheParameterGroup operation
// deletes the specified cache parameter group. You cannot delete a cache
// parameter group if it is associated with any cache clusters.
func (c *ElasticCache) DeleteCacheParameterGroup(req *DeleteCacheParameterGroupMessage) (err error) {
	// NRE
	err = c.client.Do("DeleteCacheParameterGroup", "POST", "/", req, nil)
	return
}

// DeleteCacheSecurityGroup the DeleteCacheSecurityGroup operation deletes
// a cache security group.
func (c *ElasticCache) DeleteCacheSecurityGroup(req *DeleteCacheSecurityGroupMessage) (err error) {
	// NRE
	err = c.client.Do("DeleteCacheSecurityGroup", "POST", "/", req, nil)
	return
}

// DeleteCacheSubnetGroup the DeleteCacheSubnetGroup operation deletes a
// cache subnet group.
func (c *ElasticCache) DeleteCacheSubnetGroup(req *DeleteCacheSubnetGroupMessage) (err error) {
	// NRE
	err = c.client.Do("DeleteCacheSubnetGroup", "POST", "/", req, nil)
	return
}

// DeleteReplicationGroup the DeleteReplicationGroup operation deletes an
// existing cluster. By default, this operation deletes the entire cluster,
// including the primary node group and all of the read replicas. You can
// optionally delete only the read replicas, while retaining the primary
// node group. When you receive a successful response from this operation,
// Amazon ElastiCache immediately begins deleting the selected resources;
// you cannot cancel or revert this operation.
func (c *ElasticCache) DeleteReplicationGroup(req *DeleteReplicationGroupMessage) (resp *DeleteReplicationGroupResult, err error) {
	resp = &DeleteReplicationGroupResult{}
	err = c.client.Do("DeleteReplicationGroup", "POST", "/", req, resp)
	return
}

// DeleteSnapshot the DeleteSnapshot operation deletes an existing
// snapshot. When you receive a successful response from this operation,
// ElastiCache immediately begins deleting the snapshot; you cannot cancel
// or revert this operation.
func (c *ElasticCache) DeleteSnapshot(req *DeleteSnapshotMessage) (resp *DeleteSnapshotResult, err error) {
	resp = &DeleteSnapshotResult{}
	err = c.client.Do("DeleteSnapshot", "POST", "/", req, resp)
	return
}

// DescribeCacheClusters the DescribeCacheClusters operation returns
// information about all provisioned cache clusters if no cache cluster
// identifier is specified, or about a specific cache cluster if a cache
// cluster identifier is supplied. By default, abbreviated information
// about the cache clusters(s) will be returned. You can use the optional
// ShowDetails flag to retrieve detailed information about the cache nodes
// associated with the cache clusters. These details include the DNS
// address and port for the cache node endpoint. If the cluster is in the
// state, only cluster level information will be displayed until all of the
// nodes are successfully provisioned. If the cluster is in the state, only
// cluster level information will be displayed. If cache nodes are
// currently being added to the cache cluster, node endpoint information
// and creation time for the additional nodes will not be displayed until
// they are completely provisioned. When the cache cluster state is
// available , the cluster is ready for use. If cache nodes are currently
// being removed from the cache cluster, no endpoint information for the
// removed nodes is displayed.
func (c *ElasticCache) DescribeCacheClusters(req *DescribeCacheClustersMessage) (resp *DescribeCacheClustersResult, err error) {
	resp = &DescribeCacheClustersResult{}
	err = c.client.Do("DescribeCacheClusters", "POST", "/", req, resp)
	return
}

// DescribeCacheEngineVersions the DescribeCacheEngineVersions operation
// returns a list of the available cache engines and their versions.
func (c *ElasticCache) DescribeCacheEngineVersions(req *DescribeCacheEngineVersionsMessage) (resp *DescribeCacheEngineVersionsResult, err error) {
	resp = &DescribeCacheEngineVersionsResult{}
	err = c.client.Do("DescribeCacheEngineVersions", "POST", "/", req, resp)
	return
}

// DescribeCacheParameterGroups the DescribeCacheParameterGroups operation
// returns a list of cache parameter group descriptions. If a cache
// parameter group name is specified, the list will contain only the
// descriptions for that group.
func (c *ElasticCache) DescribeCacheParameterGroups(req *DescribeCacheParameterGroupsMessage) (resp *DescribeCacheParameterGroupsResult, err error) {
	resp = &DescribeCacheParameterGroupsResult{}
	err = c.client.Do("DescribeCacheParameterGroups", "POST", "/", req, resp)
	return
}

// DescribeCacheParameters the DescribeCacheParameters operation returns
// the detailed parameter list for a particular cache parameter group.
func (c *ElasticCache) DescribeCacheParameters(req *DescribeCacheParametersMessage) (resp *DescribeCacheParametersResult, err error) {
	resp = &DescribeCacheParametersResult{}
	err = c.client.Do("DescribeCacheParameters", "POST", "/", req, resp)
	return
}

// DescribeCacheSecurityGroups the DescribeCacheSecurityGroups operation
// returns a list of cache security group descriptions. If a cache security
// group name is specified, the list will contain only the description of
// that group.
func (c *ElasticCache) DescribeCacheSecurityGroups(req *DescribeCacheSecurityGroupsMessage) (resp *DescribeCacheSecurityGroupsResult, err error) {
	resp = &DescribeCacheSecurityGroupsResult{}
	err = c.client.Do("DescribeCacheSecurityGroups", "POST", "/", req, resp)
	return
}

// DescribeCacheSubnetGroups the DescribeCacheSubnetGroups operation
// returns a list of cache subnet group descriptions. If a subnet group
// name is specified, the list will contain only the description of that
// group.
func (c *ElasticCache) DescribeCacheSubnetGroups(req *DescribeCacheSubnetGroupsMessage) (resp *DescribeCacheSubnetGroupsResult, err error) {
	resp = &DescribeCacheSubnetGroupsResult{}
	err = c.client.Do("DescribeCacheSubnetGroups", "POST", "/", req, resp)
	return
}

// DescribeEngineDefaultParameters the DescribeEngineDefaultParameters
// operation returns the default engine and system parameter information
// for the specified cache engine.
func (c *ElasticCache) DescribeEngineDefaultParameters(req *DescribeEngineDefaultParametersMessage) (resp *DescribeEngineDefaultParametersResult, err error) {
	resp = &DescribeEngineDefaultParametersResult{}
	err = c.client.Do("DescribeEngineDefaultParameters", "POST", "/", req, resp)
	return
}

// DescribeEvents the DescribeEvents operation returns events related to
// cache clusters, cache security groups, and cache parameter groups. You
// can obtain events specific to a particular cache cluster, cache security
// group, or cache parameter group by providing the name as a parameter. By
// default, only the events occurring within the last hour are returned;
// however, you can retrieve up to 14 days' worth of events if necessary.
func (c *ElasticCache) DescribeEvents(req *DescribeEventsMessage) (resp *DescribeEventsResult, err error) {
	resp = &DescribeEventsResult{}
	err = c.client.Do("DescribeEvents", "POST", "/", req, resp)
	return
}

// DescribeReplicationGroups the DescribeReplicationGroups operation
// returns information about a particular replication group. If no
// identifier is specified, DescribeReplicationGroups returns information
// about all replication groups.
func (c *ElasticCache) DescribeReplicationGroups(req *DescribeReplicationGroupsMessage) (resp *DescribeReplicationGroupsResult, err error) {
	resp = &DescribeReplicationGroupsResult{}
	err = c.client.Do("DescribeReplicationGroups", "POST", "/", req, resp)
	return
}

// DescribeReservedCacheNodes the DescribeReservedCacheNodes operation
// returns information about reserved cache nodes for this account, or
// about a specified reserved cache node.
func (c *ElasticCache) DescribeReservedCacheNodes(req *DescribeReservedCacheNodesMessage) (resp *DescribeReservedCacheNodesResult, err error) {
	resp = &DescribeReservedCacheNodesResult{}
	err = c.client.Do("DescribeReservedCacheNodes", "POST", "/", req, resp)
	return
}

// DescribeReservedCacheNodesOfferings the
// DescribeReservedCacheNodesOfferings operation lists available reserved
// cache node offerings.
func (c *ElasticCache) DescribeReservedCacheNodesOfferings(req *DescribeReservedCacheNodesOfferingsMessage) (resp *DescribeReservedCacheNodesOfferingsResult, err error) {
	resp = &DescribeReservedCacheNodesOfferingsResult{}
	err = c.client.Do("DescribeReservedCacheNodesOfferings", "POST", "/", req, resp)
	return
}

// DescribeSnapshots the DescribeSnapshots operation returns information
// about cache cluster snapshots. By default, DescribeSnapshots lists all
// of your snapshots; it can optionally describe a single snapshot, or just
// the snapshots associated with a particular cache cluster.
func (c *ElasticCache) DescribeSnapshots(req *DescribeSnapshotsMessage) (resp *DescribeSnapshotsResult, err error) {
	resp = &DescribeSnapshotsResult{}
	err = c.client.Do("DescribeSnapshots", "POST", "/", req, resp)
	return
}

// ModifyCacheCluster the ModifyCacheCluster operation modifies the
// settings for a cache cluster. You can use this operation to change one
// or more cluster configuration parameters by specifying the parameters
// and the new values.
func (c *ElasticCache) ModifyCacheCluster(req *ModifyCacheClusterMessage) (resp *ModifyCacheClusterResult, err error) {
	resp = &ModifyCacheClusterResult{}
	err = c.client.Do("ModifyCacheCluster", "POST", "/", req, resp)
	return
}

// ModifyCacheParameterGroup the ModifyCacheParameterGroup operation
// modifies the parameters of a cache parameter group. You can modify up to
// 20 parameters in a single request by submitting a list parameter name
// and value pairs.
func (c *ElasticCache) ModifyCacheParameterGroup(req *ModifyCacheParameterGroupMessage) (resp *ModifyCacheParameterGroupResult, err error) {
	resp = &ModifyCacheParameterGroupResult{}
	err = c.client.Do("ModifyCacheParameterGroup", "POST", "/", req, resp)
	return
}

// ModifyCacheSubnetGroup the ModifyCacheSubnetGroup operation modifies an
// existing cache subnet group.
func (c *ElasticCache) ModifyCacheSubnetGroup(req *ModifyCacheSubnetGroupMessage) (resp *ModifyCacheSubnetGroupResult, err error) {
	resp = &ModifyCacheSubnetGroupResult{}
	err = c.client.Do("ModifyCacheSubnetGroup", "POST", "/", req, resp)
	return
}

// ModifyReplicationGroup the ModifyReplicationGroup operation modifies the
// settings for a replication group.
func (c *ElasticCache) ModifyReplicationGroup(req *ModifyReplicationGroupMessage) (resp *ModifyReplicationGroupResult, err error) {
	resp = &ModifyReplicationGroupResult{}
	err = c.client.Do("ModifyReplicationGroup", "POST", "/", req, resp)
	return
}

// PurchaseReservedCacheNodesOffering the
// PurchaseReservedCacheNodesOffering operation allows you to purchase a
// reserved cache node offering.
func (c *ElasticCache) PurchaseReservedCacheNodesOffering(req *PurchaseReservedCacheNodesOfferingMessage) (resp *PurchaseReservedCacheNodesOfferingResult, err error) {
	resp = &PurchaseReservedCacheNodesOfferingResult{}
	err = c.client.Do("PurchaseReservedCacheNodesOffering", "POST", "/", req, resp)
	return
}

// RebootCacheCluster the RebootCacheCluster operation reboots some, or
// all, of the cache nodes within a provisioned cache cluster. This API
// will apply any modified cache parameter groups to the cache cluster. The
// reboot action takes place as soon as possible, and results in a
// momentary outage to the cache cluster. During the reboot, the cache
// cluster status is set to The reboot causes the contents of the cache
// (for each cache node being rebooted) to be lost. When the reboot is
// complete, a cache cluster event is created.
func (c *ElasticCache) RebootCacheCluster(req *RebootCacheClusterMessage) (resp *RebootCacheClusterResult, err error) {
	resp = &RebootCacheClusterResult{}
	err = c.client.Do("RebootCacheCluster", "POST", "/", req, resp)
	return
}

// ResetCacheParameterGroup the ResetCacheParameterGroup operation modifies
// the parameters of a cache parameter group to the engine or system
// default value. You can reset specific parameters by submitting a list of
// parameter names. To reset the entire cache parameter group, specify the
// ResetAllParameters and CacheParameterGroupName parameters.
func (c *ElasticCache) ResetCacheParameterGroup(req *ResetCacheParameterGroupMessage) (resp *ResetCacheParameterGroupResult, err error) {
	resp = &ResetCacheParameterGroupResult{}
	err = c.client.Do("ResetCacheParameterGroup", "POST", "/", req, resp)
	return
}

// RevokeCacheSecurityGroupIngress the RevokeCacheSecurityGroupIngress
// operation revokes ingress from a cache security group. Use this
// operation to disallow access from an Amazon EC2 security group that had
// been previously authorized.
func (c *ElasticCache) RevokeCacheSecurityGroupIngress(req *RevokeCacheSecurityGroupIngressMessage) (resp *RevokeCacheSecurityGroupIngressResult, err error) {
	resp = &RevokeCacheSecurityGroupIngressResult{}
	err = c.client.Do("RevokeCacheSecurityGroupIngress", "POST", "/", req, resp)
	return
}

// Possible values for ElasticCache.
const (
	AZModeCrossAz  = "cross-az"
	AZModeSingleAz = "single-az"
)

// AuthorizeCacheSecurityGroupIngressMessage is undocumented.
type AuthorizeCacheSecurityGroupIngressMessage struct {
	CacheSecurityGroupName  aws.StringValue `query:"CacheSecurityGroupName" xml:"CacheSecurityGroupName"`
	EC2SecurityGroupName    aws.StringValue `query:"EC2SecurityGroupName" xml:"EC2SecurityGroupName"`
	EC2SecurityGroupOwnerID aws.StringValue `query:"EC2SecurityGroupOwnerId" xml:"EC2SecurityGroupOwnerId"`
}

// AuthorizeCacheSecurityGroupIngressResult is undocumented.
type AuthorizeCacheSecurityGroupIngressResult struct {
	CacheSecurityGroup *CacheSecurityGroup `query:"CacheSecurityGroup" xml:"AuthorizeCacheSecurityGroupIngressResult>CacheSecurityGroup"`
}

// Possible values for ElasticCache.
const (
	AutomaticFailoverStatusDisabled  = "disabled"
	AutomaticFailoverStatusDisabling = "disabling"
	AutomaticFailoverStatusEnabled   = "enabled"
	AutomaticFailoverStatusEnabling  = "enabling"
)

// AvailabilityZone is undocumented.
type AvailabilityZone struct {
	Name aws.StringValue `query:"Name" xml:"Name"`
}

// CacheCluster is undocumented.
type CacheCluster struct {
	AutoMinorVersionUpgrade    aws.BooleanValue               `query:"AutoMinorVersionUpgrade" xml:"AutoMinorVersionUpgrade"`
	CacheClusterCreateTime     time.Time                      `query:"CacheClusterCreateTime" xml:"CacheClusterCreateTime"`
	CacheClusterID             aws.StringValue                `query:"CacheClusterId" xml:"CacheClusterId"`
	CacheClusterStatus         aws.StringValue                `query:"CacheClusterStatus" xml:"CacheClusterStatus"`
	CacheNodeType              aws.StringValue                `query:"CacheNodeType" xml:"CacheNodeType"`
	CacheNodes                 []CacheNode                    `query:"CacheNodes.member" xml:"CacheNodes>CacheNode"`
	CacheParameterGroup        *CacheParameterGroupStatus     `query:"CacheParameterGroup" xml:"CacheParameterGroup"`
	CacheSecurityGroups        []CacheSecurityGroupMembership `query:"CacheSecurityGroups.member" xml:"CacheSecurityGroups>CacheSecurityGroup"`
	CacheSubnetGroupName       aws.StringValue                `query:"CacheSubnetGroupName" xml:"CacheSubnetGroupName"`
	ClientDownloadLandingPage  aws.StringValue                `query:"ClientDownloadLandingPage" xml:"ClientDownloadLandingPage"`
	ConfigurationEndpoint      *Endpoint                      `query:"ConfigurationEndpoint" xml:"ConfigurationEndpoint"`
	Engine                     aws.StringValue                `query:"Engine" xml:"Engine"`
	EngineVersion              aws.StringValue                `query:"EngineVersion" xml:"EngineVersion"`
	NotificationConfiguration  *NotificationConfiguration     `query:"NotificationConfiguration" xml:"NotificationConfiguration"`
	NumCacheNodes              aws.IntegerValue               `query:"NumCacheNodes" xml:"NumCacheNodes"`
	PendingModifiedValues      *PendingModifiedValues         `query:"PendingModifiedValues" xml:"PendingModifiedValues"`
	PreferredAvailabilityZone  aws.StringValue                `query:"PreferredAvailabilityZone" xml:"PreferredAvailabilityZone"`
	PreferredMaintenanceWindow aws.StringValue                `query:"PreferredMaintenanceWindow" xml:"PreferredMaintenanceWindow"`
	ReplicationGroupID         aws.StringValue                `query:"ReplicationGroupId" xml:"ReplicationGroupId"`
	SecurityGroups             []SecurityGroupMembership      `query:"SecurityGroups.member" xml:"SecurityGroups>member"`
	SnapshotRetentionLimit     aws.IntegerValue               `query:"SnapshotRetentionLimit" xml:"SnapshotRetentionLimit"`
	SnapshotWindow             aws.StringValue                `query:"SnapshotWindow" xml:"SnapshotWindow"`
}

// CacheClusterMessage is undocumented.
type CacheClusterMessage struct {
	CacheClusters []CacheCluster  `query:"CacheClusters.member" xml:"DescribeCacheClustersResult>CacheClusters>CacheCluster"`
	Marker        aws.StringValue `query:"Marker" xml:"DescribeCacheClustersResult>Marker"`
}

// CacheEngineVersion is undocumented.
type CacheEngineVersion struct {
	CacheEngineDescription        aws.StringValue `query:"CacheEngineDescription" xml:"CacheEngineDescription"`
	CacheEngineVersionDescription aws.StringValue `query:"CacheEngineVersionDescription" xml:"CacheEngineVersionDescription"`
	CacheParameterGroupFamily     aws.StringValue `query:"CacheParameterGroupFamily" xml:"CacheParameterGroupFamily"`
	Engine                        aws.StringValue `query:"Engine" xml:"Engine"`
	EngineVersion                 aws.StringValue `query:"EngineVersion" xml:"EngineVersion"`
}

// CacheEngineVersionMessage is undocumented.
type CacheEngineVersionMessage struct {
	CacheEngineVersions []CacheEngineVersion `query:"CacheEngineVersions.member" xml:"DescribeCacheEngineVersionsResult>CacheEngineVersions>CacheEngineVersion"`
	Marker              aws.StringValue      `query:"Marker" xml:"DescribeCacheEngineVersionsResult>Marker"`
}

// CacheNode is undocumented.
type CacheNode struct {
	CacheNodeCreateTime      time.Time       `query:"CacheNodeCreateTime" xml:"CacheNodeCreateTime"`
	CacheNodeID              aws.StringValue `query:"CacheNodeId" xml:"CacheNodeId"`
	CacheNodeStatus          aws.StringValue `query:"CacheNodeStatus" xml:"CacheNodeStatus"`
	CustomerAvailabilityZone aws.StringValue `query:"CustomerAvailabilityZone" xml:"CustomerAvailabilityZone"`
	Endpoint                 *Endpoint       `query:"Endpoint" xml:"Endpoint"`
	ParameterGroupStatus     aws.StringValue `query:"ParameterGroupStatus" xml:"ParameterGroupStatus"`
	SourceCacheNodeID        aws.StringValue `query:"SourceCacheNodeId" xml:"SourceCacheNodeId"`
}

// CacheNodeTypeSpecificParameter is undocumented.
type CacheNodeTypeSpecificParameter struct {
	AllowedValues               aws.StringValue              `query:"AllowedValues" xml:"AllowedValues"`
	CacheNodeTypeSpecificValues []CacheNodeTypeSpecificValue `query:"CacheNodeTypeSpecificValues.member" xml:"CacheNodeTypeSpecificValues>CacheNodeTypeSpecificValue"`
	DataType                    aws.StringValue              `query:"DataType" xml:"DataType"`
	Description                 aws.StringValue              `query:"Description" xml:"Description"`
	IsModifiable                aws.BooleanValue             `query:"IsModifiable" xml:"IsModifiable"`
	MinimumEngineVersion        aws.StringValue              `query:"MinimumEngineVersion" xml:"MinimumEngineVersion"`
	ParameterName               aws.StringValue              `query:"ParameterName" xml:"ParameterName"`
	Source                      aws.StringValue              `query:"Source" xml:"Source"`
}

// CacheNodeTypeSpecificValue is undocumented.
type CacheNodeTypeSpecificValue struct {
	CacheNodeType aws.StringValue `query:"CacheNodeType" xml:"CacheNodeType"`
	Value         aws.StringValue `query:"Value" xml:"Value"`
}

// CacheParameterGroup is undocumented.
type CacheParameterGroup struct {
	CacheParameterGroupFamily aws.StringValue `query:"CacheParameterGroupFamily" xml:"CacheParameterGroupFamily"`
	CacheParameterGroupName   aws.StringValue `query:"CacheParameterGroupName" xml:"CacheParameterGroupName"`
	Description               aws.StringValue `query:"Description" xml:"Description"`
}

// CacheParameterGroupDetails is undocumented.
type CacheParameterGroupDetails struct {
	CacheNodeTypeSpecificParameters []CacheNodeTypeSpecificParameter `query:"CacheNodeTypeSpecificParameters.member" xml:"DescribeCacheParametersResult>CacheNodeTypeSpecificParameters>CacheNodeTypeSpecificParameter"`
	Marker                          aws.StringValue                  `query:"Marker" xml:"DescribeCacheParametersResult>Marker"`
	Parameters                      []Parameter                      `query:"Parameters.member" xml:"DescribeCacheParametersResult>Parameters>Parameter"`
}

// CacheParameterGroupNameMessage is undocumented.
type CacheParameterGroupNameMessage struct {
	CacheParameterGroupName aws.StringValue `query:"CacheParameterGroupName" xml:"CacheParameterGroupName"`
}

// CacheParameterGroupStatus is undocumented.
type CacheParameterGroupStatus struct {
	CacheNodeIDsToReboot    []string        `query:"CacheNodeIdsToReboot.member" xml:"CacheNodeIdsToReboot>CacheNodeId"`
	CacheParameterGroupName aws.StringValue `query:"CacheParameterGroupName" xml:"CacheParameterGroupName"`
	ParameterApplyStatus    aws.StringValue `query:"ParameterApplyStatus" xml:"ParameterApplyStatus"`
}

// CacheParameterGroupsMessage is undocumented.
type CacheParameterGroupsMessage struct {
	CacheParameterGroups []CacheParameterGroup `query:"CacheParameterGroups.member" xml:"DescribeCacheParameterGroupsResult>CacheParameterGroups>CacheParameterGroup"`
	Marker               aws.StringValue       `query:"Marker" xml:"DescribeCacheParameterGroupsResult>Marker"`
}

// CacheSecurityGroup is undocumented.
type CacheSecurityGroup struct {
	CacheSecurityGroupName aws.StringValue    `query:"CacheSecurityGroupName" xml:"CacheSecurityGroupName"`
	Description            aws.StringValue    `query:"Description" xml:"Description"`
	EC2SecurityGroups      []EC2SecurityGroup `query:"EC2SecurityGroups.member" xml:"EC2SecurityGroups>EC2SecurityGroup"`
	OwnerID                aws.StringValue    `query:"OwnerId" xml:"OwnerId"`
}

// CacheSecurityGroupMembership is undocumented.
type CacheSecurityGroupMembership struct {
	CacheSecurityGroupName aws.StringValue `query:"CacheSecurityGroupName" xml:"CacheSecurityGroupName"`
	Status                 aws.StringValue `query:"Status" xml:"Status"`
}

// CacheSecurityGroupMessage is undocumented.
type CacheSecurityGroupMessage struct {
	CacheSecurityGroups []CacheSecurityGroup `query:"CacheSecurityGroups.member" xml:"DescribeCacheSecurityGroupsResult>CacheSecurityGroups>CacheSecurityGroup"`
	Marker              aws.StringValue      `query:"Marker" xml:"DescribeCacheSecurityGroupsResult>Marker"`
}

// CacheSubnetGroup is undocumented.
type CacheSubnetGroup struct {
	CacheSubnetGroupDescription aws.StringValue `query:"CacheSubnetGroupDescription" xml:"CacheSubnetGroupDescription"`
	CacheSubnetGroupName        aws.StringValue `query:"CacheSubnetGroupName" xml:"CacheSubnetGroupName"`
	Subnets                     []Subnet        `query:"Subnets.member" xml:"Subnets>Subnet"`
	VPCID                       aws.StringValue `query:"VpcId" xml:"VpcId"`
}

// CacheSubnetGroupMessage is undocumented.
type CacheSubnetGroupMessage struct {
	CacheSubnetGroups []CacheSubnetGroup `query:"CacheSubnetGroups.member" xml:"DescribeCacheSubnetGroupsResult>CacheSubnetGroups>CacheSubnetGroup"`
	Marker            aws.StringValue    `query:"Marker" xml:"DescribeCacheSubnetGroupsResult>Marker"`
}

// CopySnapshotMessage is undocumented.
type CopySnapshotMessage struct {
	SourceSnapshotName aws.StringValue `query:"SourceSnapshotName" xml:"SourceSnapshotName"`
	TargetSnapshotName aws.StringValue `query:"TargetSnapshotName" xml:"TargetSnapshotName"`
}

// CopySnapshotResult is undocumented.
type CopySnapshotResult struct {
	Snapshot *Snapshot `query:"Snapshot" xml:"CopySnapshotResult>Snapshot"`
}

// CreateCacheClusterMessage is undocumented.
type CreateCacheClusterMessage struct {
	AZMode                     aws.StringValue  `query:"AZMode" xml:"AZMode"`
	AutoMinorVersionUpgrade    aws.BooleanValue `query:"AutoMinorVersionUpgrade" xml:"AutoMinorVersionUpgrade"`
	CacheClusterID             aws.StringValue  `query:"CacheClusterId" xml:"CacheClusterId"`
	CacheNodeType              aws.StringValue  `query:"CacheNodeType" xml:"CacheNodeType"`
	CacheParameterGroupName    aws.StringValue  `query:"CacheParameterGroupName" xml:"CacheParameterGroupName"`
	CacheSecurityGroupNames    []string         `query:"CacheSecurityGroupNames.member" xml:"CacheSecurityGroupNames>CacheSecurityGroupName"`
	CacheSubnetGroupName       aws.StringValue  `query:"CacheSubnetGroupName" xml:"CacheSubnetGroupName"`
	Engine                     aws.StringValue  `query:"Engine" xml:"Engine"`
	EngineVersion              aws.StringValue  `query:"EngineVersion" xml:"EngineVersion"`
	NotificationTopicARN       aws.StringValue  `query:"NotificationTopicArn" xml:"NotificationTopicArn"`
	NumCacheNodes              aws.IntegerValue `query:"NumCacheNodes" xml:"NumCacheNodes"`
	Port                       aws.IntegerValue `query:"Port" xml:"Port"`
	PreferredAvailabilityZone  aws.StringValue  `query:"PreferredAvailabilityZone" xml:"PreferredAvailabilityZone"`
	PreferredAvailabilityZones []string         `query:"PreferredAvailabilityZones.member" xml:"PreferredAvailabilityZones>PreferredAvailabilityZone"`
	PreferredMaintenanceWindow aws.StringValue  `query:"PreferredMaintenanceWindow" xml:"PreferredMaintenanceWindow"`
	ReplicationGroupID         aws.StringValue  `query:"ReplicationGroupId" xml:"ReplicationGroupId"`
	SecurityGroupIDs           []string         `query:"SecurityGroupIds.member" xml:"SecurityGroupIds>SecurityGroupId"`
	SnapshotARNs               []string         `query:"SnapshotArns.member" xml:"SnapshotArns>SnapshotArn"`
	SnapshotName               aws.StringValue  `query:"SnapshotName" xml:"SnapshotName"`
	SnapshotRetentionLimit     aws.IntegerValue `query:"SnapshotRetentionLimit" xml:"SnapshotRetentionLimit"`
	SnapshotWindow             aws.StringValue  `query:"SnapshotWindow" xml:"SnapshotWindow"`
}

// CreateCacheClusterResult is undocumented.
type CreateCacheClusterResult struct {
	CacheCluster *CacheCluster `query:"CacheCluster" xml:"CreateCacheClusterResult>CacheCluster"`
}

// CreateCacheParameterGroupMessage is undocumented.
type CreateCacheParameterGroupMessage struct {
	CacheParameterGroupFamily aws.StringValue `query:"CacheParameterGroupFamily" xml:"CacheParameterGroupFamily"`
	CacheParameterGroupName   aws.StringValue `query:"CacheParameterGroupName" xml:"CacheParameterGroupName"`
	Description               aws.StringValue `query:"Description" xml:"Description"`
}

// CreateCacheParameterGroupResult is undocumented.
type CreateCacheParameterGroupResult struct {
	CacheParameterGroup *CacheParameterGroup `query:"CacheParameterGroup" xml:"CreateCacheParameterGroupResult>CacheParameterGroup"`
}

// CreateCacheSecurityGroupMessage is undocumented.
type CreateCacheSecurityGroupMessage struct {
	CacheSecurityGroupName aws.StringValue `query:"CacheSecurityGroupName" xml:"CacheSecurityGroupName"`
	Description            aws.StringValue `query:"Description" xml:"Description"`
}

// CreateCacheSecurityGroupResult is undocumented.
type CreateCacheSecurityGroupResult struct {
	CacheSecurityGroup *CacheSecurityGroup `query:"CacheSecurityGroup" xml:"CreateCacheSecurityGroupResult>CacheSecurityGroup"`
}

// CreateCacheSubnetGroupMessage is undocumented.
type CreateCacheSubnetGroupMessage struct {
	CacheSubnetGroupDescription aws.StringValue `query:"CacheSubnetGroupDescription" xml:"CacheSubnetGroupDescription"`
	CacheSubnetGroupName        aws.StringValue `query:"CacheSubnetGroupName" xml:"CacheSubnetGroupName"`
	SubnetIDs                   []string        `query:"SubnetIds.member" xml:"SubnetIds>SubnetIdentifier"`
}

// CreateCacheSubnetGroupResult is undocumented.
type CreateCacheSubnetGroupResult struct {
	CacheSubnetGroup *CacheSubnetGroup `query:"CacheSubnetGroup" xml:"CreateCacheSubnetGroupResult>CacheSubnetGroup"`
}

// CreateReplicationGroupMessage is undocumented.
type CreateReplicationGroupMessage struct {
	AutoMinorVersionUpgrade     aws.BooleanValue `query:"AutoMinorVersionUpgrade" xml:"AutoMinorVersionUpgrade"`
	AutomaticFailoverEnabled    aws.BooleanValue `query:"AutomaticFailoverEnabled" xml:"AutomaticFailoverEnabled"`
	CacheNodeType               aws.StringValue  `query:"CacheNodeType" xml:"CacheNodeType"`
	CacheParameterGroupName     aws.StringValue  `query:"CacheParameterGroupName" xml:"CacheParameterGroupName"`
	CacheSecurityGroupNames     []string         `query:"CacheSecurityGroupNames.member" xml:"CacheSecurityGroupNames>CacheSecurityGroupName"`
	CacheSubnetGroupName        aws.StringValue  `query:"CacheSubnetGroupName" xml:"CacheSubnetGroupName"`
	Engine                      aws.StringValue  `query:"Engine" xml:"Engine"`
	EngineVersion               aws.StringValue  `query:"EngineVersion" xml:"EngineVersion"`
	NotificationTopicARN        aws.StringValue  `query:"NotificationTopicArn" xml:"NotificationTopicArn"`
	NumCacheClusters            aws.IntegerValue `query:"NumCacheClusters" xml:"NumCacheClusters"`
	Port                        aws.IntegerValue `query:"Port" xml:"Port"`
	PreferredCacheClusterAZs    []string         `query:"PreferredCacheClusterAZs.member" xml:"PreferredCacheClusterAZs>AvailabilityZone"`
	PreferredMaintenanceWindow  aws.StringValue  `query:"PreferredMaintenanceWindow" xml:"PreferredMaintenanceWindow"`
	PrimaryClusterID            aws.StringValue  `query:"PrimaryClusterId" xml:"PrimaryClusterId"`
	ReplicationGroupDescription aws.StringValue  `query:"ReplicationGroupDescription" xml:"ReplicationGroupDescription"`
	ReplicationGroupID          aws.StringValue  `query:"ReplicationGroupId" xml:"ReplicationGroupId"`
	SecurityGroupIDs            []string         `query:"SecurityGroupIds.member" xml:"SecurityGroupIds>SecurityGroupId"`
	SnapshotARNs                []string         `query:"SnapshotArns.member" xml:"SnapshotArns>SnapshotArn"`
	SnapshotName                aws.StringValue  `query:"SnapshotName" xml:"SnapshotName"`
	SnapshotRetentionLimit      aws.IntegerValue `query:"SnapshotRetentionLimit" xml:"SnapshotRetentionLimit"`
	SnapshotWindow              aws.StringValue  `query:"SnapshotWindow" xml:"SnapshotWindow"`
}

// CreateReplicationGroupResult is undocumented.
type CreateReplicationGroupResult struct {
	ReplicationGroup *ReplicationGroup `query:"ReplicationGroup" xml:"CreateReplicationGroupResult>ReplicationGroup"`
}

// CreateSnapshotMessage is undocumented.
type CreateSnapshotMessage struct {
	CacheClusterID aws.StringValue `query:"CacheClusterId" xml:"CacheClusterId"`
	SnapshotName   aws.StringValue `query:"SnapshotName" xml:"SnapshotName"`
}

// CreateSnapshotResult is undocumented.
type CreateSnapshotResult struct {
	Snapshot *Snapshot `query:"Snapshot" xml:"CreateSnapshotResult>Snapshot"`
}

// DeleteCacheClusterMessage is undocumented.
type DeleteCacheClusterMessage struct {
	CacheClusterID          aws.StringValue `query:"CacheClusterId" xml:"CacheClusterId"`
	FinalSnapshotIdentifier aws.StringValue `query:"FinalSnapshotIdentifier" xml:"FinalSnapshotIdentifier"`
}

// DeleteCacheClusterResult is undocumented.
type DeleteCacheClusterResult struct {
	CacheCluster *CacheCluster `query:"CacheCluster" xml:"DeleteCacheClusterResult>CacheCluster"`
}

// DeleteCacheParameterGroupMessage is undocumented.
type DeleteCacheParameterGroupMessage struct {
	CacheParameterGroupName aws.StringValue `query:"CacheParameterGroupName" xml:"CacheParameterGroupName"`
}

// DeleteCacheSecurityGroupMessage is undocumented.
type DeleteCacheSecurityGroupMessage struct {
	CacheSecurityGroupName aws.StringValue `query:"CacheSecurityGroupName" xml:"CacheSecurityGroupName"`
}

// DeleteCacheSubnetGroupMessage is undocumented.
type DeleteCacheSubnetGroupMessage struct {
	CacheSubnetGroupName aws.StringValue `query:"CacheSubnetGroupName" xml:"CacheSubnetGroupName"`
}

// DeleteReplicationGroupMessage is undocumented.
type DeleteReplicationGroupMessage struct {
	FinalSnapshotIdentifier aws.StringValue  `query:"FinalSnapshotIdentifier" xml:"FinalSnapshotIdentifier"`
	ReplicationGroupID      aws.StringValue  `query:"ReplicationGroupId" xml:"ReplicationGroupId"`
	RetainPrimaryCluster    aws.BooleanValue `query:"RetainPrimaryCluster" xml:"RetainPrimaryCluster"`
}

// DeleteReplicationGroupResult is undocumented.
type DeleteReplicationGroupResult struct {
	ReplicationGroup *ReplicationGroup `query:"ReplicationGroup" xml:"DeleteReplicationGroupResult>ReplicationGroup"`
}

// DeleteSnapshotMessage is undocumented.
type DeleteSnapshotMessage struct {
	SnapshotName aws.StringValue `query:"SnapshotName" xml:"SnapshotName"`
}

// DeleteSnapshotResult is undocumented.
type DeleteSnapshotResult struct {
	Snapshot *Snapshot `query:"Snapshot" xml:"DeleteSnapshotResult>Snapshot"`
}

// DescribeCacheClustersMessage is undocumented.
type DescribeCacheClustersMessage struct {
	CacheClusterID    aws.StringValue  `query:"CacheClusterId" xml:"CacheClusterId"`
	Marker            aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords        aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
	ShowCacheNodeInfo aws.BooleanValue `query:"ShowCacheNodeInfo" xml:"ShowCacheNodeInfo"`
}

// DescribeCacheEngineVersionsMessage is undocumented.
type DescribeCacheEngineVersionsMessage struct {
	CacheParameterGroupFamily aws.StringValue  `query:"CacheParameterGroupFamily" xml:"CacheParameterGroupFamily"`
	DefaultOnly               aws.BooleanValue `query:"DefaultOnly" xml:"DefaultOnly"`
	Engine                    aws.StringValue  `query:"Engine" xml:"Engine"`
	EngineVersion             aws.StringValue  `query:"EngineVersion" xml:"EngineVersion"`
	Marker                    aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords                aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
}

// DescribeCacheParameterGroupsMessage is undocumented.
type DescribeCacheParameterGroupsMessage struct {
	CacheParameterGroupName aws.StringValue  `query:"CacheParameterGroupName" xml:"CacheParameterGroupName"`
	Marker                  aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords              aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
}

// DescribeCacheParametersMessage is undocumented.
type DescribeCacheParametersMessage struct {
	CacheParameterGroupName aws.StringValue  `query:"CacheParameterGroupName" xml:"CacheParameterGroupName"`
	Marker                  aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords              aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
	Source                  aws.StringValue  `query:"Source" xml:"Source"`
}

// DescribeCacheSecurityGroupsMessage is undocumented.
type DescribeCacheSecurityGroupsMessage struct {
	CacheSecurityGroupName aws.StringValue  `query:"CacheSecurityGroupName" xml:"CacheSecurityGroupName"`
	Marker                 aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords             aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
}

// DescribeCacheSubnetGroupsMessage is undocumented.
type DescribeCacheSubnetGroupsMessage struct {
	CacheSubnetGroupName aws.StringValue  `query:"CacheSubnetGroupName" xml:"CacheSubnetGroupName"`
	Marker               aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords           aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
}

// DescribeEngineDefaultParametersMessage is undocumented.
type DescribeEngineDefaultParametersMessage struct {
	CacheParameterGroupFamily aws.StringValue  `query:"CacheParameterGroupFamily" xml:"CacheParameterGroupFamily"`
	Marker                    aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords                aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
}

// DescribeEngineDefaultParametersResult is undocumented.
type DescribeEngineDefaultParametersResult struct {
	EngineDefaults *EngineDefaults `query:"EngineDefaults" xml:"DescribeEngineDefaultParametersResult>EngineDefaults"`
}

// DescribeEventsMessage is undocumented.
type DescribeEventsMessage struct {
	Duration         aws.IntegerValue `query:"Duration" xml:"Duration"`
	EndTime          time.Time        `query:"EndTime" xml:"EndTime"`
	Marker           aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords       aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
	SourceIdentifier aws.StringValue  `query:"SourceIdentifier" xml:"SourceIdentifier"`
	SourceType       aws.StringValue  `query:"SourceType" xml:"SourceType"`
	StartTime        time.Time        `query:"StartTime" xml:"StartTime"`
}

// DescribeReplicationGroupsMessage is undocumented.
type DescribeReplicationGroupsMessage struct {
	Marker             aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords         aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
	ReplicationGroupID aws.StringValue  `query:"ReplicationGroupId" xml:"ReplicationGroupId"`
}

// DescribeReservedCacheNodesMessage is undocumented.
type DescribeReservedCacheNodesMessage struct {
	CacheNodeType                aws.StringValue  `query:"CacheNodeType" xml:"CacheNodeType"`
	Duration                     aws.StringValue  `query:"Duration" xml:"Duration"`
	Marker                       aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords                   aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
	OfferingType                 aws.StringValue  `query:"OfferingType" xml:"OfferingType"`
	ProductDescription           aws.StringValue  `query:"ProductDescription" xml:"ProductDescription"`
	ReservedCacheNodeID          aws.StringValue  `query:"ReservedCacheNodeId" xml:"ReservedCacheNodeId"`
	ReservedCacheNodesOfferingID aws.StringValue  `query:"ReservedCacheNodesOfferingId" xml:"ReservedCacheNodesOfferingId"`
}

// DescribeReservedCacheNodesOfferingsMessage is undocumented.
type DescribeReservedCacheNodesOfferingsMessage struct {
	CacheNodeType                aws.StringValue  `query:"CacheNodeType" xml:"CacheNodeType"`
	Duration                     aws.StringValue  `query:"Duration" xml:"Duration"`
	Marker                       aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords                   aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
	OfferingType                 aws.StringValue  `query:"OfferingType" xml:"OfferingType"`
	ProductDescription           aws.StringValue  `query:"ProductDescription" xml:"ProductDescription"`
	ReservedCacheNodesOfferingID aws.StringValue  `query:"ReservedCacheNodesOfferingId" xml:"ReservedCacheNodesOfferingId"`
}

// DescribeSnapshotsListMessage is undocumented.
type DescribeSnapshotsListMessage struct {
	Marker    aws.StringValue `query:"Marker" xml:"DescribeSnapshotsResult>Marker"`
	Snapshots []Snapshot      `query:"Snapshots.member" xml:"DescribeSnapshotsResult>Snapshots>Snapshot"`
}

// DescribeSnapshotsMessage is undocumented.
type DescribeSnapshotsMessage struct {
	CacheClusterID aws.StringValue  `query:"CacheClusterId" xml:"CacheClusterId"`
	Marker         aws.StringValue  `query:"Marker" xml:"Marker"`
	MaxRecords     aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
	SnapshotName   aws.StringValue  `query:"SnapshotName" xml:"SnapshotName"`
	SnapshotSource aws.StringValue  `query:"SnapshotSource" xml:"SnapshotSource"`
}

// EC2SecurityGroup is undocumented.
type EC2SecurityGroup struct {
	EC2SecurityGroupName    aws.StringValue `query:"EC2SecurityGroupName" xml:"EC2SecurityGroupName"`
	EC2SecurityGroupOwnerID aws.StringValue `query:"EC2SecurityGroupOwnerId" xml:"EC2SecurityGroupOwnerId"`
	Status                  aws.StringValue `query:"Status" xml:"Status"`
}

// Endpoint is undocumented.
type Endpoint struct {
	Address aws.StringValue  `query:"Address" xml:"Address"`
	Port    aws.IntegerValue `query:"Port" xml:"Port"`
}

// EngineDefaults is undocumented.
type EngineDefaults struct {
	CacheNodeTypeSpecificParameters []CacheNodeTypeSpecificParameter `query:"CacheNodeTypeSpecificParameters.member" xml:"CacheNodeTypeSpecificParameters>CacheNodeTypeSpecificParameter"`
	CacheParameterGroupFamily       aws.StringValue                  `query:"CacheParameterGroupFamily" xml:"CacheParameterGroupFamily"`
	Marker                          aws.StringValue                  `query:"Marker" xml:"Marker"`
	Parameters                      []Parameter                      `query:"Parameters.member" xml:"Parameters>Parameter"`
}

// Event is undocumented.
type Event struct {
	Date             time.Time       `query:"Date" xml:"Date"`
	Message          aws.StringValue `query:"Message" xml:"Message"`
	SourceIdentifier aws.StringValue `query:"SourceIdentifier" xml:"SourceIdentifier"`
	SourceType       aws.StringValue `query:"SourceType" xml:"SourceType"`
}

// EventsMessage is undocumented.
type EventsMessage struct {
	Events []Event         `query:"Events.member" xml:"DescribeEventsResult>Events>Event"`
	Marker aws.StringValue `query:"Marker" xml:"DescribeEventsResult>Marker"`
}

// ModifyCacheClusterMessage is undocumented.
type ModifyCacheClusterMessage struct {
	AZMode                     aws.StringValue  `query:"AZMode" xml:"AZMode"`
	ApplyImmediately           aws.BooleanValue `query:"ApplyImmediately" xml:"ApplyImmediately"`
	AutoMinorVersionUpgrade    aws.BooleanValue `query:"AutoMinorVersionUpgrade" xml:"AutoMinorVersionUpgrade"`
	CacheClusterID             aws.StringValue  `query:"CacheClusterId" xml:"CacheClusterId"`
	CacheNodeIDsToRemove       []string         `query:"CacheNodeIdsToRemove.member" xml:"CacheNodeIdsToRemove>CacheNodeId"`
	CacheParameterGroupName    aws.StringValue  `query:"CacheParameterGroupName" xml:"CacheParameterGroupName"`
	CacheSecurityGroupNames    []string         `query:"CacheSecurityGroupNames.member" xml:"CacheSecurityGroupNames>CacheSecurityGroupName"`
	EngineVersion              aws.StringValue  `query:"EngineVersion" xml:"EngineVersion"`
	NewAvailabilityZones       []string         `query:"NewAvailabilityZones.member" xml:"NewAvailabilityZones>PreferredAvailabilityZone"`
	NotificationTopicARN       aws.StringValue  `query:"NotificationTopicArn" xml:"NotificationTopicArn"`
	NotificationTopicStatus    aws.StringValue  `query:"NotificationTopicStatus" xml:"NotificationTopicStatus"`
	NumCacheNodes              aws.IntegerValue `query:"NumCacheNodes" xml:"NumCacheNodes"`
	PreferredMaintenanceWindow aws.StringValue  `query:"PreferredMaintenanceWindow" xml:"PreferredMaintenanceWindow"`
	SecurityGroupIDs           []string         `query:"SecurityGroupIds.member" xml:"SecurityGroupIds>SecurityGroupId"`
	SnapshotRetentionLimit     aws.IntegerValue `query:"SnapshotRetentionLimit" xml:"SnapshotRetentionLimit"`
	SnapshotWindow             aws.StringValue  `query:"SnapshotWindow" xml:"SnapshotWindow"`
}

// ModifyCacheClusterResult is undocumented.
type ModifyCacheClusterResult struct {
	CacheCluster *CacheCluster `query:"CacheCluster" xml:"ModifyCacheClusterResult>CacheCluster"`
}

// ModifyCacheParameterGroupMessage is undocumented.
type ModifyCacheParameterGroupMessage struct {
	CacheParameterGroupName aws.StringValue      `query:"CacheParameterGroupName" xml:"CacheParameterGroupName"`
	ParameterNameValues     []ParameterNameValue `query:"ParameterNameValues.member" xml:"ParameterNameValues>ParameterNameValue"`
}

// ModifyCacheSubnetGroupMessage is undocumented.
type ModifyCacheSubnetGroupMessage struct {
	CacheSubnetGroupDescription aws.StringValue `query:"CacheSubnetGroupDescription" xml:"CacheSubnetGroupDescription"`
	CacheSubnetGroupName        aws.StringValue `query:"CacheSubnetGroupName" xml:"CacheSubnetGroupName"`
	SubnetIDs                   []string        `query:"SubnetIds.member" xml:"SubnetIds>SubnetIdentifier"`
}

// ModifyCacheSubnetGroupResult is undocumented.
type ModifyCacheSubnetGroupResult struct {
	CacheSubnetGroup *CacheSubnetGroup `query:"CacheSubnetGroup" xml:"ModifyCacheSubnetGroupResult>CacheSubnetGroup"`
}

// ModifyReplicationGroupMessage is undocumented.
type ModifyReplicationGroupMessage struct {
	ApplyImmediately            aws.BooleanValue `query:"ApplyImmediately" xml:"ApplyImmediately"`
	AutoMinorVersionUpgrade     aws.BooleanValue `query:"AutoMinorVersionUpgrade" xml:"AutoMinorVersionUpgrade"`
	AutomaticFailoverEnabled    aws.BooleanValue `query:"AutomaticFailoverEnabled" xml:"AutomaticFailoverEnabled"`
	CacheParameterGroupName     aws.StringValue  `query:"CacheParameterGroupName" xml:"CacheParameterGroupName"`
	CacheSecurityGroupNames     []string         `query:"CacheSecurityGroupNames.member" xml:"CacheSecurityGroupNames>CacheSecurityGroupName"`
	EngineVersion               aws.StringValue  `query:"EngineVersion" xml:"EngineVersion"`
	NotificationTopicARN        aws.StringValue  `query:"NotificationTopicArn" xml:"NotificationTopicArn"`
	NotificationTopicStatus     aws.StringValue  `query:"NotificationTopicStatus" xml:"NotificationTopicStatus"`
	PreferredMaintenanceWindow  aws.StringValue  `query:"PreferredMaintenanceWindow" xml:"PreferredMaintenanceWindow"`
	PrimaryClusterID            aws.StringValue  `query:"PrimaryClusterId" xml:"PrimaryClusterId"`
	ReplicationGroupDescription aws.StringValue  `query:"ReplicationGroupDescription" xml:"ReplicationGroupDescription"`
	ReplicationGroupID          aws.StringValue  `query:"ReplicationGroupId" xml:"ReplicationGroupId"`
	SecurityGroupIDs            []string         `query:"SecurityGroupIds.member" xml:"SecurityGroupIds>SecurityGroupId"`
	SnapshotRetentionLimit      aws.IntegerValue `query:"SnapshotRetentionLimit" xml:"SnapshotRetentionLimit"`
	SnapshotWindow              aws.StringValue  `query:"SnapshotWindow" xml:"SnapshotWindow"`
	SnapshottingClusterID       aws.StringValue  `query:"SnapshottingClusterId" xml:"SnapshottingClusterId"`
}

// ModifyReplicationGroupResult is undocumented.
type ModifyReplicationGroupResult struct {
	ReplicationGroup *ReplicationGroup `query:"ReplicationGroup" xml:"ModifyReplicationGroupResult>ReplicationGroup"`
}

// NodeGroup is undocumented.
type NodeGroup struct {
	NodeGroupID      aws.StringValue   `query:"NodeGroupId" xml:"NodeGroupId"`
	NodeGroupMembers []NodeGroupMember `query:"NodeGroupMembers.member" xml:"NodeGroupMembers>NodeGroupMember"`
	PrimaryEndpoint  *Endpoint         `query:"PrimaryEndpoint" xml:"PrimaryEndpoint"`
	Status           aws.StringValue   `query:"Status" xml:"Status"`
}

// NodeGroupMember is undocumented.
type NodeGroupMember struct {
	CacheClusterID            aws.StringValue `query:"CacheClusterId" xml:"CacheClusterId"`
	CacheNodeID               aws.StringValue `query:"CacheNodeId" xml:"CacheNodeId"`
	CurrentRole               aws.StringValue `query:"CurrentRole" xml:"CurrentRole"`
	PreferredAvailabilityZone aws.StringValue `query:"PreferredAvailabilityZone" xml:"PreferredAvailabilityZone"`
	ReadEndpoint              *Endpoint       `query:"ReadEndpoint" xml:"ReadEndpoint"`
}

// NodeSnapshot is undocumented.
type NodeSnapshot struct {
	CacheNodeCreateTime time.Time       `query:"CacheNodeCreateTime" xml:"CacheNodeCreateTime"`
	CacheNodeID         aws.StringValue `query:"CacheNodeId" xml:"CacheNodeId"`
	CacheSize           aws.StringValue `query:"CacheSize" xml:"CacheSize"`
	SnapshotCreateTime  time.Time       `query:"SnapshotCreateTime" xml:"SnapshotCreateTime"`
}

// NotificationConfiguration is undocumented.
type NotificationConfiguration struct {
	TopicARN    aws.StringValue `query:"TopicArn" xml:"TopicArn"`
	TopicStatus aws.StringValue `query:"TopicStatus" xml:"TopicStatus"`
}

// Parameter is undocumented.
type Parameter struct {
	AllowedValues        aws.StringValue  `query:"AllowedValues" xml:"AllowedValues"`
	DataType             aws.StringValue  `query:"DataType" xml:"DataType"`
	Description          aws.StringValue  `query:"Description" xml:"Description"`
	IsModifiable         aws.BooleanValue `query:"IsModifiable" xml:"IsModifiable"`
	MinimumEngineVersion aws.StringValue  `query:"MinimumEngineVersion" xml:"MinimumEngineVersion"`
	ParameterName        aws.StringValue  `query:"ParameterName" xml:"ParameterName"`
	ParameterValue       aws.StringValue  `query:"ParameterValue" xml:"ParameterValue"`
	Source               aws.StringValue  `query:"Source" xml:"Source"`
}

// ParameterNameValue is undocumented.
type ParameterNameValue struct {
	ParameterName  aws.StringValue `query:"ParameterName" xml:"ParameterName"`
	ParameterValue aws.StringValue `query:"ParameterValue" xml:"ParameterValue"`
}

// Possible values for ElasticCache.
const (
	PendingAutomaticFailoverStatusDisabled = "disabled"
	PendingAutomaticFailoverStatusEnabled  = "enabled"
)

// PendingModifiedValues is undocumented.
type PendingModifiedValues struct {
	CacheNodeIDsToRemove []string         `query:"CacheNodeIdsToRemove.member" xml:"CacheNodeIdsToRemove>CacheNodeId"`
	EngineVersion        aws.StringValue  `query:"EngineVersion" xml:"EngineVersion"`
	NumCacheNodes        aws.IntegerValue `query:"NumCacheNodes" xml:"NumCacheNodes"`
}

// PurchaseReservedCacheNodesOfferingMessage is undocumented.
type PurchaseReservedCacheNodesOfferingMessage struct {
	CacheNodeCount               aws.IntegerValue `query:"CacheNodeCount" xml:"CacheNodeCount"`
	ReservedCacheNodeID          aws.StringValue  `query:"ReservedCacheNodeId" xml:"ReservedCacheNodeId"`
	ReservedCacheNodesOfferingID aws.StringValue  `query:"ReservedCacheNodesOfferingId" xml:"ReservedCacheNodesOfferingId"`
}

// PurchaseReservedCacheNodesOfferingResult is undocumented.
type PurchaseReservedCacheNodesOfferingResult struct {
	ReservedCacheNode *ReservedCacheNode `query:"ReservedCacheNode" xml:"PurchaseReservedCacheNodesOfferingResult>ReservedCacheNode"`
}

// RebootCacheClusterMessage is undocumented.
type RebootCacheClusterMessage struct {
	CacheClusterID       aws.StringValue `query:"CacheClusterId" xml:"CacheClusterId"`
	CacheNodeIDsToReboot []string        `query:"CacheNodeIdsToReboot.member" xml:"CacheNodeIdsToReboot>CacheNodeId"`
}

// RebootCacheClusterResult is undocumented.
type RebootCacheClusterResult struct {
	CacheCluster *CacheCluster `query:"CacheCluster" xml:"RebootCacheClusterResult>CacheCluster"`
}

// RecurringCharge is undocumented.
type RecurringCharge struct {
	RecurringChargeAmount    aws.DoubleValue `query:"RecurringChargeAmount" xml:"RecurringChargeAmount"`
	RecurringChargeFrequency aws.StringValue `query:"RecurringChargeFrequency" xml:"RecurringChargeFrequency"`
}

// ReplicationGroup is undocumented.
type ReplicationGroup struct {
	AutomaticFailover     aws.StringValue                        `query:"AutomaticFailover" xml:"AutomaticFailover"`
	Description           aws.StringValue                        `query:"Description" xml:"Description"`
	MemberClusters        []string                               `query:"MemberClusters.member" xml:"MemberClusters>ClusterId"`
	NodeGroups            []NodeGroup                            `query:"NodeGroups.member" xml:"NodeGroups>NodeGroup"`
	PendingModifiedValues *ReplicationGroupPendingModifiedValues `query:"PendingModifiedValues" xml:"PendingModifiedValues"`
	ReplicationGroupID    aws.StringValue                        `query:"ReplicationGroupId" xml:"ReplicationGroupId"`
	SnapshottingClusterID aws.StringValue                        `query:"SnapshottingClusterId" xml:"SnapshottingClusterId"`
	Status                aws.StringValue                        `query:"Status" xml:"Status"`
}

// ReplicationGroupMessage is undocumented.
type ReplicationGroupMessage struct {
	Marker            aws.StringValue    `query:"Marker" xml:"DescribeReplicationGroupsResult>Marker"`
	ReplicationGroups []ReplicationGroup `query:"ReplicationGroups.member" xml:"DescribeReplicationGroupsResult>ReplicationGroups>ReplicationGroup"`
}

// ReplicationGroupPendingModifiedValues is undocumented.
type ReplicationGroupPendingModifiedValues struct {
	AutomaticFailoverStatus aws.StringValue `query:"AutomaticFailoverStatus" xml:"AutomaticFailoverStatus"`
	PrimaryClusterID        aws.StringValue `query:"PrimaryClusterId" xml:"PrimaryClusterId"`
}

// ReservedCacheNode is undocumented.
type ReservedCacheNode struct {
	CacheNodeCount               aws.IntegerValue  `query:"CacheNodeCount" xml:"CacheNodeCount"`
	CacheNodeType                aws.StringValue   `query:"CacheNodeType" xml:"CacheNodeType"`
	Duration                     aws.IntegerValue  `query:"Duration" xml:"Duration"`
	FixedPrice                   aws.DoubleValue   `query:"FixedPrice" xml:"FixedPrice"`
	OfferingType                 aws.StringValue   `query:"OfferingType" xml:"OfferingType"`
	ProductDescription           aws.StringValue   `query:"ProductDescription" xml:"ProductDescription"`
	RecurringCharges             []RecurringCharge `query:"RecurringCharges.member" xml:"RecurringCharges>RecurringCharge"`
	ReservedCacheNodeID          aws.StringValue   `query:"ReservedCacheNodeId" xml:"ReservedCacheNodeId"`
	ReservedCacheNodesOfferingID aws.StringValue   `query:"ReservedCacheNodesOfferingId" xml:"ReservedCacheNodesOfferingId"`
	StartTime                    time.Time         `query:"StartTime" xml:"StartTime"`
	State                        aws.StringValue   `query:"State" xml:"State"`
	UsagePrice                   aws.DoubleValue   `query:"UsagePrice" xml:"UsagePrice"`
}

// ReservedCacheNodeMessage is undocumented.
type ReservedCacheNodeMessage struct {
	Marker             aws.StringValue     `query:"Marker" xml:"DescribeReservedCacheNodesResult>Marker"`
	ReservedCacheNodes []ReservedCacheNode `query:"ReservedCacheNodes.member" xml:"DescribeReservedCacheNodesResult>ReservedCacheNodes>ReservedCacheNode"`
}

// ReservedCacheNodesOffering is undocumented.
type ReservedCacheNodesOffering struct {
	CacheNodeType                aws.StringValue   `query:"CacheNodeType" xml:"CacheNodeType"`
	Duration                     aws.IntegerValue  `query:"Duration" xml:"Duration"`
	FixedPrice                   aws.DoubleValue   `query:"FixedPrice" xml:"FixedPrice"`
	OfferingType                 aws.StringValue   `query:"OfferingType" xml:"OfferingType"`
	ProductDescription           aws.StringValue   `query:"ProductDescription" xml:"ProductDescription"`
	RecurringCharges             []RecurringCharge `query:"RecurringCharges.member" xml:"RecurringCharges>RecurringCharge"`
	ReservedCacheNodesOfferingID aws.StringValue   `query:"ReservedCacheNodesOfferingId" xml:"ReservedCacheNodesOfferingId"`
	UsagePrice                   aws.DoubleValue   `query:"UsagePrice" xml:"UsagePrice"`
}

// ReservedCacheNodesOfferingMessage is undocumented.
type ReservedCacheNodesOfferingMessage struct {
	Marker                      aws.StringValue              `query:"Marker" xml:"DescribeReservedCacheNodesOfferingsResult>Marker"`
	ReservedCacheNodesOfferings []ReservedCacheNodesOffering `query:"ReservedCacheNodesOfferings.member" xml:"DescribeReservedCacheNodesOfferingsResult>ReservedCacheNodesOfferings>ReservedCacheNodesOffering"`
}

// ResetCacheParameterGroupMessage is undocumented.
type ResetCacheParameterGroupMessage struct {
	CacheParameterGroupName aws.StringValue      `query:"CacheParameterGroupName" xml:"CacheParameterGroupName"`
	ParameterNameValues     []ParameterNameValue `query:"ParameterNameValues.member" xml:"ParameterNameValues>ParameterNameValue"`
	ResetAllParameters      aws.BooleanValue     `query:"ResetAllParameters" xml:"ResetAllParameters"`
}

// RevokeCacheSecurityGroupIngressMessage is undocumented.
type RevokeCacheSecurityGroupIngressMessage struct {
	CacheSecurityGroupName  aws.StringValue `query:"CacheSecurityGroupName" xml:"CacheSecurityGroupName"`
	EC2SecurityGroupName    aws.StringValue `query:"EC2SecurityGroupName" xml:"EC2SecurityGroupName"`
	EC2SecurityGroupOwnerID aws.StringValue `query:"EC2SecurityGroupOwnerId" xml:"EC2SecurityGroupOwnerId"`
}

// RevokeCacheSecurityGroupIngressResult is undocumented.
type RevokeCacheSecurityGroupIngressResult struct {
	CacheSecurityGroup *CacheSecurityGroup `query:"CacheSecurityGroup" xml:"RevokeCacheSecurityGroupIngressResult>CacheSecurityGroup"`
}

// SecurityGroupMembership is undocumented.
type SecurityGroupMembership struct {
	SecurityGroupID aws.StringValue `query:"SecurityGroupId" xml:"SecurityGroupId"`
	Status          aws.StringValue `query:"Status" xml:"Status"`
}

// Snapshot is undocumented.
type Snapshot struct {
	AutoMinorVersionUpgrade    aws.BooleanValue `query:"AutoMinorVersionUpgrade" xml:"AutoMinorVersionUpgrade"`
	CacheClusterCreateTime     time.Time        `query:"CacheClusterCreateTime" xml:"CacheClusterCreateTime"`
	CacheClusterID             aws.StringValue  `query:"CacheClusterId" xml:"CacheClusterId"`
	CacheNodeType              aws.StringValue  `query:"CacheNodeType" xml:"CacheNodeType"`
	CacheParameterGroupName    aws.StringValue  `query:"CacheParameterGroupName" xml:"CacheParameterGroupName"`
	CacheSubnetGroupName       aws.StringValue  `query:"CacheSubnetGroupName" xml:"CacheSubnetGroupName"`
	Engine                     aws.StringValue  `query:"Engine" xml:"Engine"`
	EngineVersion              aws.StringValue  `query:"EngineVersion" xml:"EngineVersion"`
	NodeSnapshots              []NodeSnapshot   `query:"NodeSnapshots.member" xml:"NodeSnapshots>NodeSnapshot"`
	NumCacheNodes              aws.IntegerValue `query:"NumCacheNodes" xml:"NumCacheNodes"`
	Port                       aws.IntegerValue `query:"Port" xml:"Port"`
	PreferredAvailabilityZone  aws.StringValue  `query:"PreferredAvailabilityZone" xml:"PreferredAvailabilityZone"`
	PreferredMaintenanceWindow aws.StringValue  `query:"PreferredMaintenanceWindow" xml:"PreferredMaintenanceWindow"`
	SnapshotName               aws.StringValue  `query:"SnapshotName" xml:"SnapshotName"`
	SnapshotRetentionLimit     aws.IntegerValue `query:"SnapshotRetentionLimit" xml:"SnapshotRetentionLimit"`
	SnapshotSource             aws.StringValue  `query:"SnapshotSource" xml:"SnapshotSource"`
	SnapshotStatus             aws.StringValue  `query:"SnapshotStatus" xml:"SnapshotStatus"`
	SnapshotWindow             aws.StringValue  `query:"SnapshotWindow" xml:"SnapshotWindow"`
	TopicARN                   aws.StringValue  `query:"TopicArn" xml:"TopicArn"`
	VPCID                      aws.StringValue  `query:"VpcId" xml:"VpcId"`
}

// Possible values for ElasticCache.
const (
	SourceTypeCacheCluster        = "cache-cluster"
	SourceTypeCacheParameterGroup = "cache-parameter-group"
	SourceTypeCacheSecurityGroup  = "cache-security-group"
	SourceTypeCacheSubnetGroup    = "cache-subnet-group"
)

// Subnet is undocumented.
type Subnet struct {
	SubnetAvailabilityZone *AvailabilityZone `query:"SubnetAvailabilityZone" xml:"SubnetAvailabilityZone"`
	SubnetIdentifier       aws.StringValue   `query:"SubnetIdentifier" xml:"SubnetIdentifier"`
}

// DescribeCacheClustersResult is a wrapper for CacheClusterMessage.
type DescribeCacheClustersResult struct {
	CacheClusters []CacheCluster  `query:"CacheClusters.member" xml:"DescribeCacheClustersResult>CacheClusters>CacheCluster"`
	Marker        aws.StringValue `query:"Marker" xml:"DescribeCacheClustersResult>Marker"`
}

// DescribeCacheEngineVersionsResult is a wrapper for CacheEngineVersionMessage.
type DescribeCacheEngineVersionsResult struct {
	CacheEngineVersions []CacheEngineVersion `query:"CacheEngineVersions.member" xml:"DescribeCacheEngineVersionsResult>CacheEngineVersions>CacheEngineVersion"`
	Marker              aws.StringValue      `query:"Marker" xml:"DescribeCacheEngineVersionsResult>Marker"`
}

// DescribeCacheParameterGroupsResult is a wrapper for CacheParameterGroupsMessage.
type DescribeCacheParameterGroupsResult struct {
	CacheParameterGroups []CacheParameterGroup `query:"CacheParameterGroups.member" xml:"DescribeCacheParameterGroupsResult>CacheParameterGroups>CacheParameterGroup"`
	Marker               aws.StringValue       `query:"Marker" xml:"DescribeCacheParameterGroupsResult>Marker"`
}

// DescribeCacheParametersResult is a wrapper for CacheParameterGroupDetails.
type DescribeCacheParametersResult struct {
	CacheNodeTypeSpecificParameters []CacheNodeTypeSpecificParameter `query:"CacheNodeTypeSpecificParameters.member" xml:"DescribeCacheParametersResult>CacheNodeTypeSpecificParameters>CacheNodeTypeSpecificParameter"`
	Marker                          aws.StringValue                  `query:"Marker" xml:"DescribeCacheParametersResult>Marker"`
	Parameters                      []Parameter                      `query:"Parameters.member" xml:"DescribeCacheParametersResult>Parameters>Parameter"`
}

// DescribeCacheSecurityGroupsResult is a wrapper for CacheSecurityGroupMessage.
type DescribeCacheSecurityGroupsResult struct {
	CacheSecurityGroups []CacheSecurityGroup `query:"CacheSecurityGroups.member" xml:"DescribeCacheSecurityGroupsResult>CacheSecurityGroups>CacheSecurityGroup"`
	Marker              aws.StringValue      `query:"Marker" xml:"DescribeCacheSecurityGroupsResult>Marker"`
}

// DescribeCacheSubnetGroupsResult is a wrapper for CacheSubnetGroupMessage.
type DescribeCacheSubnetGroupsResult struct {
	CacheSubnetGroups []CacheSubnetGroup `query:"CacheSubnetGroups.member" xml:"DescribeCacheSubnetGroupsResult>CacheSubnetGroups>CacheSubnetGroup"`
	Marker            aws.StringValue    `query:"Marker" xml:"DescribeCacheSubnetGroupsResult>Marker"`
}

// DescribeEventsResult is a wrapper for EventsMessage.
type DescribeEventsResult struct {
	Events []Event         `query:"Events.member" xml:"DescribeEventsResult>Events>Event"`
	Marker aws.StringValue `query:"Marker" xml:"DescribeEventsResult>Marker"`
}

// DescribeReplicationGroupsResult is a wrapper for ReplicationGroupMessage.
type DescribeReplicationGroupsResult struct {
	Marker            aws.StringValue    `query:"Marker" xml:"DescribeReplicationGroupsResult>Marker"`
	ReplicationGroups []ReplicationGroup `query:"ReplicationGroups.member" xml:"DescribeReplicationGroupsResult>ReplicationGroups>ReplicationGroup"`
}

// DescribeReservedCacheNodesOfferingsResult is a wrapper for ReservedCacheNodesOfferingMessage.
type DescribeReservedCacheNodesOfferingsResult struct {
	Marker                      aws.StringValue              `query:"Marker" xml:"DescribeReservedCacheNodesOfferingsResult>Marker"`
	ReservedCacheNodesOfferings []ReservedCacheNodesOffering `query:"ReservedCacheNodesOfferings.member" xml:"DescribeReservedCacheNodesOfferingsResult>ReservedCacheNodesOfferings>ReservedCacheNodesOffering"`
}

// DescribeReservedCacheNodesResult is a wrapper for ReservedCacheNodeMessage.
type DescribeReservedCacheNodesResult struct {
	Marker             aws.StringValue     `query:"Marker" xml:"DescribeReservedCacheNodesResult>Marker"`
	ReservedCacheNodes []ReservedCacheNode `query:"ReservedCacheNodes.member" xml:"DescribeReservedCacheNodesResult>ReservedCacheNodes>ReservedCacheNode"`
}

// DescribeSnapshotsResult is a wrapper for DescribeSnapshotsListMessage.
type DescribeSnapshotsResult struct {
	Marker    aws.StringValue `query:"Marker" xml:"DescribeSnapshotsResult>Marker"`
	Snapshots []Snapshot      `query:"Snapshots.member" xml:"DescribeSnapshotsResult>Snapshots>Snapshot"`
}

// ModifyCacheParameterGroupResult is a wrapper for CacheParameterGroupNameMessage.
type ModifyCacheParameterGroupResult struct {
	CacheParameterGroupName aws.StringValue `query:"CacheParameterGroupName" xml:"ModifyCacheParameterGroupResult>CacheParameterGroupName"`
}

// ResetCacheParameterGroupResult is a wrapper for CacheParameterGroupNameMessage.
type ResetCacheParameterGroupResult struct {
	CacheParameterGroupName aws.StringValue `query:"CacheParameterGroupName" xml:"ResetCacheParameterGroupResult>CacheParameterGroupName"`
}

// avoid errors if the packages aren't referenced
var _ time.Time

var _ xml.Decoder
var _ = io.EOF
