// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package elasticbeanstalk provides a client for AWS Elastic Beanstalk.
package elasticbeanstalk

import (
	"net/http"
	"time"

	"github.com/awslabs/aws-sdk-go/aws"
	"github.com/awslabs/aws-sdk-go/gen/endpoints"
)

import (
	"encoding/xml"
	"io"
)

// ElasticBeanstalk is a client for AWS Elastic Beanstalk.
type ElasticBeanstalk struct {
	client *aws.QueryClient
}

// New returns a new ElasticBeanstalk client.
func New(creds aws.CredentialsProvider, region string, client *http.Client) *ElasticBeanstalk {
	if client == nil {
		client = http.DefaultClient
	}

	endpoint, service, region := endpoints.Lookup("elasticbeanstalk", region)

	return &ElasticBeanstalk{
		client: &aws.QueryClient{
			Context: aws.Context{
				Credentials: creds,
				Service:     service,
				Region:      region,
			},
			Client:     client,
			Endpoint:   endpoint,
			APIVersion: "2010-12-01",
		},
	}
}

// CheckDNSAvailability is undocumented.
func (c *ElasticBeanstalk) CheckDNSAvailability(req *CheckDNSAvailabilityMessage) (resp *CheckDNSAvailabilityResult, err error) {
	resp = &CheckDNSAvailabilityResult{}
	err = c.client.Do("CheckDNSAvailability", "POST", "/", req, resp)
	return
}

// CreateApplication creates an application that has one configuration
// template named default and no application versions.
func (c *ElasticBeanstalk) CreateApplication(req *CreateApplicationMessage) (resp *CreateApplicationResult, err error) {
	resp = &CreateApplicationResult{}
	err = c.client.Do("CreateApplication", "POST", "/", req, resp)
	return
}

// CreateApplicationVersion creates an application version for the
// specified application.
func (c *ElasticBeanstalk) CreateApplicationVersion(req *CreateApplicationVersionMessage) (resp *CreateApplicationVersionResult, err error) {
	resp = &CreateApplicationVersionResult{}
	err = c.client.Do("CreateApplicationVersion", "POST", "/", req, resp)
	return
}

// CreateConfigurationTemplate creates a configuration template. Templates
// are associated with a specific application and are used to deploy
// different versions of the application with the same configuration
// settings.
func (c *ElasticBeanstalk) CreateConfigurationTemplate(req *CreateConfigurationTemplateMessage) (resp *CreateConfigurationTemplateResult, err error) {
	resp = &CreateConfigurationTemplateResult{}
	err = c.client.Do("CreateConfigurationTemplate", "POST", "/", req, resp)
	return
}

// CreateEnvironment launches an environment for the specified application
// using the specified configuration.
func (c *ElasticBeanstalk) CreateEnvironment(req *CreateEnvironmentMessage) (resp *CreateEnvironmentResult, err error) {
	resp = &CreateEnvironmentResult{}
	err = c.client.Do("CreateEnvironment", "POST", "/", req, resp)
	return
}

// CreateStorageLocation creates the Amazon S3 storage location for the
// account. This location is used to store user log files.
func (c *ElasticBeanstalk) CreateStorageLocation() (resp *CreateStorageLocationResult, err error) {
	resp = &CreateStorageLocationResult{}
	err = c.client.Do("CreateStorageLocation", "POST", "/", nil, resp)
	return
}

// DeleteApplication deletes the specified application along with all
// associated versions and configurations. The application versions will
// not be deleted from your Amazon S3 bucket.
func (c *ElasticBeanstalk) DeleteApplication(req *DeleteApplicationMessage) (err error) {
	// NRE
	err = c.client.Do("DeleteApplication", "POST", "/", req, nil)
	return
}

// DeleteApplicationVersion deletes the specified version from the
// specified application.
func (c *ElasticBeanstalk) DeleteApplicationVersion(req *DeleteApplicationVersionMessage) (err error) {
	// NRE
	err = c.client.Do("DeleteApplicationVersion", "POST", "/", req, nil)
	return
}

// DeleteConfigurationTemplate is undocumented.
func (c *ElasticBeanstalk) DeleteConfigurationTemplate(req *DeleteConfigurationTemplateMessage) (err error) {
	// NRE
	err = c.client.Do("DeleteConfigurationTemplate", "POST", "/", req, nil)
	return
}

// DeleteEnvironmentConfiguration deletes the draft configuration
// associated with the running environment. Updating a running environment
// with any configuration changes creates a draft configuration set. You
// can get the draft configuration using DescribeConfigurationSettings
// while the update is in progress or if the update fails. The
// DeploymentStatus for the draft configuration indicates whether the
// deployment is in process or has failed. The draft configuration remains
// in existence until it is deleted with this action.
func (c *ElasticBeanstalk) DeleteEnvironmentConfiguration(req *DeleteEnvironmentConfigurationMessage) (err error) {
	// NRE
	err = c.client.Do("DeleteEnvironmentConfiguration", "POST", "/", req, nil)
	return
}

// DescribeApplicationVersions returns descriptions for existing
// application versions.
func (c *ElasticBeanstalk) DescribeApplicationVersions(req *DescribeApplicationVersionsMessage) (resp *DescribeApplicationVersionsResult, err error) {
	resp = &DescribeApplicationVersionsResult{}
	err = c.client.Do("DescribeApplicationVersions", "POST", "/", req, resp)
	return
}

// DescribeApplications is undocumented.
func (c *ElasticBeanstalk) DescribeApplications(req *DescribeApplicationsMessage) (resp *DescribeApplicationsResult, err error) {
	resp = &DescribeApplicationsResult{}
	err = c.client.Do("DescribeApplications", "POST", "/", req, resp)
	return
}

// DescribeConfigurationOptions describes the configuration options that
// are used in a particular configuration template or environment, or that
// a specified solution stack defines. The description includes the values
// the options, their default values, and an indication of the required
// action on a running environment if an option value is changed.
func (c *ElasticBeanstalk) DescribeConfigurationOptions(req *DescribeConfigurationOptionsMessage) (resp *DescribeConfigurationOptionsResult, err error) {
	resp = &DescribeConfigurationOptionsResult{}
	err = c.client.Do("DescribeConfigurationOptions", "POST", "/", req, resp)
	return
}

// DescribeConfigurationSettings returns a description of the settings for
// the specified configuration set, that is, either a configuration
// template or the configuration set associated with a running environment.
// When describing the settings for the configuration set associated with a
// running environment, it is possible to receive two sets of setting
// descriptions. One is the deployed configuration set, and the other is a
// draft configuration of an environment that is either in the process of
// deployment or that failed to deploy.
func (c *ElasticBeanstalk) DescribeConfigurationSettings(req *DescribeConfigurationSettingsMessage) (resp *DescribeConfigurationSettingsResult, err error) {
	resp = &DescribeConfigurationSettingsResult{}
	err = c.client.Do("DescribeConfigurationSettings", "POST", "/", req, resp)
	return
}

// DescribeEnvironmentResources is undocumented.
func (c *ElasticBeanstalk) DescribeEnvironmentResources(req *DescribeEnvironmentResourcesMessage) (resp *DescribeEnvironmentResourcesResult, err error) {
	resp = &DescribeEnvironmentResourcesResult{}
	err = c.client.Do("DescribeEnvironmentResources", "POST", "/", req, resp)
	return
}

// DescribeEnvironments is undocumented.
func (c *ElasticBeanstalk) DescribeEnvironments(req *DescribeEnvironmentsMessage) (resp *DescribeEnvironmentsResult, err error) {
	resp = &DescribeEnvironmentsResult{}
	err = c.client.Do("DescribeEnvironments", "POST", "/", req, resp)
	return
}

// DescribeEvents returns list of event descriptions matching criteria up
// to the last 6 weeks.
func (c *ElasticBeanstalk) DescribeEvents(req *DescribeEventsMessage) (resp *DescribeEventsResult, err error) {
	resp = &DescribeEventsResult{}
	err = c.client.Do("DescribeEvents", "POST", "/", req, resp)
	return
}

// ListAvailableSolutionStacks returns a list of the available solution
// stack names.
func (c *ElasticBeanstalk) ListAvailableSolutionStacks() (resp *ListAvailableSolutionStacksResult, err error) {
	resp = &ListAvailableSolutionStacksResult{}
	err = c.client.Do("ListAvailableSolutionStacks", "POST", "/", nil, resp)
	return
}

// RebuildEnvironment deletes and recreates all of the AWS resources (for
// example: the Auto Scaling group, load balancer, etc.) for a specified
// environment and forces a restart.
func (c *ElasticBeanstalk) RebuildEnvironment(req *RebuildEnvironmentMessage) (err error) {
	// NRE
	err = c.client.Do("RebuildEnvironment", "POST", "/", req, nil)
	return
}

// RequestEnvironmentInfo initiates a request to compile the specified type
// of information of the deployed environment. Setting the InfoType to tail
// compiles the last lines from the application server log files of every
// Amazon EC2 instance in your environment. Use RetrieveEnvironmentInfo to
// access the compiled information.
func (c *ElasticBeanstalk) RequestEnvironmentInfo(req *RequestEnvironmentInfoMessage) (err error) {
	// NRE
	err = c.client.Do("RequestEnvironmentInfo", "POST", "/", req, nil)
	return
}

// RestartAppServer causes the environment to restart the application
// container server running on each Amazon EC2 instance.
func (c *ElasticBeanstalk) RestartAppServer(req *RestartAppServerMessage) (err error) {
	// NRE
	err = c.client.Do("RestartAppServer", "POST", "/", req, nil)
	return
}

// RetrieveEnvironmentInfo retrieves the compiled information from a
// RequestEnvironmentInfo request.
func (c *ElasticBeanstalk) RetrieveEnvironmentInfo(req *RetrieveEnvironmentInfoMessage) (resp *RetrieveEnvironmentInfoResult, err error) {
	resp = &RetrieveEnvironmentInfoResult{}
	err = c.client.Do("RetrieveEnvironmentInfo", "POST", "/", req, resp)
	return
}

// SwapEnvironmentCNAMEs is undocumented.
func (c *ElasticBeanstalk) SwapEnvironmentCNAMEs(req *SwapEnvironmentCNAMEsMessage) (err error) {
	// NRE
	err = c.client.Do("SwapEnvironmentCNAMEs", "POST", "/", req, nil)
	return
}

// TerminateEnvironment is undocumented.
func (c *ElasticBeanstalk) TerminateEnvironment(req *TerminateEnvironmentMessage) (resp *TerminateEnvironmentResult, err error) {
	resp = &TerminateEnvironmentResult{}
	err = c.client.Do("TerminateEnvironment", "POST", "/", req, resp)
	return
}

// UpdateApplication updates the specified application to have the
// specified properties.
func (c *ElasticBeanstalk) UpdateApplication(req *UpdateApplicationMessage) (resp *UpdateApplicationResult, err error) {
	resp = &UpdateApplicationResult{}
	err = c.client.Do("UpdateApplication", "POST", "/", req, resp)
	return
}

// UpdateApplicationVersion updates the specified application version to
// have the specified properties.
func (c *ElasticBeanstalk) UpdateApplicationVersion(req *UpdateApplicationVersionMessage) (resp *UpdateApplicationVersionResult, err error) {
	resp = &UpdateApplicationVersionResult{}
	err = c.client.Do("UpdateApplicationVersion", "POST", "/", req, resp)
	return
}

// UpdateConfigurationTemplate updates the specified configuration template
// to have the specified properties or configuration option values.
func (c *ElasticBeanstalk) UpdateConfigurationTemplate(req *UpdateConfigurationTemplateMessage) (resp *UpdateConfigurationTemplateResult, err error) {
	resp = &UpdateConfigurationTemplateResult{}
	err = c.client.Do("UpdateConfigurationTemplate", "POST", "/", req, resp)
	return
}

// UpdateEnvironment updates the environment description, deploys a new
// application version, updates the configuration settings to an entirely
// new configuration template, or updates select configuration option
// values in the running environment. Attempting to update both the release
// and configuration is not allowed and AWS Elastic Beanstalk returns an
// InvalidParameterCombination error. When updating the configuration
// settings to a new template or individual settings, a draft configuration
// is created and DescribeConfigurationSettings for this environment
// returns two setting descriptions with different DeploymentStatus values.
func (c *ElasticBeanstalk) UpdateEnvironment(req *UpdateEnvironmentMessage) (resp *UpdateEnvironmentResult, err error) {
	resp = &UpdateEnvironmentResult{}
	err = c.client.Do("UpdateEnvironment", "POST", "/", req, resp)
	return
}

// ValidateConfigurationSettings takes a set of configuration settings and
// either a configuration template or environment, and determines whether
// those values are valid. This action returns a list of messages
// indicating any errors or warnings associated with the selection of
// option values.
func (c *ElasticBeanstalk) ValidateConfigurationSettings(req *ValidateConfigurationSettingsMessage) (resp *ValidateConfigurationSettingsResult, err error) {
	resp = &ValidateConfigurationSettingsResult{}
	err = c.client.Do("ValidateConfigurationSettings", "POST", "/", req, resp)
	return
}

// ApplicationDescription is undocumented.
type ApplicationDescription struct {
	ApplicationName        aws.StringValue `query:"ApplicationName" xml:"ApplicationName"`
	ConfigurationTemplates []string        `query:"ConfigurationTemplates.member" xml:"ConfigurationTemplates>member"`
	DateCreated            time.Time       `query:"DateCreated" xml:"DateCreated"`
	DateUpdated            time.Time       `query:"DateUpdated" xml:"DateUpdated"`
	Description            aws.StringValue `query:"Description" xml:"Description"`
	Versions               []string        `query:"Versions.member" xml:"Versions>member"`
}

// ApplicationDescriptionMessage is undocumented.
type ApplicationDescriptionMessage struct {
	Application *ApplicationDescription `query:"Application" xml:"Application"`
}

// ApplicationDescriptionsMessage is undocumented.
type ApplicationDescriptionsMessage struct {
	Applications []ApplicationDescription `query:"Applications.member" xml:"DescribeApplicationsResult>Applications>member"`
}

// ApplicationVersionDescription is undocumented.
type ApplicationVersionDescription struct {
	ApplicationName aws.StringValue `query:"ApplicationName" xml:"ApplicationName"`
	DateCreated     time.Time       `query:"DateCreated" xml:"DateCreated"`
	DateUpdated     time.Time       `query:"DateUpdated" xml:"DateUpdated"`
	Description     aws.StringValue `query:"Description" xml:"Description"`
	SourceBundle    *S3Location     `query:"SourceBundle" xml:"SourceBundle"`
	VersionLabel    aws.StringValue `query:"VersionLabel" xml:"VersionLabel"`
}

// ApplicationVersionDescriptionMessage is undocumented.
type ApplicationVersionDescriptionMessage struct {
	ApplicationVersion *ApplicationVersionDescription `query:"ApplicationVersion" xml:"ApplicationVersion"`
}

// ApplicationVersionDescriptionsMessage is undocumented.
type ApplicationVersionDescriptionsMessage struct {
	ApplicationVersions []ApplicationVersionDescription `query:"ApplicationVersions.member" xml:"DescribeApplicationVersionsResult>ApplicationVersions>member"`
}

// AutoScalingGroup is undocumented.
type AutoScalingGroup struct {
	Name aws.StringValue `query:"Name" xml:"Name"`
}

// CheckDNSAvailabilityMessage is undocumented.
type CheckDNSAvailabilityMessage struct {
	CNAMEPrefix aws.StringValue `query:"CNAMEPrefix" xml:"CNAMEPrefix"`
}

// CheckDNSAvailabilityResultMessage is undocumented.
type CheckDNSAvailabilityResultMessage struct {
	Available           aws.BooleanValue `query:"Available" xml:"CheckDNSAvailabilityResult>Available"`
	FullyQualifiedCNAME aws.StringValue  `query:"FullyQualifiedCNAME" xml:"CheckDNSAvailabilityResult>FullyQualifiedCNAME"`
}

// Possible values for ElasticBeanstalk.
const (
	ConfigurationDeploymentStatusDeployed = "deployed"
	ConfigurationDeploymentStatusFailed   = "failed"
	ConfigurationDeploymentStatusPending  = "pending"
)

// ConfigurationOptionDescription is undocumented.
type ConfigurationOptionDescription struct {
	ChangeSeverity aws.StringValue         `query:"ChangeSeverity" xml:"ChangeSeverity"`
	DefaultValue   aws.StringValue         `query:"DefaultValue" xml:"DefaultValue"`
	MaxLength      aws.IntegerValue        `query:"MaxLength" xml:"MaxLength"`
	MaxValue       aws.IntegerValue        `query:"MaxValue" xml:"MaxValue"`
	MinValue       aws.IntegerValue        `query:"MinValue" xml:"MinValue"`
	Name           aws.StringValue         `query:"Name" xml:"Name"`
	Namespace      aws.StringValue         `query:"Namespace" xml:"Namespace"`
	Regex          *OptionRestrictionRegex `query:"Regex" xml:"Regex"`
	UserDefined    aws.BooleanValue        `query:"UserDefined" xml:"UserDefined"`
	ValueOptions   []string                `query:"ValueOptions.member" xml:"ValueOptions>member"`
	ValueType      aws.StringValue         `query:"ValueType" xml:"ValueType"`
}

// ConfigurationOptionSetting is undocumented.
type ConfigurationOptionSetting struct {
	Namespace  aws.StringValue `query:"Namespace" xml:"Namespace"`
	OptionName aws.StringValue `query:"OptionName" xml:"OptionName"`
	Value      aws.StringValue `query:"Value" xml:"Value"`
}

// Possible values for ElasticBeanstalk.
const (
	ConfigurationOptionValueTypeList   = "List"
	ConfigurationOptionValueTypeScalar = "Scalar"
)

// ConfigurationOptionsDescription is undocumented.
type ConfigurationOptionsDescription struct {
	Options           []ConfigurationOptionDescription `query:"Options.member" xml:"DescribeConfigurationOptionsResult>Options>member"`
	SolutionStackName aws.StringValue                  `query:"SolutionStackName" xml:"DescribeConfigurationOptionsResult>SolutionStackName"`
}

// ConfigurationSettingsDescription is undocumented.
type ConfigurationSettingsDescription struct {
	ApplicationName   aws.StringValue              `query:"ApplicationName" xml:"ApplicationName"`
	DateCreated       time.Time                    `query:"DateCreated" xml:"DateCreated"`
	DateUpdated       time.Time                    `query:"DateUpdated" xml:"DateUpdated"`
	DeploymentStatus  aws.StringValue              `query:"DeploymentStatus" xml:"DeploymentStatus"`
	Description       aws.StringValue              `query:"Description" xml:"Description"`
	EnvironmentName   aws.StringValue              `query:"EnvironmentName" xml:"EnvironmentName"`
	OptionSettings    []ConfigurationOptionSetting `query:"OptionSettings.member" xml:"OptionSettings>member"`
	SolutionStackName aws.StringValue              `query:"SolutionStackName" xml:"SolutionStackName"`
	TemplateName      aws.StringValue              `query:"TemplateName" xml:"TemplateName"`
}

// ConfigurationSettingsDescriptions is undocumented.
type ConfigurationSettingsDescriptions struct {
	ConfigurationSettings []ConfigurationSettingsDescription `query:"ConfigurationSettings.member" xml:"DescribeConfigurationSettingsResult>ConfigurationSettings>member"`
}

// ConfigurationSettingsValidationMessages is undocumented.
type ConfigurationSettingsValidationMessages struct {
	Messages []ValidationMessage `query:"Messages.member" xml:"ValidateConfigurationSettingsResult>Messages>member"`
}

// CreateApplicationMessage is undocumented.
type CreateApplicationMessage struct {
	ApplicationName aws.StringValue `query:"ApplicationName" xml:"ApplicationName"`
	Description     aws.StringValue `query:"Description" xml:"Description"`
}

// CreateApplicationVersionMessage is undocumented.
type CreateApplicationVersionMessage struct {
	ApplicationName       aws.StringValue  `query:"ApplicationName" xml:"ApplicationName"`
	AutoCreateApplication aws.BooleanValue `query:"AutoCreateApplication" xml:"AutoCreateApplication"`
	Description           aws.StringValue  `query:"Description" xml:"Description"`
	SourceBundle          *S3Location      `query:"SourceBundle" xml:"SourceBundle"`
	VersionLabel          aws.StringValue  `query:"VersionLabel" xml:"VersionLabel"`
}

// CreateConfigurationTemplateMessage is undocumented.
type CreateConfigurationTemplateMessage struct {
	ApplicationName     aws.StringValue              `query:"ApplicationName" xml:"ApplicationName"`
	Description         aws.StringValue              `query:"Description" xml:"Description"`
	EnvironmentID       aws.StringValue              `query:"EnvironmentId" xml:"EnvironmentId"`
	OptionSettings      []ConfigurationOptionSetting `query:"OptionSettings.member" xml:"OptionSettings>member"`
	SolutionStackName   aws.StringValue              `query:"SolutionStackName" xml:"SolutionStackName"`
	SourceConfiguration *SourceConfiguration         `query:"SourceConfiguration" xml:"SourceConfiguration"`
	TemplateName        aws.StringValue              `query:"TemplateName" xml:"TemplateName"`
}

// CreateEnvironmentMessage is undocumented.
type CreateEnvironmentMessage struct {
	ApplicationName   aws.StringValue              `query:"ApplicationName" xml:"ApplicationName"`
	CNAMEPrefix       aws.StringValue              `query:"CNAMEPrefix" xml:"CNAMEPrefix"`
	Description       aws.StringValue              `query:"Description" xml:"Description"`
	EnvironmentName   aws.StringValue              `query:"EnvironmentName" xml:"EnvironmentName"`
	OptionSettings    []ConfigurationOptionSetting `query:"OptionSettings.member" xml:"OptionSettings>member"`
	OptionsToRemove   []OptionSpecification        `query:"OptionsToRemove.member" xml:"OptionsToRemove>member"`
	SolutionStackName aws.StringValue              `query:"SolutionStackName" xml:"SolutionStackName"`
	Tags              []Tag                        `query:"Tags.member" xml:"Tags>member"`
	TemplateName      aws.StringValue              `query:"TemplateName" xml:"TemplateName"`
	Tier              *EnvironmentTier             `query:"Tier" xml:"Tier"`
	VersionLabel      aws.StringValue              `query:"VersionLabel" xml:"VersionLabel"`
}

// CreateStorageLocationResultMessage is undocumented.
type CreateStorageLocationResultMessage struct {
	S3Bucket aws.StringValue `query:"S3Bucket" xml:"CreateStorageLocationResult>S3Bucket"`
}

// DeleteApplicationMessage is undocumented.
type DeleteApplicationMessage struct {
	ApplicationName     aws.StringValue  `query:"ApplicationName" xml:"ApplicationName"`
	TerminateEnvByForce aws.BooleanValue `query:"TerminateEnvByForce" xml:"TerminateEnvByForce"`
}

// DeleteApplicationVersionMessage is undocumented.
type DeleteApplicationVersionMessage struct {
	ApplicationName    aws.StringValue  `query:"ApplicationName" xml:"ApplicationName"`
	DeleteSourceBundle aws.BooleanValue `query:"DeleteSourceBundle" xml:"DeleteSourceBundle"`
	VersionLabel       aws.StringValue  `query:"VersionLabel" xml:"VersionLabel"`
}

// DeleteConfigurationTemplateMessage is undocumented.
type DeleteConfigurationTemplateMessage struct {
	ApplicationName aws.StringValue `query:"ApplicationName" xml:"ApplicationName"`
	TemplateName    aws.StringValue `query:"TemplateName" xml:"TemplateName"`
}

// DeleteEnvironmentConfigurationMessage is undocumented.
type DeleteEnvironmentConfigurationMessage struct {
	ApplicationName aws.StringValue `query:"ApplicationName" xml:"ApplicationName"`
	EnvironmentName aws.StringValue `query:"EnvironmentName" xml:"EnvironmentName"`
}

// DescribeApplicationVersionsMessage is undocumented.
type DescribeApplicationVersionsMessage struct {
	ApplicationName aws.StringValue `query:"ApplicationName" xml:"ApplicationName"`
	VersionLabels   []string        `query:"VersionLabels.member" xml:"VersionLabels>member"`
}

// DescribeApplicationsMessage is undocumented.
type DescribeApplicationsMessage struct {
	ApplicationNames []string `query:"ApplicationNames.member" xml:"ApplicationNames>member"`
}

// DescribeConfigurationOptionsMessage is undocumented.
type DescribeConfigurationOptionsMessage struct {
	ApplicationName   aws.StringValue       `query:"ApplicationName" xml:"ApplicationName"`
	EnvironmentName   aws.StringValue       `query:"EnvironmentName" xml:"EnvironmentName"`
	Options           []OptionSpecification `query:"Options.member" xml:"Options>member"`
	SolutionStackName aws.StringValue       `query:"SolutionStackName" xml:"SolutionStackName"`
	TemplateName      aws.StringValue       `query:"TemplateName" xml:"TemplateName"`
}

// DescribeConfigurationSettingsMessage is undocumented.
type DescribeConfigurationSettingsMessage struct {
	ApplicationName aws.StringValue `query:"ApplicationName" xml:"ApplicationName"`
	EnvironmentName aws.StringValue `query:"EnvironmentName" xml:"EnvironmentName"`
	TemplateName    aws.StringValue `query:"TemplateName" xml:"TemplateName"`
}

// DescribeEnvironmentResourcesMessage is undocumented.
type DescribeEnvironmentResourcesMessage struct {
	EnvironmentID   aws.StringValue `query:"EnvironmentId" xml:"EnvironmentId"`
	EnvironmentName aws.StringValue `query:"EnvironmentName" xml:"EnvironmentName"`
}

// DescribeEnvironmentsMessage is undocumented.
type DescribeEnvironmentsMessage struct {
	ApplicationName       aws.StringValue  `query:"ApplicationName" xml:"ApplicationName"`
	EnvironmentIDs        []string         `query:"EnvironmentIds.member" xml:"EnvironmentIds>member"`
	EnvironmentNames      []string         `query:"EnvironmentNames.member" xml:"EnvironmentNames>member"`
	IncludeDeleted        aws.BooleanValue `query:"IncludeDeleted" xml:"IncludeDeleted"`
	IncludedDeletedBackTo time.Time        `query:"IncludedDeletedBackTo" xml:"IncludedDeletedBackTo"`
	VersionLabel          aws.StringValue  `query:"VersionLabel" xml:"VersionLabel"`
}

// DescribeEventsMessage is undocumented.
type DescribeEventsMessage struct {
	ApplicationName aws.StringValue  `query:"ApplicationName" xml:"ApplicationName"`
	EndTime         time.Time        `query:"EndTime" xml:"EndTime"`
	EnvironmentID   aws.StringValue  `query:"EnvironmentId" xml:"EnvironmentId"`
	EnvironmentName aws.StringValue  `query:"EnvironmentName" xml:"EnvironmentName"`
	MaxRecords      aws.IntegerValue `query:"MaxRecords" xml:"MaxRecords"`
	NextToken       aws.StringValue  `query:"NextToken" xml:"NextToken"`
	RequestID       aws.StringValue  `query:"RequestId" xml:"RequestId"`
	Severity        aws.StringValue  `query:"Severity" xml:"Severity"`
	StartTime       time.Time        `query:"StartTime" xml:"StartTime"`
	TemplateName    aws.StringValue  `query:"TemplateName" xml:"TemplateName"`
	VersionLabel    aws.StringValue  `query:"VersionLabel" xml:"VersionLabel"`
}

// EnvironmentDescription is undocumented.
type EnvironmentDescription struct {
	ApplicationName   aws.StringValue                  `query:"ApplicationName" xml:"ApplicationName"`
	CNAME             aws.StringValue                  `query:"CNAME" xml:"CNAME"`
	DateCreated       time.Time                        `query:"DateCreated" xml:"DateCreated"`
	DateUpdated       time.Time                        `query:"DateUpdated" xml:"DateUpdated"`
	Description       aws.StringValue                  `query:"Description" xml:"Description"`
	EndpointURL       aws.StringValue                  `query:"EndpointURL" xml:"EndpointURL"`
	EnvironmentID     aws.StringValue                  `query:"EnvironmentId" xml:"EnvironmentId"`
	EnvironmentName   aws.StringValue                  `query:"EnvironmentName" xml:"EnvironmentName"`
	Health            aws.StringValue                  `query:"Health" xml:"Health"`
	Resources         *EnvironmentResourcesDescription `query:"Resources" xml:"Resources"`
	SolutionStackName aws.StringValue                  `query:"SolutionStackName" xml:"SolutionStackName"`
	Status            aws.StringValue                  `query:"Status" xml:"Status"`
	TemplateName      aws.StringValue                  `query:"TemplateName" xml:"TemplateName"`
	Tier              *EnvironmentTier                 `query:"Tier" xml:"Tier"`
	VersionLabel      aws.StringValue                  `query:"VersionLabel" xml:"VersionLabel"`
}

// EnvironmentDescriptionsMessage is undocumented.
type EnvironmentDescriptionsMessage struct {
	Environments []EnvironmentDescription `query:"Environments.member" xml:"DescribeEnvironmentsResult>Environments>member"`
}

// Possible values for ElasticBeanstalk.
const (
	EnvironmentHealthGreen  = "Green"
	EnvironmentHealthGrey   = "Grey"
	EnvironmentHealthRed    = "Red"
	EnvironmentHealthYellow = "Yellow"
)

// EnvironmentInfoDescription is undocumented.
type EnvironmentInfoDescription struct {
	EC2InstanceID   aws.StringValue `query:"Ec2InstanceId" xml:"Ec2InstanceId"`
	InfoType        aws.StringValue `query:"InfoType" xml:"InfoType"`
	Message         aws.StringValue `query:"Message" xml:"Message"`
	SampleTimestamp time.Time       `query:"SampleTimestamp" xml:"SampleTimestamp"`
}

// Possible values for ElasticBeanstalk.
const (
	EnvironmentInfoTypeTail = "tail"
)

// EnvironmentResourceDescription is undocumented.
type EnvironmentResourceDescription struct {
	AutoScalingGroups    []AutoScalingGroup    `query:"AutoScalingGroups.member" xml:"AutoScalingGroups>member"`
	EnvironmentName      aws.StringValue       `query:"EnvironmentName" xml:"EnvironmentName"`
	Instances            []Instance            `query:"Instances.member" xml:"Instances>member"`
	LaunchConfigurations []LaunchConfiguration `query:"LaunchConfigurations.member" xml:"LaunchConfigurations>member"`
	LoadBalancers        []LoadBalancer        `query:"LoadBalancers.member" xml:"LoadBalancers>member"`
	Queues               []Queue               `query:"Queues.member" xml:"Queues>member"`
	Triggers             []Trigger             `query:"Triggers.member" xml:"Triggers>member"`
}

// EnvironmentResourceDescriptionsMessage is undocumented.
type EnvironmentResourceDescriptionsMessage struct {
	EnvironmentResources *EnvironmentResourceDescription `query:"EnvironmentResources" xml:"DescribeEnvironmentResourcesResult>EnvironmentResources"`
}

// EnvironmentResourcesDescription is undocumented.
type EnvironmentResourcesDescription struct {
	LoadBalancer *LoadBalancerDescription `query:"LoadBalancer" xml:"LoadBalancer"`
}

// Possible values for ElasticBeanstalk.
const (
	EnvironmentStatusLaunching   = "Launching"
	EnvironmentStatusReady       = "Ready"
	EnvironmentStatusTerminated  = "Terminated"
	EnvironmentStatusTerminating = "Terminating"
	EnvironmentStatusUpdating    = "Updating"
)

// EnvironmentTier is undocumented.
type EnvironmentTier struct {
	Name    aws.StringValue `query:"Name" xml:"Name"`
	Type    aws.StringValue `query:"Type" xml:"Type"`
	Version aws.StringValue `query:"Version" xml:"Version"`
}

// EventDescription is undocumented.
type EventDescription struct {
	ApplicationName aws.StringValue `query:"ApplicationName" xml:"ApplicationName"`
	EnvironmentName aws.StringValue `query:"EnvironmentName" xml:"EnvironmentName"`
	EventDate       time.Time       `query:"EventDate" xml:"EventDate"`
	Message         aws.StringValue `query:"Message" xml:"Message"`
	RequestID       aws.StringValue `query:"RequestId" xml:"RequestId"`
	Severity        aws.StringValue `query:"Severity" xml:"Severity"`
	TemplateName    aws.StringValue `query:"TemplateName" xml:"TemplateName"`
	VersionLabel    aws.StringValue `query:"VersionLabel" xml:"VersionLabel"`
}

// EventDescriptionsMessage is undocumented.
type EventDescriptionsMessage struct {
	Events    []EventDescription `query:"Events.member" xml:"DescribeEventsResult>Events>member"`
	NextToken aws.StringValue    `query:"NextToken" xml:"DescribeEventsResult>NextToken"`
}

// Possible values for ElasticBeanstalk.
const (
	EventSeverityDebug = "DEBUG"
	EventSeverityError = "ERROR"
	EventSeverityFatal = "FATAL"
	EventSeverityInfo  = "INFO"
	EventSeverityTrace = "TRACE"
	EventSeverityWarn  = "WARN"
)

// Instance is undocumented.
type Instance struct {
	ID aws.StringValue `query:"Id" xml:"Id"`
}

// LaunchConfiguration is undocumented.
type LaunchConfiguration struct {
	Name aws.StringValue `query:"Name" xml:"Name"`
}

// ListAvailableSolutionStacksResultMessage is undocumented.
type ListAvailableSolutionStacksResultMessage struct {
	SolutionStackDetails []SolutionStackDescription `query:"SolutionStackDetails.member" xml:"ListAvailableSolutionStacksResult>SolutionStackDetails>member"`
	SolutionStacks       []string                   `query:"SolutionStacks.member" xml:"ListAvailableSolutionStacksResult>SolutionStacks>member"`
}

// Listener is undocumented.
type Listener struct {
	Port     aws.IntegerValue `query:"Port" xml:"Port"`
	Protocol aws.StringValue  `query:"Protocol" xml:"Protocol"`
}

// LoadBalancer is undocumented.
type LoadBalancer struct {
	Name aws.StringValue `query:"Name" xml:"Name"`
}

// LoadBalancerDescription is undocumented.
type LoadBalancerDescription struct {
	Domain           aws.StringValue `query:"Domain" xml:"Domain"`
	Listeners        []Listener      `query:"Listeners.member" xml:"Listeners>member"`
	LoadBalancerName aws.StringValue `query:"LoadBalancerName" xml:"LoadBalancerName"`
}

// OptionRestrictionRegex is undocumented.
type OptionRestrictionRegex struct {
	Label   aws.StringValue `query:"Label" xml:"Label"`
	Pattern aws.StringValue `query:"Pattern" xml:"Pattern"`
}

// OptionSpecification is undocumented.
type OptionSpecification struct {
	Namespace  aws.StringValue `query:"Namespace" xml:"Namespace"`
	OptionName aws.StringValue `query:"OptionName" xml:"OptionName"`
}

// Queue is undocumented.
type Queue struct {
	Name aws.StringValue `query:"Name" xml:"Name"`
	URL  aws.StringValue `query:"URL" xml:"URL"`
}

// RebuildEnvironmentMessage is undocumented.
type RebuildEnvironmentMessage struct {
	EnvironmentID   aws.StringValue `query:"EnvironmentId" xml:"EnvironmentId"`
	EnvironmentName aws.StringValue `query:"EnvironmentName" xml:"EnvironmentName"`
}

// RequestEnvironmentInfoMessage is undocumented.
type RequestEnvironmentInfoMessage struct {
	EnvironmentID   aws.StringValue `query:"EnvironmentId" xml:"EnvironmentId"`
	EnvironmentName aws.StringValue `query:"EnvironmentName" xml:"EnvironmentName"`
	InfoType        aws.StringValue `query:"InfoType" xml:"InfoType"`
}

// RestartAppServerMessage is undocumented.
type RestartAppServerMessage struct {
	EnvironmentID   aws.StringValue `query:"EnvironmentId" xml:"EnvironmentId"`
	EnvironmentName aws.StringValue `query:"EnvironmentName" xml:"EnvironmentName"`
}

// RetrieveEnvironmentInfoMessage is undocumented.
type RetrieveEnvironmentInfoMessage struct {
	EnvironmentID   aws.StringValue `query:"EnvironmentId" xml:"EnvironmentId"`
	EnvironmentName aws.StringValue `query:"EnvironmentName" xml:"EnvironmentName"`
	InfoType        aws.StringValue `query:"InfoType" xml:"InfoType"`
}

// RetrieveEnvironmentInfoResultMessage is undocumented.
type RetrieveEnvironmentInfoResultMessage struct {
	EnvironmentInfo []EnvironmentInfoDescription `query:"EnvironmentInfo.member" xml:"RetrieveEnvironmentInfoResult>EnvironmentInfo>member"`
}

// S3Location is undocumented.
type S3Location struct {
	S3Bucket aws.StringValue `query:"S3Bucket" xml:"S3Bucket"`
	S3Key    aws.StringValue `query:"S3Key" xml:"S3Key"`
}

// SolutionStackDescription is undocumented.
type SolutionStackDescription struct {
	PermittedFileTypes []string        `query:"PermittedFileTypes.member" xml:"PermittedFileTypes>member"`
	SolutionStackName  aws.StringValue `query:"SolutionStackName" xml:"SolutionStackName"`
}

// SourceConfiguration is undocumented.
type SourceConfiguration struct {
	ApplicationName aws.StringValue `query:"ApplicationName" xml:"ApplicationName"`
	TemplateName    aws.StringValue `query:"TemplateName" xml:"TemplateName"`
}

// SwapEnvironmentCNAMEsMessage is undocumented.
type SwapEnvironmentCNAMEsMessage struct {
	DestinationEnvironmentID   aws.StringValue `query:"DestinationEnvironmentId" xml:"DestinationEnvironmentId"`
	DestinationEnvironmentName aws.StringValue `query:"DestinationEnvironmentName" xml:"DestinationEnvironmentName"`
	SourceEnvironmentID        aws.StringValue `query:"SourceEnvironmentId" xml:"SourceEnvironmentId"`
	SourceEnvironmentName      aws.StringValue `query:"SourceEnvironmentName" xml:"SourceEnvironmentName"`
}

// Tag is undocumented.
type Tag struct {
	Key   aws.StringValue `query:"Key" xml:"Key"`
	Value aws.StringValue `query:"Value" xml:"Value"`
}

// TerminateEnvironmentMessage is undocumented.
type TerminateEnvironmentMessage struct {
	EnvironmentID      aws.StringValue  `query:"EnvironmentId" xml:"EnvironmentId"`
	EnvironmentName    aws.StringValue  `query:"EnvironmentName" xml:"EnvironmentName"`
	TerminateResources aws.BooleanValue `query:"TerminateResources" xml:"TerminateResources"`
}

// Trigger is undocumented.
type Trigger struct {
	Name aws.StringValue `query:"Name" xml:"Name"`
}

// UpdateApplicationMessage is undocumented.
type UpdateApplicationMessage struct {
	ApplicationName aws.StringValue `query:"ApplicationName" xml:"ApplicationName"`
	Description     aws.StringValue `query:"Description" xml:"Description"`
}

// UpdateApplicationVersionMessage is undocumented.
type UpdateApplicationVersionMessage struct {
	ApplicationName aws.StringValue `query:"ApplicationName" xml:"ApplicationName"`
	Description     aws.StringValue `query:"Description" xml:"Description"`
	VersionLabel    aws.StringValue `query:"VersionLabel" xml:"VersionLabel"`
}

// UpdateConfigurationTemplateMessage is undocumented.
type UpdateConfigurationTemplateMessage struct {
	ApplicationName aws.StringValue              `query:"ApplicationName" xml:"ApplicationName"`
	Description     aws.StringValue              `query:"Description" xml:"Description"`
	OptionSettings  []ConfigurationOptionSetting `query:"OptionSettings.member" xml:"OptionSettings>member"`
	OptionsToRemove []OptionSpecification        `query:"OptionsToRemove.member" xml:"OptionsToRemove>member"`
	TemplateName    aws.StringValue              `query:"TemplateName" xml:"TemplateName"`
}

// UpdateEnvironmentMessage is undocumented.
type UpdateEnvironmentMessage struct {
	Description     aws.StringValue              `query:"Description" xml:"Description"`
	EnvironmentID   aws.StringValue              `query:"EnvironmentId" xml:"EnvironmentId"`
	EnvironmentName aws.StringValue              `query:"EnvironmentName" xml:"EnvironmentName"`
	OptionSettings  []ConfigurationOptionSetting `query:"OptionSettings.member" xml:"OptionSettings>member"`
	OptionsToRemove []OptionSpecification        `query:"OptionsToRemove.member" xml:"OptionsToRemove>member"`
	TemplateName    aws.StringValue              `query:"TemplateName" xml:"TemplateName"`
	Tier            *EnvironmentTier             `query:"Tier" xml:"Tier"`
	VersionLabel    aws.StringValue              `query:"VersionLabel" xml:"VersionLabel"`
}

// ValidateConfigurationSettingsMessage is undocumented.
type ValidateConfigurationSettingsMessage struct {
	ApplicationName aws.StringValue              `query:"ApplicationName" xml:"ApplicationName"`
	EnvironmentName aws.StringValue              `query:"EnvironmentName" xml:"EnvironmentName"`
	OptionSettings  []ConfigurationOptionSetting `query:"OptionSettings.member" xml:"OptionSettings>member"`
	TemplateName    aws.StringValue              `query:"TemplateName" xml:"TemplateName"`
}

// ValidationMessage is undocumented.
type ValidationMessage struct {
	Message    aws.StringValue `query:"Message" xml:"Message"`
	Namespace  aws.StringValue `query:"Namespace" xml:"Namespace"`
	OptionName aws.StringValue `query:"OptionName" xml:"OptionName"`
	Severity   aws.StringValue `query:"Severity" xml:"Severity"`
}

// Possible values for ElasticBeanstalk.
const (
	ValidationSeverityError   = "error"
	ValidationSeverityWarning = "warning"
)

// CheckDNSAvailabilityResult is a wrapper for CheckDNSAvailabilityResultMessage.
type CheckDNSAvailabilityResult struct {
	Available           aws.BooleanValue `query:"Available" xml:"CheckDNSAvailabilityResult>Available"`
	FullyQualifiedCNAME aws.StringValue  `query:"FullyQualifiedCNAME" xml:"CheckDNSAvailabilityResult>FullyQualifiedCNAME"`
}

// CreateApplicationResult is a wrapper for ApplicationDescriptionMessage.
type CreateApplicationResult struct {
	Application *ApplicationDescription `query:"Application" xml:"CreateApplicationResult>Application"`
}

// CreateApplicationVersionResult is a wrapper for ApplicationVersionDescriptionMessage.
type CreateApplicationVersionResult struct {
	ApplicationVersion *ApplicationVersionDescription `query:"ApplicationVersion" xml:"CreateApplicationVersionResult>ApplicationVersion"`
}

// CreateConfigurationTemplateResult is a wrapper for ConfigurationSettingsDescription.
type CreateConfigurationTemplateResult struct {
	ApplicationName   aws.StringValue              `query:"ApplicationName" xml:"CreateConfigurationTemplateResult>ApplicationName"`
	DateCreated       time.Time                    `query:"DateCreated" xml:"CreateConfigurationTemplateResult>DateCreated"`
	DateUpdated       time.Time                    `query:"DateUpdated" xml:"CreateConfigurationTemplateResult>DateUpdated"`
	DeploymentStatus  aws.StringValue              `query:"DeploymentStatus" xml:"CreateConfigurationTemplateResult>DeploymentStatus"`
	Description       aws.StringValue              `query:"Description" xml:"CreateConfigurationTemplateResult>Description"`
	EnvironmentName   aws.StringValue              `query:"EnvironmentName" xml:"CreateConfigurationTemplateResult>EnvironmentName"`
	OptionSettings    []ConfigurationOptionSetting `query:"OptionSettings.member" xml:"CreateConfigurationTemplateResult>OptionSettings>member"`
	SolutionStackName aws.StringValue              `query:"SolutionStackName" xml:"CreateConfigurationTemplateResult>SolutionStackName"`
	TemplateName      aws.StringValue              `query:"TemplateName" xml:"CreateConfigurationTemplateResult>TemplateName"`
}

// CreateEnvironmentResult is a wrapper for EnvironmentDescription.
type CreateEnvironmentResult struct {
	ApplicationName   aws.StringValue                  `query:"ApplicationName" xml:"CreateEnvironmentResult>ApplicationName"`
	CNAME             aws.StringValue                  `query:"CNAME" xml:"CreateEnvironmentResult>CNAME"`
	DateCreated       time.Time                        `query:"DateCreated" xml:"CreateEnvironmentResult>DateCreated"`
	DateUpdated       time.Time                        `query:"DateUpdated" xml:"CreateEnvironmentResult>DateUpdated"`
	Description       aws.StringValue                  `query:"Description" xml:"CreateEnvironmentResult>Description"`
	EndpointURL       aws.StringValue                  `query:"EndpointURL" xml:"CreateEnvironmentResult>EndpointURL"`
	EnvironmentID     aws.StringValue                  `query:"EnvironmentId" xml:"CreateEnvironmentResult>EnvironmentId"`
	EnvironmentName   aws.StringValue                  `query:"EnvironmentName" xml:"CreateEnvironmentResult>EnvironmentName"`
	Health            aws.StringValue                  `query:"Health" xml:"CreateEnvironmentResult>Health"`
	Resources         *EnvironmentResourcesDescription `query:"Resources" xml:"CreateEnvironmentResult>Resources"`
	SolutionStackName aws.StringValue                  `query:"SolutionStackName" xml:"CreateEnvironmentResult>SolutionStackName"`
	Status            aws.StringValue                  `query:"Status" xml:"CreateEnvironmentResult>Status"`
	TemplateName      aws.StringValue                  `query:"TemplateName" xml:"CreateEnvironmentResult>TemplateName"`
	Tier              *EnvironmentTier                 `query:"Tier" xml:"CreateEnvironmentResult>Tier"`
	VersionLabel      aws.StringValue                  `query:"VersionLabel" xml:"CreateEnvironmentResult>VersionLabel"`
}

// CreateStorageLocationResult is a wrapper for CreateStorageLocationResultMessage.
type CreateStorageLocationResult struct {
	S3Bucket aws.StringValue `query:"S3Bucket" xml:"CreateStorageLocationResult>S3Bucket"`
}

// DescribeApplicationVersionsResult is a wrapper for ApplicationVersionDescriptionsMessage.
type DescribeApplicationVersionsResult struct {
	ApplicationVersions []ApplicationVersionDescription `query:"ApplicationVersions.member" xml:"DescribeApplicationVersionsResult>ApplicationVersions>member"`
}

// DescribeApplicationsResult is a wrapper for ApplicationDescriptionsMessage.
type DescribeApplicationsResult struct {
	Applications []ApplicationDescription `query:"Applications.member" xml:"DescribeApplicationsResult>Applications>member"`
}

// DescribeConfigurationOptionsResult is a wrapper for ConfigurationOptionsDescription.
type DescribeConfigurationOptionsResult struct {
	Options           []ConfigurationOptionDescription `query:"Options.member" xml:"DescribeConfigurationOptionsResult>Options>member"`
	SolutionStackName aws.StringValue                  `query:"SolutionStackName" xml:"DescribeConfigurationOptionsResult>SolutionStackName"`
}

// DescribeConfigurationSettingsResult is a wrapper for ConfigurationSettingsDescriptions.
type DescribeConfigurationSettingsResult struct {
	ConfigurationSettings []ConfigurationSettingsDescription `query:"ConfigurationSettings.member" xml:"DescribeConfigurationSettingsResult>ConfigurationSettings>member"`
}

// DescribeEnvironmentResourcesResult is a wrapper for EnvironmentResourceDescriptionsMessage.
type DescribeEnvironmentResourcesResult struct {
	EnvironmentResources *EnvironmentResourceDescription `query:"EnvironmentResources" xml:"DescribeEnvironmentResourcesResult>EnvironmentResources"`
}

// DescribeEnvironmentsResult is a wrapper for EnvironmentDescriptionsMessage.
type DescribeEnvironmentsResult struct {
	Environments []EnvironmentDescription `query:"Environments.member" xml:"DescribeEnvironmentsResult>Environments>member"`
}

// DescribeEventsResult is a wrapper for EventDescriptionsMessage.
type DescribeEventsResult struct {
	Events    []EventDescription `query:"Events.member" xml:"DescribeEventsResult>Events>member"`
	NextToken aws.StringValue    `query:"NextToken" xml:"DescribeEventsResult>NextToken"`
}

// ListAvailableSolutionStacksResult is a wrapper for ListAvailableSolutionStacksResultMessage.
type ListAvailableSolutionStacksResult struct {
	SolutionStackDetails []SolutionStackDescription `query:"SolutionStackDetails.member" xml:"ListAvailableSolutionStacksResult>SolutionStackDetails>member"`
	SolutionStacks       []string                   `query:"SolutionStacks.member" xml:"ListAvailableSolutionStacksResult>SolutionStacks>member"`
}

// RetrieveEnvironmentInfoResult is a wrapper for RetrieveEnvironmentInfoResultMessage.
type RetrieveEnvironmentInfoResult struct {
	EnvironmentInfo []EnvironmentInfoDescription `query:"EnvironmentInfo.member" xml:"RetrieveEnvironmentInfoResult>EnvironmentInfo>member"`
}

// TerminateEnvironmentResult is a wrapper for EnvironmentDescription.
type TerminateEnvironmentResult struct {
	ApplicationName   aws.StringValue                  `query:"ApplicationName" xml:"TerminateEnvironmentResult>ApplicationName"`
	CNAME             aws.StringValue                  `query:"CNAME" xml:"TerminateEnvironmentResult>CNAME"`
	DateCreated       time.Time                        `query:"DateCreated" xml:"TerminateEnvironmentResult>DateCreated"`
	DateUpdated       time.Time                        `query:"DateUpdated" xml:"TerminateEnvironmentResult>DateUpdated"`
	Description       aws.StringValue                  `query:"Description" xml:"TerminateEnvironmentResult>Description"`
	EndpointURL       aws.StringValue                  `query:"EndpointURL" xml:"TerminateEnvironmentResult>EndpointURL"`
	EnvironmentID     aws.StringValue                  `query:"EnvironmentId" xml:"TerminateEnvironmentResult>EnvironmentId"`
	EnvironmentName   aws.StringValue                  `query:"EnvironmentName" xml:"TerminateEnvironmentResult>EnvironmentName"`
	Health            aws.StringValue                  `query:"Health" xml:"TerminateEnvironmentResult>Health"`
	Resources         *EnvironmentResourcesDescription `query:"Resources" xml:"TerminateEnvironmentResult>Resources"`
	SolutionStackName aws.StringValue                  `query:"SolutionStackName" xml:"TerminateEnvironmentResult>SolutionStackName"`
	Status            aws.StringValue                  `query:"Status" xml:"TerminateEnvironmentResult>Status"`
	TemplateName      aws.StringValue                  `query:"TemplateName" xml:"TerminateEnvironmentResult>TemplateName"`
	Tier              *EnvironmentTier                 `query:"Tier" xml:"TerminateEnvironmentResult>Tier"`
	VersionLabel      aws.StringValue                  `query:"VersionLabel" xml:"TerminateEnvironmentResult>VersionLabel"`
}

// UpdateApplicationResult is a wrapper for ApplicationDescriptionMessage.
type UpdateApplicationResult struct {
	Application *ApplicationDescription `query:"Application" xml:"UpdateApplicationResult>Application"`
}

// UpdateApplicationVersionResult is a wrapper for ApplicationVersionDescriptionMessage.
type UpdateApplicationVersionResult struct {
	ApplicationVersion *ApplicationVersionDescription `query:"ApplicationVersion" xml:"UpdateApplicationVersionResult>ApplicationVersion"`
}

// UpdateConfigurationTemplateResult is a wrapper for ConfigurationSettingsDescription.
type UpdateConfigurationTemplateResult struct {
	ApplicationName   aws.StringValue              `query:"ApplicationName" xml:"UpdateConfigurationTemplateResult>ApplicationName"`
	DateCreated       time.Time                    `query:"DateCreated" xml:"UpdateConfigurationTemplateResult>DateCreated"`
	DateUpdated       time.Time                    `query:"DateUpdated" xml:"UpdateConfigurationTemplateResult>DateUpdated"`
	DeploymentStatus  aws.StringValue              `query:"DeploymentStatus" xml:"UpdateConfigurationTemplateResult>DeploymentStatus"`
	Description       aws.StringValue              `query:"Description" xml:"UpdateConfigurationTemplateResult>Description"`
	EnvironmentName   aws.StringValue              `query:"EnvironmentName" xml:"UpdateConfigurationTemplateResult>EnvironmentName"`
	OptionSettings    []ConfigurationOptionSetting `query:"OptionSettings.member" xml:"UpdateConfigurationTemplateResult>OptionSettings>member"`
	SolutionStackName aws.StringValue              `query:"SolutionStackName" xml:"UpdateConfigurationTemplateResult>SolutionStackName"`
	TemplateName      aws.StringValue              `query:"TemplateName" xml:"UpdateConfigurationTemplateResult>TemplateName"`
}

// UpdateEnvironmentResult is a wrapper for EnvironmentDescription.
type UpdateEnvironmentResult struct {
	ApplicationName   aws.StringValue                  `query:"ApplicationName" xml:"UpdateEnvironmentResult>ApplicationName"`
	CNAME             aws.StringValue                  `query:"CNAME" xml:"UpdateEnvironmentResult>CNAME"`
	DateCreated       time.Time                        `query:"DateCreated" xml:"UpdateEnvironmentResult>DateCreated"`
	DateUpdated       time.Time                        `query:"DateUpdated" xml:"UpdateEnvironmentResult>DateUpdated"`
	Description       aws.StringValue                  `query:"Description" xml:"UpdateEnvironmentResult>Description"`
	EndpointURL       aws.StringValue                  `query:"EndpointURL" xml:"UpdateEnvironmentResult>EndpointURL"`
	EnvironmentID     aws.StringValue                  `query:"EnvironmentId" xml:"UpdateEnvironmentResult>EnvironmentId"`
	EnvironmentName   aws.StringValue                  `query:"EnvironmentName" xml:"UpdateEnvironmentResult>EnvironmentName"`
	Health            aws.StringValue                  `query:"Health" xml:"UpdateEnvironmentResult>Health"`
	Resources         *EnvironmentResourcesDescription `query:"Resources" xml:"UpdateEnvironmentResult>Resources"`
	SolutionStackName aws.StringValue                  `query:"SolutionStackName" xml:"UpdateEnvironmentResult>SolutionStackName"`
	Status            aws.StringValue                  `query:"Status" xml:"UpdateEnvironmentResult>Status"`
	TemplateName      aws.StringValue                  `query:"TemplateName" xml:"UpdateEnvironmentResult>TemplateName"`
	Tier              *EnvironmentTier                 `query:"Tier" xml:"UpdateEnvironmentResult>Tier"`
	VersionLabel      aws.StringValue                  `query:"VersionLabel" xml:"UpdateEnvironmentResult>VersionLabel"`
}

// ValidateConfigurationSettingsResult is a wrapper for ConfigurationSettingsValidationMessages.
type ValidateConfigurationSettingsResult struct {
	Messages []ValidationMessage `query:"Messages.member" xml:"ValidateConfigurationSettingsResult>Messages>member"`
}

// avoid errors if the packages aren't referenced
var _ time.Time

var _ xml.Decoder
var _ = io.EOF
