// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package logs provides a client for Amazon CloudWatch Logs.
package logs

import (
	"net/http"
	"time"

	"github.com/awslabs/aws-sdk-go/aws"
	"github.com/awslabs/aws-sdk-go/gen/endpoints"
)

// Logs is a client for Amazon CloudWatch Logs.
type Logs struct {
	client *aws.JSONClient
}

// New returns a new Logs client.
func New(creds aws.CredentialsProvider, region string, client *http.Client) *Logs {
	if client == nil {
		client = http.DefaultClient
	}

	endpoint, service, region := endpoints.Lookup("logs", region)

	return &Logs{
		client: &aws.JSONClient{
			Context: aws.Context{
				Credentials: creds,
				Service:     service,
				Region:      region,
			}, Client: client,
			Endpoint:     endpoint,
			JSONVersion:  "1.1",
			TargetPrefix: "Logs_20140328",
		},
	}
}

// CreateLogGroup creates a new log group with the specified name. The name
// of the log group must be unique within a region for an AWS account. You
// can create up to 500 log groups per account. You must use the following
// guidelines when naming a log group: Log group names can be between 1 and
// 512 characters long. Allowed characters are a-z, 0-9, '_' (underscore),
// '-' (hyphen), '/' (forward slash), and '.' (period).
func (c *Logs) CreateLogGroup(req *CreateLogGroupRequest) (err error) {
	// NRE
	err = c.client.Do("CreateLogGroup", "POST", "/", req, nil)
	return
}

// CreateLogStream creates a new log stream in the specified log group. The
// name of the log stream must be unique within the log group. There is no
// limit on the number of log streams that can exist in a log group. You
// must use the following guidelines when naming a log stream: Log stream
// names can be between 1 and 512 characters long. The ':' colon character
// is not allowed.
func (c *Logs) CreateLogStream(req *CreateLogStreamRequest) (err error) {
	// NRE
	err = c.client.Do("CreateLogStream", "POST", "/", req, nil)
	return
}

// DeleteLogGroup deletes the log group with the specified name and
// permanently deletes all the archived log events associated with it.
func (c *Logs) DeleteLogGroup(req *DeleteLogGroupRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteLogGroup", "POST", "/", req, nil)
	return
}

// DeleteLogStream deletes a log stream and permanently deletes all the
// archived log events associated with it.
func (c *Logs) DeleteLogStream(req *DeleteLogStreamRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteLogStream", "POST", "/", req, nil)
	return
}

// DeleteMetricFilter deletes a metric filter associated with the specified
// log group.
func (c *Logs) DeleteMetricFilter(req *DeleteMetricFilterRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteMetricFilter", "POST", "/", req, nil)
	return
}

// DeleteRetentionPolicy deletes the retention policy of the specified log
// group. Log events would not expire if they belong to log groups without
// a retention policy.
func (c *Logs) DeleteRetentionPolicy(req *DeleteRetentionPolicyRequest) (err error) {
	// NRE
	err = c.client.Do("DeleteRetentionPolicy", "POST", "/", req, nil)
	return
}

// DescribeLogGroups returns all the log groups that are associated with
// the AWS account making the request. The list returned in the response is
// ASCII-sorted by log group name. By default, this operation returns up to
// 50 log groups. If there are more log groups to list, the response would
// contain a nextToken value in the response body. You can also limit the
// number of log groups returned in the response by specifying the limit
// parameter in the request.
func (c *Logs) DescribeLogGroups(req *DescribeLogGroupsRequest) (resp *DescribeLogGroupsResponse, err error) {
	resp = &DescribeLogGroupsResponse{}
	err = c.client.Do("DescribeLogGroups", "POST", "/", req, resp)
	return
}

// DescribeLogStreams returns all the log streams that are associated with
// the specified log group. The list returned in the response is
// ASCII-sorted by log stream name. By default, this operation returns up
// to 50 log streams. If there are more log streams to list, the response
// would contain a nextToken value in the response body. You can also limit
// the number of log streams returned in the response by specifying the
// limit parameter in the request.
func (c *Logs) DescribeLogStreams(req *DescribeLogStreamsRequest) (resp *DescribeLogStreamsResponse, err error) {
	resp = &DescribeLogStreamsResponse{}
	err = c.client.Do("DescribeLogStreams", "POST", "/", req, resp)
	return
}

// DescribeMetricFilters returns all the metrics filters associated with
// the specified log group. The list returned in the response is
// ASCII-sorted by filter name. By default, this operation returns up to 50
// metric filters. If there are more metric filters to list, the response
// would contain a nextToken value in the response body. You can also limit
// the number of metric filters returned in the response by specifying the
// limit parameter in the request.
func (c *Logs) DescribeMetricFilters(req *DescribeMetricFiltersRequest) (resp *DescribeMetricFiltersResponse, err error) {
	resp = &DescribeMetricFiltersResponse{}
	err = c.client.Do("DescribeMetricFilters", "POST", "/", req, resp)
	return
}

// GetLogEvents retrieves log events from the specified log stream. You can
// provide an optional time range to filter the results on the event
// timestamp . By default, this operation returns as much log events as can
// fit in a response size of 1MB, up to 10,000 log events. The response
// will always include a nextForwardToken and a nextBackwardToken in the
// response body. You can use any of these tokens in subsequent
// GetLogEvents requests to paginate through events in either forward or
// backward direction. You can also limit the number of log events returned
// in the response by specifying the limit parameter in the request.
func (c *Logs) GetLogEvents(req *GetLogEventsRequest) (resp *GetLogEventsResponse, err error) {
	resp = &GetLogEventsResponse{}
	err = c.client.Do("GetLogEvents", "POST", "/", req, resp)
	return
}

// PutLogEvents uploads a batch of log events to the specified log stream.
// Every PutLogEvents request must include the sequenceToken obtained from
// the response of the previous request. An upload in a newly created log
// stream does not require a sequenceToken . The batch of events must
// satisfy the following constraints: The maximum batch size is 32,768
// bytes, and this size is calculated as the sum of all event messages in
// UTF-8, plus 26 bytes for each log event. None of the log events in the
// batch can be more than 2 hours in the future. None of the log events in
// the batch can be older than 14 days or the retention period of the log
// group. The log events in the batch must be in chronological ordered by
// their timestamp The maximum number of log events in a batch is 1,000.
func (c *Logs) PutLogEvents(req *PutLogEventsRequest) (resp *PutLogEventsResponse, err error) {
	resp = &PutLogEventsResponse{}
	err = c.client.Do("PutLogEvents", "POST", "/", req, resp)
	return
}

// PutMetricFilter creates or updates a metric filter and associates it
// with the specified log group. Metric filters allow you to configure
// rules to extract metric data from log events ingested through
// PutLogEvents requests.
func (c *Logs) PutMetricFilter(req *PutMetricFilterRequest) (err error) {
	// NRE
	err = c.client.Do("PutMetricFilter", "POST", "/", req, nil)
	return
}

// PutRetentionPolicy sets the retention of the specified log group. A
// retention policy allows you to configure the number of days you want to
// retain log events in the specified log group.
func (c *Logs) PutRetentionPolicy(req *PutRetentionPolicyRequest) (err error) {
	// NRE
	err = c.client.Do("PutRetentionPolicy", "POST", "/", req, nil)
	return
}

// TestMetricFilter tests the filter pattern of a metric filter against a
// sample of log event messages. You can use this operation to validate the
// correctness of a metric filter pattern.
func (c *Logs) TestMetricFilter(req *TestMetricFilterRequest) (resp *TestMetricFilterResponse, err error) {
	resp = &TestMetricFilterResponse{}
	err = c.client.Do("TestMetricFilter", "POST", "/", req, resp)
	return
}

// CreateLogGroupRequest is undocumented.
type CreateLogGroupRequest struct {
	LogGroupName aws.StringValue `json:"logGroupName"`
}

// CreateLogStreamRequest is undocumented.
type CreateLogStreamRequest struct {
	LogGroupName  aws.StringValue `json:"logGroupName"`
	LogStreamName aws.StringValue `json:"logStreamName"`
}

// DeleteLogGroupRequest is undocumented.
type DeleteLogGroupRequest struct {
	LogGroupName aws.StringValue `json:"logGroupName"`
}

// DeleteLogStreamRequest is undocumented.
type DeleteLogStreamRequest struct {
	LogGroupName  aws.StringValue `json:"logGroupName"`
	LogStreamName aws.StringValue `json:"logStreamName"`
}

// DeleteMetricFilterRequest is undocumented.
type DeleteMetricFilterRequest struct {
	FilterName   aws.StringValue `json:"filterName"`
	LogGroupName aws.StringValue `json:"logGroupName"`
}

// DeleteRetentionPolicyRequest is undocumented.
type DeleteRetentionPolicyRequest struct {
	LogGroupName aws.StringValue `json:"logGroupName"`
}

// DescribeLogGroupsRequest is undocumented.
type DescribeLogGroupsRequest struct {
	Limit              aws.IntegerValue `json:"limit,omitempty"`
	LogGroupNamePrefix aws.StringValue  `json:"logGroupNamePrefix,omitempty"`
	NextToken          aws.StringValue  `json:"nextToken,omitempty"`
}

// DescribeLogGroupsResponse is undocumented.
type DescribeLogGroupsResponse struct {
	LogGroups []LogGroup      `json:"logGroups,omitempty"`
	NextToken aws.StringValue `json:"nextToken,omitempty"`
}

// DescribeLogStreamsRequest is undocumented.
type DescribeLogStreamsRequest struct {
	Limit               aws.IntegerValue `json:"limit,omitempty"`
	LogGroupName        aws.StringValue  `json:"logGroupName"`
	LogStreamNamePrefix aws.StringValue  `json:"logStreamNamePrefix,omitempty"`
	NextToken           aws.StringValue  `json:"nextToken,omitempty"`
}

// DescribeLogStreamsResponse is undocumented.
type DescribeLogStreamsResponse struct {
	LogStreams []LogStream     `json:"logStreams,omitempty"`
	NextToken  aws.StringValue `json:"nextToken,omitempty"`
}

// DescribeMetricFiltersRequest is undocumented.
type DescribeMetricFiltersRequest struct {
	FilterNamePrefix aws.StringValue  `json:"filterNamePrefix,omitempty"`
	Limit            aws.IntegerValue `json:"limit,omitempty"`
	LogGroupName     aws.StringValue  `json:"logGroupName"`
	NextToken        aws.StringValue  `json:"nextToken,omitempty"`
}

// DescribeMetricFiltersResponse is undocumented.
type DescribeMetricFiltersResponse struct {
	MetricFilters []MetricFilter  `json:"metricFilters,omitempty"`
	NextToken     aws.StringValue `json:"nextToken,omitempty"`
}

// GetLogEventsRequest is undocumented.
type GetLogEventsRequest struct {
	EndTime       aws.LongValue    `json:"endTime,omitempty"`
	Limit         aws.IntegerValue `json:"limit,omitempty"`
	LogGroupName  aws.StringValue  `json:"logGroupName"`
	LogStreamName aws.StringValue  `json:"logStreamName"`
	NextToken     aws.StringValue  `json:"nextToken,omitempty"`
	StartFromHead aws.BooleanValue `json:"startFromHead,omitempty"`
	StartTime     aws.LongValue    `json:"startTime,omitempty"`
}

// GetLogEventsResponse is undocumented.
type GetLogEventsResponse struct {
	Events            []OutputLogEvent `json:"events,omitempty"`
	NextBackwardToken aws.StringValue  `json:"nextBackwardToken,omitempty"`
	NextForwardToken  aws.StringValue  `json:"nextForwardToken,omitempty"`
}

// InputLogEvent is undocumented.
type InputLogEvent struct {
	Message   aws.StringValue `json:"message"`
	Timestamp aws.LongValue   `json:"timestamp"`
}

// LogGroup is undocumented.
type LogGroup struct {
	ARN               aws.StringValue  `json:"arn,omitempty"`
	CreationTime      aws.LongValue    `json:"creationTime,omitempty"`
	LogGroupName      aws.StringValue  `json:"logGroupName,omitempty"`
	MetricFilterCount aws.IntegerValue `json:"metricFilterCount,omitempty"`
	RetentionInDays   aws.IntegerValue `json:"retentionInDays,omitempty"`
	StoredBytes       aws.LongValue    `json:"storedBytes,omitempty"`
}

// LogStream is undocumented.
type LogStream struct {
	ARN                 aws.StringValue `json:"arn,omitempty"`
	CreationTime        aws.LongValue   `json:"creationTime,omitempty"`
	FirstEventTimestamp aws.LongValue   `json:"firstEventTimestamp,omitempty"`
	LastEventTimestamp  aws.LongValue   `json:"lastEventTimestamp,omitempty"`
	LastIngestionTime   aws.LongValue   `json:"lastIngestionTime,omitempty"`
	LogStreamName       aws.StringValue `json:"logStreamName,omitempty"`
	StoredBytes         aws.LongValue   `json:"storedBytes,omitempty"`
	UploadSequenceToken aws.StringValue `json:"uploadSequenceToken,omitempty"`
}

// MetricFilter is undocumented.
type MetricFilter struct {
	CreationTime          aws.LongValue          `json:"creationTime,omitempty"`
	FilterName            aws.StringValue        `json:"filterName,omitempty"`
	FilterPattern         aws.StringValue        `json:"filterPattern,omitempty"`
	MetricTransformations []MetricTransformation `json:"metricTransformations,omitempty"`
}

// MetricFilterMatchRecord is undocumented.
type MetricFilterMatchRecord struct {
	EventMessage    aws.StringValue   `json:"eventMessage,omitempty"`
	EventNumber     aws.LongValue     `json:"eventNumber,omitempty"`
	ExtractedValues map[string]string `json:"extractedValues,omitempty"`
}

// MetricTransformation is undocumented.
type MetricTransformation struct {
	MetricName      aws.StringValue `json:"metricName"`
	MetricNamespace aws.StringValue `json:"metricNamespace"`
	MetricValue     aws.StringValue `json:"metricValue"`
}

// OutputLogEvent is undocumented.
type OutputLogEvent struct {
	IngestionTime aws.LongValue   `json:"ingestionTime,omitempty"`
	Message       aws.StringValue `json:"message,omitempty"`
	Timestamp     aws.LongValue   `json:"timestamp,omitempty"`
}

// PutLogEventsRequest is undocumented.
type PutLogEventsRequest struct {
	LogEvents     []InputLogEvent `json:"logEvents"`
	LogGroupName  aws.StringValue `json:"logGroupName"`
	LogStreamName aws.StringValue `json:"logStreamName"`
	SequenceToken aws.StringValue `json:"sequenceToken,omitempty"`
}

// PutLogEventsResponse is undocumented.
type PutLogEventsResponse struct {
	NextSequenceToken aws.StringValue `json:"nextSequenceToken,omitempty"`
}

// PutMetricFilterRequest is undocumented.
type PutMetricFilterRequest struct {
	FilterName            aws.StringValue        `json:"filterName"`
	FilterPattern         aws.StringValue        `json:"filterPattern"`
	LogGroupName          aws.StringValue        `json:"logGroupName"`
	MetricTransformations []MetricTransformation `json:"metricTransformations"`
}

// PutRetentionPolicyRequest is undocumented.
type PutRetentionPolicyRequest struct {
	LogGroupName    aws.StringValue  `json:"logGroupName"`
	RetentionInDays aws.IntegerValue `json:"retentionInDays"`
}

// TestMetricFilterRequest is undocumented.
type TestMetricFilterRequest struct {
	FilterPattern    aws.StringValue `json:"filterPattern"`
	LogEventMessages []string        `json:"logEventMessages"`
}

// TestMetricFilterResponse is undocumented.
type TestMetricFilterResponse struct {
	Matches []MetricFilterMatchRecord `json:"matches,omitempty"`
}

// avoid errors if the packages aren't referenced
var _ time.Time
